﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Zadania" %>
<%@ import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Kampania</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat=server>
            public enum analizaWg
            {
                [Caption("Wartości przychodu")]
                wgPrzychodu = 1,
                [Caption("Liczby projektów")]
                wgLiczby = 2
            };

            public class Params : ContextBase
            {
                public Params(Context cx)
                    : base(cx) { }
                analizaWg analizaWedlug = analizaWg.wgPrzychodu;

                [Caption("Analiza według")]
                [Soneta.Types.DefaultWidth(20)]
                public analizaWg AnalizaWedlug
                {
                    get { return analizaWedlug; }
                    set { analizaWedlug = value; }
                }
            }

            Params param = null;
            [Context]
            public Params Param
            {
                get { return param; }
                set { param = value; }
            }


            class MaxVal
            {
                Currency maxCurr = 0;
                int maxInt = 0;
                public MaxVal() { }

                public Currency MaxCurr
                {
                    get { return maxCurr; }
                    set { maxCurr = value; }
                }
                public int MaxInt
                {
                    get { return maxInt; }
                    set { maxInt = value; }
                }
                
            }    
		    class Realizacja : IComparable
            {
                EtapProjektu etap;
                Currency wartosc = 0;
                int iloscProjektow = 0;
                public Realizacja(Projekt p)
                {
                    
                    etap = p.Etap;
                    wartosc += p.Przychod;
                    iloscProjektow++;
                }
                public void DodajWartosc(Projekt p)
                {
                    wartosc += p.Przychod;
                    iloscProjektow++;
                }
                public EtapProjektu Etap
                {
                    get { return etap; }
                }
                public Currency Wartosc
                {
                    get { return wartosc; }
                }
                public int IloscProjektow
                {
                    get { return iloscProjektow; }
                }
                public int CompareTo(object obj)
                {
                    Realizacja r = (Realizacja)obj;
                    decimal real_int = (decimal)etap.Realizacja;
                    decimal real_out = (decimal)r.Etap.Realizacja;
                    return real_int.CompareTo(real_out);
                }                
            }    
            class Realizacje
            {
                ArrayList lista = new ArrayList();
                Hashtable hashlista = new Hashtable();
                public Realizacje()
                {
                   
                }
                public void DodajProjekt(Projekt p)
                {
                    Realizacja realizacja = null;
                    foreach (Realizacja r in lista)
                    {
                        if (r.Etap.Realizacja <= p.Etap.Realizacja)
                            r.DodajWartosc(p);
                        if (p.Etap.Nazwa == r.Etap.Nazwa && p.Etap.Realizacja == r.Etap.Realizacja)
                            realizacja = r;
                    }
                    if (realizacja == null)
                    {
                        lista.Add(new Realizacja(p));
                    }
                }
                public ArrayList Lista
                {
                    get { return lista; }
                }
                public MaxVal MaxWartosc
                {
                    get
                    {
                        MaxVal maxwartosc = new MaxVal();
                        foreach (Realizacja r in lista)
                        {
                            if (r.Wartosc.Value > maxwartosc.MaxCurr)
                                maxwartosc.MaxCurr = r.Wartosc.Value;
                            if (r.IloscProjektow > maxwartosc.MaxInt)
                                maxwartosc.MaxInt = r.IloscProjektow;
                        }

                        return maxwartosc;
                    }
                }
            }
            void Msg(object o)
            {
            }
		            
            void OnContextLoad(Object sender, EventArgs args)
            {
                if (dc.Context.Contains(typeof(Kampania)))
                {
                    Kampania kampania = (Kampania)dc[typeof(Kampania)];
                    Realizacje realizacje = new Realizacje();
                    Soneta.Business.View projekty = kampania.Projekty.CreateView();
                    projekty.Sort = "Etap.Realizacja";
                    foreach (Projekt p in projekty)
                    {
                        realizacje.DodajProjekt(p);
                    }
                    decimal maxwartosc = Param.AnalizaWedlug == analizaWg.wgPrzychodu ? realizacje.MaxWartosc.MaxCurr.Value : (decimal)realizacje.MaxWartosc.MaxInt;
                    ArrayList lista = realizacje.Lista;
                    lista.Sort();
                    string tabela = "";
                    foreach (Realizacja r in lista)
                    {
                        decimal wartosc = Param.AnalizaWedlug == analizaWg.wgPrzychodu ? r.Wartosc.Value : (decimal) r.IloscProjektow;
                        decimal wspolczynnik = wartosc / (maxwartosc != 0 ? maxwartosc : (wartosc != 0 ? wartosc : 1));
                        int skutecznosc = (int)(100 * wspolczynnik);
                        int kolor     = (int)(255 * wspolczynnik);
                        
                        string styl = "\"font-size: 8pt; width: " + skutecznosc.ToString() + "%;background-color:#ff" + String.Format("{0:x}", kolor) + "00\"";
                        tabela += "<table border=1 cellspacing=0 cellpadding=0 style=" + styl + ">"
                            + "<tr><td align=\"center\" >"
                            + r.Etap.Nazwa + " (" + r.Etap.Realizacja.ToString() + ")<br/>" 
                            + "Skuteczność: " +  skutecznosc + "%<br/>"
                            + "Planowany przychód: " + r.Wartosc.ToString() + "<br/>"
                            + "Liczba projektów: " + r.IloscProjektow.ToString()
                            + "</td></tr></table>";

                    }
                    labelLejek.EditValue = tabela;
                }
            }    
		</script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server" ID="form">
			<ea:DataContext id="dc" runat="server" TypeName="Soneta.Zadania.Kampania,Soneta.Zadania" style="top: 0px" OnContextLoad="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Skuteczność kampanii|{0}" DataMember0="."></eb:ReportHeader>


<div style='FONT-SIZE: 8pt; WIDTH: 100%; FONT-FAMILY: Verdana; '>
    <table id="tabOgolne" border=0 cellspacing=0 cellpadding=0 style="font-size: 8pt; width: 100%;">
        <tr>
            <td>
                Numer:&nbsp;<ea:DataLabel runat="server" ID="label2" DataMember="Numer"></ea:datalabel><br />
                Osoba prowadząca:&nbsp;<ea:DataLabel runat="server" ID="label3" DataMember="Prowadzacy"></ea:datalabel>
            </td>
            <td>
                Data rozpoczęcia:&nbsp;<ea:DataLabel runat="server" ID="label5" DataMember="DataOd"></ea:datalabel><br />
                Data zakończenia:&nbsp;<ea:DataLabel runat="server" ID="label6" DataMember="DataDo"></ea:datalabel>
            </td>        
        </tr>
    </table>
    <br>
    Opis:<br>
    <ea:DataLabel runat="server" ID="label8" DataMember="Opis"></ea:datalabel>
    <br />
    <br />
    Cel:<br>
    <ea:DataLabel runat="server" ID="label9" DataMember="Cel"></ea:datalabel><br>
    <p style="text-align:center" >
        <ea:DataLabel ID="labelLejek" runat="server"></ea:DataLabel>
    </p>
   
</div>

<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

