﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="65001" %>
<%@ import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.Xml" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>PIT-11 (24)</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
            public class SrParams : SerializableContextBase {
                public SrParams(Context context) : base(context) {
                }

                bool strony = true;
                [Caption("4 strony")]
                public bool Strony {
                    get { return strony; }
                    set {
                        strony = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            SrParams srpars;
            [SettingsContext]
            public SrParams SrPars {
                get { return srpars; }
                set { srpars = value; }
            }

            public class Params : ContextBase {
                public Params(Context context) : base(context) {
                }

                bool ord = false;
                [Caption("Drukować ORD-ZU")]
                public bool Ord {
                    get { return ord; }
                    set {
                        ord = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                bool upo = false;
                [Caption("Drukować UPO")]
                public bool Upo {
                    get { return upo; }
                    set {
                        upo = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            Params pars;
            [Context]
            public Params Pars {
                get { return pars; }
                set { pars = value; }
            }
            
            void OnContextLoad(object sender, EventArgs e) {
                PIT pit = (PIT)dc[typeof(PIT)];
                if (pit as PIT11_24 == null)
                    throw new InvalidOperationException("Wydruk PIT-11 (24) może być drukowany wyłącznie dla deklaracji PIT-11 w wersji 24.");
                PIT11_24 pit11 = (PIT11_24)pit;
                string pesel = (string)pit.Bloki["0"]["PESEL"];
                if (!string.IsNullOrEmpty(pesel)) {
                    FrameNIPPlatnika.Text = "<b>1. <strike>Identyfikator podatkowy NIP<.Indexup>1)<./></strike> / numer PESEL <.Indexup>(niepotrzebne skreślić)<./>składającego</b>";
                    FrameNIPPlatnika.ValueStyle = ValueStyles.WideText;
                    FrameNIPPlatnika.DataMember = "0.PESEL";
                }
                else {
                    FrameNIPPlatnika.Text = "<b>1. Identyfikator podatkowy NIP<.Indexup>1)<./> / <strike>numer PESEL</strike><.Indexup>(niepotrzebne skreślić)<./> składającego</b>";
                    FrameNIPPlatnika.DataMember = "0.Nip";
                }
                if (!pit.Module.Config.PIT.Ogólne.DanePodatnikaWStopce)
                    flDanePodatnika1.Text = flDanePodatnika2.Text = "";
                else {
                    flDanePodatnika1.Text = flDanePodatnika2.Text = string.Format("{0}, {1}: {2}",
                        pit11.Podmiot.ToString(),
                        pit11.JestPESEL ? "PESEL" : "NIP",
                        pit11.IdentyfikatorPodatnika);
                }
                if (pit11.JestPESEL) {
                    flPeselNip.Text = "<strike>Identyfikator podatkowy NIP</strike>/Numer PESEL <.Indexup>(niepotrzebne skreślić)";
                    flPeselNip.ValueStyle = ValueStyles.WideText;
                }
                else {
                    flPeselNip.Text = "Identyfikator podatkowy NIP/<strike>Numer PESEL</strike> <.Indexup>(niepotrzebne skreślić)";
                    flPeselNip.ValueStyle = ValueStyles.nip_w;
                }

                string podpis1 = ""; //(string)pit11.Bloki["H"]["Podpis"];
                if (string.IsNullOrEmpty(podpis1))
                    podpis1 = (string)pit11.Bloki["H"]["Imię"] + " " + (string)pit11.Bloki["H"]["Nazwisko"];
                podpis1 += "<br/>" + pit11.Bloki["H"]["Stanowisko"];
                flPodpis1.EditValue = podpis1;

                string podpis2 = ""; //(string)pit11.Bloki["I"]["Podpis"];
                if (string.IsNullOrEmpty(podpis2))
                    podpis2 = (string)pit11.Bloki["I"]["Imię"] + " " + (string)pit11.Bloki["I"]["Nazwisko"];
                podpis2 += "<br/>" + pit11.Bloki["I"]["Stanowisko"];
                flPodpis2.EditValue = podpis2;

                Strony.Visible = srpars.Strony;

                string rodzaj = (string)pit11.Bloki["C1"]["RodzajDok"];
                if (rodzaj.Contains("/")) rodzaj = rodzaj.Substring(0, rodzaj.IndexOf("/"));
                Framelabel12.EditValue = rodzaj;

                if (pars.Ord) {
                    Soneta.Deklaracje.PIT.ITreśćUzasadnieniaKorekty3 dek = (Soneta.Deklaracje.PIT.ITreśćUzasadnieniaKorekty3)dc[typeof(Soneta.Deklaracje.PIT.ITreśćUzasadnieniaKorekty3)];
                    if (dek.Visible)
                        dc.FollowingReports.Add(new FollowingReport("deklaracje/ord_zu_3_2.aspx"));
                }
                
                if (!dc.OverPrint) {
                    if (pars.Upo) {
                        string upo = (pit.Deklaracja ?? pit).GetNumerUpo();
                        if (upo != "") {
                            Resize(FrameNIPPlatnika, -64, 0);
                            Move(FrameNrDokumentu, 0, -64);
                            Resize(FrameNrDokumentu, 64, 0);
                            FrameNrDokumentu.EditValue = upo;
                        }
                    }
                }
            }

            void Resize(WebControl fl, int dwidth, int dheight) {
                if (dwidth != 0)
                    fl.Style["width"] = (ParsePx(fl.Style["width"]) + dwidth) + "px";
                if (dheight != 0)
                    fl.Style["height"] = (ParsePx(fl.Style["height"]) + dheight) + "px";
            }
                        
            void Move(WebControl fl, int dtop, int dleft) {
                if (dtop != 0)
                    fl.Style["TOP"] = (ParsePx(fl.Style["TOP"]) + dtop) + "px";
                if (dleft != 0)
                    fl.Style["LEFT"] = (ParsePx(fl.Style["LEFT"]) + dleft) + "px";
            }
            
            int ParsePx(string px) {
                return int.Parse(px.Substring(0, px.Length - 2));
            }
</script>
	</HEAD>
	<body leftMargin="0" rightMargin="0">
		<form id="PIT_11_24" method="post" runat="server">
			<ea:deklaracjaheader id="DeklaracjaHeader1" style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 0px"
				runat="server" Width="630px" StylNagłówka="WylacznieDużymiDrukowanymi"></ea:deklaracjaheader>
<ea:framelabel id="FrameNIPPlatnika" style="Z-INDEX: 101; LEFT: 0px; POSITION: absolute; TOP: 21px; width: 338px;"
				runat="server" ValueStyle="nip_w" Height="28px"></ea:framelabel>
<ea:framelabel id="FrameNrDokumentu" style="Z-INDEX: 102; LEFT: 337px; POSITION: absolute; TOP: 21px; width: 193px;"
				runat="server" Height="28px" Text="Nr dokumentu" FrameStyle="SmallBoldGray" Number="2"></ea:framelabel>
<ea:framelabel id="FrameLabel23" style="Z-INDEX: 103; LEFT: 531px; POSITION: absolute; TOP: 21px; width: 97px;"
				runat="server" Height="30px" Text="Status" FrameStyle="SmallBoldGray" Number="3"></ea:framelabel>
<ea:framelabel id="labelPIT" style="Z-INDEX: 104; LEFT: 0px; POSITION: absolute; TOP: 49px" runat="server"
				Width="119px" Height="21px" FrameStyle="BigBold" FrameBorderStyle="None" Text="PIT-11"></ea:framelabel>
<ea:framelabel id="FrameLabel158" style="Z-INDEX: 105; LEFT: 60px; POSITION: absolute; TOP: 63px"
				runat="server" Width="525px" Height="35px" 
                Text="INFORMACJA O PRZYCHODACH Z INNYCH ŹRÓDEŁ ORAZ O DOCHODACH  I POBRANYCH ZALICZKACH NA PODATEK DOCHODOWY" 
                FrameStyle="BigBold" FrameBorderStyle="None" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel19" style="Z-INDEX: 106; LEFT: 259px; POSITION: absolute; TOP: 101px; width: 115px;"
				runat="server" ValueStyle="n4" DataMember="0.Rok" Height="28px" Text="4. Rok"></ea:framelabel>
<ea:framelabel id="FrameLabel29" style="Z-INDEX: 108; LEFT: 170px; POSITION: absolute; TOP: 108px"
				runat="server" Width="70px" Height="17px" Text="W ROKU" FrameStyle="BigBold" 
                FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel24" style="Z-INDEX: 109; LEFT: 0px; POSITION: absolute; TOP: 131px"
				runat="server" Width="630px" Height="116px" FrameStyle="SmallBoldYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel25" style="Z-INDEX: 110; LEFT: 1px; POSITION: absolute; TOP: 133px"
				runat="server" Width="89px" Height="7px" Text="Podstawa prawna:" FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel26" style="Z-INDEX: 111; LEFT: 76px; POSITION: absolute; TOP: 133px"
				runat="server" Width="555px" Height="28px" Text='Art.35 ust.10, art.39 ust.1, art.42 ust.2 pkt 1, art.42a ust.1, art.42e ust.6 ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych (Dz. U. z 2018 r. poz. 1509, z późn. zm.), zwanej dalej „ustawą”; art. 35a ust. 5 ustawy, w brzmieniu obowiązującym przed dniem 26 października 2007 r<.INDEXUP>2)<./>.' FrameStyle="SmallYellow"
				FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel27" style="Z-INDEX: 112; LEFT: 1px; POSITION: absolute; TOP: 151px"
				runat="server" Width="91px" Height="7px" Text="Składający:" FrameStyle="SmallYellow" 
                FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel28" style="Z-INDEX: 113; LEFT: 76px; POSITION: absolute; TOP: 151px"
				runat="server" Width="555px" Height="28px" 
                Text="Płatnicy podatku dochodowego od osób fizycznych, a także niebędący płatnikami: rolnicy, osoby fizyczne prowadzące działalność gospodarczą, osoby prawne i ich  jednostki organizacyjne oraz jednostki organizacyjne niemające osobowości prawnej." FrameStyle="SmallYellow" 
                FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel30" style="Z-INDEX: 114; LEFT: 1px; POSITION: absolute; TOP: 172px"
				runat="server" Width="91px" Height="7px" Text="Termin składania:" 
                FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel31" style="Z-INDEX: 115; LEFT: 76px; POSITION: absolute; TOP: 172px"
				runat="server" Width="555px" Height="56px" Text="Do końca stycznia roku następującego po roku podatkowym – dla informacji składanych urzędowi skarbowemu; do końca lutego roku następującego po roku podatkowym – dla informacji przesyłanych podatnikowi; w terminie 14 dni od złożenia pisemnego wniosku przez podatnika – w przypadku gdy w trakcie roku podatkowego ustał obowiązek poboru zaliczki przez płatników, o których mowa w art. 39 ust. 1 ustawy; do dnia zaprzestania działalności<.INDEXUP>3)<./> – w przypadku gdy składający zaprzestali działalności przed końcem stycznia lub odpowiednio przed końcem lutego roku następującego po roku podatkowym."
				FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel32" style="Z-INDEX: 116; LEFT: 1px; POSITION: absolute; TOP: 224px"
				runat="server" Width="91px" Height="7px" Text="Otrzymuje:" FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel33" style="Z-INDEX: 117; LEFT: 76px; POSITION: absolute; TOP: 220px"
				runat="server" Width="555px" Height="21px" Text="Podatnik oraz urząd skarbowy według miejsca zamieszkania podatnika, a w przypadku podatników, o których mowa w art. 3 ust. 2a ustawy, urząd skarbowy w sprawach opodatkowania osób zagranicznych."
				FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel17" style="Z-INDEX: 118; LEFT: 0px; POSITION: absolute; TOP: 245px"
				runat="server" Width="630px" Height="84px" Text="A. MIEJSCE I CEL SKŁADANIA INFORMACJI" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="FrameLabel18" style="Z-INDEX: 119; LEFT: 28px; POSITION: absolute; TOP: 273px"
				runat="server" Width="602px" DataMember="A.UrzadSkarb" Height="28px" Text="Urząd skarbowy, do którego adresowana jest informacja<.INDEXUP>4)<./>" Number="5"></ea:framelabel>
<ea:framelabel id="Framelabel77" style="Z-INDEX: 120; LEFT: 28px; POSITION: absolute; TOP: 301px"
				runat="server" Width="602px" Height="28px" Text="Cel złożenia formularza <.Normal>(zaznaczyć właściwy kwadrat):<./>" Number="6">
                </ea:FrameLabel>
<ea:checklabel id="Checklabel10" style="Z-INDEX: 121; LEFT: 219px; POSITION: absolute; TOP: 308px"
				runat="server" Width="136px" DataMember="A.Korekta" Height="14px" Text="złożenie informacji" Number="1" NumberAlignLeft="False" ComparedValue="False">
            </ea:CheckLabel>
<ea:checklabel id="Checklabel9" style="Z-INDEX: 122; LEFT: 358px; POSITION: absolute; TOP: 308px"
				runat="server" Width="133px" DataMember="A.Korekta" Height="14px" Text="korekta informacji 5)" Number="2" NumberAlignLeft="False"></ea:checklabel>
<ea:framelabel id="FrameLabel1" style="Z-INDEX: 123; LEFT: 0px; POSITION: absolute; TOP: 329px"
				runat="server" Width="630px" Height="122px" Text="B. DANE IDENTYFIKACYJNE SKŁADAJĄCEGO&lt;br&gt;&lt;.Footer&gt;* - dotyczy składającego niebędącego osobą fizyczną ** - dotyczy składającego będącego osobą fizyczną&lt;./&gt;" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="FrameLabel3" style="Z-INDEX: 124; LEFT: 28px; POSITION: absolute; TOP: 364px"
				runat="server" Width="602px" Height="28px" Text="Rodzaj składającego <.Normal>(zaznaczyć właściwy kwadrat):<./>" Number="7"></ea:framelabel>
<ea:checklabel id="CheckLabel1" style="Z-INDEX: 125; LEFT: 132px; POSITION: absolute; TOP: 371px"
				runat="server" Width="181px" DataMember="B1.OsobaFiz" Height="14px" Text="składający niebędący osobą fizyczną" Number="1" NumberAlignLeft="False" ComparedValue="False">
            </ea:CheckLabel>
<ea:checklabel id="CheckLabel2" style="Z-INDEX: 126; LEFT: 423px; POSITION: absolute; TOP: 371px"
				runat="server" Width="133px" DataMember="B1.OsobaFiz" Height="14px" Text="osoba fizyczna" Number="2" NumberAlignLeft="False">
            </ea:CheckLabel>
<ea:framelabel id="FrameLabel20" style="Z-INDEX: 128; LEFT: 28px; POSITION: absolute; TOP: 392px; height: 25px;"
				runat="server" Width="602px" DataMember="NazwaFirma" 
                Text="Nazwa pełna, REGON *"
                SmallerFontLength="70" 
                Number="8"></ea:framelabel>
<ea:framelabel id="FrameLabel4" style="Z-INDEX: 129; LEFT: 28px; POSITION: absolute; TOP: 420px; height: 25px;"
				runat="server" Width="602px" DataMember="NazwaOsobaFizycza" 
                Text="Nazwisko, pierwsze imię, data urodzenia <.INDEXUP>6)<./>**" 
                SmallerFontLength="70"
                Number="9"></ea:framelabel>
<ea:framelabel id="Framelabel41" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 447px"
				runat="server" Width="630px" Height="278px" Text="C. DANE IDENTYFIKACYJNE I ADRES ZAMIESZKANIA PODATNIKA" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="FrameLabel9" style="Z-INDEX: 141; LEFT: 28px; POSITION: absolute; TOP: 476px"
				runat="server" Width="602px" Height="28px" Text="Rodzaj obowiązku podatkowego podatnika <.Normal>(zaznaczyć właściwy kwadrat)<./>" Number="10"></ea:framelabel>
<ea:checklabel id="CheckLabel7" style="Z-INDEX: 141; LEFT: 74px; POSITION: absolute; TOP: 485px" DataMember="C1.Rezydent"
				runat="server" Width="280px" Height="14px" Text="nieograniczony obowiązek podatkowy (rezydent)" Number="1" NumberAlignLeft="False">
            </ea:CheckLabel>
<ea:checklabel id="CheckLabel8" style="Z-INDEX: 141; LEFT: 355px; POSITION: absolute; TOP: 485px" DataMember="C1.Rezydent"
				runat="server" Width="280px" Height="14px" Text="ograniczony obowiązek podatkowy (nierezydent) 7)" Number="2" NumberAlignLeft="False" ComparedValue="False">
            </ea:CheckLabel>
<ea:framelabel id="flPeselNip" style="Z-INDEX: 142; LEFT: 28px; POSITION: absolute; TOP: 504px; width: 601px;"
				runat="server" DataMember="IdentyfikatorPodatnika" Height="28px" 
                Text="Identyfikator podatkowy NIP/Numer PESEL &lt;.Indexup&gt;(niepotrzebne skreślić) &lt;/Indexup&gt;" 
                Number="11"></ea:framelabel>
<ea:framelabel id="Framelabel11" style="Z-INDEX: 142; LEFT: 28px; POSITION: absolute; TOP: 532px; width: 601px;"
				runat="server" DataMember="C1.ZagrNIP"
                Text="Zagraniczny numer identyfikacyjny podatnika <.Normal> &lt;.Indexup&gt;8)" 
                Height="28px" Number="12"></ea:framelabel>
<ea:framelabel id="Framelabel12" style="Z-INDEX: 142; LEFT: 28px; POSITION: absolute; TOP: 560px; width: 601px;"
				runat="server"
                Text="&lt;.Indexup&gt;Rodzaj numeru identyfikacyjnego (dokumentu stwierdzającego tożsamość) 9)" 
                Height="28px" Number="13"></ea:framelabel>
<ea:framelabel id="Framelabel15" style="Z-INDEX: 142; LEFT: 28px; POSITION: absolute; TOP: 588px; width: 601px;"
				runat="server" DataMember="C1.KrajDok"
                Text="&lt;.Indexup&gt;Kraj wydania numeru identyfikacyjnego (dokumentu stwierdzającego tożsamość) 9)" 
                Height="28px" Number="14"></ea:framelabel>
<ea:framelabel id="Framelabel103" 
                style="Z-INDEX: 143; LEFT: 28px; POSITION: absolute; TOP: 616px; width: 240px; right: 557px;" SmallerFontLength="30"
				runat="server" DataMember="C1.Nazwisko" Height="28px" Text="Nazwisko" Number="15"></ea:framelabel>
<ea:framelabel id="Framelabel104" style="Z-INDEX: 144; LEFT: 266px; POSITION: absolute; TOP: 616px; width: 189px;"
				runat="server" DataMember="C1.Imię" Height="28px" Text="Pierwsze imię" Number="16"></ea:framelabel>
<ea:framelabel id="Framelabel105" style="Z-INDEX: 145; LEFT: 455px; POSITION: absolute; TOP: 616px; width: 172px;"
				runat="server" ValueStyle="Date" DataMember="C1.DataUrodz" Height="28px" 
                Text="Data urodzenia" Number="17"></ea:framelabel>
<ea:framelabel id="Framelabel106" style="Z-INDEX: 147; LEFT: 28px; POSITION: absolute; TOP: 643px"
				runat="server" Width="140px" DataMember="C2.Kraj" Height="28px" Text="Kraj" Number="18"></ea:framelabel>
<ea:framelabel id="Framelabel107" style="Z-INDEX: 148; LEFT: 168px; POSITION: absolute; TOP: 643px"
				runat="server" Width="266px" DataMember="C2.Wojew" Height="28px" Text="Województwo" Number="19"></ea:framelabel>
<ea:framelabel id="Framelabel108" style="Z-INDEX: 149; LEFT: 434px; POSITION: absolute; TOP: 643px"
				runat="server" Width="196px" DataMember="C2.Powiat" Height="28px" Text="Powiat" Number="20" SmallerFontLength="22"></ea:framelabel>
<ea:framelabel id="Framelabel109" style="Z-INDEX: 150; LEFT: 28px; POSITION: absolute; TOP: 671px" SmallerFontLength="16"
				runat="server" Width="161px" DataMember="C2.Gmina" Height="28px" Text="Gmina" Number="21"></ea:framelabel>
<ea:framelabel id="Framelabel110" style="Z-INDEX: 151; LEFT: 189px; POSITION: absolute; TOP: 671px"
				runat="server" Width="301px" DataMember="C2.Ulica" Height="28px" Text="Ulica" SmallerFontLength="35"
                Number="22"></ea:framelabel>
<ea:framelabel id="Framelabel111" style="Z-INDEX: 152; LEFT: 490px; POSITION: absolute; TOP: 671px" SmallerFontLength="6"
				runat="server" Width="70px" DataMember="C2.NrDomu" Height="28px" Text="Nr domu" Number="23"></ea:framelabel>
<ea:framelabel id="Framelabel112" style="Z-INDEX: 153; LEFT: 560px; POSITION: absolute; TOP: 671px"
				runat="server" Width="70px" DataMember="C2.NrLokalu" Height="28px" Text="Nr lokalu" Number="24"></ea:framelabel>
<ea:framelabel id="Framelabel113" style="Z-INDEX: 154; LEFT: 28px; POSITION: absolute; TOP: 699px" SmallerFontLength="32"
				runat="server" Width="252px" DataMember="C2.Miejsc" Height="28px" Text="Miejscowość" Number="25"></ea:framelabel>
<ea:framelabel id="Framelabel114" style="Z-INDEX: 155; LEFT: 280px; POSITION: absolute; TOP: 699px"
				runat="server" Width="105px" ValueStyle="PostalCode" DataMember="C2.KodPoczt" Height="28px" Text="Kod pocztowy" Number="26"></ea:framelabel>
<ea:framelabel id="Framelabel115" style="Z-INDEX: 156; LEFT: 385px; POSITION: absolute; TOP: 699px"
				runat="server" Width="245px" DataMember="C2.Poczta" Height="28px" Text="Poczta" Number="27"></ea:framelabel>
<ea:framelabel id="Framelabel116" style="Z-INDEX: 157; LEFT: 0px; POSITION: absolute; TOP: 727px"
				runat="server" Width="630px" Height="107px" 
                Text="D. INFORMACJA O KOSZTACH UZYSKANIA PRZYCHODU &lt;.SMALLER&gt;Z TYTUŁU STOSUNKU SŁUŻBOWEGO, STOSUNKU PRACY, SPÓŁDZIELCZEGO STOSUNKU PRACY ORAZ PRACY NAKŁADCZEJ&lt;./&gt;" 
                FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="Framelabel117" style="Z-INDEX: 158; LEFT: 28px; POSITION: absolute; TOP: 762px"
				runat="server" Width="602px" Height="71px" Text="Koszty uzyskania przychodów, wykazane w poz. 30, zostały uwzględnione do wysokości przysługującej podatnikowi <.Normal>(zaznaczyć właściwy kwadrat):<./>" Number="28"></ea:framelabel>
<ea:checklabel id="Checklabel3" style="Z-INDEX: 159; LEFT: 44px; POSITION: absolute; TOP: 780px"
				runat="server" Width="287px" DataMember="D.Jeden" Height="14px" Text="z jednego stosunku pracy (stosunków pokrewnych)" Number="1" NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:checklabel id="Checklabel4" style="Z-INDEX: 160; LEFT: 335px; POSITION: absolute; TOP: 780px"
				runat="server" Width="280px" DataMember="D.Wiecej" Height="12px" Text="z więcej niż jednego stosunku pracy (stosunków pokrewnych)" Number="2" NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:checklabel id="Checklabel5" style="Z-INDEX: 161; LEFT: 44px; POSITION: absolute; TOP: 797px"
				runat="server" Width="286px" DataMember="D.JedenPodw" Height="14px" Text="z jednego stosunku pracy (stosunków pokrewnych), podwyższone w związku z zamieszkiwaniem podatnika poza miejscowością, w której znajduje się zakład pracy" Number="3" NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:checklabel id="Checklabel6" style="Z-INDEX: 162; LEFT: 335px; POSITION: absolute; TOP: 797px"
				runat="server" Width="277px" DataMember="D.WiecejPodw" Height="14px" Text="z więcej niż jednego stosunku pracy (stosunków pokrewnych), podwyższone w związku z zamieszkiwaniem podatnika poza miejscowością, w której znajduje się zakład pracy" Number="4" NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:deklaracjafooter id="footer1" 
                style="Z-INDEX: 188; LEFT: 490px; POSITION: absolute; TOP: 930px" runat="server"
				Width="154px" Height="10px" TitleWidth="106" Symbol="PIT-11" PageNumber="1" 
                PageTotal="3" Version="24"></ea:deklaracjafooter>
<ea:deklaracjaheader id="DeklaracjaHeader2" style="Z-INDEX: 189; LEFT: 0px; POSITION: absolute; TOP: 978px"
				runat="server" Width="630px" StylNagłówka="WylacznieDużymiDrukowanymi"></ea:deklaracjaheader>
<ea:framelabel id="FrameLabel16" style="Z-INDEX: 166; LEFT: 0px; POSITION: absolute; TOP: 1002px; height: 593px;"
				runat="server" Width="630px" 
                Text="E. DOCHODY PODATNIKA, POBRANE ZALICZKI ORAZ POBRANE SKŁADKI <.INDEXUP>13)<./>&lt;br&gt;&lt;.Footer&gt;(część tę wypełniają składający będący płatnikami)&lt;./&gt;" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel39" style="Z-INDEX: 167; LEFT: 28px; POSITION: absolute; TOP: 1031px; width: 221px;"
				runat="server" Height="36px" Text="Źródła przychodów" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel37" style="Z-INDEX: 168; LEFT: 252px; POSITION: absolute; TOP: 1031px; width: 78px; right: 617px;"
				runat="server" ValueStyle="ZlGr" Height="36px" Text="Przychód <.INDEXUP>10)<./>" 
                FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel40" style="Z-INDEX: 169; LEFT: 329px; POSITION: absolute; TOP: 1031px; width: 79px;"
				runat="server" ValueStyle="ZlGr" Height="36px" 
                Text="Koszty uzyskania<br>przychodów <.INDEXUP>11)<./>" 
                FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel42" style="Z-INDEX: 170; LEFT: 406px; POSITION: absolute; TOP: 1031px; width: 80px;"
				runat="server" Height="36px" Text="Dochód<br>(b-c)" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center" ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="FrameLabel152" style="Z-INDEX: 170; LEFT: 483px; POSITION: absolute; TOP: 1031px; width: 80px;"
				runat="server" Height="36px" 
                Text="Dochód zwolniony &lt;br&gt; od podatku &lt;.INDEXUP&gt;10)&lt;./&gt;" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center" ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="FrameLabel43" style="Z-INDEX: 171; LEFT: 560px; POSITION: absolute; TOP: 1031px; width: 69px;"
				runat="server" Height="36px" Text="Zaliczka pobrana<br>przez płatnika" 
                FrameStyle="SmallBoldYellow" HorizontalAlign="Center" ValueStyle="Zl"></ea:framelabel>
<ea:framelabel id="FrameLabel38" style="Z-INDEX: 172; LEFT: 28px; POSITION: absolute; TOP: 1066px; height: 19px; width: 222px;"
				runat="server" Text="a" FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel44" style="Z-INDEX: 173; LEFT: 252px; POSITION: absolute; TOP: 1066px; width: 79px;"
				runat="server" Height="19px" Text="b" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel45" style="Z-INDEX: 174; LEFT: 329px; POSITION: absolute; TOP: 1066px; height: 19px; width: 76px;"
				runat="server" Text="c" FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel46" style="Z-INDEX: 175; LEFT: 406px; POSITION: absolute; TOP: 1066px; width: 79px;"
				runat="server" Height="19px" Text="d" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel153" style="Z-INDEX: 175; LEFT: 483px; POSITION: absolute; TOP: 1066px; width: 79px;"
				runat="server" Height="19px" Text="e" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel47" style="Z-INDEX: 176; LEFT: 560px; POSITION: absolute; TOP: 1066px; width: 67px;"
				runat="server" Height="19px" Text="f" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel48" style="Z-INDEX: 177; LEFT: 28px; POSITION: absolute; TOP: 1084px; height: 86px; bottom: 568px; width: 224px;"
				runat="server" 
                Text="Należności ze stosunku: pracy, służbowego, spółdzielczego i z pracy nakładczej, a także zasiłki pieniężne z ubezpieczenia społecznego wypłacone przez zakład pracy,o którym mowa w art. 31 ustawy oraz płatników, o których mowa w art. 42e ust. 1 ustawy" FrameStyle="SmallBoldYellow"
				Number="1" HorizontalAlign="Left" 
                FooterText="W poz. 34 należy wykazać przychody, do których zastosowano odliczenie kosztów uzyskania przychodów na podstawie art. 22 ust. 9 pkt 3 ustawy."></ea:framelabel>
<ea:framelabel id="Framelabel49" style="Z-INDEX: 178; LEFT: 252px; POSITION: absolute; TOP: 1084px; width: 77px; height: 56px;" SmallerFontLength="18"
				runat="server" ValueStyle="ZlGr" DataMember="E.1aPrzychód" Number="29"></ea:framelabel>
<ea:framelabel id="Framelabel51" style="Z-INDEX: 179; LEFT: 329px; POSITION: absolute; TOP: 1084px; width: 75px; height: 58px;" SmallerFontLength="18"
				runat="server" ValueStyle="ZlGr" DataMember="E.1aKoszty" Number="30"></ea:framelabel>
<ea:framelabel id="Framelabel53" style="Z-INDEX: 180; LEFT: 406px; POSITION: absolute; TOP: 1084px; width: 78px; height: 87px;" SmallerFontLength="18"
				runat="server" ValueStyle="ZlGr" DataMember="E.1Dochód" 
                Number="31"></ea:framelabel>
<ea:framelabel id="Framelabel154" style="Z-INDEX: 180; LEFT: 483px; POSITION: absolute; TOP: 1084px; width: 78px; height: 85px;" SmallerFontLength="18"
				runat="server" ValueStyle="ZlGr" DataMember="E.1Zwolniony" 
                Number="32"></ea:framelabel>
<ea:framelabel id="Framelabel54" style="Z-INDEX: 181; LEFT: 560px; POSITION: absolute; TOP: 1084px; width: 73px; height: 86px;"
				runat="server" ValueStyle="Zl" DataMember="E.1Zaliczka" 
                Number="33"></ea:framelabel>
<ea:framelabel id="Framelabel50" style="Z-INDEX: 182; LEFT: 252px; POSITION: absolute; TOP: 1140px; width: 76px; height: 25px;" SmallerFontLength="18"
				runat="server" ValueStyle="ZlGr" DataMember="E.1bPrzychód" 
                Number="34" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel52" style="Z-INDEX: 183; LEFT: 329px; POSITION: absolute; TOP: 1140px; width: 76px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.1bKoszty" Height="28px" 
                Number="35"></ea:framelabel>
<ea:framelabel id="FrameLabel55" style="Z-INDEX: 184; LEFT: 28px; POSITION: absolute; TOP: 1168px; height: 45px; width: 221px;"
				runat="server" Text="Należności z tytułu członkostwa w rolniczej spółdzielni produkcyjnej lub innej spółdzielni zajmującej się produkcją rolną oraz zasiłki pieniężne z ubezpieczenia społecznego"
				FrameStyle="SmallBoldYellow" Number="2" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel57" style="Z-INDEX: 185; LEFT: 252px; POSITION: absolute; TOP: 1168px; width: 78px; height: 45px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.2Przychód" 
                Number="36"></ea:framelabel>
<ea:framelabel id="Framelabel59" style="Z-INDEX: 186; LEFT: 406px; POSITION: absolute; TOP: 1168px; width: 77px; height: 44px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.2Dochód" 
                Number="37" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel60" style="Z-INDEX: 187; LEFT: 560px; POSITION: absolute; TOP: 1168px; width: 70px; height: 41px;"
				runat="server" ValueStyle="Zl" DataMember="E.2Zaliczka" 
                Number="38"></ea:framelabel>
<ea:framelabel id="FrameLabel61" style="Z-INDEX: 190; LEFT: 28px; POSITION: absolute; TOP: 1210px; width: 221px;"
				runat="server" Height="25px" Text="Emerytury - renty zagraniczne" 
                FrameStyle="SmallBoldYellow" Number="3" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel62" style="Z-INDEX: 191; LEFT: 252px; POSITION: absolute; TOP: 1210px; width: 75px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.3Przychód" Height="28px" 
                Number="39"></ea:framelabel>
<ea:framelabel id="Framelabel64" style="Z-INDEX: 192; LEFT: 406px; POSITION: absolute; TOP: 1210px; width: 79px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.3Dochód" Height="28px" 
                Number="40"></ea:framelabel>
<ea:framelabel id="Framelabel156" style="Z-INDEX: 193; LEFT: 483px; POSITION: absolute; TOP: 1210px; width: 79px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.3Zwolniony" Height="28px" 
                Number="41"></ea:framelabel>
<ea:framelabel id="Framelabel65" style="Z-INDEX: 194; LEFT: 560px; POSITION: absolute; TOP: 1210px; width: 71px;"
				runat="server" ValueStyle="Zl" DataMember="E.3Zaliczka" Height="28px" 
                Number="42"></ea:framelabel>
<ea:framelabel id="FrameLabel66" style="Z-INDEX: 195; LEFT: 28px; POSITION: absolute; TOP: 1238px; height: 26px; width: 221px;"
				runat="server" 
                Text="Należności za pracę przypadające tymczasowo aresztowanym lub skazanym" 
                FrameStyle="SmallBoldYellow" Number="4" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel72" style="Z-INDEX: 196; LEFT: 252px; POSITION: absolute; TOP: 1238px; right: 591px; width: 80px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.4Przychód" Height="28px" 
                Number="43" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel85" style="Z-INDEX: 197; LEFT: 406px; POSITION: absolute; TOP: 1238px; width: 74px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.4Dochód" Height="28px" 
                Number="44" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel91" style="Z-INDEX: 198; LEFT: 560px; POSITION: absolute; TOP: 1238px; width: 72px;"
				runat="server" ValueStyle="Zl" DataMember="E.4Zaliczka" Height="28px" 
                Number="45"></ea:framelabel>
<ea:framelabel id="FrameLabel67" style="Z-INDEX: 199; LEFT: 28px; POSITION: absolute; TOP: 1266px; height: 26px; width: 225px;"
				runat="server" 
                Text="Świadczenia wypłacone z Funduszów<br>Pracy i Gwarantowanych Świadczeń Pracowniczych" 
                FrameStyle="SmallBoldYellow" Number="5" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel73" style="Z-INDEX: 200; LEFT: 252px; POSITION: absolute; TOP: 1266px; width: 77px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.5Przychód" Height="26px" 
                Number="46"></ea:framelabel>
<ea:framelabel id="Framelabel86" style="Z-INDEX: 201; LEFT: 406px; POSITION: absolute; TOP: 1266px; width: 79px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.5Dochód" Height="28px" 
                Number="47"></ea:framelabel>
<ea:framelabel id="Framelabel92" style="Z-INDEX: 202; LEFT: 560px; POSITION: absolute; TOP: 1266px; width: 69px;"
				runat="server" ValueStyle="Zl" DataMember="E.5Zaliczka" Height="26px" 
                Number="48"></ea:framelabel>
<ea:framelabel id="FrameLabel97" style="Z-INDEX: 203; LEFT: 28px; POSITION: absolute; TOP: 1294px; height: 39px; width: 222px;"
				runat="server" Text="Działalność wykonywana osobiście, o której mowa w art. 13 pkt 2, 4, 6 (z wyjątkiem czynności wymienionych w wierszu 7) i 7-9 ustawy, w tym umowy zlecenia i o dzieło&lt;./&gt;"
				FrameStyle="SmallBoldYellow" Number="6" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel74" style="Z-INDEX: 203; LEFT: 252px; POSITION: absolute; TOP: 1294px; width: 75px; height: 40px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.6Przychód" 
                Number="49"></ea:framelabel>
<ea:framelabel id="Framelabel100" style="Z-INDEX: 203; LEFT: 329px; POSITION: absolute; TOP: 1294px; width: 76px; height: 40px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.6Koszty" 
                Number="50"></ea:framelabel>
<ea:framelabel id="Framelabel87" style="Z-INDEX: 203; LEFT: 406px; POSITION: absolute; TOP: 1294px; width: 79px; right: 482px; height: 40px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.6Dochód" 
                Number="51"></ea:framelabel>
<ea:framelabel id="Framelabel93" style="Z-INDEX: 204; LEFT: 560px; POSITION: absolute; TOP: 1294px; width: 69px; height: 41px;"
				runat="server" ValueStyle="Zl" DataMember="E.6Zaliczka" 
                Number="52"></ea:framelabel>
<ea:framelabel id="FrameLabel68" style="Z-INDEX: 205; LEFT: 28px; POSITION: absolute; TOP: 1336px; width: 222px;"
				runat="server" Height="26px" 
                Text="Czynności związane z pełnieniem obowiązków społeczych lub obywatelskich (art. 13 pkt 5 i 6 ustawy) - <.Normal>Należy wpisać kwotę wynikające z PIT-R<./>" FrameStyle="SmallBoldYellow"
				Number="7" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel98" style="Z-INDEX: 206; LEFT: 252px; POSITION: absolute; TOP: 1336px; right: 591px; width: 78px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.7Przychód" Height="28px" 
                Number="53" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel80" style="Z-INDEX: 207; LEFT: 329px; POSITION: absolute; TOP: 1336px; width: 76px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.7Koszty" Height="28px" 
                Number="54" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel118" style="Z-INDEX: 208; LEFT: 406px; POSITION: absolute; TOP: 1336px; width: 74px; bottom: 428px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.7Dochód" Height="28px" 
                Number="55"></ea:framelabel>
<ea:framelabel id="Framelabel120" style="Z-INDEX: 209; LEFT: 560px; POSITION: absolute; TOP: 1336px; bottom: 481px; width: 69px;"
				runat="server" ValueStyle="Zl" DataMember="E.7Zaliczka" Height="28px" 
                Number="56"></ea:framelabel>
<ea:framelabel id="FrameLabel126" style="Z-INDEX: 210; LEFT: 28px; POSITION: absolute; TOP: 1364px; width: 226px;"
				runat="server" Height="56px" 
                Text="Prawa autorskie i inne prawa, o których mowa w art. 18 ustawy" 
                FrameStyle="SmallBoldYellow" Number="8" HorizontalAlign="Left"
                FooterText="W poz. 60 należy wykazać przychody, do których zastosowano koszty uzyskania przychodów na podstawie art. 22 ust. 9 pkt 1-3 ustawy."></ea:framelabel>
<ea:framelabel id="Framelabel135" style="Z-INDEX: 211; LEFT: 252px; POSITION: absolute; TOP: 1364px; width: 79px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.8Przychód" Height="28px" 
                Number="57"></ea:framelabel>
<ea:framelabel id="Framelabel141" style="Z-INDEX: 213; LEFT: 406px; POSITION: absolute; TOP: 1364px; width: 78px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.8Dochód" Height="56px" 
                Number="58"></ea:framelabel>
<ea:framelabel id="Framelabel143" style="Z-INDEX: 214; LEFT: 560px; POSITION: absolute; TOP: 1364px; width: 72px;"
				runat="server" ValueStyle="Zl" DataMember="E.8Zaliczka" Height="56px" 
                Number="59"></ea:framelabel>
<ea:framelabel id="Framelabel2" style="Z-INDEX: 215; LEFT: 252px; POSITION: absolute; TOP: 1392px; width: 76px; height: 28px;" SmallerFontLength="18"
				runat="server" ValueStyle="ZlGr" DataMember="E.8bPrzychód" 
                Number="60" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel5" style="Z-INDEX: 216; LEFT: 329px; POSITION: absolute; TOP: 1392px; width: 76px;"
				runat="server" ValueStyle="ZlGr" Height="28px" DataMember="E.8Koszty"
                Number="61"></ea:framelabel>
<ea:framelabel id="Framelabel71" style="Z-INDEX: 220; LEFT: 28px; POSITION: absolute; TOP: 1420px; width: 223px;"
				runat="server" Height="26px" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Left" Number="9" 
                Text="Należności wynikające z umowy aktywizacyjnej">
                </ea:FrameLabel>
<ea:framelabel id="Framelabel90" style="Z-INDEX: 221; LEFT: 252px; POSITION: absolute; TOP: 1420px; width: 79px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.9Przychód" Height="28px" 
                Number="62">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel96" style="Z-INDEX: 222; LEFT: 329px; POSITION: absolute; TOP: 1420px; width: 75px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.9Koszty" Height="28px" 
                Number="63">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel145" style="Z-INDEX: 223; LEFT: 406px; POSITION: absolute; TOP: 1420px; width: 76px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.9Dochód" Height="28px" 
                Number="64">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel146" style="Z-INDEX: 224; LEFT: 560px; POSITION: absolute; TOP: 1420px; width: 69px;"
				runat="server" ValueStyle="Zl" DataMember="E.9Zaliczka" Height="28px" 
                Number="65"></ea:framelabel>
<ea:framelabel id="FrameLabel70" style="Z-INDEX: 225; LEFT: 28px; POSITION: absolute; TOP: 1448px; width: 222px;"
				runat="server" Height="26px" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Left" Number="10" Text="Inne źródła&lt;.INDEXUP&gt;12)&lt;./&gt;"></ea:framelabel>
<ea:framelabel id="Framelabel76" style="Z-INDEX: 226; LEFT: 252px; POSITION: absolute; TOP: 1448px; width: 78px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.10Przychód" Height="28px" 
                Number="66"></ea:framelabel>
<ea:framelabel id="Framelabel89" style="Z-INDEX: 227; LEFT: 406px; POSITION: absolute; TOP: 1448px; width: 78px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.10Dochód" Height="28px" 
                Number="67" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel157" style="Z-INDEX: 227; LEFT: 483px; POSITION: absolute; TOP: 1448px; width: 78px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.10Zwolniony" Height="28px" 
                Number="68" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel95" style="Z-INDEX: 228; LEFT: 560px; POSITION: absolute; TOP: 1448px; width: 69px;"
				runat="server" ValueStyle="Zl" DataMember="E.10Zaliczka" Height="28px" 
                Number="69"></ea:framelabel>
<ea:framelabel id="FrameLabel36" style="Z-INDEX: 229; LEFT: 35px; POSITION: absolute; TOP: 1476px; width: 389px;"
				runat="server" Height="26px" 
                Text="Składki na ubezpieczenia społeczne, o których mowa w przepisach ustawy, podlegające odliczenu od dochodu&lt;.INDEXUP&gt;13)&lt;./&gt;" 
                FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel99" style="Z-INDEX: 230; LEFT: 427px; POSITION: absolute; TOP: 1476px"
				runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="E.Społeczne" Height="28px" 
                Number="70"></ea:framelabel>
<ea:framelabel id="FrameLabel149" style="Z-INDEX: 230; LEFT: 42px; POSITION: absolute; TOP: 1504px; width: 382px;"
				runat="server" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left" 
                Text="w tym zagraniczne, o których mowa w art. 26 ust. 1 pkt 2a ustawy"></ea:framelabel>
<ea:framelabel id="Framelabel148" style="Z-INDEX: 230; LEFT: 427px; POSITION: absolute; TOP: 1504px"
				runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="E.SpołeczneZagr" Height="28px" 
                Number="71"></ea:framelabel>
<ea:framelabel id="FrameLabel63" style="Z-INDEX: 231; LEFT: 35px; POSITION: absolute; TOP: 1532px; width: 394px;"
				runat="server" Height="28px" 
                Text="Składki na ubezpieczenie zdrowotne, o których mowa w przepisach ustawy, podlegające odliczeniu od podatku&lt;.INDEXUP&gt;13)&lt;./&gt;" 
                FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel119" style="Z-INDEX: 232; LEFT: 427px; POSITION: absolute; TOP: 1532px"
				runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="E.ZdrDoOdlicz" 
                Height="28px" Number="72"></ea:framelabel>
<ea:framelabel id="FrameLabel151" style="Z-INDEX: 232; LEFT: 42px; POSITION: absolute; TOP: 1560px; width: 385px;"
				runat="server" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left" 
                Text="w tym zagraniczne, o których mowa w art. 27b ust. 1. pkt 2 ustawy"></ea:framelabel>
<ea:framelabel id="Framelabel150" style="Z-INDEX: 232; LEFT: 427px; POSITION: absolute; TOP: 1560px"
				runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="E.ZdrDoOdliczZagr" 
                Height="28px" Number="73"></ea:framelabel>
<ea:framelabel id="Framelabel121" style="Z-INDEX: 233; LEFT: 0px; POSITION: absolute; TOP: 1588px; height: 218px;"
				runat="server" Width="630px" 
                Text="F. &lt;font STYLE='font-size: 10pt;'&gt;INFORMACJA O WYSOKOŚCI PRZYCHODÓW, O KTÓRYCH MOWA W ART. 20 UST. 1 USTAWY&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;(część tę wypełniają składający niebędący płatnikami, o których mowa w art. 42a ustawy, w tym rolnicy)&lt;./&gt;" 
                FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="FrameLabel58" style="Z-INDEX: 235; LEFT: 28px; POSITION: absolute; TOP: 1637px"
				runat="server" Width="399px" Height="28px" 
                Text="Rodzaj przychodu (wymienić):" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="Framelabel78" style="Z-INDEX: 235; LEFT: 427px; POSITION: absolute; TOP: 1637px"
				runat="server" Width="203px" Height="28px"
                Text="Przychód" FrameStyle="SmallBoldYellow"
                HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel21" style="Z-INDEX: 235; LEFT: 28px; POSITION: absolute; TOP: 1665px"
				runat="server" Width="399px" Height="28px" 
                Text="Wynagrodzenie z tytułu umowy o pomocy przy zbiorach" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel22" style="Z-INDEX: 237; LEFT: 427px; POSITION: absolute; TOP: 1665px"
				runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="F.1Przychód" 
                Height="28px" Number="74"></ea:framelabel>
<ea:framelabel id="Framelabel6" style="Z-INDEX: 238; LEFT: 28px; POSITION: absolute; TOP: 1693px"
				runat="server" Width="399px" DataMember="F.2Opis" 
                Height="28px" Number="75"></ea:framelabel>
<ea:framelabel id="Framelabel7" style="Z-INDEX: 239; LEFT: 427px; POSITION: absolute; TOP: 1693px"
				runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="F.2Przychód" 
                Height="28px" Number="76"></ea:framelabel>
<ea:framelabel id="Framelabel8" style="Z-INDEX: 240; LEFT: 28px; POSITION: absolute; TOP: 1721px"
				runat="server" Width="399px" DataMember="F.3Opis" 
                Height="28px" Number="77"></ea:framelabel>
<ea:framelabel id="Framelabel10" style="Z-INDEX: 241; LEFT: 427px; POSITION: absolute; TOP: 1721px"
				runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="F.3Przychód" 
                Height="28px" Number="78"></ea:framelabel>
<ea:framelabel id="Framelabel13" style="Z-INDEX: 242; LEFT: 28px; POSITION: absolute; TOP: 1749px"
				runat="server" Width="399px" DataMember="F.4Opis" 
                Height="28px" Number="79"></ea:framelabel>
<ea:framelabel id="Framelabel34" style="Z-INDEX: 243; LEFT: 427px; POSITION: absolute; TOP: 1749px"
				runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="F.4Przychód" 
                Height="28px" Number="80"></ea:framelabel>
<ea:framelabel id="FrameLabel35" style="Z-INDEX: 244; LEFT: 28px; POSITION: absolute; TOP: 1777px"
				runat="server" Width="399px" Height="28px" 
                Text="Razem" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Left" FooterText="Suma kwot z poz.: 74, 76, 78 i 80."></ea:framelabel>
<ea:framelabel id="Framelabel56" style="Z-INDEX: 245; LEFT: 427px; POSITION: absolute; TOP: 1777px"
				runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="F.Przychód" 
                Height="28px" Number="81"></ea:framelabel>
<ea:deklaracjafooter id="footer2" 
                style="Z-INDEX: 249; LEFT: 0px; POSITION: absolute; TOP: 1907px" runat="server"
				Width="154px" Height="10px" TitleWidth="106" Symbol="PIT-11" PageNumber="2" 
                PageTotal="3" Version="24"></ea:deklaracjafooter>
<ea:framelabel id="flDanePodatnika1" style="Z-INDEX: 249; LEFT: 199px; POSITION: absolute; TOP: 1907px; height: 21px; width: 427px; right: 275px;"
				runat="server" Text="?" FrameStyle="Middle" FrameBorderStyle="None" 
                HorizontalAlign="Right" VerticalAlign="Bottom"></ea:framelabel>
<ea:deklaracjaheader id="DeklaracjaHeader3" style="Z-INDEX: 249; LEFT: 0px; POSITION: absolute; TOP: 1960px"
				runat="server" Width="630px" StylNagłówka="WylacznieDużymiDrukowanymi"></ea:deklaracjaheader>
<ea:framelabel id="Framelabel69" style="Z-INDEX: 250; LEFT: 0px; POSITION: absolute; TOP: 1990px; height: 218px;"
				runat="server" Width="630px" 
                Text="G. &lt;font STYLE='font-size: 10pt;'&gt;INFORMACJA O PRZYCHODACH ZWOLNIONYCH OD PODATKU ORAZ O ZAŁĄCZNIKU&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;(część tę wypełniają składający będący płatnikami)&lt;./&gt;" 
                FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="FrameLabel75" style="Z-INDEX: 251; LEFT: 28px; POSITION: absolute; TOP: 2022px"
				runat="server" Width="399px" Height="28px" 
                Text="Przychody z tytułu stypendium, o którym mowa w art. 21 ust. 1 pkt 40b ustawy" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Left" FooterText="Należy wykazać kwotę stypendium, do wysokości limitu zwolnienia."></ea:framelabel>
<ea:framelabel id="Framelabel79" style="Z-INDEX: 252; LEFT: 427px; POSITION: absolute; TOP: 2022px"
				runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="G.PrzychódTytStyp" 
                Height="28px" Number="82"></ea:framelabel>
<ea:framelabel id="FrameLabel81" style="Z-INDEX: 253; LEFT: 28px; POSITION: absolute; TOP: 2050px"
				runat="server" Width="399px" Height="28px" 
                Text="Przychody otrzymywane z zagranicy, o których mowa w art. 21 ust. 1 pkt 74 ustawy, między innymi renty inwalidzkie z tytułu inwalidztwa wojennego" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel82" style="Z-INDEX: 254; LEFT: 427px; POSITION: absolute; TOP: 2050px"
				runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="G.ZZagranicy" 
                Height="28px" Number="83"></ea:framelabel>
<ea:framelabel id="FrameLabel83" style="Z-INDEX: 255; LEFT: 28px; POSITION: absolute; TOP: 2078px"
				runat="server" Width="399px" Height="28px" 
                Text="Przychody pochodzące ze środków bezzwrotnej pomocy zagranicznej, o których mowa w art. 21 ust. 1 pkt 46 ustawy" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel84" style="Z-INDEX: 255; LEFT: 427px; POSITION: absolute; TOP: 2078px"
				runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="G.PomocBezzwrotna" 
                Height="28px" Number="84"></ea:framelabel>
<ea:framelabel id="Framelabel137" style="Z-INDEX: 256; LEFT: 28px; POSITION: absolute; TOP: 2106px"
				runat="server" Width="602px" Height="28px" 
                Text="Do niniejszej informacji dołączono informację PIT-R <.Normal>(należy zaznaczyć właściwy kwadrat):<./>" 
                Number="85"></ea:framelabel>
<ea:checklabel id="Checklabel_82_T" style="Z-INDEX: 257; LEFT: 161px; POSITION: absolute; TOP: 2113px"
				runat="server" Width="35px" DataMember="G.PITR" Height="14px" Text="tak" Number="1" 
                NumberAlignLeft="False"></ea:checklabel>
<ea:checklabel id="Checklabel_82_N" style="Z-INDEX: 258; LEFT: 328px; POSITION: absolute; TOP: 2115px"
				runat="server" Width="35px" DataMember="G.PITR" Height="14px" Text="nie" Number="2" 
                NumberAlignLeft="False" ComparedValue="False"></ea:checklabel>
<ea:framelabel id="FrameLabel122" style="Z-INDEX: 259; LEFT: 0px; POSITION: absolute; TOP: 2141px; height: 86px;"
				runat="server" Width="630px" Text="H. &lt;font STYLE='font-size: 10pt;'&gt;PODPIS PŁATNIKA LUB OSOBY WYZNACZONEJ DO OBLICZENIA I POBRANIA PODATKU / PEŁNOMOCNIKA PŁATNIKA&lt;/font&gt;<.Indexup>14)<./>&lt;br&gt;&lt;.Footer&gt;"
				FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="flPodpis1" style="Z-INDEX: 260; LEFT: 28px; POSITION: absolute; TOP: 2176px"
				runat="server" Width="601px" Height="46px" Text="Imię, nazwisko, podpis albo nadruk z imieniem nazwiskiem oraz stanowiskiem służbowym" Number="86"></ea:framelabel>
<ea:framelabel id="FrameLabel88" style="Z-INDEX: 259; LEFT: 0px; POSITION: absolute; TOP: 2225px; height: 86px;"
				runat="server" Width="630px" Text="I. &lt;font STYLE='font-size: 10pt;'&gt;PODPIS OSOBY UPOWAŻNIONEJ DO SPORZĄDZENIA INFORMACJI&lt;/font&gt;<.Indexup>15)<./>&lt;br&gt;&lt;.Footer&gt;"
				FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="flPodpis2" style="Z-INDEX: 260; LEFT: 28px; POSITION: absolute; TOP: 2260px"
				runat="server" Width="601px" Height="46px" Text="Imię, nazwisko, podpis albo nadruk z imieniem nazwiskiem oraz stanowiskiem służbowym" Number="87"></ea:framelabel>
<ea:framelabel id="FrameLabel147" style="Z-INDEX: 261; LEFT: 3px; POSITION: absolute; TOP: 2330px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;1)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;W przypadku przedsiębiorstwa w spadku, należy podać identyfikator podatkowy NIP zmarłego przedsiębiorcy." 
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel101" style="Z-INDEX: 262; LEFT: 3px; POSITION: absolute; TOP: 2345px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;2)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;Art. 35a ustawy został uchylony z dniem 26 października 2007 r. ustawą z dnia 24 sierpnia 2007 r. o zmianie ustawy o promocji zatrudnienia i instytucjach rynku pracy oraz o zmianie niektórych innych ustaw (Dz. U. poz. 1243). Uchylony przepis na mocy art. 7 ust. 7 powołanej ustawy ma zastosowanie do płatników do czasu obowiązywania umowy aktywizacyjnej zawartej przed dniem 26 października 2007 r." 
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel102" style="Z-INDEX: 263; LEFT: 3px; POSITION: absolute; TOP: 2370px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;3)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;W przypadku przedsiębiorstwa w spadku za dzień zaprzestania działalności uważa się dzień wygaśnięcia zarządu sukcesyjnego albo wygaśnięcia uprawnienia do powołania zarządcy sukcesyjnego."
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel123" style="Z-INDEX: 264; LEFT: 3px; POSITION: absolute; TOP: 2385px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;4)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;Ilekroć w informacji jest mowa o urzędzie skarbowym, w tym urzędzie skarbowym, do którego adresowana jest informacja – oznacza to urząd skarbowy, przy pomocy którego właściwy dla podatnika naczelnik urzędu skarbowego wykonuje swoje zadania."
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel124" style="Z-INDEX: 265; LEFT: 3px; POSITION: absolute; TOP: 2410px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;5)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2018 r. poz. 800, z późn. zm.)." 
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel125" style="Z-INDEX: 266; LEFT: 3px; POSITION: absolute; TOP: 2425px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;6)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;W przypadku przedsiębiorstwa w spadku, należy podać dane identyfikacyjne zmarłego przedsiębiorcy z dodaniem oznaczenia „w spadku”."
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel127" style="Z-INDEX: 267; LEFT: 3px; POSITION: absolute; TOP: 2440px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;7)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;W przypadku zaznaczenia kwadratu nr 2, w poz. 18-27 należy podać kraj inny niż Rzeczpospolita Polska oraz adres zamieszkania za granicą; dodatkowo kod kraju wydania dokumentu powinien być zgodny z krajem adresu zamieszkania."
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel128" style="Z-INDEX: 268; LEFT: 3px; POSITION: absolute; TOP: 2465px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;8)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;W poz. 12 należy podać numer służący identyfikacji dla celów podatkowych lub ubezpieczeń społecznych uzyskany w państwie, w którym podatnik ma miejsce zamieszkania. W przypadku braku takiego numeru w poz. 12 należy podać numer dokumentu stwierdzającego tożsamość podatnika, uzyskanego w tym państwie"
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel129" style="Z-INDEX: 269; LEFT: 3px; POSITION: absolute; TOP: 2490px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;9)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;Poz. 13 i 14 należy wypełnić, jeżeli w poz. 12 podano zagraniczny numer identyfikacyjny podatnika." 
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel130" style="Z-INDEX: 270; LEFT: 3px; POSITION: absolute; TOP: 2505px"
				runat="server" Width="627px" Height="30px" 
                Text="&lt;.INDEXUP&gt;10)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;W kwocie przychodów, w części E, nie uwzględnia się przychodów wolnych od podatku na podstawie przepisów ustawy oraz przychodów, od których na podstawie przepisów ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa zaniechano poboru podatku; jednakże w kolumnie e należy wykazać dochody zwolnione od podatku na podstawie umów o unikaniu podwójnego opodatkowania lub innych umów międzynarodowych."
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel131" style="Z-INDEX: 271; LEFT: 3px; POSITION: absolute; TOP: 2540px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;11)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;W kwocie kosztów uzyskania przychodów wykazuje się koszty faktycznie uwzględnione przez płatnika przy poborze zaliczek na podatek."
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel132" style="Z-INDEX: 272; LEFT: 3px; POSITION: absolute; TOP: 2555px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;12)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;W wierszu 10 części E, wykazuje się m. in. kwotę stypendium, o którym mowa w art. 21 ust. 1 pkt 40b ustawy, w wysokości przekraczającej kwotę zwolnioną od podatku (wykazaną w poz. 82) oraz zaliczkę na podatek pobraną przez płatnika."
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel133" style="Z-INDEX: 273; LEFT: 3px; POSITION: absolute; TOP: 2575px"
				runat="server" Width="627px" Height="30px" 
                Text="&lt;.INDEXUP&gt;13)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;W poz. 70-73 nie wykazuje się składek, których podstawę wymiaru stanowi dochód (przychód) zwolniony od podatku na podstawie ustawy, oraz składek, których podstawę wymiaru stanowi dochód, od którego na podstawie przepisów ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa zaniechano poboru podatku, a w przypadku składek zagranicznych, których podstawę wymiaru stanowi dochód (przychód) zwolniony od podatku na podstawie umów o unikaniu podwójnego opodatkowania."
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel134" style="Z-INDEX: 274; LEFT: 3px; POSITION: absolute; TOP: 2615px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;14)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;Część H informacji wypełniają składający będący płatnikami podatku."
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel136" style="Z-INDEX: 275; LEFT: 3px; POSITION: absolute; TOP: 2630px"
				runat="server" Width="627px" Height="24px" 
                Text="&lt;.INDEXUP&gt;15)&lt;./&gt; &lt;font STYLE='font-size: 5pt;'&gt;Część I informacji wypełniają składający niebędący płatnikami, którzy wypełnili część F." 
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel138" style="Z-INDEX: 276; LEFT: 300px; POSITION: absolute; TOP: 2650px"
				runat="server" Width="327px" Height="6px" Text="&lt;font STYLE='font-size: 5pt;'&gt;&lt;b&gt;Pouczenie&lt;/b&gt;"
				FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel139" style="Z-INDEX: 277; LEFT: 3px; POSITION: absolute; TOP: 2660px"
				runat="server" Width="627px" Height="6px" Text="&lt;font STYLE='font-size: 5pt;'&gt;Za uchybienie obowiązkom płatnika, a także za złożenie informacji nieprawdziwej, grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym."
				FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="flDanePodatnika2" style="Z-INDEX: 258; LEFT: 199px; POSITION: absolute; TOP: 2218px; height: 21px; width: 427px; right: 275px;"
				runat="server" Text="?" FrameStyle="Middle" FrameBorderStyle="None" 
                HorizontalAlign="Right" VerticalAlign="Bottom"></ea:framelabel>
<ea:deklaracjafooter id="footer3" 
                style="Z-INDEX: 259; LEFT: 490px; POSITION: absolute; TOP: 2887px" runat="server"
				TitleWidth="106" Symbol="PIT-11" PageNumber="3" PageTotal="3" Version="24"></ea:deklaracjafooter>
<ea:datacontext id="dc" style="Z-INDEX: 260; LEFT: 189px; POSITION: absolute; TOP: 2887px" runat="server"
				TypeName="Soneta.Deklaracje.PIT.PIT11,Soneta.Deklaracje" oncontextload="OnContextLoad" 
                LeftMargin="15" PageHeight="977px" PageZoom="106%"></ea:datacontext>
<ea:Section ID="Strony" runat="server">
<ea:framelabel id="Framelabel14" style="Z-INDEX: 270; LEFT: 0px; POSITION: absolute; TOP: 3000px; height: 1px; width: 601px;"
				runat="server" Text="" FrameBorderStyle="None"></ea:framelabel>
</ea:Section>
</form>
	</body>
</HTML>
