﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="65001" %>
<%@ import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.Xml" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<HTML>

<HEAD>
    <title>PIT-11 (26)</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
    <script runat="server">
        public class SrParams : SerializableContextBase {
                public SrParams(Context context) : base(context) {
            }

            bool strony = true;
            [Caption("4 strony")]
                public bool Strony {
                get { return strony; }
                set {
                    strony = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }

        SrParams srpars;
        [SettingsContext]
            public SrParams SrPars {
            get { return srpars; }
            set { srpars = value; }
        }

        public class Params : ContextBase {
                public Params(Context context) : base(context) {
            }

            bool ord = false;
            [Caption("Drukować ORD-ZU")]
                public bool Ord {
                get { return ord; }
                set {
                    ord = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            bool upo = false;
            [Caption("Drukować nr UPO")]
                public bool Upo {
                get { return upo; }
                set {
                    upo = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }

        Params pars;
        [Context]
            public Params Pars {
            get { return pars; }
            set { pars = value; }
        }

        void OnContextLoad(object sender, EventArgs e) {
            PIT pit = (PIT)dc[typeof (PIT)];
            if (pit as PIT11_26 == null)
                throw new InvalidOperationException("Wydruk PIT-11 (26) może być drukowany wyłącznie dla deklaracji PIT-11 w wersji 26.");
            PIT11_26 pit11 = (PIT11_26)pit;
            string pesel = (string)pit.Bloki["0"]["PESEL"];
            if (!string.IsNullOrEmpty(pesel)) {
                FrameNIPPlatnika.Text = "<b>1. <strike>Identyfikator podatkowy NIP<.Indexup>1)<./></strike> / numer PESEL <.Indexup>(niepotrzebne skreślić)<./>składającego</b>";
                FrameNIPPlatnika.ValueStyle = ValueStyles.WideText;
                FrameNIPPlatnika.DataMember = "0.PESEL";
            }
            else {
                FrameNIPPlatnika.Text = "<b>1. Identyfikator podatkowy NIP<.Indexup>1)<./> / <strike>numer PESEL</strike><.Indexup>(niepotrzebne skreślić)<./> składającego</b>";
                FrameNIPPlatnika.DataMember = "0.Nip";
            }
            if (!pit.Module.Config.PIT.Ogólne.DanePodatnikaWStopce)
                flDanePodatnika1.Text = flDanePodatnika2.Text = "";
            else {
                flDanePodatnika1.Text = flDanePodatnika2.Text = string.Format("{0}, {1}: {2}",
                    pit11.Podmiot.ToString(),
                    pit11.JestPESEL ? "PESEL" : "NIP",
                    pit11.IdentyfikatorPodatnika);
            }
            if (pit11.JestPESEL) {
                flPeselNip.Text = "<strike>Identyfikator podatkowy NIP</strike>/Numer PESEL <.Indexup>(niepotrzebne skreślić)";
                flPeselNip.ValueStyle = ValueStyles.WideText;
            }
            else {
                flPeselNip.Text = "Identyfikator podatkowy NIP/<strike>Numer PESEL</strike> <.Indexup>(niepotrzebne skreślić)";
                flPeselNip.ValueStyle = ValueStyles.nip_w;
            }

            string podpis1 = ""; //(string)pit11.Bloki["H"]["Podpis"];
            if (string.IsNullOrEmpty(podpis1))
                podpis1 = (string)pit11.Bloki["H"]["Imię"] + " " + (string)pit11.Bloki["H"]["Nazwisko"];
            podpis1 += "<br/>" + pit11.Bloki["H"]["Stanowisko"];
            flPodpis1.EditValue = podpis1;

            string podpis2 = ""; //(string)pit11.Bloki["I"]["Podpis"];
            if (string.IsNullOrEmpty(podpis2))
                podpis2 = (string)pit11.Bloki["I"]["Imię"] + " " + (string)pit11.Bloki["I"]["Nazwisko"];
            podpis2 += "<br/>" + pit11.Bloki["I"]["Stanowisko"];
            flPodpis2.EditValue = podpis2;

            Strony.Visible = srpars.Strony;

            string rodzaj = (string)pit11.Bloki["C1"]["RodzajDok"];
            if (rodzaj.Contains("/")) rodzaj = rodzaj.Substring(0, rodzaj.IndexOf("/"));
            Framelabel12.EditValue = rodzaj;

            if (pars.Ord) {
                Soneta.Deklaracje.PIT.ITreśćUzasadnieniaKorekty3 dek = (Soneta.Deklaracje.PIT.ITreśćUzasadnieniaKorekty3)dc[typeof (Soneta.Deklaracje.PIT.ITreśćUzasadnieniaKorekty3)];
                if (dek.Visible)
                    dc.FollowingReports.Add(new FollowingReport("deklaracje/ord_zu_3_2.aspx"));
            }

            if (!dc.OverPrint) {
                if (pars.Upo) {
                    string upo = (pit.Deklaracja ?? pit).GetNumerUpo();
                    if (upo != "") {
                        Resize(FrameNIPPlatnika, -64, 0);
                        Move(FrameNrDokumentu, 0, -64);
                        Resize(FrameNrDokumentu, 64, 0);
                        FrameNrDokumentu.EditValue = upo;
                    }
                }
            }
        }

        void Resize(WebControl fl, int dwidth, int dheight) {
            if (dwidth != 0)
                fl.Style["width"] = (ParsePx(fl.Style["width"]) + dwidth) + "px";
            if (dheight != 0)
                fl.Style["height"] = (ParsePx(fl.Style["height"]) + dheight) + "px";
        }

        void Move(WebControl fl, int dtop, int dleft) {
            if (dtop != 0)
                fl.Style["TOP"] = (ParsePx(fl.Style["TOP"]) + dtop) + "px";
            if (dleft != 0)
                fl.Style["LEFT"] = (ParsePx(fl.Style["LEFT"]) + dleft) + "px";
        }

        int ParsePx(string px) {
            return int.Parse(px.Substring(0, px.Length - 2));
        }
    </script>
</HEAD>

<body leftMargin="0" rightMargin="0">
    <form id="PIT_11_26" method="post" runat="server">
        <ea:deklaracjaheader id="DeklaracjaHeader1" 
            style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 0px"
            runat="server" 
            Width="630px" 
            StylNagłówka="PolaJasneWypelniaPlatnik">
        </ea:deklaracjaheader>
        <ea:framelabel id="FrameNIPPlatnika"
            style="Z-INDEX: 101; LEFT: 0px; POSITION: absolute; TOP: 21px; width: 338px;" 
            runat="server"
            ValueStyle="nip_w" 
            Height="28px">
        </ea:framelabel>
        <ea:framelabel id="FrameNrDokumentu"
            style="Z-INDEX: 102; LEFT: 337px; POSITION: absolute; TOP: 21px; width: 193px;" 
            runat="server" 
            Height="28px"
            Text="Nr dokumentu" 
            FrameStyle="SmallBoldGray" 
            Number="2">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel23" 
            style="Z-INDEX: 103; LEFT: 531px; POSITION: absolute; TOP: 21px; width: 97px;"
            runat="server" 
            Height="30px" 
            Text="Status" 
            FrameStyle="SmallBoldGray" 
            Number="3"></ea:framelabel>
        <ea:framelabel id="labelPIT" 
            style="Z-INDEX: 104; LEFT: 0px; POSITION: absolute; TOP: 49px" 
            runat="server"
            Width="119px" 
            Height="21px" 
            FrameStyle="BigBold" 
            FrameBorderStyle="None" 
            Text="PIT-11">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel158" 
            style="Z-INDEX: 105; LEFT: 50px; POSITION: absolute; TOP: 63px" 
            runat="server"
            Width="545px" 
            Height="35px"
            Text="INFORMACJA O PRZYCHODACH Z INNYCH ŹRÓDEŁ ORAZ O DOCHODACH  I POBRANYCH ZALICZKACH NA PODATEK DOCHODOWY"
            FrameStyle="BigBold" 
            FrameBorderStyle="None" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel19"
            style="Z-INDEX: 106; LEFT: 259px; POSITION: absolute; TOP: 101px; width: 115px;" 
            runat="server"
            ValueStyle="n4" 
            DataMember="0.Rok" 
            Height="28px" 
            Text="4. Rok">
        </ea:framelabel>

        <ea:framelabel id="FrameLabel370"
            style="Z-INDEX: 106; LEFT: 515px; POSITION: absolute; TOP: 101px; width: 115px;" 
            runat="server"
            ValueStyle="n2" 
            DataMember="0.Numer" 
            Height="28px" 
            Text="5. Nr informacji <.INDEXUP>3)<./>">
        </ea:framelabel>

        <ea:framelabel id="FrameLabel29" 
            style="Z-INDEX: 108; LEFT: 170px; POSITION: absolute; TOP: 108px"
            runat="server" 
            Width="100px" 
            Height="17px" 
            Text="W ROKU <.INDEXUP>2)<./>" 
            FrameStyle="BigBold" 
            FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel24" 
            style="Z-INDEX: 109; LEFT: 0px; POSITION: absolute; TOP: 131px" 
            runat="server"
            Width="630px" 
            Height="116px" 
            FrameStyle="SmallBoldYellow">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel25" 
            style="Z-INDEX: 110; LEFT: 1px; POSITION: absolute; TOP: 133px" 
            runat="server"
            Width="89px" 
            Height="7px" 
            Text="Podstawa prawna:" 
            FrameStyle="SmallYellow" 
            FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel26" 
            style="Z-INDEX: 111; LEFT: 76px; POSITION: absolute; TOP: 133px" 
            runat="server"
            Width="555px" Height="28px"
            Text='Art.35 ust.10, art.39 ust.1, art.42 ust.2 pkt 1, art.42a ust.1, art.42e ust.6 ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych (Dz. U. z 2020 r. poz. 1426, z późn. zm.), zwanej dalej „ustawą”; art. 35a ust. 5 ustawy, w brzmieniu obowiązującym przed dniem 26 października 2007 r<.INDEXUP>4)<./>.'
            FrameStyle="SmallYellow" 
            FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel27" 
            style="Z-INDEX: 112; LEFT: 1px; POSITION: absolute; TOP: 151px" 
            runat="server"
            Width="91px" 
            Height="7px" 
            Text="Składający:" 
            FrameStyle="SmallYellow" 
            FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel28" 
            style="Z-INDEX: 113; LEFT: 76px; POSITION: absolute; TOP: 151px" 
            runat="server"
            Width="555px" 
            Height="28px"
            Text="Płatnicy podatku dochodowego od osób fizycznych, a także niebędący płatnikami: rolnicy, osoby fizyczne prowadzące działalność gospodarczą, osoby prawne i ich  jednostki organizacyjne oraz jednostki organizacyjne niemające osobowości prawnej."
            FrameStyle="SmallYellow" 
            FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel30" 
            style="Z-INDEX: 114; LEFT: 1px; POSITION: absolute; TOP: 172px" 
            runat="server"
            Width="91px" 
            Height="7px" 
            Text="Termin składania:" 
            FrameStyle="SmallYellow" 
            FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel31" 
            style="Z-INDEX: 115; LEFT: 76px; POSITION: absolute; TOP: 172px" 
            runat="server"
            Width="555px" 
            Height="56px"
            Text="Do końca stycznia roku następującego po roku podatkowym<.INDEXUP>4)<./> – dla informacji składanych urzędowi skarbowemu; do końca lutego roku następującego po roku podatkowym – dla informacji przesyłanych podatnikowi; w terminie 14 dni od złożenia pisemnego wniosku przez podatnika – w przypadku gdy w trakcie roku podatkowego ustał obowiązek poboru zaliczki przez płatników, o których mowa w art. 39 ust. 1 ustawy; do dnia zaprzestania działalności<.INDEXUP>5)<./> – w przypadku gdy składający zaprzestali działalności przed końcem stycznia lub odpowiednio przed końcem lutego roku następującego po roku podatkowym."
            FrameStyle="SmallYellow" 
            FrameBorderStyle="None">
            </ea:framelabel>
        <ea:framelabel id="FrameLabel32" 
            style="Z-INDEX: 116; LEFT: 1px; POSITION: absolute; TOP: 224px" 
            runat="server"
            Width="91px" 
            Height="7px" 
            Text="Otrzymuje:" 
            FrameStyle="SmallYellow" 
            FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel33" 
            style="Z-INDEX: 117; LEFT: 76px; POSITION: absolute; TOP: 220px" 
            runat="server"
            Width="555px" 
            Height="21px"
            Text="Podatnik oraz urząd skarbowy według miejsca zamieszkania podatnika, a w przypadku podatników, o których mowa w art. 3 ust. 2a ustawy, urząd skarbowy w sprawach opodatkowania osób zagranicznych."
            FrameStyle="SmallYellow" 
            FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel17" 
            style="Z-INDEX: 118; LEFT: 0px; POSITION: absolute; TOP: 245px" 
            runat="server"
            Width="630px" 
            Height="84px" 
            Text="A. MIEJSCE I CEL SKŁADANIA INFORMACJI" 
            FrameStyle="BigYellowBold"
            FrameBorderStyle="DoubleHeader">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel18" 
            style="Z-INDEX: 119; LEFT: 28px; POSITION: absolute; TOP: 273px" 
            runat="server"
            Width="602px" 
            DataMember="A.UrzadSkarb" 
            Height="28px"
            Text="Urząd skarbowy, do którego adresowana jest informacja<.INDEXUP>6)<./>" 
            Number="6">
        </ea:framelabel>
        <ea:framelabel id="Framelabel77" 
            style="Z-INDEX: 120; LEFT: 28px; POSITION: absolute; TOP: 301px" 
            runat="server"
            Width="602px" 
            Height="28px" 
            Text="Cel złożenia formularza <.Normal>(zaznaczyć właściwy kwadrat):<./>"
            Number="7">
        </ea:framelabel>
        <ea:checklabel id="Checklabel10" 
            style="Z-INDEX: 121; LEFT: 219px; POSITION: absolute; TOP: 308px"
            runat="server" 
            Width="136px" 
            DataMember="A.Korekta" 
            Height="14px" 
            Text="złożenie informacji" 
            Number="1"
            NumberAlignLeft="False" 
            ComparedValue="False">
        </ea:checklabel>
        <ea:checklabel id="Checklabel9" 
            style="Z-INDEX: 122; LEFT: 358px; POSITION: absolute; TOP: 308px" 
            runat="server"
            Width="133px" 
            DataMember="A.Korekta" 
            Height="14px" 
            Text="korekta informacji 7)" 
            Number="2"
            NumberAlignLeft="False">
        </ea:checklabel>
        <ea:framelabel id="FrameLabel1" 
            style="Z-INDEX: 123; LEFT: 0px; POSITION: absolute; TOP: 329px" 
            runat="server"
            Width="630px" 
            Height="122px"
            Text="B. DANE IDENTYFIKACYJNE SKŁADAJĄCEGO<br><.Footer>* - dotyczy składającego niebędącego osobą fizyczną ** - dotyczy składającego będącego osobą fizyczną<./>"
            FrameStyle="BigYellowBold" 
            FrameBorderStyle="DoubleHeader">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel3" 
            style="Z-INDEX: 124; LEFT: 28px; POSITION: absolute; TOP: 364px" 
            runat="server"
            Width="602px" 
            Height="28px" 
            Text="Rodzaj składającego <.Normal>(zaznaczyć właściwy kwadrat):<./>"
            Number="8">
        </ea:framelabel>
        <ea:checklabel id="CheckLabel1" 
            style="Z-INDEX: 125; LEFT: 132px; POSITION: absolute; TOP: 371px" 
            runat="server"
            Width="181px" 
            DataMember="B1.OsobaFiz" 
            Height="14px" 
            Text="składający niebędący osobą fizyczną" 
            Number="1"
            NumberAlignLeft="False" 
            ComparedValue="False">
        </ea:checklabel>
        <ea:checklabel id="CheckLabel2" 
            style="Z-INDEX: 126; LEFT: 423px; POSITION: absolute; TOP: 371px" 
            runat="server"
            Width="133px" 
            DataMember="B1.OsobaFiz" 
            Height="14px" 
            Text="osoba fizyczna" 
            Number="2"
            NumberAlignLeft="False">
        </ea:checklabel>
        <ea:framelabel 
            id="FrameLabel20" 
            style="Z-INDEX: 128; LEFT: 28px; POSITION: absolute; TOP: 392px; height: 25px;"
            runat="server" 
            Width="602px" 
            DataMember="NazwaFirma" 
            Text="Nazwa pełna *" 
            SmallerFontLength="70"
            Number="9">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel4" 
            style="Z-INDEX: 129; LEFT: 28px; POSITION: absolute; TOP: 420px; height: 25px;"
            runat="server" 
            Width="602px" 
            DataMember="NazwaOsobaFizycza"
            Text="Nazwisko, pierwsze imię, data urodzenia <.INDEXUP>8)<./>**" 
            SmallerFontLength="70" 
            Number="10">
        </ea:framelabel>
        <ea:framelabel id="Framelabel41" 
            style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 447px" 
            runat="server"
            Width="630px" 
            Height="270px" 
            Text="C. DANE IDENTYFIKACYJNE I ADRES ZAMIESZKANIA PODATNIKA"
            FrameStyle="BigYellowBold" 
            FrameBorderStyle="DoubleHeader">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel9" 
            style="Z-INDEX: 141; LEFT: 28px; POSITION: absolute; TOP: 476px" 
            runat="server"
            Width="602px" 
            Height="28px"
            Text="Rodzaj obowiązku podatkowego podatnika <.Normal>(zaznaczyć właściwy kwadrat)<./>" 
            Number="11">
        </ea:framelabel>
        <ea:checklabel id="CheckLabel7" 
            style="Z-INDEX: 141; LEFT: 74px; POSITION: absolute; TOP: 485px"
            DataMember="C1.Rezydent" 
            runat="server" 
            Width="280px" 
            Height="14px"
            Text="nieograniczony obowiązek podatkowy (rezydent)" 
            Number="1" 
            NumberAlignLeft="False">
        </ea:CheckLabel>
        <ea:checklabel id="CheckLabel8" 
            style="Z-INDEX: 141; LEFT: 355px; POSITION: absolute; TOP: 485px"
            DataMember="C1.Rezydent" 
            runat="server" 
            Width="280px" 
            Height="14px"
            Text="ograniczony obowiązek podatkowy (nierezydent) 9)" 
            Number="2" 
            NumberAlignLeft="False"
            ComparedValue="False">
        </ea:CheckLabel>
        <ea:framelabel id="flPeselNip" 
            style="Z-INDEX: 142; LEFT: 28px; POSITION: absolute; TOP: 504px; width: 301px;"
            runat="server" 
            DataMember="IdentyfikatorPodatnika" 
            Height="28px"
            Text="Identyfikator podatkowy NIP/Numer PESEL <.Indexup>(niepotrzebne skreślić) </Indexup>"
            Number="12">
        </ea:framelabel>
        <ea:framelabel id="Framelabel11" 
            style="Z-INDEX: 142; LEFT: 329px; POSITION: absolute; TOP: 504px; width: 301px;"
            runat="server" 
            DataMember="C1.ZagrNIP"
            Text="Zagraniczny numer identyfikacyjny podatnika <.Normal> <.Indexup>10)" 
            Height="28px" 
            Number="13">
        </ea:framelabel>
        <ea:framelabel id="Framelabel12" 
            style="Z-INDEX: 142; LEFT: 28px; POSITION: absolute; TOP: 532px; width: 301px;"
            runat="server"
            Text="Rodzaj numeru identyfikacyjnego (dokumentu stwierdzającego tożsamość) <.Indexup>11)</.>"
            Height="46px" 
            Number="14">
        </ea:framelabel>
        <ea:framelabel id="Framelabel15" 
            style="Z-INDEX: 142; LEFT: 329px; POSITION: absolute; TOP: 532px; width: 301px;"
            runat="server" 
            DataMember="C1.KrajDok"
            Text="Kraj wydania numeru identyfikacyjnego (dokumentu stwierdzającego tożsamość) <.Indexup>11)</.>"
            Height="46px" 
            Number="15">
        </ea:framelabel>
        <ea:framelabel id="Framelabel103"
            style="Z-INDEX: 143; LEFT: 28px; POSITION: absolute; TOP: 578px; width: 401px;"
            SmallerFontLength="30" 
            runat="server" 
            DataMember="C1.Nazwisko" 
            Height="28px" 
            Text="Nazwisko" 
            Number="16">
        </ea:framelabel>
        <ea:framelabel id="Framelabel104"
            style="Z-INDEX: 144; LEFT: 427px; POSITION: absolute; TOP: 578px; width: 201px;" 
            runat="server"
            DataMember="C1.Imię" 
            Height="28px" 
            Text="Pierwsze imię" 
            Number="17">
        </ea:framelabel>
        <ea:framelabel id="Framelabel105"
            style="Z-INDEX: 145; LEFT: 28px; POSITION: absolute; TOP: 606px; width: 172px;" 
            runat="server"
            ValueStyle="Date" 
            DataMember="C1.DataUrodz" 
            Height="28px" 
            Text="Data urodzenia" 
            Number="18">
        </ea:framelabel>
        <ea:framelabel id="Framelabel106" 
            style="Z-INDEX: 147; LEFT: 200px; POSITION: absolute; TOP: 606px"
            runat="server" 
            Width="200px" 
            DataMember="C2.Kraj" 
            Height="28px" 
            Text="Kraj" 
            Number="19">
        </ea:framelabel>
        <ea:framelabel id="Framelabel107" 
            style="Z-INDEX: 148; LEFT: 399px; POSITION: absolute; TOP: 606px"
            runat="server" 
            Width="228px" 
            DataMember="C2.Wojew" 
            Height="28px" 
            Text="Województwo" 
            Number="20">
        </ea:framelabel>
        <ea:framelabel id="Framelabel108" 
            style="Z-INDEX: 149; LEFT: 28px; POSITION: absolute; TOP: 634px"
            runat="server" 
            Width="401px" 
            DataMember="C2.Powiat" 
            Height="28px" 
            Text="Powiat" 
            Number="21"
            SmallerFontLength="45">
        </ea:framelabel>
        <ea:framelabel id="Framelabel109" 
            style="Z-INDEX: 150; LEFT: 427px; POSITION: absolute; TOP: 634px"
            SmallerFontLength="25" 
            runat="server" 
            Width="201px" 
            DataMember="C2.Gmina" 
            Height="28px" 
            Text="Gmina"
            Number="22">
        </ea:framelabel>
        <ea:framelabel id="Framelabel110" 
            style="Z-INDEX: 151; LEFT: 28px; POSITION: absolute; TOP: 662px"
            runat="server" 
            Width="460px" 
            DataMember="C2.Ulica" 
            Height="28px" 
            Text="Ulica" 
            SmallerFontLength="35"
            Number="23">
        </ea:framelabel>
        <ea:framelabel id="Framelabel111" 
            style="Z-INDEX: 152; LEFT: 490px; POSITION: absolute; TOP: 662px"
            SmallerFontLength="6" 
            runat="server" 
            Width="70px" 
            DataMember="C2.NrDomu" 
            Height="28px" 
            Text="Nr domu"
            Number="24">
        </ea:framelabel>
        <ea:framelabel id="Framelabel112" 
            style="Z-INDEX: 153; LEFT: 560px; POSITION: absolute; TOP: 662px"
            runat="server" 
            Width="70px" 
            DataMember="C2.NrLokalu" 
            Height="28px" 
            Text="Nr lokalu" 
            Number="25">
        </ea:framelabel>
        <ea:framelabel id="Framelabel113" 
            style="Z-INDEX: 154; LEFT: 28px; POSITION: absolute; TOP: 689px"
            SmallerFontLength="32" 
            runat="server" 
            Width="460px" 
            DataMember="C2.Miejsc" 
            Height="28px" 
            Text="Miejscowość"
            Number="26">
        </ea:framelabel>
        <ea:framelabel id="Framelabel114" 
            style="Z-INDEX: 155; LEFT: 490px; POSITION: absolute; TOP: 689px"
            runat="server" 
            Width="140px" 
            ValueStyle="PostalCode" 
            DataMember="C2.KodPoczt" 
            Height="28px"
            Text="Kod pocztowy" 
            Number="27">
        </ea:framelabel>
        <ea:framelabel id="Framelabel116" 
            style="Z-INDEX: 157; LEFT: 0px; POSITION: absolute; TOP: 717px" 
            runat="server"
            Width="630px" 
            Height="107px"
            Text="D. INFORMACJA O KOSZTACH UZYSKANIA PRZYCHODU <.SMALLER>Z TYTUŁU STOSUNKU SŁUŻBOWEGO, STOSUNKU PRACY, SPÓŁDZIELCZEGO STOSUNKU PRACY ORAZ PRACY NAKŁADCZEJ<./>"
            FrameStyle="BigYellowBold" 
            FrameBorderStyle="DoubleHeader">
        </ea:framelabel>
        <ea:framelabel id="Framelabel117" 
            style="Z-INDEX: 158; LEFT: 28px; POSITION: absolute; TOP: 752px"
            runat="server" 
            Width="602px" 
            Height="71px"
            Text="Koszty uzyskania przychodów, wykazane w poz. 30, zostały uwzględnione do wysokości przysługującej podatnikowi <.Normal>(zaznaczyć właściwy kwadrat):<./>"
            Number="28">
            </ea:framelabel>
        <ea:checklabel id="Checklabel3" 
            style="Z-INDEX: 159; LEFT: 44px; POSITION: absolute; TOP: 770px" 
            runat="server"
            Width="287px" 
            DataMember="D.Jeden" 
            Height="14px" 
            Text="z jednego stosunku pracy (stosunków pokrewnych)"
            Number="1" 
            NumberAlignLeft="False" 
            AlignTop="True">
        </ea:checklabel>
        <ea:checklabel id="Checklabel4" 
            style="Z-INDEX: 160; LEFT: 335px; POSITION: absolute; TOP: 770px" 
            runat="server"
            Width="280px" 
            DataMember="D.Wiecej" 
            Height="12px"
            Text="z więcej niż jednego stosunku pracy (stosunków pokrewnych)" 
            Number="2" 
            NumberAlignLeft="False"
            AlignTop="True">
        </ea:checklabel>
        <ea:checklabel id="Checklabel5" 
            style="Z-INDEX: 161; LEFT: 44px; POSITION: absolute; TOP: 787px" 
            runat="server"
            Width="286px" 
            DataMember="D.JedenPodw" 
            Height="14px"
            Text="z jednego stosunku pracy (stosunków pokrewnych), podwyższone w związku z zamieszkiwaniem podatnika poza miejscowością, w której znajduje się zakład pracy"
            Number="3" 
            NumberAlignLeft="False" 
            AlignTop="True">
        </ea:checklabel>
        <ea:checklabel id="Checklabel6" 
            style="Z-INDEX: 162; LEFT: 335px; POSITION: absolute; TOP: 787px" 
            runat="server"
            Width="277px" 
            DataMember="D.WiecejPodw" 
            Height="14px"
            Text="z więcej niż jednego stosunku pracy (stosunków pokrewnych), podwyższone w związku z zamieszkiwaniem podatnika poza miejscowością, w której znajduje się zakład pracy"
            Number="4" 
            NumberAlignLeft="False" 
            AlignTop="True">
        </ea:checklabel>
        <ea:deklaracjafooter id="footer1" 
            style="Z-INDEX: 188; LEFT: 490px; POSITION: absolute; TOP: 930px"
            runat="server" 
            Width="154px" 
            Height="10px" 
            TitleWidth="106" 
            Symbol="PIT-11" 
            PageNumber="1" 
            PageTotal="4"
            Version="26">
        </ea:deklaracjafooter>
        <ea:deklaracjaheader id="DeklaracjaHeader2" 
            style="Z-INDEX: 189; LEFT: 0px; POSITION: absolute; TOP: 978px"
            runat="server" 
            Width="630px" 
            StylNagłówka="PolaJasneWypelniaPlatnik">
        </ea:deklaracjaheader>
        <ea:framelabel id="FrameLabel16"
            style="Z-INDEX: 166; LEFT: 0px; POSITION: absolute; TOP: 1002px; height: 649px;" 
            runat="server"
            Width="630px"
            Text="E. DOCHODY PODATNIKA, POBRANE ZALICZKI ORAZ POBRANE SKŁADKI <.INDEXUP>17)<./><br><.Footer>(część tę wypełniają składający będący płatnikami)<./>"
            FrameStyle="BigYellowBold">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel39"
            style="Z-INDEX: 167; LEFT: 28px; POSITION: absolute; TOP: 1031px; width: 221px;" 
            runat="server"
            Height="36px" 
            Text="Źródła przychodów" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel37"
            style="Z-INDEX: 168; LEFT: 252px; POSITION: absolute; TOP: 1031px; width: 78px; right: 617px;"
            runat="server" 
            ValueStyle="ZlGr" 
            Height="36px" 
            Text="Przychód <.INDEXUP>12)<./>"
            FrameStyle="SmallBoldYellowPit112020" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel40"
            style="Z-INDEX: 169; LEFT: 329px; POSITION: absolute; TOP: 1031px; width: 79px;" 
            runat="server"
            ValueStyle="ZlGr" 
            Height="36px" 
            Text="Koszty uzyskania<br>przychodów <.INDEXUP>13)<./>"
            FrameStyle="SmallBoldYellowPit112020" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel42"
            style="Z-INDEX: 170; LEFT: 406px; POSITION: absolute; TOP: 1031px; width: 80px;" 
            runat="server"
            Height="36px" 
            Text="Dochód<br>(b-c)" 
            FrameStyle="SmallBoldYellowPit112020" 
            HorizontalAlign="Center"
            ValueStyle="ZlGr">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel152"
            style="Z-INDEX: 170; LEFT: 483px; POSITION: absolute; TOP: 1031px; width: 80px;" 
            runat="server"
            Height="36px" 
            Text="Dochód zwolniony <br> od podatku <.INDEXUP>12)<./>;"
            FrameStyle="SmallBoldYellowPit112020" 
            HorizontalAlign="Center" 
            ValueStyle="ZlGr">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel43"
            style="Z-INDEX: 171; LEFT: 560px; POSITION: absolute; TOP: 1031px; width: 69px;" 
            runat="server"
            Height="36px" 
            Text="Zaliczka pobrana<br>przez płatnika <.INDEXUP>14)<./>" 
            FrameStyle="SmallBoldYellowPit112020"
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel38"
            style="Z-INDEX: 172; LEFT: 28px; POSITION: absolute; TOP: 1066px; height: 19px; width: 222px;"
            runat="server" 
            Text="a" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel44"
            style="Z-INDEX: 173; LEFT: 252px; POSITION: absolute; TOP: 1066px; width: 79px;" 
            runat="server"
            Height="19px" 
            Text="b" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel45"
            style="Z-INDEX: 174; LEFT: 329px; POSITION: absolute; TOP: 1066px; height: 19px; width: 76px;"
            runat="server" 
            Text="c" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel46"
            style="Z-INDEX: 175; LEFT: 406px; POSITION: absolute; TOP: 1066px; width: 79px;" 
            runat="server"
            Height="19px" 
            Text="d" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel153"
            style="Z-INDEX: 175; LEFT: 483px; POSITION: absolute; TOP: 1066px; width: 79px;" 
            runat="server"
            Height="19px" 
            Text="e" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel47"
            style="Z-INDEX: 176; LEFT: 560px; POSITION: absolute; TOP: 1066px; width: 67px;" 
            runat="server"
            Height="19px" 
            Text="f" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel48"
            style="Z-INDEX: 177; LEFT: 28px; POSITION: absolute; TOP: 1084px; height: 96px; bottom: 568px; width: 224px;"
            runat="server"
            Text="Należności ze stosunku: pracy, służbowego, spółdzielczego i z pracy nakładczej, wypłacone przez zakład pracy, o którym mowa w art. 31 ustawy oraz płatników, o których mowa w art. 42e ust. 1 ustawy, z wyjątkiem należności wykazanych w wierszu 2."
            FrameStyle="SmallBoldYellow" 
            Number="1" 
            HorizontalAlign="Left"
            FooterText="W poz. 34 należy wykazać przychody, do których zastosowano odliczenie kosztów uzyskania przychodów na podstawie art. 22 ust. 9 pkt 3 ustawy.">
        </ea:framelabel>
        <ea:framelabel id="Framelabel49"
            style="Z-INDEX: 178; LEFT: 252px; POSITION: absolute; TOP: 1084px; width: 77px; height: 56px;"
            SmallerFontLength="18" 
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.1aPrzychód" 
            Number="29">
        </ea:framelabel>
        <ea:framelabel id="Framelabel51"
            style="Z-INDEX: 179; LEFT: 329px; POSITION: absolute; TOP: 1084px; width: 75px; height: 58px;"
            SmallerFontLength="18" 
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.1aKoszty" 
            Number="30">
        </ea:framelabel>
        <ea:framelabel id="Framelabel53"
            style="Z-INDEX: 184; LEFT: 406px; POSITION: absolute; TOP: 1084px; width: 78px; height: 96px;"
            SmallerFontLength="18" 
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.1Dochód" 
            Number="31">
        </ea:framelabel>
        <ea:framelabel id="Framelabel154"
            style="Z-INDEX: 185; LEFT: 483px; POSITION: absolute; TOP: 1084px; width: 78px; height: 96px;"
            SmallerFontLength="18" 
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.1Zwolniony" 
            Number="32">
        </ea:framelabel>
        <ea:framelabel id="Framelabel54"
            style="Z-INDEX: 186; LEFT: 560px; POSITION: absolute; TOP: 1084px; width: 73px; height: 96px;"
            runat="server" 
            ValueStyle="Zl" 
            DataMember="E.1Zaliczka" 
            Number="33">
        </ea:framelabel>
        <ea:framelabel id="Framelabel50"
            style="Z-INDEX: 182; LEFT: 252px; POSITION: absolute; TOP: 1140px; width: 76px; height: 39px;"
            SmallerFontLength="18" 
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.1bPrzychód" 
            Number="34"
            CssClass="style1">
        </ea:framelabel>
        <ea:framelabel id="Framelabel52"
            style="Z-INDEX: 183; LEFT: 329px; POSITION: absolute; TOP: 1140px; width: 76px; height: 39px;" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.1bKoszty" 
            Height="28px" 
            Number="35">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel55"
            style="Z-INDEX: 184; LEFT: 28px; POSITION: absolute; TOP: 1182px; height: 60px; width: 221px; bottom: 400px"
            runat="server"
            Text="Należności z tytułów wymienionych w wierszu 1, otrzymane przez podatników do ukończenia 26. roku życia <font STYLE='font-size: 5pt;'><.INDEXUP>15)<./></font>"
            FrameStyle="SmallBoldYellow" 
            Number="2" 
            HorizontalAlign="Left"
            FooterText="W poz. 41 należy wykazać przychody, do których zastosowano odliczenie kosztów uzyskania przychodów na podstawie art. 22 ust 9 pkt 3 ustawy.">
        </ea:framelabel>
        <ea:framelabel id="Framelabel57"
            style="Z-INDEX: 185; LEFT: 252px; POSITION: absolute; TOP: 1182px; width: 78px; height: 25px;"
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.2aPrzychód" 
            Number="36">
        </ea:framelabel>
        <ea:framelabel id="Framelabel59"
            style="Z-INDEX: 186; LEFT: 329px; POSITION: absolute; TOP: 1182px; width: 77px; height: 25px;"
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.2aKoszty" 
            Number="37" 
            CssClass="style1">
        </ea:framelabel>
        <ea:framelabel id="Framelabel60"
            style="Z-INDEX: 193; LEFT: 406px; POSITION: absolute; TOP: 1182px; width: 78px; height: 60px;"
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.2Dochód" 
            Number="38">
        </ea:framelabel>
        <ea:framelabel id="Framelabel62"
            style="Z-INDEX: 191; LEFT: 252px; POSITION: absolute; TOP: 1210px; width: 75px; height: 35px" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.2bPrzychód" 
            Number="41">
        </ea:framelabel>
        <ea:framelabel id="Framelabel64"
            style="Z-INDEX: 192; LEFT: 329px; POSITION: absolute; TOP: 1210px; width: 79px; height: 35px" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.2bKoszty" 
            Number="42">
        </ea:framelabel>
        <ea:framelabel id="Framelabel156"
            style="Z-INDEX: 193; LEFT: 483px; POSITION: absolute; TOP: 1182px; width: 79px; height: 60px" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.2Zwolniony" 
            Number="39">
        </ea:framelabel>
        <ea:framelabel id="Framelabel65"
            style="Z-INDEX: 194; LEFT: 560px; POSITION: absolute; TOP: 1182px; width: 71px; height: 60px" 
            runat="server"
            ValueStyle="Zl" 
            DataMember="E.2Zaliczka" 
            Number="40">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel66"
            style="Z-INDEX: 195; LEFT: 28px; POSITION: absolute; TOP: 1245px; height: 25px; width: 221px;"
            runat="server" 
            Text="Emerytury - renty zagraniczne"
            FrameStyle="SmallBoldYellow"
            Number="3" 
            HorizontalAlign="Left">
        </ea:framelabel>
        <ea:framelabel id="Framelabel72"
            style="Z-INDEX: 196; LEFT: 252px; POSITION: absolute; TOP: 1245px; right: 591px; width: 75px; Height: 25px"
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.3Przychód" 
            Number="43">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel72a"
            style="Z-INDEX: 197; LEFT: 329px; POSITION: absolute; TOP: 1245px; height: 25px; width: 79px;"
            runat="server" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="Framelabel85"
            style="Z-INDEX: 197; LEFT: 406px; POSITION: absolute; TOP: 1245px; width: 74px; Height: 25px" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.3Dochód" 
            Number="44">
        </ea:framelabel>
        </ea:framelabel>
        <ea:framelabel id="Framelabel91"
            style="Z-INDEX: 198; LEFT: 483px; POSITION: absolute; TOP: 1245px; width: 79px; Height: 25px" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.3Zwolniony" 
            Number="45">
        </ea:framelabel>
        <ea:framelabel id="Framelabel201"
            style="Z-INDEX: 198; LEFT: 560px; POSITION: absolute; TOP: 1245px; width: 72px; Height: 25px" 
            runat="server"
            ValueStyle="Zl" 
            DataMember="E.3Zaliczka" 
            Number="46">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel67"
            style="Z-INDEX: 199; LEFT: 28px; POSITION: absolute; TOP: 1273px; height: 48px; width: 225px;"
            runat="server" 
            Text="Działalność wykonywana osobiście, o której mowa w art. 13 pkt. 2, 4-9 ustawy, w tym umowy o dzieło oraz czynności związane z pełnieniem obowiązków społecznych lub obywatelskich, z wyjątkiem należności wykazanych w wierszach 5 i 6"
            FrameStyle="SmallBoldYellow" 
            Number="4" 
            HorizontalAlign="Left">
        </ea:framelabel>
        <ea:framelabel id="Framelabel73"
            style="Z-INDEX: 200; LEFT: 252px; POSITION: absolute; TOP: 1273px; width: 77px; height: 46px;" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.4Przychód" 
            Number="47">
        </ea:framelabel>
        <ea:framelabel id="Framelabe202"
            style="Z-INDEX: 201; LEFT: 329px; POSITION: absolute; TOP: 1273px; width: 79px; height: 46px;" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.4Koszty" 
            Number="48">
        </ea:framelabel>
        <ea:framelabel id="Framelabel86"
            style="Z-INDEX: 201; LEFT: 406px; POSITION: absolute; TOP: 1273px; width: 79px; height: 46px;" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.4Dochód" 
            Number="49">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel86a"
            style="Z-INDEX: 292; LEFT: 483px; POSITION: absolute; TOP: 1273px; height: 165px; width: 79px;"
            runat="server" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="Framelabel92"
            style="Z-INDEX: 293; LEFT: 560px; POSITION: absolute; TOP: 1273px; width: 69px; height: 46px;" 
            runat="server"
            ValueStyle="Zl" 
            DataMember="E.4Zaliczka" 
            Height="26px" 
            Number="50">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel97"
            style="Z-INDEX: 203; LEFT: 28px; POSITION: absolute; TOP: 1322px; height: 30px; width: 222px;"
            runat="server"
            Text="Należność z tytułu umowy zlecenie, o której mowa w art. 13 pkt 8 ustawy, z wyjątkiem należności wykazanych w wierszu 6"
            FrameStyle="SmallBoldYellow" 
            Number="5" 
            HorizontalAlign="Left">
        </ea:framelabel>
        <ea:framelabel id="Framelabel74"
            style="Z-INDEX: 203; LEFT: 252px; POSITION: absolute; TOP: 1322px; width: 75px; height: 30px;"
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.5Przychód" 
            Number="51"></ea:framelabel>
        <ea:framelabel id="Framelabel100"
            style="Z-INDEX: 203; LEFT: 329px; POSITION: absolute; TOP: 1322px; width: 76px; height: 30px;"
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.5Koszty" 
            Number="52">
        </ea:framelabel>
        <ea:framelabel id="Framelabel87"
            style="Z-INDEX: 203; LEFT: 406px; POSITION: absolute; TOP: 1322px; width: 79px; right: 482px; height: 30px;"
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.5Dochód" 
            Number="53">
        </ea:framelabel>
        <ea:framelabel id="Framelabel93"
            style="Z-INDEX: 293; LEFT: 560px; POSITION: absolute; TOP: 1322px; width: 69px; height: 30px;"
            runat="server" 
            ValueStyle="Zl" 
            DataMember="E.5Zaliczka" 
            Number="54">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel68"
            style="Z-INDEX: 205; LEFT: 28px; POSITION: absolute; TOP: 1350px; width: 222px; height: 30px;" 
            runat="server"
            Text="Należności z tytułu wymienionego w wierszu 5, otrzymane przez podatnika do ukończenia 26. roku życia<font STYLE='font-size: 5pt;'><.INDEXUP>15)<./></font>"
            FrameStyle="SmallBoldYellow" 
            Number="6" 
            HorizontalAlign="Left"></ea:framelabel>
        <ea:framelabel id="Framelabel98"
            style="Z-INDEX: 206; LEFT: 252px; POSITION: absolute; TOP: 1350px; right: 591px; width: 78px; height: 30px;"
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.6Przychód" 
            Number="55" 
            CssClass="style1">
        </ea:framelabel>
        <ea:framelabel id="Framelabel80"
            style="Z-INDEX: 207; LEFT: 329px; POSITION: absolute; TOP: 1350px; width: 76px; height: 30px;" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.6Koszty" 
            Number="56" 
            CssClass="style1">
        </ea:framelabel>
        <ea:framelabel id="Framelabel118"
            style="Z-INDEX: 208; LEFT: 406px; POSITION: absolute; TOP: 1350px; width: 74px; bottom: 428px; height: 30px;"
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.6Dochód" 
            Number="57">
        </ea:framelabel>
        <ea:framelabel id="Framelabel120"
            style="Z-INDEX: 293; LEFT: 560px; POSITION: absolute; TOP: 1350px; bottom: 481px; width: 69px; height: 30px;"
            runat="server" 
            ValueStyle="Zl" 
            DataMember="E.6Zaliczka" 
            Number="58">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel126"
            style="Z-INDEX: 210; LEFT: 28px; POSITION: absolute; TOP: 1378px; width: 226px; height: 60;" 
            runat="server"
            Text="Prawa autorskie i inne prawa, o których mowa w art. 18 ustawy"
            FrameStyle="SmallBoldYellow" 
            Number="7" 
            HorizontalAlign="Left"
            FooterText="W poz. 62 należy wykazać przychody, do których zastosowano koszty uzyskania przychodów na podstawie art. 22 ust. 9 pkt 1-3 ustawy.">
        </ea:framelabel>
        <ea:framelabel id="Framelabel135"
            style="Z-INDEX: 211; LEFT: 252px; POSITION: absolute; TOP: 1378px; width: 79px; height: 32;" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.7Przychód" 
            Height="28px" 
            Number="59">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel135a"
            style="Z-INDEX: 212; LEFT: 329px; POSITION: absolute; TOP: 1378px; height: 32px; width: 79px;"
            runat="server" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="Framelabel141"
            style="Z-INDEX: 217; LEFT: 406px; POSITION: absolute; TOP: 1378px; width: 78px; height: 60;" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.7Dochód" 
            Number="60">
        </ea:framelabel>
        <ea:framelabel id="Framelabel143"
            style="Z-INDEX: 293; LEFT: 560px; POSITION: absolute; TOP: 1378px; width: 72px; height: 60;" 
            runat="server"
            ValueStyle="Zl" 
            DataMember="E.7Zaliczka" 
            Number="61">
        </ea:framelabel>
        <ea:framelabel id="Framelabel2"
            style="Z-INDEX: 215; LEFT: 252px; POSITION: absolute; TOP: 1413px; width: 76px; height: 31;"
            SmallerFontLength="18" 
            runat="server" 
            ValueStyle="ZlGr" 
            DataMember="E.7bPrzychód" 
            Number="62"
            CssClass="style1">
        </ea:framelabel>
        <ea:framelabel id="Framelabel5" 
            style="Z-INDEX: 216; LEFT: 329px; POSITION: absolute; TOP: 1413px; width: 76px; height: 31;"
            runat="server" 
            ValueStyle="ZlGr" 
            Height="28px" 
            DataMember="E.7Koszty" 
            Number="63">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel70"
            style="Z-INDEX: 225; LEFT: 28px; POSITION: absolute; TOP: 1441px; width: 222px; height: 26;" 
            runat="server"
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left" 
            Number="8"
            Text="Inne źródła<font STYLE='font-size: 5pt;'><.INDEXUP>16)<./></font>">
        </ea:framelabel>
        <ea:framelabel id="Framelabel76"
            style="Z-INDEX: 226; LEFT: 252px; POSITION: absolute; TOP: 1441px; width: 78px;" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.8Przychód" 
            Height="28px" 
            Number="64">
        </ea:framelabel>
        <ea:framelabel id="Framelabe203"
            style="Z-INDEX: 227; LEFT: 329px; POSITION: absolute; TOP: 1441px; width: 79px;" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.8Koszty" 
            Height="28px" 
            Number="65" 
            CssClass="style1">
        </ea:framelabel>
        <ea:framelabel id="Framelabel89"
            style="Z-INDEX: 227; LEFT: 406px; POSITION: absolute; TOP: 1441px; width: 78px;" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.8Dochód" 
            Height="28px" 
            Number="66" 
            CssClass="style1">
        </ea:framelabel>
        <ea:framelabel id="Framelabel157"
            style="Z-INDEX: 293; LEFT: 483px; POSITION: absolute; TOP: 1441px; width: 78px;" 
            runat="server"
            ValueStyle="ZlGr" 
            DataMember="E.8Zwolniony" 
            Height="28px" 
            Number="67" 
            CssClass="style1">
        </ea:framelabel>
        <ea:framelabel id="Framelabel95"
            style="Z-INDEX: 294; LEFT: 560px; POSITION: absolute; TOP: 1441px; width: 69px;" 
            runat="server"
            ValueStyle="Zl" 
            DataMember="E.8Zaliczka" 
            Height="28px" 
            Number="68">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel36"
            style="Z-INDEX: 229; LEFT: 28px; POSITION: absolute; TOP: 1469px; width: 412px;" runat="server"
            Height="26px"
            Text="Składki na ubezpieczenia społeczne, o których mowa w przepisach ustawy, podlegające odliczeniu od dochodów, <font STYLE='font-size: 5pt;'><.INDEXUP>17)<./></font> w tym zagraniczne, o których mowa w art. 26 ust. 1 pkt 2a ustawy, z wyjątkiem wykazanych w poz. 70"
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left">
        </ea:framelabel>
        <ea:framelabel id="Framelabel99" 
            style="Z-INDEX: 295; LEFT: 441px; POSITION: absolute; TOP: 1469px"
            runat="server" 
            Width="192px" 
            ValueStyle="ForceZlGr" 
            DataMember="E.SpołeczneRazem" 
            Height="28px" 
            Number="69">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel149"
            style="Z-INDEX: 230; LEFT: 28px; POSITION: absolute; TOP: 1497px; width: 412px;" 
            runat="server"
            Height="26px" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left"
            Text="Składki na ubezpieczenia społeczne, o których mowa w przepisach ustawy, <font STYLE='font-size: 5pt;'><.INDEXUP>17)<./></font> w tym zagraniczne, o których mowa w art. 26 ust. 1 pkt 2a ustawy, których podstawę stanowi przychód wymieniony w wierszach 2 i 6 części E">
        </ea:framelabel>
        <ea:framelabel id="Framelabel148" 
            style="Z-INDEX: 230; LEFT: 441px; POSITION: absolute; TOP: 1497px"
            runat="server" 
            Width="192px" 
            ValueStyle="ForceZlGr" 
            DataMember="E.Społeczne26Razem" 
            Height="28px" 
            Number="70">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel63"
            style="Z-INDEX: 231; LEFT: 28px; POSITION: absolute; TOP: 1525px; width: 412px;" 
            runat="server"
            Height="28px"
            Text="Składki na ubezpieczenia społeczne, o których mowa w przepisach ustawy, których podstawę wymiaru stanowi przychód zwolniony na podstawie art. 21 ust. 1 pkt 148 ustawy, wykazany w poz. 86"
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left">
        </ea:framelabel>
        <ea:framelabel id="Framelabel119" 
            style="Z-INDEX: 232; LEFT: 441px; POSITION: absolute; TOP: 1525px"
            runat="server" 
            Width="192px" 
            ValueStyle="ForceZlGr" 
            DataMember="E.Społeczne26Zwol" 
            Height="28px" 
            Number="71">
        </ea:framelabel>

        <ea:framelabel id="FrameLabel151"
            style="Z-INDEX: 232; LEFT: 28px; POSITION: absolute; TOP: 1553px; width: 412px;" 
            runat="server"
            Height="28px" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left"
            Text="Składki na ubezpieczenie zdrowotne, o których mowa w przepisach ustawy, podlegające odliczeniu od podatku <font STYLE='font-size: 5pt;'><.INDEXUP>17)<./></font>, w tym zagraniczne, o których mowa w art. 27b ust. 1pkt 2 ustawy, z wyjątkiem wykazanych w poz. 73">
        </ea:framelabel>
        <ea:framelabel id="Framelabel150" 
            style="Z-INDEX: 232; LEFT: 441px; POSITION: absolute; TOP: 1553px"
            runat="server" 
            Width="192px" 
            ValueStyle="ForceZlGr" 
            DataMember="E.ZdrDoOdliczRazem" 
            Height="28px"
            Number="72">
        </ea:framelabel>

        <ea:framelabel id="FrameLabel210"
            style="Z-INDEX: 232; LEFT: 28px; POSITION: absolute; TOP: 1581px; width: 412px;" 
            runat="server"
            Height="28px" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left"
            Text="Składki na ubezpieczenie zdrowotne, o których mowa w przepisach ustawy, <font STYLE='font-size: 5pt;'><.INDEXUP>17)<./></font>, w tym zagraniczne, o których mowa w art. 27b ust. 1 pkt 2 ustawy, których podstawę stanowi przychód wymieniony w wierszach 2 i 6 części E">
        </ea:framelabel>
        <ea:framelabel id="Framelabel211" 
            style="Z-INDEX: 232; LEFT: 441px; POSITION: absolute; TOP: 1581px"
            runat="server" 
            Width="192px" 
            ValueStyle="ForceZlGr" 
            DataMember="E.ZdrDoOdlicz26Razem" 
            Height="28px"
            Number="73">
        </ea:framelabel>

        <ea:framelabel id="FrameLabel212"
            style="Z-INDEX: 232; LEFT: 28px; POSITION: absolute; TOP: 1609px; width: 412px;" 
            runat="server"
            Height="42px" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left"
            Text="Składki na ubezpieczenie zdrowotne, o których mowa w przepisach ustawy, których podstawę wymiaru stanowi przychód zwolniony na podstawie art. 21 ust. 1 pkt 148 ustawy, wykazany w poz 86."
            FooterText="W poz. 74 należy wykazać składki do wysokości 7,75% podstawy ich wymiaru.">
        </ea:framelabel>
        <ea:framelabel id="Framelabel213" 
            style="Z-INDEX: 232; LEFT: 441px; POSITION: absolute; TOP: 1609px"
            runat="server" 
            Width="192px" 
            ValueStyle="ForceZlGr" 
            DataMember="E.ZdrDoOdlicz26Zwol" 
            Height="42px"
            Number="74">
        </ea:framelabel>

        <ea:framelabel id="Framelabel121"
            style="Z-INDEX: 233; LEFT: 0px; POSITION: absolute; TOP: 1650px; height: 190px;" runat="server"
            Width="630px"
            Text="F. <font STYLE='font-size: 10pt;'>INFORMACJA O WYSOKOŚCI PRZYCHODÓW, O KTÓRYCH MOWA W ART. 20 UST. 1 USTAWY</font><br><.Footer>(część tę wypełniają składający niebędący płatnikami, o których mowa w art. 42a ustawy, w tym rolnicy)<./>"
            FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
        <ea:framelabel id="FrameLabel58" 
            style="Z-INDEX: 235; LEFT: 28px; POSITION: absolute; TOP: 1699px"
            runat="server" 
            Width="399px" 
            Height="28px" 
            Text="Rodzaj przychodu (wymienić):" 
            FrameStyle="SmallBoldYellow"
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="Framelabel78" 
            style="Z-INDEX: 235; LEFT: 427px; POSITION: absolute; TOP: 1699px"
            runat="server" 
            Width="203px" 
            Height="28px" 
            Text="Przychód" 
            FrameStyle="SmallBoldYellow"
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel21" 
            style="Z-INDEX: 235; LEFT: 28px; POSITION: absolute; TOP: 1727px"
            runat="server" 
            Width="399px" 
            Height="28px" 
            Text="Wynagrodzenie z tytułu umowy o pomocy przy zbiorach"
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left">
        </ea:framelabel>
        <ea:framelabel 
            id="Framelabel22" 
            style="Z-INDEX: 237; LEFT: 427px; POSITION: absolute; TOP: 1727px"
            runat="server" 
            Width="203px" 
            ValueStyle="ForceZlGr" 
            DataMember="F.1Przychód" 
            Height="28px" 
            Number="75">
        </ea:framelabel>
        <ea:framelabel id="Framelabel6" 
            style="Z-INDEX: 238; LEFT: 28px; POSITION: absolute; TOP: 1755px" 
            runat="server"
            Width="399px" 
            DataMember="F.2Opis" 
            Height="28px" 
            Number="76">
        </ea:framelabel>
        <ea:framelabel id="Framelabel7" 
            style="Z-INDEX: 239; LEFT: 427px; POSITION: absolute; TOP: 1755px"
            runat="server" 
            Width="203px" 
            ValueStyle="ForceZlGr" 
            DataMember="F.2Przychód"
            Height="28px" 
            Number="77">
        </ea:framelabel>
        <ea:framelabel id="Framelabel8" 
            style="Z-INDEX: 240; LEFT: 28px; POSITION: absolute; TOP: 1783px" 
            runat="server"
            Width="399px" 
            DataMember="F.3Opis" 
            Height="28px" 
            Number="78">
        </ea:framelabel>
        <ea:framelabel id="Framelabel10" 
            style="Z-INDEX: 241; LEFT: 427px; POSITION: absolute; TOP: 1783px"
            runat="server" 
            Width="203px" 
            ValueStyle="ForceZlGr" 
            DataMember="F.3Przychód" 
            Height="28px" 
            Number="79">
        </ea:framelabel>
        <ea:framelabel id="Framelabel13" 
            style="Z-INDEX: 242; LEFT: 28px; POSITION: absolute; TOP: 1811px"
            runat="server" 
            Width="399px" 
            DataMember="F.4Opis" 
            Height="28px" 
            Number="80">
        </ea:framelabel>
        <ea:framelabel id="Framelabel34" 
            style="Z-INDEX: 243; LEFT: 427px; POSITION: absolute; TOP: 1811px"
            runat="server" 
            Width="203px" 
            ValueStyle="ForceZlGr" 
            DataMember="F.4Przychód" 
            Height="28px" 
            Number="81">
        </ea:framelabel>

        <ea:deklaracjafooter id="footer2" 
            style="Z-INDEX: 249; LEFT: 0px; POSITION: absolute; TOP: 1907px"
            runat="server" 
            Width="154px" 
            Height="10px" 
            TitleWidth="106" 
            Symbol="PIT-11" 
            PageNumber="2" 
            PageTotal="4"
            Version="26">
        </ea:deklaracjafooter>
        <ea:framelabel id="flDanePodatnika1"
            style="Z-INDEX: 249; LEFT: 199px; POSITION: absolute; TOP: 1907px; height: 21px; width: 427px; right: 275px;"
            runat="server" 
            Text="?" 
            FrameStyle="Middle" 
            FrameBorderStyle="None" 
            HorizontalAlign="Right"
            VerticalAlign="Bottom">
        </ea:framelabel>
        <ea:deklaracjaheader id="DeklaracjaHeader3" 
            style="Z-INDEX: 249; LEFT: 0px; POSITION: absolute; TOP: 1960px"
            runat="server" 
            Width="630px" 
            StylNagłówka="PolaJasneWypelniaPlatnik">
        </ea:deklaracjaheader>

        <ea:framelabel id="FrameLabel61"
            style="Z-INDEX: 249; LEFT: 0px; POSITION: absolute; TOP: 1980px; height: 80px;" 
            runat="server"
            Width="630px"
            FrameStyle="BigYellowBold">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel35" 
            style="Z-INDEX: 250; LEFT: 28px; POSITION: absolute; TOP: 1980px"
            runat="server" 
            Width="399px" 
            Height="28px" 
            Text="Razem" 
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left"
            FooterText="Suma kwot z poz.: 75, 77, 79 i 81.">
        </ea:framelabel>
        <ea:framelabel id="Framelabel56" 
            style="Z-INDEX: 250; LEFT: 427px; POSITION: absolute; TOP: 1980px"
            runat="server" 
            Width="203px" 
            ValueStyle="ForceZlGr" 
            DataMember="F.Przychód" 
            Height="28px" 
            Number="82">
        </ea:framelabel>

        <ea:framelabel id="Framelabel69"
            style="Z-INDEX: 250; LEFT: 0px; POSITION: absolute; TOP: 2008px; height: 228px;" 
            runat="server"
            Width="630px"
            Text="G. <font STYLE='font-size: 10pt;'>INFORMACJA O PRZYCHODACH ZWOLNIONYCH OD PODATKU ORAZ O ZAŁĄCZNIKU</font><br><.Footer>(część tę wypełniają składający będący płatnikami)<./>"
            FrameStyle="BigYellowBold" 
            FrameBorderStyle="DoubleHeader">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel75" 
            style="Z-INDEX: 251; LEFT: 28px; POSITION: absolute; TOP: 2040px"
            runat="server" 
            Width="399px" 
            Height="28px"
            Text="Przychody z tytułu stypendium, o którym mowa w art. 21 ust. 1 pkt 40b ustawy <br><br> <.NORMAL> Należy wykazać kwotę przychodu, do wysokości limitu zwolnienia <font STYLE='font-size: 5pt;'><.INDEXUP>18)<./></font><./> "
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left"
            FooterText="">
        </ea:framelabel>
        <ea:framelabel id="Framelabel79" 
            style="Z-INDEX: 252; LEFT: 427px; POSITION: absolute; TOP: 2040px"
            runat="server" 
            Width="203px" 
            ValueStyle="ForceZlGr" 
            DataMember="G.PrzychódTytStyp" 
            Height="28px"
            Number="83">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel81" 
            style="Z-INDEX: 253; LEFT: 28px; POSITION: absolute; TOP: 2068px"
            runat="server" 
            Width="399px" 
            Height="28px"
            Text="Przychody otrzymywane z zagranicy, o których mowa w art. 21 ust. 1 pkt 74 ustawy, między innymi renty inwalidzkie z tytułu inwalidztwa wojennego"
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left">
        </ea:framelabel>
        <ea:framelabel 
            id="Framelabel82" 
            style="Z-INDEX: 254; LEFT: 427px; POSITION: absolute; TOP: 2068px"
            runat="server" 
            Width="203px" 
            ValueStyle="ForceZlGr" 
            DataMember="G.ZZagranicy" 
            Height="28px" 
            Number="84">
        </ea:framelabel>








        <ea:framelabel id="FrameLabel83" 
            style="Z-INDEX: 255; LEFT: 28px; POSITION: absolute; TOP: 2096px"
            runat="server" 
            Width="399px" 
            Height="28px"
            Text="Przychody pochodzące ze środków bezzwrotnej pomocy zagranicznej, o których mowa w art. 21 ust. 1 pkt 46 ustawy"
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left">
        </ea:framelabel>
        <ea:framelabel id="Framelabel84" 
            style="Z-INDEX: 255; LEFT: 427px; POSITION: absolute; TOP: 2096px"
            runat="server" 
            Width="203px" 
            ValueStyle="ForceZlGr" 
            DataMember="G.PomocBezzwrotna" 
            Height="28px"
            Number="85">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel231" 
            style="Z-INDEX: 255; LEFT: 28px; POSITION: absolute; TOP: 2124px"
            runat="server" 
            Width="399px" 
            Height="28px"
            Text="Przychody ze stosunku pracy i stosunków pokrewnych oraz umów zlecenie, o których mowa w art. 21 ust. 1 pkt 148 ustawy <br> <.NORMAL> Należy wykazać kwotę przychodu, do wysokości limitu zwolnienia <font STYLE='font-size: 5pt;'><.INDEXUP>19)<./></font><./> "
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left"
            FooterText="">
        </ea:framelabel>
        <ea:framelabel id="Framelabel232" 
            style="Z-INDEX: 255; LEFT: 427px; POSITION: absolute; TOP: 2124px"
            runat="server" 
            Width="203px" 
            ValueStyle="ForceZlGr" 
            DataMember="G.PrzychódZwolniony26" 
            Height="28px"
            Number="86">
        </ea:framelabel>

        <ea:framelabel id="FrameLabel233" 
            style="Z-INDEX: 255; LEFT: 80px; POSITION: absolute; TOP: 2152px"
            runat="server" 
            Width="399px" 
            Height="28px"
            Text="W tym przychody ze stosunku pracy i stosunków pokrewnych"
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left"
            FooterText="">
        </ea:framelabel>
        <ea:framelabel id="Framelabel234" 
            style="Z-INDEX: 255; LEFT: 427px; POSITION: absolute; TOP: 2152px"
            runat="server" 
            Width="203px" 
            ValueStyle="ForceZlGr" 
            DataMember="G.PrzychódZwolniony26Etat" 
            Height="28px"
            Number="87">
        </ea:framelabel>

        <ea:framelabel id="FrameLabel235" 
            style="Z-INDEX: 255; LEFT: 80px; POSITION: absolute; TOP: 2180px"
            runat="server" 
            Width="399px" 
            Height="28px"
            Text="W tym przychody z umów zlecenia"
            FrameStyle="SmallBoldYellow" 
            HorizontalAlign="Left"
            FooterText="">
        </ea:framelabel>
        <ea:framelabel id="Framelabel236" 
            style="Z-INDEX: 255; LEFT: 427px; POSITION: absolute; TOP: 2180px"
            runat="server" 
            Width="203px" 
            ValueStyle="ForceZlGr" 
            DataMember="G.PrzychódZwolniony26Umowa" 
            Height="28px"
            Number="88">
        </ea:framelabel>

        <ea:framelabel id="Framelabel137" 
            style="Z-INDEX: 256; LEFT: 28px; POSITION: absolute; TOP: 2208px"
            runat="server" 
            Width="602px" 
            Height="28px"
            Text="Do niniejszej informacji dołączono informację PIT-R <.Normal>(należy zaznaczyć właściwy kwadrat):<./>"
            Number="89">
        </ea:framelabel>
        <ea:checklabel id="Checklabel_82_T" 
            style="Z-INDEX: 257; LEFT: 161px; POSITION: absolute; TOP: 2218px"
            runat="server" 
            Width="35px" 
            DataMember="G.PITR" 
            Height="14px" 
            Text="tak"
            Number="1" 
            NumberAlignLeft="False">
        </ea:checklabel>
        <ea:checklabel id="Checklabel_82_N" style="Z-INDEX: 258; LEFT: 328px; POSITION: absolute; TOP: 2218px"
            runat="server" 
            Width="35px" 
            DataMember="G.PITR" 
            Height="14px" 
            Text="nie" 
            Number="2" 
            NumberAlignLeft="False"
            ComparedValue="False">
        </ea:checklabel>
        <ea:framelabel id="FrameLabel122"
            style="Z-INDEX: 259; LEFT: 0px; POSITION: absolute; TOP: 2238px; height: 86px;" 
            runat="server" 
            Width="630px"
            Text="H. <font STYLE='font-size: 10pt;'>PODPIS PŁATNIKA LUB OSOBY WYZNACZONEJ DO OBLICZENIA I POBRANIA PODATKU / PEŁNOMOCNIKA PŁATNIKA</font><.Indexup>20)<./><br><.Footer>"
            FrameStyle="BigYellowBold" 
            FrameBorderStyle="DoubleHeader">
        </ea:framelabel>
        <ea:framelabel id="flPodpis1" 
            style="Z-INDEX: 260; LEFT: 28px; POSITION: absolute; TOP: 2273px" 
            runat="server"
            Width="601px" 
            Height="45px"
            Text="Imię, nazwisko, podpis albo nadruk z imieniem nazwiskiem oraz stanowiskiem służbowym" 
            Number="90">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel88" 
            style="Z-INDEX: 259; LEFT: 0px; POSITION: absolute; TOP: 2316px; height: 80px;"
            runat="server" 
            Width="630px"
            Text="I. <font STYLE='font-size: 10pt;'>PODPIS OSOBY UPOWAŻNIONEJ DO SPORZĄDZENIA INFORMACJI</font><.Indexup>21)<./><br><.Footer>"
            FrameStyle="BigYellowBold" 
            FrameBorderStyle="DoubleHeader">
        </ea:framelabel>
        <ea:framelabel id="flPodpis2" 
            style="Z-INDEX: 260; LEFT: 28px; POSITION: absolute; TOP: 2351px" 
            runat="server"
            Width="601px" 
            Height="45px"
            Text="Imię, nazwisko, podpis albo nadruk z imieniem nazwiskiem oraz stanowiskiem służbowym" 
            Number="91">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel147" 
            style="Z-INDEX: 261; LEFT: 3px; POSITION: absolute; TOP: 2398px"
            runat="server" 
            Width="627px" 
            Height="30px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>1)<./> <font STYLE='font-size: 6pt;'>W przypadku przedsiębiorstwa w spadku, należy podać identyfikator podatkowy NIP zmarłego przedsiębiorcy."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel101" style="Z-INDEX: 262; LEFT: 3px; POSITION: absolute; TOP: 2413px"
            runat="server" 
            Width="627px" 
            Height="40px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>2)<./> <font STYLE='font-size: 6pt;'>Jeżeli w odniesieniu do dochodów (przychodów) osoby fizycznej, uzyskanych w roku, o którym mowa w poz. 4, składający sporządza i przesyła więcej niż jedną informację PIT-11 (niebędącą korektą poprzedniej), w informacji tej nie uwzględnia się kwot wykazanych w uprzednio przesyłanych informacjach (nie sumuje się ich). W przypadku gdy sporządzone i przesłane w trakcie roku podatkowego informacje PIT-11 zawierają kompletne dane niezbędne do sporządzenia zeznania podatkowego, płatnik nie przesyła informacji PIT-11 po zakończeniu roku."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel102" 
            style="Z-INDEX: 263; LEFT: 3px; POSITION: absolute; TOP: 2456px"
            runat="server" 
            Width="627px" 
            Height="24px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>3)<./> <font STYLE='font-size: 6pt;'>Jeżeli w odniesieniu do dochodów (przychodów) osoby fizycznej, uzyskanych w roku, o którym mowa w poz 4, składający sporządza i przesyła więcej niż jedną informację PIT-11 (niebędącą korektą poprzedniej), należy podaj kolejny numer składanej informacji dotyczącej tego roku podatkowego."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel123" 
            style="Z-INDEX: 264; LEFT: 3px; POSITION: absolute; TOP: 2481px"
            runat="server" 
            Width="627px" 
            Height="39px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>4)<./> <font STYLE='font-size: 6pt;'>Art. 35a ustawy został uchylony z dniem 26 października 2007 r. ustawą z dnia 24 sierpnia 2007 r. o zmianie ustawy o promocji zatrudnienia i instytucjach rynku pracy oraz o zmianie niektórych innych ustaw (Dz. U. poz 1243). Uchylony przepis na mocy art. 7 ust. 7 powołanej ustawy ma zastosowanie do płatników do czasu obowiązywania umowy aktywizacyjnej zawartej przed dniem 26 października 2007 r. W tym przypadku płatnik przekazuje informacje podatnikowi i urzędowi skarbowemu w terminie do końca lutego roku następującego po roku podatkowym."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel124" style="Z-INDEX: 265; LEFT: 3px; POSITION: absolute; TOP: 2522px"
            runat="server" 
            Width="627px" 
            Height="36px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>5)<./> <font STYLE='font-size: 6pt;'>W przypadku przedsiębiorstwa w spadku za dzień zaprzestania działalności uważa się dzień wygaśnięcia zarządu sukcesyjnego albo wygaśnięcia uprawnienia do powołania zarządcy sukcesyjnego, jeżeli zarząd sukcesyjny nie został ustanowiony i dokonano zgłoszenia, o którym mowa w art. 12 ust. 1c ustawy z dnia 13 października 1995 r. o zasadach ewidencji i identyfikacji podatników i płatników (Dz. U. z 2020 r. poz. 170)."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel125" 
            style="Z-INDEX: 266; LEFT: 3px; POSITION: absolute; TOP: 2556px"
            runat="server" 
            Width="627px" 
            Height="24px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>6)<./> <font STYLE='font-size: 6pt;'>Ilekroć w informacji jest mowa o urzędzie skarbowym, w tym urzędzie skarbowym, do którego adresowana jest informacja - oznacza to urząd skarbowy przy pomocy, którego właściwy dla podatnika naczelnik urzędu skarbowego wykonuje swoje zadania."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel127" 
            style="Z-INDEX: 267; LEFT: 3px; POSITION: absolute; TOP: 2581px"
            runat="server" 
            Width="627px" 
            Height="24px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>7)<./> <font STYLE='font-size: 6pt;'>Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz. U. z 2020 r. poz. 1325, z późn. zm.), zwanej dalej 'Ordynacją podatkową'."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel128" 
            style="Z-INDEX: 268; LEFT: 3px; POSITION: absolute; TOP: 2596px"
            runat="server" 
            Width="627px" 
            Height="24px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>8)<./> <font STYLE='font-size: 6pt;'>W przypadku przedsiębiorswa w spadku, należy podać dane identyfikacyjne zmarłego przedsiębiorcy z dodaniem oznaczenia 'W spadku'."
            FrameStyle="Small" FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel129" 
            style="Z-INDEX: 269; LEFT: 3px; POSITION: absolute; TOP: 2610px"
            runat="server" 
            Width="627px" 
            Height="25px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>9)<./> <font STYLE='font-size: 6pt;'>W przypadku zaznaczenia kwadratu nr 2, w poz, 19-27 należy podać kraj inny niż Rzeczpospolita Polska oraz adres zamieszkania za granicą; dodatkowo kod kraju wydania dokumentu powinien być zgodny z krajem adresu zamieszkania."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel130" 
            style="Z-INDEX: 270; LEFT: 3px; POSITION: absolute; TOP: 2640px"
            runat="server" 
            Width="627px" 
            Height="30px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>10)<./> <font STYLE='font-size: 6pt;'>W poz. 13 należy podać numer służący do identyfikacji dla celów podatkowych lub ubezpieczeń społecznych uzyskany w państwie, w którym podatnik ma miejsce zamieszkania. W przypadku braku takiego numeru w poz. 13 należy podać numer dokumentu stwierdzającego tożsamość podatnika, uzyskanego w tym państwie."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel131" 
            style="Z-INDEX: 271; LEFT: 3px; POSITION: absolute; TOP: 2666px"
            runat="server" 
            Width="627px" 
            Height="24px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>11)<./> <font STYLE='font-size: 6pt;'>Poz. 14 i 15 nalezy wypełnić, jeżeli w poz. 13 podano zagraniczny numer identyfikacyjny podatnika."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel132" 
            style="Z-INDEX: 272; LEFT: 3px; POSITION: absolute; TOP: 2681px"
            runat="server" 
            Width="627px" 
            Height="30px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>12)<./> <font STYLE='font-size: 6pt;'>W kwocie przychodów, w części E, nie uwzględnia się przychodów wolnych od podatków, na podstawie przepisów ustawy oraz przychodów, od których na podstawie przepisów Ordynacji podatkowej zaniechano poboru podatku; jednakże w kolumnie e należy wykazać dochody zwolnione od podatku na podstawie umów o unikaniu podwójnego opodatkowania lub innych umów międzynarodowych."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel 
            id="FrameLabel133" 
            style="Z-INDEX: 273; LEFT: 3px; POSITION: absolute; TOP: 2716px"
            runat="server" 
            Width="627px" 
            Height="30px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>13)<./> <font STYLE='font-size: 6pt;'>W kwocie kosztów uzyskania przychodów wykazuje się koszty faktycznie uwzględnione przez płatnika przy poborze zaliczeń na podatek."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel134" 
            style="Z-INDEX: 274; LEFT: 3px; POSITION: absolute; TOP: 2731px"
            runat="server" 
            Width="627px" 
            Height="30px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>14)<./> <font STYLE='font-size: 6pt;'>W przypadku gdy zakład pracy pobiera zaliczki na podatek zarówno od należności ze stosunku: pracy, służbowego, spółdzielczego, i pracy nakładczej o których mowa w art. 12 ust. 1 ustawy, jak i zasiłków pieniężnych z ubezpiczenia społecznego, o których mowa w art. 20 ust. 1 ustawy, łączną kwotę zaliczeń pobranych z tych źródeł wykazuje tylko raz. Kwotę tą płatnik może wykazać w wierszu 1, odpowiednio wierszu 2 albo w wierszu 8 części E."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel136" 
            style="Z-INDEX: 275; LEFT: 3px; POSITION: absolute; TOP: 2766px"
            runat="server" 
            Width="627px" 
            Height="46px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>15)<./><font STYLE='font-size: 6pt;'>Wiersz 2 i 6 w części E wypełnia się jeśli w trakcie roku płatnik pobierał od tych przychodów zaliczki na podatek w związku ze złożeniem przez podatnika oświadczenia o rezygnacji ze stosowania w trakcie roku zwolnienia od podatku lub z powodu przekroczenia limitu zwolnienia od podatku (kwoty wykazanej w poz. 86), gdy zwolnienie było stosowane w trakcie roku. W wierszach tych należy odpowiednio wykazać przychody uzyskane przez podatników do ukończenia 26. roku życia wraz z kwotą kosztów uzyskania przychodów oraz sumą zaliczek na podatek pobranych przez płatnika. Przychody ze stosunku pracy i stosunków pokrewnych uzyskane przez podatnika po dniu ukończenia 26. roku życia płatnik wykazuje w wierszu 1,  a odpowiednio przychody z umów zlecenia, o których mowa w art. 13 pkt 8 ustawy, płatnik wykazuje w wierszu 5.<font STYLE='font-size: 6pt;'>"
            FrameStyle="Small" FrameBorderStyle="None">
        </ea:FrameLabel>

        <ea:deklaracjafooter id="footer3" 
            style="Z-INDEX: 259; LEFT: 490px; POSITION: absolute; TOP: 2887px"
            runat="server" 
            TitleWidth="106" 
            Symbol="PIT-11" 
            PageNumber="3" 
            PageTotal="4" 
            Version="26">
        </ea:deklaracjafooter>

        <ea:deklaracjaheader id="DeklaracjaHeader4" 
            style="Z-INDEX: 189; LEFT: 0px; POSITION: absolute; TOP: 2935px"
            runat="server" 
            Width="630px" 
            StylNagłówka="PolaJasneWypelniaPlatnik">
        </ea:deklaracjaheader>

        <ea:framelabel id="FrameLabel402" 
            style="Z-INDEX: 275; LEFT: 3px; POSITION: absolute; TOP: 2965px"
            runat="server" 
            Width="627px" 
            Height="40px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>16)<./><font STYLE='font-size: 6pt;'>W wierszu 8 części E wykazuje się m.in.: zasiłki pieniężne z ubezpieczenia społecznego wypłacone przez zakład pracy, o którym mowa w art. 31 ustawy, należności z tytułu członkostwa w rolniczej spółdzielni produkcyjnej, należności za pracę przypadające tymczasowo aresztowanym lub skazanym, świadczenia wypłacone z Funduszów: Pracy i Gwarantowanych Świadczeń Pracowniczych, należności wynikające z umowy aktywizacyjnej, a także kwotę stypendium, o którym mowa w art. 21 ust. 1 pkt 40b ustawy, w wysokości przekraczającej kwotę zwolnioną od podatku (wykazaną w poz. 83). <font STYLE='font-size: 6pt;'>"
            FrameStyle="Small" FrameBorderStyle="None">
        </ea:FrameLabel>

        <ea:framelabel id="FrameLabel403" 
            style="Z-INDEX: 275; LEFT: 3px; POSITION: absolute; TOP: 3008px"
            runat="server" 
            Width="627px" 
            Height="40px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>17)<./><font STYLE='font-size: 6pt;'>W poz. 69, 70, 72 i 73 nie wykazuje się składaek, których podstawę wymiaru stanowi dochód (przychód) zwolniony od podatku na podstawie ustawy, oraz składek, których podstawę wymiaru stanowi dochód (przychód) zwolniony od podatku na podstawie ustawy, oraz składek, których podstawę wymiaru stanowi dochód, od którego na podstawie przepisów Ordynacji podatkowej zaniechano poboru podatku, a w przypadku składek zagranicznych, których podstawę wymiaru stanowi dochód (przychód) zwolniony od podatku na podstawie umów o unikaniu podwójnego opodatkowania. <font STYLE='font-size: 6pt;'>"
            FrameStyle="Small" FrameBorderStyle="None">
        </ea:FrameLabel>

        <ea:framelabel id="FrameLabel404" 
            style="Z-INDEX: 275; LEFT: 3px; POSITION: absolute; TOP: 3051px"
            runat="server" 
            Width="627px" 
            Height="24px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>18)<./><font STYLE='font-size: 6pt;'>Limit zwolnienia od podatku wynosi 3 800 zł w roku podatkowym. <font STYLE='font-size: 6pt;'>"
            FrameStyle="Small" FrameBorderStyle="None">
        </ea:FrameLabel>        

        <ea:framelabel id="FrameLabel405" 
            style="Z-INDEX: 275; LEFT: 3px; POSITION: absolute; TOP: 3066px"
            runat="server" 
            Width="627px" 
            Height="24px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>19)<./><font STYLE='font-size: 6pt;'>Limit zwolnienia od podatku przychodów wykazanych w poz. 86 wynosi 85 528 zł w roku podatkowym."
            FrameStyle="Small" FrameBorderStyle="None">
        </ea:FrameLabel>

        <ea:framelabel id="FrameLabel406" 
            style="Z-INDEX: 275; LEFT: 3px; POSITION: absolute; TOP: 3081px"
            runat="server" 
            Width="627px" 
            Height="24px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>20)<./><font STYLE='font-size: 6pt;'>Część H informacji wypełniają składający będący płatnikami podatku."
            FrameStyle="Small" FrameBorderStyle="None">
        </ea:FrameLabel>

        <ea:framelabel id="FrameLabel407" 
            style="Z-INDEX: 275; LEFT: 3px; POSITION: absolute; TOP: 3096px"
            runat="server" 
            Width="627px" 
            Height="24px"
            Text="<font STYLE='font-size: 5pt;'><.INDEXUP>21)<./><font STYLE='font-size: 6pt;'>Część I informacji wypełniają składający niebędący płatnikami, którzy wypełnili część F."
            FrameStyle="Small" FrameBorderStyle="None">
        </ea:FrameLabel>

        <ea:framelabel id="FrameLabel138" 
            style="Z-INDEX: 276; LEFT: 300px; POSITION: absolute; TOP: 3111px"
            runat="server" 
            Width="327px" 
            Height="6px"
            Text="<font STYLE='font-size: 6pt;'><b>Pouczenie</b>" 
            FrameStyle="Small"
            FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel139" 
            style="Z-INDEX: 277; LEFT: 3px; POSITION: absolute; TOP: 3126px"
            runat="server" 
            Width="627px" 
            Height="6px"
            Text="<font STYLE='font-size: 6pt;'>Za uchybienie obowiązkom płatnika, a także za złożenie informacji nieprawdziwej, grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym."
            FrameStyle="Small" 
            FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="flDanePodatnika2"
            style="Z-INDEX: 258; LEFT: 199px; POSITION: absolute; TOP: 3840px; height: 21px; width: 427px; right: 275px;"
            runat="server" Text="?" FrameStyle="Middle" FrameBorderStyle="None" HorizontalAlign="Right"
            VerticalAlign="Bottom"></ea:framelabel>

        <ea:deklaracjafooter id="footer4" 
            style="Z-INDEX: 249; LEFT: 0px; POSITION: absolute; TOP: 3840px"
            runat="server" 
            Width="154px" 
            Height="10px" 
            TitleWidth="106" 
            Symbol="PIT-11" 
            PageNumber="4" 
            PageTotal="4"
            Version="26">
        </ea:deklaracjafooter>

        <ea:datacontext id="dc" style="Z-INDEX: 260; LEFT: 189px; POSITION: absolute; TOP: 2887px" runat="server"
            TypeName="Soneta.Deklaracje.PIT.PIT11,Soneta.Deklaracje" oncontextload="OnContextLoad" LeftMargin="15"
            PageHeight="977px" PageZoom="106%"></ea:datacontext>
        <ea:Section ID="Strony" runat="server">
            <ea:framelabel id="Framelabel14"
                style="Z-INDEX: 270; LEFT: 0px; POSITION: absolute; TOP: 3000px; height: 1px; width: 601px;"
                runat="server" Text="" FrameBorderStyle="None"></ea:framelabel>
        </ea:Section>
    </form>
</body>

</HTML>