﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.CIT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<script runat="server">
	Soneta.Deklaracje.CIT.CIT8_21 dek = null;
	
	void OnContextLoad(Object sender, EventArgs args) {
		dek = (Soneta.Deklaracje.CIT.CIT8_21)dc[typeof(Soneta.Deklaracje.CIT.CIT8_21)];

		ORD_ZU.Visible = dek.TreśćUzasadnienia != "";		

		if ((bool)dek.Bloki["B3"]["Tak"])
			P20.EditValue = 1;
		else if((bool)dek.Bloki["B3"]["Utracil"])
			P20.EditValue = 2;
		else if((bool)dek.Bloki["B3"]["Nie"])
			P20.EditValue = 3;

		if ((bool)dek.Bloki["B3"]["DokumentacjaTak"])
			P21.EditValue = 1;
		else if ((bool)dek.Bloki["B3"]["DokumentacjaNie"])
			P21.EditValue = 2;

		if ((decimal)dek.Bloki["D3"]["StrataArt7"] == 0m)
			P_36S.Visible = false;
		else
			P_35S.Visible = false;

		if (string.IsNullOrEmpty((string)dek.Bloki["F"]["Nalezny20Rok"]))
			P_57_58.Visible = false;

		if ((decimal)dek.Bloki["I"]["Nadplata"] == 0m)
			P_93S.Visible = false;
		else
			P_92S.Visible = false;

		if ((decimal)dek.NadplataSprawozdawczo == 0m)
			P_96S.Visible = false;
		else
			P_95S.Visible = false;
		
		var city8O = new List<CIT8O_8>();
        var cityD = new List<CITD_3>();
        var citst = new List<CITST_7>();

		foreach (Deklaracja z in dek.Deklaracje)
			if (z is CIT8O_8)
				city8O.Add((CIT8O_8)z);
            else if (z is CITST_7)
                citst.Add((CITST_7)z);
            else if (z is CITD_3)
                cityD.Add((CITD_3)z);

		CIT8O_8.DataSource = city8O;		
        CITST_REP.DataSource = citst;
        CITD_Repeater.DataSource = cityD;
	}

	void CIT8O_8_BeforeRow(Object sender, EventArgs args) {
		var cit8O_8 = (CIT8O_8)CIT8O_8.CurrentRow;
		CIT8O_8_Od.EditValue = dek.Bloki["0"]["Od"];
		CIT8O_8_Do.EditValue = dek.Bloki["0"]["Do"];
		
		if (string.IsNullOrEmpty((string)cit8O_8.Bloki["B1"]["InneTytul"]))
			OP_18_19S.Visible = false;			

		if (string.IsNullOrEmpty((string)cit8O_8.Bloki["B2"]["Rok1"]))
			B2Rok1.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O_8.Bloki["B2"]["Rok2"]))
			B2Rok2.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O_8.Bloki["B2"]["Rok3"]))
			B2Rok3.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O_8.Bloki["B2"]["Rok4"]))
			B2Rok4.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O_8.Bloki["B2"]["Rok5"]))
			B2Rok5.Visible = false;

		if (string.IsNullOrEmpty((string)cit8O_8.Bloki["B3"]["InneTytul"]))
			OP_47_48S.Visible = false;

		if ((Soneta.Types.Date)cit8O_8.Bloki["E"]["ZwolnienieDataDecyzji"] == Soneta.Types.Date.Empty ||
			string.IsNullOrEmpty((string)cit8O_8.Bloki["E"]["ZwolnienieDecyzja"]))
			OP_56_57_58S.Visible = false;		

		if ((Soneta.Types.Date)cit8O_8.Bloki["E"]["ZaniechanieDataRozporzadzenia"]==Soneta.Types.Date.Empty ||
			string.IsNullOrEmpty((string)cit8O_8.Bloki["E"]["ZaniechanieRozporzadzenie"]))
			OP_59_60_61S.Visible = false;		

		if (string.IsNullOrEmpty((string)cit8O_8.Bloki["E"]["InneTytul"]))
			OP_62_63S.Visible = false;
	}

    private void CITD_BeforeRow(Object sender, EventArgs args)
    {
        var citd = (CITD_3)CITD_Repeater.CurrentRow;
        var session = citd.Session;

        CITD_Od.EditValue = dek.Bloki["0"]["Od"];
        CITD_Do.EditValue = dek.Bloki["0"]["Do"];

        var bloki = citd.Bloki;

        var blokB1 = bloki["B1"];
        if ((bool) blokB1["Otrzymujacy"])
        {
            CITD_RodzajPodatnika.EditValue = 1;
        }
        else if ((bool) blokB1["Przekazujacy"])
        {
            CITD_RodzajPodatnika.EditValue = 2;
        }
        else if ((bool) blokB1["OtrzymujacyPrzekazujacy"])
        {
            CITD_RodzajPodatnika.EditValue = 3;
        }

        CITD_DaneDarczyncy1.Visible = !((string) bloki["C11"]["NazwaPelna"]).IsNullOrEmpty();
        CITD_DaneDarczyncy2.Visible = !((string) bloki["C21"]["NazwaPelna"]).IsNullOrEmpty();
        CITD_DaneDarczyncy3.Visible = !((string) bloki["C31"]["NazwaPelna"]).IsNullOrEmpty();

        CITDC12KodKraju.EditValue = GetKodKraju(session, (string) bloki["C12"]["Kraj"]);
        CITDC22KodKraju.EditValue = GetKodKraju(session, (string) bloki["C22"]["Kraj"]);
        CITDC32KodKraju.EditValue = GetKodKraju(session, (string) bloki["C32"]["Kraj"]);

        CITD_Obdarowany1.Visible = CzyWidocznyObdarowany(bloki["D1"]);
        CITD_Obdarowany2.Visible = CzyWidocznyObdarowany(bloki["D2"]);
        CITD_Obdarowany3.Visible = CzyWidocznyObdarowany(bloki["D3"]);

        CITDD12KodKraju.EditValue = GetKodKraju(session, (string) bloki["D12"]["Kraj"]);
        CITDD22KodKraju.EditValue = GetKodKraju(session, (string) bloki["D22"]["Kraj"]);
        CITDD32KodKraju.EditValue = GetKodKraju(session, (string) bloki["D32"]["Kraj"]);
    }

    private static bool CzyWidocznyObdarowany(BlokDeklaracji blok)
    {
        return
            ((decimal) blok["KwotaPrzekazana"]) != 0m ||
            ((decimal) blok["KwotaOdliczona"]) != 0m;
    }

    void CITST_BeforeRow(Object sender, EventArgs args) {
        var dek = (CITST_7)CITST_REP.CurrentRow;
        var oddziały = new List<CITST_7_Multi>();
        var sta = new List<CITSTA_5>();
        foreach (Deklaracja pit in dek.Deklaracje)
            if (pit is CITST_7_Multi)
                oddziały.Add((CITST_7_Multi)pit);
            else if (pit is CITSTA_5)
                sta.Add((CITSTA_5)pit);

        CITSTM_REP.DataSource = oddziały;

        CITSTA_REP.DataSource = sta;
}	

    protected void CITSTM_BeforeRow(object sender, EventArgs e) {
    }

    protected void CITSTA_BeforeRow(object sender, EventArgs e) {
        var dek = (CITSTA_5)CITSTA_REP.CurrentRow;
        CITSTAM_REP.DataSource = dek.Deklaracje;
    }

    protected void CITSTAM_BeforeRow(object sender, EventArgs e) {
    }

private static string GetKodKraju(Session session, string nazwaKraju)
{
    var krajTbl = session.Get<CoreModule>().KrajeTbl.WgNazwa[nazwaKraju];
    return krajTbl != null ? krajTbl.Kod2 : "";
}
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.CIT.CIT8_21,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja 
    xsi:schemaLocation="http://crd.gov.pl/wzor/2014/01/02/1446/ http://crd.gov.pl/wzor/2014/01/02/1446/schemat.xsd" 
    xmlns="http://crd.gov.pl/wzor/2014/01/02/1446/" 
	xmlns:cz8o="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2012/01/19/eD/CIT8O/"
    xmlns:czd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2012/01/19/eD/CITD/"
    xmlns:czst="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2013/12/18/eD/CITSTZ/"
    xmlns:csta="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2012/01/19/eD/CITSTA/"
    xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/10/07/eD/ORDZU/"
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<Naglowek>
		<KodFormularza kodSystemowy="CIT-8 (21)" kodPodatku="CIT" rodzajZobowiazania="Z" wersjaSchemy="3-2E">CIT-8</KodFormularza>
		<WariantFormularza>21</WariantFormularza>
		<CelZlozenia poz="P_7"><ea:XmlDataLabel ID="CelZlozenia" runat="server" DataMember="A.CelKorekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<OkresOd poz="P_4"><ea:XmlDataLabel runat="server" DataMember="0.Od" XSDType="TData" ></ea:XmlDataLabel></OkresOd>
		<OkresDo poz="P_5"><ea:XmlDataLabel runat="server" DataMember="0.Do" XSDType="TData" ></ea:XmlDataLabel></OkresDo>		
		<KodUrzedu><ea:XmlDataLabel ID="DataLabel4" runat="server" DataMember="X.KodUrzeduSkarbowego"></ea:XmlDataLabel></KodUrzedu>
	</Naglowek>
	<Podmiot1 rola="Podatnik">
			<etd:OsobaNiefizyczna>
				<ea:XmlDataLabel ID="XmlDataLabel2" runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
				<etd:PelnaNazwa><ea:XmlDataLabel ID="NazwaPelna" runat="server" DataMember="B1.Nazwa" XSDType="TZnakowy"></ea:XmlDataLabel></etd:PelnaNazwa>
				<etd:REGON><ea:XmlDataLabel ID="REGON" runat="server" DataMember="B1.Regon" XSDType="TNrREGON"></ea:XmlDataLabel></etd:REGON>
			</etd:OsobaNiefizyczna>	
		<etd:AdresSiedziby rodzajAdresu="RAD">
			<etd:AdresPol>
				<etd:KodKraju>PL</etd:KodKraju>
				<etd:Wojewodztwo><ea:XmlDataLabel ID="XmlDataLabel3" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin"></ea:XmlDataLabel></etd:Wojewodztwo>
				<etd:Powiat><ea:XmlDataLabel ID="XmlDataLabel4" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"></ea:XmlDataLabel></etd:Powiat>
				<etd:Gmina><ea:XmlDataLabel ID="XmlDataLabel5" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"></ea:XmlDataLabel></etd:Gmina>
				<ea:XmlDataLabel ID="XmlDataLabel6" runat="server" ElementName="etd:Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<etd:NrDomu><ea:XmlDataLabel ID="XmlDataLabel7" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel></etd:NrDomu>
				<ea:XmlDataLabel ID="XmlDataLabel8" runat="server" ElementName="etd:NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
				<etd:Miejscowosc><ea:XmlDataLabel ID="XmlDataLabel9" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></etd:Miejscowosc>
				<etd:KodPocztowy><ea:XmlDataLabel ID="XmlDataLabel10" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></etd:KodPocztowy>
				<etd:Poczta><ea:XmlDataLabel ID="XmlDataLabel11" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc"></ea:XmlDataLabel></etd:Poczta>
			</etd:AdresPol>
		</etd:AdresSiedziby>
	</Podmiot1>	
	<PozycjeSzczegolowe>
				<P_20><ea:XmlDataLabel ID="P20" runat="server"></ea:XmlDataLabel></P_20>
				<P_21><ea:XmlDataLabel ID="P21" runat="server"></ea:XmlDataLabel></P_21>
				<ea:XmlDataLabel runat="server" ElementName="P_22" HideEmptyOrZero="true" DataMember="C.CIT-ST"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="P_23" HideEmptyOrZero="true" DataMember="C.SSE-R"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="P_24" HideEmptyOrZero="true" DataMember="C.CIT-8/O"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="P_25" HideEmptyOrZero="true" DataMember="C.CIT-D"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="P_25" HideEmptyOrZero="true" DataMember="C.Sprawozdanie" ></ea:XmlDataLabel>
				<P_27><ea:XmlDataLabel runat="server" DataMember="D1.RP" XSDType="TKwota2"></ea:XmlDataLabel></P_27>
				<P_28><ea:XmlDataLabel runat="server" DataMember="D1.PozaRP" XSDType="TKwota2"></ea:XmlDataLabel></P_28>
				<P_29><ea:XmlDataLabel runat="server" DataMember="D1.PozaRPInne" XSDType="TKwota2"></ea:XmlDataLabel></P_29>
				<P_30><ea:XmlDataLabel runat="server" DataMember="D1.Razem" XSDType="TKwota2"></ea:XmlDataLabel></P_30>
				<P_31><ea:XmlDataLabel runat="server" DataMember="D2.RP" XSDType="TKwota2"></ea:XmlDataLabel></P_31>
				<P_32><ea:XmlDataLabel runat="server" DataMember="D2.PozaRP" XSDType="TKwota2"></ea:XmlDataLabel></P_32>
				<P_33><ea:XmlDataLabel runat="server" DataMember="D2.PozaRPInne" XSDType="TKwota2"></ea:XmlDataLabel></P_33>
				<P_34><ea:XmlDataLabel runat="server" DataMember="D2.Razem" XSDType="TKwota2"></ea:XmlDataLabel></P_34>				
				<ea:Section runat="server" ID="P_35S"><P_35><ea:XmlDataLabel runat="server" DataMember="D3.DochodArt7" XSDType="TKwota2"></ea:XmlDataLabel></P_35></ea:Section>
				<ea:Section runat="server" ID="P_36S"><P_36><ea:XmlDataLabel runat="server" DataMember="D3.StrataArt7" XSDType="TKwota2"></ea:XmlDataLabel></P_36></ea:Section>
				<P_37><ea:XmlDataLabel runat="server" DataMember="D3.StrataInna" XSDType="TKwota2"></ea:XmlDataLabel></P_37>
				<P_38><ea:XmlDataLabel runat="server" DataMember="D3.Dochod" XSDType="TKwota2"></ea:XmlDataLabel></P_38>
				<P_39><ea:XmlDataLabel runat="server" DataMember="D3.Strata" XSDType="TKwota2"></ea:XmlDataLabel></P_39>
				<P_40><ea:XmlDataLabel runat="server" DataMember="E1.Wolne" XSDType="TKwota2"></ea:XmlDataLabel></P_40>
				<P_41><ea:XmlDataLabel runat="server" DataMember="E1.Odliczenia" XSDType="TKwota2"></ea:XmlDataLabel></P_41>
				<P_42><ea:XmlDataLabel runat="server" DataMember="E1.Inwestycje" XSDType="TKwota2"></ea:XmlDataLabel></P_42>
				<P_43><ea:XmlDataLabel runat="server" DataMember="E1.Razem" XSDType="TKwota2"></ea:XmlDataLabel></P_43>				
				<P_44><ea:XmlDataLabel runat="server" DataMember="E2.Podstawa" XSDType="TKwota2"></ea:XmlDataLabel></P_44>
				<P_45><ea:XmlDataLabel runat="server" DataMember="E2.Strata" XSDType="TKwota2"></ea:XmlDataLabel></P_45>							
				<P_46><ea:XmlDataLabel runat="server" DataMember="E3.NoweTechnologie" XSDType="TKwota2"></ea:XmlDataLabel></P_46>											
				<P_47><ea:XmlDataLabel runat="server" DataMember="E4.Inwestycje" XSDType="TKwota2"></ea:XmlDataLabel></P_47>				
				<P_48><ea:XmlDataLabel runat="server" DataMember="E4.Strefa" XSDType="TKwota2"></ea:XmlDataLabel></P_48>
				<P_49><ea:XmlDataLabel runat="server" DataMember="E4.NoweTechnologie" XSDType="TKwota2"></ea:XmlDataLabel></P_49>							
				<P_50><ea:XmlDataLabel runat="server" DataMember="E4.Razem" XSDType="TKwota2"></ea:XmlDataLabel></P_50>															
				<P_51><ea:XmlDataLabel runat="server" DataMember="E5.Podstawa" XSDType="TCalkowity"></ea:XmlDataLabel></P_51>							
				<P_52><ea:XmlDataLabel runat="server" DataMember="E5.Strata" XSDType="TKwota2"></ea:XmlDataLabel></P_52>																
				<P_53><ea:XmlDataLabel runat="server" DataMember="F.Stawka" XSDType="TProcentowy"></ea:XmlDataLabel></P_53>				
				<P_54><ea:XmlDataLabel  runat="server" DataMember="F.Nalezny" XSDType="TKwota2"></ea:XmlDataLabel></P_54>
				<P_55><ea:XmlDataLabel  runat="server" DataMember="F.Odliczenia" XSDType="TKwota2"></ea:XmlDataLabel></P_55>							
				<P_56><ea:XmlDataLabel  runat="server" DataMember="F.NaleznyPoOdliczeniach" XSDType="TCalkowity"></ea:XmlDataLabel></P_56>															
				<ea:Section runat="server" ID="P_57_58"><P_57><ea:XmlDataLabel  runat="server" DataMember="F.Nalezny20Rok"></ea:XmlDataLabel></P_57>							
				<P_58><ea:XmlDataLabel  runat="server" DataMember="F.Nalezny20" XSDType="TCalkowity"></ea:XmlDataLabel></P_58></ea:Section>
				<P_59><ea:XmlDataLabel runat="server" DataMember="G.1" XSDType="TCalkowity"></ea:XmlDataLabel></P_59>														
				<P_60><ea:XmlDataLabel runat="server" DataMember="G.2" XSDType="TCalkowity"></ea:XmlDataLabel></P_60>
				<P_61><ea:XmlDataLabel runat="server" DataMember="G.3" XSDType="TCalkowity"></ea:XmlDataLabel></P_61>														
				<P_62><ea:XmlDataLabel runat="server" DataMember="G.4" XSDType="TCalkowity"></ea:XmlDataLabel></P_62>
				<P_63><ea:XmlDataLabel runat="server" DataMember="G.5" XSDType="TCalkowity"></ea:XmlDataLabel></P_63>																		
				<P_64><ea:XmlDataLabel runat="server" DataMember="G.6" XSDType="TCalkowity"></ea:XmlDataLabel></P_64>														
				<P_65><ea:XmlDataLabel runat="server" DataMember="G.7" XSDType="TCalkowity"></ea:XmlDataLabel></P_65>
				<P_66><ea:XmlDataLabel runat="server" DataMember="G.8" XSDType="TCalkowity"></ea:XmlDataLabel></P_66>														
				<P_67><ea:XmlDataLabel runat="server" DataMember="G.9" XSDType="TCalkowity"></ea:XmlDataLabel></P_67>
				<P_68><ea:XmlDataLabel runat="server" DataMember="G.10" XSDType="TCalkowity"></ea:XmlDataLabel></P_68>													
				<P_69><ea:XmlDataLabel runat="server" DataMember="G.11" XSDType="TCalkowity"></ea:XmlDataLabel></P_69>														
				<P_70><ea:XmlDataLabel runat="server" DataMember="G.12" XSDType="TCalkowity"></ea:XmlDataLabel></P_70>
				<P_71><ea:XmlDataLabel runat="server" DataMember="G.13" XSDType="TCalkowity"></ea:XmlDataLabel></P_71>														
				<P_72><ea:XmlDataLabel runat="server" DataMember="G.14" XSDType="TCalkowity"></ea:XmlDataLabel></P_72>
				<P_73><ea:XmlDataLabel runat="server" DataMember="G.15" XSDType="TCalkowity"></ea:XmlDataLabel></P_73>													
				<P_74><ea:XmlDataLabel runat="server" DataMember="G.16" XSDType="TCalkowity"></ea:XmlDataLabel></P_74>														
				<P_75><ea:XmlDataLabel runat="server" DataMember="G.17" XSDType="TCalkowity"></ea:XmlDataLabel></P_75>
				<P_76><ea:XmlDataLabel runat="server" DataMember="G.18" XSDType="TCalkowity"></ea:XmlDataLabel></P_76>														
				<P_77><ea:XmlDataLabel runat="server" DataMember="G.19" XSDType="TCalkowity"></ea:XmlDataLabel></P_77>
				<P_78><ea:XmlDataLabel runat="server" DataMember="G.20" XSDType="TCalkowity"></ea:XmlDataLabel></P_78>																									
				<P_79><ea:XmlDataLabel runat="server" DataMember="G.21" XSDType="TCalkowity"></ea:XmlDataLabel></P_79>														
				<P_80><ea:XmlDataLabel runat="server" DataMember="G.22" XSDType="TCalkowity"></ea:XmlDataLabel></P_80>
				<P_81><ea:XmlDataLabel runat="server" DataMember="G.23" XSDType="TCalkowity"></ea:XmlDataLabel></P_81>														
				<P_82><ea:XmlDataLabel runat="server" DataMember="G.Razem" XSDType="TCalkowity"></ea:XmlDataLabel></P_82>
				<P_83><ea:XmlDataLabel runat="server" DataMember="H.1" XSDType="TCalkowity"></ea:XmlDataLabel></P_83>														
				<P_84><ea:XmlDataLabel runat="server" DataMember="H.2" XSDType="TCalkowity"></ea:XmlDataLabel></P_84>
				<P_85><ea:XmlDataLabel runat="server" DataMember="H.3" XSDType="TCalkowity"></ea:XmlDataLabel></P_85>														
				<P_86><ea:XmlDataLabel runat="server" DataMember="H.4" XSDType="TCalkowity"></ea:XmlDataLabel></P_86>
				<P_87><ea:XmlDataLabel runat="server" DataMember="H.5" XSDType="TCalkowity"></ea:XmlDataLabel></P_87>																		
				<P_88><ea:XmlDataLabel runat="server" DataMember="H.6" XSDType="TCalkowity"></ea:XmlDataLabel></P_88>														
				<P_89><ea:XmlDataLabel runat="server" DataMember="H.7" XSDType="TCalkowity"></ea:XmlDataLabel></P_89>
				<P_90><ea:XmlDataLabel runat="server" DataMember="H.8" XSDType="TCalkowity"></ea:XmlDataLabel></P_90>														
				<P_91><ea:XmlDataLabel runat="server" DataMember="H.Razem" XSDType="TCalkowity"></ea:XmlDataLabel></P_91>				
				<ea:Section runat="server" ID="P_92S"><P_92><ea:XmlDataLabel runat="server" DataMember="I.Niedoplata" XSDType="TCalkowity"></ea:XmlDataLabel></P_92></ea:Section>														
				<ea:Section runat="server" ID="P_93S"><P_93><ea:XmlDataLabel runat="server" DataMember="I.Nadplata" XSDType="TCalkowity"></ea:XmlDataLabel></P_93></ea:Section>								
				<P_94><ea:XmlDataLabel runat="server" DataMember="J.Zaliczki" XSDType="TCalkowity"></ea:XmlDataLabel></P_94>														
				<ea:Section runat="server" ID="P_95S"><P_95><ea:XmlDataLabel runat="server" DataMember="DoZaplatySprawozdawczo" XSDType="TCalkowity"></ea:XmlDataLabel></P_95></ea:Section>												
				<ea:Section runat="server" ID="P_96S"><P_96><ea:XmlDataLabel runat="server" DataMember="NadplataSprawozdawczo" XSDType="TCalkowity"></ea:XmlDataLabel></P_96></ea:Section>																
				<P_97><ea:XmlDataLabel runat="server" DataMember="K.Dochody" XSDType="TCalkowity"></ea:XmlDataLabel></P_97>								
				<P_98><ea:XmlDataLabel runat="server" DataMember="K.Nalezny" XSDType="TCalkowity"></ea:XmlDataLabel></P_98>														
				<P_99><ea:XmlDataLabel runat="server" DataMember="K.KwotaNaliczona" XSDType="TCalkowity"></ea:XmlDataLabel></P_99>												
				<P_100><ea:XmlDataLabel runat="server" DataMember="K.Odsetki" XSDType="TCalkowity"></ea:XmlDataLabel></P_100>												
	</PozycjeSzczegolowe>
	<Pouczenie1>Niniejsze zeznanie stanowi podstawę do wystawienia tytułu wykonawczego zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz.U. z 2005 r. Nr 229, poz.1954, ze zm.), na odsetki od wykazanych i nieuiszczonych w obowiązujących terminach lub uiszczonych w niepełnej wysokości kwot z poz.59-81 i poz.83-90.</Pouczenie1>	
	<Pouczenie2>W przypadku niewpłacenia w obowiązujących terminach kwot z poz.95, 98, 99 i 100 lub wpłacenia ich w niepełnej wysokości niniejsze zeznanie stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz.U. z 2005 r. Nr 229, poz.1954, ze zm.).</Pouczenie2>	
	<Oswiadczenie>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością i przez to narażenie na uszczuplenie podatku.</Oswiadczenie>	
	<Zalaczniki><ea:DataRepeater ID="CIT8O_8" runat="server" WithSections="False" OnBeforeRow="CIT8O_8_BeforeRow">
		<cz8o:Zalacznik_CIT-8_O>
			<cz8o:Naglowek>
				<cz8o:KodFormularza kodSystemowy="CIT8/O (8)" wersjaSchemy="3-0E">CIT-8/O</cz8o:KodFormularza>
				<cz8o:WariantFormularza>8</cz8o:WariantFormularza>
				<cz8o:OkresOd poz="P_4"><ea:XmlDataLabel ID="CIT8O_8_Od" XSDType="TData" runat="server"></ea:XmlDataLabel></cz8o:OkresOd>
				<cz8o:OkresDo poz="P_5"><ea:XmlDataLabel ID="CIT8O_8_Do" XSDType="TData" runat="server"></ea:XmlDataLabel></cz8o:OkresDo>		
			</cz8o:Naglowek>
				<cz8o:PozycjeSzczegolowe>
					<cz8o:P_8><ea:XmlDataLabel runat="server" DataMember="B1.Wolne1" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_8>
					<cz8o:P_9><ea:XmlDataLabel runat="server" DataMember="B1.Wolne2" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_9>			
					<cz8o:P_10><ea:XmlDataLabel runat="server" DataMember="B1.Wolne3" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_10>
					<cz8o:P_11><ea:XmlDataLabel runat="server" DataMember="B1.Wolne4" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_11>
					<cz8o:P_12><ea:XmlDataLabel runat="server" DataMember="B1.Wolne5" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_12>
					<cz8o:P_13><ea:XmlDataLabel runat="server" DataMember="B1.Wolne6" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_13>
					<cz8o:P_14><ea:XmlDataLabel runat="server" DataMember="B1.Wolne7" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_14>
					<cz8o:P_15><ea:XmlDataLabel runat="server" DataMember="B1.Wolne8" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_15>
					<cz8o:P_16><ea:XmlDataLabel runat="server" DataMember="B1.Wolne9" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_16>
					<cz8o:P_17><ea:XmlDataLabel runat="server" DataMember="B1.Zwolnione" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_17>
					<ea:Section runat="server" ID="OP_18_19S"><cz8o:P_18><ea:XmlDataLabel runat="server" DataMember="B1.InneTytul" XSDType="TZnakowy"></ea:XmlDataLabel></cz8o:P_18>
					<cz8o:P_19><ea:XmlDataLabel runat="server" DataMember="B1.Inne" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_19></ea:Section>
					<cz8o:P_20><ea:XmlDataLabel runat="server" DataMember="B1.Razem" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_20>
					<ea:Section runat="server" ID="B2Rok1"><cz8o:P_21><ea:XmlDataLabel runat="server" DataMember="B2.Rok1" XSDType="TZnakowy"></ea:XmlDataLabel></cz8o:P_21>
					<cz8o:P_22><ea:XmlDataLabel runat="server" DataMember="B2.Kwota1" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_22>																									
					<cz8o:P_23><ea:XmlDataLabel runat="server" DataMember="B2.Odliczona1" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_23>																														
					<cz8o:P_24><ea:XmlDataLabel runat="server" DataMember="B2.DoOdliczenia1" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_24></ea:Section>
					<ea:Section runat="server" ID="B2Rok2"><cz8o:P_25><ea:XmlDataLabel runat="server" DataMember="B2.Rok2" XSDType="TZnakowy"></ea:XmlDataLabel></cz8o:P_25>					
					<cz8o:P_26><ea:XmlDataLabel runat="server" DataMember="B2.Kwota2" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_26>																									
					<cz8o:P_27><ea:XmlDataLabel runat="server" DataMember="B2.Odliczona2" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_27>																														
					<cz8o:P_28><ea:XmlDataLabel runat="server" DataMember="B2.DoOdliczenia2" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_28></ea:Section>	
					<ea:Section runat="server" ID="B2Rok3"><cz8o:P_29><ea:XmlDataLabel runat="server" DataMember="B2.Rok3" XSDType="TZnakowy"></ea:XmlDataLabel></cz8o:P_29>					
					<cz8o:P_30><ea:XmlDataLabel runat="server" DataMember="B2.Kwota3" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_30>																									
					<cz8o:P_31><ea:XmlDataLabel runat="server" DataMember="B2.Odliczona3" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_31>																														
					<cz8o:P_32><ea:XmlDataLabel runat="server" DataMember="B2.DoOdliczenia3" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_32></ea:Section>
					<ea:Section runat="server" ID="B2Rok4"><cz8o:P_33><ea:XmlDataLabel runat="server" DataMember="B2.Rok4" XSDType="TZnakowy"></ea:XmlDataLabel></cz8o:P_33>					
					<cz8o:P_34><ea:XmlDataLabel runat="server" DataMember="B2.Kwota4" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_34>																									
					<cz8o:P_35><ea:XmlDataLabel runat="server" DataMember="B2.Odliczona4" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_35>																														
					<cz8o:P_36><ea:XmlDataLabel runat="server" DataMember="B2.DoOdliczenia4" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_36></ea:Section>	
					<ea:Section runat="server" ID="B2Rok5"><cz8o:P_37><ea:XmlDataLabel runat="server" DataMember="B2.Rok5" XSDType="TZnakowy"></ea:XmlDataLabel></cz8o:P_37>					
					<cz8o:P_38><ea:XmlDataLabel runat="server" DataMember="B2.Kwota5" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_38>																									
					<cz8o:P_39><ea:XmlDataLabel runat="server" DataMember="B2.Odliczona5" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_39>																														
					<cz8o:P_40><ea:XmlDataLabel runat="server" DataMember="B2.DoOdliczenia5" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_40></ea:Section>
					<cz8o:P_41><ea:XmlDataLabel runat="server" DataMember="B2.Razem" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_41>																									
					<cz8o:P_42><ea:XmlDataLabel runat="server" DataMember="B3.Darowizny" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_42>																									
					<cz8o:P_43><ea:XmlDataLabel runat="server" DataMember="B3.DarowiznyReligijne" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_43>																														
					<cz8o:P_44><ea:XmlDataLabel runat="server" DataMember="B3.DarowiznyOdrebne" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_44>																					
					<cz8o:P_45><ea:XmlDataLabel runat="server" DataMember="B3.RazemDarowizny" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_45>																														
					<cz8o:P_46><ea:XmlDataLabel runat="server" DataMember="B3.Odliczenia" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_46>																									
					<ea:Section runat="server" ID="OP_47_48S"><cz8o:P_47><ea:XmlDataLabel runat="server" DataMember="B3.InneTytul" XSDType="TZnakowy"></ea:XmlDataLabel></cz8o:P_47>
					<cz8o:P_48><ea:XmlDataLabel runat="server" DataMember="B3.Inne" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_48></ea:Section>
					<cz8o:P_49><ea:XmlDataLabel runat="server" DataMember="B3.Razem" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_49>																											
					<cz8o:P_50><ea:XmlDataLabel runat="server" DataMember="C.Wydatki1" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_50>																					
					<cz8o:P_51><ea:XmlDataLabel runat="server" DataMember="C.Obnizka" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_51>																														
					<cz8o:P_52><ea:XmlDataLabel runat="server" DataMember="C.Razem" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_52>																													
					<cz8o:P_53><ea:XmlDataLabel runat="server" DataMember="D.NowaTechnologia" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_53>																																		
					<cz8o:P_54><ea:XmlDataLabel runat="server" DataMember="E.Odliczenia1" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_54>																					
					<cz8o:P_55><ea:XmlDataLabel runat="server" DataMember="E.Odliczenia2" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_55>																											
					<ea:Section runat="server" ID="OP_56_57_58S"><cz8o:P_56><ea:XmlDataLabel runat="server" DataMember="E.Zwolnienie" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_56>																					
					<cz8o:P_57><ea:XmlDataLabel runat="server" DataMember="E.ZwolnienieDecyzja" XSDType="TZnakowy"></ea:XmlDataLabel></cz8o:P_57>
					<cz8o:P_58><ea:XmlDataLabel runat="server" DataMember="E.ZwolnienieDataDecyzji" XSDType="TData"></ea:XmlDataLabel></cz8o:P_58></ea:Section>
					<ea:Section runat="server" ID="OP_59_60_61S"><cz8o:P_59><ea:XmlDataLabel runat="server" DataMember="E.Zaniechanie" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_59>																					
					<cz8o:P_60><ea:XmlDataLabel runat="server" DataMember="E.ZaniechanieDataRozporzadzenia" XSDType="TData"></ea:XmlDataLabel></cz8o:P_60>																					
					<cz8o:P_61><ea:XmlDataLabel runat="server" DataMember="E.ZaniechanieRozporzadzenie" XSDType="TZnakowy"></ea:XmlDataLabel></cz8o:P_61></ea:Section>
					<ea:Section runat="server" ID="OP_62_63S"><cz8o:P_62><ea:XmlDataLabel runat="server" DataMember="E.InneTytul" XSDType="TZnakowy"></ea:XmlDataLabel></cz8o:P_62>
					<cz8o:P_63><ea:XmlDataLabel runat="server" DataMember="E.Inne" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_63></ea:Section>
					<cz8o:P_64><ea:XmlDataLabel runat="server" DataMember="E.Razem" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_64>																													
					<cz8o:P_65><ea:XmlDataLabel runat="server" DataMember="F1.Dochody1" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_65>																											
					<cz8o:P_66><ea:XmlDataLabel runat="server" DataMember="F1.Dochody2" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_66>																					
					<cz8o:P_67><ea:XmlDataLabel runat="server" DataMember="F1.Dochody3" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_67>																														
					<cz8o:P_68><ea:XmlDataLabel runat="server" DataMember="F1.PobranyPodatek" XSDType="TCalkowity"></ea:XmlDataLabel></cz8o:P_68>																													
					<cz8o:P_69><ea:XmlDataLabel runat="server" DataMember="F1.WplaconyPodatek" XSDType="TCalkowity"></ea:XmlDataLabel></cz8o:P_69>																						
					<cz8o:P_70><ea:XmlDataLabel runat="server" DataMember="F2.SumaDochodow" XSDType="TKwota2"></ea:XmlDataLabel></cz8o:P_70>																														
					<cz8o:P_71><ea:XmlDataLabel runat="server" DataMember="F3.Kwoty" XSDType="TCalkowity"></ea:XmlDataLabel></cz8o:P_71>																													
					<cz8o:P_72><ea:XmlDataLabel runat="server" DataMember="F3.Podatek" XSDType="TCalkowity"></ea:XmlDataLabel></cz8o:P_72>																											
				</cz8o:PozycjeSzczegolowe>
		</cz8o:Zalacznik_CIT-8_O>	
		</ea:DataRepeater>

    <ea:DataRepeater ID="CITD_Repeater" runat="server" WithSections="False" OnBeforeRow="CITD_BeforeRow">
        <czd:Zalacznik_CIT-D>
            <czd:Naglowek>
                <czd:KodFormularza kodSystemowy="CIT-D (3)" wersjaSchemy="3-0E">CIT-D</czd:KodFormularza>
                <czd:WariantFormularza>3</czd:WariantFormularza>
                <czd:OkresOd poz="P_4"><ea:XmlDataLabel ID="CITD_Od" XSDType="TData" runat="server"></ea:XmlDataLabel></czd:OkresOd>
                <czd:OkresDo poz="P_5"><ea:XmlDataLabel ID="CITD_Do" XSDType="TData" runat="server"></ea:XmlDataLabel></czd:OkresDo>
            </czd:Naglowek>
            <czd:PozycjeSzczegolowe>
                <ea:XmlDataLabel ElementName="czd:P_6" runat="server" DataMember="NrFormularza" XSDType="TCalkowity"/>
                <czd:P_8>2</czd:P_8>
                <ea:XmlDataLabel ID="CITD_RodzajPodatnika" ElementName="czd:P_10" runat="server" XSDType="TCalkowity"/>
                
                <ea:XmlDataLabel ElementName="czd:P_23" runat="server" DataMember="C.Ogolem" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_24" runat="server" DataMember="C.Osoba1" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_25" runat="server" DataMember="C.Osoba2" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_26" runat="server" DataMember="C.Osoba3" XSDType="TKwota2" HideEmptyOrZero="True"/>
                
                <ea:Section ID="CITD_DaneDarczyncy1" runat="server">
                    <ea:XmlDataLabel ElementName="czd:P_27" runat="server" DataMember="C11.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_28A" runat="server" ID="CITDC12KodKraju" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_29" runat="server" DataMember="C12.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_30" runat="server" DataMember="C12.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_31" runat="server" DataMember="C12.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_32" runat="server" DataMember="C12.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_33" runat="server" DataMember="C12.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_34" runat="server" DataMember="C12.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_35" runat="server" DataMember="C12.Miejsc" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_36" runat="server" DataMember="C12.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_37" runat="server" DataMember="C12.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                </ea:Section>
                
                <ea:Section ID="CITD_DaneDarczyncy2" runat="server">
                    <ea:XmlDataLabel ElementName="czd:P_38" runat="server" DataMember="C21.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_39A" runat="server" ID="CITDC22KodKraju" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_40" runat="server" DataMember="C22.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_41" runat="server" DataMember="C22.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_42" runat="server" DataMember="C22.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_43" runat="server" DataMember="C22.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_44" runat="server" DataMember="C22.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_45" runat="server" DataMember="C22.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_46" runat="server" DataMember="C22.Miejsc" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_47" runat="server" DataMember="C22.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_48" runat="server" DataMember="C22.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                </ea:Section>
                
                <ea:Section ID="CITD_DaneDarczyncy3" runat="server">
                    <ea:XmlDataLabel ElementName="czd:P_49" runat="server" DataMember="C31.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_50A" runat="server" ID="CITDC32KodKraju" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_51" runat="server" DataMember="C32.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_52" runat="server" DataMember="C32.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_53" runat="server" DataMember="C32.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_54" runat="server" DataMember="C32.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_55" runat="server" DataMember="C32.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_56" runat="server" DataMember="C32.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_57" runat="server" DataMember="C32.Miejsc" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_58" runat="server" DataMember="C32.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_59" runat="server" DataMember="C32.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                </ea:Section>

                <ea:XmlDataLabel ElementName="czd:P_60" runat="server" DataMember="C4.DzialalnoscCharytatywna" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_61" runat="server" DataMember="C4.PomocOfiarom" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_62" runat="server" DataMember="C4.PomocSpoleczna" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_63" runat="server" DataMember="C4.KrajoznawstwoWypoczynek" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_64" runat="server" DataMember="C4.Nauka" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_65" runat="server" DataMember="C4.Niepelnosprawni" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_66" runat="server" DataMember="C4.Kultura" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_67" runat="server" DataMember="C4.Ekologia" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_68" runat="server" DataMember="C4.Zdrowie" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_69" runat="server" DataMember="C4.RozwojGospodarczy" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_70" runat="server" DataMember="C4.KulturaFizyczna" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_71" runat="server" DataMember="C4.Ratownictwo" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_72" runat="server" DataMember="C4.KultReligijny" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_73" runat="server" DataMember="C4.DzialalnoscCharytatywnoOpiekuncza" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_74" runat="server" DataMember="C4.Pozostale" XSDType="TWybor1" HideEmptyOrZero="True"/>
                
                <ea:Section ID="CITD_Obdarowany1" runat="server">
                    <ea:XmlDataLabel ElementName="czd:P_75" runat="server" DataMember="D1.KwotaPrzekazana" XSDType="TKwota2" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_76" runat="server" DataMember="D1.KwotaOdliczona" XSDType="TKwota2" HideEmptyOrZero="True"/>
                    
                    <ea:XmlDataLabel ElementName="czd:P_77" runat="server" DataMember="D11.Identyfikator" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_78" runat="server" DataMember="D11.KodKraju" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_79" runat="server" DataMember="D11.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    
                    <ea:XmlDataLabel ElementName="czd:P_80A" runat="server" ID="CITDD12KodKraju" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_81" runat="server" DataMember="D12.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_82" runat="server" DataMember="D12.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_83" runat="server" DataMember="D12.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_84" runat="server" DataMember="D12.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_85" runat="server" DataMember="D12.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_86" runat="server" DataMember="D12.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_87" runat="server" DataMember="D12.Miejsc" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_88" runat="server" DataMember="D12.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_89" runat="server" DataMember="D12.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                </ea:Section>
                
                <ea:Section ID="CITD_Obdarowany2" runat="server">
                    <ea:XmlDataLabel ElementName="czd:P_90" runat="server" DataMember="D2.KwotaPrzekazana" XSDType="TKwota2" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_91" runat="server" DataMember="D2.KwotaOdliczona" XSDType="TKwota2" HideEmptyOrZero="True"/>
                    
                    <ea:XmlDataLabel ElementName="czd:P_92" runat="server" DataMember="D21.Identyfikator" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_93" runat="server" DataMember="D21.KodKraju" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_94" runat="server" DataMember="D21.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    
                    <ea:XmlDataLabel ElementName="czd:P_95A" runat="server" ID="CITDD22KodKraju" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_96" runat="server" DataMember="D22.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_97" runat="server" DataMember="D22.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_98" runat="server" DataMember="D22.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_99" runat="server" DataMember="D22.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_100" runat="server" DataMember="D22.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_101" runat="server" DataMember="D22.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_102" runat="server" DataMember="D22.Miejsc" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_103" runat="server" DataMember="D22.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_104" runat="server" DataMember="D22.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                </ea:Section>
                
                <ea:Section ID="CITD_Obdarowany3" runat="server">
                    <ea:XmlDataLabel ElementName="czd:P_105" runat="server" DataMember="D3.KwotaPrzekazana" XSDType="TKwota2" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_106" runat="server" DataMember="D3.KwotaOdliczona" XSDType="TKwota2" HideEmptyOrZero="True"/>
                    
                    <ea:XmlDataLabel ElementName="czd:P_107" runat="server" DataMember="D31.Identyfikator" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_108" runat="server" DataMember="D31.KodKraju" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_109" runat="server" DataMember="D31.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    
                    <ea:XmlDataLabel ElementName="czd:P_110A" runat="server" ID="CITDD32KodKraju" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_111" runat="server" DataMember="D32.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_112" runat="server" DataMember="D32.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_113" runat="server" DataMember="D32.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_114" runat="server" DataMember="D32.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_115" runat="server" DataMember="D32.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_116" runat="server" DataMember="D32.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_117" runat="server" DataMember="D32.Miejsc" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_118" runat="server" DataMember="D32.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_119" runat="server" DataMember="D32.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                </ea:Section>

            </czd:PozycjeSzczegolowe>
        </czd:Zalacznik_CIT-D>
    </ea:DataRepeater>
        
    <ea:DataRepeater ID="CITST_REP" runat="server" WithSections="False" OnBeforeRow="CITST_BeforeRow">
	<czst:Zalacznik_CIT-ST>
    <czst:Naglowek>
        <czst:KodFormularza kodSystemowy="CT-STR (7)" wersjaSchemy="1-2E">CIT-ST</czst:KodFormularza>
        <czst:WariantFormularza>7</czst:WariantFormularza>		
        <czst:OkresOd poz="P_4"><ea:XmlDataLabel runat="server" DataMember="0.Od" XSDType="TData"/></czst:OkresOd>
        <czst:OkresDo poz="P_5"><ea:XmlDataLabel runat="server" DataMember="0.Do" XSDType="TData"/></czst:OkresDo>
    </czst:Naglowek>
    <czst:PozycjeSzczegolowe>
    <czst:P_9>2</czst:P_9>		
    <ea:XmlDataLabel ElementName="czst:P_22" runat="server" DataMember="D.LiczbaZatrudnionych" XSDType="TCalkowity" />	
    <ea:DataRepeater ID="CITSTM_REP" runat="server" WithSections="False" OnBeforeRow="CITSTM_BeforeRow">
    <czst:P_E typ="G">	
        <ea:XmlDataLabel ElementName="czst:P_A" runat="server" DataMember="E.Wojew" XSDType="TJednAdmin"/>
        <ea:XmlDataLabel ElementName="czst:P_B" runat="server" DataMember="E.Powiat" XSDType="TJednAdmin"/>
        <ea:XmlDataLabel ElementName="czst:P_C" runat="server" DataMember="E.Gmina" XSDType="TJednAdmin"/>
        <ea:XmlDataLabel ElementName="czst:P_D" runat="server" DataMember="E.KodGminy" XSDType="TTekstowy"/>
        <ea:XmlDataLabel ElementName="czst:P_E1" runat="server" DataMember="E.NazwaOddziału" XSDType="TTekstowy"/>
        <ea:XmlDataLabel ElementName="czst:P_F1" runat="server" DataMember="E.Regon" XSDType="TNrREGON" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="czst:P_F2" runat="server" DataMember="E.NIP" XSDType="TNrNIP" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="czst:P_G" runat="server" DataMember="E.LiczbaZatrudnionych" XSDType="TCalkowity"/>
    </czst:P_E>
    </ea:DataRepeater>
    <ea:XmlDataLabel ElementName="czst:P_169" runat="server" DataMember="F.Data" XSDType="TData" />	
    </czst:PozycjeSzczegolowe>
    <czst:Zalaczniki>
    <ea:DataRepeater ID="CITSTA_REP" runat="server" WithSections="False" OnBeforeRow="CITSTA_BeforeRow">
    <csta:Zalacznik_CIT-ST_A>
        <csta:Naglowek>
            <csta:KodFormularza kodSystemowy="CTSTAR (5)" wersjaSchemy="1-0E">CIT-ST/A</csta:KodFormularza>
            <csta:WariantFormularza>5</csta:WariantFormularza>
        </csta:Naglowek>
        <csta:PozycjeSzczegolowe>
            <ea:DataRepeater ID="CITSTAM_REP" runat="server" WithSections="False" OnBeforeRow="CITSTAM_BeforeRow">
            <csta:P_B1 typ="G">
                <ea:XmlDataLabel ElementName="csta:P_1" runat="server" DataMember="B1.Nazwa" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ElementName="csta:P_2" runat="server" DataMember="B1.NazwaSkrócona" XSDType="TTekstowy" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="csta:P_3" runat="server" DataMember="B1.Regon" XSDType="TNrREGON" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="csta:P_4" runat="server" DataMember="B1.NIP" XSDType="TNrNIP" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="csta:P_5" runat="server" DataMember="B1.DataRozpoczęciaDziałalności" XSDType="TData" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="csta:P_6A" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"><ValuesMap><ea:ValuesPair Key="" Value="PL" /></ValuesMap></ea:XmlDataLabel>
                <ea:XmlDataLabel ElementName="csta:P_7" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="csta:P_8" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="csta:P_9" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="csta:P_10" runat="server" DataMember="B2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="csta:P_11" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="csta:P_12" runat="server" DataMember="B2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="csta:P_13" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="csta:P_14" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="csta:P_15" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
            </csta:P_B1>
            </ea:DataRepeater>
        </csta:PozycjeSzczegolowe>
    </csta:Zalacznik_CIT-ST_A>
    </ea:DataRepeater>
    </czst:Zalaczniki>
    </czst:Zalacznik_CIT-ST>	
	</ea:DataRepeater>                
        
        <ea:Section ID="ORD_ZU" runat="server">
    <zzu:Zalacznik_ORD-ZU>
	    <zzu:Naglowek>
            <zzu:KodFormularza kodSystemowy="ORD-ZU (2)" wersjaSchemy="2-0E">ORD-ZU</zzu:KodFormularza>
            <zzu:WariantFormularza>2</zzu:WariantFormularza>
	    </zzu:Naglowek>
	    <zzu:PozycjeSzczegolowe>
	        <zzu:P_13><ea:XmlDataLabel runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/></zzu:P_13>
	    </zzu:PozycjeSzczegolowe>
	</zzu:Zalacznik_ORD-ZU></ea:Section>
	</Zalaczniki>
</Deklaracja>
