﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.CIT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>


<script runat="server">
	CIT8_27 dek;

    private struct GrupaCitBR
    {
        public string Nazwa { get; set; }
        public string KodKraju { get; set; }
        public string Wojewodztwo { get; set; }
        public string Powiat { get; set; }
        public string Gmina { get; set; }
        public string Ulica { get; set; }
        public string NrDomu { get; set; }
        public string NrLokalu { get; set; }
        public string Miejscowosc { get; set; }
        public string KodPocztowy { get; set; }
        public string Poczta { get; set; }
    }

    private struct GrupaCitMIT
    {
        public string NazwaST { get; set; }
        public decimal WartoscPoczatkowa { get; set; }
        public bool ZmianaWartosciPoczatkowej { get; set; }
        public decimal ZmienionaWartoscPoczatkowa { get; set; }
        public decimal Przychod1 { get; set; }
        public decimal Przychod2 { get; set; }
        public decimal Przychod3 { get; set; }
        public decimal Przychod4 { get; set; }
        public decimal Przychod5 { get; set; }
        public decimal Przychod6 { get; set; }
        public decimal Przychod7 { get; set; }
        public decimal Przychod8 { get; set; }
        public decimal Przychod9 { get; set; }
        public decimal Przychod10 { get; set; }
        public decimal Przychod11 { get; set; }
        public decimal Przychod12 { get; set; }
        public decimal Przychod13 { get; set; }
        public decimal Przychod14 { get; set; }
        public decimal Przychod15 { get; set; }
        public decimal Przychod16 { get; set; }
        public decimal Przychod17 { get; set; }
        public decimal Przychod18 { get; set; }
        public decimal Przychod19 { get; set; }
        public decimal Przychod20 { get; set; }
        public decimal Przychod21 { get; set; }
        public decimal Przychod22 { get; set; }
        public decimal Przychod23 { get; set; }
    }

    private struct GrupaBCit8S
    {
        public string NumerZezwolenia { get; set; }
        public Date DataWydania { get; set; }
        public Date DataRozpoczecia { get; set; }
        public string NazwaPodmiotu { get; set; }
        public string NIP { get; set; }
        public Percent Udzial { get; set; }
        public decimal MaxPomoc { get; set; }
        public decimal MaxPomocDyskonto { get; set; }
        public decimal Koszty { get; set; }
        public decimal KosztyDyskonto { get; set; }
        public decimal Pomoc { get; set; }
        public decimal PomocDyskonto { get; set; }
        public decimal InneWsparcie { get; set; }
        public decimal InneWsparcieDyskonto { get; set; }
    }

    private struct GrupaCCit8S
    {
        public string NumerZezwolenia { get; set; }
        public Date DataWydania { get; set; }
        public decimal Przychody { get; set; }
        public decimal Koszty { get; set; }
        public decimal Dochod { get; set; }
        public decimal Strata { get; set; }
    }

    private struct GrupaDCit8S
    {
        public string NumerZezwolenia { get; set; }
        public Date DataCofniecia { get; set; }
        public decimal KwotaPodatku { get; set; }
        public decimal DochodZwolniony { get; set; }
    }

    private int TakNie(bool value)
    {
        return value ? 1 : 2;
    }

    private int Tak(bool value)
    {
        return value ? 1 : 0;
    }

	private void OnContextLoad(Object sender, EventArgs args)
    {
		dek = (CIT8_27)dc[typeof(CIT8_27)];

		ORD_ZU.Visible = dek.TreśćUzasadnienia != "";

        P19.EditValue = TakNie((bool)dek.Bloki["B3"]["OdsetkiTak"]);
        P21.EditValue = TakNie((bool)dek.Bloki["B3"]["PrzedsiebiorstwoFinansoweTak"]);

        if ((bool)dek.Bloki["B3"]["ZwolnienieTak"])
            P24.EditValue = 1;
        else if ((bool)dek.Bloki["B3"]["ZwolnienieUtracil"])
            P24.EditValue = 2;
        else if ((bool)dek.Bloki["B3"]["ZwolnienieNie"])
            P24.EditValue = 3;

        P25.EditValue = TakNie((bool)dek.Bloki["B3"]["ZwrotOdliczeniaTak"]);
        P26.EditValue = TakNie((bool)dek.Bloki["B3"]["Dokumentacja9A11Tak"]);
        P27.EditValue = TakNie((bool)dek.Bloki["B3"]["Dokumentacja9A123Tak"]);
        P28.EditValue = TakNie((bool)dek.Bloki["B3"]["Dokumentacja9A2DTak"]);
        P29.EditValue = TakNie((bool)dek.Bloki["B3"]["Dokumentacja9A2BTak"]);
        P29A.EditValue = TakNie((bool)dek.Bloki["B3"]["MajatekPozaRPTak"]);
        SecP29A.Visible = (bool)dek.Bloki["B3"]["MajatekPozaRPTak"];
        P265.EditValue = TakNie((bool)dek.Bloki["L"]["InnyRokPodatkowyTak"]);

		if(string.IsNullOrEmpty((string) dek.Bloki["E4"]["InneDoliczeniaTytul"]) && (decimal) dek.Bloki["E4"]["InneDoliczeniaKwota"] == 0m)
			SecInneDoliczenia.Visible = false;

		if (string.IsNullOrEmpty((string)dek.Bloki["F"]["Nalezny20Rok"]))
			SecNalezny20.Visible = false;

		if ((decimal)dek.Bloki["H"]["Nadplata"] == 0m)
			SecNadplataH.Visible = false;
		else
			SecNiedoplata.Visible = false;

		if ((decimal)dek.Bloki["I"]["DoZaplaty"] == 0m)
			SecDoZaplaty.Visible = false;
		else
			SecNadplataI.Visible = false;

        Zalaczniki.Visible = !dek.Deklaracje.IsEmpty;
		var city8O = new List<CIT8O_14>();
        var cityD = new List<CITD_6>();
        var citst = new List<CITST_7>();
	    var cityBR = new List<CIT8BR_5>();
        var grupyBR = new List<GrupaCitBR>();
        var cityMIT = new List<CITMIT_2>();
        var grupyMIT = new List<GrupaCitMIT>();
        var city8SP = new List<CIT8SP_2>();
        var grupyB8SP = new List<GrupaBCit8S>();
        var grupyC8SP = new List<GrupaCCit8S>();
        var grupyD8SP = new List<GrupaDCit8S>();
        var city8S = new List<CIT8S_2>();
        var grupyB8S = new List<GrupaBCit8S>();
        var grupyC8S = new List<GrupaCCit8S>();
        var grupyD8S = new List<GrupaDCit8S>();

		foreach (Deklaracja z in dek.Deklaracje)
			if (z is CIT8O_14)
				city8O.Add((CIT8O_14)z);
            else if (z is CITST_7)
                citst.Add((CITST_7)z);
            else if (z is CITD_6)
                cityD.Add((CITD_6)z);
            else if (z is CIT8BR_5)
                cityBR.Add((CIT8BR_5)z);
            else if (z is CITMIT_2)
                cityMIT.Add((CITMIT_2)z);
            else if (z is CIT8SP_2)
                city8SP.Add((CIT8SP_2)z);
            else if (z is CIT8S_2)
                city8S.Add((CIT8S_2)z);

	    foreach (CIT8BR_5 br in cityBR)
	    {
            string blk = "F";
	        for (int i = 1; i <= 3; i++)
	        {
	            if (((string) br.Bloki[blk + i + "1"]["NazwaJednostki"]).IsNullOrEmpty())
	                continue;
	            grupyBR.Add(new GrupaCitBR
	            {
	                Nazwa = (string)br.Bloki[blk + i + "1"]["NazwaJednostki"],
                    KodKraju =  GetKodKraju(br.Session, (string)br.Bloki[blk + i + "2"]["Kraj"]),
                    Wojewodztwo = (string)br.Bloki[blk + i + "2"]["Wojew"],
                    Powiat = (string)br.Bloki[blk + i + "2"]["Powiat"],
                    Gmina = (string)br.Bloki[blk + i + "2"]["Gmina"],
                    Ulica = (string)br.Bloki[blk + i + "2"]["Ulica"],
                    NrDomu = (string)br.Bloki[blk + i + "2"]["NrDomu"],
                    NrLokalu = (string)br.Bloki[blk + i + "2"]["NrLokalu"],
                    Miejscowosc = (string)br.Bloki[blk + i + "2"]["Miejsc"],
                    KodPocztowy = (string)br.Bloki[blk + i + "2"]["KodPoczt"],
                    Poczta = (string)br.Bloki[blk + i + "2"]["Poczta"]
	            });
	        }
        }

        foreach (CITMIT_2 mit in cityMIT)
        {
            string blk = "B";
            for (int i = 1; i<=4; i++)
            {
                if (((string)mit.Bloki[blk+i]["NazwaST"]).IsNullOrEmpty())
                    continue;
                grupyMIT.Add(new GrupaCitMIT
                {
                    NazwaST = (string)mit.Bloki[blk+i]["NazwaST"],
                    WartoscPoczatkowa = (decimal)mit.Bloki[blk+i]["WartoscPoczatkowa"],
                    ZmianaWartosciPoczatkowej = (bool)mit.Bloki[blk+i]["ZmianaWartosciPoczatkowej"],
                    ZmienionaWartoscPoczatkowa = (decimal)mit.Bloki[blk+i]["ZmienionaWartoscPoczatkowa"],
                    Przychod1 = (decimal)mit.Bloki[blk+i+"1"]["Przychod1"],
                    Przychod2 = (decimal)mit.Bloki[blk+i+"1"]["Przychod2"],
                    Przychod3 = (decimal)mit.Bloki[blk+i+"1"]["Przychod3"],
                    Przychod4 = (decimal)mit.Bloki[blk+i+"1"]["Przychod4"],
                    Przychod5 = (decimal)mit.Bloki[blk+i+"1"]["Przychod5"],
                    Przychod6 = (decimal)mit.Bloki[blk+i+"1"]["Przychod6"],
                    Przychod7 = (decimal)mit.Bloki[blk+i+"1"]["Przychod7"],
                    Przychod8 = (decimal)mit.Bloki[blk+i+"1"]["Przychod8"],
                    Przychod9 = (decimal)mit.Bloki[blk+i+"1"]["Przychod9"],
                    Przychod10 = (decimal)mit.Bloki[blk+i+"1"]["Przychod10"],
                    Przychod11 = (decimal)mit.Bloki[blk+i+"1"]["Przychod11"],
                    Przychod12 = (decimal)mit.Bloki[blk+i+"1"]["Przychod12"],
                    Przychod13 = (decimal)mit.Bloki[blk+i+"1"]["Przychod13"],
                    Przychod14 = (decimal)mit.Bloki[blk+i+"1"]["Przychod14"],
                    Przychod15 = (decimal)mit.Bloki[blk+i+"1"]["Przychod15"],
                    Przychod16 = (decimal)mit.Bloki[blk+i+"1"]["Przychod16"],
                    Przychod17 = (decimal)mit.Bloki[blk+i+"1"]["Przychod17"],
                    Przychod18 = (decimal)mit.Bloki[blk+i+"1"]["Przychod18"],
                    Przychod19 = (decimal)mit.Bloki[blk+i+"1"]["Przychod19"],
                    Przychod20 = (decimal)mit.Bloki[blk+i+"1"]["Przychod20"],
                    Przychod21 = (decimal)mit.Bloki[blk+i+"1"]["Przychod21"],
                    Przychod22 = (decimal)mit.Bloki[blk+i+"1"]["Przychod22"],
                    Przychod23 = (decimal)mit.Bloki[blk+i+"1"]["Przychod23"],
                });
            }
        }

        foreach (CIT8SP_2 csp in city8SP)
        {
            string blk = "B";
            for (int i = 1; i<=2; i++)
            {
                if (((string)csp.Bloki[blk+i]["NumerZezwolenia"]).IsNullOrEmpty() && grupyB8SP.Any())
                    continue;
                grupyB8SP.Add(new GrupaBCit8S
                {
                    NumerZezwolenia = (string)csp.Bloki[blk+i]["NumerZezwolenia"],
                    DataWydania = (Date)csp.Bloki[blk+i]["DataWydania"],
                    DataRozpoczecia = (Date)csp.Bloki[blk+i]["DataRozpoczecia"],
                    NazwaPodmiotu = (string)csp.Bloki[blk+i]["NazwaPodmiotu"],
                    NIP = (string)csp.Bloki[blk+i]["NIP"],
                    Udzial = (Percent)csp.Bloki[blk+i]["Udzial"],
                    MaxPomoc = (decimal)csp.Bloki[blk+i+"1"]["MaxPomoc"],
                    MaxPomocDyskonto = (decimal)csp.Bloki[blk+i+"1"]["MaxPomocDyskonto"],
                    Koszty = (decimal)csp.Bloki[blk+i+"1"]["Koszty"],
                    KosztyDyskonto = (decimal)csp.Bloki[blk+i+"1"]["KosztyDyskonto"],
                    Pomoc = (decimal)csp.Bloki[blk+i+"1"]["Pomoc"],
                    PomocDyskonto = (decimal)csp.Bloki[blk+i+"1"]["PomocDyskonto"],
                    InneWsparcie = (decimal)csp.Bloki[blk+i+"1"]["InneWsparcie"],
                    InneWsparcieDyskonto = (decimal)csp.Bloki[blk+i+"1"]["InneWsparcieDyskonto"],
                });
            }

            blk = "C";
            for (int i = 1; i<=3; i++)
            {
                if (((string)csp.Bloki[blk+i]["NumerZezwolenia"]).IsNullOrEmpty() && grupyC8SP.Any())
                    continue;
                grupyC8SP.Add(new GrupaCCit8S
                {
                    NumerZezwolenia = (string)csp.Bloki[blk+i]["NumerZezwolenia"],
                    DataWydania = (Date)csp.Bloki[blk+i]["DataWydania"],
                    Przychody = (decimal)csp.Bloki[blk+i]["Przychody"],
                    Koszty = (decimal)csp.Bloki[blk+i]["Koszty"],
                    Dochod = (decimal)csp.Bloki[blk+i]["Dochod"],
                    Strata = (decimal)csp.Bloki[blk+i]["Strata"],
                });
            }

            blk = "D";
            if (((string)csp.Bloki[blk]["NumerZezwolenia"]).IsNullOrEmpty())
                continue;
            grupyD8SP.Add(new GrupaDCit8S
            {
                NumerZezwolenia = (string)csp.Bloki[blk]["NumerZezwolenia"],
                DataCofniecia = (Date)csp.Bloki[blk]["DataCofniecia"],
                KwotaPodatku = (decimal)csp.Bloki[blk]["KwotaPodatku"],
                DochodZwolniony = (decimal)csp.Bloki[blk]["DochodZwolniony"],
            });
        }

        foreach (CIT8S_2 cs in city8S)
        {
            string blk = "B";
            for (int i = 1; i<=2; i++)
            {
                if (((string)cs.Bloki[blk+i]["NumerZezwolenia"]).IsNullOrEmpty() && grupyB8S.Any())
                    continue;
                grupyB8S.Add(new GrupaBCit8S
                {
                    NumerZezwolenia = (string)cs.Bloki[blk+i]["NumerZezwolenia"],
                    DataWydania = (Date)cs.Bloki[blk+i]["DataWydania"],
                    DataRozpoczecia = (Date)cs.Bloki[blk+i]["DataRozpoczecia"],
                    MaxPomoc = (decimal)cs.Bloki[blk+i+"1"]["MaxPomoc"],
                    MaxPomocDyskonto = (decimal)cs.Bloki[blk+i+"1"]["MaxPomocDyskonto"],
                    Koszty = (decimal)cs.Bloki[blk+i+"1"]["Koszty"],
                    KosztyDyskonto = (decimal)cs.Bloki[blk+i+"1"]["KosztyDyskonto"],
                    Pomoc = (decimal)cs.Bloki[blk+i+"1"]["Pomoc"],
                    PomocDyskonto = (decimal)cs.Bloki[blk+i+"1"]["PomocDyskonto"],
                    InneWsparcie = (decimal)cs.Bloki[blk+i+"1"]["InneWsparcie"],
                    InneWsparcieDyskonto = (decimal)cs.Bloki[blk+i+"1"]["InneWsparcieDyskonto"],
                });
            }
            blk = "C";
            for (int i = 1; i<=2; i++)
            {
                if (((string)cs.Bloki[blk+i]["NumerZezwolenia"]).IsNullOrEmpty())
                    continue;
                grupyC8S.Add(new GrupaCCit8S
                {
                    NumerZezwolenia = (string)cs.Bloki[blk+i]["NumerZezwolenia"],
                    DataWydania = (Date)cs.Bloki[blk+i]["DataWydania"],
                    Przychody = (decimal)cs.Bloki[blk+i]["Przychody"],
                    Koszty = (decimal)cs.Bloki[blk+i]["Koszty"],
                    Dochod = (decimal)cs.Bloki[blk+i]["Dochod"],
                    Strata = (decimal)cs.Bloki[blk+i]["Strata"],
                });
            }
            blk = "D";
            if (((string)cs.Bloki[blk]["NumerZezwolenia"]).IsNullOrEmpty())
                continue;
            grupyD8S.Add(new GrupaDCit8S
            {
                NumerZezwolenia = (string)cs.Bloki[blk]["NumerZezwolenia"],
                DataCofniecia = (Date)cs.Bloki[blk]["DataCofniecia"],
                KwotaPodatku = (decimal)cs.Bloki[blk]["KwotaPodatku"],
                DochodZwolniony = (decimal)cs.Bloki[blk]["DochodZwolniony"],
            });
        }

	    CIT8O.DataSource = city8O;
        CITST_REP.DataSource = citst;
        CITD_Repeater.DataSource = cityD;
	    CITBR.DataSource = cityBR.Take(1);
        CITBR_P_F.DataSource = grupyBR;
        CITMIT.DataSource = cityMIT.Take(1);
        CITMIT_P_B.DataSource = grupyMIT;
        CIT8SP.DataSource = city8SP.Take(1);
        CIT8SP_P_B.DataSource = grupyB8SP;
        CIT8SP_P_C.DataSource = grupyC8SP;
        CIT8SP_P_D.DataSource = grupyD8SP;
        CIT8S.DataSource = city8S.Take(1);
        CIT8S_P_B.DataSource = grupyB8S;
        CIT8S_P_C.DataSource = grupyC8S;
        CIT8S_P_D.DataSource = grupyD8S;

        P_36.EditValue = Tak(cityMIT.Any());
        P_37.EditValue = Tak(city8SP.Any());
        P_38.EditValue = Tak(city8S.Any());
    }


	void CIT8O_BeforeRow(Object sender, EventArgs args)
    {
		var cit8O = (CIT8O_14)CIT8O.CurrentRow;
		CIT8O_Od.EditValue = dek.Bloki["0"]["Od"];
		CIT8O_Do.EditValue = dek.Bloki["0"]["Do"];

		if (string.IsNullOrEmpty((string)cit8O.Bloki["B1"]["InneTytul"]))
			SecInneDochody.Visible = false;

		if (string.IsNullOrEmpty((string)cit8O.Bloki["B21"]["Rok1"]))
			B21Rok1.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O.Bloki["B21"]["Rok2"]))
			B21Rok2.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O.Bloki["B21"]["Rok3"]))
			B21Rok3.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O.Bloki["B21"]["Rok4"]))
			B21Rok4.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O.Bloki["B21"]["Rok5"]))
            B21Rok5.Visible = false;

        if (string.IsNullOrEmpty((string)cit8O.Bloki["B22"]["Rok1"]))
			B22Rok1.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O.Bloki["B22"]["Rok2"]))
			B22Rok2.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O.Bloki["B22"]["Rok3"]))
			B22Rok3.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O.Bloki["B22"]["Rok4"]))
			B22Rok4.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O.Bloki["B22"]["Rok5"]))
            B22Rok5.Visible = false;

        if (string.IsNullOrEmpty((string)cit8O.Bloki["B23"]["Rok1"]))
			B23Rok1.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O.Bloki["B23"]["Rok2"]))
			B23Rok2.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O.Bloki["B23"]["Rok3"]))
			B23Rok3.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O.Bloki["B23"]["Rok4"]))
			B23Rok4.Visible = false;
		if (string.IsNullOrEmpty((string)cit8O.Bloki["B23"]["Rok5"]))
			B23Rok5.Visible = false;

		if (string.IsNullOrEmpty((string)cit8O.Bloki["B3"]["InneTytul"]))
            SecInneOdliczenia.Visible = false;

		if ((Soneta.Types.Date)cit8O.Bloki["E"]["ZwolnienieDataDecyzji"] == Soneta.Types.Date.Empty ||
			string.IsNullOrEmpty((string)cit8O.Bloki["E"]["ZwolnienieDecyzja"]))
			SecZwolnienie.Visible = false;

		if ((Soneta.Types.Date)cit8O.Bloki["E"]["ZaniechanieDataRozporzadzenia"]==Soneta.Types.Date.Empty ||
			string.IsNullOrEmpty((string)cit8O.Bloki["E"]["ZaniechanieRozporzadzenie"]))
			SecZaniechanie.Visible = false;

		if (string.IsNullOrEmpty((string)cit8O.Bloki["E"]["InneTytul"]))
			SecObnizki.Visible = false;
	}


    private void CITBR_BeforeRow(Object sender, EventArgs args)
    {
        var citbr = (CIT8BR_5) CITBR.CurrentRow;
        var bloki = citbr.Bloki;

        CITBR_Od.EditValue = dek.Bloki["0"]["Od"];
        CITBR_Do.EditValue = dek.Bloki["0"]["Do"];

        StatusCentrum.EditValue = TakNie((bool) bloki["A"]["StatusCentrumTak"]);
        if ((bool) bloki["A"]["StatusCentrumNie"])
            SecStatusCentrum.Visible = false;
        if ((bool) bloki["A"]["MikrofirmaTak"] || (bool) bloki["A"]["MikrofirmaNie"])
        {
            Mikrofirma.EditValue = TakNie((bool) bloki["A"]["MikrofirmaTak"]);
        }
        else
        {
            Mikrofirma.Visible = false;
        }
        if(((string) bloki["D1"]["Nazwa"]).IsNullOrEmpty())
             D_DaneSpolki.Visible = false;
            
        SpolkaMikrofirma.EditValue = TakNie((bool) bloki["D1"]["MikrofirmaTak"]);

        BadaniaNaukowe.EditValue = TakNie((bool) bloki["E"]["BadaniaNaukoweTak"]);
        PraceRozwojowe.EditValue = TakNie((bool) bloki["E"]["PraceRozwojoweTak"]);
        BadaniaPodstawowe.EditValue = Tak((bool) bloki["E1"]["BadaniaPodstawowe"]);
        BadaniaAplikacyjne.EditValue = Tak((bool) bloki["E1"]["BadaniaAplikacyjne"]);
    }


    private void CITD_BeforeRow(Object sender, EventArgs args)
    {
        var citd = (CITD_6)CITD_Repeater.CurrentRow;
        var session = citd.Session;

        CITD_Od.EditValue = dek.Bloki["0"]["Od"];
        CITD_Do.EditValue = dek.Bloki["0"]["Do"];

        var bloki = citd.Bloki;

        var blokB1 = bloki["B1"];
        if ((bool) blokB1["Otrzymujacy"])
        {
            CITD_RodzajPodatnika.EditValue = 1;
        }
        else if ((bool) blokB1["Przekazujacy"])
        {
            CITD_RodzajPodatnika.EditValue = 2;
        }
        else if ((bool) blokB1["OtrzymujacyPrzekazujacy"])
        {
            CITD_RodzajPodatnika.EditValue = 3;
        }

        CITD_DaneDarczyncy1.Visible = !((string) bloki["C11"]["NazwaPelna"]).IsNullOrEmpty();
        CITD_DaneDarczyncy2.Visible = !((string) bloki["C21"]["NazwaPelna"]).IsNullOrEmpty();
        CITD_DaneDarczyncy3.Visible = !((string) bloki["C31"]["NazwaPelna"]).IsNullOrEmpty();

        CITDC12KodKraju.EditValue = GetKodKraju(session, (string) bloki["C12"]["Kraj"]);
        CITDC22KodKraju.EditValue = GetKodKraju(session, (string) bloki["C22"]["Kraj"]);
        CITDC32KodKraju.EditValue = GetKodKraju(session, (string) bloki["C32"]["Kraj"]);

        CITD_Obdarowany1.Visible = CzyWidocznyObdarowany(bloki["D1"]);
        CITD_Obdarowany2.Visible = CzyWidocznyObdarowany(bloki["D2"]);
        CITD_Obdarowany3.Visible = CzyWidocznyObdarowany(bloki["D3"]);

        CITDD12KodKraju.EditValue = GetKodKraju(session, (string)bloki["D12"]["Kraj"]);
        CITDD22KodKraju.EditValue = GetKodKraju(session, (string)bloki["D22"]["Kraj"]);
        CITDD32KodKraju.EditValue = GetKodKraju(session, (string)bloki["D32"]["Kraj"]);
    }

    private void CITMIT_BeforeRow(Object sender, EventArgs args)
    {
        var citmit = (CITMIT_2)CITMIT.CurrentRow;

        CITMIT_Od.EditValue = dek.Bloki["0"]["Od"];
        CITMIT_Do.EditValue = dek.Bloki["0"]["Do"];
    }

    private void CIT8SP_BeforeRow(Object sender, EventArgs args)
    {
        var cit8sp = (CIT8SP_2)CIT8SP.CurrentRow;

        CIT8SP_Od.EditValue = dek.Bloki["0"]["Od"];
        CIT8SP_Do.EditValue = dek.Bloki["0"]["Do"];

        CIT8SP_KosztyKwalifikowane.Visible =
            ((decimal)cit8sp.Bloki["E"]["KwotaKosztowB+R"] > 0m)
            && !string.IsNullOrEmpty((string)cit8sp.Bloki["E"]["NumerZezwolenia"]);
    }

    private void CIT8S_BeforeRow(Object sender, EventArgs args)
    {
        var cit8s = (CIT8S_2)CIT8S.CurrentRow;

        CIT8S_Od.EditValue = dek.Bloki["0"]["Od"];
        CIT8S_Do.EditValue = dek.Bloki["0"]["Do"];

        CIT8S_KosztyKwalifikowane.Visible =
            ((decimal)cit8s.Bloki["E"]["KwotaKosztowB+R"] > 0m)
            && !string.IsNullOrEmpty((string)cit8s.Bloki["E"]["NumerZezwolenia"]);
    }

    private static bool CzyWidocznyObdarowany(BlokDeklaracji blok)
    {
        return
            ((decimal) blok["KwotaPrzekazana"]) != 0m ||
            ((decimal) blok["KwotaOdliczona"]) != 0m;
    }


    private void CITST_BeforeRow(Object sender, EventArgs args) {
        var dek = (CITST_7)CITST_REP.CurrentRow;
        var oddziały = new List<CITST_7_Multi>();
        var sta = new List<CITSTA_5>();
        foreach (Deklaracja pit in dek.Deklaracje)
            if (pit is CITST_7_Multi)
                oddziały.Add((CITST_7_Multi)pit);
            else if (pit is CITSTA_5)
                sta.Add((CITSTA_5)pit);

        CITSTM_REP.DataSource = oddziały;
        CITSTA_REP.DataSource = sta;
        ZalacznikiST.Visible = sta.Count > 0;
}


    protected void CITSTM_BeforeRow(object sender, EventArgs e)
    {
    }


    protected void CITSTA_BeforeRow(object sender, EventArgs e)
    {
        var dek = (CITSTA_5)CITSTA_REP.CurrentRow;
        CITSTAM_REP.DataSource = dek.Deklaracje;
    }


    protected void CITSTAM_BeforeRow(object sender, EventArgs e)
    {
    }


    private static string GetKodKraju(Session session, string nazwaKraju)
    {
        var krajTbl = session.Get<CoreModule>().KrajeTbl.WgNazwa[nazwaKraju];
        return krajTbl != null ? krajTbl.Kod2 : "";
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.CIT.CIT8_27,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja
    xsi:schemaLocation="http://crd.gov.pl/wzor/2019/03/29/7439/ http://crd.gov.pl/wzor/2019/03/29/7439/schemat.xsd"
    xmlns="http://crd.gov.pl/wzor/2019/03/29/7439/"
    xmlns:czbr="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2019/03/26/eD/CITBR/"
    xmlns:czd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2019/03/26/eD/CITD/"
    xmlns:czmit="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2019/03/26/eD/CITMIT/"
    xmlns:czmt="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/SPRMT/"
    xmlns:czst="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2019/01/24/eD/CITSTZ/" 
    xmlns:csta="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2019/01/24/eD/CITSTA/"
    xmlns:cz8o="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2019/03/26/eD/CIT8O/"
    xmlns:cz8s="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2019/03/26/eD/CIT8S/"
    xmlns:cz8sp="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2019/03/26/eD/CIT8SP/"
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
    xmlns:ssr="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/SSER/"
    xmlns:tns="http://crd.gov.pl/wzor/2019/03/29/7439/"
    xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/ORDZU/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

	<Naglowek>
		<KodFormularza kodSystemowy="CIT-8 (27)" kodPodatku="CIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">CIT-8</KodFormularza>
		<WariantFormularza>27</WariantFormularza>
		<CelZlozenia poz="P_7"><ea:XmlDataLabel ID="CelZlozenia" runat="server" DataMember="A.CelKorekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<OkresOd poz="P_4"><ea:XmlDataLabel runat="server" DataMember="0.Od" XSDType="TData"  /></OkresOd>
		<OkresDo poz="P_5"><ea:XmlDataLabel runat="server" DataMember="0.Do" XSDType="TData"  /></OkresDo>
		<KodUrzedu><ea:XmlDataLabel ID="DataLabel4" runat="server" DataMember="X.KodUrzeduSkarbowego" /></KodUrzedu>
	</Naglowek>

	<Podmiot1 rola="Podatnik">
		<OsobaNiefizyczna>
			<ea:XmlDataLabel runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP" />
			<ea:XmlDataLabel ID="NazwaPelna" runat="server" ElementName="PelnaNazwa" DataMember="B1.Nazwa" XSDType="TZnakowy" />
		</OsobaNiefizyczna>
		<AdresSiedziby rodzajAdresu="RAD">
			<etd:AdresPol>
				<etd:KodKraju>PL</etd:KodKraju>
				<etd:Wojewodztwo><ea:XmlDataLabel ID="XmlDataLabel3" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin" /></etd:Wojewodztwo>
				<etd:Powiat><ea:XmlDataLabel ID="XmlDataLabel4" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin" /></etd:Powiat>
				<etd:Gmina><ea:XmlDataLabel ID="XmlDataLabel5" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin" /></etd:Gmina>
				<ea:XmlDataLabel ID="XmlDataLabel6" runat="server" ElementName="etd:Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica" />
				<etd:NrDomu><ea:XmlDataLabel ID="XmlDataLabel7" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku" /></etd:NrDomu>
				<ea:XmlDataLabel ID="XmlDataLabel8" runat="server" ElementName="etd:NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu" />
				<etd:Miejscowosc><ea:XmlDataLabel ID="XmlDataLabel9" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc" /></etd:Miejscowosc>
				<etd:KodPocztowy><ea:XmlDataLabel ID="XmlDataLabel10" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy" /></etd:KodPocztowy>
				<etd:Poczta><ea:XmlDataLabel ID="XmlDataLabel11" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc" /></etd:Poczta>
			</etd:AdresPol>
		</AdresSiedziby>
	</Podmiot1>

	<PozycjeSzczegolowe>
        <ea:XmlDataLabel runat="server" ElementName="P_19" ID="P19" />
        <ea:XmlDataLabel runat="server" ElementName="P_20" HideEmptyOrZero="true" DataMember="B3.KwotaOdsetek" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_21" ID="P21" />
        <ea:XmlDataLabel runat="server" ElementName="P_22" HideEmptyOrZero="true" DataMember="B3.FinansowanieDluzne" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_23" HideEmptyOrZero="true" DataMember="B3.WylaczenieArt15E" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_24" ID="P24" />
        <ea:XmlDataLabel runat="server" ElementName="P_25" ID="P25" />
        <ea:XmlDataLabel runat="server" ElementName="P_26" ID="P26" />
        <ea:XmlDataLabel runat="server" ElementName="P_27" ID="P27" />
        <ea:XmlDataLabel runat="server" ElementName="P_28" ID="P28" />
        <ea:XmlDataLabel runat="server" ElementName="P_29" ID="P29" />
        <ea:Section runat="server" ID="SecP29A">
            <ea:XmlDataLabel runat="server" ElementName="P_29A" ID="P29A" />
            <ea:XmlDataLabel runat="server" ElementName="P_29B" DataMember="B3.MajatekPozaRPWartosc" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_29C" DataMember="B3.MajatekPozaRPTerminPowrot" XSDType="TData" />
        </ea:Section>

        <ea:XmlDataLabel runat="server" ElementName="P_30" HideEmptyOrZero="true" DataMember="C.CIT-ST" />
        <ea:XmlDataLabel runat="server" ElementName="P_31" HideEmptyOrZero="true" DataMember="C.SSE-R" />
        <ea:XmlDataLabel runat="server" ElementName="P_32" HideEmptyOrZero="true" DataMember="C.CIT-8/O" />
        <ea:XmlDataLabel runat="server" ElementName="P_33" HideEmptyOrZero="true" DataMember="C.CIT-8/BR" />
        <ea:XmlDataLabel runat="server" ElementName="P_34" HideEmptyOrZero="true" DataMember="C.CIT-D" />
        <ea:XmlDataLabel runat="server" ElementName="P_35" HideEmptyOrZero="true" DataMember="C.Sprawozdanie" />
        <ea:XmlDataLabel runat="server" ElementName="P_36" HideEmptyOrZero="true" ID="P_36" />
        <ea:XmlDataLabel runat="server" ElementName="P_37" HideEmptyOrZero="true" ID="P_37" />
        <ea:XmlDataLabel runat="server" ElementName="P_38" HideEmptyOrZero="true" ID="P_38" />

		<ea:XmlDataLabel runat="server" ElementName="P_39" HideEmptyOrZero="true" DataMember="D1.RP" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_40" HideEmptyOrZero="true" DataMember="D1.RPIz" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_41" HideEmptyOrZero="true" DataMember="D1.PozaRP" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_42" HideEmptyOrZero="true" DataMember="D1.PozaRPIz" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_43" HideEmptyOrZero="true" DataMember="D1.PozaRPInne" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_44" HideEmptyOrZero="true" DataMember="D1.PozaRPInneIz" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_45" HideEmptyOrZero="true" DataMember="D1.WkladNiepieniezny" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_46" HideEmptyOrZero="true" DataMember="D1.WkladNiepienieznyIz" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_47" DataMember="D1.Razem" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_48" DataMember="D1.RazemIz" XSDType="TKwota2" />

        <ea:XmlDataLabel runat="server" ElementName="P_49" HideEmptyOrZero="true" DataMember="D2.RP" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_50" HideEmptyOrZero="true" DataMember="D2.RPIz" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_51" HideEmptyOrZero="true" DataMember="D2.PozaRP" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_52" HideEmptyOrZero="true" DataMember="D2.PozaRPIz" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_53" HideEmptyOrZero="true" DataMember="D2.PozaRPInne" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_54" HideEmptyOrZero="true" DataMember="D2.PozaRPInneIz" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_55" HideEmptyOrZero="true" DataMember="D2.WkladNiepieniezny" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_56" HideEmptyOrZero="true" DataMember="D2.WkladNiepienieznyIz" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_57" HideEmptyOrZero="true" DataMember="D2.OdsetkiWylaczone" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_58" HideEmptyOrZero="true" DataMember="D2.OdsetkiWylaczoneIz" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_59" HideEmptyOrZero="true" DataMember="D2.KosztyFinansowania" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_60" HideEmptyOrZero="true" DataMember="D2.KosztyFinansowaniaIz" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_61" HideEmptyOrZero="true" DataMember="D2.KosztyArt15E" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_62" HideEmptyOrZero="true" DataMember="D2.KosztyArt15EIz" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_63" DataMember="D2.Razem" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_64" DataMember="D2.RazemIz" XSDType="TKwota2" />

        <ea:XmlDataLabel runat="server" ElementName="P_65" HideEmptyOrZero="true" DataMember="D3.DochodArt7" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_67" HideEmptyOrZero="true" DataMember="D3.StrataArt7" XSDType="TKwota2" />

        <ea:XmlDataLabel runat="server" ElementName="P_66" HideEmptyOrZero="true" DataMember="D3.DochodArt7Iz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_68" HideEmptyOrZero="true" DataMember="D3.StrataArt7Iz" XSDType="TKwota2" />

        <ea:XmlDataLabel runat="server" ElementName="P_69" HideEmptyOrZero="true" DataMember="D3.StrataInna" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_70" HideEmptyOrZero="true" DataMember="D3.StrataInnaIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_71" HideEmptyOrZero="true" DataMember="D3.Dochod" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_72" HideEmptyOrZero="true" DataMember="D3.DochodIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_73" HideEmptyOrZero="true" DataMember="D3.Strata" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_74" HideEmptyOrZero="true" DataMember="D3.StrataIz" XSDType="TKwota2" />

        <ea:XmlDataLabel runat="server" ElementName="P_75" HideEmptyOrZero="true" DataMember="E1.Wolne" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_76" HideEmptyOrZero="true" DataMember="E1.WolneIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_77" HideEmptyOrZero="true" DataMember="E1.DochodBezWolnych" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_78" HideEmptyOrZero="true" DataMember="E1.DochodBezWolnychIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_79" HideEmptyOrZero="true" DataMember="E1.StratyLatUbieglych2017" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_80" HideEmptyOrZero="true" DataMember="E1.StratyLatUbieglych2017Iz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_81" HideEmptyOrZero="true" DataMember="E1.DochodPoStratach2017" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_82" HideEmptyOrZero="true" DataMember="E1.DochodPoStratach2017Iz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_83" HideEmptyOrZero="true" DataMember="E1.StratyLatUbieglych" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_84" HideEmptyOrZero="true" DataMember="E1.StratyLatUbieglychIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_85" HideEmptyOrZero="true" DataMember="E1.InneOdliczenia" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_86" HideEmptyOrZero="true" DataMember="E1.InneOdliczeniaIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_87" HideEmptyOrZero="true" DataMember="E1.RazemOdliczenia" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_88" HideEmptyOrZero="true" DataMember="E1.RazemOdliczeniaIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_89" HideEmptyOrZero="true" DataMember="E1.Inwestycje" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_90" HideEmptyOrZero="true" DataMember="E1.InwestycjeIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_91" DataMember="E1.Razem" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_92" DataMember="E1.RazemIz" XSDType="TKwota2" />

		<ea:XmlDataLabel runat="server" ElementName="P_93" DataMember="E2.Podstawa" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_94" HideEmptyOrZero="true" DataMember="E2.Strata" XSDType="TKwota2" />

		<ea:XmlDataLabel runat="server" ElementName="P_95" HideEmptyOrZero="true" DataMember="E3.NoweTechnologie" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_96" HideEmptyOrZero="true" DataMember="E3.DziałalnośćBR" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_97" DataMember="E3.Razem" XSDType="TKwota2" />

		<ea:XmlDataLabel runat="server" ElementName="P_98" HideEmptyOrZero="true" DataMember="E4.Inwestycje" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_99" HideEmptyOrZero="true" DataMember="E4.Strefa" XSDType="TKwota2" />
		<ea:XmlDataLabel runat="server" ElementName="P_100" HideEmptyOrZero="true" DataMember="E4.NoweTechnologie" XSDType="TKwota2" />
		<ea:Section runat="server" ID="SecInneDoliczenia">
			<ea:XmlDataLabel runat="server" ElementName="P_101" DataMember="E4.InneDoliczeniaTytul" XSDType="TZnakowy" />
			<ea:XmlDataLabel runat="server" ElementName="P_102" DataMember="E4.InneDoliczeniaKwota" XSDType="TKwota2" />
		</ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_103" DataMember="E4.Razem" XSDType="TKwota2" />

		<ea:XmlDataLabel runat="server" ElementName="P_104" DataMember="E5.Podstawa" XSDType="TCalkowity" />
		<ea:XmlDataLabel runat="server" ElementName="P_105" HideEmptyOrZero="true" DataMember="E5.Strata" XSDType="TKwota2" />

        <ea:XmlDataLabel runat="server" ElementName="P_106" DataMember="F.Stawka" XSDType="TProcentowy" />
        <ea:XmlDataLabel runat="server" ElementName="P_107" DataMember="F.Nalezny" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_108" HideEmptyOrZero="true" DataMember="F.Odliczenia" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_109" DataMember="F.NaleznyPoOdliczeniach" XSDType="TCalkowity" />
        <ea:Section runat="server" ID="SecNalezny20">
	        <ea:XmlDataLabel runat="server" ElementName="P_110" DataMember="F.Nalezny20Rok" />
			<ea:XmlDataLabel runat="server" ElementName="P_111" DataMember="F.Nalezny20" XSDType="TCalkowity" />
        </ea:Section>

        <ea:XmlDataLabel runat="server" ElementName="P_112" HideEmptyOrZero="true" DataMember="G.1" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_118" HideEmptyOrZero="true" DataMember="G.NP1" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_124" HideEmptyOrZero="true" DataMember="G.ZP1" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_130" HideEmptyOrZero="true" DataMember="G.ZZ1" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_113" HideEmptyOrZero="true" DataMember="G.2" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_119" HideEmptyOrZero="true" DataMember="G.NP2" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_125" HideEmptyOrZero="true" DataMember="G.ZP2" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_131" HideEmptyOrZero="true" DataMember="G.ZZ2" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_114" HideEmptyOrZero="true" DataMember="G.3" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_120" HideEmptyOrZero="true" DataMember="G.NP3" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_126" HideEmptyOrZero="true" DataMember="G.ZP3" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_132" HideEmptyOrZero="true" DataMember="G.ZZ3" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_115" HideEmptyOrZero="true" DataMember="G.4" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_121" HideEmptyOrZero="true" DataMember="G.NP4" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_127" HideEmptyOrZero="true" DataMember="G.ZP4" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_133" HideEmptyOrZero="true" DataMember="G.ZZ4" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_116" HideEmptyOrZero="true" DataMember="G.5" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_122" HideEmptyOrZero="true" DataMember="G.NP5" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_128" HideEmptyOrZero="true" DataMember="G.ZP5" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_134" HideEmptyOrZero="true" DataMember="G.ZZ5" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_117" HideEmptyOrZero="true" DataMember="G.6" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_123" HideEmptyOrZero="true" DataMember="G.NP6" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_129" HideEmptyOrZero="true" DataMember="G.ZP6" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_135" HideEmptyOrZero="true" DataMember="G.ZZ6" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_136" HideEmptyOrZero="true" DataMember="G.7" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_142" HideEmptyOrZero="true" DataMember="G.NP7" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_148" HideEmptyOrZero="true" DataMember="G.ZP7" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_154" HideEmptyOrZero="true" DataMember="G.ZZ7" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_137" HideEmptyOrZero="true" DataMember="G.8" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_143" HideEmptyOrZero="true" DataMember="G.NP8" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_149" HideEmptyOrZero="true" DataMember="G.ZP8" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_155" HideEmptyOrZero="true" DataMember="G.ZZ8" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_138" HideEmptyOrZero="true" DataMember="G.9" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_144" HideEmptyOrZero="true" DataMember="G.NP9" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_150" HideEmptyOrZero="true" DataMember="G.ZP9" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_156" HideEmptyOrZero="true" DataMember="G.ZZ9" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_139" HideEmptyOrZero="true" DataMember="G.10" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_145" HideEmptyOrZero="true" DataMember="G.NP10" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_151" HideEmptyOrZero="true" DataMember="G.ZP10" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_157" HideEmptyOrZero="true" DataMember="G.ZZ10" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_140" HideEmptyOrZero="true" DataMember="G.11" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_146" HideEmptyOrZero="true" DataMember="G.NP11" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_152" HideEmptyOrZero="true" DataMember="G.ZP11" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_158" HideEmptyOrZero="true" DataMember="G.ZZ11" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_141" HideEmptyOrZero="true" DataMember="G.12" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_147" HideEmptyOrZero="true" DataMember="G.NP12" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_153" HideEmptyOrZero="true" DataMember="G.ZP12" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_159" HideEmptyOrZero="true" DataMember="G.ZZ12" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_160" HideEmptyOrZero="true" DataMember="G.13" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_166" HideEmptyOrZero="true" DataMember="G.NP13" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_172" HideEmptyOrZero="true" DataMember="G.ZP13" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_178" HideEmptyOrZero="true" DataMember="G.ZZ13" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_161" HideEmptyOrZero="true" DataMember="G.14" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_167" HideEmptyOrZero="true" DataMember="G.NP14" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_173" HideEmptyOrZero="true" DataMember="G.ZP14" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_179" HideEmptyOrZero="true" DataMember="G.ZZ14" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_162" HideEmptyOrZero="true" DataMember="G.15" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_168" HideEmptyOrZero="true" DataMember="G.NP15" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_174" HideEmptyOrZero="true" DataMember="G.ZP15" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_180" HideEmptyOrZero="true" DataMember="G.ZZ15" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_163" HideEmptyOrZero="true" DataMember="G.16" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_169" HideEmptyOrZero="true" DataMember="G.NP16" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_175" HideEmptyOrZero="true" DataMember="G.ZP16" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_181" HideEmptyOrZero="true" DataMember="G.ZZ16" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_164" HideEmptyOrZero="true" DataMember="G.17" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_170" HideEmptyOrZero="true" DataMember="G.NP17" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_176" HideEmptyOrZero="true" DataMember="G.ZP17" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_182" HideEmptyOrZero="true" DataMember="G.ZZ17" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_165" HideEmptyOrZero="true" DataMember="G.18" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_171" HideEmptyOrZero="true" DataMember="G.NP18" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_177" HideEmptyOrZero="true" DataMember="G.ZP18" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_183" HideEmptyOrZero="true" DataMember="G.ZZ18" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_184" HideEmptyOrZero="true" DataMember="G.19" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_190" HideEmptyOrZero="true" DataMember="G.NP19" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_196" HideEmptyOrZero="true" DataMember="G.ZP19" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_202" HideEmptyOrZero="true" DataMember="G.ZZ19" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_185" HideEmptyOrZero="true" DataMember="G.20" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_191" HideEmptyOrZero="true" DataMember="G.NP20" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_197" HideEmptyOrZero="true" DataMember="G.ZP20" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_203" HideEmptyOrZero="true" DataMember="G.ZZ20" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_186" HideEmptyOrZero="true" DataMember="G.21" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_192" HideEmptyOrZero="true" DataMember="G.NP21" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_198" HideEmptyOrZero="true" DataMember="G.ZP21" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_204" HideEmptyOrZero="true" DataMember="G.ZZ21" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_187" HideEmptyOrZero="true" DataMember="G.22" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_193" HideEmptyOrZero="true" DataMember="G.NP22" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_199" HideEmptyOrZero="true" DataMember="G.ZP22" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_205" HideEmptyOrZero="true" DataMember="G.ZZ22" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_188" HideEmptyOrZero="true" DataMember="G.23" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_194" HideEmptyOrZero="true" DataMember="G.NP23" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_200" HideEmptyOrZero="true" DataMember="G.ZP23" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_206" HideEmptyOrZero="true" DataMember="G.ZZ23" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_189" HideEmptyOrZero="true" DataMember="G.Razem" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_195" HideEmptyOrZero="true" DataMember="G.NPRazem" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_201" HideEmptyOrZero="true" DataMember="G.ZPRazem" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_207" HideEmptyOrZero="true" DataMember="G.ZZRazem" XSDType="TCalkowity" />

        <ea:Section runat="server" ID="SecNiedoplata">
            <ea:XmlDataLabel runat="server" ElementName="P_208" DataMember="H.Niedoplata" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecNadplataH">
            <ea:XmlDataLabel runat="server" ElementName="P_209" DataMember="H.Nadplata" XSDType="TCalkowity" />
        </ea:Section>

        <ea:XmlDataLabel runat="server" ElementName="P_210" HideEmptyOrZero="true" DataMember="I.RoznicaMiedzyPodatkiem" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_211" HideEmptyOrZero="true" DataMember="I.SumaWplat" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_212" HideEmptyOrZero="true" DataMember="I.KorektaBR" XSDType="TCalkowity" />

        <ea:Section runat="server" ID="SecDoZaplaty">
            <ea:XmlDataLabel runat="server" ElementName="P_213" DataMember="I.DoZaplaty" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecNadplataI">
            <ea:XmlDataLabel runat="server" ElementName="P_214" DataMember="I.Nadplata" XSDType="TCalkowity" />
        </ea:Section>

        <ea:XmlDataLabel runat="server" ElementName="P_215" DataMember="J.D1" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_221" DataMember="J.P1" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_216" DataMember="J.D2" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_222" DataMember="J.P2" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_217" DataMember="J.D3" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_223" DataMember="J.P3" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_218" DataMember="J.D4" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_224" DataMember="J.P4" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_219" DataMember="J.D5" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_225" DataMember="J.P5" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_220" DataMember="J.D6" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_226" DataMember="J.P6" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_227" DataMember="J.D7" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_233" DataMember="J.P7" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_228" DataMember="J.D8" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_234" DataMember="J.P8" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_229" DataMember="J.D9" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_235" DataMember="J.P9" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_230" DataMember="J.D10" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_236" DataMember="J.P10" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_231" DataMember="J.D11" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_237" DataMember="J.P11" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_232" DataMember="J.D12" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_238" DataMember="J.P12" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_239" DataMember="J.D13" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_245" DataMember="J.P13" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_240" DataMember="J.D14" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_246" DataMember="J.P14" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_241" DataMember="J.D15" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_247" DataMember="J.P15" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_242" DataMember="J.D16" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_248" DataMember="J.P16" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_243" DataMember="J.D17" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_249" DataMember="J.P17" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_244" DataMember="J.D18" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_250" DataMember="J.P18" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_251" DataMember="J.D19" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_256" DataMember="J.P19" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_252" DataMember="J.D20" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_257" DataMember="J.P20" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_253" DataMember="J.D21" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_258" DataMember="J.P21" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_254" DataMember="J.D22" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_259" DataMember="J.P22" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_255" DataMember="J.D23" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_260" DataMember="J.P23" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_261" DataMember="K.Dochody" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_262" DataMember="K.Nalezny" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" HideEmptyOrZero="true" ElementName="P_263" DataMember="K.KwotaNaliczona" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" HideEmptyOrZero="true" ElementName="P_264" DataMember="K.Odsetki" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_265" ID="P265" />
	</PozycjeSzczegolowe>

	<Pouczenia>1</Pouczenia>

    <ea:Section runat="server" ID="Zalaczniki">
	<Zalaczniki>
        <ea:DataRepeater ID="CITST_REP" runat="server" WithSections="False" OnBeforeRow="CITST_BeforeRow">
        	<czst:Zalacznik_CIT-ST>
                <czst:Naglowek>
                    <czst:KodFormularza kodSystemowy="CT-STR (7)" wersjaSchemy="6-0E">CIT-ST</czst:KodFormularza>
                    <czst:WariantFormularza>7</czst:WariantFormularza>
                    <czst:OkresOd poz="P_4"><ea:XmlDataLabel runat="server" DataMember="0.Od" XSDType="TData" /></czst:OkresOd>
                    <czst:OkresDo poz="P_5"><ea:XmlDataLabel runat="server" DataMember="0.Do" XSDType="TData" /></czst:OkresDo>
                </czst:Naglowek>
                <czst:PozycjeSzczegolowe>
                    <czst:P_9>2</czst:P_9>
                    <ea:XmlDataLabel ElementName="czst:P_22" runat="server" DataMember="D.LiczbaZatrudnionych" XSDType="TCalkowity" />
                    <ea:DataRepeater ID="CITSTM_REP" runat="server" WithSections="False" OnBeforeRow="CITSTM_BeforeRow">
                        <czst:P_E typ="G">
                            <ea:XmlDataLabel ElementName="czst:P_A" runat="server" DataMember="E.Wojew" XSDType="TJednAdmin"/>
                            <ea:XmlDataLabel ElementName="czst:P_B" runat="server" DataMember="E.Powiat" XSDType="TJednAdmin"/>
                            <ea:XmlDataLabel ElementName="czst:P_C" runat="server" DataMember="E.Gmina" XSDType="TJednAdmin"/>
                            <ea:XmlDataLabel ElementName="czst:P_D" runat="server" DataMember="E.KodGminy" XSDType="TTekstowy"/>
                            <ea:XmlDataLabel ElementName="czst:P_E1" runat="server" DataMember="E.NazwaOddziału" XSDType="TTekstowy"/>
                            <ea:XmlDataLabel ElementName="czst:P_F1" runat="server" DataMember="E.Regon" XSDType="TNrREGON" HideEmptyOrZero="true"/>
                            <ea:XmlDataLabel ElementName="czst:P_F2" runat="server" DataMember="E.NIP" XSDType="TNrNIP" HideEmptyOrZero="true"/>
                            <ea:XmlDataLabel ElementName="czst:P_G" runat="server" DataMember="E.LiczbaZatrudnionych" XSDType="TCalkowity"/>
                        </czst:P_E>
                    </ea:DataRepeater>
                    <ea:XmlDataLabel ElementName="czst:P_169" runat="server" DataMember="F.Data" XSDType="TData" />
                </czst:PozycjeSzczegolowe>

                <ea:Section runat="server" ID="ZalacznikiST">
                <czst:Zalaczniki>
                    <ea:DataRepeater ID="CITSTA_REP" runat="server" WithSections="False" OnBeforeRow="CITSTA_BeforeRow">
                        <csta:Zalacznik_CIT-ST_A>
                            <csta:Naglowek>
                                <csta:KodFormularza kodSystemowy="CTSTAR (5)" wersjaSchemy="4-0E">CIT-ST/A</csta:KodFormularza>
                                <csta:WariantFormularza>5</csta:WariantFormularza>
                            </csta:Naglowek>
                            <csta:PozycjeSzczegolowe>
                                <ea:DataRepeater ID="CITSTAM_REP" runat="server" WithSections="False" OnBeforeRow="CITSTAM_BeforeRow">
                                    <csta:P_B1 typ="G">
                                        <ea:XmlDataLabel ElementName="csta:P_1" runat="server" DataMember="B1.Nazwa" XSDType="TTekstowy"/>
                                        <ea:XmlDataLabel ElementName="csta:P_2" runat="server" DataMember="B1.NazwaSkrócona" XSDType="TTekstowy" HideEmptyOrZero="true"/>
                                        <ea:XmlDataLabel ElementName="csta:P_3" runat="server" DataMember="B1.Regon" XSDType="TNrREGON" HideEmptyOrZero="true"/>
                                        <ea:XmlDataLabel ElementName="csta:P_4" runat="server" DataMember="B1.NIP" XSDType="TNrNIP" HideEmptyOrZero="true"/>
                                        <ea:XmlDataLabel ElementName="csta:P_5" runat="server" DataMember="B1.DataRozpoczęciaDziałalności" XSDType="TData" HideEmptyOrZero="true"/>
                                        <ea:XmlDataLabel ElementName="csta:P_6A" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"><ValuesMap><ea:ValuesPair Key="" Value="PL" /></ValuesMap></ea:XmlDataLabel>
                                        <ea:XmlDataLabel ElementName="csta:P_7" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                                        <ea:XmlDataLabel ElementName="csta:P_8" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                                        <ea:XmlDataLabel ElementName="csta:P_9" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                                        <ea:XmlDataLabel ElementName="csta:P_10" runat="server" DataMember="B2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                                        <ea:XmlDataLabel ElementName="csta:P_11" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                                        <ea:XmlDataLabel ElementName="csta:P_12" runat="server" DataMember="B2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                                        <ea:XmlDataLabel ElementName="csta:P_13" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
                                        <ea:XmlDataLabel ElementName="csta:P_14" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                                        <ea:XmlDataLabel ElementName="csta:P_15" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                                    </csta:P_B1>
                                </ea:DataRepeater>
                            </csta:PozycjeSzczegolowe>
                        </csta:Zalacznik_CIT-ST_A>
                     </ea:DataRepeater>
              </czst:Zalaczniki>
            </ea:Section>
          </czst:Zalacznik_CIT-ST>
	    </ea:DataRepeater>


	    <ea:DataRepeater ID="CIT8O" runat="server" WithSections="False" OnBeforeRow="CIT8O_BeforeRow">
		<cz8o:Zalacznik_CIT-8_O>
			<cz8o:Naglowek>
				<cz8o:KodFormularza kodSystemowy="CIT8/O (14)" wersjaSchemy="1-0E">CIT-8/O</cz8o:KodFormularza>
				<cz8o:WariantFormularza>14</cz8o:WariantFormularza>
				<cz8o:OkresOd poz="P_4"><ea:XmlDataLabel ID="CIT8O_Od" XSDType="TData" runat="server" /></cz8o:OkresOd>
				<cz8o:OkresDo poz="P_5"><ea:XmlDataLabel ID="CIT8O_Do" XSDType="TData" runat="server" /></cz8o:OkresDo>
			</cz8o:Naglowek>
				<cz8o:PozycjeSzczegolowe>
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_7" HideEmptyOrZero="true" DataMember="B1.Wolne1" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_8" HideEmptyOrZero="true" DataMember="B1.Wolne1Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_9" HideEmptyOrZero="true" DataMember="B1.Wolne2" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_10" HideEmptyOrZero="true" DataMember="B1.Wolne2Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_11" HideEmptyOrZero="true" DataMember="B1.Wolne3" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_12" HideEmptyOrZero="true" DataMember="B1.Wolne3Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_13" HideEmptyOrZero="true" DataMember="B1.Wolne4" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_14" HideEmptyOrZero="true" DataMember="B1.Wolne4Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_15" HideEmptyOrZero="true" DataMember="B1.Wolne5" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_16" HideEmptyOrZero="true" DataMember="B1.Wolne5Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_17" HideEmptyOrZero="true" DataMember="B1.Wolne6" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_18" HideEmptyOrZero="true" DataMember="B1.Wolne6Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_19" HideEmptyOrZero="true" DataMember="B1.Wolne7" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_20" HideEmptyOrZero="true" DataMember="B1.Wolne7Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_21" HideEmptyOrZero="true" DataMember="B1.Wolne8" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_22" HideEmptyOrZero="true" DataMember="B1.Wolne8Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_23" HideEmptyOrZero="true" DataMember="B1.Wolne9" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_24" HideEmptyOrZero="true" DataMember="B1.Wolne9Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_25" HideEmptyOrZero="true" DataMember="B1.Wolne10" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_26" HideEmptyOrZero="true" DataMember="B1.Wolne10Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_27" HideEmptyOrZero="true" DataMember="B1.Wolne11" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_28" HideEmptyOrZero="true" DataMember="B1.Wolne11Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_29" HideEmptyOrZero="true" DataMember="B1.Wolne12" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_30" HideEmptyOrZero="true" DataMember="B1.Wolne12Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_31" HideEmptyOrZero="true" DataMember="B1.Wolne13" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_32" HideEmptyOrZero="true" DataMember="B1.Wolne13Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_33" HideEmptyOrZero="true" DataMember="B1.Wolne14" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_34" HideEmptyOrZero="true" DataMember="B1.Wolne14Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_35" HideEmptyOrZero="true" DataMember="B1.Wolne15" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_36" HideEmptyOrZero="true" DataMember="B1.Wolne15Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_37" HideEmptyOrZero="true" DataMember="B1.Wolne16" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_38" HideEmptyOrZero="true" DataMember="B1.Wolne16Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_39" HideEmptyOrZero="true" DataMember="B1.Wolne17" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_40" HideEmptyOrZero="true" DataMember="B1.Wolne17Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_41" HideEmptyOrZero="true" DataMember="B1.Wolne18" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_42" HideEmptyOrZero="true" DataMember="B1.Wolne18Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_43" HideEmptyOrZero="true" DataMember="B1.Wolne19" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_44" HideEmptyOrZero="true" DataMember="B1.Wolne19Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_45" HideEmptyOrZero="true" DataMember="B1.Wolne20" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_46" HideEmptyOrZero="true" DataMember="B1.Wolne20Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_47" HideEmptyOrZero="true" DataMember="B1.Wolne21" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_48" HideEmptyOrZero="true" DataMember="B1.Wolne21Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_49" HideEmptyOrZero="true" DataMember="B1.Wolne22" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_50" HideEmptyOrZero="true" DataMember="B1.Wolne22Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_51" HideEmptyOrZero="true" DataMember="B1.Wolne23" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_52" HideEmptyOrZero="true" DataMember="B1.Wolne23Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_53" HideEmptyOrZero="true" DataMember="B1.Wolne24" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_54" HideEmptyOrZero="true" DataMember="B1.Wolne24Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_55" HideEmptyOrZero="true" DataMember="B1.Wolne25" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_56" HideEmptyOrZero="true" DataMember="B1.Wolne25Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_57" HideEmptyOrZero="true" DataMember="B1.Wolne26" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_58" HideEmptyOrZero="true" DataMember="B1.Wolne26Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_59" HideEmptyOrZero="true" DataMember="B1.Wolne27" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_60" HideEmptyOrZero="true" DataMember="B1.Wolne27Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_61" HideEmptyOrZero="true" DataMember="B1.WolneDochodyZarzadzajacego" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_62" HideEmptyOrZero="true" DataMember="B1.WolneDochodyZarzadzajacegoIz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_63" HideEmptyOrZero="true" DataMember="B1.Wolne28" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_64" HideEmptyOrZero="true" DataMember="B1.Wolne28Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_65" HideEmptyOrZero="true" DataMember="B1.Wolne29" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_66" HideEmptyOrZero="true" DataMember="B1.Wolne29Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_67" HideEmptyOrZero="true" DataMember="B1.Wolne30" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_68" HideEmptyOrZero="true" DataMember="B1.Wolne30Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_69" HideEmptyOrZero="true" DataMember="B1.Wolne31" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_70" HideEmptyOrZero="true" DataMember="B1.Wolne31Iz" XSDType="TKwota2" />

                    <ea:Section runat="server" ID="SecInneDochody">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_71" DataMember="B1.InneTytul" XSDType="TZnakowy" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_72" HideEmptyOrZero="true" DataMember="B1.Inne" XSDType="TKwota2" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_73" HideEmptyOrZero="true" DataMember="B1.InneIz" XSDType="TKwota2" />
                    </ea:Section>
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_74" HideEmptyOrZero="true" DataMember="B1.Razem" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_75" HideEmptyOrZero="true" DataMember="B1.RazemIz" XSDType="TKwota2" />

                    <ea:Section runat="server" ID="B21Rok1">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_76" DataMember="B21.Rok1" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_77" DataMember="B21.Kwota1" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_78" HideEmptyOrZero="true" DataMember="B21.Odliczona1" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_79" DataMember="B21.DoOdliczenia1" XSDType="TKwota2" />
                    </ea:Section>
					<ea:Section runat="server" ID="B21Rok2">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_80" DataMember="B21.Rok2" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_81" DataMember="B21.Kwota2" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_82" HideEmptyOrZero="true" DataMember="B21.Odliczona2" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_83" DataMember="B21.DoOdliczenia2" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B21Rok3">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_84" DataMember="B21.Rok3" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_85" DataMember="B21.Kwota3" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_86" HideEmptyOrZero="true" DataMember="B21.Odliczona3" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_87" DataMember="B21.DoOdliczenia3" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B21Rok4">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_88" DataMember="B21.Rok4" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_89" DataMember="B21.Kwota4" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_90" HideEmptyOrZero="true" DataMember="B21.Odliczona4" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_91" DataMember="B21.DoOdliczenia4" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B21Rok5">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_92" DataMember="B21.Rok5" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_93" DataMember="B21.Kwota5" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_94" HideEmptyOrZero="true" DataMember="B21.Odliczona5" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_95" DataMember="B21.DoOdliczenia5" XSDType="TKwota2" />
					</ea:Section>

					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_96" HideEmptyOrZero="true" DataMember="B21.Razem" XSDType="TCalkowity" />

                    <ea:Section runat="server" ID="B22Rok1">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_97" DataMember="B22.Rok1" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_98" DataMember="B22.Kwota1" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_99" HideEmptyOrZero="true" DataMember="B22.Odliczona1" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_100" DataMember="B22.DoOdliczenia1" XSDType="TKwota2" />
                    </ea:Section>
					<ea:Section runat="server" ID="B22Rok2">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_101" DataMember="B22.Rok2" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_102" DataMember="B22.Kwota2" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_103" HideEmptyOrZero="true" DataMember="B22.Odliczona2" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_104" DataMember="B22.DoOdliczenia2" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B22Rok3">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_105" DataMember="B22.Rok3" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_106" DataMember="B22.Kwota3" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_107" HideEmptyOrZero="true" DataMember="B22.Odliczona3" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_108" DataMember="B22.DoOdliczenia3" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B22Rok4">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_109" DataMember="B22.Rok4" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_110" DataMember="B22.Kwota4" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_111" HideEmptyOrZero="true" DataMember="B22.Odliczona4" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_112" DataMember="B22.DoOdliczenia4" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B22Rok5">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_113" DataMember="B22.Rok5" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_114" DataMember="B22.Kwota5" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_115" HideEmptyOrZero="true" DataMember="B22.Odliczona5" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_116" DataMember="B22.DoOdliczenia5" XSDType="TKwota2" />
					</ea:Section>

                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_117" HideEmptyOrZero="true" DataMember="B22.Razem" XSDType="TCalkowity" />

                    <ea:Section runat="server" ID="B23Rok1">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_118" DataMember="B23.Rok1" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_119" DataMember="B23.Kwota1" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_120" HideEmptyOrZero="true" DataMember="B23.Odliczona1" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_121" DataMember="B23.DoOdliczenia1" XSDType="TKwota2" />
                    </ea:Section>
					<ea:Section runat="server" ID="B23Rok2">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_122" DataMember="B23.Rok2" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_123" DataMember="B23.Kwota2" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_124" HideEmptyOrZero="true" DataMember="B23.Odliczona2" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_125" DataMember="B23.DoOdliczenia2" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B23Rok3">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_126" DataMember="B23.Rok3" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_127" DataMember="B23.Kwota3" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_128" HideEmptyOrZero="true" DataMember="B23.Odliczona3" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_129" DataMember="B23.DoOdliczenia3" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B23Rok4">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_130" DataMember="B23.Rok4" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_131" DataMember="B23.Kwota4" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_132" HideEmptyOrZero="true" DataMember="B23.Odliczona4" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_133" DataMember="B23.DoOdliczenia4" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B23Rok5">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_134" DataMember="B23.Rok5" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_135" DataMember="B23.Kwota5" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_136" HideEmptyOrZero="true" DataMember="B23.Odliczona5" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_137" DataMember="B23.DoOdliczenia5" XSDType="TKwota2" />
					</ea:Section>

					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_138" HideEmptyOrZero="true" DataMember="B23.Razem" XSDType="TCalkowity" />

                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_139" HideEmptyOrZero="true" DataMember="B3.Darowizny" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_140" HideEmptyOrZero="true" DataMember="B3.DarowiznyIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_141" HideEmptyOrZero="true" DataMember="B3.DarowiznyReligijne" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_142" HideEmptyOrZero="true" DataMember="B3.DarowiznyReligijneIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_143" HideEmptyOrZero="true" DataMember="B3.DarowiznyOdrebne" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_144" HideEmptyOrZero="true" DataMember="B3.DarowiznyOdrebneIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_145" HideEmptyOrZero="true" DataMember="B3.RazemDarowizny" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_146" HideEmptyOrZero="true" DataMember="B3.RazemDarowiznyIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_147" HideEmptyOrZero="true" DataMember="B3.Odliczenia" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_148" HideEmptyOrZero="true" DataMember="B3.OdliczeniaIz" XSDType="TKwota2" />

                    <ea:Section runat="server" ID="SecInneOdliczenia">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_149" DataMember="B3.InneTytul" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_150" HideEmptyOrZero="true" DataMember="B3.Inne" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_151" HideEmptyOrZero="true" DataMember="B3.InneIz" XSDType="TKwota2" />
                    </ea:Section>

					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_152" DataMember="B3.Razem" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_153" DataMember="B3.RazemIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_154" DataMember="B4.Razem" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_155" DataMember="B4.RazemIz" XSDType="TKwota2" />

					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_156" HideEmptyOrZero="true" DataMember="C.Wydatki1" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_157" HideEmptyOrZero="true" DataMember="C.Wydatki1Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_158" HideEmptyOrZero="true" DataMember="C.Obnizka" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_159" HideEmptyOrZero="true" DataMember="C.ObnizkaIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_160" DataMember="C.Razem" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_161" DataMember="C.RazemIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_162" HideEmptyOrZero="true" DataMember="D.NowaTechnologia" XSDType="TKwota2" />

					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_163" HideEmptyOrZero="true" DataMember="E.Odliczenia1" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_164" HideEmptyOrZero="true" DataMember="E.Odliczenia2" XSDType="TKwota2" />

					<ea:Section runat="server" ID="SecZwolnienie">
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_165" DataMember="E.ZwolnienieDecyzja" XSDType="TZnakowy" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_166" DataMember="E.Zwolnienie" XSDType="TKwota2" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_167" DataMember="E.ZwolnienieDataDecyzji" XSDType="TData" />
					</ea:Section>
					<ea:Section runat="server" ID="SecZaniechanie">
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_168" DataMember="E.ZaniechanieDataRozporzadzenia" XSDType="TData" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_169" DataMember="E.Zaniechanie" XSDType="TKwota2" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_170" DataMember="E.ZaniechanieRozporzadzenie" XSDType="TZnakowy" />
					</ea:Section>
					<ea:Section runat="server" ID="SecObnizki">
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_171" DataMember="E.InneTytul" XSDType="TZnakowy" />
				    	<ea:XmlDataLabel runat="server" ElementName="cz8o:P_172" DataMember="E.Inne" XSDType="TKwota2" />
                    </ea:Section>

                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_173" HideEmptyOrZero="true" DataMember="E.InneUst10C" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_174" DataMember="E.Razem" XSDType="TKwota2" />

					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_175" HideEmptyOrZero="true" DataMember="F1.Dochody1" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_176" HideEmptyOrZero="true" DataMember="F1.Dochody2" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_177" HideEmptyOrZero="true" DataMember="F1.Dochody3" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_178" HideEmptyOrZero="true" DataMember="F1.PobranyPodatek" XSDType="TCalkowity" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_179" HideEmptyOrZero="true" DataMember="F1.WplaconyPodatek" XSDType="TCalkowity" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_180" HideEmptyOrZero="true" DataMember="F2.SumaDochodow" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_181" HideEmptyOrZero="true" DataMember="F3.Kwoty" XSDType="TCalkowity" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_182" HideEmptyOrZero="true" DataMember="F3.Podatek" XSDType="TCalkowity" />
				</cz8o:PozycjeSzczegolowe>
		</cz8o:Zalacznik_CIT-8_O>
	</ea:DataRepeater>

    <ea:DataRepeater ID="CITBR" runat="server" WithSections="False" OnBeforeRow="CITBR_BeforeRow">
		<czbr:Zalacznik_CIT_BR>
		    <czbr:Naglowek>
		        <czbr:KodFormularza kodSystemowy="CIT/BR (5)" wersjaSchemy="1-0E">CIT/BR</czbr:KodFormularza>
                <czbr:WariantFormularza>5</czbr:WariantFormularza>
                <czbr:OkresOd poz="P_4"><ea:XmlDataLabel ID="CITBR_Od" XSDType="TData" runat="server" /></czbr:OkresOd>
                <czbr:OkresDo poz="P_5"><ea:XmlDataLabel ID="CITBR_Do" XSDType="TData" runat="server" /></czbr:OkresDo>
		    </czbr:Naglowek>
            <czbr:PozycjeSzczegolowe>
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_8" ID="StatusCentrum" />
                <ea:Section runat="server" ID="SecStatusCentrum">
					<ea:XmlDataLabel runat="server" ElementName="czbr:P_9" DataMember="A.StatusCentrumOd" XSDType="TData" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_10" DataMember="A.StatusCentrumDo" XSDType="TData" />
                </ea:Section>
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_11" ID="Mikrofirma" />

				<ea:XmlDataLabel runat="server" ElementName="czbr:P_12" HideEmptyOrZero="true" DataMember="B1.Poz12" XSDType="TKwota2" />
				<ea:XmlDataLabel runat="server" ElementName="czbr:P_13" HideEmptyOrZero="true" DataMember="B1.Poz13" XSDType="TKwota2" />
				<ea:XmlDataLabel runat="server" ElementName="czbr:P_14" HideEmptyOrZero="true" DataMember="B1.Poz14" XSDType="TKwota2" />
				<ea:XmlDataLabel runat="server" ElementName="czbr:P_15" HideEmptyOrZero="true" DataMember="B1.Poz15" XSDType="TKwota2" />
				<ea:XmlDataLabel runat="server" ElementName="czbr:P_16" HideEmptyOrZero="true" DataMember="B1.Poz16" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_17" HideEmptyOrZero="true" DataMember="B1.Poz17" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_18" HideEmptyOrZero="true" DataMember="B1.Poz18" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_19" HideEmptyOrZero="true" DataMember="B1.Poz19" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_20" HideEmptyOrZero="true" DataMember="B1.Poz20" XSDType="TKwota2" />
	            <ea:XmlDataLabel runat="server" ElementName="czbr:P_21" HideEmptyOrZero="true" DataMember="B1.Poz21" XSDType="TKwota2" />
	            <ea:XmlDataLabel runat="server" ElementName="czbr:P_22" HideEmptyOrZero="true" DataMember="B1.Poz22" XSDType="TKwota2" />
	            <ea:XmlDataLabel runat="server" ElementName="czbr:P_23" HideEmptyOrZero="true" DataMember="B1.Poz23" XSDType="TKwota2" />
	            <ea:XmlDataLabel runat="server" ElementName="czbr:P_24" HideEmptyOrZero="true" DataMember="B1.Poz24" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_25" HideEmptyOrZero="true" DataMember="B1.Poz25" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_26" HideEmptyOrZero="true" DataMember="B1.Poz26" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_27" HideEmptyOrZero="true" DataMember="B1.Poz27" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_28" HideEmptyOrZero="true" DataMember="B1.Poz28" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_29" HideEmptyOrZero="true" DataMember="B1.Poz29" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_30" HideEmptyOrZero="true" DataMember="B1.Suma30" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_31" HideEmptyOrZero="true" DataMember="B1.Suma31" XSDType="TKwota2" />

                <ea:XmlDataLabel runat="server" ElementName="czbr:P_32" HideEmptyOrZero="true" DataMember="B2.Poz32" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_33" HideEmptyOrZero="true" DataMember="B2.Poz33" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_34" HideEmptyOrZero="true" DataMember="B2.Poz34" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_35" HideEmptyOrZero="true" DataMember="B2.Poz35" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_36" DataMember="B2.Suma36" XSDType="TKwota2" />

                <ea:XmlDataLabel runat="server" ElementName="czbr:P_37" HideEmptyOrZero="true" DataMember="B3.Suma37" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_38" HideEmptyOrZero="true" DataMember="B3.Suma38" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_39" HideEmptyOrZero="true" DataMember="B3.Poz39" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_40" HideEmptyOrZero="true" DataMember="B3.Poz40" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_41" DataMember="B3.Suma41" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_42" HideEmptyOrZero="true" DataMember="B3.Poz42" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_43" HideEmptyOrZero="true" DataMember="B3.Poz43" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_44" DataMember="B3.Poz44" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_45" HideEmptyOrZero="true" DataMember="B3.Poz45" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_46" HideEmptyOrZero="true" DataMember="B3.Poz46" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_47" HideEmptyOrZero="true" DataMember="B3.Poz47" XSDType="TKwota2" />

                <ea:XmlDataLabel runat="server" ElementName="czbr:P_48" HideEmptyOrZero="true" DataMember="C1.PraceRozwojowe" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_49" HideEmptyOrZero="true" DataMember="C1.BadaniaPodstawowe" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_50" HideEmptyOrZero="true" DataMember="C1.BadaniaAplikacyjne" XSDType="TKwota2" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_51" HideEmptyOrZero="true" DataMember="C1.PatentyOrazWzory" XSDType="TKwota2" />

              
                <ea:Section runat="server" ID="D_DaneSpolki">
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_52" DataMember="D1.Nazwa" XSDType="TZnakowy" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_53" DataMember="D1.NIP" XSDType="TNrNIP" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_54" ID="SpolkaMikrofirma" />
                
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_55" HideEmptyOrZero="true" DataMember="D11.PraceRozwojowe" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_56" HideEmptyOrZero="true" DataMember="D11.BadaniaPodstawowe" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_57" HideEmptyOrZero="true" DataMember="D11.BadaniaAplikacyjne" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_58" HideEmptyOrZero="true" DataMember="D11.PatentyOrazWzory" XSDType="TKwota2" />
                </ea:Section>
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_59" ID="BadaniaNaukowe" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_60" ID="PraceRozwojowe" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_61" HideEmptyOrZero="true" ID="BadaniaPodstawowe" />
                <ea:XmlDataLabel runat="server" ElementName="czbr:P_62" HideEmptyOrZero="true" ID="BadaniaAplikacyjne" />

                <ea:DataRepeater ID="CITBR_P_F" runat="server" WithSections="False">
                <czbr:P_F typ="G">
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_F63" DataMember="Nazwa" XSDType="TZnakowy" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_F64A" DataMember="KodKraju" XSDType="TJednAdmin" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_F65" HideEmptyOrZero="true" DataMember="Wojewodztwo" XSDType="TJednAdmin" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_F66" HideEmptyOrZero="true" DataMember="Powiat" XSDType="TJednAdmin" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_F67" HideEmptyOrZero="true" DataMember="Gmina" XSDType="TJednAdmin" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_F68" HideEmptyOrZero="true" DataMember="Ulica" XSDType="TUlica" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_F69" HideEmptyOrZero="true" DataMember="NrDomu" XSDType="TNrBudynku" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_F70" HideEmptyOrZero="true" DataMember="NrLokalu" XSDType="TNrLokalu" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_F71" HideEmptyOrZero="true" DataMember="Miejscowosc" XSDType="TMiejscowosc"/>
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_F72" HideEmptyOrZero="true" DataMember="KodPocztowy" XSDType="TKodPocztowy" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_F73" HideEmptyOrZero="true" DataMember="Poczta" XSDType="TMiejscowosc" />
                </czbr:P_F>
                </ea:DataRepeater>
            </czbr:PozycjeSzczegolowe>
        </czbr:Zalacznik_CIT_BR>
    </ea:DataRepeater>


    <ea:DataRepeater ID="CITD_Repeater" runat="server" WithSections="False" OnBeforeRow="CITD_BeforeRow">
        <czd:Zalacznik_CIT-D>
            <czd:Naglowek>
                <czd:KodFormularza kodSystemowy="CIT-D (6)" wersjaSchemy="2-0E">CIT-D</czd:KodFormularza>
                <czd:WariantFormularza>6</czd:WariantFormularza>
                <czd:OkresOd poz="P_4"><ea:XmlDataLabel ID="CITD_Od" XSDType="TData" runat="server" /></czd:OkresOd>
                <czd:OkresDo poz="P_5"><ea:XmlDataLabel ID="CITD_Do" XSDType="TData" runat="server" /></czd:OkresDo>
            </czd:Naglowek>
            <czd:PozycjeSzczegolowe>
                <ea:XmlDataLabel ElementName="czd:P_6" runat="server" DataMember="NrFormularza" XSDType="TCalkowity"/>
                <czd:P_8>2</czd:P_8>
                <ea:XmlDataLabel ID="CITD_RodzajPodatnika" ElementName="czd:P_10" runat="server" XSDType="TCalkowity"/>

                <ea:XmlDataLabel ElementName="czd:P_22" runat="server" DataMember="C.Ogolem" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_23" runat="server" DataMember="C.Osoba1" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_24" runat="server" DataMember="C.Osoba2" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_25" runat="server" DataMember="C.Osoba3" XSDType="TKwota2" HideEmptyOrZero="True"/>

                <ea:Section ID="CITD_DaneDarczyncy1" runat="server">
                    <ea:XmlDataLabel ElementName="czd:P_26" runat="server" DataMember="C11.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_27A" runat="server" ID="CITDC12KodKraju" XSDType="TJednAdmin"/>
                    <ea:XmlDataLabel ElementName="czd:P_28" runat="server" DataMember="C12.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_29" runat="server" DataMember="C12.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_30" runat="server" DataMember="C12.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_31" runat="server" DataMember="C12.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_32" runat="server" DataMember="C12.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_33" runat="server" DataMember="C12.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_34" runat="server" DataMember="C12.Miejsc" XSDType="TMiejscowosc"/>
                    <ea:XmlDataLabel ElementName="czd:P_35" runat="server" DataMember="C12.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_36" runat="server" DataMember="C12.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                </ea:Section>

                <ea:Section ID="CITD_DaneDarczyncy2" runat="server">
                    <ea:XmlDataLabel ElementName="czd:P_37" runat="server" DataMember="C21.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_38A" runat="server" ID="CITDC22KodKraju" XSDType="TJednAdmin"/>
                    <ea:XmlDataLabel ElementName="czd:P_39" runat="server" DataMember="C22.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_40" runat="server" DataMember="C22.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_41" runat="server" DataMember="C22.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_42" runat="server" DataMember="C22.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_43" runat="server" DataMember="C22.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_44" runat="server" DataMember="C22.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_45" runat="server" DataMember="C22.Miejsc" XSDType="TMiejscowosc"/>
                    <ea:XmlDataLabel ElementName="czd:P_46" runat="server" DataMember="C22.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_47" runat="server" DataMember="C22.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                </ea:Section>

                <ea:Section ID="CITD_DaneDarczyncy3" runat="server">
                    <ea:XmlDataLabel ElementName="czd:P_48" runat="server" DataMember="C31.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_49A" runat="server" ID="CITDC32KodKraju" XSDType="TJednAdmin"/>
                    <ea:XmlDataLabel ElementName="czd:P_50" runat="server" DataMember="C32.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_51" runat="server" DataMember="C32.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_52" runat="server" DataMember="C32.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_53" runat="server" DataMember="C32.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_54" runat="server" DataMember="C32.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_55" runat="server" DataMember="C32.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_56" runat="server" DataMember="C32.Miejsc" XSDType="TMiejscowosc"/>
                    <ea:XmlDataLabel ElementName="czd:P_57" runat="server" DataMember="C32.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_58" runat="server" DataMember="C32.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                </ea:Section>

                <ea:XmlDataLabel ElementName="czd:P_59" runat="server" DataMember="C4.DzialalnoscCharytatywna" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_60" runat="server" DataMember="C4.PomocOfiarom" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_61" runat="server" DataMember="C4.PomocSpoleczna" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_62" runat="server" DataMember="C4.KrajoznawstwoWypoczynek" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_63" runat="server" DataMember="C4.Nauka" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_64" runat="server" DataMember="C4.Niepelnosprawni" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_65" runat="server" DataMember="C4.Kultura" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_66" runat="server" DataMember="C4.Ekologia" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_67" runat="server" DataMember="C4.Zdrowie" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_68" runat="server" DataMember="C4.RozwojGospodarczy" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_69" runat="server" DataMember="C4.KulturaFizyczna" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_70" runat="server" DataMember="C4.Ratownictwo" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_71" runat="server" DataMember="C4.KultReligijny" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_72" runat="server" DataMember="C4.DzialalnoscCharytatywnoOpiekuncza" XSDType="TWybor1" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ElementName="czd:P_73" runat="server" DataMember="C4.Pozostale" XSDType="TWybor1" HideEmptyOrZero="True"/>

                <ea:Section ID="CITD_Obdarowany1" runat="server">
                    <ea:XmlDataLabel ElementName="czd:P_74" runat="server" DataMember="D1.KwotaPrzekazana" XSDType="TKwota2" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_75" runat="server" DataMember="D1.KwotaOdliczona" XSDType="TKwota2" HideEmptyOrZero="True"/>

                    <ea:XmlDataLabel ElementName="czd:P_76" runat="server" DataMember="D11.Identyfikator" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_77" runat="server" DataMember="D11.KodKraju" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_78" runat="server" DataMember="D11.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>

                    <ea:XmlDataLabel ElementName="czd:P_79A" runat="server" ID="CITDD12KodKraju" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_80" runat="server" DataMember="D12.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_81" runat="server" DataMember="D12.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_82" runat="server" DataMember="D12.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_83" runat="server" DataMember="D12.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_84" runat="server" DataMember="D12.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_85" runat="server" DataMember="D12.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_86" runat="server" DataMember="D12.Miejsc" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_87" runat="server" DataMember="D12.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_88" runat="server" DataMember="D12.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                </ea:Section>

                <ea:Section ID="CITD_Obdarowany2" runat="server">
                    <ea:XmlDataLabel ElementName="czd:P_89" runat="server" DataMember="D2.KwotaPrzekazana" XSDType="TKwota2" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_90" runat="server" DataMember="D2.KwotaOdliczona" XSDType="TKwota2" HideEmptyOrZero="True"/>

                    <ea:XmlDataLabel ElementName="czd:P_91" runat="server" DataMember="D21.Identyfikator" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_92" runat="server" DataMember="D21.KodKraju" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_93" runat="server" DataMember="D21.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>

                    <ea:XmlDataLabel ElementName="czd:P_94A" runat="server" ID="CITDD22KodKraju" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_95" runat="server" DataMember="D22.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_96" runat="server" DataMember="D22.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_97" runat="server" DataMember="D22.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_98" runat="server" DataMember="D22.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_99" runat="server" DataMember="D22.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_100" runat="server" DataMember="D22.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_101" runat="server" DataMember="D22.Miejsc" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_102" runat="server" DataMember="D22.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_103" runat="server" DataMember="D22.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                </ea:Section>

                <ea:Section ID="CITD_Obdarowany3" runat="server">
                    <ea:XmlDataLabel ElementName="czd:P_104" runat="server" DataMember="D3.KwotaPrzekazana" XSDType="TKwota2" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_105" runat="server" DataMember="D3.KwotaOdliczona" XSDType="TKwota2" HideEmptyOrZero="True"/>

                    <ea:XmlDataLabel ElementName="czd:P_106" runat="server" DataMember="D31.Identyfikator" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_107" runat="server" DataMember="D31.KodKraju" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_108" runat="server" DataMember="D31.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>

                    <ea:XmlDataLabel ElementName="czd:P_109A" runat="server" ID="CITDD32KodKraju" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_110" runat="server" DataMember="D32.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_111" runat="server" DataMember="D32.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_112" runat="server" DataMember="D32.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_113" runat="server" DataMember="D32.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_114" runat="server" DataMember="D32.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_115" runat="server" DataMember="D32.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_116" runat="server" DataMember="D32.Miejsc" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_117" runat="server" DataMember="D32.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    <ea:XmlDataLabel ElementName="czd:P_118" runat="server" DataMember="D32.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                </ea:Section>
            </czd:PozycjeSzczegolowe>
        </czd:Zalacznik_CIT-D>
    </ea:DataRepeater>

    <ea:DataRepeater ID="CITMIT" runat="server" WithSections="False" OnBeforeRow="CITMIT_BeforeRow">
        <czmit:Zalacznik_CIT_MIT>
            <czmit:Naglowek>
                <czmit:KodFormularza kodSystemowy="CITMIT (2)" wersjaSchemy="1-0E">CIT/MIT</czmit:KodFormularza>
                <czmit:WariantFormularza>2</czmit:WariantFormularza>
                <czmit:OkresOd poz="P_4"><ea:XmlDataLabel ID="CITMIT_Od" XSDType="TData" runat="server" /></czmit:OkresOd>
                <czmit:OkresDo poz="P_5"><ea:XmlDataLabel ID="CITMIT_Do" XSDType="TData" runat="server" /></czmit:OkresDo>
            </czmit:Naglowek>
            <czmit:PozycjeSzczegolowe>
                <ea:DataRepeater ID="CITMIT_P_B" runat="server" WithSections="False">
                <czmit:P_B typ="G">
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B8" DataMember="NazwaST" XSDType="TTekstowy" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B9" DataMember="WartoscPoczatkowa" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B10" HideEmptyOrZero="true" DataMember="ZmianaWartosciPoczatkowej" XSDType="TWybor1" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B11" HideEmptyOrZero="true" DataMember="ZmienionaWartoscPoczatkowa" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B12" HideEmptyOrZero="true" DataMember="Przychod1" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B13" HideEmptyOrZero="true" DataMember="Przychod2" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B14" HideEmptyOrZero="true" DataMember="Przychod3" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B15" HideEmptyOrZero="true" DataMember="Przychod4" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B16" HideEmptyOrZero="true" DataMember="Przychod5" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B17" HideEmptyOrZero="true" DataMember="Przychod6" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B18" HideEmptyOrZero="true" DataMember="Przychod7" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B19" HideEmptyOrZero="true" DataMember="Przychod8" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B20" HideEmptyOrZero="true" DataMember="Przychod9" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B21" HideEmptyOrZero="true" DataMember="Przychod10" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B22" HideEmptyOrZero="true" DataMember="Przychod11" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B23" HideEmptyOrZero="true" DataMember="Przychod12" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B24" HideEmptyOrZero="true" DataMember="Przychod13" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B25" HideEmptyOrZero="true" DataMember="Przychod14" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B26" HideEmptyOrZero="true" DataMember="Przychod15" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B27" HideEmptyOrZero="true" DataMember="Przychod16" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B28" HideEmptyOrZero="true" DataMember="Przychod17" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B29" HideEmptyOrZero="true" DataMember="Przychod18" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B30" HideEmptyOrZero="true" DataMember="Przychod19" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B31" HideEmptyOrZero="true" DataMember="Przychod20" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B32" HideEmptyOrZero="true" DataMember="Przychod21" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B33" HideEmptyOrZero="true" DataMember="Przychod22" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czmit:P_B34" HideEmptyOrZero="true" DataMember="Przychod23" XSDType="TCalkowity" />
                </czmit:P_B>
                </ea:DataRepeater>
            </czmit:PozycjeSzczegolowe>
        </czmit:Zalacznik_CIT_MIT>
    </ea:DataRepeater>

    <ea:DataRepeater ID="CIT8SP" runat="server" WithSections="False" OnBeforeRow="CIT8SP_BeforeRow">
        <cz8sp:Zalacznik_CIT_8SP>
            <cz8sp:Naglowek>
                <cz8sp:KodFormularza kodSystemowy="CIT8SP (2)"  wersjaSchemy="1-0E">CIT/8SP</cz8sp:KodFormularza>
                <cz8sp:WariantFormularza>2</cz8sp:WariantFormularza>
                <cz8sp:OkresOd poz="P_4"><ea:XmlDataLabel ID="CIT8SP_Od" XSDType="TData" runat="server" /></cz8sp:OkresOd>
                <cz8sp:OkresDo poz="P_5"><ea:XmlDataLabel ID="CIT8SP_Do" XSDType="TData" runat="server" /></cz8sp:OkresDo>
            </cz8sp:Naglowek>
            <cz8sp:PozycjeSzczegolowe>
                <ea:DataRepeater ID="CIT8SP_P_B" runat="server" WithSections="False">
                <cz8sp:P_B typ="G">
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B8" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B9" DataMember="DataWydania" XSDType="TData" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B10" DataMember="DataRozpoczecia" XSDType="TData" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B11" DataMember="NazwaPodmiotu" XSDType="TZnakowy" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B12" DataMember="NIP" XSDType="TNrNIP" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B13" DataMember="Udzial" XSDType="TProcentowy" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B14" DataMember="MaxPomoc" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B15" DataMember="MaxPomocDyskonto" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B16" DataMember="Koszty" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B17" DataMember="KosztyDyskonto" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B18" DataMember="Pomoc" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B19" DataMember="PomocDyskonto" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B20" DataMember="InneWsparcie" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B21" DataMember="InneWsparcieDyskonto" XSDType="TKwota2" />
                </cz8sp:P_B>
                </ea:DataRepeater>
                <ea:DataRepeater ID="CIT8SP_P_C" runat="server" WithSections="False">
                <cz8sp:P_C typ="G">
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_C22" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_C23" DataMember="DataWydania" XSDType="TData" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_C24" DataMember="Przychody" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_C25" DataMember="Koszty" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_C26" DataMember="Dochod" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_C27" DataMember="Strata" XSDType="TKwota2" />
                </cz8sp:P_C>
                </ea:DataRepeater>
                <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_28" DataMember="C.RazemDochod" XSDType="TKwota2" />
                <ea:DataRepeater ID="CIT8SP_P_D" runat="server" WithSections="False">
                <cz8sp:P_D typ="G">
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_D29" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_D30" DataMember="DataCofniecia" XSDType="TData" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_D31" DataMember="KwotaPodatku" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_D32" DataMember="DochodZwolniony" XSDType="TKwota2" />
                </cz8sp:P_D>
                </ea:DataRepeater>
                <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_33" DataMember="D.RazemDochodDoliczony" XSDType="TKwota2" />
                <ea:Section ID="CIT8SP_KosztyKwalifikowane" runat="server">
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_34" DataMember="E.KwotaKosztowB+R" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_35" DataMember="E.NumerZezwolenia" XSDType="TZnakowy" />
                </ea:Section>
            </cz8sp:PozycjeSzczegolowe>
        </cz8sp:Zalacznik_CIT_8SP>
    </ea:DataRepeater>

    <ea:DataRepeater ID="CIT8S" runat="server" WithSections="False" OnBeforeRow="CIT8S_BeforeRow">
        <cz8s:Zalacznik_CIT_8S>
            <cz8s:Naglowek>
                <cz8s:KodFormularza kodSystemowy="CIT/8S (2)"  wersjaSchemy="1-0E">CIT/8S</cz8s:KodFormularza>
                <cz8s:WariantFormularza>2</cz8s:WariantFormularza>
                <cz8s:OkresOd poz="P_4"><ea:XmlDataLabel ID="CIT8S_Od" XSDType="TData" runat="server" /></cz8s:OkresOd>
                <cz8s:OkresDo poz="P_5"><ea:XmlDataLabel ID="CIT8S_Do" XSDType="TData" runat="server" /></cz8s:OkresDo>
            </cz8s:Naglowek>
            <cz8s:PozycjeSzczegolowe>
                <ea:DataRepeater ID="CIT8S_P_B" runat="server" WithSections="False">
                <cz8s:P_B typ="G">
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B8" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B9" DataMember="DataWydania" XSDType="TData" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B10" DataMember="DataRozpoczecia" XSDType="TData" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B11" DataMember="MaxPomoc" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B12" DataMember="MaxPomocDyskonto" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B13" DataMember="Koszty" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B14" DataMember="KosztyDyskonto" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B15" DataMember="Pomoc" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B16" DataMember="PomocDyskonto" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B17" DataMember="InneWsparcie" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B18" DataMember="InneWsparcieDyskonto" XSDType="TKwota2" />
                </cz8s:P_B>
                </ea:DataRepeater>
                <ea:DataRepeater ID="CIT8S_P_C" runat="server" WithSections="False">
                <cz8s:P_C typ="G">
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_C19" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_C20" DataMember="DataWydania" XSDType="TData" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_C21" DataMember="Przychody" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_C22" DataMember="Koszty" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_C23" DataMember="Dochod" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_C24" DataMember="Strata" XSDType="TKwota2" />
                </cz8s:P_C>
                </ea:DataRepeater>
                <ea:XmlDataLabel runat="server" ElementName="cz8s:P_25" DataMember="C.RazemDochod" XSDType="TKwota2" />
                <ea:DataRepeater ID="CIT8S_P_D" runat="server" WithSections="False">
                <cz8s:P_D typ="G">
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_D26" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_D27" DataMember="DataCofniecia" XSDType="TData" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_D28" DataMember="KwotaPodatku" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_D29" DataMember="DochodZwolniony" XSDType="TKwota2" />
                </cz8s:P_D>
                </ea:DataRepeater>
                <ea:XmlDataLabel runat="server" ElementName="cz8s:P_30" DataMember="D.RazemDochodDoliczony" XSDType="TKwota2" />
                <ea:Section ID="CIT8S_KosztyKwalifikowane" runat="server">
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_31" DataMember="E.KwotaKosztowB+R" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_32" DataMember="E.NumerZezwolenia" XSDType="TZnakowy" />
                </ea:Section>
            </cz8s:PozycjeSzczegolowe>
        </cz8s:Zalacznik_CIT_8S>
    </ea:DataRepeater>

    <ea:Section ID="ORD_ZU" runat="server">
        <zzu:Zalacznik_ORD-ZU>
	        <zzu:Naglowek>
                <zzu:KodFormularza kodSystemowy="ORD-ZU (3)" wersjaSchemy="2-0E">ORD-ZU</zzu:KodFormularza>
                <zzu:WariantFormularza>3</zzu:WariantFormularza>
	        </zzu:Naglowek>
	        <zzu:PozycjeSzczegolowe>
	            <zzu:P_13><ea:XmlDataLabel runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/></zzu:P_13>
	        </zzu:PozycjeSzczegolowe>
	    </zzu:Zalacznik_ORD-ZU>
    </ea:Section>

	</Zalaczniki>
    </ea:Section>
</Deklaracja>
