﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.CIT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>


<script runat="server">
    CIT8_32 dek;

    private struct GrupaCitBR
    {
        public string Nazwa { get; set; }
        public string KodKraju { get; set; }
        public string Wojewodztwo { get; set; }
        public string Powiat { get; set; }
        public string Gmina { get; set; }
        public string Ulica { get; set; }
        public string NrDomu { get; set; }
        public string NrLokalu { get; set; }
        public string Miejscowosc { get; set; }
        public string KodPocztowy { get; set; }
    }

    private struct GrupaCitMIT
    {
        public string NazwaST { get; set; }
        public decimal LiczbaST { get; set; }
    }


    private struct GrupaBCit8S
    {
        public string NumerZezwolenia { get; set; }
        public Date DataWydania { get; set; }
        public Date DataRozpoczecia { get; set; }
        public string NazwaPodmiotu { get; set; }
        public string NIP { get; set; }
        public Percent Udzial { get; set; }
        public decimal MaxPomoc { get; set; }
        public decimal MaxPomocDyskonto { get; set; }
        public decimal Koszty { get; set; }
        public decimal KosztyDyskonto { get; set; }
        public decimal Pomoc { get; set; }
        public decimal PomocDyskonto { get; set; }
        public decimal InneWsparcie { get; set; }
        public decimal InneWsparcieDyskonto { get; set; }
    }

    private struct GrupaDCit8S
    {
        public string NumerZezwolenia { get; set; }
        public Date DataWydania { get; set; }
        public decimal Dochod { get; set; }
    }

    private struct GrupaECit8S
    {
        public string NumerZezwolenia { get; set; }
        public Date DataCofniecia { get; set; }
        public decimal PodatekNiezaplacony { get; set; }
        public decimal MaksymalnaPomoc { get; set; }
        public decimal PodatekZaplacony { get; set; }
    }

    private struct GrupaCitIP
    {
        public string NumerZezwolenia { get; set; }
        public Date DataWydaniaZezwolenia { get; set; }
        public string JednostkaTerytorialnaRealizacjiInwestycji { get; set; }
        public string JednostkaTerytorialnaRealizacjiInwestycjiPL
        {
            get
            {
                return "PL" + JednostkaTerytorialnaRealizacjiInwestycji;
            }
        }
        public decimal DochodPodlegajacyZwolnieniuZPodatku { get; set; }
    }

    private struct GrupaBCitWZ
    {
        public string NazwaDluznika { get; set; }
        public string NIP { get; set; }
        public string NumerDokumentu { get; set; }
        public Date DataDokumentu { get; set; }
        public Date Termin { get; set; }
        public decimal Wartosc { get; set; }
    }

    private struct GrupaCCitWZ
    {
        public string NazwaWierzyciela { get; set; }
        public string NIP { get; set; }
        public string NumerDokumentu { get; set; }
        public Date DataDokumentu { get; set; }
        public Date Termin { get; set; }
        public decimal Wartosc { get; set; }
    }

    private struct GrupaDCitWZ
    {
        public string NazwaDluznika { get; set; }
        public string NIP { get; set; }
        public string NumerDokumentu { get; set; }
        public Date DataDokumentu { get; set; }
        public Date Termin { get; set; }
        public Date DataUregulowania { get; set; }
        public decimal UregulowaneWTrakcieRoku { get; set; }
        public decimal UregulowanePoRoku { get; set; }
    }

    private struct GrupaECitWZ
    {
        public string NazwaWierzyciela { get; set; }
        public string NIP { get; set; }
        public string NumerDokumentu { get; set; }
        public Date DataDokumentu { get; set; }
        public Date Termin { get; set; }
        public Date DataUregulowania { get; set; }
        public decimal UregulowaneWTrakcieRoku { get; set; }
        public decimal UregulowanePoRoku { get; set; }
    }

    private struct GrupaBCitKW
    {
        public string NazwaWspolnika { get; set; }
        public string NIP_PESEL_Wspolnika { get; set; }
    }

    private struct GrupaFCitKW
    {
        public decimal PodatekNalezny { get; set; }
        public Date Data { get; set; }
    }

    private int TakNie(bool value)
    {
        return value ? 1 : 2;
    }

    private int Tak(bool value)
    {
        return value ? 1 : 0;
    }


    private void OnContextLoad(Object sender, EventArgs args)
    {
        dek = (CIT8_32)dc[typeof(CIT8_32)];

        if((bool)dek.Bloki["A"]["CelKorekta"])
            P8.EditValue = TakNie((bool)dek.Bloki["A"]["Korekta81"]);

        if ((bool)dek.Bloki["B3"]["ZwolnienieTak"])
            P26.EditValue = 1;
        else if ((bool)dek.Bloki["B3"]["ZwolnienieUtracil"])
            P26.EditValue = 2;
        else if ((bool)dek.Bloki["B3"]["ZwolnienieNie"])
            P26.EditValue = 3;

        P33.EditValue = TakNie((bool)dek.Bloki["B3"]["MajatekPozaRPTak"]);
        P34.Visible = (bool)dek.Bloki["B3"]["MajatekPozaRPTak"];
        Sec48_59.Visible = (decimal) dek.Bloki["D1"]["Razem"] != 0m || (decimal) dek.Bloki["D1"]["RazemIz"] != 0m;
        Sec60_77.Visible = (decimal) dek.Bloki["D2"]["Razem"] != 0m || (decimal) dek.Bloki["D2"]["RazemIz"] != 0m;
        Sec96_113.Visible =
            (decimal) dek.Bloki["E1"]["DochodBezWolnych"] != 0m || (decimal) dek.Bloki["E1"]["DochodBezWolnychIz"] != 0m ||
            (decimal) dek.Bloki["E1"]["StratyLatUbieglych2017"] != 0m || (decimal) dek.Bloki["E1"]["StratyLatUbieglych2017Iz"] != 0m ||
            (decimal) dek.Bloki["E1"]["DochodPoStratach2017"] != 0m || (decimal) dek.Bloki["E1"]["DochodPoStratach2017Iz"] != 0m ||
            (decimal) dek.Bloki["E1"]["InneOdliczenia"] != 0m || (decimal) dek.Bloki["E1"]["InneOdliczeniaIz"] != 0m ||
            (decimal) dek.Bloki["E1"]["NieodliczoneStratyArt7"] != 0m || (decimal) dek.Bloki["E1"]["NieodliczoneStratyArt7Iz"] != 0m ||
            (decimal) dek.Bloki["E1"]["Razem"] != 0m || (decimal) dek.Bloki["E1"]["RazemIz"] != 0m;
        Sec116_118.Visible = (decimal) dek.Bloki["E3"]["Razem"] != 0m;
        Sec133_137.Visible = (decimal) dek.Bloki["E7"]["Razem"] != 0m;
        Sec135_136.Visible = (decimal) dek.Bloki["E7"]["InneDoliczeniaKwota"] != 0m;
        SectionPodstawa19.Visible = dek.E8Podstawa19 != 0m;
        SectionPodstawa9.Visible = dek.E8Podstawa9 != 0m;
        Sec148_149.Visible = !string.IsNullOrEmpty((string)dek.Bloki["F"]["Nalezny20Rok"]);
        P246.Visible = (decimal) dek.Bloki["H"]["Nadplata"] == 0m;
        P247.Visible = (decimal) dek.Bloki["H"]["Nadplata"] != 0m;
        P259.Visible = (decimal) dek.Bloki["I"]["DoZaplaty"] != 0m;
        P260.Visible = (decimal) dek.Bloki["I"]["DoZaplaty"] == 0m;

        SecD1_P1.Visible = (decimal)dek.Bloki["J"]["D1"] != 0m || (decimal)dek.Bloki["J"]["P1"] != 0m;
        SecD2_P2.Visible = (decimal)dek.Bloki["J"]["D2"] != 0m || (decimal)dek.Bloki["J"]["P2"] != 0m;
        SecD3_P3.Visible = (decimal)dek.Bloki["J"]["D3"] != 0m || (decimal)dek.Bloki["J"]["P3"] != 0m;
        SecD4_P4.Visible = (decimal)dek.Bloki["J"]["D4"] != 0m || (decimal)dek.Bloki["J"]["P4"] != 0m;
        SecD5_P5.Visible = (decimal)dek.Bloki["J"]["D5"] != 0m || (decimal)dek.Bloki["J"]["P5"] != 0m;
        SecD6_P6.Visible = (decimal)dek.Bloki["J"]["D6"] != 0m || (decimal)dek.Bloki["J"]["P6"] != 0m;
        SecD7_P7.Visible = (decimal)dek.Bloki["J"]["D7"] != 0m || (decimal)dek.Bloki["J"]["P7"] != 0m;
        SecD8_P8.Visible = (decimal)dek.Bloki["J"]["D8"] != 0m || (decimal)dek.Bloki["J"]["P8"] != 0m;
        SecD9_P9.Visible = (decimal)dek.Bloki["J"]["D9"] != 0m || (decimal)dek.Bloki["J"]["P9"] != 0m;
        SecD10_P10.Visible = (decimal)dek.Bloki["J"]["D10"] != 0m || (decimal)dek.Bloki["J"]["P10"] != 0m;
        SecD11_P11.Visible = (decimal)dek.Bloki["J"]["D11"] != 0m || (decimal)dek.Bloki["J"]["P11"] != 0m;
        SecD12_P12.Visible = (decimal)dek.Bloki["J"]["D12"] != 0m || (decimal)dek.Bloki["J"]["P12"] != 0m;
        SecD13_P13.Visible = (decimal)dek.Bloki["J"]["D13"] != 0m || (decimal)dek.Bloki["J"]["P13"] != 0m;
        SecD14_P14.Visible = (decimal)dek.Bloki["J"]["D14"] != 0m || (decimal)dek.Bloki["J"]["P14"] != 0m;
        SecD15_P15.Visible = (decimal)dek.Bloki["J"]["D15"] != 0m || (decimal)dek.Bloki["J"]["P15"] != 0m;
        SecD16_P16.Visible = (decimal)dek.Bloki["J"]["D16"] != 0m || (decimal)dek.Bloki["J"]["P16"] != 0m;
        SecD17_P17.Visible = (decimal)dek.Bloki["J"]["D17"] != 0m || (decimal)dek.Bloki["J"]["P17"] != 0m;
        SecD18_P18.Visible = (decimal)dek.Bloki["J"]["D18"] != 0m || (decimal)dek.Bloki["J"]["P18"] != 0m;
        SecD19_P19.Visible = (decimal)dek.Bloki["J"]["D19"] != 0m || (decimal)dek.Bloki["J"]["P19"] != 0m;
        SecD20_P20.Visible = (decimal)dek.Bloki["J"]["D20"] != 0m || (decimal)dek.Bloki["J"]["P20"] != 0m;
        SecD21_P21.Visible = (decimal)dek.Bloki["J"]["D21"] != 0m || (decimal)dek.Bloki["J"]["P21"] != 0m;
        SecD22_P22.Visible = (decimal)dek.Bloki["J"]["D22"] != 0m || (decimal)dek.Bloki["J"]["P22"] != 0m;
        SecD23_P23.Visible = (decimal)dek.Bloki["J"]["D23"] != 0m || (decimal)dek.Bloki["J"]["P23"] != 0m;
        Sec307_308.Visible = (decimal)dek.Bloki["K"]["Dochody"] != 0m || (decimal)dek.Bloki["K"]["Nalezny"] != 0m;
        P315.EditValue =  TakNie((bool)dek.Bloki["L"]["InnyRokPodatkowyTak"]);
        P316.EditValue =  TakNie((bool)dek.Bloki["L"]["RozpoczecieOpodatkowanieRyczaltemTak"]);
        P317.EditValue =  TakNie((bool)dek.Bloki["L"]["ZakonczenieOpodatkowanieRyczaltemTak"]);
        P318.EditValue =  TakNie((bool)dek.Bloki["L"]["OdpisCeleInwestycyjneTak"]);
        P320.EditValue =  TakNie((bool)dek.Bloki["L"]["InformacjaOInwestycjachTak"]);
        P321.EditValue =  TakNie((bool)dek.Bloki["L"]["SpolkaNieruchomosciowaTak"]);
        Zalaczniki.Visible = !dek.Deklaracje.IsEmpty;

        var citst = new List<CITST_8>();
        var city8O = new List<CIT8O_18>();
        var cityBR = new List<CIT8BR_9>();
        var grupyBR = new List<GrupaCitBR>();
        var cityD = new List<CITD_7>();
        var cityMIT = new List<CITMIT_3>();
        var grupyMIT = new List<GrupaCitMIT>();
        var city8SP = new List<CIT8SP_5>();
        var grupyB8SP = new List<GrupaBCit8S>();
        var grupyD8SP = new List<GrupaDCit8S>();
        var grupyE8SP = new List<GrupaECit8S>();
        var city8S = new List<CIT8S_5>();
        var grupyB8S = new List<GrupaBCit8S>();
        var grupyD8S = new List<GrupaDCit8S>();
        var grupyE8S = new List<GrupaECit8S>();
        var cityIP = new List<CITIP_4>();
        var grupyIP = new List<GrupaCitIP>();
        var cityWZ = new List<CITWZ_3>();
        var grupyBWZ = new List<GrupaBCitWZ>();
        var grupyCWZ = new List<GrupaCCitWZ>();
        var grupyDWZ = new List<GrupaDCitWZ>();
        var grupyEWZ = new List<GrupaECitWZ>();
        var cityKW = new List<CITKW_3>();
        var grupyBKW = new List<GrupaBCitKW>();
        var grupyFKW = new List<GrupaFCitKW>();

        foreach (Deklaracja z in dek.Deklaracje)
            if (z is CIT8O_18)
                city8O.Add((CIT8O_18)z);
            else if (z is CIT8BR_9)
                cityBR.Add((CIT8BR_9)z);
            else if (z is CITD_7)
                cityD.Add((CITD_7)z);
            else if (z is CITMIT_3)
                cityMIT.Add((CITMIT_3)z);
            else if (z is CIT8SP_5)
                city8SP.Add((CIT8SP_5)z);
            else if (z is CIT8S_5)
                city8S.Add((CIT8S_5)z);
            else if (z is CITIP_4)
                cityIP.Add((CITIP_4)z);
            else if (z is CITWZ_3)
                cityWZ.Add((CITWZ_3)z);
            else if (z is CITKW_3)
                cityKW.Add((CITKW_3) z);

        city8S.Sort(delegate(CIT8S_5 s1, CIT8S_5 s2) { return s1.NumerZalacznika.CompareTo(s2.NumerZalacznika); });
        city8SP.Sort(delegate(CIT8SP_5 s1, CIT8SP_5 s2) { return s1.NumerZalacznika.CompareTo(s2.NumerZalacznika); });
        cityIP.Sort(delegate(CITIP_4 s1, CITIP_4 s2) { return s1.NumerZalacznika.CompareTo(s2.NumerZalacznika); });

        foreach (CIT8BR_9 br in cityBR)
        {
            string blk = "F";
            for (int i = 1; i <= 3; i++)
            {
                if (((string) br.Bloki[blk + i + "1"]["NazwaJednostki"]).IsNullOrEmpty())
                    continue;
                grupyBR.Add(new GrupaCitBR
                {
                    Nazwa = (string)br.Bloki[blk + i + "1"]["NazwaJednostki"],
                    KodKraju =  GetKodKraju(br.Session, (string)br.Bloki[blk + i + "2"]["Kraj"]),
                    Wojewodztwo = (string)br.Bloki[blk + i + "2"]["Wojew"],
                    Powiat = (string)br.Bloki[blk + i + "2"]["Powiat"],
                    Gmina = (string)br.Bloki[blk + i + "2"]["Gmina"],
                    Ulica = (string)br.Bloki[blk + i + "2"]["Ulica"],
                    NrDomu = (string)br.Bloki[blk + i + "2"]["NrDomu"],
                    NrLokalu = (string)br.Bloki[blk + i + "2"]["NrLokalu"],
                    Miejscowosc = (string)br.Bloki[blk + i + "2"]["Miejsc"],
                    KodPocztowy = (string)br.Bloki[blk + i + "2"]["KodPoczt"],
                });
            }
        }

        foreach (CITMIT_3 mit in cityMIT)
        {
            string blk = "B";
            for (int i = 1; i<=5; i++)
            {
                if (((string)mit.Bloki[blk+i]["NazwaST"]).IsNullOrEmpty() && grupyMIT.Any())
                    continue;
                grupyMIT.Add(new GrupaCitMIT
                {
                    NazwaST = (string)mit.Bloki[blk+i]["NazwaST"],
                    LiczbaST = (decimal)mit.Bloki[blk+i]["LiczbaST"],
                });
            }
        }

        foreach (CIT8SP_5 csp in city8SP)
        {
            string blk = "B";
            for (int i = 1; i<=2; i++)
            {
                if (((string)csp.Bloki[blk+i]["NumerZezwolenia"]).IsNullOrEmpty() && grupyB8SP.Any())
                    continue;
                grupyB8SP.Add(new GrupaBCit8S
                {
                    NumerZezwolenia = (string)csp.Bloki[blk+i]["NumerZezwolenia"],
                    DataWydania = (Date)csp.Bloki[blk+i]["DataWydania"],
                    DataRozpoczecia = (Date)csp.Bloki[blk+i]["DataRozpoczecia"],
                    NazwaPodmiotu = (string)csp.Bloki[blk+i]["NazwaPodmiotu"],
                    NIP = (string)csp.Bloki[blk+i]["NIP"],
                    Udzial = (Percent)csp.Bloki[blk+i]["Udzial"],
                    MaxPomoc = (decimal)csp.Bloki[blk+i+"1"]["MaxPomoc"],
                    MaxPomocDyskonto = (decimal)csp.Bloki[blk+i+"1"]["MaxPomocDyskonto"],
                    Koszty = (decimal)csp.Bloki[blk+i+"1"]["Koszty"],
                    KosztyDyskonto = (decimal)csp.Bloki[blk+i+"1"]["KosztyDyskonto"],
                    Pomoc = (decimal)csp.Bloki[blk+i+"1"]["Pomoc"],
                    PomocDyskonto = (decimal)csp.Bloki[blk+i+"1"]["PomocDyskonto"],
                    InneWsparcie = (decimal)csp.Bloki[blk+i+"1"]["InneWsparcie"],
                    InneWsparcieDyskonto = (decimal)csp.Bloki[blk+i+"1"]["InneWsparcieDyskonto"],
                });
            }
            blk = "D";
            for (int i = 1; i<=2; i++)
            {
                if (((string)csp.Bloki[blk+i]["NumerZezwolenia"]).IsNullOrEmpty())
                    continue;
                grupyD8SP.Add(new GrupaDCit8S
                {
                    NumerZezwolenia = (string)csp.Bloki[blk+i]["NumerZezwolenia"],
                    DataWydania = (Date)csp.Bloki[blk+i]["DataWydania"],
                    Dochod = (decimal)csp.Bloki[blk+i]["Dochod"],
                });
            }
            blk = "E";
            for (int i = 1; i <= 2; i++)
            {
                if (((string)csp.Bloki[blk+i]["NumerZezwolenia"]).IsNullOrEmpty())
                    continue;
                grupyE8SP.Add(new GrupaECit8S
                {
                    NumerZezwolenia = (string)csp.Bloki[blk+i]["NumerZezwolenia"],
                    DataCofniecia = (Date)csp.Bloki[blk+i]["DataCofniecia"],
                    PodatekNiezaplacony = (decimal)csp.Bloki[blk+i]["PodatekNiezaplacony"],
                    MaksymalnaPomoc = (decimal)csp.Bloki[blk+i]["MaksymalnaPomoc"],
                    PodatekZaplacony = (decimal)csp.Bloki[blk+i]["PodatekZaplacony"],
                });
            }
        }

        foreach (CIT8S_5 cs in city8S)
        {
            string blk = "B";
            for (int i = 1; i<=2; i++)
            {
                if (((string)cs.Bloki[blk+i]["NumerZezwolenia"]).IsNullOrEmpty() && grupyB8S.Any())
                    continue;
                grupyB8S.Add(new GrupaBCit8S
                {
                    NumerZezwolenia = (string)cs.Bloki[blk+i]["NumerZezwolenia"],
                    DataWydania = (Date)cs.Bloki[blk+i]["DataWydania"],
                    DataRozpoczecia = (Date)cs.Bloki[blk+i]["DataRozpoczecia"],
                    MaxPomoc = (decimal)cs.Bloki[blk+i+"1"]["MaxPomoc"],
                    MaxPomocDyskonto = (decimal)cs.Bloki[blk+i+"1"]["MaxPomocDyskonto"],
                    Koszty = (decimal)cs.Bloki[blk+i+"1"]["Koszty"],
                    KosztyDyskonto = (decimal)cs.Bloki[blk+i+"1"]["KosztyDyskonto"],
                    Pomoc = (decimal)cs.Bloki[blk+i+"1"]["Pomoc"],
                    PomocDyskonto = (decimal)cs.Bloki[blk+i+"1"]["PomocDyskonto"],
                    InneWsparcie = (decimal)cs.Bloki[blk+i+"1"]["InneWsparcie"],
                    InneWsparcieDyskonto = (decimal)cs.Bloki[blk+i+"1"]["InneWsparcieDyskonto"],
                });
            }
            blk = "D";
            for (int i = 1; i<=2; i++)
            {
                if (((string)cs.Bloki[blk+i]["NumerZezwolenia"]).IsNullOrEmpty())
                    continue;
                grupyD8S.Add(new GrupaDCit8S
                {
                    NumerZezwolenia = (string)cs.Bloki[blk+i]["NumerZezwolenia"],
                    DataWydania = (Date)cs.Bloki[blk+i]["DataWydania"],
                    Dochod = (decimal)cs.Bloki[blk+i]["Dochod"],
                });
            }
            blk = "E";
            for (int i = 1; i <= 2; i++)
            {
                if (((string)cs.Bloki[blk+i]["NumerZezwolenia"]).IsNullOrEmpty())
                    continue;
                grupyE8S.Add(new GrupaECit8S
                {
                    NumerZezwolenia = (string)cs.Bloki[blk+i]["NumerZezwolenia"],
                    DataCofniecia = (Date)cs.Bloki[blk+i]["DataCofniecia"],
                    PodatekNiezaplacony = (decimal)cs.Bloki[blk+i]["PodatekNiezaplacony"],
                    MaksymalnaPomoc = (decimal)cs.Bloki[blk+i]["MaksymalnaPomoc"],
                    PodatekZaplacony = (decimal)cs.Bloki[blk+i]["PodatekZaplacony"],
                });
            }
        }

        foreach (CITIP_4 ip in cityIP)
        {
            string blk = "G";
            for (int i = 1; i <= 2; i++)
            {
                if(string.IsNullOrEmpty((string)ip.Bloki[blk + i]["NumerZezwolenia"]))
                    continue;

                grupyIP.Add(new GrupaCitIP
                {
                    NumerZezwolenia = (string)ip.Bloki[blk + i]["NumerZezwolenia"],
                    DataWydaniaZezwolenia = (Date)ip.Bloki[blk + i]["DataWydaniaZezwolenia"],
                    JednostkaTerytorialnaRealizacjiInwestycji = (string)ip.Bloki[blk + i]["JednostkaTerytorialnaRealizacjiInwestycji"],
                    DochodPodlegajacyZwolnieniuZPodatku = (decimal)ip.Bloki[blk + i]["DochodPodlegajacyZwolnieniuZPodatku"]
                });
            }
        }
        foreach (CITKW_3 kw in cityKW)
        {
            string blk = "F";
            for (int i = 21; i <= 23; i++)
            {
                if((decimal)kw.Bloki[blk + i]["PodatekNalezny"] <= 0m)
                    continue;

                grupyFKW.Add(new GrupaFCitKW
                {
                    PodatekNalezny = (decimal)kw.Bloki[blk + i]["PodatekNalezny"],
                    Data = (Date)kw.Bloki[blk + i]["Data"],
                });
            }
        }

        foreach (CITKW_3 kw in cityKW)
        {
            string blk = "B";
            for (int i = 21; i <= 23; i++)
            {
                if(string.IsNullOrEmpty((string)kw.Bloki[blk + i]["NazwaWspolnika"]))
                    continue;

                grupyBKW.Add(new GrupaBCitKW
                {
                    NazwaWspolnika = (string)kw.Bloki[blk + i]["NazwaWspolnika"],
                    NIP_PESEL_Wspolnika = (string)kw.Bloki[blk + i]["NIP_PESEL_Wspolnika"],
                });
            }
        }

        foreach (CITWZ_3 cwz in cityWZ)
        {
            string blk = "B";
            for (int i = 1; i<=2; i++)
            {
                if (((string)cwz.Bloki[blk+i]["Nazwa"]).IsNullOrEmpty())
                    continue;
                grupyBWZ.Add(new GrupaBCitWZ
                {
                    NazwaDluznika = (string)cwz.Bloki[blk+i]["Nazwa"],
                    NIP = (string)cwz.Bloki[blk+i]["NIP"],
                    NumerDokumentu = (string)cwz.Bloki[blk+i]["NumerDokumentu"],
                    DataDokumentu = (Date)cwz.Bloki[blk+i]["DataDokumentu"],
                    Termin = (Date)cwz.Bloki[blk+i]["Termin"],
                    Wartosc = (decimal)cwz.Bloki[blk+i]["Wartosc"]
                });
            }

            blk = "C";
            for (int i = 1; i<=2; i++)
            {
                if (((string)cwz.Bloki[blk+i]["Nazwa"]).IsNullOrEmpty())
                    continue;
                grupyCWZ.Add(new GrupaCCitWZ
                {
                    NazwaWierzyciela = (string)cwz.Bloki[blk+i]["Nazwa"],
                    NIP = (string)cwz.Bloki[blk+i]["NIP"],
                    NumerDokumentu = (string)cwz.Bloki[blk+i]["NumerDokumentu"],
                    DataDokumentu = (Date)cwz.Bloki[blk+i]["DataDokumentu"],
                    Termin = (Date)cwz.Bloki[blk+i]["Termin"],
                    Wartosc = (decimal)cwz.Bloki[blk+i]["Wartosc"]
                });
            }
            blk = "D";
            for (int i = 1; i<=2; i++)
            {
                if (((string)cwz.Bloki[blk+i]["Nazwa"]).IsNullOrEmpty())
                    continue;
                grupyDWZ.Add(new GrupaDCitWZ
                {
                    NazwaDluznika = (string)cwz.Bloki[blk+i]["Nazwa"],
                    NIP = (string)cwz.Bloki[blk+i]["NIP"],
                    NumerDokumentu = (string)cwz.Bloki[blk+i]["NumerDokumentu"],
                    DataDokumentu = (Date)cwz.Bloki[blk+i]["DataDokumentu"],
                    DataUregulowania = (Date)cwz.Bloki[blk+i]["DataUregulowania"],
                    UregulowaneWTrakcieRoku = (decimal)cwz.Bloki[blk+i]["UregulowaneWTrakcieRoku"],
                });
            }
            blk = "E";
            for (int i = 1; i<=2; i++)
            {
                if (((string)cwz.Bloki[blk+i]["Nazwa"]).IsNullOrEmpty())
                    continue;
                grupyEWZ.Add(new GrupaECitWZ
                {
                    NazwaWierzyciela = (string)cwz.Bloki[blk+i]["Nazwa"],
                    NIP = (string)cwz.Bloki[blk+i]["NIP"],
                    NumerDokumentu = (string)cwz.Bloki[blk+i]["NumerDokumentu"],
                    DataDokumentu = (Date)cwz.Bloki[blk+i]["DataDokumentu"],
                    DataUregulowania = (Date)cwz.Bloki[blk+i]["DataUregulowania"],
                    UregulowaneWTrakcieRoku = (decimal)cwz.Bloki[blk+i]["UregulowaneWTrakcieRoku"],
                });
            }
        }

        CIT8O.DataSource = city8O;
        CITBR.DataSource = cityBR.Take(1);
        CITBR_P_F.DataSource = grupyBR;
        CITD_Repeater.DataSource = cityD;
        CITMIT.DataSource = cityMIT.Take(1);
        CITMIT_P_B.DataSource = grupyMIT;
        CIT8SP.DataSource = city8SP.Take(1);
        CIT8SP_P_B.DataSource = grupyB8SP;
        CIT8SP_P_D.DataSource = grupyD8SP;
        CIT8SP_P_E.DataSource = grupyE8SP;
        CIT8S.DataSource = city8S.Take(1);
        CIT8S_P_B.DataSource = grupyB8S;
        CIT8S_P_D.DataSource = grupyD8S;
        CIT8S_P_E.DataSource = grupyE8S;
        CITIP.DataSource = cityIP.Take(1);
        CITIP_P_G.DataSource = grupyIP;
        CITWZ.DataSource = cityWZ.Take(1);
        CITWZ_P_B.DataSource = grupyBWZ;
        CITWZ_P_C.DataSource = grupyCWZ;
        CITWZ_P_D.DataSource = grupyDWZ;
        CITWZ_P_E.DataSource = grupyEWZ;
        CITKW.DataSource = cityKW.Take(1);
        CITKW_P_B.DataSource = grupyBKW;
        CITKW_P_F.DataSource = grupyFKW;
        ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
    }

    void CIT8O_BeforeRow(Object sender, EventArgs args)
    {
        var cit8O = (CIT8O_18)CIT8O.CurrentRow;
        CIT8O_Od.EditValue = dek.Bloki["0"]["Od"];
        CIT8O_Do.EditValue = dek.Bloki["0"]["Do"];

        if (string.IsNullOrEmpty((string)cit8O.Bloki["B1"]["InneTytul"]))
            SecInneDochody.Visible = false;

        if (string.IsNullOrEmpty((string)cit8O.Bloki["B21"]["Rok1"]))
            B21Rok1.Visible = false;
        if (string.IsNullOrEmpty((string)cit8O.Bloki["B21"]["Rok2"]))
            B21Rok2.Visible = false;
        if (string.IsNullOrEmpty((string)cit8O.Bloki["B21"]["Rok3"]))
            B21Rok3.Visible = false;
        if (string.IsNullOrEmpty((string)cit8O.Bloki["B21"]["Rok4"]))
            B21Rok4.Visible = false;
        if (string.IsNullOrEmpty((string)cit8O.Bloki["B21"]["Rok5"]))
            B21Rok5.Visible = false;

        if (string.IsNullOrEmpty((string)cit8O.Bloki["B22"]["Rok1"]))
            B22Rok1.Visible = false;
        if (string.IsNullOrEmpty((string)cit8O.Bloki["B22"]["Rok2"]))
            B22Rok2.Visible = false;
        if (string.IsNullOrEmpty((string)cit8O.Bloki["B22"]["Rok3"]))
            B22Rok3.Visible = false;
        if (string.IsNullOrEmpty((string)cit8O.Bloki["B22"]["Rok4"]))
            B22Rok4.Visible = false;
        if (string.IsNullOrEmpty((string)cit8O.Bloki["B22"]["Rok5"]))
            B22Rok5.Visible = false;

        if (string.IsNullOrEmpty((string)cit8O.Bloki["B23"]["Rok1"]))
            B23Rok1.Visible = false;
        if (string.IsNullOrEmpty((string)cit8O.Bloki["B23"]["Rok2"]))
            B23Rok2.Visible = false;
        if (string.IsNullOrEmpty((string)cit8O.Bloki["B23"]["Rok3"]))
            B23Rok3.Visible = false;
        if (string.IsNullOrEmpty((string)cit8O.Bloki["B23"]["Rok4"]))
            B23Rok4.Visible = false;
        if (string.IsNullOrEmpty((string)cit8O.Bloki["B23"]["Rok5"]))
            B23Rok5.Visible = false;

        if (string.IsNullOrEmpty((string)cit8O.Bloki["B3"]["InneTytul"]))
            SecInneOdliczenia.Visible = false;

        if ((Soneta.Types.Date)cit8O.Bloki["E"]["ZwolnienieDataDecyzji"] == Soneta.Types.Date.Empty ||
            string.IsNullOrEmpty((string)cit8O.Bloki["E"]["ZwolnienieDecyzja"]))
            SecZwolnienie.Visible = false;

        if ((Soneta.Types.Date)cit8O.Bloki["E"]["ZaniechanieDataRozporzadzenia"]==Soneta.Types.Date.Empty ||
            string.IsNullOrEmpty((string)cit8O.Bloki["E"]["ZaniechanieRozporzadzenie"]))
            SecZaniechanie.Visible = false;

        if (string.IsNullOrEmpty((string)cit8O.Bloki["E"]["InneTytul"]))
            SecObnizki.Visible = false;
    }


    private void CITBR_BeforeRow(Object sender, EventArgs args)
    {
        var citbr = (CIT8BR_9) CITBR.CurrentRow;
        var bloki = citbr.Bloki;

        CITBR_Od.EditValue = dek.Bloki["0"]["Od"];
        CITBR_Do.EditValue = dek.Bloki["0"]["Do"];

        StatusCentrum.EditValue = TakNie((bool) bloki["A"]["StatusCentrumTak"]);
        if ((bool) bloki["A"]["StatusCentrumNie"])
            SecStatusCentrum.Visible = false;
        if ((bool) bloki["A"]["MikrofirmaTak"] || (bool) bloki["A"]["MikrofirmaNie"])
        {
            Mikrofirma.EditValue = TakNie((bool) bloki["A"]["MikrofirmaTak"]);
        }
        else
        {
            Mikrofirma.Visible = false;
        }
        if(((string) bloki["D1"]["Nazwa"]).IsNullOrEmpty())
            D_DaneSpolki.Visible = false;

        SpolkaMikrofirma.EditValue = TakNie((bool) bloki["D1"]["MikrofirmaTak"]);

        BadaniaNaukowe.EditValue = TakNie((bool) bloki["E"]["BadaniaNaukoweTak"]);
        PraceRozwojowe.EditValue = TakNie((bool) bloki["E"]["PraceRozwojoweTak"]);
        BadaniaPodstawowe.EditValue = Tak((bool) bloki["E1"]["BadaniaPodstawowe"]);
        BadaniaAplikacyjne.EditValue = Tak((bool) bloki["E1"]["BadaniaAplikacyjne"]);
    }


    private void CITD_BeforeRow(Object sender, EventArgs args)
    {
        var citd = (CITD_7)CITD_Repeater.CurrentRow;
        var session = citd.Session;

        CITD_Od.EditValue = dek.Bloki["0"]["Od"];
        CITD_Do.EditValue = dek.Bloki["0"]["Do"];

        var bloki = citd.Bloki;

        var blokB1 = bloki["B1"];
        if ((bool) blokB1["Otrzymujacy"])
        {
            CITD_RodzajPodatnika.EditValue = 1;
        }
        else if ((bool) blokB1["Przekazujacy"])
        {
            CITD_RodzajPodatnika.EditValue = 2;
        }
        else if ((bool) blokB1["OtrzymujacyPrzekazujacy"])
        {
            CITD_RodzajPodatnika.EditValue = 3;
        }

        CITD_DaneDarczyncy1.Visible = !((string) bloki["C11"]["NazwaPelna"]).IsNullOrEmpty();
        CITD_DaneDarczyncy2.Visible = !((string) bloki["C21"]["NazwaPelna"]).IsNullOrEmpty();
        CITD_DaneDarczyncy3.Visible = !((string) bloki["C31"]["NazwaPelna"]).IsNullOrEmpty();

        CITDC12KodKraju.EditValue = GetKodKraju(session, (string) bloki["C12"]["Kraj"]);
        CITDC22KodKraju.EditValue = GetKodKraju(session, (string) bloki["C22"]["Kraj"]);
        CITDC32KodKraju.EditValue = GetKodKraju(session, (string) bloki["C32"]["Kraj"]);

        CITD_Obdarowany1.Visible = CzyWidocznyObdarowany(bloki["D1"]);
        CITD_Obdarowany2.Visible = CzyWidocznyObdarowany(bloki["D2"]);
        CITD_Obdarowany3.Visible = CzyWidocznyObdarowany(bloki["D3"]);

        CITDD12KodKraju.EditValue = GetKodKraju(session, (string)bloki["D12"]["Kraj"]);
        CITDD22KodKraju.EditValue = GetKodKraju(session, (string)bloki["D22"]["Kraj"]);
        CITDD32KodKraju.EditValue = GetKodKraju(session, (string)bloki["D32"]["Kraj"]);
    }


    private void CITMIT_BeforeRow(Object sender, EventArgs args)
    {
        var citmit = (CITMIT_3)CITMIT.CurrentRow;

        CITMIT_Od.EditValue = dek.Bloki["0"]["Od"];
        CITMIT_Do.EditValue = dek.Bloki["0"]["Do"];
    }


    private void CIT8SP_BeforeRow(Object sender, EventArgs args)
    {
        var cit8sp = (CIT8SP_5)CIT8SP.CurrentRow;

        CIT8SP_Od.EditValue = dek.Bloki["0"]["Od"];
        CIT8SP_Do.EditValue = dek.Bloki["0"]["Do"];

        CIT8SP_KosztyKwalifikowane.Visible = ((decimal)cit8sp.Bloki["F"]["KwotaKosztowB+R"] > 0m) && !string.IsNullOrEmpty((string)cit8sp.Bloki["F"]["NumerZezwolenia"]);
    }


    private void CIT8S_BeforeRow(Object sender, EventArgs args)
    {
        var cit8s = (CIT8S_5)CIT8S.CurrentRow;

        CIT8S_Od.EditValue = dek.Bloki["0"]["Od"];
        CIT8S_Do.EditValue = dek.Bloki["0"]["Do"];

        CIT8S_KosztyKwalifikowane.Visible = ((decimal)cit8s.Bloki["F"]["KwotaKosztowB+R"] > 0m) && !string.IsNullOrEmpty((string)cit8s.Bloki["F"]["NumerZezwolenia"]);
    }


    private void CITIP_BeforeRow(Object sender, EventArgs args)
    {
        var citip = (CITIP_4) CITIP.CurrentRow;
        var bloki = citip.Bloki;

        CITIP_Od.EditValue = dek.Bloki["0"]["Od"];
        CITIP_Do.EditValue = dek.Bloki["0"]["Do"];

        KwalifikowanyDochod.EditValue = Tak((bool) bloki["C"]["KwalifikowanyDochodDlaTegoSamegoRodzaju"]);
    }


    private void CITWZ_BeforeRow(Object sender, EventArgs args)
    {
        var last_citwz = dek.Deklaracje.OfType<CITWZ_3>().FirstOrDefault(x=> x.OstatniZalacznik);

        CITWZ_Od.EditValue = dek.Bloki["0"]["Od"];
        CITWZ_Do.EditValue = dek.Bloki["0"]["Do"];
        CITWZ_SumaB.EditValue = last_citwz != null ? last_citwz.SumaB : 0m;
        CITWZ_SumaC.EditValue = last_citwz != null ? last_citwz.SumaC : 0m;
        CITWZ_SumaD.EditValue = last_citwz != null ? last_citwz.SumaD : 0m;
        CITWZ_SumaE.EditValue = last_citwz != null ? last_citwz.SumaE : 0m;
    }


    private void CITKW_BeforeRow(Object sender, EventArgs args)
    {
        var citkw = (CITKW_3) CITKW.CurrentRow;

        CITKW_Od.EditValue = dek.Bloki["0"]["Od"];
        CITKW_Do.EditValue = dek.Bloki["0"]["Do"];

        KW_P16.EditValue = TakNie((bool)citkw.Bloki["B"]["PowstalWWynikuPrzeksztalceniaSpolki"]);
        KW_P17.EditValue = TakNie((bool)citkw.Bloki["B"]["PowstalWWynikuPrzeksztalceniaPrzedsiebiorcy"]);
        KW_P18.EditValue = TakNie((bool)citkw.Bloki["B"]["PowstalWWynikuPrzeksztalceniaSpolkiNiebedacejOsobaPrawna"]);
        KW_P19.EditValue = TakNie((bool)citkw.Bloki["B"]["PowstalWWynikuInnychRestrukturyzacji"]);

        var restrukturyzacja = 0;
        if ((bool) citkw.Bloki["B3"]["FormaRestrukturyzacjiPodział"])
            restrukturyzacja = 1;
        else if ((bool) citkw.Bloki["B3"]["FormaRestrukturyzacjiŁączenie"])
            restrukturyzacja = 2;
        else if ((bool) citkw.Bloki["B3"]["FormaRestrukturyzacjiWniesienieWkładu"])
            restrukturyzacja = 3;
        else if ((bool) citkw.Bloki["B3"]["FormaRestrukturyzacjiInne"])
            restrukturyzacja = 4;

        KW_P26.EditValue = restrukturyzacja;
        KW_P2628.Visible = restrukturyzacja > 0;

        KW_C.Visible = citkw.CzyEdycyjnaSekcjaC;
        KW_D.Visible = citkw.CzyEdycyjnaSekcjaD;
    }


    private static bool CzyWidocznyObdarowany(BlokDeklaracji blok)
    {
        return
            ((decimal) blok["KwotaOdliczona"]) != 0m;
    }


    private static string GetKodKraju(Session session, string nazwaKraju)
    {
        var krajTbl = session.Get<CoreModule>().KrajeTbl.WgNazwa[nazwaKraju];
        return krajTbl != null ? krajTbl.Kod2 : "";
    }


</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.CIT.CIT8_32,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja
    xsi:schemaLocation="http://crd.gov.pl/wzor/2023/05/10/12464/ http://crd.gov.pl/wzor/2023/05/10/12464/schemat.xsd"
    xmlns="http://crd.gov.pl/wzor/2023/05/10/12464/"
    xmlns:tns="http://crd.gov.pl/wzor/2023/05/10/12464/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"

    xmlns:czm="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CITM/"
    xmlns:czpd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CITPD/"
    xmlns:cz8o="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CIT8O/"
    xmlns:cz8s="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CIT8S/"
    xmlns:cz8sp="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CIT8SP/"
    xmlns:czbr="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CITBR/"
    xmlns:czd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CITD/"
    xmlns:czip="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CITIP/"
    xmlns:czkw="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CITKW/"
    xmlns:czmit="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CITMIT/"
    xmlns:cznz="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CITNZI/"
    xmlns:czpm="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CITPM/"
    xmlns:czww="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CITWW/"
    xmlns:czwz="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/CITWZ/"
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/DefinicjeTypy/"
    xmlns:ssr="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/21/eD/SSER/"
    xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/ORDZU/" >

	<Naglowek>
		<KodFormularza kodSystemowy="CIT-8 (32)" kodPodatku="CIT" rodzajZobowiazania="Z" wersjaSchemy="3-0E">CIT-8</KodFormularza>
		<WariantFormularza>32</WariantFormularza>
		<CelZlozenia poz="P_7"><ea:XmlDataLabel ID="CelZlozenia" runat="server" DataMember="A.CelKorekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<OkresOd poz="P_4"><ea:XmlDataLabel runat="server" DataMember="0.Od" XSDType="TData"  /></OkresOd>
		<OkresDo poz="P_5"><ea:XmlDataLabel runat="server" DataMember="0.Do" XSDType="TData"  /></OkresDo>
		<KodUrzedu><ea:XmlDataLabel ID="DataLabel4" runat="server" DataMember="X.KodUrzeduSkarbowego" /></KodUrzedu>
	</Naglowek>

	<Podmiot1 rola="Podatnik">
		<OsobaNiefizyczna>
				<ea:XmlDataLabel ID="XmlDataLabel2" runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
				<etd:PelnaNazwa><ea:XmlDataLabel ID="NazwaPelna" runat="server" DataMember="B1.Nazwa" XSDType="TZnakowy"></ea:XmlDataLabel></etd:PelnaNazwa>
		</OsobaNiefizyczna>
		<AdresSiedziby rodzajAdresu="RAD">
			<AdresPol>
				<KodKraju>PL</KodKraju>
				<Wojewodztwo><ea:XmlDataLabel ID="XmlDataLabel3" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin"></ea:XmlDataLabel></Wojewodztwo>
				<Powiat><ea:XmlDataLabel ID="XmlDataLabel4" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"></ea:XmlDataLabel></Powiat>
				<Gmina><ea:XmlDataLabel ID="XmlDataLabel5" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"></ea:XmlDataLabel></Gmina>
				<ea:XmlDataLabel ID="XmlDataLabel6" runat="server" ElementName="Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<NrDomu><ea:XmlDataLabel ID="XmlDataLabel7" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel></NrDomu>
				<ea:XmlDataLabel ID="XmlDataLabel8" runat="server" ElementName="NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
				<Miejscowosc><ea:XmlDataLabel ID="XmlDataLabel9" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></Miejscowosc>
				<KodPocztowy><ea:XmlDataLabel ID="XmlDataLabel10" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></KodPocztowy>
			</AdresPol>
		</AdresSiedziby>
	</Podmiot1>

	<PozycjeSzczegolowe>
        <ea:XmlDataLabel runat="server" ElementName="P_8" HideEmptyOrZero="true" ID="P8" />
        <ea:XmlDataLabel runat="server" ElementName="P_19" HideEmptyOrZero="True" DataMember="B3.MetodaUstalaniaDPPArt12Ust3G" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_20" HideEmptyOrZero="true" DataMember="B3.OdsetkiTak" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_21" HideEmptyOrZero="true" DataMember="B3.KwotaOdsetek" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_22" HideEmptyOrZero="true" DataMember="B3.PrzedsiebiorstwoFinansoweTak" XSDType="TWybor1" />
        <ea:XmlDataLabel runat="server" ElementName="P_23" HideEmptyOrZero="true" DataMember="B3.FinansowanieDluzne" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_24" HideEmptyOrZero="true" DataMember="B3.WylaczenieArt16" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_25" HideEmptyOrZero="true" DataMember="B3.ObnizenieDochoduOStrate" XSDType="TWybor1" />
        <ea:XmlDataLabel runat="server" ElementName="P_26" HideEmptyOrZero="true" ID="P26"/>
        <ea:XmlDataLabel runat="server" ElementName="P_27" HideEmptyOrZero="true" DataMember="B3.ZwrotOdliczeniaTak" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_28" HideEmptyOrZero="true" DataMember="B3.ZaliczkiKwartalne" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_29" HideEmptyOrZero="true" DataMember="B3.ZaliczkiUproszczone" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_30" HideEmptyOrZero="true" DataMember="B3.WyborUstalaniaRoznicKursowych" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_31" HideEmptyOrZero="true" DataMember="B3.RezygnacjaUstalaniaRoznicKursowych" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_32" HideEmptyOrZero="true" DataMember="B3.PolaczoneRezygnacjaUstalaniaRoznicKursowych" XSDType="TWybor1" />
        <ea:XmlDataLabel runat="server" ElementName="P_33" ID="P33" />
        <ea:XmlDataLabel runat="server" ElementName="P_34" ID="P34" DataMember="B3.MajatekPozaRPWartosc" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_35" HideEmptyOrZero="true" DataMember="B3.UzyskaniePrzychoduHipotetyczneOdsetki" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_36" HideEmptyOrZero="true" DataMember="B3KosztyHipotetycznychOdsetek" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_37" HideEmptyOrZero="true" DataMember="C.CIT/M" />
        <ea:XmlDataLabel runat="server" ElementName="P_38" HideEmptyOrZero="true" DataMember="C.CIT/PD" />
        <ea:XmlDataLabel runat="server" ElementName="P_39" HideEmptyOrZero="true" DataMember="C.SSE-R" XSDType="TWybor1" />
        <ea:XmlDataLabel runat="server" ElementName="P_40" HideEmptyOrZero="true" DataMember="C.CIT-8/O" XSDType="TWybor1" />
        <ea:XmlDataLabel runat="server" ElementName="P_41" HideEmptyOrZero="true" DataMember="C.CIT/KW" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_42" HideEmptyOrZero="true" DataMember="C.CIT/BR" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_43" HideEmptyOrZero="true" DataMember="C.CIT-D" />
        <ea:XmlDataLabel runat="server" ElementName="P_44" HideEmptyOrZero="true" DataMember="C.CIT-MIT" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_45" HideEmptyOrZero="true" DataMember="C.CIT/NZI" />
        <ea:XmlDataLabel runat="server" ElementName="P_46" HideEmptyOrZero="true" DataMember="C.CIT-8SP" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_47" HideEmptyOrZero="true" DataMember="C.CIT-8S" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_48" HideEmptyOrZero="true" DataMember="C.CIT/WW" />
        <ea:XmlDataLabel runat="server" ElementName="P_49" HideEmptyOrZero="true" DataMember="C.CIT/PM" />
        <ea:XmlDataLabel runat="server" ElementName="P_50" HideEmptyOrZero="true" DataMember="C.CIT/IP" XSDType="TWybor1"/>
        <ea:XmlDataLabel runat="server" ElementName="P_51" HideEmptyOrZero="true" DataMember="C.CIT/WZ" XSDType="TWybor1"/>
        <ea:Section runat="server" ID="Sec48_59">
            <ea:XmlDataLabel runat="server" ElementName="P_52" HideEmptyOrZero="true" DataMember="D1.RP" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_53" HideEmptyOrZero="true" DataMember="D1.RPIz" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_54" HideEmptyOrZero="true" DataMember="D1.PozaRP" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_55" HideEmptyOrZero="true" DataMember="D1.PozaRPIz" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_56" HideEmptyOrZero="true" DataMember="D1.PozaRPInne" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_57" HideEmptyOrZero="true" DataMember="D1.PozaRPInneIz" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_58" HideEmptyOrZero="true" DataMember="D1.WkladNiepieniezny" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_59" HideEmptyOrZero="true" DataMember="D1.WkladNiepienieznyIz" XSDType="TKwota2" />          
            <ea:XmlDataLabel runat="server" ElementName="P_60" DataMember="D1.Razem" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_61" DataMember="D1.RazemIz" XSDType="TKwota2" />
        </ea:Section>
        <ea:Section runat="server" ID="Sec60_77">
            <ea:XmlDataLabel runat="server" ElementName="P_62" HideEmptyOrZero="true" DataMember="D2.RP" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_63" HideEmptyOrZero="true" DataMember="D2.RPIz" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_64" HideEmptyOrZero="true" DataMember="D2.PozaRP" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_65" HideEmptyOrZero="true" DataMember="D2.PozaRPIz" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_66" HideEmptyOrZero="true" DataMember="D2.PozaRPInne" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_67" HideEmptyOrZero="true" DataMember="D2.PozaRPInneIz" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_68" HideEmptyOrZero="true" DataMember="D2.WkladNiepieniezny" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_69" HideEmptyOrZero="true" DataMember="D2.WkladNiepienieznyIz" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_70" HideEmptyOrZero="true" DataMember="D2.OdsetkiWylaczone" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_71" HideEmptyOrZero="true" DataMember="D2.OdsetkiWylaczoneIz" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_72" HideEmptyOrZero="true" DataMember="D2.KosztyFinansowania" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_73" HideEmptyOrZero="true" DataMember="D2.KosztyFinansowaniaIz" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_74" HideEmptyOrZero="true" DataMember="D2.KosztyArt15E" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_75" HideEmptyOrZero="true" DataMember="D2.KosztyArt15EIz" XSDType="TKwota2" />        
            <ea:XmlDataLabel runat="server" ElementName="P_76" DataMember="D2.Razem" XSDType="TKwota2" />
		    <ea:XmlDataLabel runat="server" ElementName="P_77" DataMember="D2.RazemIz" XSDType="TKwota2" />
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_78" HideEmptyOrZero="true" DataMember="D3.DochodArt7" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_80" HideEmptyOrZero="true" DataMember="D3.StrataArt7" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_79" HideEmptyOrZero="true"  DataMember="D3.DochodArt7Iz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_81" HideEmptyOrZero="true" DataMember="D3.StrataArt7Iz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_82" HideEmptyOrZero="true" DataMember="D3.StrataInna" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_83" HideEmptyOrZero="true" DataMember="D3.StrataInnaIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_84" HideEmptyOrZero="true" DataMember="D3.Dochod" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_85" HideEmptyOrZero="true" DataMember="D3.DochodIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_86" HideEmptyOrZero="true" DataMember="D3.Strata" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_87" HideEmptyOrZero="true" DataMember="D3.StrataIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_88" HideEmptyOrZero="true" DataMember="D4.ZmniejszenieStraty" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_89" HideEmptyOrZero="true" DataMember="D4.ZmniejszenieStratyIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_90" HideEmptyOrZero="true" DataMember="D4.StrataPoZmniejszeniu" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_92" HideEmptyOrZero="true" DataMember="D4.RoznicaStraty" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_91" HideEmptyOrZero="true" DataMember="D4.StrataPoZmniejszeniuIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_93" HideEmptyOrZero="true" DataMember="D4.RoznicaStratyIz" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_94" HideEmptyOrZero="true" DataMember="D4.DochodPoDoliczeniu" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_95" HideEmptyOrZero="true" DataMember="D4.DochodPoDoliczeniuIz" XSDType="TKwota2" />
        <ea:Section runat="server" ID="Sec96_113">
            <ea:XmlDataLabel runat="server" ElementName="P_96" HideEmptyOrZero="true" DataMember="E1.Wolne" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_97" HideEmptyOrZero="true" DataMember="E1.WolneIz" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_98" HideEmptyOrZero="true" DataMember="E1.DochodBezWolnych" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_99" HideEmptyOrZero="true" DataMember="E1.DochodBezWolnychIz" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_100" HideEmptyOrZero="true" DataMember="E1.StratyLatUbieglych2017" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_101" HideEmptyOrZero="true" DataMember="E1.StratyLatUbieglych2017Iz" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_102" HideEmptyOrZero="true" DataMember="E1.DochodPoStratach2017" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_103" HideEmptyOrZero="true" DataMember="E1.DochodPoStratach2017Iz" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_104" HideEmptyOrZero="true" DataMember="E1.NieodliczoneStratyArt7" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_105" HideEmptyOrZero="true" DataMember="E1.NieodliczoneStratyArt7Iz" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_106" HideEmptyOrZero="true" DataMember="E1.InneOdliczenia" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_107" HideEmptyOrZero="true" DataMember="E1.InneOdliczeniaIz" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_108" HideEmptyOrZero="true" DataMember="E1.RazemOdliczenia" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_109" HideEmptyOrZero="true" DataMember="E1.RazemOdliczeniaIz" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_110" HideEmptyOrZero="true" DataMember="E1.Inwestycje" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_111" HideEmptyOrZero="true" DataMember="E1.InwestycjeIz" XSDType="TKwota2" />        
            <ea:XmlDataLabel runat="server" ElementName="P_112" DataMember="E1.Razem" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_113" DataMember="E1.RazemIz" XSDType="TKwota2" />
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_114" DataMember="E2.Podstawa" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_115" HideEmptyOrZero="true" DataMember="E2.Strata" XSDType="TKwota2" />
        <ea:Section runat="server" ID="Sec116_118">
            <ea:XmlDataLabel runat="server" ElementName="P_116" HideEmptyOrZero="true" DataMember="E3.NoweTechnologie" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_117" HideEmptyOrZero="true" DataMember="E3.DziałalnośćBR" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_118" HideEmptyOrZero="true" DataMember="E3.OdliczenieZPozycjiCIT8O" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_119" HideEmptyOrZero="true" DataMember="E3.Razem" XSDType="TKwota2" />
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_120" DataMember="E4Podstawa" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_121" HideEmptyOrZero="true" DataMember="E5WierzytelnosciZmniejszajace" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_122" HideEmptyOrZero="true" DataMember="E51NieodliczoneWierzytelnosci" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_123" HideEmptyOrZero="true" DataMember="E5WierzytelnosciZwiekszajaceStrate" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_124" HideEmptyOrZero="true" DataMember="E5ZobowiazaniaZwiekszajace" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_125" HideEmptyOrZero="true" DataMember="E5ZobowiazaniaZmniejszajaceStrate" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_126" HideEmptyOrZero="true" DataMember="E5WierzytelnosciZwiekszajace" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_127" HideEmptyOrZero="true" DataMember="E5WierzytelnosciZmniejszajaceStrate" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_128" HideEmptyOrZero="true" DataMember="E5ZobowiazaniaZmniejszajace" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_129" HideEmptyOrZero="true" DataMember="E53ZobowiazaniaNieodliczone" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_130" HideEmptyOrZero="true" DataMember="E5ZobowiazaniaZwiekszajaceStrate" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_131" DataMember="E6.Podstawa" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_132" HideEmptyOrZero="true" DataMember="E6.Strata" XSDType="TKwota2" />
        <ea:Section runat="server" ID="Sec133_137">
            <ea:XmlDataLabel runat="server" ElementName="P_133" HideEmptyOrZero="true" DataMember="E7.Inwestycje" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_134" HideEmptyOrZero="true" DataMember="E7.NoweTechnologie" XSDType="TKwota2" />
            <ea:Section runat="server" ID="Sec135_136">
                <ea:XmlDataLabel runat="server" ElementName="P_135" DataMember="E7.InneDoliczeniaTytul" XSDType="TZnakowy" />
                <ea:XmlDataLabel runat="server" ElementName="P_136" DataMember="E7.InneDoliczeniaKwota" XSDType="TKwota2" />
            </ea:Section>
            <ea:XmlDataLabel runat="server" ElementName="P_137" DataMember="E7.Razem" XSDType="TKwota2" />
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_138" DataMember="E8Podstawa" XSDType="TCalkowity" />
        <ea:Section runat="server" ID="SectionPodstawa19">
            <ea:XmlDataLabel runat="server" ElementName="P_139" DataMember="E8Podstawa19" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_142_1" DataMember="F.Stawka19" XSDType="TWybor1"/>
        </ea:Section>
        <ea:Section runat="server" ID="SectionPodstawa9">
            <ea:XmlDataLabel runat="server" ElementName="P_140" DataMember="E8Podstawa9" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_142_2" DataMember="F.Stawka9" XSDType="TWybor1"/>
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_141" HideEmptyOrZero="true" DataMember="E8.Strata" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_143" HideEmptyOrZero="true" DataMember="F.Nalezny19" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_144" HideEmptyOrZero="true" DataMember="F.Nalezny9" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_145" DataMember="F.Nalezny" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_146" HideEmptyOrZero="true" DataMember="F.Odliczenia" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_147" DataMember="F.NaleznyPoOdliczeniach" XSDType="TCalkowity" />
        <ea:Section runat="server" ID="Sec148_149">
            <ea:XmlDataLabel runat="server" ElementName="P_148" DataMember="F.Nalezny20Rok" />
            <ea:XmlDataLabel runat="server" ElementName="P_149" DataMember="F.Nalezny20" XSDType="TCalkowity" />
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_150" HideEmptyOrZero="true" DataMember="G.1" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_156" HideEmptyOrZero="true" DataMember="G.NP1" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_162" HideEmptyOrZero="true" DataMember="G.ZP1" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_168" HideEmptyOrZero="true" DataMember="G.ZZ1" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_151" HideEmptyOrZero="true" DataMember="G.2" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_157" HideEmptyOrZero="true" DataMember="G.NP2" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_163" HideEmptyOrZero="true" DataMember="G.ZP2" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_169" HideEmptyOrZero="true" DataMember="G.ZZ2" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_152" HideEmptyOrZero="true" DataMember="G.3" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_158" HideEmptyOrZero="true" DataMember="G.NP3" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_164" HideEmptyOrZero="true" DataMember="G.ZP3" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_170" HideEmptyOrZero="true" DataMember="G.ZZ3" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_153" HideEmptyOrZero="true" DataMember="G.4" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_159" HideEmptyOrZero="true" DataMember="G.NP4" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_165" HideEmptyOrZero="true" DataMember="G.ZP4" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_171" HideEmptyOrZero="true" DataMember="G.ZZ4" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_154" HideEmptyOrZero="true" DataMember="G.5" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_160" HideEmptyOrZero="true" DataMember="G.NP5" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_166" HideEmptyOrZero="true" DataMember="G.ZP5" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_172" HideEmptyOrZero="true" DataMember="G.ZZ5" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_155" HideEmptyOrZero="true" DataMember="G.6" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_161" HideEmptyOrZero="true" DataMember="G.NP6" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_167" HideEmptyOrZero="true" DataMember="G.ZP6" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_173" HideEmptyOrZero="true" DataMember="G.ZZ6" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_174" HideEmptyOrZero="true" DataMember="G.7" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_180" HideEmptyOrZero="true" DataMember="G.NP7" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_186" HideEmptyOrZero="true" DataMember="G.ZP7" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_192" HideEmptyOrZero="true" DataMember="G.ZZ7" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_175" HideEmptyOrZero="true" DataMember="G.8" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_181" HideEmptyOrZero="true" DataMember="G.NP8" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_187" HideEmptyOrZero="true" DataMember="G.ZP8" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_193" HideEmptyOrZero="true" DataMember="G.ZZ8" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_176" HideEmptyOrZero="true" DataMember="G.9" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_182" HideEmptyOrZero="true" DataMember="G.NP9" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_188" HideEmptyOrZero="true" DataMember="G.ZP9" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_194" HideEmptyOrZero="true" DataMember="G.ZZ9" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_177" HideEmptyOrZero="true" DataMember="G.10" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_183" HideEmptyOrZero="true" DataMember="G.NP10" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_189" HideEmptyOrZero="true" DataMember="G.ZP10" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_195" HideEmptyOrZero="true" DataMember="G.ZZ10" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_178" HideEmptyOrZero="true" DataMember="G.11" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_184" HideEmptyOrZero="true" DataMember="G.NP11" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_190" HideEmptyOrZero="true" DataMember="G.ZP11" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_196" HideEmptyOrZero="true" DataMember="G.ZZ11" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_179" HideEmptyOrZero="true" DataMember="G.12" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_185" HideEmptyOrZero="true" DataMember="G.NP12" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_191" HideEmptyOrZero="true" DataMember="G.ZP12" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_197" HideEmptyOrZero="true" DataMember="G.ZZ12" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_198" HideEmptyOrZero="true" DataMember="G.13" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_204" HideEmptyOrZero="true" DataMember="G.NP13" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_210" HideEmptyOrZero="true" DataMember="G.ZP13" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_216" HideEmptyOrZero="true" DataMember="G.ZZ13" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_199" HideEmptyOrZero="true" DataMember="G.14" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_205" HideEmptyOrZero="true" DataMember="G.NP14" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_211" HideEmptyOrZero="true" DataMember="G.ZP14" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_217" HideEmptyOrZero="true" DataMember="G.ZZ14" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_200" HideEmptyOrZero="true" DataMember="G.15" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_206" HideEmptyOrZero="true" DataMember="G.NP15" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_212" HideEmptyOrZero="true" DataMember="G.ZP15" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_218" HideEmptyOrZero="true" DataMember="G.ZZ15" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_201" HideEmptyOrZero="true" DataMember="G.16" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_207" HideEmptyOrZero="true" DataMember="G.NP16" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_213" HideEmptyOrZero="true" DataMember="G.ZP16" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_219" HideEmptyOrZero="true" DataMember="G.ZZ16" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_202" HideEmptyOrZero="true" DataMember="G.17" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_208" HideEmptyOrZero="true" DataMember="G.NP17" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_214" HideEmptyOrZero="true" DataMember="G.ZP17" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_220" HideEmptyOrZero="true" DataMember="G.ZZ17" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_203" HideEmptyOrZero="true" DataMember="G.18" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_209" HideEmptyOrZero="true" DataMember="G.NP18" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_215" HideEmptyOrZero="true" DataMember="G.ZP18" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_221" HideEmptyOrZero="true" DataMember="G.ZZ18" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_222" HideEmptyOrZero="true" DataMember="G.19" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_228" HideEmptyOrZero="true" DataMember="G.NP19" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_234" HideEmptyOrZero="true" DataMember="G.ZP19" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_240" HideEmptyOrZero="true" DataMember="G.ZZ19" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_223" HideEmptyOrZero="true" DataMember="G.20" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_229" HideEmptyOrZero="true" DataMember="G.NP20" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_235" HideEmptyOrZero="true" DataMember="G.ZP20" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_241" HideEmptyOrZero="true" DataMember="G.ZZ20" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_224" HideEmptyOrZero="true" DataMember="G.21" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_230" HideEmptyOrZero="true" DataMember="G.NP21" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_236" HideEmptyOrZero="true" DataMember="G.ZP21" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_242" HideEmptyOrZero="true" DataMember="G.ZZ21" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_225" HideEmptyOrZero="true" DataMember="G.22" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_231" HideEmptyOrZero="true" DataMember="G.NP22" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_237" HideEmptyOrZero="true" DataMember="G.ZP22" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_243" HideEmptyOrZero="true" DataMember="G.ZZ22" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_226" HideEmptyOrZero="true" DataMember="G.23" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_232" HideEmptyOrZero="true" DataMember="G.NP23" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_238" HideEmptyOrZero="true" DataMember="G.ZP23" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_244" HideEmptyOrZero="true" DataMember="G.ZZ23" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_227" HideEmptyOrZero="true" DataMember="G.Razem" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_233" HideEmptyOrZero="true" DataMember="G.NPRazem" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_239" HideEmptyOrZero="true" DataMember="G.ZPRazem" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_245" HideEmptyOrZero="true" DataMember="G.ZZRazem" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ID="P246" ElementName="P_246" DataMember="H.Niedoplata" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ID="P247" ElementName="P_247" DataMember="H.Nadplata" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_248" HideEmptyOrZero="true" DataMember="I.RoznicaMiedzyPodatkiem" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_249" HideEmptyOrZero="true" DataMember="I.SumaWplat" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_250" HideEmptyOrZero="true" DataMember="I.SumaWplatCIT8S" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_251" HideEmptyOrZero="true" DataMember="I.KorektaBR" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_252" HideEmptyOrZero="true" DataMember="I.ZwiekszenieUtrata" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_253" HideEmptyOrZero="true" DataMember="I.InneKwoty" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_254" HideEmptyOrZero="true" DataMember="PodatekCITIP" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_255" HideEmptyOrZero="true" DataMember="PodatekCITKW" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_256" HideEmptyOrZero="true" DataMember="I.SumaZaliczek" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_257" HideEmptyOrZero="true" DataMember="PodatekCITPD" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ElementName="P_258" HideEmptyOrZero="true" DataMember="PodatekCITM" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ID="P259" ElementName="P_259" DataMember="I.DoZaplaty" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" ID="P260" ElementName="P_260" DataMember="I.Nadplata" XSDType="TCalkowity" />

        <ea:Section runat="server" ID="SecD1_P1">
            <ea:XmlDataLabel runat="server" ElementName="P_261" DataMember="J.D1" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_267" DataMember="J.P1" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD2_P2">
            <ea:XmlDataLabel runat="server" ElementName="P_262" DataMember="J.D2" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_268" DataMember="J.P2" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD3_P3">
            <ea:XmlDataLabel runat="server" ElementName="P_263" DataMember="J.D3" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_269" DataMember="J.P3" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD4_P4">
            <ea:XmlDataLabel runat="server" ElementName="P_264" DataMember="J.D4" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_270" DataMember="J.P4" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD5_P5">
            <ea:XmlDataLabel runat="server" ElementName="P_265" DataMember="J.D5" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_271" DataMember="J.P5" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD6_P6">
            <ea:XmlDataLabel runat="server" ElementName="P_266" DataMember="J.D6" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_272" DataMember="J.P6" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD7_P7">
            <ea:XmlDataLabel runat="server" ElementName="P_273" DataMember="J.D7" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_279" DataMember="J.P7" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD8_P8">
            <ea:XmlDataLabel runat="server" ElementName="P_274" DataMember="J.D8" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_280" DataMember="J.P8" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD9_P9">
            <ea:XmlDataLabel runat="server" ElementName="P_275" DataMember="J.D9" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_281" DataMember="J.P9" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD10_P10">
            <ea:XmlDataLabel runat="server" ElementName="P_276" DataMember="J.D10" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_282" DataMember="J.P10" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD11_P11">
            <ea:XmlDataLabel runat="server" ElementName="P_277" DataMember="J.D11" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_283" DataMember="J.P11" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD12_P12">
            <ea:XmlDataLabel runat="server" ElementName="P_278" DataMember="J.D12" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_284" DataMember="J.P12" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD13_P13">
            <ea:XmlDataLabel runat="server" ElementName="P_285" DataMember="J.D13" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_291" DataMember="J.P13" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD14_P14">
            <ea:XmlDataLabel runat="server" ElementName="P_286" DataMember="J.D14" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_292" DataMember="J.P14" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD15_P15">
            <ea:XmlDataLabel runat="server" ElementName="P_287" DataMember="J.D15" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_293" DataMember="J.P15" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD16_P16">
            <ea:XmlDataLabel runat="server" ElementName="P_288" DataMember="J.D16" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_294" DataMember="J.P16" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD17_P17">
            <ea:XmlDataLabel runat="server" ElementName="P_289" DataMember="J.D17" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_295" DataMember="J.P17" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD18_P18">
            <ea:XmlDataLabel runat="server" ElementName="P_290" DataMember="J.D18" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_296" DataMember="J.P18" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD19_P19">
            <ea:XmlDataLabel runat="server" ElementName="P_297" DataMember="J.D19" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_302" DataMember="J.P19" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD20_P20">
            <ea:XmlDataLabel runat="server" ElementName="P_298" DataMember="J.D20" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_303" DataMember="J.P20" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD21_P21">
            <ea:XmlDataLabel runat="server" ElementName="P_299" DataMember="J.D21" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_304" DataMember="J.P21" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD22_P22">
            <ea:XmlDataLabel runat="server" ElementName="P_300" DataMember="J.D22" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_305" DataMember="J.P22" XSDType="TCalkowity" />
        </ea:Section>
        <ea:Section runat="server" ID="SecD23_P23">
            <ea:XmlDataLabel runat="server" ElementName="P_301" DataMember="J.D23" XSDType="TCalkowity" />
            <ea:XmlDataLabel runat="server" ElementName="P_306" DataMember="J.P23" XSDType="TCalkowity" />
        </ea:Section>

        <ea:Section runat="server" ID="Sec307_308">
            <ea:XmlDataLabel runat="server" ElementName="P_307" DataMember="K.Dochody" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_308" DataMember="K.Nalezny" XSDType="TCalkowity" />
        </ea:Section>
        <ea:XmlDataLabel runat="server" HideEmptyOrZero="true" ElementName="P_309" DataMember="K.KwotaNaliczona" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" HideEmptyOrZero="true" ElementName="P_310" DataMember="K.Odsetki" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" HideEmptyOrZero="true" ElementName="P_311" DataMember="K.OdsetkiArt7" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" HideEmptyOrZero="true" ElementName="P_312" DataMember="K.OdsetkiArt12" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" HideEmptyOrZero="true" ElementName="P_313" DataMember="K.NaleznyZPrzeksztalceniaCITKW" XSDType="TCalkowity" />
        <ea:XmlDataLabel runat="server" HideEmptyOrZero="true" ElementName="P_314" DataMember="K.NaleznyCITKW" XSDType="TCalkowity" />

        <ea:XmlDataLabel runat="server" ElementName="P_315" ID="P315" />
        <ea:XmlDataLabel runat="server" ElementName="P_316" ID="P316" />
        <ea:XmlDataLabel runat="server" ElementName="P_317" ID="P317" />
        <ea:XmlDataLabel runat="server" ElementName="P_318" ID="P318" />
        <ea:XmlDataLabel runat="server" ElementName="P_319" HideEmptyOrZero="true" DataMember="LKwotaOdpisu" XSDType="TKwota2" />
        <ea:XmlDataLabel runat="server" ElementName="P_320" ID="P320" />
        <ea:XmlDataLabel runat="server" ElementName="P_321" ID="P321" />

        <ea:XmlDataLabel runat="server" HideEmptyOrZero="true" ElementName="P_322" DataMember="L1.OkresyZawieszeniaPodatnik" XSDType="TZnakowy" />
        <ea:XmlDataLabel runat="server" HideEmptyOrZero="true" ElementName="P_323" DataMember="L1.OkresyZawieszeniaSpolka" XSDType="TTekstowy" />
        <ea:XmlDataLabel runat="server" HideEmptyOrZero="true" ElementName="P_324" DataMember="L2.InneInformacje" XSDType="TTekstowy" />
	</PozycjeSzczegolowe>
	<Pouczenia>1</Pouczenia>

    <ea:Section runat="server" ID="Zalaczniki">
        <Zalaczniki>

	    <ea:DataRepeater ID="CIT8O" runat="server" WithSections="False" OnBeforeRow="CIT8O_BeforeRow">
		<cz8o:Zalacznik_CIT-8_O>
			<cz8o:Naglowek>
				<cz8o:KodFormularza kodSystemowy="CIT8/O (18)" wersjaSchemy="1-0E">CIT-8/O</cz8o:KodFormularza>
				<cz8o:WariantFormularza>18</cz8o:WariantFormularza>
				<cz8o:OkresOd poz="P_4"><ea:XmlDataLabel ID="CIT8O_Od" XSDType="TData" runat="server" /></cz8o:OkresOd>
				<cz8o:OkresDo poz="P_5"><ea:XmlDataLabel ID="CIT8O_Do" XSDType="TData" runat="server" /></cz8o:OkresDo>
			</cz8o:Naglowek>
				<cz8o:PozycjeSzczegolowe>
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_7" HideEmptyOrZero="true" DataMember="B1.Wolne1" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_8" HideEmptyOrZero="true" DataMember="B1.Wolne1Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_9" HideEmptyOrZero="true" DataMember="B1.Wolne2" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_10" HideEmptyOrZero="true" DataMember="B1.Wolne2Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_11" HideEmptyOrZero="true" DataMember="B1.Wolne3" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_12" HideEmptyOrZero="true" DataMember="B1.Wolne3Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_13" HideEmptyOrZero="true" DataMember="B1.Wolne4" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_14" HideEmptyOrZero="true" DataMember="B1.Wolne4Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_15" HideEmptyOrZero="true" DataMember="B1.Wolne5" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_16" HideEmptyOrZero="true" DataMember="B1.Wolne5Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_17" HideEmptyOrZero="true" DataMember="B1.Wolne6" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_18" HideEmptyOrZero="true" DataMember="B1.Wolne6Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_19" HideEmptyOrZero="true" DataMember="B1.Wolne7" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_20" HideEmptyOrZero="true" DataMember="B1.Wolne7Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_21" HideEmptyOrZero="true" DataMember="B1.Wolne8" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_22" HideEmptyOrZero="true" DataMember="B1.Wolne8Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_23" HideEmptyOrZero="true" DataMember="B1.Wolne9" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_24" HideEmptyOrZero="true" DataMember="B1.Wolne9Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_25" HideEmptyOrZero="true" DataMember="B1.Wolne10" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_26" HideEmptyOrZero="true" DataMember="B1.Wolne10Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_27" HideEmptyOrZero="true" DataMember="B1.Wolne11" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_28" HideEmptyOrZero="true" DataMember="B1.Wolne11Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_29" HideEmptyOrZero="true" DataMember="B1.Wolne12" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_30" HideEmptyOrZero="true" DataMember="B1.Wolne12Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_31" HideEmptyOrZero="true" DataMember="B1.Wolne13" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_32" HideEmptyOrZero="true" DataMember="B1.Wolne13Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_33" HideEmptyOrZero="true" DataMember="B1.Wolne14" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_34" HideEmptyOrZero="true" DataMember="B1.Wolne14Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_35" HideEmptyOrZero="true" DataMember="B1.Wolne15" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_36" HideEmptyOrZero="true" DataMember="B1.Wolne15Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_37" HideEmptyOrZero="true" DataMember="B1.Wolne16" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_38" HideEmptyOrZero="true" DataMember="B1.Wolne16Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_39" HideEmptyOrZero="true" DataMember="B1.Wolne17" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_40" HideEmptyOrZero="true" DataMember="B1.Wolne17Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_41" HideEmptyOrZero="true" DataMember="B1.Wolne18" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_42" HideEmptyOrZero="true" DataMember="B1.Wolne18Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_43" HideEmptyOrZero="true" DataMember="B1.Wolne19" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_44" HideEmptyOrZero="true" DataMember="B1.Wolne19Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_45" HideEmptyOrZero="true" DataMember="B1.Wolne20" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_46" HideEmptyOrZero="true" DataMember="B1.Wolne20Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_47" HideEmptyOrZero="true" DataMember="B1.Wolne21" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_48" HideEmptyOrZero="true" DataMember="B1.Wolne21Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_49" HideEmptyOrZero="true" DataMember="B1.Wolne22" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_50" HideEmptyOrZero="true" DataMember="B1.Wolne22Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_51" HideEmptyOrZero="true" DataMember="B1.Wolne23" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_52" HideEmptyOrZero="true" DataMember="B1.Wolne23Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_53" HideEmptyOrZero="true" DataMember="B1.Wolne24" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_54" HideEmptyOrZero="true" DataMember="B1.Wolne24Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_55" HideEmptyOrZero="true" DataMember="B1.Wolne25" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_56" HideEmptyOrZero="true" DataMember="B1.Wolne25Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_57" HideEmptyOrZero="true" DataMember="B1.Wolne26" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_58" HideEmptyOrZero="true" DataMember="B1.Wolne26Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_59" HideEmptyOrZero="true" DataMember="B1.Wolne27" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_60" HideEmptyOrZero="true" DataMember="B1.Wolne27Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_61" HideEmptyOrZero="true" DataMember="B1.WolneDochodyZarzadzajacego" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_62" HideEmptyOrZero="true" DataMember="B1.WolneDochodyZarzadzajacegoIz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_63" HideEmptyOrZero="true" DataMember="B1.Wolne28" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_64" HideEmptyOrZero="true" DataMember="B1.Wolne28Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_65" HideEmptyOrZero="true" DataMember="B1.Wolne29" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_66" HideEmptyOrZero="true" DataMember="B1.Wolne29Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_67" HideEmptyOrZero="true" DataMember="B1.Wolne30" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_68" HideEmptyOrZero="true" DataMember="B1.Wolne30Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_69" HideEmptyOrZero="true" DataMember="B1.Wolne31" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_70" HideEmptyOrZero="true" DataMember="B1.Wolne31Iz" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_71" HideEmptyOrZero="true" DataMember="B1.Wolne32" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_72" HideEmptyOrZero="true" DataMember="B1.Wolne32Iz" XSDType="TKwota2" />

                    <ea:Section runat="server" ID="SecInneDochody">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_73" DataMember="B1.InneTytul" XSDType="TZnakowy" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_74" HideEmptyOrZero="true" DataMember="B1.Inne" XSDType="TKwota2" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_75" HideEmptyOrZero="true" DataMember="B1.InneIz" XSDType="TKwota2" />
                    </ea:Section>
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_76" HideEmptyOrZero="true" DataMember="B1.Razem" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_77" HideEmptyOrZero="true" DataMember="B1.RazemIz" XSDType="TKwota2" />

                    <ea:Section runat="server" ID="B21Rok1">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_78" DataMember="B21.Rok1" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_79" DataMember="B21.Kwota1" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_80" HideEmptyOrZero="true" DataMember="B21.Odliczona1" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_81" DataMember="B21.DoOdliczenia1" XSDType="TKwota2" />
                    </ea:Section>
					<ea:Section runat="server" ID="B21Rok2">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_82" DataMember="B21.Rok2" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_83" DataMember="B21.Kwota2" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_84" HideEmptyOrZero="true" DataMember="B21.Odliczona2" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_85" DataMember="B21.DoOdliczenia2" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B21Rok3">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_86" DataMember="B21.Rok3" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_87" DataMember="B21.Kwota3" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_88" HideEmptyOrZero="true" DataMember="B21.Odliczona3" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_89" DataMember="B21.DoOdliczenia3" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B21Rok4">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_90" DataMember="B21.Rok4" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_91" DataMember="B21.Kwota4" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_92" HideEmptyOrZero="true" DataMember="B21.Odliczona4" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_93" DataMember="B21.DoOdliczenia4" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B21Rok5">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_94" DataMember="B21.Rok5" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_95" DataMember="B21.Kwota5" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_96" HideEmptyOrZero="true" DataMember="B21.Odliczona5" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_97" DataMember="B21.DoOdliczenia5" XSDType="TKwota2" />
					</ea:Section>

                    <ea:Section runat="server" ID="B21Strata">
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_98" DataMember="B21.Razem" XSDType="TKwota2" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_98A" HideEmptyOrZero="true" DataMember="B21.WartoscStrat" XSDType="TKwota2" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_98B" HideEmptyOrZero="true" DataMember="B21.WartoscStratIz" XSDType="TKwota2" />
                    </ea:Section>

                    <ea:Section runat="server" ID="B22Rok1">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_99" DataMember="B22.Rok1" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_100" DataMember="B22.Kwota1" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_101" HideEmptyOrZero="true" DataMember="B22.Odliczona1" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_102" DataMember="B22.DoOdliczenia1" XSDType="TKwota2" />
                    </ea:Section>
					<ea:Section runat="server" ID="B22Rok2">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_103" DataMember="B22.Rok2" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_104" DataMember="B22.Kwota2" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_105" HideEmptyOrZero="true" DataMember="B22.Odliczona2" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_106" DataMember="B22.DoOdliczenia2" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B22Rok3">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_107" DataMember="B22.Rok3" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_108" DataMember="B22.Kwota3" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_109" HideEmptyOrZero="true" DataMember="B22.Odliczona3" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_110" DataMember="B22.DoOdliczenia3" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B22Rok4">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_111" DataMember="B22.Rok4" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_112" DataMember="B22.Kwota4" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_113" HideEmptyOrZero="true" DataMember="B22.Odliczona4" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_114" DataMember="B22.DoOdliczenia4" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B22Rok5">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_115" DataMember="B22.Rok5" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_116" DataMember="B22.Kwota5" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_117" HideEmptyOrZero="true" DataMember="B22.Odliczona5" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_118" DataMember="B22.DoOdliczenia5" XSDType="TKwota2" />
					</ea:Section>

                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_119" HideEmptyOrZero="true" DataMember="B22.Razem" XSDType="TKwota2" />

                    <ea:Section runat="server" ID="B23Rok1">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_120" DataMember="B23.Rok1" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_121" DataMember="B23.Kwota1" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_122" HideEmptyOrZero="true" DataMember="B23.Odliczona1" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_123" DataMember="B23.DoOdliczenia1" XSDType="TKwota2" />
                    </ea:Section>
					<ea:Section runat="server" ID="B23Rok2">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_124" DataMember="B23.Rok2" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_125" DataMember="B23.Kwota2" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_126" HideEmptyOrZero="true" DataMember="B23.Odliczona2" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_127" DataMember="B23.DoOdliczenia2" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B23Rok3">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_128" DataMember="B23.Rok3" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_129" DataMember="B23.Kwota3" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_130" HideEmptyOrZero="true" DataMember="B23.Odliczona3" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_131" DataMember="B23.DoOdliczenia3" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B23Rok4">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_132" DataMember="B23.Rok4" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_133" DataMember="B23.Kwota4" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_134" HideEmptyOrZero="true" DataMember="B23.Odliczona4" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_135" DataMember="B23.DoOdliczenia4" XSDType="TKwota2" />
					</ea:Section>
					<ea:Section runat="server" ID="B23Rok5">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_136" DataMember="B23.Rok5" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_137" DataMember="B23.Kwota5" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_138" HideEmptyOrZero="true" DataMember="B23.Odliczona5" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_139" DataMember="B23.DoOdliczenia5" XSDType="TKwota2" />
					</ea:Section>

					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_140" HideEmptyOrZero="true" DataMember="B23.Razem" XSDType="TKwota2" />

                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_141" HideEmptyOrZero="true" DataMember="B3.Darowizny" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_142" HideEmptyOrZero="true" DataMember="B3.DarowiznyIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_143" HideEmptyOrZero="true" DataMember="B3.DarowiznyReligijne" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_144" HideEmptyOrZero="true" DataMember="B3.DarowiznyReligijneIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_145" HideEmptyOrZero="true" DataMember="B3.DarowiznyKsztalcenie" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_146" HideEmptyOrZero="true" DataMember="B3.DarowiznyKsztalcenieIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_147" HideEmptyOrZero="true" DataMember="B3.DarowiznyOdrebne" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_148" HideEmptyOrZero="true" DataMember="B3.DarowiznyOdrebneIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_149" HideEmptyOrZero="true" DataMember="B3.RazemDarowizny" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_150" HideEmptyOrZero="true" DataMember="B3.RazemDarowiznyIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_151" HideEmptyOrZero="true" DataMember="B3.Odliczenia" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_152" HideEmptyOrZero="true" DataMember="B3.OdliczeniaIz" XSDType="TKwota2" />

                    <ea:Section runat="server" ID="SecInneOdliczenia">
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_153" DataMember="B3.InneTytul" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_154" HideEmptyOrZero="true" DataMember="B3.Inne" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8o:P_155" HideEmptyOrZero="true" DataMember="B3.InneIz" XSDType="TKwota2" />
                    </ea:Section>

					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_156" DataMember="B3.Razem" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_157" DataMember="B3.RazemIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_158" DataMember="B4.Razem" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_159" DataMember="B4.RazemIz" XSDType="TKwota2" />

					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_160" HideEmptyOrZero="true" DataMember="C.Wydatki1" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_161" HideEmptyOrZero="true" DataMember="C.Wydatki1Iz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_162" HideEmptyOrZero="true" DataMember="C.Obnizka" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_163" HideEmptyOrZero="true" DataMember="C.ObnizkaIz" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_164" DataMember="C.Razem" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_165" DataMember="C.RazemIz" XSDType="TKwota2" />

					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_166" HideEmptyOrZero="true" DataMember="D.NowaTechnologia" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_167" HideEmptyOrZero="true" DataMember="D.OdliczenieProdukcja" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_168" HideEmptyOrZero="true" DataMember="D.OdliczenieUzyskaniePrzychodu" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_169" HideEmptyOrZero="true" DataMember="D.OdliczenieUdzialy" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_170" HideEmptyOrZero="true" DataMember="D.OdliczenieOfertaPubliczna" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_171" HideEmptyOrZero="true" DataMember="D.OdliczenieDzialalnosc" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_172" HideEmptyOrZero="true" DataMember="D.OdliczenieTerminal" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_173" HideEmptyOrZero="true" DataMember="D.OdliczenieRobotyzacja" XSDType="TKwota2" />

					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_174" HideEmptyOrZero="true" DataMember="E.Odliczenia1" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_175" HideEmptyOrZero="true" DataMember="E.Odliczenia2" XSDType="TKwota2" />

					<ea:Section runat="server" ID="SecZwolnienie">
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_176" DataMember="E.ZwolnienieDecyzja" XSDType="TZnakowy" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_177" DataMember="E.Zwolnienie" XSDType="TKwota2" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_178" DataMember="E.ZwolnienieDataDecyzji" XSDType="TData" />
					</ea:Section>
					<ea:Section runat="server" ID="SecZaniechanie">
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_179" DataMember="E.ZaniechanieDataRozporzadzenia" XSDType="TData" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_180" DataMember="E.Zaniechanie" XSDType="TKwota2" />
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_181" DataMember="E.ZaniechanieRozporzadzenie" XSDType="TZnakowy" />
					</ea:Section>
					<ea:Section runat="server" ID="SecObnizki">
					    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_182" DataMember="E.InneTytul" XSDType="TZnakowy" />
				    	<ea:XmlDataLabel runat="server" ElementName="cz8o:P_183" DataMember="E.Inne" XSDType="TKwota2" />
                    </ea:Section>

                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_184" HideEmptyOrZero="true" DataMember="E.InneUst10C" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8o:P_185" HideEmptyOrZero="true" DataMember="E.InneUst13" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_186" DataMember="E.Razem" XSDType="TKwota2" />

					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_187" HideEmptyOrZero="true" DataMember="F1.Dochody1" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_188" HideEmptyOrZero="true" DataMember="F1.Dochody2" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_189" HideEmptyOrZero="true" DataMember="F1.Dochody3" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_190" HideEmptyOrZero="true" DataMember="F1.PobranyPodatek" XSDType="TCalkowity" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_191" HideEmptyOrZero="true" DataMember="F1.WplaconyPodatek" XSDType="TCalkowity" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_192" HideEmptyOrZero="true" DataMember="F2.SumaDochodow" XSDType="TKwota2" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_193" HideEmptyOrZero="true" DataMember="F3.Kwoty" XSDType="TCalkowity" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_194" HideEmptyOrZero="true" DataMember="F3.Podatek" XSDType="TCalkowity" />
					<ea:XmlDataLabel runat="server" ElementName="cz8o:P_195" HideEmptyOrZero="true" DataMember="F4.Przychody" XSDType="TCalkowity" />
				</cz8o:PozycjeSzczegolowe>
		    </cz8o:Zalacznik_CIT-8_O>
	    </ea:DataRepeater>

        
        <ea:DataRepeater ID="CITKW" runat="server" WithSections="False" OnBeforeRow="CITKW_BeforeRow">
		    <czkw:Zalacznik_CIT_KW>
		        <czkw:Naglowek>
		            <czkw:KodFormularza kodSystemowy="CIT/KW (3)" wersjaSchemy="1-0E">CIT/KW</czkw:KodFormularza>
                    <czkw:WariantFormularza>3</czkw:WariantFormularza>
                    <czkw:OkresOd poz="P_4"><ea:XmlDataLabel ID="CITKW_Od" XSDType="TData" runat="server" /></czkw:OkresOd>
                    <czkw:OkresDo poz="P_5"><ea:XmlDataLabel ID="CITKW_Do" XSDType="TData" runat="server" /></czkw:OkresDo>
		        </czkw:Naglowek>
                <czkw:PozycjeSzczegolowe>
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_16" ID="KW_P16" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_17" ID="KW_P17" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_18" ID="KW_P18" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_19" ID="KW_P19" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_20" DataMember="B1.NazwiskoImieOsobyFizycznej" HideEmptyOrZero="true" XSDType="TZnakowy" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_21" DataMember="B1.NIPLubPESEL" HideEmptyOrZero="true" XSDType="TZnakowy" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_22" DataMember="B2.NazwaSp" HideEmptyOrZero="true" XSDType="TZnakowy" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_23" DataMember="B2.NIPSp" HideEmptyOrZero="true" XSDType="TZnakowy" />
                      <ea:DataRepeater ID="CITKW_P_B" runat="server" WithSections="False">
                      <czkw:P_B typ="G" >
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_B24" DataMember="NazwaWspolnika" HideEmptyOrZero="true" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_B25" DataMember="NIP_PESEL_Wspolnika" HideEmptyOrZero="true" XSDType="TZnakowy" />
                      </czkw:P_B>
                      </ea:DataRepeater>
                   <ea:Section runat="server" ID="KW_P2628">
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_26" ID="KW_P26" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_27" DataMember="B3.NazwaSpolki"  XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_28" DataMember="B3.NIP" XSDType="TZnakowy" />
                    </ea:Section>
                    <ea:section runat="server" ID="KW_C">
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_29" DataMember="C1.PrzychodyKapitalowe" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_31" DataMember="C1.KosztyKapitalowe" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_33" DataMember="RazemPrzychodyKapitalowe" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_30" DataMember="C1.PrzychodyInne" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_32" DataMember="C1.KosztyInne" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_34" DataMember="RazemPrzychodyInne" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_35" DataMember="C2.PrzychodyKapitalowe" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_37" DataMember="C2.KosztyKapitalowe" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_39" DataMember="RazemKosztyKapitalowe" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_36" DataMember="C2.PrzychodyInne" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_38" DataMember="C2.KosztyInne" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_40" DataMember="RazemKosztyInne" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_41" DataMember="UstalenieDochoduKapitalowe" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_42" DataMember="UstalenieDochoduInne" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_43" DataMember="C3_PodatekNalezny" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_44" DataMember="C4_UstalenieDochodu" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_45" DataMember="C4_PodatekNalezny" XSDType="TCalkowity" />
                    </ea:section>
                    <ea:section runat="server" ID="KW_D">
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_46" DataMember="D1.Przychody" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_47" DataMember="D1.Koszty" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_48"  DataMember="D1_RazemPrzychody" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_49" DataMember="D2.Przychody" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_50" DataMember="D2.Koszty" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_51" DataMember="D2_RazemKosztyUzyskaniaPrzychodow" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_52" DataMember="D3_UstalenieDochodu" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_53" DataMember="D3_PodatekNalezny" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_54" DataMember="D4_UstalenieDochodu" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czkw:P_55" DataMember="D4_PodatekNalezny" XSDType="TCalkowity" />
                    </ea:section>
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_62" DataMember="F1.PodatekNalezny" XSDType="TCalkowity" />
                    <ea:DataRepeater ID="CITKW_P_F" runat="server" WithSections="False">
                        <czkw:P_F typ="G" >
                            <ea:XmlDataLabel runat="server" ElementName="czkw:P_F63" DataMember="PodatekNalezny" XSDType="TCalkowity"/>
                            <ea:XmlDataLabel runat="server" ElementName="czkw:P_F64" DataMember="Data" XSDType="TData" />
                        </czkw:P_F>
                    </ea:DataRepeater>
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_56" DataMember="E1.StrataNieOdliczona" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_57" DataMember="E1.StrataDoOdliczeniaWRokuBiezacym" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_58" DataMember="E1.StrataDoOdliczeniaWRokuPoprzednim" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_59" DataMember="E2.StrataNieOdliczona" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_60" DataMember="E2.StrataDoOdliczeniaWRokuBiezacym" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_61" DataMember="E2.StrataDoOdliczeniaWRokuPoprzednim" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czkw:P_65" DataMember="G.UwagiWyjasnienia" HideEmptyOrZero="true" XSDType="TTekstowy" />
                </czkw:PozycjeSzczegolowe>
            </czkw:Zalacznik_CIT_KW>
        </ea:DataRepeater>

       <ea:DataRepeater ID="CITBR" runat="server" WithSections="False" OnBeforeRow="CITBR_BeforeRow">
		    <czbr:Zalacznik_CIT_BR>
		        <czbr:Naglowek>
		            <czbr:KodFormularza kodSystemowy="CIT/BR (9)" wersjaSchemy="1-0E">CIT/BR</czbr:KodFormularza>
                    <czbr:WariantFormularza>9</czbr:WariantFormularza>
                    <czbr:OkresOd poz="P_4"><ea:XmlDataLabel ID="CITBR_Od" XSDType="TData" runat="server" /></czbr:OkresOd>
                    <czbr:OkresDo poz="P_5"><ea:XmlDataLabel ID="CITBR_Do" XSDType="TData" runat="server" /></czbr:OkresDo>
		        </czbr:Naglowek>
                <czbr:PozycjeSzczegolowe>
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_8" ID="StatusCentrum" />
                    <ea:Section runat="server" ID="SecStatusCentrum">
					    <ea:XmlDataLabel runat="server" ElementName="czbr:P_9" DataMember="A.StatusCentrumOd" XSDType="TData" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_10" DataMember="A.StatusCentrumDo" XSDType="TData" />
                    </ea:Section>
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_11" ID="Mikrofirma" />

				    <ea:XmlDataLabel runat="server" ElementName="czbr:P_12" HideEmptyOrZero="true" DataMember="B1.Poz12" XSDType="TKwota2" />
				    <ea:XmlDataLabel runat="server" ElementName="czbr:P_13" HideEmptyOrZero="true" DataMember="B1.Poz13" XSDType="TKwota2" />
				    <ea:XmlDataLabel runat="server" ElementName="czbr:P_14" HideEmptyOrZero="true" DataMember="B1.Poz14" XSDType="TKwota2" />
				    <ea:XmlDataLabel runat="server" ElementName="czbr:P_15" HideEmptyOrZero="true" DataMember="B1.Poz15" XSDType="TKwota2" />
				    <ea:XmlDataLabel runat="server" ElementName="czbr:P_16" HideEmptyOrZero="true" DataMember="B1.Poz16" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_17" HideEmptyOrZero="true" DataMember="B1.Poz17" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_18" HideEmptyOrZero="true" DataMember="B1.Poz18" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_19" HideEmptyOrZero="true" DataMember="B1.Poz19" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_20" HideEmptyOrZero="true" DataMember="B1.Poz20" XSDType="TKwota2" />
	                <ea:XmlDataLabel runat="server" ElementName="czbr:P_21" HideEmptyOrZero="true" DataMember="B1.Poz21" XSDType="TKwota2" />
	                <ea:XmlDataLabel runat="server" ElementName="czbr:P_22" HideEmptyOrZero="true" DataMember="B1.Poz22" XSDType="TKwota2" />
	                <ea:XmlDataLabel runat="server" ElementName="czbr:P_23" HideEmptyOrZero="true" DataMember="B1.Poz23" XSDType="TKwota2" />
	                <ea:XmlDataLabel runat="server" ElementName="czbr:P_24" HideEmptyOrZero="true" DataMember="B1.Poz24" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_25" HideEmptyOrZero="true" DataMember="B1.Poz25" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_26" HideEmptyOrZero="true" DataMember="B1.Poz26" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_27" HideEmptyOrZero="true" DataMember="B1.Poz27" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_28" HideEmptyOrZero="true" DataMember="B1.Poz28" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_29" HideEmptyOrZero="true" DataMember="B1.Poz29" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_30" HideEmptyOrZero="true" DataMember="B1.Suma30" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_31" HideEmptyOrZero="true" DataMember="B1.Suma31" XSDType="TKwota2" />

                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_32" HideEmptyOrZero="true" DataMember="B2.Poz32" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_33" HideEmptyOrZero="true" DataMember="B2.Poz33" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_34" HideEmptyOrZero="true" DataMember="B2.Poz34" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_35" HideEmptyOrZero="true" DataMember="B2.Poz35" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_36" DataMember="B2.Suma36" XSDType="TKwota2" />

                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_37" HideEmptyOrZero="true" DataMember="B3.Suma37" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_38" HideEmptyOrZero="true" DataMember="B3.Suma38" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_39" HideEmptyOrZero="true" DataMember="B3.Poz39" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_40" HideEmptyOrZero="true" DataMember="B3.Poz40" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_41" DataMember="B3.Suma41" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_42" HideEmptyOrZero="true" DataMember="B3.Poz42" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_43" HideEmptyOrZero="true" DataMember="B3.Poz43" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_44" DataMember="B3.Poz44" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_45" HideEmptyOrZero="true" DataMember="B3.Poz45" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_46" HideEmptyOrZero="true" DataMember="B3.Poz46" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_47" HideEmptyOrZero="true" DataMember="B3.Poz47" XSDType="TKwota2" />

                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_48" HideEmptyOrZero="true" DataMember="C1.PraceRozwojowe" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_49" HideEmptyOrZero="true" DataMember="C1.BadaniaPodstawowe" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_50" HideEmptyOrZero="true" DataMember="C1.BadaniaAplikacyjne" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_51" HideEmptyOrZero="true" DataMember="C1.PatentyOrazWzory" XSDType="TKwota2" />


                    <ea:Section runat="server" ID="D_DaneSpolki">
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_52" DataMember="D1.Nazwa" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_53" DataMember="D1.NIP" XSDType="TNrNIP" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_54" ID="SpolkaMikrofirma" />

                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_55" HideEmptyOrZero="true" DataMember="D11.PraceRozwojowe" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_56" HideEmptyOrZero="true" DataMember="D11.BadaniaPodstawowe" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_57" HideEmptyOrZero="true" DataMember="D11.BadaniaAplikacyjne" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_58" HideEmptyOrZero="true" DataMember="D11.PatentyOrazWzory" XSDType="TKwota2" />
                    </ea:Section>
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_59" ID="BadaniaNaukowe" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_60" ID="PraceRozwojowe" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_61_1" HideEmptyOrZero="true" ID="BadaniaPodstawowe" />
                    <ea:XmlDataLabel runat="server" ElementName="czbr:P_61_2" HideEmptyOrZero="true" ID="BadaniaAplikacyjne" />

                    <ea:DataRepeater ID="CITBR_P_F" runat="server" WithSections="False">
                    <czbr:P_F typ="G">
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_F62" DataMember="Nazwa" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_F63A" DataMember="KodKraju" XSDType="TJednAdmin" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_F64" HideEmptyOrZero="true" DataMember="Wojewodztwo" XSDType="TJednAdmin" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_F65" HideEmptyOrZero="true" DataMember="Powiat" XSDType="TJednAdmin" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_F66" HideEmptyOrZero="true" DataMember="Gmina" XSDType="TJednAdmin" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_F67" HideEmptyOrZero="true" DataMember="Ulica" XSDType="TUlica" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_F68" HideEmptyOrZero="true" DataMember="NrDomu" XSDType="TNrBudynku" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_F69" HideEmptyOrZero="true" DataMember="NrLokalu" XSDType="TNrLokalu" />
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_F70" HideEmptyOrZero="true" DataMember="Miejscowosc" XSDType="TMiejscowosc"/>
                        <ea:XmlDataLabel runat="server" ElementName="czbr:P_F71" HideEmptyOrZero="true" DataMember="KodPocztowy" XSDType="TKodPocztowy" />
                    </czbr:P_F>
                    </ea:DataRepeater>
                </czbr:PozycjeSzczegolowe>
            </czbr:Zalacznik_CIT_BR>
        </ea:DataRepeater>

       <ea:DataRepeater ID="CITD_Repeater" runat="server" WithSections="False" OnBeforeRow="CITD_BeforeRow">
            <czd:Zalacznik_CIT-D>
                <czd:Naglowek>
                    <czd:KodFormularza kodSystemowy="CIT-D (7)" wersjaSchemy="5-0E">CIT-D</czd:KodFormularza>
                    <czd:WariantFormularza>7</czd:WariantFormularza>
                    <czd:OkresOd poz="P_4"><ea:XmlDataLabel ID="CITD_Od" XSDType="TData" runat="server" /></czd:OkresOd>
                    <czd:OkresDo poz="P_5"><ea:XmlDataLabel ID="CITD_Do" XSDType="TData" runat="server" /></czd:OkresDo>
                </czd:Naglowek>
                <czd:PozycjeSzczegolowe>
                    <ea:XmlDataLabel ElementName="czd:P_6" runat="server" DataMember="NrFormularza" XSDType="TCalkowity"/>
                    <czd:P_8>2</czd:P_8>
                    <ea:XmlDataLabel ID="CITD_RodzajPodatnika" ElementName="czd:P_10" runat="server" XSDType="TCalkowity"/>

                    <ea:XmlDataLabel ElementName="czd:P_21" runat="server" DataMember="C.Ogolem" XSDType="TKwota2" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_22" runat="server" DataMember="C.Osoba1" XSDType="TKwota2" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_23" runat="server" DataMember="C.Osoba2" XSDType="TKwota2" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_24" runat="server" DataMember="C.Osoba3" XSDType="TKwota2" HideEmptyOrZero="True"/>

                    <ea:Section ID="CITD_DaneDarczyncy1" runat="server">
                        <ea:XmlDataLabel ElementName="czd:P_25" runat="server" DataMember="C11.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                        <ea:XmlDataLabel ElementName="czd:P_26A" runat="server" ID="CITDC12KodKraju" XSDType="TJednAdmin"/>
                        <ea:XmlDataLabel ElementName="czd:P_27" runat="server" DataMember="C12.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_28" runat="server" DataMember="C12.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_29" runat="server" DataMember="C12.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_30" runat="server" DataMember="C12.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_31" runat="server" DataMember="C12.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_32" runat="server" DataMember="C12.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_33" runat="server" DataMember="C12.Miejsc" XSDType="TMiejscowosc"/>
                        <ea:XmlDataLabel ElementName="czd:P_34" runat="server" DataMember="C12.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    </ea:Section>

                    <ea:Section ID="CITD_DaneDarczyncy2" runat="server">
                        <ea:XmlDataLabel ElementName="czd:P_35" runat="server" DataMember="C21.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                        <ea:XmlDataLabel ElementName="czd:P_36A" runat="server" ID="CITDC22KodKraju" XSDType="TJednAdmin"/>
                        <ea:XmlDataLabel ElementName="czd:P_37" runat="server" DataMember="C22.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_38" runat="server" DataMember="C22.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_39" runat="server" DataMember="C22.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_40" runat="server" DataMember="C22.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_41" runat="server" DataMember="C22.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_42" runat="server" DataMember="C22.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_43" runat="server" DataMember="C22.Miejsc" XSDType="TMiejscowosc"/>
                        <ea:XmlDataLabel ElementName="czd:P_44" runat="server" DataMember="C22.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    </ea:Section>

                    <ea:Section ID="CITD_DaneDarczyncy3" runat="server">
                        <ea:XmlDataLabel ElementName="czd:P_45" runat="server" DataMember="C31.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                        <ea:XmlDataLabel ElementName="czd:P_46A" runat="server" ID="CITDC32KodKraju" XSDType="TJednAdmin"/>
                        <ea:XmlDataLabel ElementName="czd:P_47" runat="server" DataMember="C32.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_48" runat="server" DataMember="C32.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_49" runat="server" DataMember="C32.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_50" runat="server" DataMember="C32.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_51" runat="server" DataMember="C32.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_52" runat="server" DataMember="C32.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_53" runat="server" DataMember="C32.Miejsc" XSDType="TMiejscowosc"/>
                        <ea:XmlDataLabel ElementName="czd:P_54" runat="server" DataMember="C32.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    </ea:Section>

                    <ea:XmlDataLabel ElementName="czd:P_55" runat="server" DataMember="C4.DzialalnoscCharytatywna" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_56" runat="server" DataMember="C4.PomocOfiarom" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_57" runat="server" DataMember="C4.PomocSpoleczna" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_58" runat="server" DataMember="C4.KrajoznawstwoWypoczynek" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_59" runat="server" DataMember="C4.Nauka" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_60" runat="server" DataMember="C4.Niepelnosprawni" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_61" runat="server" DataMember="C4.Kultura" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_62" runat="server" DataMember="C4.Ekologia" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_63" runat="server" DataMember="C4.Zdrowie" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_64" runat="server" DataMember="C4.RozwojGospodarczy" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_65" runat="server" DataMember="C4.KulturaFizyczna" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_66" runat="server" DataMember="C4.Ratownictwo" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_67" runat="server" DataMember="C4.KultReligijny" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_68" runat="server" DataMember="C4.DzialalnoscCharytatywnoOpiekuncza" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_69" runat="server" DataMember="C4.Pozostale" XSDType="TWybor1" HideEmptyOrZero="True"/>
                    <ea:XmlDataLabel ElementName="czd:P_70" runat="server" DataMember="C5.DoPublicznejWiadomosci" XSDType="TWybor1" HideEmptyOrZero="True"/>

                    <ea:Section ID="CITD_Obdarowany1" runat="server">
                        <ea:XmlDataLabel ElementName="czd:P_71" runat="server" DataMember="D1.KwotaPrzekazana" XSDType="TKwota2" HideEmptyOrZero="True"/>
                        <ea:XmlDataLabel ElementName="czd:P_72" runat="server" DataMember="D1.KwotaOdliczona" XSDType="TKwota2" HideEmptyOrZero="True"/>

                        <ea:XmlDataLabel ElementName="czd:P_73" runat="server" DataMember="D11.Identyfikator" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                        <ea:XmlDataLabel ElementName="czd:P_74" runat="server" DataMember="D11.KodKraju" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                        <ea:XmlDataLabel ElementName="czd:P_75" runat="server" DataMember="D11.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>

                        <ea:XmlDataLabel ElementName="czd:P_76A" runat="server" ID="CITDD12KodKraju" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_77" runat="server" DataMember="D12.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_78" runat="server" DataMember="D12.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_79" runat="server" DataMember="D12.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_80" runat="server" DataMember="D12.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_81" runat="server" DataMember="D12.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_82" runat="server" DataMember="D12.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_83" runat="server" DataMember="D12.Miejsc" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_84" runat="server" DataMember="D12.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    </ea:Section>

                    <ea:Section ID="CITD_Obdarowany2" runat="server">
                        <ea:XmlDataLabel ElementName="czd:P_85" runat="server" DataMember="D2.KwotaPrzekazana" XSDType="TKwota2" HideEmptyOrZero="True"/>
                        <ea:XmlDataLabel ElementName="czd:P_86" runat="server" DataMember="D2.KwotaOdliczona" XSDType="TKwota2" HideEmptyOrZero="True"/>

                        <ea:XmlDataLabel ElementName="czd:P_87" runat="server" DataMember="D21.Identyfikator" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                        <ea:XmlDataLabel ElementName="czd:P_88" runat="server" DataMember="D21.KodKraju" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                        <ea:XmlDataLabel ElementName="czd:P_89" runat="server" DataMember="D21.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>

                        <ea:XmlDataLabel ElementName="czd:P_90A" runat="server" ID="CITDD22KodKraju" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_91" runat="server" DataMember="D22.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_92" runat="server" DataMember="D22.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_93" runat="server" DataMember="D22.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_94" runat="server" DataMember="D22.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_95" runat="server" DataMember="D22.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_96" runat="server" DataMember="D22.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_97" runat="server" DataMember="D22.Miejsc" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_98" runat="server" DataMember="D22.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    </ea:Section>

                    <ea:Section ID="CITD_Obdarowany3" runat="server">
                        <ea:XmlDataLabel ElementName="czd:P_99" runat="server" DataMember="D3.KwotaPrzekazana" XSDType="TKwota2" HideEmptyOrZero="True"/>
                        <ea:XmlDataLabel ElementName="czd:P_100" runat="server" DataMember="D3.KwotaOdliczona" XSDType="TKwota2" HideEmptyOrZero="True"/>

                        <ea:XmlDataLabel ElementName="czd:P_101" runat="server" DataMember="D31.Identyfikator" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                        <ea:XmlDataLabel ElementName="czd:P_102" runat="server" DataMember="D31.KodKraju" XSDType="TZnakowy" HideEmptyOrZero="True"/>
                        <ea:XmlDataLabel ElementName="czd:P_103" runat="server" DataMember="D31.NazwaPelna" XSDType="TZnakowy" HideEmptyOrZero="True"/>

                        <ea:XmlDataLabel ElementName="czd:P_104A" runat="server" ID="CITDD32KodKraju" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_105" runat="server" DataMember="D32.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_106" runat="server" DataMember="D32.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_107" runat="server" DataMember="D32.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_108" runat="server" DataMember="D32.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_109" runat="server" DataMember="D32.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_110" runat="server" DataMember="D32.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_111" runat="server" DataMember="D32.Miejsc" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
                        <ea:XmlDataLabel ElementName="czd:P_112" runat="server" DataMember="D32.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                    </ea:Section>
                </czd:PozycjeSzczegolowe>
            </czd:Zalacznik_CIT-D>
        </ea:DataRepeater>
            
        <ea:DataRepeater ID="CITMIT" runat="server" WithSections="False" OnBeforeRow="CITMIT_BeforeRow">
            <czmit:Zalacznik_CIT_MIT>
                <czmit:Naglowek>
                    <czmit:KodFormularza kodSystemowy="CITMIT (3)" wersjaSchemy="5-0E">CIT/MIT</czmit:KodFormularza>
                    <czmit:WariantFormularza>3</czmit:WariantFormularza>
                    <czmit:OkresOd poz="P_4"><ea:XmlDataLabel ID="CITMIT_Od" XSDType="TData" runat="server" /></czmit:OkresOd>
                    <czmit:OkresDo poz="P_5"><ea:XmlDataLabel ID="CITMIT_Do" XSDType="TData" runat="server" /></czmit:OkresDo>
                </czmit:Naglowek>
                <czmit:PozycjeSzczegolowe>
                    <ea:DataRepeater ID="CITMIT_P_B" runat="server" WithSections="False">
                        <czmit:P_B typ="G">
                            <ea:XmlDataLabel runat="server" ElementName="czmit:P_B8" DataMember="NazwaST" XSDType="TZnakowy" />
                            <ea:XmlDataLabel runat="server" ElementName="czmit:P_B9" DataMember="LiczbaST" XSDType="TKwota2" />
                        </czmit:P_B>
                    </ea:DataRepeater>
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_10" HideEmptyOrZero="true" DataMember="C.Podstawa1" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_11" HideEmptyOrZero="true" DataMember="C.Podstawa2" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_12" HideEmptyOrZero="true" DataMember="C.Podstawa3" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_13" HideEmptyOrZero="true" DataMember="C.Podstawa4" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_14" HideEmptyOrZero="true" DataMember="C.Podstawa5" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_15" HideEmptyOrZero="true" DataMember="C.Podstawa6" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_16" HideEmptyOrZero="true" DataMember="C.Podstawa7" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_17" HideEmptyOrZero="true" DataMember="C.Podstawa8" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_18" HideEmptyOrZero="true" DataMember="C.Podstawa9" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_19" HideEmptyOrZero="true" DataMember="C.Podstawa10" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_20" HideEmptyOrZero="true" DataMember="C.Podstawa11" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_21" HideEmptyOrZero="true" DataMember="C.Podstawa12" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_22" HideEmptyOrZero="true" DataMember="C.Podstawa13" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_23" HideEmptyOrZero="true" DataMember="C.Podstawa14" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_24" HideEmptyOrZero="true" DataMember="C.Podstawa15" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_25" HideEmptyOrZero="true" DataMember="C.Podstawa16" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_26" HideEmptyOrZero="true" DataMember="C.Podstawa17" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_27" HideEmptyOrZero="true" DataMember="C.Podstawa18" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_28" HideEmptyOrZero="true" DataMember="C.Podstawa19" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_29" HideEmptyOrZero="true" DataMember="C.Podstawa20" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_30" HideEmptyOrZero="true" DataMember="C.Podstawa21" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_31" HideEmptyOrZero="true" DataMember="C.Podstawa22" XSDType="TCalkowity" />
                        <ea:XmlDataLabel runat="server" ElementName="czmit:P_32" HideEmptyOrZero="true" DataMember="C.Podstawa23" XSDType="TCalkowity" />
                </czmit:PozycjeSzczegolowe>
            </czmit:Zalacznik_CIT_MIT>
        </ea:DataRepeater>

       <ea:DataRepeater ID="CIT8SP" runat="server" WithSections="False" OnBeforeRow="CIT8SP_BeforeRow">
            <cz8sp:Zalacznik_CIT_8SP>
                <cz8sp:Naglowek>
                    <cz8sp:KodFormularza kodSystemowy="CIT8SP (5)"  wersjaSchemy="4-0E">CIT/8SP</cz8sp:KodFormularza>
                    <cz8sp:WariantFormularza>5</cz8sp:WariantFormularza>
                    <cz8sp:OkresOd poz="P_4"><ea:XmlDataLabel ID="CIT8SP_Od" XSDType="TData" runat="server" /></cz8sp:OkresOd>
                    <cz8sp:OkresDo poz="P_5"><ea:XmlDataLabel ID="CIT8SP_Do" XSDType="TData" runat="server" /></cz8sp:OkresDo>
                </cz8sp:Naglowek>
                <cz8sp:PozycjeSzczegolowe>
                    <ea:DataRepeater ID="CIT8SP_P_B" runat="server" WithSections="False">
                    <cz8sp:P_B typ="G">
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B8" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B9" DataMember="DataWydania" XSDType="TData" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B10" DataMember="DataRozpoczecia" XSDType="TData" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B11" DataMember="NazwaPodmiotu" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B12" DataMember="NIP" XSDType="TNrNIP" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B13" DataMember="Udzial" XSDType="TProcentowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B14" DataMember="MaxPomoc" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B15" DataMember="MaxPomocDyskonto" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B16" DataMember="Koszty" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B17" DataMember="KosztyDyskonto" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B18" DataMember="Pomoc" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B19" DataMember="PomocDyskonto" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B20" DataMember="InneWsparcie" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_B21" DataMember="InneWsparcieDyskonto" XSDType="TKwota2" />
                    </cz8sp:P_B>
                    </ea:DataRepeater>

                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_22" DataMember="C1.Przychody" HideEmptyOrZero="true"  XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_23" DataMember="C1.Koszty" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_24" DataMember="C1.Dochod" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_25" DataMember="C1.KwalifikowanyDochod" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_26" DataMember="C1.Strata" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_27" DataMember="C2.Przychody" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_28" DataMember="C2.Koszty" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_29" DataMember="C2.Dochod" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_30" DataMember="C2.KwalifikowanyDochod" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_31" DataMember="C2.Strata" HideEmptyOrZero="true" XSDType="TKwota2" />

                    <ea:DataRepeater ID="CIT8SP_P_D" runat="server" WithSections="False">
                    <cz8sp:P_D typ="G">
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_D32" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_D33" DataMember="DataWydania" XSDType="TData" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_D34" DataMember="Dochod" XSDType="TKwota2" />
                    </cz8sp:P_D>
                    </ea:DataRepeater>
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_35" DataMember="D3.RazemDochod" XSDType="TKwota2" /> 
                    <ea:DataRepeater ID="CIT8SP_P_E" runat="server" WithSections="False">
                    <cz8sp:P_E typ="G">
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_E36" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_E37" DataMember="DataCofniecia" XSDType="TData" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_E38" DataMember="PodatekNiezaplacony" XSDType="TKwota2" HideEmptyOrZero="true" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_E39" DataMember="MaksymalnaPomoc" XSDType="TKwota2" HideEmptyOrZero="true" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_E40" DataMember="PodatekZaplacony" XSDType="TKwota2" HideEmptyOrZero="true" />
                    </cz8sp:P_E>
                    </ea:DataRepeater>
                    <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_41" DataMember="E.RazemPodatekDoliczony" XSDType="TKwota2" />
                    <ea:Section ID="CIT8SP_KosztyKwalifikowane" runat="server">
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_42" DataMember="F.KwotaKosztowB+R" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8sp:P_43" DataMember="F.NumerZezwolenia" XSDType="TZnakowy" />
                    </ea:Section>
                </cz8sp:PozycjeSzczegolowe>
            </cz8sp:Zalacznik_CIT_8SP>
        </ea:DataRepeater>

        <ea:DataRepeater ID="CIT8S" runat="server" WithSections="False" OnBeforeRow="CIT8S_BeforeRow">
            <cz8s:Zalacznik_CIT_8S>
                <cz8s:Naglowek>
                    <cz8s:KodFormularza kodSystemowy="CIT/8S (5)"  wersjaSchemy="4-0E">CIT/8S</cz8s:KodFormularza>
                    <cz8s:WariantFormularza>5</cz8s:WariantFormularza>
                    <cz8s:OkresOd poz="P_4"><ea:XmlDataLabel ID="CIT8S_Od" XSDType="TData" runat="server" /></cz8s:OkresOd>
                    <cz8s:OkresDo poz="P_5"><ea:XmlDataLabel ID="CIT8S_Do" XSDType="TData" runat="server" /></cz8s:OkresDo>
                </cz8s:Naglowek>
                <cz8s:PozycjeSzczegolowe>
                    <ea:DataRepeater ID="CIT8S_P_B" runat="server" WithSections="False">
                    <cz8s:P_B typ="G">
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B8" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B9" DataMember="DataWydania" XSDType="TData" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B10" DataMember="DataRozpoczecia" XSDType="TData" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B11" DataMember="MaxPomoc" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B12" DataMember="MaxPomocDyskonto" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B13" DataMember="Koszty" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B14" DataMember="KosztyDyskonto" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B15" DataMember="Pomoc" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B16" DataMember="PomocDyskonto" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B17" DataMember="InneWsparcie" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_B18" DataMember="InneWsparcieDyskonto" XSDType="TKwota2" />
                    </cz8s:P_B>
                    </ea:DataRepeater>                

                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_19" DataMember="C1.Przychody" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_20" DataMember="C1.Koszty" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_21" DataMember="C1.Dochod" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_22" DataMember="C1.KwalifikowanyDochod" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_23" DataMember="C1.Strata" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_24" DataMember="C2.Przychody" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_25" DataMember="C2.Koszty" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_26" DataMember="C2.Dochod" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_27" DataMember="C2.KwalifikowanyDochod" HideEmptyOrZero="true" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_28" DataMember="C2.Strata" HideEmptyOrZero="true" XSDType="TKwota2" />

                    <ea:DataRepeater ID="CIT8S_P_D" runat="server" WithSections="False">
                    <cz8s:P_D typ="G">
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_D29" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_D30" DataMember="DataWydania" XSDType="TData" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_D31" DataMember="Dochod" XSDType="TKwota2" />
                    </cz8s:P_D>
                    </ea:DataRepeater>
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_32" DataMember="D3.RazemDochod" XSDType="TKwota2" />
                    <ea:DataRepeater ID="CIT8S_P_E" runat="server" WithSections="False">
                    <cz8s:P_E typ="G">
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_E33" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_E34" DataMember="DataCofniecia" XSDType="TData" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_E35" DataMember="PodatekNiezaplacony" XSDType="TKwota2" HideEmptyOrZero="True" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_E36" DataMember="MaksymalnaPomoc" XSDType="TKwota2" HideEmptyOrZero="True" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_E37" DataMember="PodatekZaplacony" XSDType="TKwota2" HideEmptyOrZero="True" />
                    </cz8s:P_E>
                    </ea:DataRepeater>
                    <ea:XmlDataLabel runat="server" ElementName="cz8s:P_38" DataMember="E.RazemPodatekDoliczony" XSDType="TKwota2" />
                    <ea:Section ID="CIT8S_KosztyKwalifikowane" runat="server">
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_39" DataMember="F.KwotaKosztowB+R" XSDType="TKwota2" />
                        <ea:XmlDataLabel runat="server" ElementName="cz8s:P_40" DataMember="F.NumerZezwolenia" XSDType="TZnakowy" />
                    </ea:Section>
                </cz8s:PozycjeSzczegolowe>
            </cz8s:Zalacznik_CIT_8S>
        </ea:DataRepeater>

         <ea:DataRepeater ID="CITIP" runat="server" WithSections="False" OnBeforeRow="CITIP_BeforeRow">
		    <czip:Zalacznik_CIT_IP>
		        <czip:Naglowek>
		            <czip:KodFormularza kodSystemowy="CIT/IP (4)" wersjaSchemy="1-0E">CIT/IP</czip:KodFormularza>
                    <czip:WariantFormularza>4</czip:WariantFormularza>
                    <czip:OkresOd poz="P_4"><ea:XmlDataLabel ID="CITIP_Od" XSDType="TData" runat="server" /></czip:OkresOd>
                    <czip:OkresDo poz="P_5"><ea:XmlDataLabel ID="CITIP_Do" XSDType="TData" runat="server" /></czip:OkresDo>
		        </czip:Naglowek>
                <czip:PozycjeSzczegolowe>
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_8" HideEmptyOrZero="true" DataMember="B.Patent" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_9" HideEmptyOrZero="true" DataMember="B.PrawoWzorUzytkowy" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_10" HideEmptyOrZero="true" DataMember="B.PrawoWzorPrzesmyslowy" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_11" HideEmptyOrZero="true" DataMember="B.PrawoTopografiiUkładuScalonego" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_12" HideEmptyOrZero="true" DataMember="B.DodatkowePrawoOchronneDlaPatentu" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_13" HideEmptyOrZero="true" DataMember="B.PrawoZRejestracjiProduktuLeczniczego" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_14" HideEmptyOrZero="true" DataMember="B.WylacznePrawoUstawaDzU2018poz432" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_15" HideEmptyOrZero="true" DataMember="B.AutorskiePrawoDoProgramuKomputerowego" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_16" HideEmptyOrZero="true" DataMember="B.Ekspektatywa" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_17" HideEmptyOrZero="true" ID="KwalifikowanyDochod" XSDType="TWybor1" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_18" DataMember="C.PrzychodyZKwalifikowanychPraw" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_19" HideEmptyOrZero="true" DataMember="C.KosztyUzyskaniaPrzychodow" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_20" HideEmptyOrZero="true" DataMember="C.DochodyZKwalifikowanychPraw" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_21" HideEmptyOrZero="true" DataMember="C.OdliczenieZmniejszajaceDochod" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_22" HideEmptyOrZero="true" DataMember="C.KwalifikowanyDochod" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_23" HideEmptyOrZero="true" DataMember="C.DochodZKwaliPrawNiepodlegajacyOpodatkowaniuStawka5p" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_24" DataMember="PodstawaOpodatkowania" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_25" HideEmptyOrZero="true" DataMember="D.StrataZKwaliPrawBiezacyRok" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_26" HideEmptyOrZero="true" DataMember="E1WierzytelnosciZmniejszajacePodstaweOpodatkowania" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_27" HideEmptyOrZero="true" DataMember="E1.WierzytelnosciNieodliczone" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_28" HideEmptyOrZero="true" DataMember="E1WierzytelnosciZwiekszajaceStrate" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_29" HideEmptyOrZero="true" DataMember="E2ZobowiazaniaZwiekszajacePodstaweOpodatkowania" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_30" HideEmptyOrZero="true" DataMember="E2ZobowiazaniaZmniejszajaceStrate" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_31" HideEmptyOrZero="true" DataMember="E3WierzytelnosciZwiekszajacePodstaweOpodatkowania" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_32" HideEmptyOrZero="true" DataMember="E3WierzytelnosciZmniejszajaceStrate" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_33" HideEmptyOrZero="true" DataMember="E3ZobowiazaniaZmniejszajacePodstaweOpodatkowania" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_34" HideEmptyOrZero="true" DataMember="E3WartoscNieodliczonychZobowiazan" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_35" HideEmptyOrZero="true" DataMember="E3ZobowiazaniaZwiekszajaceStrate" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_36" DataMember="PodstawaOpodatkowaniaPoUwzglednieniuKwot" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_37" HideEmptyOrZero="true" DataMember="StrataPoUwzglednieniuKwot" XSDType="TKwota2" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_38" DataMember="ObliczonyPodatek" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_39" HideEmptyOrZero="true" DataMember="DoliczenieDoPodatku" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_40" HideEmptyOrZero="true" DataMember="OdliczenieOdPodatku" XSDType="TCalkowity" />
                    <ea:XmlDataLabel runat="server" ElementName="czip:P_41" DataMember="ObliczonyPodatekArt24d" XSDType="TCalkowity" />

                    <ea:DataRepeater ID="CITIP_P_G" runat="server" WithSections="False">
                    <czip:P_G typ="G">
                        <ea:XmlDataLabel runat="server" ElementName="czip:P_G42" DataMember="NumerZezwolenia" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="czip:P_G43" DataMember="DataWydaniaZezwolenia" XSDType="TData" />
                        <ea:XmlDataLabel runat="server" ElementName="czip:P_G44" DataMember="JednostkaTerytorialnaRealizacjiInwestycjiPL" XSDType="TZnakowy" />
                        <ea:XmlDataLabel runat="server" ElementName="czip:P_G45" DataMember="DochodPodlegajacyZwolnieniuZPodatku" XSDType="TKwota2" />
                    </czip:P_G>
                    </ea:DataRepeater>
                </czip:PozycjeSzczegolowe>
            </czip:Zalacznik_CIT_IP>
        </ea:DataRepeater>

        <ea:DataRepeater ID="CITWZ" runat="server" WithSections="False" OnBeforeRow="CITWZ_BeforeRow">
		    <czwz:Zalacznik_CIT_WZ>
		        <czwz:Naglowek>
		            <czwz:KodFormularza kodSystemowy="CIT/WZ (3)" wersjaSchemy="1-0E">CIT/WZ</czwz:KodFormularza>
                    <czwz:WariantFormularza>3</czwz:WariantFormularza>
                    <czwz:OkresOd poz="P_4"><ea:XmlDataLabel ID="CITWZ_Od" XSDType="TData" runat="server" /></czwz:OkresOd>
                    <czwz:OkresDo poz="P_5"><ea:XmlDataLabel ID="CITWZ_Do" XSDType="TData" runat="server" /></czwz:OkresDo>
		        </czwz:Naglowek>
                <czwz:PozycjeSzczegolowe>
                    <ea:DataRepeater ID="CITWZ_P_B" runat="server" WithSections="False">
                        <czwz:P_B typ="G" >
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_B8" DataMember="NazwaDluznika" XSDType="TZnakowy" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_B9" DataMember="NIP" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_B10" DataMember="NumerDokumentu" XSDType="TZnakowy" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_B11" DataMember="DataDokumentu" XSDType="TData" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_B12" DataMember="Termin" XSDType="TData" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_B13" DataMember="Wartosc" XSDType="TKwota2" />
                        </czwz:P_B>
                    </ea:DataRepeater>
                    <ea:XmlDataLabel runat="server" ElementName="czwz:P_14" ID="CITWZ_SumaB" XSDType="TKwota2" />
                   <ea:DataRepeater ID="CITWZ_P_C" runat="server" WithSections="False">
                       <czwz:P_C typ="G" >
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_C15" DataMember="NazwaWierzyciela" XSDType="TZnakowy" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_C16" DataMember="NIP" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_C17" DataMember="NumerDokumentu" XSDType="TZnakowy" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_C18" DataMember="DataDokumentu" XSDType="TData" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_C19" DataMember="Termin" XSDType="TData" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_C20" DataMember="Wartosc" XSDType="TKwota2" />
                       </czwz:P_C>
                    </ea:DataRepeater>
                    <ea:XmlDataLabel runat="server" ElementName="czwz:P_21" ID="CITWZ_SumaC" XSDType="TKwota2" />
                    <ea:DataRepeater ID="CITWZ_P_D" runat="server" WithSections="False">
                        <czwz:P_D typ="G" >
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_D22" DataMember="NazwaDluznika" XSDType="TZnakowy" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_D23" DataMember="NIP" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_D24" DataMember="NumerDokumentu" XSDType="TZnakowy" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_D25" DataMember="DataDokumentu" XSDType="TData" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_D26" DataMember="DataUregulowania" XSDType="TData" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_D27" HideEmptyOrZero="true" DataMember="UregulowaneWTrakcieRoku" XSDType="TKwota2" />
                        </czwz:P_D>
                    </ea:DataRepeater>
                    <ea:XmlDataLabel runat="server" ElementName="czwz:P_28" ID="CITWZ_SumaD" XSDType="TKwota2" />
                    <ea:DataRepeater ID="CITWZ_P_E" runat="server" WithSections="False">
                        <czwz:P_E typ="G" >
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_E29" DataMember="NazwaWierzyciela" XSDType="TZnakowy" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_E30" DataMember="NIP" XSDType="TNrNIP" HideEmptyOrZero="True"/>
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_E31" DataMember="NumerDokumentu" XSDType="TZnakowy" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_E32" DataMember="DataDokumentu" XSDType="TData" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_E33" DataMember="DataUregulowania" XSDType="TData" />
                            <ea:XmlDataLabel runat="server" ElementName="czwz:P_E34" HideEmptyOrZero="true" DataMember="UregulowaneWTrakcieRoku" XSDType="TKwota2" />
                        </czwz:P_E>
                    </ea:DataRepeater>
                    <ea:XmlDataLabel runat="server" ElementName="czwz:P_35" ID="CITWZ_SumaE" XSDType="TKwota2" />
                </czwz:PozycjeSzczegolowe>
            </czwz:Zalacznik_CIT_WZ>
        </ea:DataRepeater>

        <ea:Section ID="ORD_ZU" runat="server">
            <zzu:Zalacznik_ORD-ZU>
                <zzu:Naglowek>
                    <zzu:KodFormularza kodSystemowy="ORD-ZU (3)" wersjaSchemy="10-0E">ORD-ZU</zzu:KodFormularza>
                    <zzu:WariantFormularza>3</zzu:WariantFormularza>
                </zzu:Naglowek>
                <zzu:PozycjeSzczegolowe>
                    <zzu:P_13><ea:XmlDataLabel runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy" /></zzu:P_13>
                </zzu:PozycjeSzczegolowe>
            </zzu:Zalacznik_ORD-ZU>
        </ea:Section>

        </Zalaczniki>
    </ea:Section>
</Deklaracja>
