﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Deklaracje.CIT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<script runat="server">

    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (CITST_7)dc[typeof(CITST_7)];

        string kodKraju = ((string)dek.Bloki["X"]["KodKrajuPl"]).ToUpper();
        if (kodKraju == "" || kodKraju=="PL")
            AdresZagr.Visible = false;
        else
            AdresPol.Visible = false;

        var oddziały = new List<CITST_7_Multi>();
        var sta = new List<CITSTA_5>();
        foreach (Deklaracja pit in dek.Deklaracje)
            if (pit is CITST_7_Multi)
                oddziały.Add((CITST_7_Multi)pit);
            else if (pit is CITSTA_5)
                sta.Add((CITSTA_5)pit);

        CITSTM_REP.DataSource = oddziały;

        CITSTA_REP.DataSource = sta;

        ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
    }

    protected void CITSTM_BeforeRow(object sender, EventArgs e) {
    }

    protected void CITSTA_BeforeRow(object sender, EventArgs e) {
        var dek = (CITSTA_5)CITSTA_REP.CurrentRow;
        CITSTAM_REP.DataSource = dek.Deklaracje;
    }

    protected void CITSTAM_BeforeRow(object sender, EventArgs e) {
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.CIT.CITST_7,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja 
    xsi:noNamespaceSchemaLocation="http://www.finanse.mf.gov.pl/documents/766655/1198615/CIT-ST(7)_v1-0.xsd" 
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <Naglowek>
        <KodFormularza kodSystemowy="CIT-ST (7)" kodPodatku="CIT" rodzajZobowiazania="Z">CIT-ST</KodFormularza>
        <WariantFormularza>7</WariantFormularza>		
        <CelZlozenia poz="P_8"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="B.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
        <OkresOd poz="P_4"><ea:XmlDataLabel runat="server" DataMember="0.Od" XSDType="TData"/></OkresOd>
        <OkresDo poz="P_5"><ea:XmlDataLabel runat="server" DataMember="0.Do" XSDType="TData"/></OkresDo>
        <ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
    </Naglowek>
    <Podmiot1 rola="Podatnik">
        <OsobaNiefizyczna>
            <ea:XmlDataLabel ElementName="NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="PelnaNazwa" runat="server" DataMember="C1.Nazwa" XSDType="TZnakowy" />
            <ea:XmlDataLabel ElementName="REGON" runat="server" DataMember="C1.Regon" XSDType="TNrREGON" HideEmptyOrZero="true"/>
        </OsobaNiefizyczna>
        <AdresSiedziby rodzajAdresu="RAD">
            <ea:Section ID="AdresPol" runat="server">
            <AdresPol>
                <KodKraju>PL</KodKraju>
                <ea:XmlDataLabel ElementName="Wojewodztwo" ID="pit_wojew" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="Powiat" ID="pit_powiat" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="Gmina" ID="pit_gmina" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="NrDomu" ID="pit_nrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/>
                <ea:XmlDataLabel ElementName="NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="Miejscowosc" ID="pit_miejsc" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="KodPocztowy" ID="pit_kodPoczt" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/>
                <ea:XmlDataLabel ElementName="Poczta" ID="pit_poczta" runat="server" DataMember="C2.Poczta" XSDType="TMiejscowosc"/>
            </AdresPol>
            </ea:Section>
            <ea:Section ID="AdresZagr" runat="server">
            <AdresZagr>
                <ea:XmlDataLabel ElementName="KodKraju" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ElementName="KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="Miejscowosc" ID="pit_miejscZagr" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
            </AdresZagr>
            </ea:Section>
        </AdresSiedziby>
    </Podmiot1>
    <PozycjeSzczegolowe>
    <P_9>1</P_9>		
    <ea:XmlDataLabel ElementName="P_22" runat="server" DataMember="D.LiczbaZatrudnionych" XSDType="TCalkowity" />	
    <ea:DataRepeater ID="CITSTM_REP" runat="server" WithSections="False" OnBeforeRow="CITSTM_BeforeRow">
    <P_E typ="G">	
        <ea:XmlDataLabel ElementName="P_A" runat="server" DataMember="E.Wojew" XSDType="TJednAdmin"/>
        <ea:XmlDataLabel ElementName="P_B" runat="server" DataMember="E.Powiat" XSDType="TJednAdmin"/>
        <ea:XmlDataLabel ElementName="P_C" runat="server" DataMember="E.Gmina" XSDType="TJednAdmin"/>
        <ea:XmlDataLabel ElementName="P_D" runat="server" DataMember="E.KodGminy" XSDType="TTekstowy"/>
        <ea:XmlDataLabel ElementName="P_E1" runat="server" DataMember="E.NazwaOddziału" XSDType="TTekstowy"/>
        <ea:XmlDataLabel ElementName="P_F1" runat="server" DataMember="E.Regon" XSDType="TNrREGON" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_F2" runat="server" DataMember="E.NIP" XSDType="TNrNIP" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_G" runat="server" DataMember="E.LiczbaZatrudnionych" XSDType="TCalkowity"/>
    </P_E>
    </ea:DataRepeater>
    <ea:XmlDataLabel ElementName="P_169" runat="server" DataMember="F.Data" XSDType="TData" />	
    </PozycjeSzczegolowe>
    <Oswiadczenie>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością.</Oswiadczenie>
    <Zalaczniki>
    <ea:DataRepeater ID="CITSTA_REP" runat="server" WithSections="False" OnBeforeRow="CITSTA_BeforeRow">
    <Zalacznik_CIT-ST_A>
        <Naglowek>
            <KodFormularza kodSystemowy="CITSTA (5)">CIT-ST/A</KodFormularza>
            <WariantFormularza>5</WariantFormularza>
        </Naglowek>
        <PozycjeSzczegolowe>
            <ea:DataRepeater ID="CITSTAM_REP" runat="server" WithSections="False" OnBeforeRow="CITSTAM_BeforeRow">
            <P_B1 typ="G">
                <ea:XmlDataLabel ElementName="P_1" runat="server" DataMember="B1.Nazwa" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ElementName="P_2" runat="server" DataMember="B1.NazwaSkrócona" XSDType="TTekstowy" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="P_3" runat="server" DataMember="B1.Regon" XSDType="TNrREGON" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="P_4" runat="server" DataMember="B1.NIP" XSDType="TNrNIP" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="P_5" runat="server" DataMember="B1.DataRozpoczęciaDziałalności" XSDType="TData" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="P_6A" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"><ValuesMap><ea:ValuesPair Key="" Value="PL" /></ValuesMap></ea:XmlDataLabel>
                <ea:XmlDataLabel ElementName="P_7" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="P_8" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="P_9" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="P_10" runat="server" DataMember="B2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="P_11" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="P_12" runat="server" DataMember="B2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="P_13" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="P_14" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="P_15" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
            </P_B1>
            </ea:DataRepeater>
        </PozycjeSzczegolowe>
    </Zalacznik_CIT-ST_A>
    </ea:DataRepeater>
    <ea:Section ID="ORD_ZU" runat="server">
    <Zalacznik_ORD-ZU>
        <Naglowek>
            <KodFormularza kodSystemowy="ORD-ZU (2)">ORD-ZU</KodFormularza>
            <WariantFormularza>2</WariantFormularza>
        </Naglowek>
        <PozycjeSzczegolowe>
            <ea:XmlDataLabel ElementName="P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
        </PozycjeSzczegolowe>
    </Zalacznik_ORD-ZU>
    </ea:Section>
    </Zalaczniki>

</Deklaracja>
