﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="System.Net.NetworkInformation" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PITRyczałt)dc[typeof(PITRyczałt)];
        Rok.EditValue = dek.Rok;
        var us = (UrzadSkarbowy) dek.WlascicielHistoria.Podatki.UrzadSkarbowy;
        if (us != null)
            UrzSkarb.EditValue = us.KodUrzeduSkarbowego;
        var adres = dek.WlascicielHistoria.Adres;
        if (adres.Wojewodztwo != 0)
            Wojewodztwo.EditValue = CaptionAttribute.EnumToString(adres.Wojewodztwo).ToUpper();
        Powiat.EditValue = adres.Powiat.ToUpper();
        Gmina.EditValue = adres.Gmina.ToUpper();
        Ulica.EditValue = adres.Ulica;
        Ulica.Visible = adres.Ulica.Trim().Length > 0;
        NrDomu.EditValue = adres.NrDomu;
        NrLokalu.EditValue = adres.NrLokalu;
        NrLokalu.Visible = adres.NrLokalu.Trim().Length > 0;
        Miejscowosc.EditValue = adres.Miejscowosc;
        KodPocztowy.EditValue = adres.KodPocztowyS;
        Poczta.EditValue = adres.Poczta;
        Nip.EditValue = dek.WlascicielHistoria.NIP;

        var pieczątka = CoreModule.GetInstance(dek.Session).Config.Firma.Pieczątka;
        BP_7.EditValue = pieczątka.Nazwa;
        BP_8.EditValue = pieczątka.NIP;

        if (dek.WlascicielHistoria.Udzialy == Fraction.One)
        {
            SecPIT28A.Visible = true;
            PIT28A.EditValue = 1;
        }
        else
        {
            SecPIT28B.Visible = true;
            PIT28B.EditValue = 1;
            PIT28B_Count.EditValue = 1;
        }

        WyliczMiesiace(dek);
        if (dek.Okres.EntireMonths == 3)
        {
            WyliczKwartaly2(dek);
        }
        else
        {
            WyliczMiesiace2(dek);
        }
    }


    void WyliczMiesiace(PITRyczałt dek)
    {
        decimal Firma1 = 0;
        decimal Firma2 = 0;
        decimal Firma3 = 0;
        decimal Firma4 = 0;
        decimal Firma5 = 0;
        decimal Firma6 = 0;
        decimal Podatnik1 = 0;
        decimal Podatnik2 = 0;
        decimal Podatnik3 = 0;
        decimal Podatnik4 = 0;
        decimal Podatnik5 = 0;
        decimal Podatnik6 = 0;
        decimal Podatnik7 = 0;
        decimal Podatnik8 = 0;
        decimal Wplacono = 0;
        decimal Zdrowotne = 0;
        decimal Spoleczne = 0;
        int i = 12;
        do
        {
            Podatnik1 += (decimal) dek.Bloki["C"]["Podatnik1"];
            Podatnik2 += (decimal) dek.Bloki["C"]["Podatnik2"];
            Podatnik3 += (decimal) dek.Bloki["C"]["Podatnik3"];
            Podatnik4 += (decimal) dek.Bloki["C"]["Podatnik4"];
            Podatnik5 += (decimal) dek.Bloki["C"]["Podatnik5"];
            Podatnik6 += (decimal) dek.Bloki["X"]["CPodatnik6"];
            Podatnik7 += (decimal) dek.Bloki["X"]["CPodatnik7"];
            Podatnik8 += (decimal) dek.Bloki["X"]["CPodatnik8"];
            Firma1 += (decimal) dek.Bloki["C"]["Firma1"];
            Firma2 += (decimal) dek.Bloki["C"]["Firma2"];
            Firma3 += (decimal) dek.Bloki["C"]["Firma3"];
            Firma4 += (decimal) dek.Bloki["C"]["Firma4"];
            Firma5 += (decimal) dek.Bloki["C"]["Firma5"];
            Firma6 += (decimal) dek.Bloki["X"]["CFirma6"];
            Wplacono += (decimal) dek.Bloki["G"]["Wplacono"];
            Zdrowotne += dek.DoRozliczeniaZdrowotne;
            Spoleczne += dek.DoRozliczeniaSpoleczne;
            dek = (PITRyczałt)dek.Poprzednia;
            i--;
        } while (dek != null && i >= 0);
        P_74.EditValue = Spoleczne;
        P_114.EditValue = Zdrowotne;
        P_123.EditValue = Math.Round(Wplacono);
        AP_8.EditValue = Podatnik5;
        AP_9.EditValue = Podatnik4;
        AP_10.EditValue = Podatnik3;
        AP_11.EditValue = Podatnik6;
        AP_12.EditValue = Podatnik2;
        AP_13.EditValue = Podatnik1;
        AP_15.EditValue = Podatnik8;
        AP_16.EditValue = Podatnik7;
        BP_11.EditValue = Firma5;
        BP_12.EditValue = Firma4;
        BP_13.EditValue = Firma3;
        BP_14.EditValue = Firma6;
        BP_15.EditValue = Firma2;
        BP_16.EditValue = Firma1;
    }

    void WyliczKwartaly2(Deklaracja dek)
    {
        P_138.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_134.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_131.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_128.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
    }

    void WyliczMiesiace2(Deklaracja dek)
    {
        P_138.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_136.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_135.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_134.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_133.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_132.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_131.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_130.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_129.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_128.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_127.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_126.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
    }
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PITRyczałt,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:schemaLocation="http://crd.gov.pl/wzor/2018/12/19/6467/ http://crd.gov.pl/wzor/2018/12/19/6467/schemat.xsd"
            xmlns="http://crd.gov.pl/wzor/2018/12/19/6467/"
            xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <Naglowek>
        <KodFormularza kodSystemowy="PIT-28 (21)" kodPodatku="PPE" rodzajZobowiazania="Z" wersjaSchemy="1-0E">PIT-28</KodFormularza>
        <WariantFormularza>21</WariantFormularza>
        <CelZlozenia poz="P_6">1</CelZlozenia>
        <ea:XmlDataLabel ID="Rok" ElementName="Rok" runat="server" XSDType="TCalkowity" />
        <ea:XmlDataLabel ID="UrzSkarb" ElementName="KodUrzedu" runat="server" />
    </Naglowek>
    <Podmiot1 rola="Podatnik">
        <etd:OsobaFizyczna>
            <ea:XmlDataLabel ID="Nip" ElementName="etd:NIP" runat="server" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
        </etd:OsobaFizyczna>
        <etd:AdresZamieszkania rodzajAdresu="RAD">
            <etd:AdresPol>
                <etd:KodKraju>PL</etd:KodKraju>
                <ea:XmlDataLabel ID="Wojewodztwo" ElementName="etd:Wojewodztwo" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Powiat" ElementName="etd:Powiat" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Gmina" ElementName="etd:Gmina" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Ulica" ElementName="etd:Ulica" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="NrDomu" ElementName="etd:NrDomu" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="NrLokalu" ElementName="etd:NrLokalu" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Miejscowosc" ElementName="etd:Miejscowosc" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="KodPocztowy" ElementName="etd:KodPocztowy" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Poczta" ElementName="etd:Poczta" runat="server" XSDType="TTekstowy"/>
            </etd:AdresPol>
        </etd:AdresZamieszkania>
    </Podmiot1>
    <PozycjeSzczegolowe>
        <P_47>0</P_47>
        <P_56>0</P_56>
        <ea:XmlDataLabel runat="server" ElementName="P_68" DataMember="D.Straty" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_74" runat="server" ElementName="P_74" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_77>0</P_77>
        <P_100>0</P_100>
        <P_110>0</P_110>
        <P_113>0</P_113>
        <ea:XmlDataLabel ID="P_114" runat="server" ElementName="P_114" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_117>0</P_117>
        <P_119>0</P_119>
        <P_122>3</P_122>
        <ea:XmlDataLabel ID="P_123" runat="server" ElementName="P_123" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <P_124>0</P_124>
        <ea:XmlDataLabel ID="P_126" runat="server" ElementName="P_126" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_127" runat="server" ElementName="P_127" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_128" runat="server" ElementName="P_128" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_129" runat="server" ElementName="P_129" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_130" runat="server" ElementName="P_130" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_131" runat="server" ElementName="P_131" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_132" runat="server" ElementName="P_132" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_133" runat="server" ElementName="P_133" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_134" runat="server" ElementName="P_134" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_135" runat="server" ElementName="P_135" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_136" runat="server" ElementName="P_136" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <P_137>0</P_137>
        <ea:XmlDataLabel ID="P_138" runat="server" ElementName="P_138" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="PIT28A" runat="server" ElementName="P_147" XSDType="TCalkowity" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="PIT28B" runat="server" ElementName="P_148" XSDType="TCalkowity" HideEmptyOrZero="True"/>
    </PozycjeSzczegolowe>
  <Pouczenia>1</Pouczenia>
  <Zalaczniki>
      <ea:Section ID="SecPIT28A" runat="server" Visible="False">
      <Zalacznik_PIT-28_A xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/12/17/eD/PIT28A/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/12/17/eD/PIT28A/PIT-28_A(18)_Z_v1-0E.xsd"
          xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/12/17/eD/PIT28A/"
          xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
          xmlns:z28a="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/12/17/eD/PIT28A/"
          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT28A (18)" wersjaSchemy="1-0E">PIT-28/A</KodFormularza>
            <WariantFormularza>18</WariantFormularza>
          </Naglowek>
          <z28a:PozycjeSzczegolowe>
            <P_6>_</P_6>
            <ea:XmlDataLabel ID="AP_8" runat="server" ElementName="P_8" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="AP_9" runat="server" ElementName="P_9" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="AP_10" runat="server" ElementName="P_10" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="AP_11" runat="server" ElementName="P_11" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="AP_12" runat="server" ElementName="P_12" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="AP_13" runat="server" ElementName="P_13" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="AP_15" runat="server" ElementName="P_15" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="AP_16" runat="server" ElementName="P_16" XSDType="TKwota2" HideEmptyOrZero="True"/>
          </z28a:PozycjeSzczegolowe>
      </Zalacznik_PIT-28_A>
      </ea:Section>

      <ea:Section ID="SecPIT28B" runat="server" Visible="False">
      <Zalacznik_PIT-28_B xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/12/17/eD/PIT28B/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/12/17/eD/PIT28B/PIT-28_B(15)_Z_v1-0E.xsd"
          xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/12/17/eD/PIT28B/"
          xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
          xmlns:z28b="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/12/17/eD/PIT28B/"
          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT28B (15)" wersjaSchemy="1-0E">PIT-28/B</KodFormularza>
            <WariantFormularza>15</WariantFormularza>
          </Naglowek>
          <z28b:PozycjeSzczegolowe>
            <ea:XmlDataLabel ID="PIT28B_Count" runat="server" ElementName="P_6" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="BP_7" runat="server" ElementName="P_7" XSDType="TTekstowy" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="BP_8" runat="server" ElementName="P_8" XSDType="TNrNIP" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel runat="server" ElementName="P_9" DataMember="C.Udzial" XSDType="TProcentowy" HideEmptyOrZero="True"/>
            <P_10>0</P_10>
            <ea:XmlDataLabel ID="BP_11" runat="server" ElementName="P_11" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="BP_12" runat="server" ElementName="P_12" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="BP_13" runat="server" ElementName="P_13" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="BP_14" runat="server" ElementName="P_14" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="BP_15" runat="server" ElementName="P_15" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="BP_16" runat="server" ElementName="P_16" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <P_23>0</P_23>
          </z28b:PozycjeSzczegolowe>
      </Zalacznik_PIT-28_B>
      </ea:Section>
  </Zalaczniki>
</Deklaracja>
