﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="System.Net.NetworkInformation" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PITRyczałt)dc[typeof(PITRyczałt)];
        Rok.EditValue = dek.Rok;
        var us = (UrzadSkarbowy) dek.WlascicielHistoria.Podatki.UrzadSkarbowy;
        if (us != null)
            UrzSkarb.EditValue = us.KodUrzeduSkarbowego;
        var adres = dek.WlascicielHistoria.Adres;
        if (adres.Wojewodztwo != 0)
            Wojewodztwo.EditValue = CaptionAttribute.EnumToString(adres.Wojewodztwo).ToUpper();
        Powiat.EditValue = adres.Powiat.ToUpper();
        Gmina.EditValue = adres.Gmina.ToUpper();
        Ulica.EditValue = adres.Ulica;
        Ulica.Visible = adres.Ulica.Trim().Length > 0;
        NrDomu.EditValue = adres.NrDomu;
        NrLokalu.EditValue = adres.NrLokalu;
        NrLokalu.Visible = adres.NrLokalu.Trim().Length > 0;
        Miejscowosc.EditValue = adres.Miejscowosc;
        KodPocztowy.EditValue = adres.KodPocztowyS;
        Nip.EditValue = dek.WlascicielHistoria.NIP;

        var pieczątka = CoreModule.GetInstance(dek.Session).Config.Firma.Pieczątka;
        BP_7.EditValue = pieczątka.Nazwa;
        BP_8.EditValue = pieczątka.NIP;

        if (dek.WlascicielHistoria.Udzialy != Fraction.One)
        {
            SecUdzial100.Visible = false;
            SecPIT28B.Visible = true;
            PIT28B.EditValue = 1;
            PIT28B_Count.EditValue = 1;
        }

        WyliczMiesiace(dek);
        if (dek.Okres.EntireMonths == 3)
        {
            WyliczKwartaly2(dek);
        }
        else
        {
            WyliczMiesiace2(dek);
        }
    }


    void WyliczMiesiace(PITRyczałt dek)
    {
        decimal Firma1 = 0;
        decimal Firma2 = 0;
        decimal Firma3 = 0;
        decimal Firma4 = 0;
        decimal Firma5 = 0;
        decimal Firma6 = 0;
        decimal Podatnik1 = 0;
        decimal Podatnik2 = 0;
        decimal Podatnik3 = 0;
        decimal Podatnik4 = 0;
        decimal Podatnik5 = 0;
        decimal Podatnik6 = 0;
        decimal Podatnik7 = 0;
        decimal Podatnik8 = 0;
        decimal Wplacono = 0;
        decimal Zdrowotne = 0;
        decimal Spoleczne = 0;
        int i = 12;
        do
        {
            Podatnik1 += (decimal) dek.Bloki["C"]["Podatnik1"];
            Podatnik2 += (decimal) dek.Bloki["C"]["Podatnik2"];
            Podatnik3 += (decimal) dek.Bloki["C"]["Podatnik3"];
            Podatnik4 += (decimal) dek.Bloki["C"]["Podatnik4"];
            Podatnik5 += (decimal) dek.Bloki["C"]["Podatnik5"];
            Podatnik6 += (decimal) dek.Bloki["X"]["CPodatnik6"];
            Podatnik7 += (decimal) dek.Bloki["X"]["CPodatnik7"];
            Podatnik8 += (decimal) dek.Bloki["X"]["CPodatnik8"];
            Firma1 += (decimal) dek.Bloki["C"]["Firma1"];
            Firma2 += (decimal) dek.Bloki["C"]["Firma2"];
            Firma3 += (decimal) dek.Bloki["C"]["Firma3"];
            Firma4 += (decimal) dek.Bloki["C"]["Firma4"];
            Firma5 += (decimal) dek.Bloki["C"]["Firma5"];
            Firma6 += (decimal) dek.Bloki["X"]["CFirma6"];
            Wplacono += (decimal) dek.Bloki["G"]["Wplacono"];
            Zdrowotne += dek.DoRozliczeniaZdrowotne;
            Spoleczne += dek.DoRozliczeniaSpoleczne;
            dek = (PITRyczałt)dek.Poprzednia;
            i--;
        } while (dek != null && i >= 0);
        P_73.EditValue = Spoleczne;
        P_150.EditValue = Zdrowotne;
        P_159.EditValue = Math.Round(Wplacono);
        P_19.EditValue = Podatnik5;
        P_20.EditValue = Podatnik4;
        P_21.EditValue = Podatnik3;
        P_22.EditValue = Podatnik6;
        P_23.EditValue = Podatnik2;
        P_24.EditValue = Podatnik1;
        P_34.EditValue = Podatnik8;
        P_36.EditValue = Podatnik7;
        P_37.EditValue = Podatnik7;
        BP_11.EditValue = Firma5;
        BP_12.EditValue = Firma4;
        BP_13.EditValue = Firma3;
        BP_14.EditValue = Firma6;
        BP_15.EditValue = Firma2;
        BP_16.EditValue = Firma1;
    }

    void WyliczKwartaly2(Deklaracja dek)
    {
        P_174.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_170.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_167.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_164.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
    }

    void WyliczMiesiace2(Deklaracja dek)
    {
        P_174.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_172.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_171.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_170.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_169.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_168.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_167.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_166.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_165.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_164.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_163.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_162.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
    }
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PITRyczałt,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:schemaLocation="http://crd.gov.pl/wzor/2021/01/07/10284/ http://crd.gov.pl/wzor/2021/01/07/10284/schemat.xsd"
            xmlns="http://crd.gov.pl/wzor/2021/01/07/10284/"
            xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/07/06/eD/DefinicjeTypy/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <Naglowek>
        <KodFormularza kodSystemowy="PIT-28 (23)" kodPodatku="PPE" rodzajZobowiazania="Z" wersjaSchemy="1-0E">PIT-28</KodFormularza>
        <WariantFormularza>23</WariantFormularza>
        <CelZlozenia poz="P_6">1</CelZlozenia>
        <ea:XmlDataLabel ID="Rok" ElementName="Rok" runat="server" XSDType="TCalkowity" />
        <ea:XmlDataLabel ID="UrzSkarb" ElementName="KodUrzedu" runat="server" />
    </Naglowek>
    <Podmiot1 rola="Podatnik">
        <etd:OsobaFizyczna>
            <ea:XmlDataLabel ID="Nip" ElementName="etd:NIP" runat="server" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
        </etd:OsobaFizyczna>
        <etd:AdresZamieszkania rodzajAdresu="RAD">
            <etd:AdresPol>
                <etd:KodKraju>PL</etd:KodKraju>
                <ea:XmlDataLabel ID="Wojewodztwo" ElementName="etd:Wojewodztwo" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Powiat" ElementName="etd:Powiat" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Gmina" ElementName="etd:Gmina" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Ulica" ElementName="etd:Ulica" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="NrDomu" ElementName="etd:NrDomu" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="NrLokalu" ElementName="etd:NrLokalu" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Miejscowosc" ElementName="etd:Miejscowosc" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="KodPocztowy" ElementName="etd:KodPocztowy" runat="server" XSDType="TTekstowy"/>
            </etd:AdresPol>
        </etd:AdresZamieszkania>
    </Podmiot1>
    <PozycjeSzczegolowe>
        <ea:Section ID="SecUdzial100" runat="server">
            <ea:XmlDataLabel ID="P_19" runat="server" ElementName="P_19" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_20" runat="server" ElementName="P_20" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_21" runat="server" ElementName="P_21" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_22" runat="server" ElementName="P_22" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_23" runat="server" ElementName="P_23" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_24" runat="server" ElementName="P_24" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <P_25>0</P_25>
            <ea:XmlDataLabel ID="P_34" runat="server" ElementName="P_34" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <P_35>0</P_35>
            <ea:XmlDataLabel ID="P_36" runat="server" ElementName="P_36" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_37" runat="server" ElementName="P_37" XSDType="TKwota2" HideEmptyOrZero="True"/>
        </ea:Section>
        <P_46>0</P_46>
        <P_55>0</P_55>
        <ea:XmlDataLabel runat="server" ElementName="P_72" DataMember="D.Straty" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_73" runat="server" ElementName="P_73" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_76>0</P_76>
        <P_99>0</P_99>
        <P_146>0</P_146>
        <P_149>0</P_149>
        <ea:XmlDataLabel ID="P_150" runat="server" ElementName="P_150" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_153>0</P_153>
        <P_155>0</P_155>
        <P_158>3</P_158>
        <ea:XmlDataLabel ID="P_159" runat="server" ElementName="P_159" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <P_160>0</P_160>
        <ea:XmlDataLabel ID="P_162" runat="server" ElementName="P_162" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_163" runat="server" ElementName="P_163" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_164" runat="server" ElementName="P_164" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_165" runat="server" ElementName="P_165" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_166" runat="server" ElementName="P_166" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_167" runat="server" ElementName="P_167" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_168" runat="server" ElementName="P_168" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_169" runat="server" ElementName="P_169" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_170" runat="server" ElementName="P_170" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_171" runat="server" ElementName="P_171" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_172" runat="server" ElementName="P_172" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <P_173>0</P_173>
        <ea:XmlDataLabel ID="P_174" runat="server" ElementName="P_174" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="PIT28B" runat="server" ElementName="P_183" XSDType="TCalkowity" HideEmptyOrZero="True"/>
    </PozycjeSzczegolowe>
  <ea:Section ID="SecPIT28B" runat="server" Visible="false">
      <Zalaczniki>
      <Zalacznik_PIT-28_B xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/12/29/eD/PIT28B/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/12/29/eD/PIT28B/PIT-28_B(17)_Z_v1-0E.xsd"
          xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/12/29/eD/PIT28B/"
          xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/07/06/eD/DefinicjeTypy/"
          xmlns:z28b="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/12/29/eD/PIT28B/"
          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT28B (17)" wersjaSchemy="1-0E">PIT-28/B</KodFormularza>
            <WariantFormularza>17</WariantFormularza>
          </Naglowek>
          <z28b:PozycjeSzczegolowe>
            <ea:XmlDataLabel ID="PIT28B_Count" runat="server" ElementName="P_6"/>              
            <P_C typ="G">
                <ea:XmlDataLabel ID="BP_7" runat="server" ElementName="P_C7" XSDType="TTekstowy" />
                <ea:XmlDataLabel ID="BP_8" runat="server" ElementName="P_C8" XSDType="TNrNIP" />
                <ea:XmlDataLabel runat="server" ElementName="P_C9" DataMember="C.Udzial" XSDType="TProcentowy" />
                <P_C10>0</P_C10>
                <ea:XmlDataLabel ID="BP_11" runat="server" ElementName="P_C11" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_12" runat="server" ElementName="P_C12" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_13" runat="server" ElementName="P_C13" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_14" runat="server" ElementName="P_C14" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_15" runat="server" ElementName="P_C15" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_16" runat="server" ElementName="P_C16" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <P_C23>0</P_C23>
            </P_C>
          </z28b:PozycjeSzczegolowe>
      </Zalacznik_PIT-28_B>
  </Zalaczniki>
  </ea:Section>
  <Pouczenia>1</Pouczenia>
</Deklaracja>
