﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="System.Net.NetworkInformation" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PITRyczałt2022_2)dc[typeof(PITRyczałt2022_2)];
        Rok.EditValue = dek.Rok;
        var us = (UrzadSkarbowy) dek.WlascicielHistoria.Podatki.UrzadSkarbowy;
        if (us != null)
            UrzSkarb.EditValue = us.KodUrzeduSkarbowego;
        var adres = dek.WlascicielHistoria.Adres;
        if (adres.Wojewodztwo != 0)
            Wojewodztwo.EditValue = CaptionAttribute.EnumToString(adres.Wojewodztwo).ToUpper();
        Powiat.EditValue = adres.Powiat.ToUpper();
        Gmina.EditValue = adres.Gmina.ToUpper();
        Ulica.EditValue = adres.Ulica;
        Ulica.Visible = adres.Ulica.Trim().Length > 0;
        NrDomu.EditValue = adres.NrDomu;
        NrLokalu.EditValue = adres.NrLokalu;
        NrLokalu.Visible = adres.NrLokalu.Trim().Length > 0;
        Miejscowosc.EditValue = adres.Miejscowosc;
        KodPocztowy.EditValue = adres.KodPocztowyS;
        Nip.EditValue = dek.WlascicielHistoria.NIP;

        var pieczątka = CoreModule.GetInstance(dek.Session).Config.Firma.Pieczątka;
        BP_7.EditValue = pieczątka.Nazwa;
        BP_8.EditValue = pieczątka.NIP;

        if (dek.WlascicielHistoria.Udzialy != Fraction.One)
        {
            SecUdzial100.Visible = false;
            SecPIT28B.Visible = true;
            PIT28B.EditValue = 1;
            PIT28B_Count.EditValue = 1;
        }

        WyliczMiesiace(dek);
        if (dek.Okres.EntireMonths == 3)
        {
            WyliczKwartaly2(dek);
        }
        else
        {
            WyliczMiesiace2(dek);
        }
    }

    void WyliczMiesiace(IRyczalt2022 dek)
    {
        decimal Firma1 = 0;
        decimal Firma2 = 0;
        decimal Firma3 = 0;
        decimal Firma4 = 0;
        decimal Firma5 = 0;
        decimal Firma6 = 0;
        decimal Firma8 = 0;
        decimal Firma9 = 0;
        decimal Firma10 = 0;
        decimal Podatnik1 = 0;
        decimal Podatnik2 = 0;
        decimal Podatnik3 = 0;
        decimal Podatnik4 = 0;
        decimal Podatnik5 = 0;
        decimal Podatnik6 = 0;
        decimal Podatnik7 = 0;
        decimal Podatnik8 = 0;
        decimal Podatnik9 = 0;
        decimal Podatnik10 = 0;
        decimal Wplacono = 0;
        decimal Zdrowotne = 0;
        decimal Spoleczne = 0;
        int i = 12;
        bool ostatniMiesiac = true;
        do
        {
            Podatnik1 += (decimal) dek.Bloki["C"]["Podatnik1"];
            Podatnik2 += (decimal) dek.Bloki["C"]["Podatnik2"];
            Podatnik3 += (decimal) dek.Bloki["C"]["Podatnik3"];
            Podatnik4 += (decimal) dek.Bloki["C"]["Podatnik4"];
            Podatnik5 += (decimal) dek.Bloki["C"]["Podatnik5"];
            Podatnik6 += (decimal) dek.Bloki["C"]["Podatnik6"];
            Podatnik7 += (decimal) dek.Bloki["C"]["Podatnik7"];
            Podatnik8 += (decimal) dek.Bloki["C"]["Podatnik8"];
            Podatnik9 += (decimal) dek.Bloki["C"]["Podatnik9"];
            Podatnik10 += (decimal) dek.Bloki["C"]["Podatnik10"];
            Firma1 += (decimal) dek.Bloki["C"]["Firma1"];
            Firma2 += (decimal) dek.Bloki["C"]["Firma2"];
            Firma3 += (decimal) dek.Bloki["C"]["Firma3"];
            Firma4 += (decimal) dek.Bloki["C"]["Firma4"];
            Firma5 += (decimal) dek.Bloki["C"]["Firma5"];
            Firma6 += (decimal) dek.Bloki["C"]["Firma6"];
            Firma8 += (decimal) dek.Bloki["C"]["Firma8"];
            Firma9 += (decimal) dek.Bloki["C"]["Firma9"];
            Firma10 += (decimal) dek.Bloki["C"]["Firma10"];
            Wplacono += (decimal) dek.Bloki["G"]["Wplacono"];
            if(dek is PITRyczałt2022_2)
                Zdrowotne += (decimal) dek.Bloki["D"]["Zdrowotne50"];
            if(ostatniMiesiac)
                Spoleczne = (decimal) dek.Bloki["X"]["SkladkiNaUbezpieczenieSpoleczneNarastajaco"];
    
            ostatniMiesiac = false;
            
            dek = dek.Prev;
            i--;
        } while (dek != null && i >= 0);
        P_97.EditValue = Spoleczne;
        P_104.EditValue = Zdrowotne;
        P_235.EditValue = Math.Round(Wplacono);
        P_25.EditValue = Podatnik5;
        P_26.EditValue = Podatnik4;
        P_27.EditValue = Podatnik3;
        P_28.EditValue = Podatnik6;
        P_29.EditValue = Podatnik10;
        P_30.EditValue = Podatnik8;
        P_31.EditValue = Podatnik9;
        P_32.EditValue = Podatnik2;
        P_33.EditValue = Podatnik1;
        P_48.EditValue = Podatnik7;
        BP_11.EditValue = Firma5;
        BP_12.EditValue = Firma4;
        BP_13.EditValue = Firma3;
        BP_14.EditValue = Firma6;
        BP_15.EditValue = Firma10;
        BP_16.EditValue = Firma8;
        BP_17.EditValue = Firma9;
        BP_18.EditValue = Firma2;
        BP_19.EditValue = Firma1;
    }

    void WyliczKwartaly2(Deklaracja dek)
    {
        P_249.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_246.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_243.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_240.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
    }

    void WyliczMiesiace2(Deklaracja dek)
    {
        P_249.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_248.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_247.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_246.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_245.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_244.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_243.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_242.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_241.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_240.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_239.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        P_238.EditValue = Math.Round((decimal) dek.Bloki["G"]["Zaliczka"]);
    }
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PITRyczałt2022_2,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:schemaLocation="http://crd.gov.pl/wzor/2023/02/06/12109/ http://crd.gov.pl/wzor/2023/02/06/12109/schemat.xsd"
            xmlns="http://crd.gov.pl/wzor/2023/02/06/12109/"
            xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/DefinicjeTypy/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <Naglowek>
        <KodFormularza kodSystemowy="PIT-28 (25)" kodPodatku="PPE" rodzajZobowiazania="Z" wersjaSchemy="2-0E">PIT-28</KodFormularza>
        <WariantFormularza>25</WariantFormularza>
        <CelZlozenia poz="P_6">1</CelZlozenia>
        <ea:XmlDataLabel ID="Rok" ElementName="Rok" runat="server" XSDType="TCalkowity" />
        <ea:XmlDataLabel ID="UrzSkarb" ElementName="KodUrzedu" runat="server" />
    </Naglowek>
    <Podmiot1 rola="Podatnik">
        <OsobaFizyczna>
            <ea:XmlDataLabel ID="Nip" ElementName="etd:NIP" runat="server" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
        </OsobaFizyczna>
        <AdresZamieszkania rodzajAdresu="RAD">
            <AdresPol>
                <KodKraju>PL</KodKraju>
                <ea:XmlDataLabel ID="Wojewodztwo" ElementName="Wojewodztwo" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Powiat" ElementName="Powiat" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Gmina" ElementName="Gmina" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Ulica" ElementName="Ulica" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="NrDomu" ElementName="NrDomu" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="NrLokalu" ElementName="NrLokalu" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Miejscowosc" ElementName="Miejscowosc" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="KodPocztowy" ElementName="KodPocztowy" runat="server" XSDType="TTekstowy"/>
            </AdresPol>
        </AdresZamieszkania>
    </Podmiot1>
    <PozycjeSzczegolowe>
        <ea:Section ID="SecUdzial100" runat="server">
            <ea:XmlDataLabel ID="P_25" runat="server" ElementName="P_25" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_26" runat="server" ElementName="P_26" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_27" runat="server" ElementName="P_27" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_28" runat="server" ElementName="P_28" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_29" runat="server" ElementName="P_29" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_30" runat="server" ElementName="P_30" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_31" runat="server" ElementName="P_31" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_32" runat="server" ElementName="P_32" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <ea:XmlDataLabel ID="P_33" runat="server" ElementName="P_33" XSDType="TKwota2" HideEmptyOrZero="True"/>
            <P_34>0</P_34>
            <P_44>0</P_44>
            <ea:XmlDataLabel ID="P_48" runat="server" ElementName="P_48" XSDType="TKwota2"/>
            <P_49>0</P_49>
        </ea:Section>
        <P_62>0</P_62>
        <P_73>0</P_73>
        <ea:XmlDataLabel runat="server" ElementName="P_96" DataMember="D.Straty" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_97" runat="server" ElementName="P_97" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_99>0</P_99>
        <ea:XmlDataLabel ID="P_104" runat="server" ElementName="P_104" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_143>0</P_143>
        <P_223>0</P_223>
        <P_227>0</P_227>
        <P_229>0</P_229>
        <P_231>0</P_231>
        <P_234>3</P_234>
        <ea:XmlDataLabel ID="P_235" runat="server" ElementName="P_235" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <P_236>0</P_236>
        <ea:XmlDataLabel ID="P_238" runat="server" ElementName="P_238" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_239" runat="server" ElementName="P_239" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_240" runat="server" ElementName="P_240" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_241" runat="server" ElementName="P_241" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_242" runat="server" ElementName="P_242" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_243" runat="server" ElementName="P_243" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_244" runat="server" ElementName="P_244" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_245" runat="server" ElementName="P_245" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_246" runat="server" ElementName="P_246" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_247" runat="server" ElementName="P_247" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_248" runat="server" ElementName="P_248" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="P_249" runat="server" ElementName="P_249" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel ID="PIT28B" runat="server" ElementName="P_259" XSDType="TCalkowity" HideEmptyOrZero="True"/>
    </PozycjeSzczegolowe>
  <ea:Section ID="SecPIT28B" runat="server" Visible="false">
      <Zalaczniki>
      <Zalacznik_PIT-28_B xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/11/02/eD/PIT28B/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/11/02/eD/PIT28B/PIT-28_B(19)_Z_v1-0E.xsd"
          xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/11/02/eD/PIT28B/"
          xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/DefinicjeTypy/"
          xmlns:z28b="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/11/02/eD/PIT28B/"
          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT28B (19)" wersjaSchemy="1-0E">PIT-28/B</KodFormularza>
            <WariantFormularza>19</WariantFormularza>
          </Naglowek>
          <z28b:PozycjeSzczegolowe>
            <ea:XmlDataLabel ID="PIT28B_Count" runat="server" ElementName="P_6"/>              
            <P_C typ="G">
                <ea:XmlDataLabel ID="BP_7" runat="server" ElementName="P_C7" XSDType="TTekstowy" />
                <ea:XmlDataLabel ID="BP_8" runat="server" ElementName="P_C8" XSDType="TNrNIP" />
                <ea:XmlDataLabel runat="server" ElementName="P_C9" DataMember="C.Udzial" XSDType="TProcentowy" />
                <P_C10>0</P_C10>
                <ea:XmlDataLabel ID="BP_11" runat="server" ElementName="P_C11" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_12" runat="server" ElementName="P_C12" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_13" runat="server" ElementName="P_C13" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_14" runat="server" ElementName="P_C14" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_15" runat="server" ElementName="P_C15" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_16" runat="server" ElementName="P_C16" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_17" runat="server" ElementName="P_C17" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_18" runat="server" ElementName="P_C18" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <ea:XmlDataLabel ID="BP_19" runat="server" ElementName="P_C19" XSDType="TKwota2" HideEmptyOrZero="True"/>
                <P_C29>0</P_C29>
            </P_C>
          </z28b:PozycjeSzczegolowe>
      </Zalacznik_PIT-28_B>
  </Zalaczniki>
  </ea:Section>
  <Pouczenia>1</Pouczenia>
</Deklaracja>
