﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PIT5_16)dc[typeof(PIT5_16)];

        Rok.EditValue = dek.Rok;
        var us = (UrzadSkarbowy) dek.WlascicielHistoria.Podatki.UrzadSkarbowy;
        if (us != null)
            UrzSkarb.EditValue = us.KodUrzeduSkarbowego;
        var adres = dek.WlascicielHistoria.Adres;
        if (adres.Wojewodztwo != 0)
            Wojewodztwo.EditValue = CaptionAttribute.EnumToString(adres.Wojewodztwo).ToUpper();
        Powiat.EditValue = adres.Powiat.ToUpper();
        Gmina.EditValue = adres.Gmina.ToUpper();
        Ulica.EditValue = adres.Ulica;
        Ulica.Visible = adres.Ulica.Trim().Length > 0;
        NrDomu.EditValue = adres.NrDomu;
        NrLokalu.EditValue = adres.NrLokalu;
        NrLokalu.Visible = adres.NrLokalu.Trim().Length > 0;
        Miejscowosc.EditValue = adres.Miejscowosc;
        KodPocztowy.EditValue = adres.KodPocztowyS;
        Poczta.EditValue = adres.Poczta;

        if ((decimal) dek.Bloki["C"]["PrzychodNajem"] > 0m)
            SecNajem.Visible = true;

        if ((decimal) dek.Bloki["D"]["Straty"] > 0m)
            SecStraty.Visible = true;

        PITBCount.EditValue = PITBCount2.EditValue = IloscPitB.EditValue = 1;
        if (dek.Okres.EntireMonths == 3)
        {
            WyliczKwartaly(dek);
        }
        else
        {
            WyliczMiesiace(dek);
        }
        WyliczPitB(dek.Bloki);
    }

    void DrugiPitBVisible()
    {
        DrugiPitB.Visible = true;
        PITBCount.EditValue = PITBCount2.EditValue = IloscPitB.EditValue = 2;
    }

    void WyliczPitB(Deklaracja.BlokiIdx b)
    {
        if ((Percent)b["K1"]["Udzial"] == Percent.Hundred)
        {
            PB1_P8.EditValue = b["K1"]["Regon"];
            PB1_P9.EditValue = b["K1"]["MiejsceProwadzenia"];
            PB1_P10.EditValue = b["K1"]["Przychod"];
            PB1_P11.EditValue = b["K1"]["Koszty"];
            PitB1_B1.Visible = true;
        }
        else if ((Percent)b["K1"]["Udzial"] != Percent.Zero)
        {
            PB1_P19.EditValue = b["K1"]["NazwaPelna"];
            PB1_P20.EditValue = b["K1"]["Udzial"];
            PB1_P21.EditValue = b["K1"]["Nip"];
            PB1_P22.EditValue = b["K1"]["Regon"];
            PB1_P23.EditValue = b["K1"]["MiejsceProwadzenia"];
            PB1_P24.EditValue = (decimal) b["K1"]["Przychod"]/(Percent) b["K1"]["Udzial"];
            PB1_P25.EditValue = b["K1"]["Przychod"];
            PB1_P26.EditValue = (decimal) b["K1"]["Koszty"]/(Percent) b["K1"]["Udzial"];
            PB1_P27.EditValue = b["K1"]["Koszty"];
            PitB1_C1.Visible = true;
        }
        if ((Percent)b["K2"]["Udzial"] == Percent.Hundred)
        {
            PB1_P14.EditValue = b["K2"]["Regon"];
            PB1_P15.EditValue = b["K2"]["MiejsceProwadzenia"];
            PB1_P16.EditValue = b["K2"]["Przychod"];
            PB1_P17.EditValue = b["K2"]["Koszty"];
            PitB1_B2.Visible = true;
        }
        else if ((Percent)b["K2"]["Udzial"] != Percent.Zero)
        {
            PB1_P30.EditValue = b["K2"]["NazwaPelna"];
            PB1_P31.EditValue = b["K2"]["Udzial"];
            PB1_P32.EditValue = b["K2"]["Nip"];
            PB1_P33.EditValue = b["K2"]["Regon"];
            PB1_P34.EditValue = b["K2"]["MiejsceProwadzenia"];
            PB1_P35.EditValue = (decimal) b["K2"]["Przychod"]/(Percent) b["K2"]["Udzial"];
            PB1_P36.EditValue = b["K2"]["Przychod"];
            PB1_P37.EditValue = (decimal) b["K2"]["Koszty"]/(Percent) b["K2"]["Udzial"];
            PB1_P38.EditValue = b["K2"]["Koszty"];
            PitB1_C2.Visible = true;
        }
        if ((Percent)b["K3"]["Udzial"] == Percent.Hundred)
        {
            PB2_P8.EditValue = b["K3"]["Regon"];
            PB2_P9.EditValue = b["K3"]["MiejsceProwadzenia"];
            PB2_P10.EditValue = b["K3"]["Przychod"];
            PB2_P11.EditValue = b["K3"]["Koszty"];
            PitB2_B1.Visible = true;
            DrugiPitBVisible();
        }
        else if ((Percent)b["K3"]["Udzial"] != Percent.Zero)
        {
            PB1_P41.EditValue = b["K3"]["NazwaPelna"];
            PB1_P42.EditValue = b["K3"]["Udzial"];
            PB1_P43.EditValue = b["K3"]["Nip"];
            PB1_P44.EditValue = b["K3"]["Regon"];
            PB1_P45.EditValue = b["K3"]["MiejsceProwadzenia"];
            PB1_P46.EditValue = (decimal) b["K3"]["Przychod"]/(Percent) b["K3"]["Udzial"];
            PB1_P47.EditValue = b["K3"]["Przychod"];
            PB1_P48.EditValue = (decimal) b["K3"]["Koszty"]/(Percent) b["K3"]["Udzial"];
            PB1_P49.EditValue = b["K3"]["Koszty"];
            PitB1_C3.Visible = true;
        }
        if ((Percent)b["K4"]["Udzial"] == Percent.Hundred)
        {
            PB2_P14.EditValue = b["K4"]["Regon"];
            PB2_P15.EditValue = b["K4"]["MiejsceProwadzenia"];
            PB2_P16.EditValue = b["K4"]["Przychod"];
            PB2_P17.EditValue = b["K4"]["Koszty"];
            PitB1_B2.Visible = true;
            DrugiPitBVisible();
        }
        else if ((Percent)b["K4"]["Udzial"] != Percent.Zero)
        {
            PB2_P19.EditValue = b["K4"]["NazwaPelna"];
            PB2_P20.EditValue = b["K4"]["Udzial"];
            PB2_P21.EditValue = b["K4"]["Nip"];
            PB2_P22.EditValue = b["K4"]["Regon"];
            PB2_P23.EditValue = b["K4"]["MiejsceProwadzenia"];
            PB2_P24.EditValue = (decimal) b["K4"]["Przychod"]/(Percent) b["K4"]["Udzial"];
            PB2_P25.EditValue = b["K4"]["Przychod"];
            PB2_P26.EditValue = (decimal) b["K4"]["Koszty"]/(Percent) b["K4"]["Udzial"];
            PB2_P27.EditValue = b["K4"]["Koszty"];
            PitB2_C1.Visible = true;
            DrugiPitBVisible();
        }
    }

    void WyliczKwartaly(Deklaracja dek)
    {
        Odsetki12.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty12.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki9.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty9.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki6.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty6.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki3.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty3.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
    }

    void WyliczMiesiace(Deklaracja dek)
    {
        Odsetki12.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty12.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki11.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty11.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki10.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty10.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki9.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty9.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki8.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty8.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki7.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty7.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki6.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty6.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki5.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty5.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki4.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty4.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki3.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty3.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki2.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty2.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki1.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty1.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT5_16,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:schemaLocation="http://crd.gov.pl/wzor/2018/12/12/6398/ http://crd.gov.pl/wzor/2018/12/12/6398/schemat.xsd"
            xmlns="http://crd.gov.pl/wzor/2018/12/12/6398/"
            xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <Naglowek>
        <KodFormularza kodSystemowy="PIT-36 (26)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">PIT-36</KodFormularza>
        <WariantFormularza>26</WariantFormularza>
        <CelZlozenia poz="P_10">1</CelZlozenia>
        <ea:XmlDataLabel ID="Rok" ElementName="Rok" runat="server" XSDType="TCalkowity" />
        <ea:XmlDataLabel ID="UrzSkarb" ElementName="KodUrzedu" runat="server" />
    </Naglowek>
    <Podmiot1 rola="Podatnik">
        <etd:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
        </etd:OsobaFizyczna>
        <etd:AdresZamieszkania rodzajAdresu="RAD">
            <etd:AdresPol>
                <etd:KodKraju>PL</etd:KodKraju>
                <ea:XmlDataLabel ID="Wojewodztwo" ElementName="etd:Wojewodztwo" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Powiat" ElementName="etd:Powiat" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Gmina" ElementName="etd:Gmina" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Ulica" ElementName="etd:Ulica" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="NrDomu" ElementName="etd:NrDomu" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="NrLokalu" ElementName="etd:NrLokalu" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Miejscowosc" ElementName="etd:Miejscowosc" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="KodPocztowy" ElementName="etd:KodPocztowy" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Poczta" ElementName="etd:Poczta" runat="server" XSDType="TTekstowy"/>
            </etd:AdresPol>
        </etd:AdresZamieszkania>
    </Podmiot1>
    <PozycjeSzczegolowe>
        <P_6>1</P_6>
        <ea:Section runat="server" ID="SecNajem" Visible="False">
            <ea:XmlDataLabel runat="server" ElementName="P_69" DataMember="C.PrzychodNajem" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_70" DataMember="C.KosztyNajem" XSDType="TKwota2" />
            <P_71>0</P_71>
            <P_73>0</P_73>
	    </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_157" DataMember="D.DochodZwolniony" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <ea:Section runat="server" ID="SecStraty" Visible="False">
            <P_161_1>_</P_161_1>
            <ea:XmlDataLabel runat="server" ElementName="P_162" DataMember="D.Straty" XSDType="TKwota2" HideEmptyOrZero="True"/>
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_165" DataMember="E1.Spoleczne" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_198>0</P_198>
        <P_201>0</P_201>
        <P_202>0</P_202>
        <P_206>0</P_206>
        <ea:XmlDataLabel runat="server" ElementName="P_207" DataMember="J2.Zdrowotne" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_213>0</P_213>
        <P_215>0</P_215>
        <P_216>0</P_216>
        <P_217>0</P_217>
        <ea:XmlDataLabel runat="server" ElementName="P_219" ID="DoZaplaty1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_220" ID="DoZaplaty2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_221" ID="DoZaplaty3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_222" ID="DoZaplaty4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_223" ID="DoZaplaty5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_224" ID="DoZaplaty6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_243" ID="DoZaplaty7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_244" ID="DoZaplaty8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_245" ID="DoZaplaty9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_246" ID="DoZaplaty10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_247" ID="DoZaplaty11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_248" ID="DoZaplaty12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <P_328>0</P_328>
        <P_338>0</P_338>
        <ea:XmlDataLabel runat="server" ElementName="P_366" ID="Odsetki1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_367" ID="Odsetki2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_368" ID="Odsetki3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_369" ID="Odsetki4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_370" ID="Odsetki5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_371" ID="Odsetki6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_372" ID="Odsetki7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_373" ID="Odsetki8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_374" ID="Odsetki9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_375" ID="Odsetki10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_376" ID="Odsetki11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_377" ID="Odsetki12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_420" ID="IloscPitB" XSDType="TCalkowity" HideEmptyOrZero="True"/>
    </PozycjeSzczegolowe>
  <Oswiadczenie>1</Oswiadczenie>
  <Pouczenia>1</Pouczenia>
  <Zalaczniki>
      <Zalacznik_PIT_B xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36/PIT_B(16)_Z36_v1-0E.xsd"
          xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36/"
          xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
          xmlns:zb36="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36/"
          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT/B (16)" wersjaSchemy="1-0E">PIT/B</KodFormularza>
            <WariantFormularza>16</WariantFormularza>
          </Naglowek>
          <Podmiot1>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
          </Podmiot1>
          <PozycjeSzczegolowe>
            <ea:XmlDataLabel runat="server" ElementName="P_3" ID="PITBCount" XSDType="TCalkowity" />
            <ea:Section ID="PitB1_B1" runat="server" Visible="False">
                <P_7>_</P_7>
                <ea:XmlDataLabel ID="PB1_P8" ElementName="P_8" runat="server" XSDType="TNrREGON"/>
                <ea:XmlDataLabel ID="PB1_P9" ElementName="P_9" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P10" ElementName="P_10" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P11" ElementName="P_11" runat="server" XSDType="TKwota2"/>
                <P_12>0</P_12>
            </ea:Section>
            <ea:Section ID="PitB1_B2" runat="server" Visible="False">
                <P_13>_</P_13>
                <ea:XmlDataLabel ID="PB1_P14" ElementName="P_14" runat="server" XSDType="TNrREGON"/>
                <ea:XmlDataLabel ID="PB1_P15" ElementName="P_15" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P16" ElementName="P_16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P17" ElementName="P_17" runat="server" XSDType="TKwota2"/>
                <P_18>0</P_18>
            </ea:Section>
            <ea:Section ID="PitB1_C1" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB1_P19" ElementName="P_19" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P20" ElementName="P_20" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB1_P21" ElementName="P_21" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB1_P22" ElementName="P_22" runat="server" XSDType="TNrREGON" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB1_P23" ElementName="P_23" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P24" ElementName="P_24" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P25" ElementName="P_25" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P26" ElementName="P_26" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P27" ElementName="P_27" runat="server" XSDType="TKwota2"/>
                <P_28>0</P_28>
                <P_29>0</P_29>
            </ea:Section>
            <ea:Section ID="PitB1_C2" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB1_P30" ElementName="P_30" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P31" ElementName="P_31" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB1_P32" ElementName="P_32" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB1_P33" ElementName="P_33" runat="server" XSDType="TNrREGON" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB1_P34" ElementName="P_34" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P35" ElementName="P_35" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P36" ElementName="P_36" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P37" ElementName="P_37" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P38" ElementName="P_38" runat="server" XSDType="TKwota2"/>
                <P_39>0</P_39>
                <P_40>0</P_40>
            </ea:Section>
            <ea:Section ID="PitB1_C3" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB1_P41" ElementName="P_41" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P42" ElementName="P_42" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB1_P43" ElementName="P_43" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB1_P44" ElementName="P_44" runat="server" XSDType="TNrREGON" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB1_P45" ElementName="P_45" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P46" ElementName="P_46" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P47" ElementName="P_47" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P48" ElementName="P_48" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P49" ElementName="P_49" runat="server" XSDType="TKwota2"/>
                <P_50>0</P_50>
                <P_51>0</P_51>
            </ea:Section>
            <P_56>2</P_56>
            <P_57>2</P_57>
          </PozycjeSzczegolowe>
      </Zalacznik_PIT_B>
      <ea:Section runat="server" ID="DrugiPitB" Visible="False">
        <Zalacznik_PIT_B xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36/PIT_B(16)_Z36_v1-0E.xsd"
        xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36/"
        xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
        xmlns:zb36="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36/"
        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT/B (16)" wersjaSchemy="1-0E">PIT/B</KodFormularza>
            <WariantFormularza>16</WariantFormularza>
          </Naglowek>
          <Podmiot1>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
          </Podmiot1>
          <PozycjeSzczegolowe>
            <ea:XmlDataLabel runat="server" ElementName="P_3" ID="PITBCount2" XSDType="TCalkowity" />
            <ea:Section ID="PitB2_B1" runat="server" Visible="False">
                <P_7>_</P_7>
                <ea:XmlDataLabel ID="PB2_P8" ElementName="P_8" runat="server" XSDType="TNrREGON"/>
                <ea:XmlDataLabel ID="PB2_P9" ElementName="P_9" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB2_P10" ElementName="P_10" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB2_P11" ElementName="P_11" runat="server" XSDType="TKwota2"/>
                <P_12>0</P_12>
            </ea:Section>
            <ea:Section ID="PitB2_B2" runat="server" Visible="False">
                <P_13>_</P_13>
                <ea:XmlDataLabel ID="PB2_P14" ElementName="P_14" runat="server" XSDType="TNrREGON"/>
                <ea:XmlDataLabel ID="PB2_P15" ElementName="P_15" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB2_P16" ElementName="P_16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB2_P17" ElementName="P_17" runat="server" XSDType="TKwota2"/>
                <P_18>0</P_18>
            </ea:Section>
            <ea:Section ID="PitB2_C1" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB2_P19" ElementName="P_19" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB2_P20" ElementName="P_20" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB2_P21" ElementName="P_21" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB2_P22" ElementName="P_22" runat="server" XSDType="TNrREGON" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB2_P23" ElementName="P_23" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB2_P24" ElementName="P_24" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB2_P25" ElementName="P_25" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB2_P26" ElementName="P_26" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB2_P27" ElementName="P_27" runat="server" XSDType="TKwota2"/>
                <P_28>0</P_28>
                <P_29>0</P_29>
            </ea:Section>
            <P_56>2</P_56>
            <P_57>2</P_57>
          </PozycjeSzczegolowe>
      </Zalacznik_PIT_B>
      </ea:Section>
  </Zalaczniki>
</Deklaracja>
