﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PIT5_16)dc[typeof(PIT5_16)];

        Rok.EditValue = dek.Rok;
        var us = (UrzadSkarbowy) dek.WlascicielHistoria.Podatki.UrzadSkarbowy;
        if (us != null)
            UrzSkarb.EditValue = us.KodUrzeduSkarbowego;
        var adres = dek.WlascicielHistoria.Adres;
        if (adres.Wojewodztwo != 0)
            Wojewodztwo.EditValue = CaptionAttribute.EnumToString(adres.Wojewodztwo).ToUpper();
        Powiat.EditValue = adres.Powiat.ToUpper();
        Gmina.EditValue = adres.Gmina.ToUpper();
        Ulica.EditValue = adres.Ulica;
        Ulica.Visible = adres.Ulica.Trim().Length > 0;
        NrDomu.EditValue = adres.NrDomu;
        NrLokalu.EditValue = adres.NrLokalu;
        NrLokalu.Visible = adres.NrLokalu.Trim().Length > 0;
        Miejscowosc.EditValue = adres.Miejscowosc;
        KodPocztowy.EditValue = adres.KodPocztowyS;

        if ((decimal) dek.Bloki["C"]["PrzychodNajem"] > 0m)
            SecNajem.Visible = true;

        if ((decimal) dek.Bloki["D"]["Straty"] > 0m)
            SecStraty.Visible = true;

        PITBCount.EditValue = IloscPitB.EditValue = 1;
        if (dek.Okres.EntireMonths == 3)
        {
            WyliczKwartaly(dek);
        }
        else
        {
            WyliczMiesiace(dek);
        }
        WyliczPitB(dek.Bloki);
    }

    void WyliczPitB(Deklaracja.BlokiIdx b)
    {
        PB_P7.EditValue = 0m;
        PB_P8.EditValue = 0m;
        if ((Percent)b["K1"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["K1"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["K1"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["K2"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["K2"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["K2"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["K3"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["K3"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["K3"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["K4"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["K4"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["K4"]["Koszty"];
            PitB_B1.Visible = true;
        }

        if ((Percent)b["K1"]["Udzial"] != Percent.Zero && (Percent)b["K1"]["Udzial"] != Percent.Hundred )
        {
            PB_C11_1.EditValue = b["K1"]["NazwaPelna"];
            PB_C12_1.EditValue = b["K1"]["Udzial"];
            PB_C13_1.EditValue = b["K1"]["Nip"];
            PB_C14_1.EditValue = (decimal) b["K1"]["Przychod"]/(Percent) b["K1"]["Udzial"];
            PB_C15_1.EditValue = b["K1"]["Przychod"];
            PB_C16_1.EditValue = (decimal) b["K1"]["Koszty"]/(Percent) b["K1"]["Udzial"];
            PB_C17_1.EditValue = b["K1"]["Koszty"];
            PitB_C1.Visible = true;
        }
        if ((Percent)b["K2"]["Udzial"] != Percent.Zero && (Percent)b["K2"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_2.EditValue = b["K2"]["NazwaPelna"];
            PB_C12_2.EditValue = b["K2"]["Udzial"];
            PB_C13_2.EditValue = b["K2"]["Nip"];
            PB_C14_2.EditValue = (decimal) b["K2"]["Przychod"]/(Percent) b["K2"]["Udzial"];
            PB_C15_2.EditValue = b["K2"]["Przychod"];
            PB_C16_2.EditValue = (decimal) b["K2"]["Koszty"]/(Percent) b["K2"]["Udzial"];
            PB_C17_2.EditValue = b["K2"]["Koszty"];
            PitB_C2.Visible = true;
        }
        if ((Percent)b["K3"]["Udzial"] != Percent.Zero && (Percent)b["K3"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_3.EditValue = b["K3"]["NazwaPelna"];
            PB_C12_3.EditValue = b["K3"]["Udzial"];
            PB_C13_3.EditValue = b["K3"]["Nip"];
            PB_C14_3.EditValue = (decimal) b["K3"]["Przychod"]/(Percent) b["K3"]["Udzial"];
            PB_C15_3.EditValue = b["K3"]["Przychod"];
            PB_C16_3.EditValue = (decimal) b["K3"]["Koszty"]/(Percent) b["K3"]["Udzial"];
            PB_C17_3.EditValue = b["K3"]["Koszty"];
            PitB_C3.Visible = true;
        }
        if ((Percent)b["K4"]["Udzial"] != Percent.Zero && (Percent)b["K4"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_4.EditValue = b["K4"]["NazwaPelna"];
            PB_C12_4.EditValue = b["K4"]["Udzial"];
            PB_C13_4.EditValue = b["K4"]["Nip"];
            PB_C14_4.EditValue = (decimal) b["K4"]["Przychod"]/(Percent) b["K4"]["Udzial"];
            PB_C15_4.EditValue = b["K4"]["Przychod"];
            PB_C16_4.EditValue = (decimal) b["K4"]["Koszty"]/(Percent) b["K4"]["Udzial"];
            PB_C17_4.EditValue = b["K4"]["Koszty"];
            PitB_C4.Visible = true;
        }
    }

    void WyliczKwartaly(Deklaracja dek)
    {
        Odsetki12.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty12.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki9.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty9.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki6.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty6.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki3.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty3.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
    }

    void WyliczMiesiace(Deklaracja dek)
    {
        Odsetki12.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty12.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki11.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty11.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki10.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty10.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki9.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty9.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki8.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty8.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki7.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty7.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki6.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty6.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki5.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty5.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki4.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty4.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki3.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty3.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki2.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty2.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki1.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty1.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT5_16,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:schemaLocation="http://crd.gov.pl/wzor/2020/01/21/9033/ http://crd.gov.pl/wzor/2020/01/21/9033/schemat.xsd"
            xmlns="http://crd.gov.pl/wzor/2020/01/21/9033/"
            xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <Naglowek>
        <KodFormularza kodSystemowy="PIT-36 (27)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="1-1E">PIT-36</KodFormularza>
        <WariantFormularza>27</WariantFormularza>
        <CelZlozenia poz="P_10">1</CelZlozenia>
        <ea:XmlDataLabel ID="Rok" ElementName="Rok" runat="server" XSDType="TCalkowity" />
        <ea:XmlDataLabel ID="UrzSkarb" ElementName="KodUrzedu" runat="server" />
    </Naglowek>
    <Podmiot1 rola="Podatnik">
        <etd:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
        </etd:OsobaFizyczna>
        <etd:AdresZamieszkania rodzajAdresu="RAD">
            <etd:AdresPol>
                <etd:KodKraju>PL</etd:KodKraju>
                <ea:XmlDataLabel ID="Wojewodztwo" ElementName="etd:Wojewodztwo" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Powiat" ElementName="etd:Powiat" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Gmina" ElementName="etd:Gmina" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Ulica" ElementName="etd:Ulica" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="NrDomu" ElementName="etd:NrDomu" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="NrLokalu" ElementName="etd:NrLokalu" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Miejscowosc" ElementName="etd:Miejscowosc" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="KodPocztowy" ElementName="etd:KodPocztowy" runat="server" XSDType="TTekstowy"/>
            </etd:AdresPol>
        </etd:AdresZamieszkania>
    </Podmiot1>
    <PozycjeSzczegolowe>
        <P_6>1</P_6>
        <ea:Section runat="server" ID="SecNajem" Visible="False">
            <ea:XmlDataLabel runat="server" ElementName="P_91" DataMember="C.PrzychodNajem" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_92" DataMember="C.KosztyNajem" XSDType="TKwota2" />
            <P_93>0</P_93>
            <P_95>0</P_95>
	    </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_181" DataMember="D.DochodZwolniony" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <ea:Section runat="server" ID="SecStraty" Visible="False">
            <P_185_1>_</P_185_1>
            <ea:XmlDataLabel runat="server" ElementName="P_186" DataMember="D.Straty" XSDType="TKwota2" HideEmptyOrZero="True"/>
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_188" DataMember="E1.Spoleczne" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_221>0</P_221>
        <P_224>0</P_224>
        <P_225>0</P_225>
        <P_229>0</P_229>
        <ea:XmlDataLabel runat="server" ElementName="P_230" DataMember="J2.Zdrowotne" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_236>0</P_236>
        <P_238>0</P_238>
        <P_239>0</P_239>
        <P_240>0</P_240>
        <ea:XmlDataLabel runat="server" ElementName="P_242" ID="DoZaplaty1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_243" ID="DoZaplaty2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_244" ID="DoZaplaty3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_245" ID="DoZaplaty4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_246" ID="DoZaplaty5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_247" ID="DoZaplaty6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_266" ID="DoZaplaty7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_267" ID="DoZaplaty8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_268" ID="DoZaplaty9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_269" ID="DoZaplaty10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_270" ID="DoZaplaty11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_271" ID="DoZaplaty12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <P_351>0</P_351>
        <P_363>0</P_363>
        <ea:XmlDataLabel runat="server" ElementName="P_391" ID="Odsetki1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_392" ID="Odsetki2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_393" ID="Odsetki3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_394" ID="Odsetki4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_395" ID="Odsetki5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_396" ID="Odsetki6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_397" ID="Odsetki7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_398" ID="Odsetki8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_399" ID="Odsetki9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_400" ID="Odsetki10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_401" ID="Odsetki11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_402" ID="Odsetki12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_445" ID="IloscPitB" XSDType="TCalkowity" HideEmptyOrZero="True"/>
    </PozycjeSzczegolowe>
  <Oswiadczenie>1</Oswiadczenie>
  <Pouczenia>1</Pouczenia>
  <Zalaczniki>
      <Zalacznik_PIT_B xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/01/14/eD/PITB36/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/01/14/eD/PITB36/PIT_B(17)_Z36_v1-0E.xsd"
          xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/01/14/eD/PITB36/"
          xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
          xmlns:zb36="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/01/14/eD/PITB36/"
          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT/B (17)" wersjaSchemy="1-0E">PIT/B</KodFormularza>
            <WariantFormularza>17</WariantFormularza>
          </Naglowek>
          <Podmiot1>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
          </Podmiot1>
          <PozycjeSzczegolowe>
            <ea:XmlDataLabel runat="server" ElementName="P_3" ID="PITBCount" XSDType="TCalkowity" />
            <ea:Section ID="PitB_B1" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB_P7" ElementName="P_7" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_P8" ElementName="P_8" runat="server" XSDType="TKwota2"/>
            </ea:Section>
            <P_9>0</P_9>
            <ea:Section ID="PitB_C1" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_1" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_1" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_1" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_1" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_1" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_1" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_1" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C2" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_2" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_2" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_2" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_2" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_2" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_2" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_2" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C3" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_3" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_3" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_3" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_3" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_3" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_3" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_3" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C4" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_4" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_4" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_4" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_4" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_4" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_4" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_4" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
          </PozycjeSzczegolowe>
      </Zalacznik_PIT_B>      
  </Zalaczniki>
</Deklaracja>
