﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PIT5_2022_2)dc[typeof(PIT5_2022_2)];

        Rok.EditValue = dek.Rok;
        var us = (UrzadSkarbowy) dek.WlascicielHistoria.Podatki.UrzadSkarbowy;
        if (us != null)
            UrzSkarb.EditValue = us.KodUrzeduSkarbowego;
        var adres = dek.WlascicielHistoria.Adres;
        if (adres.Wojewodztwo != 0)
            Wojewodztwo.EditValue = CaptionAttribute.EnumToString(adres.Wojewodztwo).ToUpper();
        Powiat.EditValue = adres.Powiat.ToUpper();
        Gmina.EditValue = adres.Gmina.ToUpper();
        Ulica.EditValue = adres.Ulica;
        Ulica.Visible = adres.Ulica.Trim().Length > 0;
        NrDomu.EditValue = adres.NrDomu;
        NrLokalu.EditValue = adres.NrLokalu;
        NrLokalu.Visible = adres.NrLokalu.Trim().Length > 0;
        Miejscowosc.EditValue = adres.Miejscowosc;
        KodPocztowy.EditValue = adres.KodPocztowyS;

        if ((decimal) dek.Bloki["C"]["PrzychodNajem"] > 0m)
            SecNajem.Visible = true;

        if ((decimal) dek.Bloki["D"]["Straty"] > 0m)
            SecStraty.Visible = true;

        IloscPitB.EditValue = 1;
        if (dek.ZaliczkaKwartalna)
        {
            WyliczKwartaly(dek);
        }
        else
        {
            WyliczMiesiace(dek);
        }
        WyliczPitB(dek.Bloki);
    }

    void WyliczPitB(Deklaracja.BlokiIdx b)
    {
        PB_P7.EditValue = 0m;
        PB_P8.EditValue = 0m;

        if ((Percent)b["K1"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["K1"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["K1"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["K2"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["K2"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["K2"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["K3"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["K3"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["K3"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["K4"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["K4"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["K4"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["ZK5"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["ZK5"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["ZK5"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["ZK6"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["ZK6"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["ZK6"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["ZK7"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["ZK7"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["ZK7"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["ZK8"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["ZK8"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["ZK8"]["Koszty"];
            PitB_B1.Visible = true;
        }

        if ((Percent)b["K1"]["Udzial"] != Percent.Zero && (Percent)b["K1"]["Udzial"] != Percent.Hundred )
        {
            PB_C11_1.EditValue = b["K1"]["NazwaPelna"];
            PB_C12_1.EditValue = b["K1"]["Udzial"];
            PB_C13_1.EditValue = b["K1"]["Nip"];
            PB_C14_1.EditValue = (decimal) b["K1"]["Przychod"]/(Percent) b["K1"]["Udzial"];
            PB_C15_1.EditValue = b["K1"]["Przychod"];
            PB_C16_1.EditValue = (decimal) b["K1"]["Koszty"]/(Percent) b["K1"]["Udzial"];
            PB_C17_1.EditValue = b["K1"]["Koszty"];
            PitB_C1.Visible = true;
        }
        if ((Percent)b["K2"]["Udzial"] != Percent.Zero && (Percent)b["K2"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_2.EditValue = b["K2"]["NazwaPelna"];
            PB_C12_2.EditValue = b["K2"]["Udzial"];
            PB_C13_2.EditValue = b["K2"]["Nip"];
            PB_C14_2.EditValue = (decimal) b["K2"]["Przychod"]/(Percent) b["K2"]["Udzial"];
            PB_C15_2.EditValue = b["K2"]["Przychod"];
            PB_C16_2.EditValue = (decimal) b["K2"]["Koszty"]/(Percent) b["K2"]["Udzial"];
            PB_C17_2.EditValue = b["K2"]["Koszty"];
            PitB_C2.Visible = true;
        }
        if ((Percent)b["K3"]["Udzial"] != Percent.Zero && (Percent)b["K3"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_3.EditValue = b["K3"]["NazwaPelna"];
            PB_C12_3.EditValue = b["K3"]["Udzial"];
            PB_C13_3.EditValue = b["K3"]["Nip"];
            PB_C14_3.EditValue = (decimal) b["K3"]["Przychod"]/(Percent) b["K3"]["Udzial"];
            PB_C15_3.EditValue = b["K3"]["Przychod"];
            PB_C16_3.EditValue = (decimal) b["K3"]["Koszty"]/(Percent) b["K3"]["Udzial"];
            PB_C17_3.EditValue = b["K3"]["Koszty"];
            PitB_C3.Visible = true;
        }
        if ((Percent)b["K4"]["Udzial"] != Percent.Zero && (Percent)b["K4"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_4.EditValue = b["K4"]["NazwaPelna"];
            PB_C12_4.EditValue = b["K4"]["Udzial"];
            PB_C13_4.EditValue = b["K4"]["Nip"];
            PB_C14_4.EditValue = (decimal) b["K4"]["Przychod"]/(Percent) b["K4"]["Udzial"];
            PB_C15_4.EditValue = b["K4"]["Przychod"];
            PB_C16_4.EditValue = (decimal) b["K4"]["Koszty"]/(Percent) b["K4"]["Udzial"];
            PB_C17_4.EditValue = b["K4"]["Koszty"];
            PitB_C4.Visible = true;
        }
        if ((Percent)b["ZK5"]["Udzial"] != Percent.Zero && (Percent)b["ZK5"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_5.EditValue = b["ZK5"]["NazwaPelna"];
            PB_C12_5.EditValue = b["ZK5"]["Udzial"];
            PB_C13_5.EditValue = b["ZK5"]["Nip"];
            PB_C14_5.EditValue = (decimal) b["ZK5"]["Przychod"]/(Percent) b["ZK5"]["Udzial"];
            PB_C15_5.EditValue = b["ZK5"]["Przychod"];
            PB_C16_5.EditValue = (decimal) b["ZK5"]["Koszty"]/(Percent) b["ZK5"]["Udzial"];
            PB_C17_5.EditValue = b["ZK5"]["Koszty"];
            PitB_C5.Visible = true;
        }
        if ((Percent)b["ZK6"]["Udzial"] != Percent.Zero && (Percent)b["ZK6"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_6.EditValue = b["ZK6"]["NazwaPelna"];
            PB_C12_6.EditValue = b["ZK6"]["Udzial"];
            PB_C13_6.EditValue = b["ZK6"]["Nip"];
            PB_C14_6.EditValue = (decimal) b["ZK6"]["Przychod"]/(Percent) b["ZK6"]["Udzial"];
            PB_C15_6.EditValue = b["ZK6"]["Przychod"];
            PB_C16_6.EditValue = (decimal) b["ZK6"]["Koszty"]/(Percent) b["ZK6"]["Udzial"];
            PB_C17_6.EditValue = b["ZK6"]["Koszty"];
            PitB_C6.Visible = true;
        }
        if ((Percent)b["ZK7"]["Udzial"] != Percent.Zero && (Percent)b["ZK7"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_7.EditValue = b["ZK7"]["NazwaPelna"];
            PB_C12_7.EditValue = b["ZK7"]["Udzial"];
            PB_C13_7.EditValue = b["ZK7"]["Nip"];
            PB_C14_7.EditValue = (decimal) b["ZK7"]["Przychod"]/(Percent) b["ZK7"]["Udzial"];
            PB_C15_7.EditValue = b["ZK7"]["Przychod"];
            PB_C16_7.EditValue = (decimal) b["ZK7"]["Koszty"]/(Percent) b["ZK7"]["Udzial"];
            PB_C17_7.EditValue = b["ZK7"]["Koszty"];
            PitB_C7.Visible = true;
        }
        if ((Percent)b["ZK8"]["Udzial"] != Percent.Zero && (Percent)b["ZK8"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_8.EditValue = b["ZK8"]["NazwaPelna"];
            PB_C12_8.EditValue = b["ZK8"]["Udzial"];
            PB_C13_8.EditValue = b["ZK8"]["Nip"];
            PB_C14_8.EditValue = (decimal) b["ZK8"]["Przychod"]/(Percent) b["ZK8"]["Udzial"];
            PB_C15_8.EditValue = b["ZK8"]["Przychod"];
            PB_C16_8.EditValue = (decimal) b["ZK8"]["Koszty"]/(Percent) b["ZK8"]["Udzial"];
            PB_C17_8.EditValue = b["ZK8"]["Koszty"];
            PitB_C8.Visible = true;
        }
    }

    void WyliczKwartaly(Deklaracja dek)
    {

        var doZaplaty12 = 0m;
        var doZaplaty9 = 0m;
        var doZaplaty6 = 0m;
        var doZaplaty3 = 0m;
        var liczbaDeklaracji = 12;

        for(int i = liczbaDeklaracji; i > 0; i--)
        {
            if(i > 9 && i <= 12)
            {
                if(i == 12)
                    Odsetki12.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
                doZaplaty12 += Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
            }
            else if(i > 6 && i <= 9)
            {
                if(i == 9)
                    Odsetki9.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
                doZaplaty9 += Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);               
            }
            else if(i > 3 && i <= 6)
            {
                if(i == 6)
                    Odsetki6.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
                doZaplaty6 += Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
            }
            else
            {
                if(i == 3)
                    Odsetki3.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
                doZaplaty3 += Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
            }

            if (dek.Poprzednia == null) break;
            dek = dek.Poprzednia;
        }

        DoZaplaty12.EditValue = doZaplaty12 < 0 ? 0m : doZaplaty12;
        DoZaplaty9.EditValue = doZaplaty9 < 0 ? 0m : doZaplaty9;
        DoZaplaty6.EditValue = doZaplaty6 < 0 ? 0m : doZaplaty6;
        DoZaplaty3.EditValue = doZaplaty3 < 0 ? 0m : doZaplaty3; 
    }

    void WyliczMiesiace(Deklaracja dek)
    {
        Odsetki12.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty12.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki11.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty11.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki10.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty10.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki9.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty9.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki8.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty8.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki7.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty7.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki6.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty6.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki5.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty5.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki4.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty4.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki3.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty3.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki2.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty2.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki1.EditValue = Math.Round((decimal) dek.Bloki["J5"]["Odsetki"]);
        DoZaplaty1.EditValue = Math.Round((decimal) dek.Bloki["J5"]["DoZaplaty"]);
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT5_2022_2,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:schemaLocation="http://crd.gov.pl/wzor/2023/03/30/12369/ http://crd.gov.pl/wzor/2023/03/30/12369/schemat.xsd"
            xmlns="http://crd.gov.pl/wzor/2023/03/30/12369/"
            xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/DefinicjeTypy/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <Naglowek>
        <KodFormularza kodSystemowy="PIT-36 (30)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="2-0E">PIT-36</KodFormularza>
        <WariantFormularza>30</WariantFormularza>
        <CelZlozenia poz="P_10">1</CelZlozenia>
        <ea:XmlDataLabel ID="Rok" ElementName="Rok" runat="server" XSDType="TCalkowity" />
        <ea:XmlDataLabel ID="UrzSkarb" ElementName="KodUrzedu" runat="server" />
    </Naglowek>
    <Podmiot1 rola="Podatnik">
        <OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
        </OsobaFizyczna>
        <AdresZamieszkania rodzajAdresu="RAD">
            <AdresPol>
                <KodKraju>PL</KodKraju>
                <ea:XmlDataLabel ID="Wojewodztwo" ElementName="Wojewodztwo" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Powiat" ElementName="Powiat" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Gmina" ElementName="Gmina" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Ulica" ElementName="Ulica" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="NrDomu" ElementName="NrDomu" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="NrLokalu" ElementName="NrLokalu" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="Miejscowosc" ElementName="Miejscowosc" runat="server" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ID="KodPocztowy" ElementName="KodPocztowy" runat="server" XSDType="TTekstowy"/>
            </AdresPol>
        </AdresZamieszkania>
    </Podmiot1>
    <PozycjeSzczegolowe>
        <P_6>1</P_6>
        <ea:Section runat="server" ID="SecNajem" Visible="False">
            <ea:XmlDataLabel runat="server" ElementName="P_117" DataMember="C.PrzychodNajem" XSDType="TKwota2" />
            <ea:XmlDataLabel runat="server" ElementName="P_118" DataMember="C.KosztyNajem" XSDType="TKwota2" />
            <P_119>0</P_119>
	    </ea:Section>

        <ea:Section runat="server" ID="SecStraty" Visible="False">
            <P_217_1>_</P_217_1>
            <ea:XmlDataLabel runat="server" ElementName="P_218" DataMember="D.Straty" XSDType="TKwota2" HideEmptyOrZero="True"/>
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_220" DataMember="E1.Spoleczne" XSDType="TKwota2" HideEmptyOrZero="True"/> 
        <P_302>0</P_302>
        <P_305>0</P_305>
        <P_306>0</P_306>
        <P_311>0</P_311>
        <P_314>0</P_314>
        <P_316>0</P_316>
        <P_318>0</P_318>
        <ea:XmlDataLabel runat="server" ElementName="P_320" ID="DoZaplaty1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_321" ID="DoZaplaty2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_322" ID="DoZaplaty3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_323" ID="DoZaplaty4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_324" ID="DoZaplaty5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_325" ID="DoZaplaty6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_344" ID="DoZaplaty7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_345" ID="DoZaplaty8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_346" ID="DoZaplaty9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_347" ID="DoZaplaty10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_348" ID="DoZaplaty11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_349" ID="DoZaplaty12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <P_429>0</P_429>
        <P_443>0</P_443>
        <ea:XmlDataLabel runat="server" ElementName="P_471" ID="Odsetki1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_472" ID="Odsetki2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_473" ID="Odsetki3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_474" ID="Odsetki4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_475" ID="Odsetki5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_476" ID="Odsetki6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_477" ID="Odsetki7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_478" ID="Odsetki8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_479" ID="Odsetki9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_480" ID="Odsetki10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_481" ID="Odsetki11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_482" ID="Odsetki12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_525" ID="IloscPitB" XSDType="TCalkowity" HideEmptyOrZero="True"/>
    </PozycjeSzczegolowe>
  <Oswiadczenie>1</Oswiadczenie>  
  <Zalaczniki>
      <Zalacznik_PIT_B xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/05/eD/PITB36/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/05/eD/PITB36/PIT_B(20)_Z36_v1-0E.xsd"
          xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/05/eD/PITB36/"
          xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/DefinicjeTypy/"
          xmlns:zb36="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/05/eD/PITB36/"
          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT/B (20)" wersjaSchemy="1-0E">PIT/B</KodFormularza>
            <WariantFormularza>20</WariantFormularza>
          </Naglowek>
          <Podmiot1>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
          </Podmiot1>
          <PozycjeSzczegolowe>
            <ea:Section ID="PitB_B1" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB_P7" ElementName="P_7" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_P8" ElementName="P_8" runat="server" XSDType="TKwota2"/>
                <P_9>0</P_9>
            </ea:Section>
            <ea:Section ID="PitB_C1" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_1" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_1" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_1" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_1" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_1" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_1" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_1" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C2" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_2" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_2" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_2" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_2" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_2" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_2" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_2" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C3" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_3" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_3" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_3" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_3" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_3" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_3" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_3" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C4" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_4" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_4" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_4" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_4" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_4" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_4" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_4" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
              <ea:Section ID="PitB_C5" runat="server" Visible="False">
                  <P_C typ="G">
                      <ea:XmlDataLabel ID="PB_C11_5" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                      <ea:XmlDataLabel ID="PB_C12_5" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                      <ea:XmlDataLabel ID="PB_C13_5" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                      <ea:XmlDataLabel ID="PB_C14_5" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C15_5" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C16_5" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C17_5" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                      <P_C18>0</P_C18>
                      <P_C19>0</P_C19>
                  </P_C>
              </ea:Section>
              <ea:Section ID="PitB_C6" runat="server" Visible="False">
                  <P_C typ="G">
                      <ea:XmlDataLabel ID="PB_C11_6" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                      <ea:XmlDataLabel ID="PB_C12_6" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                      <ea:XmlDataLabel ID="PB_C13_6" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                      <ea:XmlDataLabel ID="PB_C14_6" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C15_6" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C16_6" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C17_6" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                      <P_C18>0</P_C18>
                      <P_C19>0</P_C19>
                  </P_C>
              </ea:Section>
              <ea:Section ID="PitB_C7" runat="server" Visible="False">
                  <P_C typ="G">
                      <ea:XmlDataLabel ID="PB_C11_7" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                      <ea:XmlDataLabel ID="PB_C12_7" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                      <ea:XmlDataLabel ID="PB_C13_7" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                      <ea:XmlDataLabel ID="PB_C14_7" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C15_7" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C16_7" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C17_7" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                      <P_C18>0</P_C18>
                      <P_C19>0</P_C19>
                  </P_C>
              </ea:Section>
              <ea:Section ID="PitB_C8" runat="server" Visible="False">
                  <P_C typ="G">
                      <ea:XmlDataLabel ID="PB_C11_8" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                      <ea:XmlDataLabel ID="PB_C12_8" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                      <ea:XmlDataLabel ID="PB_C13_8" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                      <ea:XmlDataLabel ID="PB_C14_8" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C15_8" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C16_8" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C17_8" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                      <P_C18>0</P_C18>
                      <P_C19>0</P_C19>
                  </P_C>
              </ea:Section>
          </PozycjeSzczegolowe>
      </Zalacznik_PIT_B>      
  </Zalaczniki>
  <Pouczenia>1</Pouczenia>
</Deklaracja>
