﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PIT5L_4)dc[typeof(PIT5L_4)];
        Rok.EditValue = dek.Rok;
        var us = (UrzadSkarbowy) dek.WlascicielHistoria.Podatki.UrzadSkarbowy;
        if (us != null)
            UrzSkarb.EditValue = us.KodUrzeduSkarbowego;

        Straty.Visible = ((decimal)dek.Bloki["D"]["Straty"]) > 0m;
        PITBCount.EditValue = PITBCount2.EditValue = IloscPitB.EditValue = 1;
        if (dek.Okres.EntireMonths == 3)
        {
            WyliczKwartaly(dek);
        }
        else
        {
            WyliczMiesiace(dek);
        }
        WyliczPitB(dek.Bloki);
    }

    void DrugiPitBVisible()
    {
        DrugiPitB.Visible = true;
        PITBCount.EditValue = PITBCount2.EditValue = IloscPitB.EditValue = 2;
    }

    void WyliczPitB(Deklaracja.BlokiIdx b)
    {
        if ((Percent)b["H1"]["Udzial"] == Percent.Hundred)
        {
            PB1_P8.EditValue = b["H1"]["Regon"];
            PB1_P9.EditValue = b["H1"]["MiejsceProwadzenia"];
            PB1_P10.EditValue = b["H1"]["Przychod"];
            PB1_P11.EditValue = b["H1"]["Koszty"];
            PitB1_B1.Visible = true;
        }
        else if ((Percent)b["H1"]["Udzial"] != Percent.Zero)
        {
            PB1_P19.EditValue = b["H1"]["NazwaPelna"];
            PB1_P20.EditValue = b["H1"]["Udzial"];
            PB1_P21.EditValue = b["H1"]["Nip"];
            PB1_P22.EditValue = b["H1"]["Regon"];
            PB1_P23.EditValue = b["H1"]["MiejsceProwadzenia"];
            PB1_P24.EditValue = (decimal) b["H1"]["Przychod"]/(Percent) b["H1"]["Udzial"];
            PB1_P25.EditValue = b["H1"]["Przychod"];
            PB1_P26.EditValue = (decimal) b["H1"]["Koszty"]/(Percent) b["H1"]["Udzial"];
            PB1_P27.EditValue = b["H1"]["Koszty"];
            PitB1_C1.Visible = true;
        }
        if ((Percent)b["H2"]["Udzial"] == Percent.Hundred)
        {
            PB1_P14.EditValue = b["H2"]["Regon"];
            PB1_P15.EditValue = b["H2"]["MiejsceProwadzenia"];
            PB1_P16.EditValue = b["H2"]["Przychod"];
            PB1_P17.EditValue = b["H2"]["Koszty"];
            PitB1_B2.Visible = true;
        }
        else if ((Percent)b["H2"]["Udzial"] != Percent.Zero)
        {
            PB1_P30.EditValue = b["H2"]["NazwaPelna"];
            PB1_P31.EditValue = b["H2"]["Udzial"];
            PB1_P32.EditValue = b["H2"]["Nip"];
            PB1_P33.EditValue = b["H2"]["Regon"];
            PB1_P34.EditValue = b["H2"]["MiejsceProwadzenia"];
            PB1_P35.EditValue = (decimal) b["H2"]["Przychod"]/(Percent) b["H2"]["Udzial"];
            PB1_P36.EditValue = b["H2"]["Przychod"];
            PB1_P37.EditValue = (decimal) b["H2"]["Koszty"]/(Percent) b["H2"]["Udzial"];
            PB1_P38.EditValue = b["H2"]["Koszty"];
            PitB1_C2.Visible = true;
        }
        if ((Percent)b["H3"]["Udzial"] == Percent.Hundred)
        {
            PB2_P8.EditValue = b["H3"]["Regon"];
            PB2_P9.EditValue = b["H3"]["MiejsceProwadzenia"];
            PB2_P10.EditValue = b["H3"]["Przychod"];
            PB2_P11.EditValue = b["H3"]["Koszty"];
            PitB2_B1.Visible = true;
            DrugiPitBVisible();
        }
        else if ((Percent)b["H3"]["Udzial"] != Percent.Zero)
        {
            PB1_P41.EditValue = b["H3"]["NazwaPelna"];
            PB1_P42.EditValue = b["H3"]["Udzial"];
            PB1_P43.EditValue = b["H3"]["Nip"];
            PB1_P44.EditValue = b["H3"]["Regon"];
            PB1_P45.EditValue = b["H3"]["MiejsceProwadzenia"];
            PB1_P46.EditValue = (decimal) b["H3"]["Przychod"]/(Percent) b["H3"]["Udzial"];
            PB1_P47.EditValue = b["H3"]["Przychod"];
            PB1_P48.EditValue = (decimal) b["H3"]["Koszty"]/(Percent) b["H3"]["Udzial"];
            PB1_P49.EditValue = b["H3"]["Koszty"];
            PitB1_C3.Visible = true;
        }
        if ((Percent)b["H4"]["Udzial"] == Percent.Hundred)
        {
            PB2_P14.EditValue = b["H4"]["Regon"];
            PB2_P15.EditValue = b["H4"]["MiejsceProwadzenia"];
            PB2_P16.EditValue = b["H4"]["Przychod"];
            PB2_P17.EditValue = b["H4"]["Koszty"];
            PitB1_B2.Visible = true;
            DrugiPitBVisible();
        }
        else if ((Percent)b["H4"]["Udzial"] != Percent.Zero)
        {
            PB2_P19.EditValue = b["H4"]["NazwaPelna"];
            PB2_P20.EditValue = b["H4"]["Udzial"];
            PB2_P21.EditValue = b["H4"]["Nip"];
            PB2_P22.EditValue = b["H4"]["Regon"];
            PB2_P23.EditValue = b["H4"]["MiejsceProwadzenia"];
            PB2_P24.EditValue = (decimal) b["H4"]["Przychod"]/(Percent) b["H4"]["Udzial"];
            PB2_P25.EditValue = b["H4"]["Przychod"];
            PB2_P26.EditValue = (decimal) b["H4"]["Koszty"]/(Percent) b["H4"]["Udzial"];
            PB2_P27.EditValue = b["H4"]["Koszty"];
            PitB2_C1.Visible = true;
            DrugiPitBVisible();
        }
    }

    void WyliczKwartaly(Deklaracja dek)
    {
        Odsetki12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
    }

    void WyliczMiesiace(Deklaracja dek)
    {
        Odsetki12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki11.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty11.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki10.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty10.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki8.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty8.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki7.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty7.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki5.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty5.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki4.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty4.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki2.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty2.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki1.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty1.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT5L_4,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:schemaLocation="http://crd.gov.pl/wzor/2018/12/10/6351/ http://crd.gov.pl/wzor/2018/12/10/6351/schemat.xsd"
            xmlns="http://crd.gov.pl/wzor/2018/12/10/6351/"
            xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <Naglowek>
        <KodFormularza kodSystemowy="PIT36L (15)" kodPodatku="PPL" rodzajZobowiazania="Z" wersjaSchemy="1-0E">PIT-36L</KodFormularza>
        <WariantFormularza>15</WariantFormularza>
        <CelZlozenia poz="P_6">1</CelZlozenia>
        <ea:XmlDataLabel ID="Rok" ElementName="Rok" runat="server" XSDType="TCalkowity" />
        <ea:XmlDataLabel ID="UrzSkarb" ElementName="KodUrzedu" runat="server" />
    </Naglowek>
    <Podmiot1 rola="Podatnik">
        <OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
        </OsobaFizyczna>
    </Podmiot1>
    <PozycjeSzczegolowe>
        <ea:Section ID="Straty" runat="server" Visible="False">
            <P_24>_</P_24>
            <ea:XmlDataLabel runat="server" ElementName="P_25" DataMember="D.Straty" XSDType="TKwota2"/>
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_27" DataMember="D.Spoleczne" XSDType="TKwota2"/>
        <P_31>0</P_31>
        <P_41>0</P_41>
        <P_42>0</P_42>
        <P_43>0</P_43>
        <P_46>0</P_46>
        <ea:XmlDataLabel runat="server" ElementName="P_47" DataMember="G2.Zdrowotne" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_51>0</P_51>
        <P_52>0</P_52>
        <P_53>0</P_53>
        <P_54>0</P_54>
        <ea:XmlDataLabel runat="server" ElementName="P_56" ID="DoZaplaty1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_57" ID="DoZaplaty2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_58" ID="DoZaplaty3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_59" ID="DoZaplaty4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_60" ID="DoZaplaty5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_61" ID="DoZaplaty6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_80" ID="DoZaplaty7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_81" ID="DoZaplaty8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_82" ID="DoZaplaty9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_83" ID="DoZaplaty10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_84" ID="DoZaplaty11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_85" ID="DoZaplaty12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <P_108>0</P_108>
        <ea:XmlDataLabel runat="server" ElementName="P_110" DataMember="G5.Remanent" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_114>0</P_114>
        <ea:XmlDataLabel runat="server" ElementName="P_128" ID="Odsetki1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_129" ID="Odsetki2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_130" ID="Odsetki3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_131" ID="Odsetki4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_132" ID="Odsetki5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_133" ID="Odsetki6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_134" ID="Odsetki7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_135" ID="Odsetki8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_136" ID="Odsetki9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_137" ID="Odsetki10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_138" ID="Odsetki11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_139" ID="Odsetki12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_146" ID="IloscPitB" XSDType="TCalkowity" HideEmptyOrZero="True"/>
    </PozycjeSzczegolowe>
  <Pouczenia>1</Pouczenia>
  <Zalaczniki>
      <Zalacznik_PIT_B xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36L/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36L/PIT_B(16)_Z36L_v1-0E.xsd"
          xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36L/"
          xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT/B (16)" wersjaSchemy="1-0E">PIT/B</KodFormularza>
            <WariantFormularza>16</WariantFormularza>
          </Naglowek>
          <PozycjeSzczegolowe>
            <ea:XmlDataLabel runat="server" ElementName="P_3" ID="PITBCount" XSDType="TCalkowity" />
            <ea:Section ID="PitB1_B1" runat="server" Visible="False">
                <P_7>_</P_7>
                <ea:XmlDataLabel ID="PB1_P8" ElementName="P_8" runat="server" XSDType="TNrREGON"/>
                <ea:XmlDataLabel ID="PB1_P9" ElementName="P_9" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P10" ElementName="P_10" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P11" ElementName="P_11" runat="server" XSDType="TKwota2"/>
                <P_12>0</P_12>
            </ea:Section>
            <ea:Section ID="PitB1_B2" runat="server" Visible="False">
                <P_13>_</P_13>
                <ea:XmlDataLabel ID="PB1_P14" ElementName="P_14" runat="server" XSDType="TNrREGON"/>
                <ea:XmlDataLabel ID="PB1_P15" ElementName="P_15" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P16" ElementName="P_16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P17" ElementName="P_17" runat="server" XSDType="TKwota2"/>
                <P_18>0</P_18>
            </ea:Section>
            <ea:Section ID="PitB1_C1" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB1_P19" ElementName="P_19" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P20" ElementName="P_20" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB1_P21" ElementName="P_21" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB1_P22" ElementName="P_22" runat="server" XSDType="TNrREGON" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB1_P23" ElementName="P_23" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P24" ElementName="P_24" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P25" ElementName="P_25" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P26" ElementName="P_26" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P27" ElementName="P_27" runat="server" XSDType="TKwota2"/>
                <P_28>0</P_28>
                <P_29>0</P_29>
            </ea:Section>
            <ea:Section ID="PitB1_C2" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB1_P30" ElementName="P_30" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P31" ElementName="P_31" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB1_P32" ElementName="P_32" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB1_P33" ElementName="P_33" runat="server" XSDType="TNrREGON" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB1_P34" ElementName="P_34" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P35" ElementName="P_35" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P36" ElementName="P_36" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P37" ElementName="P_37" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P38" ElementName="P_38" runat="server" XSDType="TKwota2"/>
                <P_39>0</P_39>
                <P_40>0</P_40>
            </ea:Section>
            <ea:Section ID="PitB1_C3" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB1_P41" ElementName="P_41" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P42" ElementName="P_42" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB1_P43" ElementName="P_43" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB1_P44" ElementName="P_44" runat="server" XSDType="TNrREGON" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB1_P45" ElementName="P_45" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB1_P46" ElementName="P_46" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P47" ElementName="P_47" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P48" ElementName="P_48" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB1_P49" ElementName="P_49" runat="server" XSDType="TKwota2"/>
                <P_50>0</P_50>
                <P_51>0</P_51>
            </ea:Section>
            <P_56>2</P_56>
            <P_57>2</P_57>
          </PozycjeSzczegolowe>
      </Zalacznik_PIT_B>
      <ea:Section runat="server" ID="DrugiPitB" Visible="False">
          <Zalacznik_PIT_B xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36L/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36L/PIT_B(16)_Z36L_v1-0E.xsd"
                           xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/11/30/eD/PITB36L/"
                           xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
                           xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT/B (16)" wersjaSchemy="1-0E">PIT/B</KodFormularza>
            <WariantFormularza>16</WariantFormularza>
          </Naglowek>
          <PozycjeSzczegolowe>
            <ea:XmlDataLabel runat="server" ElementName="P_3" ID="PITBCount2" XSDType="TCalkowity" />
            <ea:Section ID="PitB2_B1" runat="server" Visible="False">
                <P_7>_</P_7>
                <ea:XmlDataLabel ID="PB2_P8" ElementName="P_8" runat="server" XSDType="TNrREGON"/>
                <ea:XmlDataLabel ID="PB2_P9" ElementName="P_9" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB2_P10" ElementName="P_10" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB2_P11" ElementName="P_11" runat="server" XSDType="TKwota2"/>
                <P_12>0</P_12>
            </ea:Section>
            <ea:Section ID="PitB2_B2" runat="server" Visible="False">
                <P_13>_</P_13>
                <ea:XmlDataLabel ID="PB2_P14" ElementName="P_14" runat="server" XSDType="TNrREGON"/>
                <ea:XmlDataLabel ID="PB2_P15" ElementName="P_15" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB2_P16" ElementName="P_16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB2_P17" ElementName="P_17" runat="server" XSDType="TKwota2"/>
                <P_18>0</P_18>
            </ea:Section>
            <ea:Section ID="PitB2_C1" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB2_P19" ElementName="P_19" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB2_P20" ElementName="P_20" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB2_P21" ElementName="P_21" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB2_P22" ElementName="P_22" runat="server" XSDType="TNrREGON" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB2_P23" ElementName="P_23" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB2_P24" ElementName="P_24" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB2_P25" ElementName="P_25" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB2_P26" ElementName="P_26" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB2_P27" ElementName="P_27" runat="server" XSDType="TKwota2"/>
                <P_28>0</P_28>
                <P_29>0</P_29>
            </ea:Section>
            <P_56>2</P_56>
            <P_57>2</P_57>
          </PozycjeSzczegolowe>
      </Zalacznik_PIT_B>
      </ea:Section>
  </Zalaczniki>
</Deklaracja>
