﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PIT5L_4)dc[typeof(PIT5L_4)];
        Rok.EditValue = dek.Rok;
        var us = (UrzadSkarbowy) dek.WlascicielHistoria.Podatki.UrzadSkarbowy;
        if (us != null)
            UrzSkarb.EditValue = us.KodUrzeduSkarbowego;

        Straty.Visible = ((decimal)dek.Bloki["D"]["Straty"]) > 0m;
        PITBCount.EditValue = IloscPitB.EditValue = 1;
        if (dek.Okres.EntireMonths == 3)
        {
            WyliczKwartaly(dek);
        }
        else
        {
            WyliczMiesiace(dek);
        }
        WyliczPitB(dek.Bloki);
    }

    void WyliczPitB(Deklaracja.BlokiIdx b)
    {
        PB_P7.EditValue = 0m;
        PB_P8.EditValue = 0m;
        if ((Percent)b["H1"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["H1"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["H1"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["H2"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["H2"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["H2"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["H3"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["H3"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["H3"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["H4"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["H4"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["H4"]["Koszty"];
            PitB_B1.Visible = true;
        }

        if ((Percent)b["H1"]["Udzial"] != Percent.Zero && (Percent)b["H1"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_1.EditValue = b["H1"]["NazwaPelna"];
            PB_C12_1.EditValue = b["H1"]["Udzial"];
            PB_C13_1.EditValue = b["H1"]["Nip"];
            PB_C14_1.EditValue = (decimal) b["H1"]["Przychod"]/(Percent) b["H1"]["Udzial"];
            PB_C15_1.EditValue = b["H1"]["Przychod"];
            PB_C16_1.EditValue = (decimal) b["H1"]["Koszty"]/(Percent) b["H1"]["Udzial"];
            PB_C17_1.EditValue = b["H1"]["Koszty"];
            PitB_C1.Visible = true;
        }
        if ((Percent)b["H2"]["Udzial"] != Percent.Zero && (Percent)b["H2"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_2.EditValue = b["H2"]["NazwaPelna"];
            PB_C12_2.EditValue = b["H2"]["Udzial"];
            PB_C13_2.EditValue = b["H2"]["Nip"];
            PB_C14_2.EditValue = (decimal) b["H2"]["Przychod"]/(Percent) b["H2"]["Udzial"];
            PB_C15_2.EditValue = b["H2"]["Przychod"];
            PB_C16_2.EditValue = (decimal) b["H2"]["Koszty"]/(Percent) b["H2"]["Udzial"];
            PB_C17_2.EditValue = b["H2"]["Koszty"];
            PitB_C2.Visible = true;
        }
        if ((Percent)b["H3"]["Udzial"] != Percent.Zero && (Percent)b["H3"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_3.EditValue = b["H3"]["NazwaPelna"];
            PB_C12_3.EditValue = b["H3"]["Udzial"];
            PB_C13_3.EditValue = b["H3"]["Nip"];
            PB_C14_3.EditValue = (decimal) b["H3"]["Przychod"]/(Percent) b["H3"]["Udzial"];
            PB_C15_3.EditValue = b["H3"]["Przychod"];
            PB_C16_3.EditValue = (decimal) b["H3"]["Koszty"]/(Percent) b["H3"]["Udzial"];
            PB_C17_3.EditValue = b["H3"]["Koszty"];
            PitB_C3.Visible = true;
        }
        if ((Percent)b["H4"]["Udzial"] != Percent.Zero && (Percent)b["H4"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_4.EditValue = b["H4"]["NazwaPelna"];
            PB_C12_4.EditValue = b["H4"]["Udzial"];
            PB_C13_4.EditValue = b["H4"]["Nip"];
            PB_C14_4.EditValue = (decimal) b["H4"]["Przychod"]/(Percent) b["H4"]["Udzial"];
            PB_C15_4.EditValue = b["H4"]["Przychod"];
            PB_C16_4.EditValue = (decimal) b["H4"]["Koszty"]/(Percent) b["H4"]["Udzial"];
            PB_C17_4.EditValue = b["H4"]["Koszty"];
            PitB_C4.Visible = true;
        }
    }

    void WyliczKwartaly(Deklaracja dek)
    {
        Odsetki12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
    }

    void WyliczMiesiace(Deklaracja dek)
    {
        Odsetki12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki11.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty11.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki10.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty10.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki8.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty8.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki7.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty7.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki5.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty5.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki4.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty4.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki2.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty2.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki1.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty1.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT5L_4,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:schemaLocation="http://crd.gov.pl/wzor/2020/01/15/9021/ http://crd.gov.pl/wzor/2020/01/15/9021/schemat.xsd"
            xmlns="http://crd.gov.pl/wzor/2020/01/15/9021/"
            xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <Naglowek>
        <KodFormularza kodSystemowy="PIT36L (16)" kodPodatku="PPL" rodzajZobowiazania="Z" wersjaSchemy="1-0E">PIT-36L</KodFormularza>
        <WariantFormularza>16</WariantFormularza>
        <CelZlozenia poz="P_6">1</CelZlozenia>
        <ea:XmlDataLabel ID="Rok" ElementName="Rok" runat="server" XSDType="TCalkowity" />
        <ea:XmlDataLabel ID="UrzSkarb" ElementName="KodUrzedu" runat="server" />
    </Naglowek>
    <Podmiot1 rola="Podatnik">
        <OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
        </OsobaFizyczna>
    </Podmiot1>
    <PozycjeSzczegolowe>
        <ea:Section ID="Straty" runat="server" Visible="False">
            <P_31>_</P_31>
            <ea:XmlDataLabel runat="server" ElementName="P_32" DataMember="D.Straty" XSDType="TKwota2"/>
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_33" DataMember="D.Spoleczne" XSDType="TKwota2"/>
        <P_36>0</P_36>
        <P_46>0</P_46>
        <P_47>0</P_47>
        <P_48>0</P_48>
        <P_51>0</P_51>
        <ea:XmlDataLabel runat="server" ElementName="P_52" DataMember="G2.Zdrowotne" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_55>0</P_55>
        <P_56>0</P_56>
        <P_57>0</P_57>
        <P_58>0</P_58>
        <ea:XmlDataLabel runat="server" ElementName="P_60" ID="DoZaplaty1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_61" ID="DoZaplaty2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_62" ID="DoZaplaty3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_63" ID="DoZaplaty4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_64" ID="DoZaplaty5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_65" ID="DoZaplaty6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_84" ID="DoZaplaty7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_85" ID="DoZaplaty8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_86" ID="DoZaplaty9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_87" ID="DoZaplaty10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_88" ID="DoZaplaty11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_89" ID="DoZaplaty12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <P_112>0</P_112>
        <ea:XmlDataLabel runat="server" ElementName="P_114" DataMember="G5.Remanent" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_119>0</P_119>
        <ea:XmlDataLabel runat="server" ElementName="P_133" ID="Odsetki1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_134" ID="Odsetki2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_135" ID="Odsetki3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_136" ID="Odsetki4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_137" ID="Odsetki5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_138" ID="Odsetki6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_139" ID="Odsetki7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_140" ID="Odsetki8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_141" ID="Odsetki9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_142" ID="Odsetki10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_143" ID="Odsetki11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_144" ID="Odsetki12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_151" ID="IloscPitB" XSDType="TCalkowity" HideEmptyOrZero="True"/>
    </PozycjeSzczegolowe>
  <Pouczenia>1</Pouczenia>
  <Zalaczniki>
      <Zalacznik_PIT_B xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/01/14/eD/PITB36L/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/01/14/eD/PITB36L/PIT_B(17)_Z36L_v1-0E.xsd"
          xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/01/14/eD/PITB36L/"
          xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
          xmlns:zb36="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/01/14/eD/PITB36L/"
          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT/B (17)" wersjaSchemy="1-0E">PIT/B</KodFormularza>
            <WariantFormularza>17</WariantFormularza>
          </Naglowek>
          <PozycjeSzczegolowe>
            <ea:XmlDataLabel runat="server" ElementName="P_3" ID="PITBCount" XSDType="TCalkowity" />
            <ea:Section ID="PitB_B1" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB_P7" ElementName="P_7" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_P8" ElementName="P_8" runat="server" XSDType="TKwota2"/>
            </ea:Section>
            <P_9>0</P_9>
            <ea:Section ID="PitB_C1" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_1" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_1" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_1" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_1" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_1" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_1" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_1" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C2" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_2" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_2" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_2" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_2" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_2" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_2" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_2" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C3" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_3" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_3" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_3" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_3" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_3" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_3" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_3" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C4" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_4" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_4" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_4" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_4" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_4" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_4" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_4" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
          </PozycjeSzczegolowe>
      </Zalacznik_PIT_B>      
  </Zalaczniki>
</Deklaracja>
