﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PIT5L_4)dc[typeof(PIT5L_4)];
        Rok.EditValue = dek.Rok;
        var us = (UrzadSkarbowy) dek.WlascicielHistoria.Podatki.UrzadSkarbowy;
        if (us != null)
            UrzSkarb.EditValue = us.KodUrzeduSkarbowego;

        Straty.Visible = ((decimal)dek.Bloki["D"]["Straty"]) > 0m;
        IloscPitB.EditValue = 1;
        if (dek.Okres.EntireMonths == 3)
        {
            WyliczKwartaly(dek);
        }
        else
        {
            WyliczMiesiace(dek);
        }
        WyliczPitB(dek.Bloki);
    }

    void WyliczPitB(Deklaracja.BlokiIdx b)
    {
        PB_P7.EditValue = 0m;
        PB_P8.EditValue = 0m;
        if ((Percent)b["H1"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["H1"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["H1"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["H2"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["H2"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["H2"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["H3"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["H3"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["H3"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["H4"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["H4"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["H4"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["ZH5"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["ZH5"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["ZH5"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["ZH6"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["ZH6"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["ZH6"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["ZH7"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["ZH7"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["ZH7"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["ZH8"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["ZH8"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["ZH8"]["Koszty"];
            PitB_B1.Visible = true;
        }

        if ((Percent)b["H1"]["Udzial"] != Percent.Zero && (Percent)b["H1"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_1.EditValue = b["H1"]["NazwaPelna"];
            PB_C12_1.EditValue = b["H1"]["Udzial"];
            PB_C13_1.EditValue = b["H1"]["Nip"];
            PB_C14_1.EditValue = (decimal) b["H1"]["Przychod"]/(Percent) b["H1"]["Udzial"];
            PB_C15_1.EditValue = b["H1"]["Przychod"];
            PB_C16_1.EditValue = (decimal) b["H1"]["Koszty"]/(Percent) b["H1"]["Udzial"];
            PB_C17_1.EditValue = b["H1"]["Koszty"];
            PitB_C1.Visible = true;
        }
        if ((Percent)b["H2"]["Udzial"] != Percent.Zero && (Percent)b["H2"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_2.EditValue = b["H2"]["NazwaPelna"];
            PB_C12_2.EditValue = b["H2"]["Udzial"];
            PB_C13_2.EditValue = b["H2"]["Nip"];
            PB_C14_2.EditValue = (decimal) b["H2"]["Przychod"]/(Percent) b["H2"]["Udzial"];
            PB_C15_2.EditValue = b["H2"]["Przychod"];
            PB_C16_2.EditValue = (decimal) b["H2"]["Koszty"]/(Percent) b["H2"]["Udzial"];
            PB_C17_2.EditValue = b["H2"]["Koszty"];
            PitB_C2.Visible = true;
        }
        if ((Percent)b["H3"]["Udzial"] != Percent.Zero && (Percent)b["H3"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_3.EditValue = b["H3"]["NazwaPelna"];
            PB_C12_3.EditValue = b["H3"]["Udzial"];
            PB_C13_3.EditValue = b["H3"]["Nip"];
            PB_C14_3.EditValue = (decimal) b["H3"]["Przychod"]/(Percent) b["H3"]["Udzial"];
            PB_C15_3.EditValue = b["H3"]["Przychod"];
            PB_C16_3.EditValue = (decimal) b["H3"]["Koszty"]/(Percent) b["H3"]["Udzial"];
            PB_C17_3.EditValue = b["H3"]["Koszty"];
            PitB_C3.Visible = true;
        }
        if ((Percent)b["H4"]["Udzial"] != Percent.Zero && (Percent)b["H4"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_4.EditValue = b["H4"]["NazwaPelna"];
            PB_C12_4.EditValue = b["H4"]["Udzial"];
            PB_C13_4.EditValue = b["H4"]["Nip"];
            PB_C14_4.EditValue = (decimal) b["H4"]["Przychod"]/(Percent) b["H4"]["Udzial"];
            PB_C15_4.EditValue = b["H4"]["Przychod"];
            PB_C16_4.EditValue = (decimal) b["H4"]["Koszty"]/(Percent) b["H4"]["Udzial"];
            PB_C17_4.EditValue = b["H4"]["Koszty"];
            PitB_C4.Visible = true;
        }
        if ((Percent)b["ZH5"]["Udzial"] != Percent.Zero && (Percent)b["ZH5"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_5.EditValue = b["ZH5"]["NazwaPelna"];
            PB_C12_5.EditValue = b["ZH5"]["Udzial"];
            PB_C13_5.EditValue = b["ZH5"]["Nip"];
            PB_C14_5.EditValue = (decimal) b["ZH5"]["Przychod"]/(Percent) b["ZH5"]["Udzial"];
            PB_C15_5.EditValue = b["ZH5"]["Przychod"];
            PB_C16_5.EditValue = (decimal) b["ZH5"]["Koszty"]/(Percent) b["ZH5"]["Udzial"];
            PB_C17_5.EditValue = b["ZH5"]["Koszty"];
            PitB_C5.Visible = true;
        }
        if ((Percent)b["ZH6"]["Udzial"] != Percent.Zero && (Percent)b["ZH6"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_6.EditValue = b["ZH6"]["NazwaPelna"];
            PB_C12_6.EditValue = b["ZH6"]["Udzial"];
            PB_C13_6.EditValue = b["ZH6"]["Nip"];
            PB_C14_6.EditValue = (decimal) b["ZH6"]["Przychod"]/(Percent) b["ZH6"]["Udzial"];
            PB_C15_6.EditValue = b["ZH6"]["Przychod"];
            PB_C16_6.EditValue = (decimal) b["ZH6"]["Koszty"]/(Percent) b["ZH6"]["Udzial"];
            PB_C17_6.EditValue = b["ZH6"]["Koszty"];
            PitB_C6.Visible = true;
        }
        if ((Percent)b["ZH7"]["Udzial"] != Percent.Zero && (Percent)b["ZH7"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_7.EditValue = b["ZH7"]["NazwaPelna"];
            PB_C12_7.EditValue = b["ZH7"]["Udzial"];
            PB_C13_7.EditValue = b["ZH7"]["Nip"];
            PB_C14_7.EditValue = (decimal) b["ZH6"]["Przychod"]/(Percent) b["ZH7"]["Udzial"];
            PB_C15_7.EditValue = b["ZH7"]["Przychod"];
            PB_C16_7.EditValue = (decimal) b["ZH6"]["Koszty"]/(Percent) b["ZH7"]["Udzial"];
            PB_C17_7.EditValue = b["ZH7"]["Koszty"];
            PitB_C7.Visible = true;
        }
        if ((Percent)b["ZH8"]["Udzial"] != Percent.Zero && (Percent)b["ZH8"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_8.EditValue = b["ZH8"]["NazwaPelna"];
            PB_C12_8.EditValue = b["ZH8"]["Udzial"];
            PB_C13_8.EditValue = b["ZH8"]["Nip"];
            PB_C14_8.EditValue = (decimal) b["ZH8"]["Przychod"]/(Percent) b["ZH8"]["Udzial"];
            PB_C15_8.EditValue = b["ZH8"]["Przychod"];
            PB_C16_8.EditValue = (decimal) b["ZH8"]["Koszty"]/(Percent) b["ZH8"]["Udzial"];
            PB_C17_8.EditValue = b["ZH8"]["Koszty"];
            PitB_C8.Visible = true;
        }
    }

    void WyliczKwartaly(Deklaracja dek)
    {
        Odsetki12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
    }

    void WyliczMiesiace(Deklaracja dek)
    {
        Odsetki12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki11.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty11.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki10.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty10.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki8.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty8.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki7.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty7.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki5.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty5.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki4.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty4.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki2.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty2.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        Odsetki1.EditValue = Math.Round((decimal) dek.Bloki["G5"]["Odsetki"]);
        DoZaplaty1.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT5L_4,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:schemaLocation="http://crd.gov.pl/wzor/2021/02/12/10402/ http://crd.gov.pl/wzor/2021/02/12/10402/schemat.xsd"
            xmlns="http://crd.gov.pl/wzor/2021/02/12/10402/"
            xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/07/06/eD/DefinicjeTypy/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <Naglowek>
        <KodFormularza kodSystemowy="PIT36L (17)" kodPodatku="PPL" rodzajZobowiazania="Z" wersjaSchemy="1-0E">PIT-36L</KodFormularza>
        <WariantFormularza>17</WariantFormularza>
        <CelZlozenia poz="P_6">1</CelZlozenia>
        <ea:XmlDataLabel ID="Rok" ElementName="Rok" runat="server" XSDType="TCalkowity" />
        <ea:XmlDataLabel ID="UrzSkarb" ElementName="KodUrzedu" runat="server" />
    </Naglowek>
    <Podmiot1 rola="Podatnik">
        <OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
        </OsobaFizyczna>
    </Podmiot1>
    <PozycjeSzczegolowe>
        <ea:Section ID="Straty" runat="server" Visible="False">
            <P_33>_</P_33>
            <ea:XmlDataLabel runat="server" ElementName="P_34" DataMember="D.Straty" XSDType="TKwota2"/>
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_35" DataMember="D.Spoleczne" XSDType="TKwota2"/>
        <P_38>0</P_38>
        <P_48>0</P_48>
        <P_61>0</P_61>
        <P_63>0</P_63>
        <P_64>0</P_64>
        <P_65>0</P_65>
        <P_68>0</P_68>
        <ea:XmlDataLabel runat="server" ElementName="P_69" DataMember="G2.Zdrowotne" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_72>0</P_72>
        <P_73>0</P_73>
        <P_74>0</P_74>
        <P_75>0</P_75>
        <ea:XmlDataLabel runat="server" ElementName="P_77" ID="DoZaplaty1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_78" ID="DoZaplaty2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_79" ID="DoZaplaty3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_80" ID="DoZaplaty4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_81" ID="DoZaplaty5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_82" ID="DoZaplaty6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_101" ID="DoZaplaty7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_102" ID="DoZaplaty8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_103" ID="DoZaplaty9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_104" ID="DoZaplaty10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_105" ID="DoZaplaty11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_106" ID="DoZaplaty12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <P_129>0</P_129>
        <ea:XmlDataLabel runat="server" ElementName="P_131" DataMember="G5.Remanent" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_136>0</P_136>
        <ea:XmlDataLabel runat="server" ElementName="P_150" ID="Odsetki1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_151" ID="Odsetki2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_152" ID="Odsetki3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_153" ID="Odsetki4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_154" ID="Odsetki5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_155" ID="Odsetki6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_156" ID="Odsetki7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_157" ID="Odsetki8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_158" ID="Odsetki9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_159" ID="Odsetki10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_160" ID="Odsetki11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_161" ID="Odsetki12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_168" ID="IloscPitB" XSDType="TCalkowity" HideEmptyOrZero="True"/>
    </PozycjeSzczegolowe>
  <Zalaczniki>
      <Zalacznik_PIT_B xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/02/08/eD/PITB36X/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/02/08/eD/PITB36X/PIT_B(18)_Z36X_v1-0E.xsd"
          xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/02/08/eD/PITB36X/"
          xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/07/06/eD/DefinicjeTypy/"
          xmlns:zb36x="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/02/08/eD/PITB36X/"
          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT/B (18)" wersjaSchemy="1-0E">PIT/B</KodFormularza>
            <WariantFormularza>18</WariantFormularza>
          </Naglowek>
          <PozycjeSzczegolowe>
            <ea:Section ID="PitB_B1" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB_P7" ElementName="P_7" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_P8" ElementName="P_8" runat="server" XSDType="TKwota2"/>
                <P_9>0</P_9>
            </ea:Section>
            <ea:Section ID="PitB_C1" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_1" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_1" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_1" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_1" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_1" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_1" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_1" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C2" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_2" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_2" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_2" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_2" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_2" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_2" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_2" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C3" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_3" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_3" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_3" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_3" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_3" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_3" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_3" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C4" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_4" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_4" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_4" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_4" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_4" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_4" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_4" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
              <ea:Section ID="PitB_C5" runat="server" Visible="False">
                  <P_C typ="G">
                      <ea:XmlDataLabel ID="PB_C11_5" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                      <ea:XmlDataLabel ID="PB_C12_5" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                      <ea:XmlDataLabel ID="PB_C13_5" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                      <ea:XmlDataLabel ID="PB_C14_5" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C15_5" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C16_5" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C17_5" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                      <P_C18>0</P_C18>
                      <P_C19>0</P_C19>
                  </P_C>
              </ea:Section>
              <ea:Section ID="PitB_C6" runat="server" Visible="False">
                  <P_C typ="G">
                      <ea:XmlDataLabel ID="PB_C11_6" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                      <ea:XmlDataLabel ID="PB_C12_6" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                      <ea:XmlDataLabel ID="PB_C13_6" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                      <ea:XmlDataLabel ID="PB_C14_6" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C15_6" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C16_6" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C17_6" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                      <P_C18>0</P_C18>
                      <P_C19>0</P_C19>
                  </P_C>
              </ea:Section>
              <ea:Section ID="PitB_C7" runat="server" Visible="False">
                  <P_C typ="G">
                      <ea:XmlDataLabel ID="PB_C11_7" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                      <ea:XmlDataLabel ID="PB_C12_7" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                      <ea:XmlDataLabel ID="PB_C13_7" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                      <ea:XmlDataLabel ID="PB_C14_7" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C15_7" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C16_7" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C17_7" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                      <P_C18>0</P_C18>
                      <P_C19>0</P_C19>
                  </P_C>
              </ea:Section>
              <ea:Section ID="PitB_C8" runat="server" Visible="False">
                  <P_C typ="G">
                      <ea:XmlDataLabel ID="PB_C11_8" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                      <ea:XmlDataLabel ID="PB_C12_8" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                      <ea:XmlDataLabel ID="PB_C13_8" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                      <ea:XmlDataLabel ID="PB_C14_8" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C15_8" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C16_8" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C17_8" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                      <P_C18>0</P_C18>
                      <P_C19>0</P_C19>
                  </P_C>
              </ea:Section>
          </PozycjeSzczegolowe>
      </Zalacznik_PIT_B>      
  </Zalaczniki>
  <Pouczenia>1</Pouczenia>
</Deklaracja>
