﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PIT5L_2022_2)dc[typeof(PIT5L_2022_2)];
        Rok.EditValue = dek.Rok;
        var us = (UrzadSkarbowy) dek.WlascicielHistoria.Podatki.UrzadSkarbowy;
        if (us != null)
            UrzSkarb.EditValue = us.KodUrzeduSkarbowego;

        Straty.Visible = ((decimal)dek.Bloki["D"]["Straty"]) > 0m;
        IloscPitB.EditValue = 1;

        if (dek.ZaliczkaKwartalna)
        {
            WyliczKwartaly(dek);
            WyliczSumaZaliczek(dek, true);
        }
        else
        {
            WyliczMiesiace(dek);
            WyliczSumaZaliczek(dek);
        }
        WyliczPitB(dek.Bloki);
        ZdrowotneLimit.EditValue = dek is PIT5L_2022_2 ? (decimal)dek.Bloki["D"]["Zdrowotne_Limit"] : 0m;
    }

    void WyliczPitB(Deklaracja.BlokiIdx b)
    {
        PB_P7.EditValue = 0m;
        PB_P8.EditValue = 0m;
        if ((Percent)b["H1"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["H1"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["H1"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["H2"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["H2"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["H2"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["H3"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["H3"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["H3"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["H4"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["H4"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["H4"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["ZH5"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["ZH5"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["ZH5"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["ZH6"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["ZH6"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["ZH6"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["ZH7"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["ZH7"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["ZH7"]["Koszty"];
            PitB_B1.Visible = true;
        }
        if ((Percent)b["ZH8"]["Udzial"] == Percent.Hundred)
        {
            PB_P7.EditValue = (decimal)PB_P7.EditValue + (decimal)b["ZH8"]["Przychod"];
            PB_P8.EditValue = (decimal)PB_P8.EditValue + (decimal)b["ZH8"]["Koszty"];
            PitB_B1.Visible = true;
        }

        if ((Percent)b["H1"]["Udzial"] != Percent.Zero && (Percent)b["H1"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_1.EditValue = b["H1"]["NazwaPelna"];
            PB_C12_1.EditValue = b["H1"]["Udzial"];
            PB_C13_1.EditValue = b["H1"]["Nip"];
            PB_C14_1.EditValue = (decimal) b["H1"]["Przychod"]/(Percent) b["H1"]["Udzial"];
            PB_C15_1.EditValue = b["H1"]["Przychod"];
            PB_C16_1.EditValue = (decimal) b["H1"]["Koszty"]/(Percent) b["H1"]["Udzial"];
            PB_C17_1.EditValue = b["H1"]["Koszty"];
            PitB_C1.Visible = true;
        }
        if ((Percent)b["H2"]["Udzial"] != Percent.Zero && (Percent)b["H2"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_2.EditValue = b["H2"]["NazwaPelna"];
            PB_C12_2.EditValue = b["H2"]["Udzial"];
            PB_C13_2.EditValue = b["H2"]["Nip"];
            PB_C14_2.EditValue = (decimal) b["H2"]["Przychod"]/(Percent) b["H2"]["Udzial"];
            PB_C15_2.EditValue = b["H2"]["Przychod"];
            PB_C16_2.EditValue = (decimal) b["H2"]["Koszty"]/(Percent) b["H2"]["Udzial"];
            PB_C17_2.EditValue = b["H2"]["Koszty"];
            PitB_C2.Visible = true;
        }
        if ((Percent)b["H3"]["Udzial"] != Percent.Zero && (Percent)b["H3"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_3.EditValue = b["H3"]["NazwaPelna"];
            PB_C12_3.EditValue = b["H3"]["Udzial"];
            PB_C13_3.EditValue = b["H3"]["Nip"];
            PB_C14_3.EditValue = (decimal) b["H3"]["Przychod"]/(Percent) b["H3"]["Udzial"];
            PB_C15_3.EditValue = b["H3"]["Przychod"];
            PB_C16_3.EditValue = (decimal) b["H3"]["Koszty"]/(Percent) b["H3"]["Udzial"];
            PB_C17_3.EditValue = b["H3"]["Koszty"];
            PitB_C3.Visible = true;
        }
        if ((Percent)b["H4"]["Udzial"] != Percent.Zero && (Percent)b["H4"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_4.EditValue = b["H4"]["NazwaPelna"];
            PB_C12_4.EditValue = b["H4"]["Udzial"];
            PB_C13_4.EditValue = b["H4"]["Nip"];
            PB_C14_4.EditValue = (decimal) b["H4"]["Przychod"]/(Percent) b["H4"]["Udzial"];
            PB_C15_4.EditValue = b["H4"]["Przychod"];
            PB_C16_4.EditValue = (decimal) b["H4"]["Koszty"]/(Percent) b["H4"]["Udzial"];
            PB_C17_4.EditValue = b["H4"]["Koszty"];
            PitB_C4.Visible = true;
        }
        if ((Percent)b["ZH5"]["Udzial"] != Percent.Zero && (Percent)b["ZH5"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_5.EditValue = b["ZH5"]["NazwaPelna"];
            PB_C12_5.EditValue = b["ZH5"]["Udzial"];
            PB_C13_5.EditValue = b["ZH5"]["Nip"];
            PB_C14_5.EditValue = (decimal) b["ZH5"]["Przychod"]/(Percent) b["ZH5"]["Udzial"];
            PB_C15_5.EditValue = b["ZH5"]["Przychod"];
            PB_C16_5.EditValue = (decimal) b["ZH5"]["Koszty"]/(Percent) b["ZH5"]["Udzial"];
            PB_C17_5.EditValue = b["ZH5"]["Koszty"];
            PitB_C5.Visible = true;
        }
        if ((Percent)b["ZH6"]["Udzial"] != Percent.Zero && (Percent)b["ZH6"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_6.EditValue = b["ZH6"]["NazwaPelna"];
            PB_C12_6.EditValue = b["ZH6"]["Udzial"];
            PB_C13_6.EditValue = b["ZH6"]["Nip"];
            PB_C14_6.EditValue = (decimal) b["ZH6"]["Przychod"]/(Percent) b["ZH6"]["Udzial"];
            PB_C15_6.EditValue = b["ZH6"]["Przychod"];
            PB_C16_6.EditValue = (decimal) b["ZH6"]["Koszty"]/(Percent) b["ZH6"]["Udzial"];
            PB_C17_6.EditValue = b["ZH6"]["Koszty"];
            PitB_C6.Visible = true;
        }
        if ((Percent)b["ZH7"]["Udzial"] != Percent.Zero && (Percent)b["ZH7"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_7.EditValue = b["ZH7"]["NazwaPelna"];
            PB_C12_7.EditValue = b["ZH7"]["Udzial"];
            PB_C13_7.EditValue = b["ZH7"]["Nip"];
            PB_C14_7.EditValue = (decimal) b["ZH6"]["Przychod"]/(Percent) b["ZH7"]["Udzial"];
            PB_C15_7.EditValue = b["ZH7"]["Przychod"];
            PB_C16_7.EditValue = (decimal) b["ZH6"]["Koszty"]/(Percent) b["ZH7"]["Udzial"];
            PB_C17_7.EditValue = b["ZH7"]["Koszty"];
            PitB_C7.Visible = true;
        }
        if ((Percent)b["ZH8"]["Udzial"] != Percent.Zero && (Percent)b["ZH8"]["Udzial"] != Percent.Hundred)
        {
            PB_C11_8.EditValue = b["ZH8"]["NazwaPelna"];
            PB_C12_8.EditValue = b["ZH8"]["Udzial"];
            PB_C13_8.EditValue = b["ZH8"]["Nip"];
            PB_C14_8.EditValue = (decimal) b["ZH8"]["Przychod"]/(Percent) b["ZH8"]["Udzial"];
            PB_C15_8.EditValue = b["ZH8"]["Przychod"];
            PB_C16_8.EditValue = (decimal) b["ZH8"]["Koszty"]/(Percent) b["ZH8"]["Udzial"];
            PB_C17_8.EditValue = b["ZH8"]["Koszty"];
            PitB_C8.Visible = true;
        }
    }

    void WyliczKwartaly(Deklaracja dek)
    {
        var doZaplaty12 = 0m;
        var doZaplaty9 = 0m;
        var doZaplaty6 = 0m;
        var doZaplaty3 = 0m;
        var liczbaDeklaracji = 12;

        for(int i = liczbaDeklaracji; i > 0; i--)
        {
            if(i > 9 && i <= 12)
            {
                doZaplaty12 += Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
            }
            else if(i > 6 && i <= 9)
            {
                doZaplaty9 += Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);               
            }
            else if(i > 3 && i <= 6)
            {
                doZaplaty6 += Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
            }
            else
            {
                doZaplaty3 += Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
            }

            if (dek.Poprzednia == null) break;
            dek = dek.Poprzednia;
        }

        DoZaplaty12.EditValue = doZaplaty12 < 0 ? 0m : doZaplaty12;
        DoZaplaty9.EditValue = doZaplaty9 < 0 ? 0m : doZaplaty9;
        DoZaplaty6.EditValue = doZaplaty6 < 0 ? 0m : doZaplaty6;
        DoZaplaty3.EditValue = doZaplaty3 < 0 ? 0m : doZaplaty3; 
      
    }

    void WyliczSumaZaliczek(Deklaracja dek, bool kwartalnie = false)
    {
        decimal suma = 0m;
        int liczbaDeklaracji = 12;

        for(int i = liczbaDeklaracji; i > 0; i--)
        {
            suma += Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
            SumaZaliczek.EditValue = suma;

            if (dek.Poprzednia == null) return;
            dek = dek.Poprzednia;
        }
    }

    void WyliczMiesiace(Deklaracja dek)
    {
        DoZaplaty12.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        DoZaplaty11.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        DoZaplaty10.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        DoZaplaty9.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        DoZaplaty8.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        DoZaplaty7.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        DoZaplaty6.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        DoZaplaty5.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        DoZaplaty4.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        DoZaplaty3.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        DoZaplaty2.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
        if (dek.Poprzednia == null) return;
        dek = dek.Poprzednia;
        DoZaplaty1.EditValue = Math.Round((decimal) dek.Bloki["G5"]["DoZaplaty"]);
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT5L_2022_2,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:schemaLocation="http://crd.gov.pl/wzor/2023/01/09/12053/ http://crd.gov.pl/wzor/2023/01/09/12053/schemat.xsd"
            xmlns="http://crd.gov.pl/wzor/2023/01/09/12053/"
            xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/09/13/eD/DefinicjeTypy/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

    <Naglowek>
        <KodFormularza kodSystemowy="PIT36L (19)" kodPodatku="PPL" rodzajZobowiazania="Z" wersjaSchemy="1-1E">PIT-36L</KodFormularza>
        <WariantFormularza>19</WariantFormularza>
        <CelZlozenia poz="P_6">1</CelZlozenia>
        <ea:XmlDataLabel ID="Rok" ElementName="Rok" runat="server" XSDType="TCalkowity" />
        <ea:XmlDataLabel ID="UrzSkarb" ElementName="KodUrzedu" runat="server" />
    </Naglowek>
    <Podmiot1 rola="Podatnik">
        <OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" runat="server" DataMember="B1.Imie" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" runat="server" DataMember="B1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" runat="server" DataMember="B1.DataUrodzenia" XSDType="TData"/>
        </OsobaFizyczna>
    </Podmiot1>
    <PozycjeSzczegolowe>
        <P_28>0</P_28>
        <P_30>0</P_30>
        <ea:XmlDataLabel runat="server" ElementName="P_32" ID="SumaZaliczek" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:Section ID="Straty" runat="server" Visible="False">
            <P_38>_</P_38>
            <ea:XmlDataLabel runat="server" ElementName="P_39" DataMember="D.Straty" XSDType="TKwota2"/>
        </ea:Section>
        <ea:XmlDataLabel runat="server" ElementName="P_40" DataMember="D.Spoleczne" XSDType="TKwota2"/>
        <ea:XmlDataLabel runat="server" ElementName="P_41" ID="ZdrowotneLimit" XSDType="TKwota2"/>
        <P_49>0</P_49>
        <P_66>0</P_66>
        <P_69>0</P_69>
        <P_71>0</P_71>
        <P_72>0</P_72>
        <P_73>0</P_73>
        <P_74>0</P_74>
        <P_78>0</P_78>
        <ea:XmlDataLabel runat="server" ElementName="P_70" DataMember="G2.Zdrowotne" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_80>0</P_80>
        <P_81>0</P_81>
        <P_82>0</P_82>
        <P_83>0</P_83>
        <ea:XmlDataLabel runat="server" ElementName="P_85" ID="DoZaplaty1" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_86" ID="DoZaplaty2" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_87" ID="DoZaplaty3" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_88" ID="DoZaplaty4" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_89" ID="DoZaplaty5" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_90" ID="DoZaplaty6" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_109" ID="DoZaplaty7" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_110" ID="DoZaplaty8" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_111" ID="DoZaplaty9" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_112" ID="DoZaplaty10" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_113" ID="DoZaplaty11" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <ea:XmlDataLabel runat="server" ElementName="P_114" ID="DoZaplaty12" XSDType="TKwotaC" HideEmptyOrZero="True"/>
        <P_137>0</P_137>
        <ea:XmlDataLabel runat="server" ElementName="P_139" DataMember="G5.Remanent" XSDType="TKwota2" HideEmptyOrZero="True"/>
        <P_145>0</P_145>
        <ea:XmlDataLabel runat="server" ElementName="P_177" ID="IloscPitB" XSDType="TCalkowity" HideEmptyOrZero="True"/>
    </PozycjeSzczegolowe>
  <Zalaczniki>
      <Zalacznik_PIT_B xsi:schemaLocation="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/15/eD/PITB36X/ http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/15/eD/PITB36X/PIT_B(20)_Z36X_v1-0E.xsd"
          xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/15/eD/PITB36X/"
          xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/06/09/eD/DefinicjeTypy/"
          xmlns:zb36x="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/12/15/eD/PITB36X/"
          xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
          <Naglowek>
            <KodFormularza kodSystemowy="PIT/B (20)" wersjaSchemy="1-0E">PIT/B</KodFormularza>
            <WariantFormularza>20</WariantFormularza>
          </Naglowek>
          <PozycjeSzczegolowe>
            <ea:Section ID="PitB_B1" runat="server" Visible="False">
                <ea:XmlDataLabel ID="PB_P7" ElementName="P_7" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_P8" ElementName="P_8" runat="server" XSDType="TKwota2"/>
                <P_9>0</P_9>
            </ea:Section>
            <ea:Section ID="PitB_C1" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_1" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_1" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_1" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_1" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_1" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_1" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_1" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C2" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_2" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_2" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_2" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_2" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_2" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_2" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_2" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C3" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_3" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_3" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_3" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_3" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_3" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_3" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_3" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
            <ea:Section ID="PitB_C4" runat="server" Visible="False">
                <P_C typ="G">
                <ea:XmlDataLabel ID="PB_C11_4" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                <ea:XmlDataLabel ID="PB_C12_4" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                <ea:XmlDataLabel ID="PB_C13_4" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                <ea:XmlDataLabel ID="PB_C14_4" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C15_4" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C16_4" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                <ea:XmlDataLabel ID="PB_C17_4" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                <P_C18>0</P_C18>
                <P_C19>0</P_C19>
                </P_C>
            </ea:Section>
              <ea:Section ID="PitB_C5" runat="server" Visible="False">
                  <P_C typ="G">
                      <ea:XmlDataLabel ID="PB_C11_5" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                      <ea:XmlDataLabel ID="PB_C12_5" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                      <ea:XmlDataLabel ID="PB_C13_5" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                      <ea:XmlDataLabel ID="PB_C14_5" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C15_5" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C16_5" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C17_5" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                      <P_C18>0</P_C18>
                      <P_C19>0</P_C19>
                  </P_C>
              </ea:Section>
              <ea:Section ID="PitB_C6" runat="server" Visible="False">
                  <P_C typ="G">
                      <ea:XmlDataLabel ID="PB_C11_6" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                      <ea:XmlDataLabel ID="PB_C12_6" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                      <ea:XmlDataLabel ID="PB_C13_6" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                      <ea:XmlDataLabel ID="PB_C14_6" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C15_6" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C16_6" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C17_6" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                      <P_C18>0</P_C18>
                      <P_C19>0</P_C19>
                  </P_C>
              </ea:Section>
              <ea:Section ID="PitB_C7" runat="server" Visible="False">
                  <P_C typ="G">
                      <ea:XmlDataLabel ID="PB_C11_7" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                      <ea:XmlDataLabel ID="PB_C12_7" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                      <ea:XmlDataLabel ID="PB_C13_7" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                      <ea:XmlDataLabel ID="PB_C14_7" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C15_7" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C16_7" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C17_7" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                      <P_C18>0</P_C18>
                      <P_C19>0</P_C19>
                  </P_C>
              </ea:Section>
              <ea:Section ID="PitB_C8" runat="server" Visible="False">
                  <P_C typ="G">
                      <ea:XmlDataLabel ID="PB_C11_8" ElementName="P_C11" runat="server" XSDType="TZnakowy"/>
                      <ea:XmlDataLabel ID="PB_C12_8" ElementName="P_C12" runat="server" XSDType="TProcentowy"/>
                      <ea:XmlDataLabel ID="PB_C13_8" ElementName="P_C13" runat="server" XSDType="TNrNIP" HideEmptyOrZero=""/>
                      <ea:XmlDataLabel ID="PB_C14_8" ElementName="P_C14" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C15_8" ElementName="P_C15" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C16_8" ElementName="P_C16" runat="server" XSDType="TKwota2"/>
                      <ea:XmlDataLabel ID="PB_C17_8" ElementName="P_C17" runat="server" XSDType="TKwota2"/>
                      <P_C18>0</P_C18>
                      <P_C19>0</P_C19>
                  </P_C>
              </ea:Section>
          </PozycjeSzczegolowe>
      </Zalacznik_PIT_B>      
  </Zalaczniki>
  <Pouczenia>1</Pouczenia>
</Deklaracja>
