﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="System.Globalization" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.VAT" %>


<script runat="server">

	private VAT27_2 dek;


	void OnContextLoad(Object sender, EventArgs args)
	{
		dek = (VAT27_2)dc[typeof(VAT27_2)];

		var nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], (bool)dek.Bloki["B1"]["OsobaFiz"]);
		if ((bool)dek.Bloki["B1"]["OsobaFiz"])
		{
			OsobaNieFizyczna.Visible = false;
			if (nazwa.Length > 0)
				IdNazwisko.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				IdImiePierwsze.EditValue = nazwa[1].Trim();
			if (nazwa.Length > 2)
				IdDataUrodzenia.EditValue = nazwa[2].Trim();
		}
		else
		{
			OsobaFizyczna.Visible = false;
			if (nazwa.Length > 0)
				NazwaPelna.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				REGON.EditValue = nazwa[1].Trim();
		}

		var edeklHelper = dek.GetEDekleracjaHelper();
		
		GroupC.DataSource = edeklHelper.ItemsC;
		SumGroupC.EditValue = edeklHelper.ItemsC.Sum(i => i.Value);

		GroupD.DataSource = edeklHelper.ItemsD;
		SumGroupD.EditValue = edeklHelper.ItemsD.Sum(i => i.Value);

	}


</script>


<ea:datacontext id="dc" runat="server" typename="Soneta.Deklaracje.VAT.VAT27_2,Soneta.Deklaracje" oncontextload="OnContextLoad" />
<?xml version="1.0" encoding="UTF-8" ?>
<Deklaracja 
	xmlns="http://crd.gov.pl/wzor/2017/01/11/3844/" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://crd.gov.pl/wzor/2017/01/11/3844/ http://crd.gov.pl/wzor/2017/01/11/3844/schemat.xsd"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2016/01/25/eD/DefinicjeTypy/" >
<Naglowek>
	<KodFormularza kodSystemowy="VAT-27 (2)" kodPodatku="VAT" rodzajZobowiazania="Z" wersjaSchemy="1-0E" >VAT-27</KodFormularza>
	<WariantFormularza>2</WariantFormularza>
	<CelZlozenia poz="P_7"><ea:XmlDataLabel runat="server" DataMember="Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
	<ea:XmlDataLabel runat="server" ElementName="Rok" DataMember="0.Rok" />
	<ea:XmlDataLabel runat="server" ElementName="Miesiac" DataMember="0.Miesiac" />
	<ea:XmlDataLabel runat="server" ElementName="KodUrzedu" DataMember="DOD.KodUrzeduSkarbowego" />
</Naglowek>

<Podmiot1 rola="Podatnik">
	<ea:Section ID="OsobaFizyczna" runat="server">
		<etd:OsobaFizyczna>
			<ea:XmlDataLabel runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP" />
			<ea:XmlDataLabel runat="server" ElementName="etd:ImiePierwsze" ID="IdImiePierwsze" XSDType="TImie" />
			<ea:XmlDataLabel runat="server" ElementName="etd:Nazwisko" ID="IdNazwisko" XSDType="TNazwisko" />
			<ea:XmlDataLabel runat="server" ElementName="etd:DataUrodzenia" ID="IdDataUrodzenia" XSDType="TData" />
		</etd:OsobaFizyczna>
	</ea:Section>
	<ea:Section ID="OsobaNieFizyczna" runat="server">
		<etd:OsobaNiefizyczna>
			<ea:XmlDataLabel runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP" />
			<ea:XmlDataLabel ID="NazwaPelna" runat="server" ElementName="etd:PelnaNazwa" XSDType="TZnakowy" />
			<ea:XmlDataLabel ID="REGON" runat="server" ElementName="etd:REGON" XSDType="TNrREGON" HideEmptyOrZero="true" />
		</etd:OsobaNiefizyczna>
	</ea:Section>
</Podmiot1>	
	
<PozycjeSzczegolowe>
	<ea:Section ID="BlokC" runat="server">
		<ea:DataRepeater runat="server" WithSections="false" ID="GroupC" >
			<Grupa_C typ="G" >
				<ea:XmlDataLabel runat="server" ID="P_C1" ElementName="P_C1" DataMember="Changed" XSDType="TWybor1" HideEmptyOrZero="true" />
				<ea:XmlDataLabel runat="server" ID="P_C2" ElementName="P_C2" DataMember="Name" />
				<ea:XmlDataLabel runat="server" ID="P_C3" ElementName="P_C3" DataMember="NIP" XSDType="TNrNIP" />
				<ea:XmlDataLabel runat="server" ID="P_C4" ElementName="P_C4" DataMember="Value" XSDType="TKwota2" />
			</Grupa_C>
		</ea:DataRepeater>
		<ea:XmlDataLabel runat="server" ID="SumGroupC" XSDType="TKwota2" ElementName="P_10" />
	</ea:Section>
	<ea:Section ID="BlokD" runat="server">
		<ea:DataRepeater runat="server" WithSections="false" ID="GroupD" >
			<Grupa_D typ="G" >
				<ea:XmlDataLabel runat="server" ID="P_D1" ElementName="P_D1" DataMember="Changed" XSDType="TWybor1" HideEmptyOrZero="true" />
				<ea:XmlDataLabel runat="server" ID="P_D2" ElementName="P_D2" DataMember="Name" />
				<ea:XmlDataLabel runat="server" ID="P_D3" ElementName="P_D3" DataMember="NIP" XSDType="TNrNIP" />
				<ea:XmlDataLabel runat="server" ID="P_D4" ElementName="P_D4" DataMember="Value" XSDType="TKwota2"  />
			</Grupa_D>
		</ea:DataRepeater>
		<ea:XmlDataLabel runat="server" ID="SumGroupD" XSDType="TKwota2" ElementName="P_11" />
	</ea:Section>
	<ea:XmlDataLabel runat="server" ElementName="P_14" DataMember="ETelefon" XSDType="TZnakowy"  HideEmptyOrZero="true" />
	<ea:XmlDataLabel runat="server" ElementName="P_15" DataMember="EData" XSDType="TData" />
</PozycjeSzczegolowe>
	
<Pouczenie>1</Pouczenie>

	 
</Deklaracja>
