﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.VAT" %>
<script runat="server">
  void OnBeforeRowKGrupa1(object sender, EventArgs e) {
		if (((KGrupa)KGrupa1.CurrentRow).BKwota == 0) {
			KGrupa1BKod.Visible = false;
			KGrupa1BNIP.Visible = false;
			KGrupa1BKwota.Visible = false;
			KGrupa1BTrojstronna.Visible = false;
		} else {
			KGrupa1BKod.Visible = true;
			KGrupa1BNIP.Visible = true;
			KGrupa1BKwota.Visible = true;
			KGrupa1BTrojstronna.Visible = true;			
		}

		if (((KGrupa)KGrupa1.CurrentRow).JKwota == 0) {
			KGrupa1JKod.Visible = false;
			KGrupa1JNIP.Visible = false;
			KGrupa1JKwota.Visible = false;
			KGrupa1JTrojstronna.Visible = false;
		} else {
			KGrupa1JKod.Visible = true;
			KGrupa1JNIP.Visible = true;
			KGrupa1JKwota.Visible = true;
			KGrupa1JTrojstronna.Visible = true;			
		}
		
  }

  void OnBeforeRowKGrupa2(object sender, EventArgs e) {
		if (((KGrupa)KGrupa2.CurrentRow).BKwota == 0) {
			KGrupa2BKod.Visible = false;
			KGrupa2BNIP.Visible = false;
			KGrupa2BKwota.Visible = false;
			KGrupa2BTrojstronna.Visible = false;
		} else {
			KGrupa2BKod.Visible = true;
			KGrupa2BNIP.Visible = true;
			KGrupa2BKwota.Visible = true;
			KGrupa2BTrojstronna.Visible = true;			
		}

		if (((KGrupa)KGrupa2.CurrentRow).JKwota == 0) {
			KGrupa2JKod.Visible = false;
			KGrupa2JNIP.Visible = false;
			KGrupa2JKwota.Visible = false;
			KGrupa2JTrojstronna.Visible = false;
		} else {
			KGrupa2JKod.Visible = true;
			KGrupa2JNIP.Visible = true;
			KGrupa2JKwota.Visible = true;
			KGrupa2JTrojstronna.Visible = true;			
		}		
  }

  void OnBeforeRowKGrupa3(object sender, EventArgs e) {
		if (((KGrupa)KGrupa3.CurrentRow).BKwota == 0) {
			KGrupa3BKod.Visible = false;
			KGrupa3BNIP.Visible = false;
			KGrupa3BKwota.Visible = false;
		} else {
			KGrupa3BKod.Visible = true;
			KGrupa3BNIP.Visible = true;
			KGrupa3BKwota.Visible = true;			
		}

		if (((KGrupa)KGrupa3.CurrentRow).JKwota == 0) {
			KGrupa3JKod.Visible = false;
			KGrupa3JNIP.Visible = false;
			KGrupa3JKwota.Visible = false;
		} else {
			KGrupa3JKod.Visible = true;
			KGrupa3JNIP.Visible = true;
			KGrupa3JKwota.Visible = true;			
		}
  }  
  
	VATUE_2 dek = null;

	public class Grupa {
		readonly string kod; readonly string nip; readonly decimal kwota; readonly bool trojstronna;
		public Grupa(string kod, string nip, decimal kwota, bool trojstronna){
			this.kod = kod;
			this.nip = nip;
			this.kwota = kwota;
			this.trojstronna = trojstronna;
		}

		public string Kod {
			get { return kod; }
		}

		public string NIP {
			get { return nip; }
		}

		public decimal Kwota {
			get { return kwota; }
		}

		public bool Trojstronna{
			get { return trojstronna; }
		}						
	}
	
	public class KGrupa {
		readonly string bkod; readonly string bnip; readonly decimal bkwota; readonly bool btrojstronna;
		readonly string jkod; readonly string jnip; readonly decimal jkwota; readonly bool jtrojstronna;		
		public KGrupa(
			string bkod, string bnip, decimal bkwota, bool btrojstronna,
			string jkod, string jnip, decimal jkwota, bool jtrojstronna			
			){
			this.bkod = bkod;
			this.bnip = bnip;
			this.bkwota = bkwota;
			this.btrojstronna = btrojstronna;
			
			this.jkod = jkod;
			this.jnip = jnip;
			this.jkwota = jkwota;
			this.jtrojstronna = jtrojstronna;			
		}

		public string BKod {
			get { return bkod; }
		}

		public string BNIP {
			get { return bnip; }
		}

		public decimal BKwota {
			get { return bkwota; }
		}

		public bool BTrojstronna{
			get { return btrojstronna; }
		}						
		
		public string JKod {
			get { return jkod; }
		}

		public string JNIP {
			get { return jnip; }
		}

		public decimal JKwota {
			get { return jkwota; }
		}

		public bool JTrojstronna{
			get { return jtrojstronna; }
		}

		public override string ToString() {
			return string.Format("B({0};{1};{2};{3}) J({4};{5};{6};{7})",BKod,BNIP,BKwota,BTrojstronna,JKod,JNIP,JKwota,JTrojstronna);
		}
	}	
	
	void OnContextLoad(Object sender, EventArgs args) {
		dek = (Soneta.Deklaracje.VAT.VATUE_2)dc[typeof(Soneta.Deklaracje.VAT.VATUE_2)];
		
		//Nagłówek
		//Kwartal.EditValue = dek.Okres.To.Quarter;
		
		string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], (bool)dek.Bloki["B1"]["OsobaFiz"]);
		if((bool)dek.Bloki["B1"]["OsobaFiz"]){
			OsobaNieFizyczna.Visible = false;
			if (nazwa.Length > 0)
				Nazwisko.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				ImiePiersze.EditValue = nazwa[1].Trim();
			if (nazwa.Length > 2)
				DataUrodzenia.EditValue = nazwa[2].Trim();	
      if (nazwa.Length > 3)
        PESEL.EditValue = nazwa[3].Trim();						      									
		}else{
			OsobaFizyczna.Visible = false;
			if (nazwa.Length > 0)
				NazwaPelna.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				REGON.EditValue = nazwa[1].Trim();			
		}

		string kraj = (string)dek.Bloki["B2"]["Kraj"];
		if (!string.IsNullOrEmpty(kraj) && kraj.ToLower() != "polska") {
			AdresPolski.Visible = false;
            AdresZagranicznyKodKraju.EditValue = Soneta.Core.Adres.KodKrajuWgNazwy(kraj, dc.Session);
		} else
			AdresZagraniczny.Visible = false;		
		
		if(dek.Korekta){
			Grupa1.Visible = false;
			Grupa2.Visible = false;	
			Grupa3.Visible = false;				
			
			Soneta.Deklaracje.VAT.VATUEK kor = null;
			BlokDeklaracji blok = null;
			System.Collections.Generic.List<KGrupa> grupyKDostawy = new System.Collections.Generic.List<KGrupa>();			
			System.Collections.Generic.List<KGrupa> grupyKNabycia = new System.Collections.Generic.List<KGrupa>();					
			System.Collections.Generic.List<KGrupa> grupyKUslugi = new System.Collections.Generic.List<KGrupa>();								
			

			foreach(Deklaracja d in dek.Deklaracje){
				kor = d as Soneta.Deklaracje.VAT.VATUEK;
				if(kor==null)
					continue;
				
				//Grupa1
				blok = kor.Bloki["CKorekta"];
				for (int i = 1; i <= dek.LiczbaPozycjiDostawyKorekta; i++) {
					if ((decimal)blok[string.Format("BKwota{0}", i)] == 0 && (decimal)blok[string.Format("JKwota{0}", i)] == 0)
						break;
					grupyKDostawy.Add(
						new KGrupa(
							(string)blok[string.Format("BKod{0}", i)],
							(string)blok[string.Format("BNIP{0}", i)],
							(decimal)blok[string.Format("BKwota{0}", i)],
							(bool)blok[string.Format("BTrojstronna{0}", i)],
							(string)blok[string.Format("JKod{0}", i)],
							(string)blok[string.Format("JNIP{0}", i)],
							(decimal)blok[string.Format("JKwota{0}", i)],
							(bool)blok[string.Format("JTrojstronna{0}", i)]));
				}
				
				//Grupa2
				blok = kor.Bloki["DKorekta"];
				for (int i = 1; i <= dek.LiczbaPozycjiNabyciaKorekta; i++) {
					if ((decimal)blok[string.Format("BKwota{0}", i)] == 0 && (decimal)blok[string.Format("JKwota{0}", i)] == 0)
						break;
					grupyKNabycia.Add(
						new KGrupa(
							(string)blok[string.Format("BKod{0}", i)],
							(string)blok[string.Format("BNIP{0}", i)],
							(decimal)blok[string.Format("BKwota{0}", i)],
							(bool)blok[string.Format("BTrojstronna{0}", i)],
							(string)blok[string.Format("JKod{0}", i)],
							(string)blok[string.Format("JNIP{0}", i)],
							(decimal)blok[string.Format("JKwota{0}", i)],
							(bool)blok[string.Format("JTrojstronna{0}", i)]));
				}	
				
				//Grupa3
				blok = kor.Bloki["EKorekta"];
				for (int i = 1; i <= dek.LiczbaPozycjiUslugiKorekta; i++) {
					if ((decimal)blok[string.Format("BKwota{0}", i)] == 0 && (decimal)blok[string.Format("JKwota{0}", i)] == 0)
						break;
					grupyKUslugi.Add(
						new KGrupa(
							(string)blok[string.Format("BKod{0}", i)],
							(string)blok[string.Format("BNIP{0}", i)],
							(decimal)blok[string.Format("BKwota{0}", i)],
							(bool)blok[string.Format("BTrojstronna{0}", i)],
							(string)blok[string.Format("JKod{0}", i)],
							(string)blok[string.Format("JNIP{0}", i)],
							(decimal)blok[string.Format("JKwota{0}", i)],
							(bool)blok[string.Format("JTrojstronna{0}", i)]));
				}					
			}
			
			KGrupa1.DataSource = grupyKDostawy;
			KGrupa2.DataSource = grupyKNabycia;			
			KGrupa3.DataSource = grupyKUslugi;						
		}
		else{
			KGrupa1.Visible = false;
			KGrupa2.Visible = false;			
			KGrupa3.Visible = false;						
			//Grupa1
			System.Collections.Generic.List<Grupa> grupyDostawy = new System.Collections.Generic.List<Grupa>();
			BlokDeklaracji blok = dek.Bloki["C"];
			for (int i = 1; i <= dek.LiczbaPozycjiDostawy; i++) {
				if ((decimal)blok[string.Format("Kwota{0}", i)] == 0)
					break;
				grupyDostawy.Add(
					new Grupa(
						(string)blok[string.Format("Kod{0}", i)],
						(string)blok[string.Format("NIP{0}", i)],
						(decimal)blok[string.Format("Kwota{0}", i)],
						(bool)blok[string.Format("Trojstronna{0}", i)]));
			}
			
			//Grupa2
			System.Collections.Generic.List<Grupa> grupyNabycia = new System.Collections.Generic.List<Grupa>();		
			blok = dek.Bloki["D"];
			for (int i = 1; i <= dek.LiczbaPozycjiNabycia; i++) {
				if ((decimal)blok[string.Format("Kwota{0}", i)] == 0)
					break;
				grupyNabycia.Add(
					new Grupa(
						(string)blok[string.Format("Kod{0}", i)],
						(string)blok[string.Format("NIP{0}", i)],
						(decimal)blok[string.Format("Kwota{0}", i)],
						(bool)blok[string.Format("Trojstronna{0}", i)]));
			}
			
			//Grupa3
			System.Collections.Generic.List<Grupa> grupyUslugi = new System.Collections.Generic.List<Grupa>();		
			blok = dek.Bloki["E"];
			for (int i = 1; i <= dek.LiczbaPozycjiUslugi; i++) {
				if ((decimal)blok[string.Format("Kwota{0}", i)] == 0)
					break;
				grupyUslugi.Add(
					new Grupa(
						(string)blok[string.Format("Kod{0}", i)],
						(string)blok[string.Format("NIP{0}", i)],
						(decimal)blok[string.Format("Kwota{0}", i)],
						(bool)blok[string.Format("Trojstronna{0}", i)]));
			}			
			
			//załączniki
			System.Collections.Generic.List<Grupa> grupy = null;
			foreach (Deklaracja d in dek.Deklaracje) {
				VATUEAB zal = d as VATUEAB;
				if (zal == null)
					continue;
        if (zal is Soneta.Deklaracje.VAT.VATUEA)
          grupy = grupyDostawy;
        if (zal is Soneta.Deklaracje.VAT.VATUEB)
          grupy = grupyNabycia;
        if (zal is Soneta.Deklaracje.VAT.VATUEC)
          grupy = grupyUslugi;
				blok = zal.Bloki["B"];
				for (int i = 1; i <= 53; i++) {
					if ((decimal)blok[string.Format("Kwota{0}", i)] == 0)
						break;
					grupy.Add(
						new Grupa(
							(string)blok[string.Format("Kod{0}", i)],
							(string)blok[string.Format("NIP{0}", i)],
							(decimal)blok[string.Format("Kwota{0}", i)],
							(bool)blok[string.Format("Trojstronna{0}", i)]));
				}
				
			}

			Grupa1.DataSource = grupyDostawy;
			Grupa2.DataSource = grupyNabycia;		
			Grupa3.DataSource = grupyUslugi;					
		}	
	}
	
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.VAT.VATUE_2,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<%if (dek.Korekta) {%>
<Deklaracja xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://crd.gov.pl/wzor/2011/10/19/687/ http://crd.gov.pl/wzor/2011/10/19/687/schemat.xsd" xmlns="http://crd.gov.pl/wzor/2011/10/19/687/" xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/">
<%} else {%>
<Deklaracja xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://crd.gov.pl/wzor/2011/10/25/690/ http://crd.gov.pl/wzor/2011/10/25/690/schemat.xsd" xmlns="http://crd.gov.pl/wzor/2011/10/25/690/" xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/">
<%} %>
	<Naglowek>
<%if (dek.Korekta) {%>	
		<KodFormularza kodSystemowy="VATUEK (2)" wersjaSchemy="1-1E">VAT-UEK</KodFormularza>
<%} else {%>		
		<KodFormularza kodSystemowy="VAT-UE (2)" wersjaSchemy="1-1E">VAT-UE</KodFormularza>		
<%} %>		
		<WariantFormularza>2</WariantFormularza>
		<Rok><ea:XmlDataLabel ID="DataLabel2" runat="server" DataMember="0.Rok"></ea:XmlDataLabel></Rok>		
<%if (dek.Kwartalna) {%>			
		<Kwartal><ea:XmlDataLabel ID="Kwartal" runat="server" DataMember="0.Kwartal"></ea:XmlDataLabel></Kwartal>
<%} %>						
<%if (dek.Miesieczna) {%>			
		<Miesiac><ea:XmlDataLabel ID="Miesiac" runat="server"  DataMember="0.Miesiac"></ea:XmlDataLabel></Miesiac>
<%} %>								
		<CelZlozenia>1</CelZlozenia>
		<KodUrzedu><ea:XmlDataLabel ID="DataLabel4" runat="server" DataMember="DOD.KodUrzeduSkarbowego"></ea:XmlDataLabel></KodUrzedu>
	</Naglowek>
	<Podmiot1 rola="Podatnik">
		<ea:Section ID="OsobaFizyczna" runat="server"><etd:OsobaFizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel1" runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<etd:ImiePierwsze><ea:XmlDataLabel ID="ImiePiersze" runat="server" XSDType="TImie"></ea:XmlDataLabel></etd:ImiePierwsze>
			<etd:Nazwisko><ea:XmlDataLabel ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel></etd:Nazwisko>
			<etd:DataUrodzenia><ea:XmlDataLabel ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel></etd:DataUrodzenia>
			<ea:XmlDataLabel ID="PESEL" runat="server" ElementName="etd:PESEL" HideEmptyOrZero="true"></ea:XmlDataLabel>
		</etd:OsobaFizyczna></ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server"><etd:OsobaNiefizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel2" runat="server" ElementName="etd:NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<etd:PelnaNazwa><ea:XmlDataLabel ID="NazwaPelna" runat="server" XSDType="TZnakowy"></ea:XmlDataLabel></etd:PelnaNazwa>
            <ea:XmlDataLabel ID="REGON" runat="server" ElementName="etd:REGON" XSDType="TNrREGON" HideEmptyOrZero="true"></ea:XmlDataLabel>
		</etd:OsobaNiefizyczna></ea:Section>
		<etd:AdresZamieszkaniaSiedziby rodzajAdresu="RAD">
			<ea:Section ID="AdresPolski" runat="server"><etd:AdresPol>
				<etd:KodKraju>PL</etd:KodKraju>
				<etd:Wojewodztwo><ea:XmlDataLabel ID="XmlDataLabel3" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin"></ea:XmlDataLabel></etd:Wojewodztwo>
				<etd:Powiat><ea:XmlDataLabel ID="XmlDataLabel4" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"></ea:XmlDataLabel></etd:Powiat>
				<etd:Gmina><ea:XmlDataLabel ID="XmlDataLabel5" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"></ea:XmlDataLabel></etd:Gmina>
				<ea:XmlDataLabel ID="XmlDataLabel6" runat="server" ElementName="etd:Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<etd:NrDomu><ea:XmlDataLabel ID="XmlDataLabel7" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel></etd:NrDomu>
				<ea:XmlDataLabel ID="XmlDataLabel8" runat="server" ElementName="etd:NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
				<etd:Miejscowosc><ea:XmlDataLabel ID="XmlDataLabel9" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></etd:Miejscowosc>
				<etd:KodPocztowy><ea:XmlDataLabel ID="XmlDataLabel10" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></etd:KodPocztowy>
				<etd:Poczta><ea:XmlDataLabel ID="XmlDataLabel11" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc"></ea:XmlDataLabel></etd:Poczta>
			</etd:AdresPol></ea:Section>
			<ea:Section ID="AdresZagraniczny" runat="server"><etd:AdresZagr>
				<etd:KodKraju><ea:XmlDataLabel ID="AdresZagranicznyKodKraju" runat="server"></ea:XmlDataLabel></etd:KodKraju>
				<etd:KodPocztowy><ea:XmlDataLabel runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></etd:KodPocztowy>
				<etd:Miejscowosc><ea:XmlDataLabel runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></etd:Miejscowosc>
				<ea:XmlDataLabel runat="server" ElementName="etd:Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="etd:NrDomu" HideEmptyOrZero="true" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel>
				<ea:XmlDataLabel runat="server" ElementName="etd:NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
			</etd:AdresZagr></ea:Section>
		</etd:AdresZamieszkaniaSiedziby>
	</Podmiot1>	
	<PozycjeSzczegolowe>
		<ea:DataRepeater ID="Grupa1" runat="server" WithSections="False">
			<Grupa1>
				<P_Da><ea:XmlDataLabel ID="Grupa1Kod" runat="server" DataMember="Kod" XSDType="TZnakowy"></ea:XmlDataLabel></P_Da> 
				<P_Db><ea:XmlDataLabel ID="Grupa1NIP" runat="server" DataMember="NIP" XSDType="TNrVatUE"></ea:XmlDataLabel></P_Db> 
				<P_Dc><ea:XmlDataLabel ID="Grupa1Kwota" runat="server" DataMember="Kwota"  XSDType="TKwotaC"></ea:XmlDataLabel></P_Dc> 
				<P_Dd><ea:XmlDataLabel ID="Grupa1Trojstronna" runat="server" DataMember="Trojstronna"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></P_Dd> 
			</Grupa1>
		</ea:DataRepeater>
		<ea:DataRepeater ID="Grupa2" runat="server" WithSections="False">
			<Grupa2>
				<P_Na><ea:XmlDataLabel ID="Grupa2Kod" runat="server" DataMember="Kod" XSDType="TZnakowy"></ea:XmlDataLabel></P_Na> 
				<P_Nb><ea:XmlDataLabel ID="Grupa2NIP" runat="server" DataMember="NIP" XSDType="TNrVatUE"></ea:XmlDataLabel></P_Nb> 
				<P_Nc><ea:XmlDataLabel ID="Grupa2Kwota" runat="server" DataMember="Kwota"  XSDType="TKwotaC"></ea:XmlDataLabel></P_Nc> 
				<P_Nd><ea:XmlDataLabel ID="Grupa2Trojstronna" runat="server" DataMember="Trojstronna"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></P_Nd> 
			</Grupa2>
		</ea:DataRepeater>		
		<ea:DataRepeater ID="Grupa3" runat="server" WithSections="False">
			<Grupa3>
				<P_Ua><ea:XmlDataLabel ID="Grupa3Kod" runat="server" DataMember="Kod" XSDType="TZnakowy"></ea:XmlDataLabel></P_Ua> 
				<P_Ub><ea:XmlDataLabel ID="Grupa3NIP" runat="server" DataMember="NIP" XSDType="TNrVatUE"></ea:XmlDataLabel></P_Ub> 
				<P_Uc><ea:XmlDataLabel ID="Grupa3Kwota" runat="server" DataMember="Kwota"  XSDType="TKwotaC"></ea:XmlDataLabel></P_Uc> 
			</Grupa3>
		</ea:DataRepeater>				
		<ea:DataRepeater ID="KGrupa1" runat="server" WithSections="False" OnBeforeRow="OnBeforeRowKGrupa1">
			<Grupa1>
				<ea:XmlDataLabel ID="KGrupa1BKod" runat="server" DataMember="BKod" ElementName="P_DBa" XSDType="TZnakowy"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1BNIP" runat="server" DataMember="BNIP" ElementName="P_DBb" XSDType="TNrVatUE"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1BKwota" runat="server" DataMember="BKwota"  ElementName="P_DBc" XSDType="TKwotaC"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1BTrojstronna" runat="server" DataMember="BTrojstronna" ElementName="P_DBd"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1JKod" runat="server" DataMember="JKod" ElementName="P_DJa" XSDType="TZnakowy"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1JNIP" runat="server" DataMember="JNIP" ElementName="P_DJb" XSDType="TNrVatUE"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1JKwota" runat="server" DataMember="JKwota" ElementName="P_DJc" XSDType="TKwotaC"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa1JTrojstronna" runat="server" DataMember="JTrojstronna" ElementName="P_DJd" ><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel>		
			</Grupa1>
		</ea:DataRepeater>
		<ea:DataRepeater ID="KGrupa2" runat="server" WithSections="False"  OnBeforeRow="OnBeforeRowKGrupa2">
			<Grupa2>
				<ea:XmlDataLabel ID="KGrupa2BKod" runat="server" DataMember="BKod" ElementName="P_NBa" XSDType="TZnakowy"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa2BNIP" runat="server" DataMember="BNIP" ElementName="P_NBb" XSDType="TNrVatUE"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa2BKwota" runat="server" DataMember="BKwota" ElementName="P_NBc" XSDType="TKwotaC"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa2BTrojstronna" runat="server" DataMember="BTrojstronna" ElementName="P_NBd"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa2JKod" runat="server" DataMember="JKod" ElementName="P_NJa" XSDType="TZnakowy"></ea:XmlDataLabel> 
				<ea:XmlDataLabel ID="KGrupa2JNIP" runat="server" DataMember="JNIP" ElementName="P_NJb" XSDType="TNrVatUE"></ea:XmlDataLabel> 
				<ea:XmlDataLabel ID="KGrupa2JKwota" runat="server" DataMember="JKwota" ElementName="P_NJc" XSDType="TKwotaC"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa2JTrojstronna" runat="server" DataMember="JTrojstronna" ElementName="P_NJd"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel> 				
			</Grupa2>
		</ea:DataRepeater>				
		<ea:DataRepeater ID="KGrupa3" runat="server" WithSections="False"  OnBeforeRow="OnBeforeRowKGrupa3">
			<Grupa3>
				<ea:XmlDataLabel ID="KGrupa3BKod" runat="server" DataMember="BKod" ElementName="P_UBa" XSDType="TZnakowy"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa3BNIP" runat="server" DataMember="BNIP" ElementName="P_UBb" XSDType="TNrVatUE"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa3BKwota" runat="server" DataMember="BKwota" ElementName="P_UBc" XSDType="TKwotaC"></ea:XmlDataLabel>
				<ea:XmlDataLabel ID="KGrupa3JKod" runat="server" DataMember="JKod" ElementName="P_UJa" XSDType="TZnakowy"></ea:XmlDataLabel> 
				<ea:XmlDataLabel ID="KGrupa3JNIP" runat="server" DataMember="JNIP" ElementName="P_UJb" XSDType="TNrVatUE"></ea:XmlDataLabel> 
				<ea:XmlDataLabel ID="KGrupa3JKwota" runat="server" DataMember="JKwota" ElementName="P_UJc" XSDType="TKwotaC"></ea:XmlDataLabel>
			</Grupa3>
		</ea:DataRepeater>						
	</PozycjeSzczegolowe>
	<Oswiadczenie>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za podanie danych niezgodnych z rzeczywistością.</Oswiadczenie>	
</Deklaracja>
