﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="System.Collections.Generic" %>
<script runat="server">

    [DefaultWidth(19)]
    public enum TypZakresu {
        WażneWOkresie, Złożone, Wycofane
    }

    public class PrnParams : ContextBase {

        Date today;
        public PrnParams(Context context)
            : base(context) {
            today = ActualDate.Today(Context);
            okres = FromTo.Year(today.Year);
        }

        DefinicjaOświadczenia definicja = null;
        [Priority(10)]
        public DefinicjaOświadczenia Definicja {
            get { return definicja; }
            set {
                definicja = value;
                if (definicja == null || treść != null && treść.Definicja != definicja)
                    treść = null;
                OnChanged(EventArgs.Empty);
            }
        }

        TreśćOświadczenia treść = null;
        [Priority(20)]
        public TreśćOświadczenia Treść {
            get { return treść; }
            set {
                treść = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public bool IsReadOnlyTreść() {
            return definicja == null;
        }

        public object GetListTreść() {
            return definicja == null ? null : definicja.Treści;
        }

        TypZakresu zakres = TypZakresu.WażneWOkresie;
        [Caption("Zakres")]
        [Priority(30)]
        public TypZakresu Zakres {
            get { return zakres; }
            set {
                zakres = value;
                OnChanged(EventArgs.Empty);
            }
        }

        FromTo okres;
        [Required]
        [Caption("Raport za okres")]
        [Priority(40)]
        public FromTo Okres {
            get { return okres; }
            set {
                if (value == FromTo.Empty)
                    okres = FromTo.Year(today.Year);
                else
                    okres = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    PrnParams pars;
    [Context(Required = true)]
    public PrnParams Params {
        set { pars = value; }
    }

    Dictionary<Pracownik, List<OświadczeniePracownika>> dct = new Dictionary<Pracownik, List<OświadczeniePracownika>>();

    void OnContextLoad(Object sender, EventArgs args) {
        ReportHeader1["NAZWA"] = pars.Definicja == null ? "" : pars.Definicja.Nazwa;
        ReportHeader1["TREŚĆ"] = pars.Treść == null ? "" : pars.Treść.Nazwa;
        ReportHeader1["ZAKRES"] = CaptionAttribute.EnumToString(pars.Zakres);
        ReportHeader1["OKRES"] = pars.Okres.ToString();

        SubTable st;
        if (pars.Treść != null) {
            st = KadryModule.GetInstance(dc).OswiadczeniaPrac.WgTrescOswiadczenia[pars.Treść];
            colNazwa.Visible = colTresc.Visible = false;
        }
        else if (pars.Definicja != null) {
            st = KadryModule.GetInstance(dc).OswiadczeniaPrac.WgDefinicja[pars.Definicja];
            colNazwa.Visible = false;
        }
        else
            st = KadryModule.GetInstance(dc).OswiadczeniaPrac.WgPracownik;

        Soneta.Business.View view = st.CreateView();
        
        switch (pars.Zakres) {
            case TypZakresu.WażneWOkresie:
                view.Condition &= RowCondition.IsIntersected("Okres", pars.Okres);
                break;
                
            case TypZakresu.Złożone:
                if (pars.Okres.From > Date.MinValue)
                    view.Condition &= new FieldCondition.GreaterEqual("DataZlozenia", pars.Okres.From);
                if (pars.Okres.To < Date.MaxValue)
                    view.Condition &= new FieldCondition.LessEqual("DataZlozenia", pars.Okres.To);
                break;
                
            case TypZakresu.Wycofane:
                if (pars.Okres.From > Date.MinValue)
                    view.Condition &= new FieldCondition.GreaterEqual("DataWycofania", pars.Okres.From);
                if (pars.Okres.To < Date.MaxValue)
                    view.Condition &= new FieldCondition.LessEqual("DataWycofania", pars.Okres.To);
                else
                    view.Condition &= new FieldCondition.Less("DataWycofania", Date.MaxValue);
                break;
        }

        foreach (OświadczeniePracownika oświadczenie in view) {
            List<OświadczeniePracownika> lst;
            if (!dct.TryGetValue(oświadczenie.Pracownik, out lst))
                dct.Add(oświadczenie.Pracownik, lst = new List<OświadczeniePracownika>());
            lst.Add(oświadczenie);
        }

        List<Pracownik> lstprc = new List<Pracownik>(dct.Keys);
        lstprc.Sort();
        Grid1.DataSource = lstprc;
    }

    protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
        Pracownik pracownik = (Pracownik)args.Row;
        foreach (OświadczeniePracownika oświadczenie in dct[pracownik]) {
            colNazwa.AddLine(oświadczenie.Definicja.Nazwa);
            colTresc.AddLine(oświadczenie.TrescOswiadczenia.Nazwa);
            colOd.AddLine(oświadczenie.DataZlozenia);
            if (oświadczenie.DataWycofania < Date.MaxValue)
                colDo.AddLine(oświadczenie.DataWycofania);
            else
                colDo.AddLine();
        }
    }

    static void Msg(object value) {
    }
    
</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Badania okresowe</title> 
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="BadaniaOkresowe" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Business.Row[], Soneta.Business"></ea:datacontext>
        <cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" 
            title="Lista oświadczeń|&lt;/strong&gt;Oświadczenie:&lt;strong&gt; %NAZWA%|&lt;/strong&gt;Treść:&lt;strong&gt; %TREŚĆ%|&lt;/strong&gt;Zakres: &lt;strong&gt;%ZAKRES%|&lt;/strong&gt;Okres: &lt;strong&gt;%OKRES%" 
            runat="server"></cc1:ReportHeader>
        <ea:Grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
                <ea:GridColumn DataMember="NazwiskoImię" Caption="Pracownik" 
                    ID="colPrac" NoWrap="True"></ea:GridColumn>
                <ea:GridColumn Width="20" ID="colNazwa" NoWrap="True" 
                    Caption="Oświadczenie~Nazwa"></ea:GridColumn>
                <ea:GridColumn ID="colTresc" runat="server" Caption="Oświadczenie~Treść" 
                    NoWrap="True" Width="25">
                </ea:GridColumn>
                <ea:GridColumn Align="Center" ID="colOd" Caption="Oświadczenie~Data złożenia" 
                    Width="10" NoWrap="True"></ea:GridColumn>
                <ea:GridColumn Align="Center" Caption="Oświadczenie~Data wycofania" ID="colDo" 
                    Width="10" NoWrap="True"></ea:GridColumn>
            </Columns>
        </ea:Grid>
        <cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
    </form>
</body>
</html>
