﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Core;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Place;
using Soneta.Kalend;
using System.Diagnostics;
using System.Collections.Generic;
using Soneta.Web;
using System.Xml;
using Soneta.Deklaracje;
using Soneta.Deklaracje.PIT;
using System.Web.UI.HtmlControls;

namespace ASP {

    public partial class PIT_40_22 : System.Web.UI.Page {

        public string Str_PITWatermark = "Tylko do celów poglądowych";
        public static string Str_PITVerifier = "Wydruk PIT-40 (22) może być drukowany wyłącznie dla deklaracji PIT-40 w wersji 22.";

        public class SrParams : SerializableContextBase {

            public SrParams(Context context) : base(context) {
            }

            bool watermark = true;
            [Caption("Znak wodny")]
            public bool Watermark {
                get { return watermark; }
                set {
                    watermark = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }

        SrParams srpars;
        [SettingsContext]
        public SrParams SrPars {
            get { return srpars; }
            set { srpars = value; }
        }

        protected void dc_ContextLoad(object sender, EventArgs e) {
            Deklaracja pit = (Deklaracja)dc[typeof(Deklaracja)];
            if (pit as PIT40_22 == null)
                throw new InvalidOperationException(Str_PITVerifier);
            PIT40_22 pit40 = (PIT40_22)pit;
            if (!pit.Module.Config.PIT.Ogólne.DanePodatnikaWStopce)
                flDanePodatnika2.Text = flDanePodatnika1.Text = "";
            else {
                flDanePodatnika2.Text = flDanePodatnika1.Text = string.Format("{0}, {1}: {2}",
                            pit40.Podmiot.ToString(),
                            pit40.JestPESEL ? "PESEL" : "NIP",
                            pit40.IdentyfikatorPodatnika);
            }
            if (pit40.JestPESEL) {
                flPeselNip.Text = "<strike>Identyfikator podatkowy NIP</strike>/Numer PESEL <.Indexup>(niepotrzebne skreślić))";
                flPeselNip.ValueStyle = ValueStyles.WideText;
            }
            else {
                flPeselNip.Text = "Identyfikator podatkowy NIP/<strike>Numer PESEL</strike> <.Indexup>(niepotrzebne skreślić))";
                flPeselNip.ValueStyle = ValueStyles.nip_w;
            }
            watermark.Visible = srpars.Watermark;

            if (!dc.OverPrint) {
                string upo = pit.GetNumerUpo();

                if (upo == "") {
                    DefinicjaDokumentu dd = CoreModule.GetInstance(dc).DefDokumentow.WgSymbolu["PIT40Z"];
                    SubTable st = DeklaracjeModule.GetInstance(dc).Deklaracje.WgDefinicja[dd];
                    st = st[new RowCondition.Exists("Deklaracje", "Deklaracja", new FieldCondition.Equal("Guid", pit.Guid))];
                    if (!st.IsEmpty) {
                        Deklaracja dek = (Deklaracja)st.GetPrev();
                        Soneta.Business.View v = dek.EDeklaracje.CreateView();
                        EDeklaracja edek = (EDeklaracja)v.GetLast();
                        if (edek != null && !string.IsNullOrEmpty(edek.GetUPO())) {
                            XmlDocument document = new XmlDocument();
                            document.LoadXml(edek.GetUPO());
                            XmlNamespaceManager nm = new XmlNamespaceManager(document.NameTable);
                            XmlNode nodeToFind = document.SelectSingleNode("//Potwierdzenie/NumerReferencyjny", nm);
                            if (nodeToFind != null) {
                                XmlNode node = document.SelectSingleNode("//Potwierdzenie/NumerReferencyjny/text()", nm);
                                upo = node.Value;
                            }
                        }
                    }
                }

                if (upo != "") {
                    Resize(FrameNIPPlatnika, -64, 0);
                    Move(FrameNrDokumentu, 0, -64);
                    Resize(FrameNrDokumentu, 64, 0);
                    FrameNrDokumentu.EditValue = upo;
                }
            }
        }

        void Resize(System.Web.UI.WebControls.WebControl fl, int dwidth, int dheight) {
            if (dwidth != 0)
                fl.Style["width"] = (ParsePx(fl.Style["width"]) + dwidth) + "px";
            if (dheight != 0)
                fl.Style["height"] = (ParsePx(fl.Style["height"]) + dheight) + "px";
        }

        void Move(System.Web.UI.WebControls.WebControl fl, int dtop, int dleft) {
            if (dtop != 0)
                fl.Style["TOP"] = (ParsePx(fl.Style["TOP"]) + dtop) + "px";
            if (dleft != 0)
                fl.Style["LEFT"] = (ParsePx(fl.Style["LEFT"]) + dleft) + "px";
        }

        int ParsePx(string px) {
            return int.Parse(px.Substring(0, px.Length - 2));
        }

    }
}
