﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Waluty" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Kompensata</title>
		<script runat="server">
            public class Params : ContextBase
		    {
			    public Params(Context ctx)
				    : base(ctx)
			    {
			    }


                [Priority(99)]
                [Caption("Adres korespondencyjny")]
                public Boolean AdresKorespondencyjny { get; set; }
		    }


		    private Params prm;

		    [Context]
		    public Params Prm
		    { set { prm = value; } }

		    void OnContextLoad(object sender, EventArgs args)
		    {
		        Cesja dok = (Cesja) dc[typeof (Cesja)];
		        if (dok.Rodzaj == RodzajeCesji.Należności)
		        {
		            colZob.Visible = false;
		            colZob2.Visible = false;
		        }
		        else
		        {
		            colNal.Visible = false;
		            colNal2.Visible = false;
		        }

		        var pieczatka = ReportHeader.GetPieczątka(dc);

		        IdPieczatka1x.EditValue = IdPieczatka1.EditValue = pieczatka.NazwaFormatowana;
		        IdPieczatka2x.EditValue = IdPieczatka2.EditValue = pieczatka.Adres.Linia1;
		        IdPieczatka3x.EditValue = IdPieczatka3.EditValue = pieczatka.Adres.Linia2;

		        var kh = dok.Podmiot as Kontrahent;
                if (kh != null && prm.AdresKorespondencyjny && !String.IsNullOrWhiteSpace(kh.KorespondencjaNazwaFirmy + kh.AdresDoKorespondencji.Linia1 + kh.AdresDoKorespondencji.Linia2))
                {
                    LblAdPodmiot.EditValue = String.IsNullOrWhiteSpace(kh.KorespondencjaNazwaFirmy) ? dok.Podmiot.NazwaFormatowana : kh.KorespondencjaNazwaFirmy;
                    LblAdAdresLinia1.EditValue = kh.AdresDoKorespondencji.Linia1;
                    LblAdAdresLinia2.EditValue = kh.AdresDoKorespondencji.Linia2;
                    ScAdresat.Visible = true;
                }
                LblPodmiot.EditValue = Lbl2Podmiot.EditValue = dok.Podmiot.NazwaFormatowana;
                LblAdresLinia1.EditValue = Lbl2AdresLinia1.EditValue = dok.Podmiot.Adres.Linia1;
                LblAdresLinia2.EditValue = Lbl2AdresLinia2.EditValue = dok.Podmiot.Adres.Linia2;
		    }

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="Kompensata" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Kasa.Cesja,Soneta.Kasa"></ea:datacontext>
			<cc1:ReportHeader id="ReportHeader1" title="Cesja {3}|</strong>Numer: <strong>{0}|</strong>Data: <strong>{1}|</strong>Waluta: <strong>{2}|ODCINEK A"
				runat="server" DataMember0="Numer" DataMember1="Data" DataMember2="Kwota.Symbol" DataMember3="Rodzaj"></cc1:ReportHeader>
			<p>
				<em>Nadawca:</em><br>
				<ea:datalabel id="IdPieczatka1" runat="server"></ea:datalabel><br>
				<ea:datalabel id="IdPieczatka2" runat="server"></ea:datalabel><br>
				<ea:datalabel id="IdPieczatka3" runat="server"></ea:datalabel>
			</p>
			<table style="width: 100%; border:hidden">
            <tbody>
                <tr>
                    <td valign="top" width="50%">
		                <p>
			                <em>Odbiorca:</em><br />
			                <ea:DataLabel ID="LblPodmiot" runat="server" /><br />
			                <ea:DataLabel ID="LblAdresLinia1" runat="server" /><br />
			                <ea:DataLabel ID="LblAdresLinia2" runat="server" />
		                </p>
                    </td>
                    <td valign="top" width="50%">
                        <ea:Section runat="server" ID="ScAdresat" Visible="false">
                        <p>
			                <em>Adres korespondencyjny:</em><br />
			                <ea:DataLabel ID="LblAdPodmiot" runat="server" /><br />
			                <ea:DataLabel ID="LblAdAdresLinia1" runat="server" /><br />
			                <ea:DataLabel ID="LblAdAdresLinia2" runat="server" />
		                </p>
                        </ea:Section>
                    </td>
                </tr>
            </tbody>
            </table>
			<p>
				Informujemy o dokonaniu, na podstawie wzajemnych umów i uzgodnień, cesji
				<ea:DataLabel id="DataLabel22" runat="server" DataMember="Rodzaj" Width="84px" Bold="False"></ea:DataLabel>
				&nbsp;na kwotę
				<ea:DataLabel id="DataLabel4" runat="server" DataMember="Kwota" DESIGNTIMEDRAGDROP="324" Format="{0:u}"></ea:DataLabel>&nbsp;w 
				dniu
				<ea:DataLabel id="DataLabel20" runat="server" DESIGNTIMEDRAGDROP="28" DataMember="Data" Width="84px"></ea:DataLabel>
				&nbsp;wg podanego poniżej zestawienia:
			</p>
			<p>
				<ea:Grid id="Grid1" runat="server" DataMember="Pozycje" RowTypeName="Soneta.Kasa.KompensataPozycja,Soneta.Kasa"
					RowsInRow="2" Sort="DataDokumentu,NumerDokumentu">
					<Columns>
						<ea:GridColumn Width="25" DataMember="NumerDokumentu" Caption="Dokument" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" DataMember="DataDokumentu" Caption="Data"></ea:GridColumn>
						<ea:GridColumn ColSpan="2" DataMember="Opis" Caption="Opis"></ea:GridColumn>
						<ea:GridColumn DataMember="Kompensowany.Podmiot" Total="Info" Caption="Kontrahent"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Należność" Total="Sum" Caption="Należności"
							HideZero="True" Format="{0:n}" ID="colNal" RowSpan="2"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Zobowiązanie" Total="Sum" Caption="Zobowiązania"
							HideZero="True" Format="{0:n}" ID="colZob" RowSpan="2"></ea:GridColumn>
					</Columns>
				</ea:Grid>
			</p>
			<p>
				<table id="Table1" cellspacing="0" cellpadding="0" width="90%">
					<tbody>
						<tr>
							<td align="right" width="40%" colspan="1" rowspan="1">
								Razem:</td>
							<td align="right">
								<ea:DataLabel id="DataLabel5" runat="server" DataMember="Kwota" Format="{0:u}"></ea:DataLabel>
							</td>
						</tr>
						<tr>
							<td align="right">
								<font size="2"><em>Słownie:</em></font></td>
							<td align="right">
								<font size="2"><em>
										<ea:DataLabel id="DataLabel6" runat="server" DataMember="Kwota" Bold="False" Format="{0:t}"></ea:DataLabel>
									</em></font>
							</td>
						</tr>
					</tbody>
				</table>
			</p>
			<p>
				<ea:DataLabel id="DataLabel7" runat="server" DataMember="Opis" Bold="False"></ea:DataLabel>
			</p>
			<p>
				Prosimy o zgodne z nami księgowanie i odesłanie potwiedzonego dokumentu cesji.
			</p>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False" Height="105px">
				<Subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Data i podpis" Width="50"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
			<ea:PageBreak id="PageBreak1" runat="server"></ea:PageBreak>
			<cc1:ReportHeader id="Reportheader2" title="Cesja {3}|</strong>Numer: <strong>{0}|</strong>Data: <strong>{1}|</strong>Waluta: <strong>{2}|ODCINEK B"
				runat="server" DataMember0="Numer" DataMember1="Data" DataMember2="Kwota.Symbol" DataMember3="Rodzaj"></cc1:ReportHeader>
			<p>
				<em>Nadawca:</em><br/>
				<ea:DataLabel id="Lbl2Podmiot" runat="server"></ea:DataLabel><br/>
				<ea:DataLabel id="Lbl2AdresLinia1" runat="server"></ea:DataLabel><br/>
				<ea:DataLabel id="Lbl2AdresLinia2" runat="server"></ea:DataLabel>
			</p>
			<p>
				<em>Odbiorca:</em>
				<br>
				<ea:datalabel id="IdPieczatka1x" runat="server" ></ea:datalabel><br>
				<ea:datalabel id="IdPieczatka2x" runat="server" ></ea:datalabel><br>
				<ea:datalabel id="IdPieczatka3x" runat="server" ></ea:datalabel>
			</p>
			<p>
				Potwierdzamy dokonanie cesji
				<ea:DataLabel id="DataLabel23" runat="server" DataMember="Rodzaj" Bold="False"></ea:DataLabel>&nbsp;na 
				kwotę
				<ea:DataLabel id="Datalabel17" runat="server" DESIGNTIMEDRAGDROP="69" DataMember="Kwota" Format="{0:u}"></ea:DataLabel>&nbsp;w 
				dniu&nbsp;
				<ea:DataLabel id="DataLabel21" runat="server" DataMember="Data"></ea:DataLabel>
				&nbsp;wg podanego poniżej zestawienia:
			</p>
			<P>
				<ea:Grid id="Grid2" runat="server" DataMember="Pozycje" RowTypeName="Soneta.Kasa.KompensataPozycja,Soneta.Kasa"
					RowsInRow="2" Sort="DataDokumentu,NumerDokumentu">
					<Columns>
						<ea:GridColumn Width="25" DataMember="NumerDokumentu" Caption="Dokument" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" DataMember="DataDokumentu" Caption="Data"></ea:GridColumn>
						<ea:GridColumn ColSpan="2" DataMember="Opis" Caption="Opis" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn DataMember="Kompensowany.Podmiot" Total="Info" Caption="Kontrahent"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Należność" Total="Sum" Caption="Należności"
							HideZero="True" Format="{0:n}" ID="colNal2" RowSpan="2"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Zobowiązanie" Total="Sum" Caption="Zobowiązania"
							HideZero="True" Format="{0:n}" ID="colZob2" RowSpan="2"></ea:GridColumn>
					</Columns>
				</ea:Grid></P>
			<p>
				<table id="Table1" cellspacing="0" cellpadding="0" width="90%">
					<tbody>
						<tr>
							<td align="right" width="40%" colspan="1" rowspan="1">
								Razem:</td>
							<td align="right">
								<ea:DataLabel id="Datalabel18" runat="server" DataMember="Kwota" Format="{0:u}"></ea:DataLabel>
							</td>
						</tr>
						<tr>
							<td align="right">
								<font size="2"><em>Słownie:</em></font></td>
							<td align="right">
								<font size="2"><em>
										<ea:DataLabel id="Datalabel19" runat="server" DataMember="Kwota" Bold="False" Format="{0:t}"></ea:DataLabel>
									</em></font>
							</td>
						</tr>
					</tbody>
				</table>
			</p>
			<cc1:ReportFooter id="Reportfooter2" runat="server" TheEnd="False" Height="105px">
				<Subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Data i podpis" Width="50"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
		</form>
	</body>
</HTML>
