﻿using System;
using System.Collections.Generic;
using Soneta.Tools;
using Soneta.Types;
using Soneta.Ksiega;
using Soneta.Business;
using Soneta.Web;
using System.Collections;

namespace ASP
{
    public partial class Dziennik : System.Web.UI.Page
    {
        public string Str_Tak = "Tak";
        public string Str_Nie = "Nie";
        public string Str_Wszystkie = "wszystkie";
        public string Str_Oddzial = "| Oddział: {0}";
        public static string Exc_NalezyUstawicMiesiac = "Należy ustawić miesiąc";
        public static string Exc_MiesiacWczesniejszy = "Miesiąc wcześniejszy o daty ropoczęcia okresu.";
        public static string Str_SumaPozabilansowa = "<b>Suma pozabilansowych:</b>";

        protected void Grid1_ItemsGet(Object sender, ItemsGetEventArgs args)
        {
            if (args.Deep == 1)
            {
                Dekret dekret = (Dekret)args.Row;
                ArrayList arr = new ArrayList(dekret.Zapisy.Count + 1);
                arr.Add(dekret);
                if (prms.TylkoBilansowe)
                {
                    foreach (ZapisKsiegowy z in dekret.Zapisy)
                        if (z.Konto.Bilansowe)
                            arr.Add(z);
                }
                else
                    arr.AddRange(dekret.Zapisy);
                args.Enumerable = arr;
            }
        }

        protected void Grid1_OnBeforeRow(object sender, Soneta.Web.RowEventArgs args)
        {
            if (args.Row is ZapisKsiegowy)
            {
                ZapisKsiegowy zapis = (ZapisKsiegowy)args.Row;
                colLp.EditValue = lp++;
                colOperator.EditValue = (zapis.Konto.Bilansowe) ? Str_Tak : Str_Nie;
                colNumer.EditValue = zapis.Numer;
                colKonto.EditValue = zapis.Konto.Symbol;
                if (!zapis.Konto.Bilansowe)
                {
                    colWinien.SumRow = false;
                    colMa.SumRow = false;
                    sumaPozabilansowa[0].Winien += zapis.Winien.Value;
                    sumaPozabilansowa[0].Ma += zapis.Ma.Value;
                }
                colWinien.EditValue = zapis.Winien.Value;
                colMa.EditValue = zapis.Ma.Value;
                colOpis.EditValue = zapis.Opis;
            }
            else
            {
                Dekret dekret = (Dekret)args.Row;
                if (dekret.Bufor && dekret.Wprowadzil != null)
                    colOperator.EditValue = dekret.Wprowadzil.Name;
                if (!dekret.Bufor && dekret.Zatwierdzil != null)
                    colOperator.EditValue = dekret.Zatwierdzil.Name;
                colNumer.EditValue = dekret.Numer.NumerPelny;
                colData.EditValue = dekret.Data;
                colDataOperacji.EditValue = dekret.Ewidencja.DataOperacji;
                colDataDokumentu.EditValue = dekret.Ewidencja.DataDokumentu;
                colNrDokumentu.EditValue = dekret.NumerDokumentu;
                colWinien.SumRow = false;
                colWinien.EditValue = dekret.Winien.Value;
                colMa.SumRow = false;
                colMa.EditValue = dekret.Ma.Value;
                colOpis.EditValue = dekret.Opis;
                if (Prms.Definicja == null)
                {
                    DodajDoDziennikaCzastkowego(dekret.DefinicjaEwidencji, dekret.Winien.Value, dekret.Ma.Value);
                }
            }

        }

        protected void Grid2_OnBeforeRow(object sender, Soneta.Web.RowEventArgs args)
        {
        }

        DictionaryZero<Soneta.Core.DefinicjaDokumentu, SumaDziennika> sumyCzastkoweDziennika = new DictionaryZero<Soneta.Core.DefinicjaDokumentu, SumaDziennika>();
        List<SumaPozabilansowa> sumaPozabilansowa = new List<SumaPozabilansowa>();

        protected void OnContextLoad(Object sender, EventArgs args)
        {
            ReportHeader1.Title = string.Format(
                ReportHeader1.Title,
                Prms.Okres,
                Prms.Miesiac.ToFromTo(),
                (Prms.Bufor) ? Str_Tak : Str_Nie,
                Prms.TypDokumentu, Prms.Definicja == null ? Str_Wszystkie : Prms.Definicja.ToString(),
                Prms.TylkoBilansowe ? Str_Tak : Str_Nie);

            if (Prms.oddzialParams.OddzialowoscEnabled)
                ReportHeader1.Title += string.Format(Str_Oddzial, Prms.Oddzial);
            SubTable st = new SubTable(KsiegaModule.GetInstance(Prms.Okres).Dziennik.WgOkres[Prms.Okres, TypDziennika.Dekret], Prms.Miesiac.ToFromTo());
            st = st[getParamsCondition()];
            Grid1.DataSource = st;
            Grid2.DataSource = sumyCzastkoweDziennika.Values;

            sumaPozabilansowa.Add(new SumaPozabilansowa());
            GridPozabilansowy.DataSource = sumaPozabilansowa;

            if (prms.TylkoBilansowe)
                SecSumaPozabilansowa.Visible = false;

            if (!prms.PokazSzczegoly)
                szczegoly.Visible = false;

            if (prms.Definicja != null || !prms.PokazSumy)
                dziennikiCzastkowe.Visible = false;

            if (!prms.PokazSzczegoly && prms.PokazSumy)
            {
                foreach (DekretBase d in st)
                {
                    DodajDoDziennikaCzastkowego(d.DefinicjaEwidencji, d.Winien.Value, d.Ma.Value);
                }
            }

            //zlicz poprzedni okres
            decimal poprzWinien = 0m;
            decimal poprzMa = 0m;
            Query.Table t = null;

            if (Prms.ZaOkres.From.AddDays(-1) > Prms.Okres.Okres.From)
            {
                t = getQueryTable(new FromTo(Prms.Okres.Okres.From, Prms.ZaOkres.From.AddDays(-1)));
                t.Condition &= getParamsCondition();
                foreach (DziennikQuery dq in Prms.Session.Execute<DziennikQuery>(t))
                {
                    poprzWinien += dq.Winien;
                    poprzMa += dq.Ma;
                }
            }

            //zlicz aktualny okres i narastająco
            decimal aktWinien = 0m;
            decimal aktMa = 0m;
            decimal narastWinien = 0m;
            decimal narastMa = 0m;

            t = getQueryTable(Prms.ZaOkres);
            t.Condition &= getParamsCondition();
            foreach (DziennikQuery dq in Prms.Session.Execute<DziennikQuery>(t))
            {
                aktWinien += dq.Winien;
                aktMa += dq.Ma;
            }

            narastWinien = poprzWinien + aktWinien;
            narastMa = poprzMa + aktMa;

            DLWinien.EditValue = aktWinien;
            DLMa.EditValue = aktMa;

            DLWinienPoprz.EditValue = poprzWinien;
            DLMaPoprz.EditValue = poprzMa;

            DLWinienNarast.EditValue = narastWinien;
            DLMaNarast.EditValue = narastMa;

        }

        Query.Table getQueryTable(FromTo zakres)
        {
            Query.Table t = new Query.Table("Dziennik");
            t.Distinct = true;
            Query.Argument arg = new Query.Sum(new Query.Field("Winien.Value"));
            arg.PropertyName = "Winien";
            t += arg;
            arg = new Query.Sum(new Query.Field("Ma.Value"));
            arg.PropertyName = "Ma";
            t += arg;
            t.Condition =
              new FieldCondition.Equal("Okres", Prms.Okres)
              & new FieldCondition.Equal("Typ", TypDziennika.Dekret)
              & new FieldCondition.Contain("Data", zakres);
            return t;
        }

        RowCondition getParamsCondition()
        {
            RowCondition cond = RowCondition.Empty;
            if (!Prms.Bufor)
                cond &= new FieldCondition.Equal("Bufor", false);

            if (Prms.TypDokumentu != Soneta.Core.TypDokumentu.Niezdefiniowany)
                cond &= new FieldCondition.Equal("Ewidencja.Typ", Prms.TypDokumentu);
            if (Prms.Definicja != null)
                cond &= new FieldCondition.Equal("DefinicjaEwidencji", Prms.Definicja);
            if (Prms.oddzialParams.OddzialowoscEnabled)
                cond &= Prms.oddzialParams.GetCondition("Ewidencja.Oddzial");
            return cond;
        }

        public class DziennikQuery
        {
            decimal winien;
            public decimal Winien { get { return winien; } set { winien = value; } }
            decimal ma;
            public decimal Ma { get { return ma; } set { ma = value; } }
        }



        int lp = 1;

        ReportParams prms = null;
        [Context]
        public ReportParams Prms
        {
            get { return prms; }
            set { prms = value; }
        }

        public class ReportParams : ContextBase
        {
            internal Soneta.Core.OddzialParamsBase oddzialParams = null;
            private bool isPulpitKB = false;

            public ReportParams(Context cx) : base(cx)
            {
                okres = (OkresObrachunkowy)cx[typeof(OkresObrachunkowy)];
                oddzialParams = (Soneta.Core.OddzialParamsBase)cx[typeof(Soneta.Core.OddzialParamsBase)];
                isPulpitKB = cx.Session.Login.IsWebUser &&
                    cx.Session.Login.WebUserInstance != null &&
                    cx.Session.Login.WebUserInstance.HasLicence(Soneta.Business.Licence.LicencjaProgramu.KBN);
            }

            OkresObrachunkowy okres = null;
            [Caption("Okres")]
            [Priority(1)]
            public OkresObrachunkowy Okres
            {
                get { return okres; }
            }

            public bool IsVisibleOkres() { return !isPulpitKB; }

            YearMonth miesiac = Date.Today.ToYearMonth();
            [Caption("Miesiąc")]
            [Priority(2)]
            public YearMonth Miesiac
            {
                get { return miesiac; }
                set
                {

                    if (value == YearMonth.Empty)
                        throw new Exception(Exc_NalezyUstawicMiesiac);
                    FromTo ft = value.ToFromTo();
                    if (Okres.Okres.From > ft.From && Okres.Okres.From.ToYearMonth() != ft.From.ToYearMonth())
                        throw new Exception(Exc_MiesiacWczesniejszy);
                    miesiac = value;

                }
            }

            internal FromTo ZaOkres
            {
                get
                {
                    if (Miesiac == YearMonth.Empty)
                        return FromTo.Empty;
                    return Miesiac.ToFromTo();
                }
            }

            bool bufor = true;
            [Caption("Uwzględniaj bufor")]
            [Priority(3)]
            public bool Bufor
            {
                get { return bufor; }
                set { bufor = value; }
            }

            Soneta.Core.TypDokumentu typDokumentu = Soneta.Core.TypDokumentu.Niezdefiniowany;
            [Caption("Typ ewidencji")]
            [Priority(4)]
            public Soneta.Core.TypDokumentu TypDokumentu
            {
                get { return typDokumentu; }
                set
                {
                    typDokumentu = value;
                    definicja = null;
                    OnChanged(EventArgs.Empty);
                }
            }

            public bool IsVisibleTypDokumentu() { return !isPulpitKB; }

            public Soneta.Core.TypDokumentu[] GetListTypDokumentu()
            {
                return
                                  Soneta.Core.CoreModule.GetInstance(this).Config.EwidencjaDokumentów.UkryjTypyEwidencji.UkryjTypy(
                                      Soneta.Core.DokEwidencja.TypyDokumentowEwidencji(Session, true)
                                  );
            }

            Soneta.Core.DefinicjaDokumentu definicja = null;
            [Caption("Definicja ewidencji")]
            [Priority(5)]
            public Soneta.Core.DefinicjaDokumentu Definicja
            {
                get { return definicja; }
                set { definicja = value; OnChanged(EventArgs.Empty); }
            }

            public bool IsVisibleDefinicja() { return !isPulpitKB; }

            public LookupInfo GetListDefinicja()
            {
                return new LookupInfo(Soneta.Core.CoreModule.GetInstance(Session).DefDokumentow.WgTypu[TypDokumentu]);
            }

            [Caption("Oddział")]
            [Priority(6)]
            public Soneta.Core.OddziałItem Oddzial
            {
                get { return oddzialParams.Oddział; }
                set { oddzialParams.Oddział = value; }
            }

            public bool IsVisibleOddzial() { return !isPulpitKB; }

            public object GetListOddzial()
            {
                return oddzialParams.GetListOddział();
            }

            public bool IsReadOnlyOddzial()
            {
                return oddzialParams.IsReadOnlyOddział();
            }

            bool pokazSzczegoly = true;
            [Caption("Pokaż szczegóły")]
            [Priority(7)]
            public bool PokazSzczegoly
            {
                get { return pokazSzczegoly; }
                set { pokazSzczegoly = value; OnChanged(EventArgs.Empty); }
            }

            bool pokazSumy = false;
            [Caption("Pokaż sumy cząstk.")]
            [Priority(8)]
            public bool PokazSumy
            {
                get { return pokazSumy; }
                set { pokazSumy = value; OnChanged(EventArgs.Empty); }
            }

            public bool IsVisiblePokazSumy() { return !isPulpitKB; }

            bool tylkoBilansowe = false;
            [Caption("Tylko bilansowe")]
            [Priority(8)]
            public bool TylkoBilansowe
            {
                get { return tylkoBilansowe; }
                set { tylkoBilansowe = value; OnChanged(EventArgs.Empty); }
            }

            public bool IsVisibleTylkoBilansowe() { return !isPulpitKB; }

        }

        void DodajDoDziennikaCzastkowego(Soneta.Core.DefinicjaDokumentu definicja, decimal winien, decimal ma)
        {
            SumaDziennika sd = null;
            if (sumyCzastkoweDziennika.ContainsKey(definicja))
                sd = sumyCzastkoweDziennika[definicja];
            else
            {
                sd = new SumaDziennika(definicja);
                sumyCzastkoweDziennika.Add(definicja, sd);
            }
            sd.Add(winien, ma);
        }

        public class SumaDziennika
        {
            readonly Soneta.Core.DefinicjaDokumentu definicja;
            decimal winien = 0m;
            decimal ma = 0m;

            public SumaDziennika(Soneta.Core.DefinicjaDokumentu definicja)
            {
                this.definicja = definicja;
            }

            public void Add(decimal winien, decimal ma)
            {
                this.winien += winien;
                this.ma += ma;
            }

            public Soneta.Core.DefinicjaDokumentu Definicja
            {
                get { return definicja; }
            }

            public decimal Winien
            {
                get { return winien; }
            }

            public decimal Ma
            {
                get { return ma; }
            }
        }

        public class SumaPozabilansowa
        {
            public string SumaText { get { return Str_SumaPozabilansowa; } }

            public decimal Winien { get; set; }

            public decimal Ma { get; set; }
        }
    }
}