function hideStackView(e) {
  const stackView = document.getElementsByClassName("stackview")[0];
  if (stackView) stackView.style.display = "none";
}

function showDetails(e) {
  const target = e && e.target;
  if (!target) return false;

  var stackView = document.getElementsByClassName("stackview")[0],
      stackContent = stackView.getElementsByClassName("stackview_content")[0],
      parent = target.parentElement,
      trace = parent.getElementsByClassName("stacktrace")[0];

  if (stackView && trace) {
      stackContent.innerHTML = trace.innerHTML;
      stackView.style.display = "block";
  }
}

function initListeners() {
  const close = document.getElementById("close");
  close.addEventListener("click", hideStackView, false);

  const btns = document.getElementsByClassName("btnShowDetails");
  for (var i = 0; i < btns.length; i++) {
      const b = btns[i];
      b.addEventListener("click", showDetails, false);
  }
}

document.addEventListener('DOMContentLoaded', initListeners, false);