﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.Xml" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<script runat="server">
    protected void dc_ContextLoad(object sender, EventArgs e) {
        PIT pit = (PIT)dc[typeof(PIT)];
        if (pit as PIT40_20 == null)
            throw new InvalidOperationException("Wydruk PIT-40 (20) może być drukowany wyłącznie dla deklaracji PIT-40 w wersji 20.");
        PIT40_20 pit40 = (PIT40_20)pit;
        if (!pit.Module.Config.PIT.Ogólne.DanePodatnikaWStopce)
            flDanePodatnika2.Text = flDanePodatnika1.Text = "";
        else {
            flDanePodatnika2.Text = flDanePodatnika1.Text = string.Format("{0}, {1}: {2}",
                        pit40.Podmiot.ToString(),
                        pit40.JestPESEL ? "PESEL" : "NIP",
                        pit40.IdentyfikatorPodatnika);
        }
        if (pit40.JestPESEL) {
            flPeselNip.Text = "<strike>Identyfikator podatkowy NIP</strike>/Numer PESEL <.Indexup>(niepotrzebne skreślić))";
            flPeselNip.ValueStyle = ValueStyles.WideText;
        }
        else {
            flPeselNip.Text = "Identyfikator podatkowy NIP/<strike>Numer PESEL</strike> <.Indexup>(niepotrzebne skreślić))";
            flPeselNip.ValueStyle = ValueStyles.nip_w;
        }
        if (!dc.OverPrint) {
            string upo = (pit.Deklaracja ?? pit).GetNumerUpo();
            if (upo != "") {
                Resize(FrameNIPPlatnika, -64, 0);
                Move(FrameNrDokumentu, 0, -64);
                Resize(FrameNrDokumentu, 64, 0);
                FrameNrDokumentu.EditValue = upo;
            }
        }
    }

    void Resize(WebControl fl, int dwidth, int dheight) {
        if (dwidth != 0)
            fl.Style["width"] = (ParsePx(fl.Style["width"]) + dwidth) + "px";
        if (dheight != 0)
            fl.Style["height"] = (ParsePx(fl.Style["height"]) + dheight) + "px";
    }
                        
    void Move(WebControl fl, int dtop, int dleft) {
        if (dtop != 0)
            fl.Style["TOP"] = (ParsePx(fl.Style["TOP"]) + dtop) + "px";
        if (dleft != 0)
            fl.Style["LEFT"] = (ParsePx(fl.Style["LEFT"]) + dleft) + "px";
    }
            
    int ParsePx(string px) {
        return int.Parse(px.Substring(0, px.Length - 2));
    }
</script>
<HTML>
	<HEAD>
		<title>PIT-40 (20)</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body leftMargin="0" rightMargin="0">
		<form id="PIT_40_20" method="post" runat="server">
			<ea:DeklaracjaHeader id="DeklaracjaHeader1" style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 0px"
				runat="server" StylNagłówka="JasneCiemneElektroniczniePortal2"></ea:DeklaracjaHeader>
<ea:framelabel id="FrameNIPPlatnika" style="Z-INDEX: 101; LEFT: 0px; POSITION: absolute; TOP: 21px; width: 359px;"
				runat="server" ValueStyle="nip_w" DataMember="0.Nip" Height="28px" 
                Text="1. Identyfikator podatkowy NIP płatnika"></ea:framelabel>
<ea:framelabel id="FrameNrDokumentu" style="Z-INDEX: 102; LEFT: 358px; POSITION: absolute; TOP: 21px; width: 193px;"
				runat="server" Height="28px" Text="Nr dokumentu" FrameStyle="SmallBoldGray" Number="2"></ea:framelabel>
<ea:framelabel id="FrameLabel23" style="Z-INDEX: 103; LEFT: 552px; POSITION: absolute; TOP: 21px; width: 97px;"
				runat="server" Height="30px" Text="Status" FrameStyle="SmallBoldGray" Number="3"></ea:framelabel>
<ea:framelabel id="FrameLabel35" style="Z-INDEX: 104; LEFT: 0px; POSITION: absolute; TOP: 49px"
				runat="server" Height="14px" Width="63px" Text="PIT-40" FrameBorderStyle="None" FrameStyle="BigBold"></ea:framelabel>
<ea:framelabel id="FrameLabel34" style="Z-INDEX: 105; LEFT: 7px; POSITION: absolute; TOP: 70px"
				runat="server" Height="35px" Width="518px" Text="ROCZNE OBLICZENIE PODATKU OD DOCHODU<br>UZYSKANEGO PRZEZ PODATNIKA"
				FrameBorderStyle="None" FrameStyle="BigBold" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel19" style="Z-INDEX: 106; LEFT: 301px; POSITION: absolute; TOP: 112px"
				runat="server" DataMember="0.Rok" Height="28px" Width="112px" Text="4. Rok" ValueStyle="n4"></ea:framelabel>
<ea:framelabel id="FrameLabel29" style="Z-INDEX: 107; LEFT: 91px; POSITION: absolute; TOP: 119px"
				runat="server" Height="17px" Width="179px" Text="W ROKU PODATKOWYM" FrameBorderStyle="None"
				FrameStyle="BigBold"></ea:framelabel>
<ea:framelabel id="FrameLabel24" style="Z-INDEX: 108; LEFT: 0px; POSITION: absolute; TOP: 147px"
				runat="server" Height="91px" Width="651px" FrameStyle="SmallBoldYellow" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="FrameLabel25" style="Z-INDEX: 109; LEFT: 7px; POSITION: absolute; TOP: 154px"
				runat="server" Height="14px" Width="91px" Text="Podstawa prawna:" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel26" style="Z-INDEX: 110; LEFT: 133px; POSITION: absolute; TOP: 154px"
				runat="server" Height="21px" Width="504px" Text='Art.37 ust.1 ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych (Dz. U. z 2012 r. poz.361 z późn. zm.), zwanej dalej "ustawą".'
				FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel27" style="Z-INDEX: 111; LEFT: 7px; POSITION: absolute; TOP: 175px"
				runat="server" Height="7px" Width="91px" Text="Składający:" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel28" style="Z-INDEX: 112; LEFT: 133px; POSITION: absolute; TOP: 175px"
				runat="server" Height="7px" Width="511px" Text="Płatnik podatku dochodowego od osób fizycznych."
				FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel30" style="Z-INDEX: 113; LEFT: 7px; POSITION: absolute; TOP: 186px"
				runat="server" Height="7px" Width="91px" Text="Termin składania:" FrameBorderStyle="None"
				FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel31" style="Z-INDEX: 114; LEFT: 133px; POSITION: absolute; TOP: 186px"
				runat="server" Height="29px" Width="511px" Text="Do końca lutego roku następującego po roku podatkowym - wyłącznie dla PIT-40 składanego urzędowi skarbowemu za pomocą środków komunikacji elektronicznej oraz podatnikowi; do końca stycznia roku następującego po roku podatkowym w przypadku PIT-40 składanego urzędowi skarbowemu w formie dokumentu pisemnego, zgodnie z art. 45ba ust. 2 ustawy."
				FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel32" style="Z-INDEX: 115; LEFT: 7px; POSITION: absolute; TOP: 216px"
				runat="server" Height="7px" Width="91px" Text="Otrzymuje:" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel33" style="Z-INDEX: 116; LEFT: 133px; POSITION: absolute; TOP: 216px"
				runat="server" Height="9px" Width="511px" Text='Podatnik oraz urząd, o których mowa w art.37 ust.3 ustawy, zwany dalej "urzędem".'
				FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel17" style="Z-INDEX: 117; LEFT: 0px; POSITION: absolute; TOP: 238px"
				runat="server" Height="91px" Width="651px" Text="A. MIEJSCE I CEL SKŁADANIA FORMULARZA" FrameBorderStyle="DoubleBottom"
				FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel18" style="Z-INDEX: 118; LEFT: 28px; POSITION: absolute; TOP: 266px"
				runat="server" DataMember="A.UrzadSkarb" Number="5" Height="28px" Width="623px" Text="Urząd do którego adresowany jest formularz"></ea:framelabel>
<ea:framelabel id="Framelabel100" style="Z-INDEX: 119; LEFT: 28px; POSITION: absolute; TOP: 294px"
				runat="server" Number="6" Height="28px" Width="623px" Text="Cel złożenia formularza <.Normal>(zaznaczyć właściwy kwadrat)<./>">
                </ea:FrameLabel>
<ea:checklabel id="Checklabel7" style="Z-INDEX: 120; LEFT: 217px; POSITION: absolute; TOP: 301px"
				runat="server" DataMember="A.Korekta" Number="1" Height="14px" Width="147px" Text="złożenie formularza"
				NumberAlignLeft="False" ComparedValue="False">
            </ea:CheckLabel>
<ea:checklabel id="Checklabel8" style="Z-INDEX: 121; LEFT: 378px; POSITION: absolute; TOP: 301px"
				runat="server" DataMember="A.Korekta" Number="2" Height="14px" Width="189px" Text="korekta formularza 1)"
				NumberAlignLeft="False"></ea:checklabel>
<ea:framelabel id="FrameLabel1" style="Z-INDEX: 122; LEFT: 0px; POSITION: absolute; TOP: 329px"
				runat="server" Height="122px" Width="651px" Text="B. DANE IDENTYFIKACYJNE PŁATNIKA&lt;br&gt;&lt;.Footer&gt;* - dotyczy płatnika niebędącego osobą fizyczną ** - dotyczy płatnika będącego osobą fizyczną&lt;./&gt;"
                FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="FrameLabel3" style="Z-INDEX: 124; LEFT: 28px; POSITION: absolute; TOP: 359px"
				runat="server" Number="7" Height="28px" Width="623px" Text="Rodzaj płatnika <.Normal>(zaznaczyć właściwy kwadrat)<./>"></ea:framelabel>
<ea:checklabel id="CheckLabel1" style="Z-INDEX: 125; LEFT: 84px; POSITION: absolute; TOP: 368px"
				runat="server" DataMember="B1.OsobaFiz" Number="1" Height="14px" Width="189px" Text="płatnik niebędący osobą fizyczną"
				NumberAlignLeft="False" ComparedValue="False">
            </ea:CheckLabel>
<ea:checklabel id="CheckLabel2" style="Z-INDEX: 126; LEFT: 364px; POSITION: absolute; TOP: 368px"
				runat="server" DataMember="B1.OsobaFiz" Number="2" Height="14px" Width="189px" Text="osoba fizyczna"
				NumberAlignLeft="False">
            </ea:CheckLabel>
<ea:framelabel id="FrameLabel4" style="Z-INDEX: 127; LEFT: 28px; POSITION: absolute; TOP: 385px"
				runat="server" DataMember="B1.Nazwa" Number="8" Height="56px" Width="623px" 
                Text="Nazwa pełna, REGON * / Nazwisko, pierwsze imię, data urodzenia **"></ea:framelabel>
<ea:framelabel id="Framelabel41" style="Z-INDEX: 139; LEFT: 0px; POSITION: absolute; TOP: 448px"
				runat="server" Text="C. DANE PODATNIKA" Width="651px" Height="27px" FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="Framelabel81" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 476px"
				runat="server" Text="C.1. DANE IDENTYFIKACYJNE" Width="651px" Height="82px" FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="flPeselNip" style="Z-INDEX: 141; LEFT: 28px; POSITION: absolute; TOP: 504px; width: 330px;"
				runat="server" 
                Text="Identyfikator podatkowy NIP/Numer PESEL &lt;.Indexup&gt;(niepotrzebne skreślić))" 
                Height="28px" Number="9"
				DataMember="IdentyfikatorPodatnika"></ea:framelabel>
<ea:framelabel id="Framelabel133" style="Z-INDEX: 144; LEFT: 357px; POSITION: absolute; TOP: 504px; width: 295px;"
				runat="server" Text="Data urodzenia" Height="28px" Number="10" DataMember="C1.DataUrodz"
				ValueStyle="Date"></ea:FrameLabel>
<ea:framelabel id="Framelabel103" 
                style="Z-INDEX: 142; LEFT: 28px; POSITION: absolute; TOP: 532px; width: 326px;" SmallerFontLength="40"
				runat="server" Text="Nazwisko" Height="28px" Number="11" DataMember="C1.Nazwisko"></ea:framelabel>
<ea:framelabel id="Framelabel104" style="Z-INDEX: 143; LEFT: 357px; POSITION: absolute; TOP: 532px; width: 291px;"
				runat="server" Text="Pierwsze imię" Height="28px" Number="12" DataMember="C1.Imię"></ea:framelabel>
<ea:framelabel id="Framelabel101" style="Z-INDEX: 145; LEFT: 0px; POSITION: absolute; TOP: 560px"
				runat="server" Text="C.2. ADRES ZAMIESZKANIA" Width="651px" Height="119px" FrameStyle="BigYellow"
				FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="Framelabel106" style="Z-INDEX: 146; LEFT: 28px; POSITION: absolute; TOP: 588px"
				runat="server" Text="Kraj" Width="140px" Height="28px" Number="13" 
                DataMember="C2.Kraj"></ea:framelabel>
<ea:framelabel id="Framelabel107" style="Z-INDEX: 147; LEFT: 168px; POSITION: absolute; TOP: 588px"
				runat="server" Text="Województwo" Width="280px" Height="28px" Number="14" 
                DataMember="C2.Wojew"></ea:framelabel>
<ea:framelabel id="Framelabel108" style="Z-INDEX: 148; LEFT: 448px; POSITION: absolute; TOP: 588px"
				runat="server" Text="Powiat" Width="203px" Height="28px" Number="15" 
                DataMember="C2.Powiat"></ea:framelabel>
<ea:framelabel id="Framelabel109" style="Z-INDEX: 149; LEFT: 28px; POSITION: absolute; TOP: 616px"
				runat="server" Text="Gmina" Width="168px" Height="28px" Number="16" 
                DataMember="C2.Gmina"></ea:framelabel>
<ea:framelabel id="Framelabel110" style="Z-INDEX: 150; LEFT: 196px; POSITION: absolute; TOP: 616px"
				runat="server" Text="Ulica" Width="301px" Height="28px" Number="17" 
                DataMember="C2.Ulica" SmallerFontLength="35"></ea:framelabel>
<ea:framelabel id="Framelabel111" style="Z-INDEX: 151; LEFT: 497px; POSITION: absolute; TOP: 616px"
				runat="server" Text="Nr domu" Width="77px" Height="28px" Number="18" 
                DataMember="C2.NrDomu"></ea:framelabel>
<ea:framelabel id="Framelabel112" style="Z-INDEX: 152; LEFT: 574px; POSITION: absolute; TOP: 616px"
				runat="server" Text="Nr lokalu" Width="77px" Height="28px" Number="19" 
                DataMember="C2.NrLokalu"></ea:framelabel>
<ea:framelabel id="Framelabel113" style="Z-INDEX: 153; LEFT: 28px; POSITION: absolute; TOP: 644px"
				runat="server" Text="Miejscowość" Width="266px" Height="28px" Number="20" 
                DataMember="C2.Miejsc" SmallerFontLength="30"></ea:framelabel>
<ea:framelabel id="Framelabel114" style="Z-INDEX: 154; LEFT: 294px; POSITION: absolute; TOP: 644px"
				runat="server" Text="Kod pocztowy" Width="105px" Height="28px" Number="21" DataMember="C2.KodPoczt"
				ValueStyle="PostalCode"></ea:framelabel>
<ea:framelabel id="Framelabel115" style="Z-INDEX: 155; LEFT: 399px; POSITION: absolute; TOP: 644px"
				runat="server" Text="Poczta" Width="252px" Height="28px" Number="22" 
                DataMember="C2.Poczta"></ea:framelabel>
<ea:framelabel id="Framelabel20" style="Z-INDEX: 156; LEFT: 0px; POSITION: absolute; TOP: 679px"
				runat="server" Width="651px" Height="54px" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom" Text="D. INFORMACJA O ZAŁĄCZNIKU"></ea:framelabel>
<ea:framelabel id="Framelabel134" style="Z-INDEX: 157; LEFT: 28px; POSITION: absolute; TOP: 700px"
				runat="server" Text="Jeżeli do niniejszego formularza dołączono informację PIT-R, należy zaznaczyć kwadrat w poz.23&lt;.Normal&gt;"
				Width="623px" Height="28px"></ea:framelabel>
<ea:checklabel id="Checklabel10" style="Z-INDEX: 159; LEFT: 378px; POSITION: absolute; TOP: 707px"
				runat="server" Text="PIT-R" Width="119px" Height="14px" Number="23" 
                DataMember="D.PIT_R"></ea:checklabel>
<ea:framelabel id="Framelabel116" style="Z-INDEX: 162; LEFT: 0px; POSITION: absolute; TOP: 735px"
				runat="server" Text="E. INFORMACJA O KOSZTACH UZYSKANIA PRZYCHODÓW" Width="651px" Height="112px"
				FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="Framelabel117" style="Z-INDEX: 163; LEFT: 28px; POSITION: absolute; TOP: 756px"
				runat="server" Text="Koszty uzyskania przychodów, wykazane w poz.26 zostały uwzględnione do wysokości przysługującej podatnikowi &lt;.Normal&gt;(zaznaczyć właściwy kwadrat)&lt;./&gt;:"
				Width="623px" Height="88px" Number="24"></ea:framelabel>
<ea:checklabel id="Checklabel3" style="Z-INDEX: 164; LEFT: 35px; POSITION: absolute; TOP: 770px"
				runat="server" Text="z jednego stosunku pracy (stosunków pokrewnych)" Width="154px" Height="14px" Number="1" DataMember="E.Jeden"
				NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:checklabel id="Checklabel4" style="Z-INDEX: 165; LEFT: 224px; POSITION: absolute; TOP: 770px"
				runat="server" Text="z więcej niż jednego stosunku pracy (stosunków pokrewnych)" Width="168px" Height="18px" Number="2"
				DataMember="E.Wiecej" NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:checklabel id="Checklabel5" style="Z-INDEX: 166; LEFT: 35px; POSITION: absolute; TOP: 791px"
				runat="server" Text="z jednego stosunku pracy (stosunków pokrewnych), podwyższone w związku z zamieszkiwaniem podatnika poza miejscowością, w której znajduje się zakład pracy"
				Width="203px" Height="14px" Number="3" DataMember="E.JedenPodw" NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:checklabel id="Checklabel6" style="Z-INDEX: 167; LEFT: 224px; POSITION: absolute; TOP: 791px"
				runat="server" Text="z więcej niż jednego stosunku pracy(stosunków pokrewnych), podwyższone w związku z zamieszkiwaniem podatnika poza miejscowością, w której znajduje się zakład pracy"
				Width="196px" Height="14px" Number="4" DataMember="E.WiecejPodw" NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:checklabel id="Checklabel12" style="Z-INDEX: 168; LEFT: 406px; POSITION: absolute; TOP: 791px"
				runat="server" Text="na podstawie wydatków faktycznie poniesionych, udokumentowanych wyłącznie imiennymi biletami okresowymi"
				Width="196px" Height="14px" Number="5" DataMember="E.Rachunki" NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:DeklaracjaFooter id="DeklaracjaFooter1" style="Z-INDEX: 160; LEFT: 532px; POSITION: absolute; TOP: 917px"
				runat="server" Width="56px" Height="15px" Symbol="PIT-40" PageNumber="1" PageTotal="3" 
                Version="20"></ea:DeklaracjaFooter>
<ea:DeklaracjaHeader id="DeklaracjaHeader2" style="Z-INDEX: 161; LEFT: 0px; POSITION: absolute; TOP: 980px"
				runat="server" StylNagłówka="JasneCiemneElektroniczniePortal2"></ea:DeklaracjaHeader>
<ea:framelabel id="Framelabel36" style="Z-INDEX: 169; LEFT: 0px; POSITION: absolute; TOP: 1001px"
				runat="server" Text="F. DOCHODY PODATNIKA I ZALICZKA POBRANA PRZEZ PŁATNIKA" Width="651px" Height="404px" FrameStyle="BigYellowBold"
				FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:FrameLabel id="FrameLabel39" style="Z-INDEX: 170; LEFT: 0px; POSITION: absolute; TOP: 1022px"
				runat="server" Text="Źródła przychodów" Width="203px" Height="28px" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Center"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel37" style="Z-INDEX: 171; LEFT: 203px; POSITION: absolute; TOP: 1022px"
				runat="server" Text="Przychód" Width="112px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center"
				ValueStyle="ZlGr"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel40" style="Z-INDEX: 172; LEFT: 315px; POSITION: absolute; TOP: 1022px"
				runat="server" Text="Koszty<br>uzyskania<br>przychodów" Width="113px" Height="28px" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Center" ValueStyle="ZlGr"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel42" style="Z-INDEX: 173; LEFT: 427px; POSITION: absolute; TOP: 1022px"
				runat="server" Text="Dochód<br>(b-c)" Width="112px" Height="28px" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Center" ValueStyle="ZlGr"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel43" style="Z-INDEX: 174; LEFT: 539px; POSITION: absolute; TOP: 1022px"
				runat="server" 
                Text="Zaliczka pobrana&lt;br&gt;przez płatnika &lt;.INDEXUP&gt;2)&lt;./&gt;" 
                Width="112px" Height="28px"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" ValueStyle="Zl"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel38" style="Z-INDEX: 175; LEFT: 0px; POSITION: absolute; TOP: 1050px"
				runat="server" Text="a" Width="203px" Height="12px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel44" style="Z-INDEX: 176; LEFT: 203px; POSITION: absolute; TOP: 1050px"
				runat="server" Text="b" Width="112px" Height="12px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel45" style="Z-INDEX: 177; LEFT: 315px; POSITION: absolute; TOP: 1050px"
				runat="server" Text="c" Width="112px" Height="12px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel46" style="Z-INDEX: 178; LEFT: 427px; POSITION: absolute; TOP: 1050px"
				runat="server" Text="d" Width="112px" Height="12px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel47" style="Z-INDEX: 179; LEFT: 539px; POSITION: absolute; TOP: 1050px"
				runat="server" Text="e" Width="113px" Height="12px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel48" style="Z-INDEX: 180; LEFT: 0px; POSITION: absolute; TOP: 1064px"
				runat="server" Text="Należności ze stosunku: pracy, służbowego, spółdzielczego i z pracy nakładczej, a także zasiłki pieniężne z ubezpieczenia społecznego wypłacane przez zakład pracy"
				Width="203px" Height="82px" Number="1" FrameStyle="SmallBoldYellow" HorizontalAlign="Left"
                FooterText="W poz.29 należy wykazać przychody, do których zastosowano 50% koszty uzyskania przychodów na podstawie art.22 ust.9 pkt 3 ustawy."></ea:FrameLabel>
<ea:framelabel id="Framelabel49" style="Z-INDEX: 181; LEFT: 203px; POSITION: absolute; TOP: 1064px"
				runat="server" Width="112px" Height="54px" Number="25" DataMember="F.1aPrzychód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel51" style="Z-INDEX: 182; LEFT: 315px; POSITION: absolute; TOP: 1064px"
				runat="server" Width="112px" Height="54px" Number="26" DataMember="F.1aKoszty" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel53" style="Z-INDEX: 183; LEFT: 427px; POSITION: absolute; TOP: 1064px"
				runat="server" Width="112px" Height="83px" Number="27" DataMember="F.1Dochód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel54" style="Z-INDEX: 184; LEFT: 539px; POSITION: absolute; TOP: 1064px"
				runat="server" Width="113px" Height="83px" Number="28" DataMember="F.1Zaliczka" 
                ValueStyle="Zl"></ea:framelabel>
<ea:framelabel id="Framelabel50" style="Z-INDEX: 185; LEFT: 203px; POSITION: absolute; TOP: 1120px"
				runat="server" Width="112px" Height="28px" Number="29" DataMember="F.1bPrzychód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel52" style="Z-INDEX: 186; LEFT: 315px; POSITION: absolute; TOP: 1120px"
				runat="server" Width="112px" Height="28px" Number="30" DataMember="F.1bKoszty" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:FrameLabel id="FrameLabel55" style="Z-INDEX: 187; LEFT: 0px; POSITION: absolute; TOP: 1148px"
				runat="server" Text="Należności z tytułu członkostwa w rolniczej spółdzielni produkcyjnej lub innej spółdzielni zajmującej się produkcją rolną oraz zasiłki z ubezpieczenia społecznego, o których mowa w art.33 ustawy"
				Width="203px" Height="55px" Number="2" FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:FrameLabel>
<ea:framelabel id="Framelabel57" style="Z-INDEX: 188; LEFT: 203px; POSITION: absolute; TOP: 1148px"
				runat="server" Width="112px" Height="54px" Number="31" DataMember="F.2Przychód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel58" style="Z-INDEX: 189; LEFT: 315px; POSITION: absolute; TOP: 1148px"
				runat="server" Width="112px" Height="54px" FrameStyle="SmallBoldYellow"></ea:framelabel>
<ea:framelabel id="Framelabel59" style="Z-INDEX: 190; LEFT: 427px; POSITION: absolute; TOP: 1148px"
				runat="server" Width="112px" Height="54px" Number="32" DataMember="F.2Dochód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel60" style="Z-INDEX: 191; LEFT: 539px; POSITION: absolute; TOP: 1148px"
				runat="server" Width="113px" Height="54px" Number="33" DataMember="F.2Zaliczka" 
                ValueStyle="Zl"></ea:framelabel>
<ea:FrameLabel id="FrameLabel61" style="Z-INDEX: 192; LEFT: 0px; POSITION: absolute; TOP: 1204px"
				runat="server" Text="Emerytury - renty zagraniczne" Width="203px" Height="26px" Number="3"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:FrameLabel>
<ea:framelabel id="Framelabel62" style="Z-INDEX: 193; LEFT: 203px; POSITION: absolute; TOP: 1204px"
				runat="server" Width="112px" Height="28px" Number="34" DataMember="F.3Przychód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel63" style="Z-INDEX: 194; LEFT: 315px; POSITION: absolute; TOP: 1204px"
				runat="server" Width="112px" Height="28px" FrameStyle="SmallBoldYellow"></ea:framelabel>
<ea:framelabel id="Framelabel64" style="Z-INDEX: 195; LEFT: 427px; POSITION: absolute; TOP: 1204px"
				runat="server" Width="112px" Height="28px" Number="35" DataMember="F.3Dochód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel65" style="Z-INDEX: 196; LEFT: 539px; POSITION: absolute; TOP: 1204px"
				runat="server" Width="113px" Height="28px" Number="36" DataMember="F.3Zaliczka" 
                ValueStyle="Zl"></ea:framelabel>
<ea:FrameLabel id="FrameLabel67" style="Z-INDEX: 197; LEFT: 0px; POSITION: absolute; TOP: 1232px"
				runat="server" Text="Należności za pracę przypadające tymczasowo aresztowanym lub skazanym"
				Width="203px" Height="26px" Number="4" FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:FrameLabel>
<ea:framelabel id="Framelabel73" style="Z-INDEX: 198; LEFT: 203px; POSITION: absolute; TOP: 1232px"
				runat="server" Width="112px" Height="28px" Number="37" DataMember="F.4Przychód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel79" style="Z-INDEX: 199; LEFT: 315px; POSITION: absolute; TOP: 1232px"
				runat="server" Width="112px" Height="28px" FrameStyle="SmallBoldYellow"></ea:framelabel>
<ea:framelabel id="Framelabel86" style="Z-INDEX: 200; LEFT: 427px; POSITION: absolute; TOP: 1232px"
				runat="server" Width="112px" Height="28px" Number="38" DataMember="F.4Dochód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel92" style="Z-INDEX: 201; LEFT: 539px; POSITION: absolute; TOP: 1232px"
				runat="server" Width="113px" Height="28px" Number="39" DataMember="F.4Zaliczka" 
                ValueStyle="Zl"></ea:framelabel>
<ea:FrameLabel id="FrameLabel68" style="Z-INDEX: 202; LEFT: 0px; POSITION: absolute; TOP: 1260px"
				runat="server" Text="Działalność wykonywana osobiście, o której mowa w art.13 ustawy (w tym umowy o dzieło i zlecenia)"
				Width="203px" Height="26px" Number="5" FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:FrameLabel>
<ea:framelabel id="Framelabel74" style="Z-INDEX: 203; LEFT: 203px; POSITION: absolute; TOP: 1260px"
				runat="server" Width="112px" Height="28px" Number="40" DataMember="F.5Przychód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel80" style="Z-INDEX: 204; LEFT: 315px; POSITION: absolute; TOP: 1260px"
				runat="server" Width="112px" Height="28px" Number="41" DataMember="F.5Koszty" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel87" style="Z-INDEX: 205; LEFT: 427px; POSITION: absolute; TOP: 1260px; right: 284px;"
				runat="server" Width="112px" Height="28px" Number="42" DataMember="F.5Dochód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel93" style="Z-INDEX: 206; LEFT: 539px; POSITION: absolute; TOP: 1260px"
				runat="server" Width="113px" Height="28px" Number="43" DataMember="F.5Zaliczka" 
                ValueStyle="Zl"></ea:framelabel>
<ea:FrameLabel id="FrameLabel69" style="Z-INDEX: 207; LEFT: 0px; POSITION: absolute; TOP: 1288px"
				runat="server" Text="Prawa autorskie i inne prawa, o których mowa w art.18 ustawy" Width="203px"
				Height="56px" Number="6" FrameStyle="SmallBoldYellow" HorizontalAlign="Left"
                FooterText="W poz.47 należy wykazać przychody, do których zastosowano 50% koszty uzyskania przychodów na podstawie art. 22 ust. 9 pkt 1-3 ustawy."></ea:FrameLabel>
<ea:framelabel id="Framelabel75" style="Z-INDEX: 208; LEFT: 203px; POSITION: absolute; TOP: 1288px"
				runat="server" Width="112px" Height="28px" Number="44" DataMember="F.6Przychód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel88" style="Z-INDEX: 210; LEFT: 427px; POSITION: absolute; TOP: 1288px"
				runat="server" Width="112px" Height="56px" Number="45" DataMember="F.6Dochód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel94" style="Z-INDEX: 211; LEFT: 539px; POSITION: absolute; TOP: 1288px"
				runat="server" Width="113px" Height="56px" Number="46" DataMember="F.6Zaliczka" 
                ValueStyle="Zl"></ea:framelabel>
<ea:framelabel id="Framelabel2" style="Z-INDEX: 211; LEFT: 203px; POSITION: absolute; TOP: 1316px; right: 396px;"
				runat="server" Width="112px" Height="28px" Number="47" DataMember="F.6bPrzychód"
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel82" style="Z-INDEX: 211; LEFT: 315px; POSITION: absolute; TOP: 1316px; right: 396px;"
				runat="server" Width="112px" Height="28px" Number="48" DataMember="F.6Koszty" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:FrameLabel id="FrameLabel70" style="Z-INDEX: 212; LEFT: 0px; POSITION: absolute; TOP: 1344px"
				runat="server" Text="Inne źródła, niewymienione w wierszach<br>od 1 do 6" Width="203px" Height="26px"
				Number="7" FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:FrameLabel>
<ea:framelabel id="Framelabel76" style="Z-INDEX: 213; LEFT: 203px; POSITION: absolute; TOP: 1344px"
				runat="server" Width="112px" Height="28px" Number="49" DataMember="F.7Przychód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel83" style="Z-INDEX: 214; LEFT: 315px; POSITION: absolute; TOP: 1344px"
				runat="server" Width="112px" Height="28px" ValueStyle="ZlGr" DataMember="F.7Koszty" 
                Number="50"></ea:framelabel>
<ea:framelabel id="Framelabel89" style="Z-INDEX: 215; LEFT: 427px; POSITION: absolute; TOP: 1344px"
				runat="server" Width="112px" Height="28px" Number="51" DataMember="F.7Dochód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel95" style="Z-INDEX: 216; LEFT: 539px; POSITION: absolute; TOP: 1344px"
				runat="server" Width="113px" Height="28px" Number="52" DataMember="F.7Zaliczka" 
                ValueStyle="Zl"></ea:framelabel>
<ea:FrameLabel id="FrameLabel71" style="Z-INDEX: 217; LEFT: 0px; POSITION: absolute; TOP: 1372px"
				runat="server" Text="RAZEM" Width="203px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left"
				FooterText="Suma kwot z wierszy od 1 do 7." Number="8"></ea:FrameLabel>
<ea:framelabel id="Framelabel77" style="Z-INDEX: 218; LEFT: 203px; POSITION: absolute; TOP: 1372px"
				runat="server" Width="112px" Height="28px" Number="53" DataMember="F.Przychód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel84" style="Z-INDEX: 219; LEFT: 315px; POSITION: absolute; TOP: 1372px"
				runat="server" Width="112px" Height="28px" Number="54" DataMember="F.Koszty" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel90" style="Z-INDEX: 220; LEFT: 427px; POSITION: absolute; TOP: 1372px; right: 284px;"
				runat="server" Width="112px" Height="28px" Number="55" DataMember="F.Dochód" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel96" style="Z-INDEX: 221; LEFT: 539px; POSITION: absolute; TOP: 1372px"
				runat="server" Width="113px" Height="28px" Number="56" DataMember="F.Zaliczka" 
                ValueStyle="Zl"></ea:framelabel>
<ea:framelabel id="Framelabel16" style="Z-INDEX: 222; LEFT: 0px; POSITION: absolute; TOP: 1407px; height: 176px;"
				runat="server" Text="G. ODLICZENIA OD DOCHODU - ZGODNIE Z ART.37 UST.1a USTAWY&lt;.Footer&gt;&lt;br&gt;Suma kwot z poz.57, 59 i 61 nie może przekroczyć kwoty z poz.55.&lt;./&gt;"
				Width="651px" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="Framelabel169" style="Z-INDEX: 222; LEFT: 580px; POSITION: absolute; TOP: 1418px"
				runat="server"
				Width="70px" Height="14px" FrameStyle="BigYellowBold" FrameBorderStyle="None" 
                ValueStyle="ZlGr"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel166" style="Z-INDEX: 224; LEFT: 28px; POSITION: absolute; TOP: 1435px"
				runat="server" Text="Składki na ubezpieczenia społeczne"
				Width="499px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:FrameLabel>
<ea:framelabel id="Framelabel141" style="Z-INDEX: 225; LEFT: 525px; POSITION: absolute; TOP: 1435px"
				runat="server" Width="126px" Height="28px" Number="57" DataMember="G.ZUS" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:FrameLabel id="FrameLabel140" style="Z-INDEX: 224; LEFT: 36px; POSITION: absolute; TOP: 1463px; width: 489px;"
				runat="server" Text="w tym zagraniczne, o których mowa w art. 26 ust.1 pkt 2a ustawy"
				Width="490px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:FrameLabel>
<ea:framelabel id="Framelabel167" style="Z-INDEX: 225; LEFT: 525px; POSITION: absolute; TOP: 1463px; bottom: 489px;"
				runat="server" Width="126px" Height="28px" Number="58" DataMember="G.ZUSZagr" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:FrameLabel id="FrameLabel142" style="Z-INDEX: 226; LEFT: 28px; POSITION: absolute; TOP: 1491px"
				runat="server" Text="Zwrot nienależnie pobranych świadczeń"
				Width="499px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:FrameLabel>
<ea:framelabel id="Framelabel143" style="Z-INDEX: 227; LEFT: 525px; POSITION: absolute; TOP: 1491px"
				runat="server" Width="126px" Height="28px" Number="59" DataMember="G.ZwrotŚwiadczeń" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel118" style="Z-INDEX: 273; LEFT: 28px; POSITION: absolute; TOP: 1519px"
				runat="server" Text="Inne odliczenia od dochodu, niewymienione w poz.57 i 59&lt;.INDEXUP&gt;3)&lt;./&gt;"
				Width="140px" Height="56px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left">
                </ea:FrameLabel>
<ea:framelabel id="Framelabel119" style="Z-INDEX: 229; LEFT: 168px; POSITION: absolute; TOP: 1519px"
				runat="server" Text="Podać rodzaj:" Width="357px" Height="56px" Number="60" 
                DataMember="G.InneOpis">
                </ea:FrameLabel>
<ea:framelabel id="Framelabel120" style="Z-INDEX: 230; LEFT: 525px; POSITION: absolute; TOP: 1519px"
				runat="server" Width="126px" Height="56px" Number="61" DataMember="G.InneKwota" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel56" style="Z-INDEX: 231; LEFT: 0px; POSITION: absolute; TOP: 1582px"
				runat="server" Text="H. OBLICZENIE NALEŻNEGO PODATKU" Width="651px" Height="28px" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="Framelabel144" style="Z-INDEX: 232; LEFT: 0px; POSITION: absolute; TOP: 1610px"
				runat="server" Text="H.1. OBLICZENIE PODATKU" Width="651px" Height="138px" 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel171" style="Z-INDEX: 233; LEFT: 580px; POSITION: absolute; TOP: 1620px"
				runat="server"
				Width="70px" Height="14px" FrameStyle="BigYellowBold" FrameBorderStyle="None" 
                ValueStyle="ZlGr">
                </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel145" style="Z-INDEX: 233; LEFT: 28px; POSITION: absolute; TOP: 1638px"
				runat="server" Text="Podstawa obliczenia podatku &lt;.Normal&gt;(po zaokrągleniu do pełnych złotych)&lt;./&gt;"
				Width="499px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left" 
                FooterText="Od kwoty z poz.55 należy odjąć sumę kwot z poz.57, 59 i 61."></ea:FrameLabel>
<ea:framelabel id="Framelabel146" style="Z-INDEX: 234; LEFT: 525px; POSITION: absolute; TOP: 1638px; bottom: 182px;"
				runat="server" Width="126px" Height="28px" Number="62" DataMember="H1.Podstawa" 
                ValueStyle="ForceZl"></ea:framelabel>
<ea:FrameLabel id="FrameLabel147" style="Z-INDEX: 235; LEFT: 28px; POSITION: absolute; TOP: 1666px"
				runat="server" Text="Obliczony podatek - zgodnie z art.27 ustawy" Width="499px" Height="26px"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Left" 
                FooterText="Podatek od podstawy z poz.62. Jeżeli wynik jest liczbą ujemną, należy wpisać 0."></ea:FrameLabel>
<ea:framelabel id="Framelabel148" style="Z-INDEX: 236; LEFT: 525px; POSITION: absolute; TOP: 1666px"
				runat="server" Width="126px" Height="28px" Number="63" DataMember="H1.Obliczony" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:FrameLabel id="FrameLabel149" style="Z-INDEX: 237; LEFT: 28px; POSITION: absolute; TOP: 1694px"
				runat="server" Text="Doliczenie do podatku" Width="499px" Height="26px" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Left"></ea:FrameLabel>
<ea:framelabel id="Framelabel150" style="Z-INDEX: 238; LEFT: 525px; POSITION: absolute; TOP: 1694px"
				runat="server" Width="126px" Height="28px" Number="64" DataMember="H1.Doliczenie" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:FrameLabel id="FrameLabel66" style="Z-INDEX: 239; LEFT: 28px; POSITION: absolute; TOP: 1722px"
				runat="server" Text="Podatek" Width="499px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left"
				FooterText="Do kwoty z poz.63 należy dodać kwotę z poz.64."></ea:FrameLabel>
<ea:framelabel id="Framelabel72" style="Z-INDEX: 240; LEFT: 525px; POSITION: absolute; TOP: 1722px"
				runat="server" ValueStyle="ZlGr" Width="126px" Height="28px" DataMember="H1.Podatek" 
                Number="65"></ea:framelabel>
<ea:DeklaracjaFooter id="DeklaracjaFooter3" style="Z-INDEX: 241; LEFT: 0px; POSITION: absolute; TOP: 1904px"
				runat="server" Width="56px" Height="15px" Version="20" PageTotal="3" PageNumber="2" 
                Symbol="PIT-40"></ea:DeklaracjaFooter>
<ea:framelabel id="flDanePodatnika1" style="Z-INDEX: 242; LEFT: 170px; POSITION: absolute; TOP: 1904px; height: 21px; width: 479px; right: 275px;"
				runat="server" Text="?" FrameStyle="Middle" FrameBorderStyle="None" 
                HorizontalAlign="Right" VerticalAlign="Bottom"></ea:framelabel>
<ea:DeklaracjaHeader id="DeklaracjaHeader3" style="Z-INDEX: 242; LEFT: 0px; POSITION: absolute; TOP: 1953px"
				runat="server" StylNagłówka="JasneCiemneElektroniczniePortal2"></ea:DeklaracjaHeader>
<ea:framelabel id="Framelabel151" style="Z-INDEX: 243; LEFT: 0px; POSITION: absolute; TOP: 1974px"
				runat="server" 
                Text="H.2. ODLICZENIA OD PODATKU - ZGODNIE Z ART.37 UST.1a USTAWY|&lt;.Footer&gt;Suma kwot z poz.68 i 70 nie może przekroczyć kwoty podatku z poz.65.&lt;./&gt;" 
                Width="651px" Height="165px" FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel102" style="Z-INDEX: 244; LEFT: 580px; POSITION: absolute; TOP: 1985px"
				runat="server"
				Width="70px" Height="14px" FrameStyle="BigYellowBold" FrameBorderStyle="None" 
                ValueStyle="ZlGr">
                </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel152" style="Z-INDEX: 244; LEFT: 28px; POSITION: absolute; TOP: 2002px"
				runat="server" Text="Składka na ubezpieczenie zdrowotne"
				Width="498px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:FrameLabel>
<ea:framelabel id="Framelabel153" style="Z-INDEX: 245; LEFT: 525px; POSITION: absolute; TOP: 2002px"
				runat="server" Width="126px" Height="28px" Number="66" DataMember="H2.Zdrowotne" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:FrameLabel id="FrameLabel156" style="Z-INDEX: 246; LEFT: 35px; POSITION: absolute; TOP: 2030px"
				runat="server" Text="w tym zagraniczne, o których mowa w art.27b ust.1 pkt 2 ustawy"
				Width="490px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left" FooterText=""></ea:FrameLabel>
<ea:framelabel id="Framelabel157" style="Z-INDEX: 247; LEFT: 525px; POSITION: absolute; TOP: 2030px"
				runat="server" Width="126px" Height="28px" Number="67" DataMember="H2.ZdrowotneZagr" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:FrameLabel id="FrameLabel136" style="Z-INDEX: 244; LEFT: 28px; POSITION: absolute; TOP: 2058px"
				runat="server" Text="Kwota składek z poz.66, możliwa do odliczenia w roku podatkowym"
				Width="498px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left" 
                FooterText="Kwota z poz.66. nie więcej jednak niż kwota podatku z poz.65.&lt;br/&gt;">
                </ea:FrameLabel>
<ea:framelabel id="Framelabel135" style="Z-INDEX: 247; LEFT: 525px; POSITION: absolute; TOP: 2058px"
				runat="server" Width="126px" Height="28px" Number="68" DataMember="H2.DoOdliczenia" 
                ValueStyle="ZlGr">
                </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel121" style="Z-INDEX: 248; LEFT: 28px; POSITION: absolute; TOP: 2086px"
				runat="server" Text="Inne odliczenia od podatku, niewymienione w poz.66  &lt;.INDEXUP&gt;3)&lt;./&gt;"
				Width="140px" Height="56px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel124" style="Z-INDEX: 249; LEFT: 168px; POSITION: absolute; TOP: 2086px"
				runat="server" Text="Podać rodzaj:" Width="357px" Height="56px" Number="69" 
                DataMember="H2.InneOpis">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel130" style="Z-INDEX: 250; LEFT: 525px; POSITION: absolute; TOP: 2086px"
				runat="server" Width="126px" Height="56px" Number="70" DataMember="H2.InneKwota" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel78" style="Z-INDEX: 251; LEFT: 0px; POSITION: absolute; TOP: 2142px"
				runat="server" Text="H.3. PODATEK NALEŻNY" Width="651px" Height="119px" FrameStyle="BigYellow" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="Framelabel170" style="Z-INDEX: 252; LEFT: 580px; POSITION: absolute; TOP: 2154px"
				runat="server"
				Width="70px" Height="14px" FrameStyle="BigYellowBold" FrameBorderStyle="None" 
                ValueStyle="Zl">
                </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel91" style="Z-INDEX: 252; LEFT: 28px; POSITION: absolute; TOP: 2170px"
				runat="server" Text="Podatek należny <.Normal>(po zaokrągleniu do pełnych złotych)<./>"
				Width="497px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left" 
                FooterText="Od kwoty z poz. 65 należy odjąć sumę kwot z poz.68 i 70."></ea:FrameLabel>
<ea:framelabel id="Framelabel85" style="Z-INDEX: 253; LEFT: 525px; POSITION: absolute; TOP: 2170px"
				runat="server" ValueStyle="Zl" Width="126px" Height="28px" DataMember="H3.Należny" 
                Number="71"></ea:framelabel>
<ea:FrameLabel id="FrameLabel162" style="Z-INDEX: 254; LEFT: 28px; POSITION: absolute; TOP: 2198px"
				runat="server" Text="Różnica pomiędzy podatkiem należnym a sumą zaliczek pobranych przez płatnika - DO ZAPŁATY &lt;.INDEXUP&gt;4)&lt;./&gt;"
				Width="497px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left" 
                FooterText="Od kwoty z poz.71 należy odjąć kwotę z poz.56. Jeżeli różnica jest liczbą ujemną, należy wpisać 0."></ea:FrameLabel>
<ea:framelabel id="Framelabel163" style="Z-INDEX: 255; LEFT: 525px; POSITION: absolute; TOP: 2198px"
				runat="server" Width="126px" Height="28px" Number="72" DataMember="H3.DoZapłaty" 
                ValueStyle="Zl"></ea:framelabel>
<ea:FrameLabel id="FrameLabel164" style="Z-INDEX: 256; LEFT: 28px; POSITION: absolute; TOP: 2226px"
				runat="server" Text="Różnica pomiędzy sumą zaliczek pobranych przez płatnika a podatkiem należnym - NADPŁATA &lt;.INDEXUP&gt;5)&lt;./&gt;"
				Width="497px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left" 
                FooterText="Od kwoty z poz.56 należy odjąć kwotę z poz.71. Jeżeli różnica jest liczbą ujemną, należy wpisać 0."></ea:FrameLabel>
<ea:framelabel id="Framelabel165" style="Z-INDEX: 257; LEFT: 525px; POSITION: absolute; TOP: 2226px"
				runat="server" Width="126px" Height="28px" Number="73" DataMember="H3.Nadpłata" 
                ValueStyle="Zl"></ea:framelabel>
            &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;
<ea:FrameLabel id="FrameLabel122" style="Z-INDEX: 258; LEFT: 0px; POSITION: absolute; TOP: 2261px"
				runat="server" Text="I. PODPIS PŁATNIKA LUB OSOBY WYZNACZONEJ DO OBLICZENIA I POBRANIA PODATKU / PEŁNOMOCNIKA PŁATNIKA"
				Width="651px" Height="99px" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel123" style="Z-INDEX: 259; LEFT: 28px; POSITION: absolute; TOP: 2296px"
				runat="server" Text="Imię" Width="210px" Height="56px" Number="74" DataMember="I.Imię"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel125" style="Z-INDEX: 260; LEFT: 238px; POSITION: absolute; TOP: 2296px"
				runat="server" Text="Nazwisko" Width="210px" Height="56px" Number="75" 
                DataMember="I.Nazwisko"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel126" style="Z-INDEX: 261; LEFT: 448px; POSITION: absolute; TOP: 2296px"
				runat="server" Text="Podpis"
				Width="203px" Height="56px" Number="76"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel127" style="Z-INDEX: 262; LEFT: 0px; POSITION: absolute; TOP: 2360px"
				runat="server" Text="J. ADNOTACJE URZĘDU" Width="651px" Height="84px" FrameStyle="BigYellowBold"></ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel128" style="Z-INDEX: 263; LEFT: 28px; POSITION: absolute; TOP: 2388px"
				runat="server" Text="Identyfikator przyjmującego formularz" Width="308px" 
                Height="56px" Number="77"
				FrameStyle="SmallBoldGray"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel129" style="Z-INDEX: 264; LEFT: 336px; POSITION: absolute; TOP: 2388px"
				runat="server" Text="Podpis przyjmującego formularz" Width="315px" Height="56px" Number="78"
				FrameStyle="SmallBoldGray"></ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel131" style="Z-INDEX: 266; LEFT: 10px; POSITION: absolute; TOP: 2479px; width: 638px;"
				runat="server" 
                Text="&lt;.INDEXUP&gt;1)&lt;./&gt; Zgodnie z art.81 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz.U. z 2012 r. poz. 749, z późn. zm.) płatnik może skorygować złożoną deklarację poprzez złożenie deklaracji korygującej wraz z dołączonym pisemnym uzasadnieniem przyczyn korekty." 
                Height="21px" FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel97" style="Z-INDEX: 268; LEFT: 10px; POSITION: absolute; TOP: 2512px; height: 30px; width: 636px;"
				runat="server" 
                Text="&lt;.INDEXUP&gt;2)&lt;./&gt; W sytuacji gdy podatnik mimo złożonego oświadczenia PIT-12 złoży w urzędzie skarbowym zeznanie podatkowe PIT-37 albo PIT-36, do zeznania tego przenosi kwotę zaliczki odpowiednio pomniejszoną o kwotę z poz.73, jeżeli z rocznego obliczenia podatku PIT-40 wynika nadpłata, albo powiększoną o kwotę z poz.72, jeżeli z rocznego obliczenia podatku PIT-40 wynika kwota do zapłaty." 
                FrameStyle="Small" FrameBorderStyle="None">
    </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel98" style="Z-INDEX: 269; LEFT: 10px; POSITION: absolute; TOP: 2557px; width: 634px;"
				runat="server" 
                Text="&lt;.INDEXUP&gt;3)&lt;./&gt; Poz.60 i 61 należy wypełnić w sytuacji, gdy obowiązujące przepisy przewidują pomniejszenie przez płatnika dochodu do opodatkowania o kwoty inne niż wymienione w poz.57 i 59, odpowiednio poz.69 i 70 - jeżeli obowiązujące przepisy przewidują pomniejszenie przez płatnika podatku o kwotę inną niż wymieniona w poz.66." 
                Height="35px" FrameStyle="Small" FrameBorderStyle="None">
    </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel99" style="Z-INDEX: 270; LEFT: 10px; POSITION: absolute; TOP: 2596px; width: 634px; height: 29px;"
				runat="server" 
                Text="&lt;.INDEXUP&gt;4)&lt;./&gt; Różnicę pomiędzy podatkiem należnym a sumą zaliczek pobranych przez płatnika pobiera się z dochodu za marzec roku następującego po roku podatkowym. Różnicę tę, na wniosek podatnika, pobiera się z dochodu za kwiecień roku następującego po roku podatkowym. W razie gdy stosunek uzasadniający pobór zaliczek ustał w styczniu lub w lutym roku następującego po roku podatkowym, różnicę pobiera się z dochodu za miesiąc, za który pobrana została ostatnia zaliczka." 
                FrameStyle="Small" FrameBorderStyle="None">
    </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel168" style="Z-INDEX: 270; LEFT: 10px; POSITION: absolute; TOP: 2647px; width: 636px;"
				runat="server" 
                Text="&lt;.INDEXUP&gt;5)&lt;./&gt; Różnicę pomiędzy sumą zaliczek pobranych przez płatnika a podatkiem należnym zalicza się na poczet zaliczki należnej za marzec roku następującego po roku podatkowym, a jeżeli po pobraniu tej zaliczki pozostaje nadpłata, zwraca się ją podatnikowi w gotówce." 
                Height="21px" FrameStyle="Small" FrameBorderStyle="None">
    </ea:FrameLabel>
<ea:framelabel id="FrameLabel6" style="Z-INDEX: 271; LEFT: 300px; POSITION: absolute; TOP: 2685px"
				runat="server" Width="327px" Height="6px" Text="&lt;b&gt;Pouczenie&lt;/b&gt;"
				FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel7" style="Z-INDEX: 271; LEFT: 3px; POSITION: absolute; TOP: 2696px"
				runat="server" Width="627px" Height="6px" Text="Za uchybienie obowiązkom płatnika grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym."
				FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="flDanePodatnika2" style="Z-INDEX: 272; LEFT: 0px; POSITION: absolute; TOP: 2829px; height: 21px; width: 427px; right: 275px;"
				runat="server" Text="?" FrameStyle="Middle" FrameBorderStyle="None" 
                HorizontalAlign="Left" VerticalAlign="Bottom"></ea:framelabel>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT40,Soneta.Deklaracje"
				style="Z-INDEX: 272; LEFT: 189px; POSITION: absolute; TOP: 2849px" LeftMargin="15"
				PageHeight="977px" PageZoom="106.74%" oncontextload="dc_ContextLoad"></ea:datacontext>
<ea:DeklaracjaFooter id="DeklaracjaFooter2" style="Z-INDEX: 271; LEFT: 532px; POSITION: absolute; TOP: 2849px"
				runat="server" Symbol="PIT-40" PageNumber="3" PageTotal="3" Version="20"></ea:DeklaracjaFooter>
</form>
	</body>
</HTML>
