﻿<%@ Page language="c#" AutoEventWireup="false" codePage="65001" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.Xml" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>PIT-R (17)</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
	void OnContextLoad(object sender, EventArgs e) {
        PITR_17 pit = dc[typeof(PITR)] as PITR_17;
        if (pit==null)
            throw new InvalidOperationException("Wydruk PIT-R (17) może być drukowany wyłącznie dla deklaracji PIT-R w wersji 17.");
        if (((PITR_17)pit).JestPESEL) {
            flPeselNip.Text = "<strike>Identyfikator podatkowy NIP</strike>/Numer PESEL <.Indexup>(niepotrzebne skreślić))";
            flPeselNip.ValueStyle = ValueStyles.WideText;
        }
        else {
            flPeselNip.Text = "Identyfikator podatkowy NIP/<strike>Numer PESEL</strike> <.Indexup>(niepotrzebne skreślić))";
            flPeselNip.ValueStyle = ValueStyles.nip_w;
        }
        if (!dc.OverPrint) {
            string upo = (pit.Deklaracja ?? pit).GetNumerUpo();
            if (upo != "") {
                Resize(FrameNIPPlatnika, -64, 0);
                Move(FrameNrDokumentu, 0, -64);
                Resize(FrameNrDokumentu, 64, 0);
                FrameNrDokumentu.EditValue = upo;
            }
        }
	}

    void Resize(WebControl fl, int dwidth, int dheight) {
        if (dwidth != 0)
            fl.Style["width"] = (ParsePx(fl.Style["width"]) + dwidth) + "px";
        if (dheight != 0)
            fl.Style["height"] = (ParsePx(fl.Style["height"]) + dheight) + "px";
    }
                        
    void Move(WebControl fl, int dtop, int dleft) {
        if (dtop != 0)
            fl.Style["TOP"] = (ParsePx(fl.Style["TOP"]) + dtop) + "px";
        if (dleft != 0)
            fl.Style["LEFT"] = (ParsePx(fl.Style["LEFT"]) + dleft) + "px";
    }
            
    int ParsePx(string px) {
        return int.Parse(px.Substring(0, px.Length - 2));
    }
		</script>
	</HEAD>
	<body leftMargin="0" rightMargin="0">
		<form id="PIT_R_17" method="post" runat="server">
			<ea:DeklaracjaHeader id="DeklaracjaHeader1" style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 0px"
				runat="server" Width="630px" StylNagłówka="JasneCiemneElektroniczniePortal"></ea:DeklaracjaHeader>
<ea:framelabel id="FrameNIPPlatnika" style="Z-INDEX: 101; LEFT: 0px; POSITION: absolute; TOP: 21px; width: 338px;"
				runat="server" ValueStyle="nip_w" DataMember="0.Nip" Height="28px" 
                Text="1. Identyfikator podatkowy NIP płatnika"></ea:framelabel>
<ea:framelabel id="FrameNrDokumentu" style="Z-INDEX: 102; LEFT: 337px; POSITION: absolute; TOP: 21px; width: 193px;"
				runat="server" Height="28px" Text="Nr dokumentu" FrameStyle="SmallBoldGray" Number="2"></ea:framelabel>
<ea:framelabel id="FrameLabel20" style="Z-INDEX: 103; LEFT: 531px; POSITION: absolute; TOP: 21px; width: 97px;"
				runat="server" Height="30px" Text="Status" FrameStyle="SmallBoldGray" Number="3"></ea:framelabel>
<ea:framelabel id="FrameLabel35" style="Z-INDEX: 104; LEFT: 7px; POSITION: absolute; TOP: 49px"
				runat="server" Height="14px" Width="63px" Text="PIT-R" FrameBorderStyle="None" FrameStyle="BigBold"></ea:framelabel>
<ea:framelabel id="FrameLabel34" style="Z-INDEX: 105; LEFT: 7px; POSITION: absolute; TOP: 65px"
				runat="server" Height="35px" Width="532px" Text="INFORMACJA O WYPŁACONYCH PODATNIKOWI KWOTACH Z TYTUŁU<br>PEŁNIENIA OBOWIĄZKÓW SPOŁECZNYCH I OBYWATELSKICH"
				FrameBorderStyle="None" FrameStyle="BigBold" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel19" style="Z-INDEX: 106; LEFT: 231px; POSITION: absolute; TOP: 105px; width: 112px;"
				runat="server" DataMember="0.Rok" Height="28px" Text="Rok" ValueStyle="n4" Number="4"></ea:framelabel>
<ea:framelabel id="FrameLabel29" style="Z-INDEX: 107; LEFT: 147px; POSITION: absolute; TOP: 112px; right: 908px;"
				runat="server" Height="17px" Width="70px" Text="w roku" FrameBorderStyle="None" 
                FrameStyle="BigBold"></ea:framelabel>
<ea:framelabel id="FrameLabel24" style="Z-INDEX: 108; LEFT: 0px; POSITION: absolute; TOP: 138px"
				runat="server" Height="100px" Width="630px" FrameStyle="SmallBoldYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel10" style="Z-INDEX: 112; LEFT: 7px; POSITION: absolute; TOP: 142px"
				runat="server" Width="91px" Height="7px" Text="Składający:" FrameStyle="SmallYellow" 
                FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel14" style="Z-INDEX: 113; LEFT: 133px; POSITION: absolute; TOP: 140px; height: 42px;"
				runat="server" Width="490px" 
                Text="Płatnik podatku dochodowego od osób fizycznych, o którym mowa w art. 41 ust. 1 ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych (Dz. U. z 2012 r. poz.361, z późn. zm.), zwanej dalej 'ustawą', dokonujący osobom fizycznym wypłat należności z tytułu pełnienia obowiązków społecznych i obywatelskich (art. 13 pkt 5 i 6 ustawy), wolnych od podatku na podstawie art. 21 ust. 1 pkt 16 lit.b i pkt 17 ustawy" FrameStyle="SmallYellow" 
                FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel11" style="Z-INDEX: 114; LEFT: 7px; POSITION: absolute; TOP: 180px"
				runat="server" Width="91px" Height="7px" Text="Termin składania:" 
                FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel12" style="Z-INDEX: 115; LEFT: 133px; POSITION: absolute; TOP: 178px; height: 42px;"
				runat="server" Width="490px" Text="Do końca lutego roku następującego po roku podatkowym - wyłącznie dla informacji składanych urzędowi skarbowemu za pomocą środków komunikacji elektronicznej lub podatnikowi; do końca stycznia roku następującego po roku podatkowym w przypadku informacji składanych urzędowi skarbowemu w formie pisemnej, zgodnie z art. 45ba ust. 2 ustawy. W przypadku zaprzestania działalności przez płatnika przed końcem lutego roku następującego po roku podatkowym - do dnia zaprzestania tej działalności."
				FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel13" style="Z-INDEX: 116; LEFT: 7px; POSITION: absolute; TOP: 218px"
				runat="server" Width="91px" Height="7px" Text="Otrzymuje:" FrameStyle="SmallYellow" 
                FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel33" style="Z-INDEX: 117; LEFT: 133px; POSITION: absolute; TOP: 216px; height: 22px;"
				runat="server" Width="490px" Text="Podatnik i urząd skarbowy &lt;.INDEXUP&gt;1)&lt;./&gt; według miejsca zamieszkania podatnika, a w przypadku podatnika, o którym mowa w art.3 ust.2a ustawy, urząd skarbowy w sprawach opodatkowania osób zagranicznych."
				FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel17" style="Z-INDEX: 118; LEFT: 0px; POSITION: absolute; TOP: 236px"
				runat="server" Height="84px" Width="630px" Text="A. MIEJSCE I CEL SKŁADANIA INFORMACJI" FrameBorderStyle="DoubleHeader"
				FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel18" style="Z-INDEX: 119; LEFT: 28px; POSITION: absolute; TOP: 264px"
				runat="server" DataMember="A.UrzadSkarb" Number="5" Height="28px" Width="602px" 
                Text="Urząd skarbowy <.INDEXUP>1)<./>, do którego adresowana jest informacja"></ea:framelabel>
<ea:framelabel id="Framelabel140" style="Z-INDEX: 122; LEFT: 28px; POSITION: absolute; TOP: 292px"
				runat="server" Number="6" Height="28px" Width="602px" 
                Text="Cel złożenia formularza<.Normal>(zaznaczyć właściwy kwadrat)<./>">
                </ea:FrameLabel>
<ea:checklabel id="Checklabel4" style="Z-INDEX: 124; LEFT: 161px; POSITION: absolute; TOP: 299px"
				runat="server" DataMember="A.Korekta" Number="1" Height="14px" Width="189px" Text="złożenie informacji"
				NumberAlignLeft="False" ComparedValue="False">
            </ea:CheckLabel>
<ea:checklabel id="Checklabel3" style="Z-INDEX: 125; LEFT: 369px; POSITION: absolute; TOP: 299px"
				runat="server" DataMember="A.Korekta" Number="2" Height="14px" Width="126px" Text="korekta informacji 2)"
				NumberAlignLeft="False"></ea:checklabel>
<ea:framelabel id="FrameLabel1" style="Z-INDEX: 126; LEFT: 0px; POSITION: absolute; TOP: 320px"
				runat="server" Height="76px" Width="630px" Text="B. DANE IDENTYFIKACYJNE PŁATNIKA" FrameStyle="BigYellowBold"
				FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="FrameLabel4" style="Z-INDEX: 127; LEFT: 28px; POSITION: absolute; TOP: 348px"
				runat="server" DataMember="B1.Nazwa" Number="7" Height="50px" Width="602px" 
                Text="Nazwa pełna, REGON"></ea:framelabel>
<ea:framelabel id="Framelabel41" style="Z-INDEX: 156; LEFT: 0px; POSITION: absolute; TOP: 398px"
				runat="server" Text="C. DANE IDENTYFIKACYJNE PODATNIKA" Width="630px" Height="82px" FrameStyle="BigYellowBold"
				FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="flPeselNip" style="Z-INDEX: 159; LEFT: 28px; POSITION: absolute; TOP: 426px; width: 600px;"
				runat="server" 
                Text="Identyfikator podatkowy NIP/Numer PESEL &lt;.Indexup&gt;(niepotrzebne skreślić))" 
                Height="28px" Number="8"
				DataMember="IdentyfikatorPodatnika"></ea:framelabel>
<ea:framelabel id="Framelabel103"                 
                style="Z-INDEX: 160; LEFT: 28px; POSITION: absolute; TOP: 454px; width: 239px;" SmallerFontLength="20"
				runat="server" Text="Nazwisko" Height="28px" Number="9" DataMember="C1.Nazwisko"></ea:framelabel>
<ea:framelabel id="Framelabel104" style="Z-INDEX: 161; LEFT: 266px; POSITION: absolute; TOP: 454px; width: 190px;"
				runat="server" Text="Pierwsze imię" Height="28px" Number="10" DataMember="C1.Imię"></ea:framelabel>
<ea:framelabel id="Framelabel105" style="Z-INDEX: 162; LEFT: 455px; POSITION: absolute; TOP: 454px; width: 177px;"
				runat="server" Text="Data urodzenia" Height="28px" Number="11" DataMember="C1.DataUrodz"
				ValueStyle="Date"></ea:framelabel>
<ea:framelabel id="Framelabel36" style="Z-INDEX: 179; LEFT: 0px; POSITION: absolute; TOP: 482px"
				runat="server" Text="D. INFORMACJA O KWOTACH WYPŁACONYCH PODATNIKOWI" Width="630px" Height="390px"
                FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:FrameLabel id="FrameLabel39" style="Z-INDEX: 181; LEFT: 14px; POSITION: absolute; TOP: 510px"
				runat="server" Text="<br>Miesiąc,<br>za który dokonano wypłaty" Width="63px" Height="70px" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Center"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel16" style="Z-INDEX: 185; LEFT: 77px; POSITION: absolute; TOP: 510px"
				runat="server" Text="<br>Kwota wypłacona" Width="140px" Height="70px" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Center" ValueStyle="ZlGr">
                </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel37" style="Z-INDEX: 182; LEFT: 217px; POSITION: absolute; TOP: 510px"
				runat="server" Text="Kwota wolna od podatku dochodowego na podstawie art.21 ust.1 pkt 16 lit.b ustawy" Width="133px" Height="70px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center"
				ValueStyle="ZlGr"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel40" style="Z-INDEX: 183; LEFT: 350px; POSITION: absolute; TOP: 510px"
				runat="server" Text="Kwota wolna od podatku dochodowego na podstawie art.21 ust.1 pkt 17 ustawy" Width="140px" Height="70px" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Center" ValueStyle="ZlGr"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel42" style="Z-INDEX: 184; LEFT: 490px; POSITION: absolute; TOP: 510px"
				runat="server" Text="Kwota po odliczeniu kwot<br>wolnych od podatku<br>b - (c + d)" Width="140px" Height="70px" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Center" ValueStyle="ZlGr"></ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel38" style="Z-INDEX: 180; LEFT: 14px; POSITION: absolute; TOP: 580px"
				runat="server" Text="a" Width="63px" Height="14px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel44" style="Z-INDEX: 186; LEFT: 77px; POSITION: absolute; TOP: 580px"
				runat="server" Text="b" Width="140px" Height="14px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel45" style="Z-INDEX: 187; LEFT: 217px; POSITION: absolute; TOP: 580px"
				runat="server" Text="c" Width="133px" Height="14px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel46" style="Z-INDEX: 188; LEFT: 350px; POSITION: absolute; TOP: 580px"
				runat="server" Text="d" Width="140px" Height="14px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel47" style="Z-INDEX: 189; LEFT: 490px; POSITION: absolute; TOP: 580px"
				runat="server" Text="e" Width="140px" Height="14px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle"></ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel48" style="Z-INDEX: 190; LEFT: 14px; POSITION: absolute; TOP: 594px"
				runat="server" Text="Styczeń"
				Width="63px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle"></ea:FrameLabel>
<ea:framelabel id="Framelabel50" style="Z-INDEX: 192; LEFT: 77px; POSITION: absolute; TOP: 594px; right: 606px;"
				runat="server" Width="140px" Height="28px" Number="12" DataMember="D.01_b" 
                ValueStyle="ZlGr"></ea:framelabel>
            &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
            &nbsp; &nbsp;
<ea:framelabel id="Framelabel52" style="Z-INDEX: 194; LEFT: 217px; POSITION: absolute; TOP: 594px"
				runat="server" Width="133px" Height="28px" Number="13" DataMember="D.01_c" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="Framelabel53" style="Z-INDEX: 195; LEFT: 350px; POSITION: absolute; TOP: 594px"
				runat="server" Width="140px" Height="28px" Number="14" DataMember="D.01_d" 
                ValueStyle="ZlGr"></ea:framelabel>
            &nbsp;&nbsp;
<ea:framelabel id="Framelabel23" style="Z-INDEX: 196; LEFT: 490px; POSITION: absolute; TOP: 594px"
				runat="server" Width="140px" Height="28px" Number="15" DataMember="D.01_e" 
                ValueStyle="ZlGr">
                </ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel30" style="Z-INDEX: 190; LEFT: 14px; POSITION: absolute; TOP: 622px"
				runat="server" Text="Luty"
				Width="63px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel32" style="Z-INDEX: 192; LEFT: 77px; POSITION: absolute; TOP: 622px"
				runat="server" Width="140px" Height="28px" Number="16" DataMember="D.02_b" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel31" style="Z-INDEX: 194; LEFT: 217px; POSITION: absolute; TOP: 622px"
				runat="server" Width="133px" Height="28px" Number="17" DataMember="D.02_c" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel28" style="Z-INDEX: 195; LEFT: 350px; POSITION: absolute; TOP: 622px"
				runat="server" Width="140px" Height="28px" Number="18" DataMember="D.02_d" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel27" style="Z-INDEX: 196; LEFT: 490px; POSITION: absolute; TOP: 622px"
				runat="server" Width="140px" Height="28px" Number="19" DataMember="D.02_e" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel55" style="Z-INDEX: 190; LEFT: 14px; POSITION: absolute; TOP: 650px"
				runat="server" Text="Marzec"
				Width="63px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel58" style="Z-INDEX: 192; LEFT: 77px; POSITION: absolute; TOP: 650px"
				runat="server" Width="140px" Height="28px" Number="20" DataMember="D.03_b" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel57" style="Z-INDEX: 194; LEFT: 217px; POSITION: absolute; TOP: 650px"
				runat="server" Width="133px" Height="28px" Number="21" DataMember="D.03_c" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel51" style="Z-INDEX: 195; LEFT: 350px; POSITION: absolute; TOP: 650px"
				runat="server" Width="140px" Height="28px" Number="22" DataMember="D.03_d" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel49" style="Z-INDEX: 196; LEFT: 490px; POSITION: absolute; TOP: 650px"
				runat="server" Width="140px" Height="28px" Number="23" DataMember="D.03_e" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel62" style="Z-INDEX: 190; LEFT: 14px; POSITION: absolute; TOP: 678px"
				runat="server" Text="Kwiecień"
				Width="63px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel64" style="Z-INDEX: 192; LEFT: 77px; POSITION: absolute; TOP: 678px"
				runat="server" Width="140px" Height="28px" Number="24" DataMember="D.04_b" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel63" style="Z-INDEX: 194; LEFT: 217px; POSITION: absolute; TOP: 678px"
				runat="server" Width="133px" Height="28px" Number="25" DataMember="D.04_c" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel61" style="Z-INDEX: 195; LEFT: 350px; POSITION: absolute; TOP: 678px"
				runat="server" Width="140px" Height="28px" Number="26" DataMember="D.04_d" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel60" style="Z-INDEX: 196; LEFT: 490px; POSITION: absolute; TOP: 678px"
				runat="server" Width="140px" Height="28px" Number="27" DataMember="D.04_e" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel68" style="Z-INDEX: 190; LEFT: 14px; POSITION: absolute; TOP: 706px"
				runat="server" Text="Maj"
				Width="63px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel70" style="Z-INDEX: 192; LEFT: 77px; POSITION: absolute; TOP: 706px"
				runat="server" Width="140px" Height="28px" Number="28" DataMember="D.05_b" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel69" style="Z-INDEX: 194; LEFT: 217px; POSITION: absolute; TOP: 706px"
				runat="server" Width="133px" Height="28px" Number="29" DataMember="D.05_c" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel67" style="Z-INDEX: 195; LEFT: 350px; POSITION: absolute; TOP: 706px"
				runat="server" Width="140px" Height="28px" Number="30" DataMember="D.05_d" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel66" style="Z-INDEX: 196; LEFT: 490px; POSITION: absolute; TOP: 706px"
				runat="server" Width="140px" Height="28px" Number="31" DataMember="D.05_e" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel75" style="Z-INDEX: 190; LEFT: 14px; POSITION: absolute; TOP: 734px"
				runat="server" Text="Czerwiec"
				Width="63px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel77" style="Z-INDEX: 192; LEFT: 77px; POSITION: absolute; TOP: 734px"
				runat="server" Width="140px" Height="28px" Number="32" DataMember="D.06_b" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel76" style="Z-INDEX: 194; LEFT: 217px; POSITION: absolute; TOP: 734px"
				runat="server" Width="133px" Height="28px" Number="33" DataMember="D.06_c" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel74" style="Z-INDEX: 195; LEFT: 350px; POSITION: absolute; TOP: 734px"
				runat="server" Width="140px" Height="28px" Number="34" DataMember="D.06_d" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel73" style="Z-INDEX: 196; LEFT: 490px; POSITION: absolute; TOP: 734px"
				runat="server" Width="140px" Height="28px" Number="35" DataMember="D.06_e" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel82" style="Z-INDEX: 190; LEFT: 14px; POSITION: absolute; TOP: 762px"
				runat="server" Text="Lipiec"
				Width="63px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel84" style="Z-INDEX: 192; LEFT: 77px; POSITION: absolute; TOP: 762px"
				runat="server" Width="140px" Height="28px" Number="36" DataMember="D.07_b" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel83" style="Z-INDEX: 194; LEFT: 217px; POSITION: absolute; TOP: 762px"
				runat="server" Width="133px" Height="28px" Number="37" DataMember="D.07_c" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel80" style="Z-INDEX: 195; LEFT: 350px; POSITION: absolute; TOP: 762px"
				runat="server" Width="140px" Height="28px" Number="38" DataMember="D.07_d" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel79" style="Z-INDEX: 196; LEFT: 490px; POSITION: absolute; TOP: 762px"
				runat="server" Width="140px" Height="28px" Number="39" DataMember="D.07_e" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel88" style="Z-INDEX: 190; LEFT: 14px; POSITION: absolute; TOP: 790px"
				runat="server" Text="Sierpień"
				Width="63px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel91" style="Z-INDEX: 192; LEFT: 77px; POSITION: absolute; TOP: 790px"
				runat="server" Width="140px" Height="28px" Number="40" DataMember="D.08_b" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel90" style="Z-INDEX: 194; LEFT: 217px; POSITION: absolute; TOP: 790px"
				runat="server" Width="133px" Height="28px" Number="41" DataMember="D.08_c" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel87" style="Z-INDEX: 195; LEFT: 350px; POSITION: absolute; TOP: 790px"
				runat="server" Width="140px" Height="28px" Number="42" DataMember="D.08_d" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel86" style="Z-INDEX: 196; LEFT: 490px; POSITION: absolute; TOP: 790px"
				runat="server" Width="140px" Height="28px" Number="43" DataMember="D.08_e" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel95" style="Z-INDEX: 190; LEFT: 14px; POSITION: absolute; TOP: 818px"
				runat="server" Text="Wrzesień"
				Width="63px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel98" style="Z-INDEX: 192; LEFT: 77px; POSITION: absolute; TOP: 818px"
				runat="server" Width="140px" Height="28px" Number="44" DataMember="D.09_b" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel97" style="Z-INDEX: 194; LEFT: 217px; POSITION: absolute; TOP: 818px"
				runat="server" Width="133px" Height="28px" Number="45" DataMember="D.09_c" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel94" style="Z-INDEX: 195; LEFT: 350px; POSITION: absolute; TOP: 818px"
				runat="server" Width="140px" Height="28px" Number="46" DataMember="D.09_d" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel93" style="Z-INDEX: 196; LEFT: 490px; POSITION: absolute; TOP: 818px"
				runat="server" Width="140px" Height="28px" Number="47" DataMember="D.09_e" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel117" style="Z-INDEX: 190; LEFT: 14px; POSITION: absolute; TOP: 846px"
				runat="server" Text="Październik"
				Width="63px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel119" style="Z-INDEX: 192; LEFT: 77px; POSITION: absolute; TOP: 846px"
				runat="server" Width="140px" Height="28px" Number="48" DataMember="D.10_b" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel118" style="Z-INDEX: 194; LEFT: 217px; POSITION: absolute; TOP: 846px"
				runat="server" Width="133px" Height="28px" Number="49" DataMember="D.10_c" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel116" style="Z-INDEX: 195; LEFT: 350px; POSITION: absolute; TOP: 846px"
				runat="server" Width="140px" Height="28px" Number="50" DataMember="D.10_d" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel100" style="Z-INDEX: 196; LEFT: 490px; POSITION: absolute; TOP: 846px"
				runat="server" Width="140px" Height="28px" Number="51" DataMember="D.10_e" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
            &nbsp;
<ea:DeklaracjaFooter id="DeklaracjaFooter1" style="Z-INDEX: 213; LEFT: 511px; POSITION: absolute; TOP: 940px"
				runat="server" Width="56px" Height="15px" Symbol="PIT-R" PageNumber="1" PageTotal="2" 
                Version="17"></ea:DeklaracjaFooter>
<ea:DeklaracjaHeader id="DeklaracjaHeader2" style="Z-INDEX: 214; LEFT: 0px; POSITION: absolute; TOP: 980px"
				runat="server" Width="630px" StylNagłówka="JasneCiemneElektroniczniePortal"></ea:DeklaracjaHeader>
<ea:framelabel id="Framelabel15" style="Z-INDEX: 190; LEFT: 0px; POSITION: absolute; TOP: 1001px"
				runat="server" Width="630px" Height="84px" FrameStyle="SmallYellow"></ea:framelabel>
<ea:FrameLabel id="FrameLabel127" style="Z-INDEX: 190; LEFT: 14px; POSITION: absolute; TOP: 1001px"
				runat="server" Text="Listopad"
				Width="63px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel129" style="Z-INDEX: 192; LEFT: 77px; POSITION: absolute; TOP: 1001px"
				runat="server" Width="140px" Height="28px" Number="52" DataMember="D.11_b" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel128" style="Z-INDEX: 194; LEFT: 217px; POSITION: absolute; TOP: 1001px"
				runat="server" Width="133px" Height="28px" Number="53" DataMember="D.11_c" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel124" style="Z-INDEX: 195; LEFT: 350px; POSITION: absolute; TOP: 1001px"
				runat="server" Width="140px" Height="28px" Number="54" DataMember="D.11_d" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel121" style="Z-INDEX: 196; LEFT: 490px; POSITION: absolute; TOP: 1001px"
				runat="server" Width="140px" Height="28px" Number="55" DataMember="D.11_e" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel137" style="Z-INDEX: 190; LEFT: 14px; POSITION: absolute; TOP: 1029px"
				runat="server" Text="Grudzień"
				Width="63px" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel139" style="Z-INDEX: 192; LEFT: 77px; POSITION: absolute; TOP: 1029px"
				runat="server" Width="140px" Height="28px" Number="56" DataMember="D.12_b" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel138" style="Z-INDEX: 194; LEFT: 217px; POSITION: absolute; TOP: 1029px"
				runat="server" Width="133px" Height="28px" Number="57" DataMember="D.12_c" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel135" style="Z-INDEX: 195; LEFT: 350px; POSITION: absolute; TOP: 1029px"
				runat="server" Width="140px" Height="28px" Number="58" DataMember="D.12_d" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel134" style="Z-INDEX: 196; LEFT: 490px; POSITION: absolute; TOP: 1029px"
				runat="server" Width="140px" Height="28px" Number="59" DataMember="D.12_e" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
            &nbsp;
<ea:FrameLabel id="FrameLabel71" style="Z-INDEX: 212; LEFT: 14px; POSITION: absolute; TOP: 1057px"
				runat="server" Text="RAZEM" Width="476px" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left" VerticalAlign="Middle"></ea:FrameLabel>
            &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
<ea:framelabel id="Framelabel89" style="Z-INDEX: 229; LEFT: 490px; POSITION: absolute; TOP: 1057px"
				runat="server" Width="140px" Height="28px" Number="60" DataMember="D.razem_e" 
                ValueStyle="ZlGr"></ea:framelabel>
<ea:FrameLabel id="FrameLabel122" style="Z-INDEX: 141; LEFT: 0px; POSITION: absolute; TOP: 1085px"
				runat="server" Text="E. PODPIS PŁATNIKA LUB OSOBY ODPOWIEDZIALNEJ ZA OBLICZENIE I POBRANIE PODATKU / PEŁNOMOCNIKA PŁATNIKA"
				Width="630px" Height="100px" FrameStyle="BigYellowBold" 
                FrameBorderStyle="DoubleHeader"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel123" style="Z-INDEX: 142; LEFT: 28px; POSITION: absolute; TOP: 1127px"
				runat="server" Text="Imię" Width="203px" Height="56px" Number="61" DataMember="E.Imię"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel125" style="Z-INDEX: 144; LEFT: 231px; POSITION: absolute; TOP: 1127px"
				runat="server" Text="Nazwisko" Width="203px" Height="56px" Number="62" 
                DataMember="E.Nazwisko"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel126" style="Z-INDEX: 145; LEFT: 434px; POSITION: absolute; TOP: 1127px"
				runat="server" Text="Podpis i pieczątka"
				Width="196px" Height="56px" Number="63"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel3" style="Z-INDEX: 146; LEFT: 0px; POSITION: absolute; TOP: 1190px"
				runat="server" Text="&lt;.INDEXUP&gt;1)&lt;./&gt; Ilekroć w informacji jest mowa o urzędzie skarbowym - oznacza to właściwy dla płatnika urząd skarbowy, o którym mowa w przepisach ustawy."
				Width="630px" Height="6px" FrameBorderStyle="None" FrameStyle="Small">
                </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel142" style="Z-INDEX: 147; LEFT: 0px; POSITION: absolute; TOP: 1205px"
				runat="server" Text="&lt;.INDEXUP&gt;2)&lt;./&gt; Zgodnie z art.81 ustawy z dnia 29 sierpnia 1997 r.- Ordynacja podatkowa (Dz. U. z 2012 r. poz. 749, z późn. zm.) płatnik może skorygować złożoną informację przez złożenie informacji korygującej wraz z dołączonym pisemnym uzasadnieniem przyczyn korekty."
				Width="630px" Height="42px" FrameBorderStyle="None" FrameStyle="Small">
                </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel131" style="Z-INDEX: 150; LEFT: 290px; POSITION: absolute; TOP: 1234px"
				runat="server" Text="&lt;font STYLE='font-size: 7pt;'&gt;&lt;b&gt;Objaśnienia&lt;/b&gt;" Width="327px" Height="21px" HorizontalAlign="Left" FrameBorderStyle="None"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel133" style="Z-INDEX: 152; LEFT: 0px; POSITION: absolute; TOP: 1252px"
				runat="server" Text="1. W części D:"
				Width="630px" Height="12px" FrameStyle="Small" FrameBorderStyle="None"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel2" style="Z-INDEX: 152; LEFT: 10px; POSITION: absolute; TOP: 1264px"
				runat="server" Text="1) w kolumnie b – płatnik wykazuje ogólną kwotę wypłat dokonanych należności w danym miesiącu, z uwzględnieniem kwot wolnych od podatku dochodowego na podstawie art.21 ust.1 pkt 16 lit.b i pkt 17 ustawy,"
				Width="630px" Height="20px" FrameStyle="Small" FrameBorderStyle="None"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel5" style="Z-INDEX: 152; LEFT: 10px; POSITION: absolute; TOP: 1286px"
				runat="server" Text="2) w kolumnie c – płatnik wykazuje kwoty diet i innych należności, wypłacone osobom pełniącym obowiązki społeczne i obywatelskie, wolne od podatku dochodowego na podstawie art.21 ust.1 pkt 16 lit. b ustawy,"
				Width="630px" Height="20px" FrameStyle="Small" FrameBorderStyle="None"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel8" style="Z-INDEX: 152; LEFT: 10px; POSITION: absolute; TOP: 1308px"
				runat="server" Text="3) w kolumnie d – płatnik wykazuje kwoty diet oraz kwoty stanowiące zwrot kosztów, wypłacone osobom pełniącym obowiązki społeczne i obywatelskie, wolne od podatku dochodowego na podstawie art.21 ust.1 pkt 17 ustawy,"
				Width="630px" Height="20px" FrameStyle="Small" FrameBorderStyle="None"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel9" style="Z-INDEX: 152; LEFT: 10px; POSITION: absolute; TOP: 1330px"
				runat="server" Text="4) w kolumnie e – płatnik wykazuje nadwyżkę między kwotą wypłaconych należności a sumą kwot wolnych od podatku dochodowego, która podlega opodatkowaniu podatkiem dochodowym."
				Width="630px" Height="20px" FrameStyle="Small" FrameBorderStyle="None"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel56" style="Z-INDEX: 153; LEFT: 0px; POSITION: absolute; TOP: 1360px"
				runat="server" Text="2. Sumę kwot wykazanych w kolumnie e płatnik wykazuje w wierszu 7 części E informacji PIT-11 oraz w rocznym obliczeniu podatku PIT-40."
				Width="630px" Height="24px" FrameBorderStyle="None" FrameStyle="Small"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel136" style="Z-INDEX: 155; LEFT: 0px; POSITION: absolute; TOP: 1378px"
				runat="server" Text="3. W sytuacji gdy płatnik wypłaca osobie fizycznej jedynie należności z tytułu pełnienia obowiązków społecznych i obywatelskich i należności te nie przekraczają kwot wolnych od podatku dochodowego, płatnik nie ma obowiązku sporządzania informacji PIT-11, a jedynie informację PIT-R. Jeden egzemplarz informacji płatnik przesyła do urzędu skarbowego według miejsca zamieszkania podatnika, drugi egzemplarz przekazuje podatnikowi."
				Width="630px" Height="35px" FrameBorderStyle="None" FrameStyle="Small"></ea:FrameLabel>
<ea:framelabel id="FrameLabel6" style="Z-INDEX: 156; LEFT: 300px; POSITION: absolute; TOP: 1424px"
				runat="server" Width="327px" Height="21px" Text="&lt;font STYLE='font-size: 7pt;'&gt;&lt;b&gt;Pouczenie&lt;/b&gt;"
				FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel7" style="Z-INDEX: 157; LEFT: 3px; POSITION: absolute; TOP: 1449px"
				runat="server" Width="627px" Height="6px" Text="Za uchybienie obowiązkom płatnika grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym."
				FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:DeklaracjaFooter id="DeklaracjaFooter2" style="Z-INDEX: 154; LEFT: 0px; POSITION: absolute; TOP: 1890px"
				runat="server" Symbol="PIT-R" PageNumber="2" PageTotal="2" Version="17"></ea:DeklaracjaFooter>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PITR,Soneta.Deklaracje"
			oncontextload="OnContextLoad" style="Z-INDEX: 137; LEFT: 189px; POSITION: absolute; TOP: 1897px"
			LeftMargin="15" PageHeight="977px" PageZoom="107%"></ea:datacontext>
</form>
	</body>
</HTML>
