﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="System.Collections.Generic" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>VAT-7 (18)</title>

		<script runat="server">

			private void OnContextLoad(Object sender, EventArgs args)
			{
                    var dekx = (Deklaracja)dc[typeof(Deklaracja)];
                    if (dekx as Soneta.Deklaracje.VAT.VAT7 == null)
                        throw new InvalidOperationException("Wydruk VAT-7 (18) może być drukowany wyłącznie dla deklaracji VAT-7 w wersji 18.");
                    var dek = (Soneta.Deklaracje.VAT.VAT7)dekx;

					if (dek.TypDeklaracjiVAT7 == Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7 || dek.TypDeklaracjiVAT7 == Soneta.Deklaracje.VAT.TypDeklaracjiVAT7.VAT7K)
					{
						var dek2 = (Soneta.Deklaracje.VAT.VAT7_18)dc[typeof(Soneta.Deklaracje.VAT.VAT7_18)];

						if (dek2.Okres.Months > 1)
						{
							LabelNazwa.Text = "VAT-7K";
							LabelOkres.Text = "Kwartał";
							LabelOkres.DataMember = "";
							LabelOkres.EditValue = dek2.Okres.To.Quarter;
							LabelInfo.Text = "<span style=\"font-size:95%\">Art. 99 ust. 2 lub 3 ustawy z dnia 11 marca 2004r. o podatku od towarów i usług (Dz. U. z 2017 r. poz. 1221, z późn. zm.), zwanej dalej \"ustawą\".</span><br>Mali podatnicy, o których mowa w art. 2 pkt 25 ustawy, obowiązani do składania deklaracji za okresy kwartalne zgodnie z art. 99<br>ust. 2 lub 3 ustawy.";
							DeklaracjaFooter1.Symbol = DeklaracjaFooter2.Symbol = DeklaracjaFooter3.Symbol = "VAT-7K";
							DeklaracjaFooter1.Version = DeklaracjaFooter2.Version = DeklaracjaFooter3.Version = 12;
						}
					}
					else
						throw new ArgumentException("Wybrano niewłaściwy wydruk. Niezgodność typów deklaracji.");


			    if ((bool) dek.Bloki["DOD"]["DrukujGrosze"])
			        foreach (Control c in VAT_7_18.Controls)
			        {
			            var frameLabel = c as FrameLabel;
			            if (frameLabel != null && frameLabel.ValueStyle == ValueStyles.Zl)
			                frameLabel.ValueStyle = ValueStyles.ZlGr;
			        }

			    FrameNrDokumentu.EditValue = dek.GetNumerUpo();
			}

		</script>
	</HEAD>


	<body leftMargin="0" rightMargin="0">
		<form id="VAT_7_18" method="post" runat="server">
		<ea:deklaracjaheader runat="server" id="DeklaracjaHeader1" style="LEFT: 0px; TOP: 0px" StylNagłówka="WylacznieElektronicznie" />
		<ea:datacontext runat="server" id="dc" style="LEFT: 189px; TOP: 0px" oncontextload="OnContextLoad" TypeName="Soneta.Deklaracje.Deklaracja,Soneta.Deklaracje" LeftMargin="13" BottomMargin="1" PageHeight="952" />

<ea:framelabel runat="server" style="LEFT: 0px; TOP: 21px"	Text="1. Identyfikator podatkowy NIP podatnika" Height="28px" DataMember="0.Nip" ValueStyle="n13" Width="294px" />
<ea:framelabel runat="server" id="FrameNrDokumentu" style="LEFT: 294px; TOP: 21px" Number="2" Text="Nr dokumentu" Height="28px" Width="279px" FrameStyle="SmallBoldGray" />
<ea:framelabel runat="server" style="LEFT: 573px; TOP: 21px" Number="3" Text="Status" Height="28px" Width="77px" FrameStyle="SmallBoldGray" />

<ea:framelabel runat="server" id="LabelNazwa" style="LEFT: 0px; TOP: 63px" Text="VAT-7" Height="14px" Width="70px" FrameStyle="BigBold" FrameBorderStyle="None" />
<ea:framelabel runat="server" style="LEFT: 120px; TOP: 63px" HorizontalAlign="Center" Text="DEKLARACJA DLA PODATKU OD TOWARÓW I USŁUG" Height="14px" Width="410px" FrameStyle="BigBold" FrameBorderStyle="None" />

<ea:framelabel runat="server" style="LEFT: 155px;  TOP: 122px" Text="za" Height="17px" Width="26px" FrameStyle="BigBold" FrameBorderStyle="None" />
<ea:framelabel runat="server" id="LabelOkres" style="LEFT: 189px; TOP: 112px" Number="4" Text="Miesiąc" Height="28px" DataMember="0.Miesiąc" ValueStyle="n2" Width="105px" />
<ea:framelabel runat="server" style="LEFT: 294px; TOP: 112px" Text="5. Rok" Height="28px" DataMember="0.Rok" ValueStyle="n2" Width="105px" />

<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 154px" Height="35px" Width="649px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 7px;   TOP: 158px" Text="Podstawa prawna: ‪‪Składający:" Height="24px" Width="91px" FrameStyle="SmallYellow" FrameBorderStyle="None" />
<ea:framelabel runat="server" id="LabelInfo" style="LEFT: 94px; TOP: 159px; width: 550px" Text='Art. 99 ust. 1 ustawy z dnia 11 marca 2004r. o podatku od towarów i usług (Dz. U. z 2017 r. poz. 1221, z późn. zm.), zwanej dalej "ustawą".|Podatnicy, o których mowa w art. 15 ustawy, obowiązani do składania deklaracji za okresy miesięczne zgodnie z art. 99 ust. 1 ustawy.' Height="28px" FrameStyle="SmallYellow" FrameBorderStyle="None" />
<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 189px" Text="A. MIEJSCE I CEL SKŁADANIA DEKLARACJI" Height="57px" Width="653px" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 210px" Number="6" Text="Urząd skarbowy, do którego adresowana jest deklaracja" Height="28px" DataMember="A.UrzadSkarb" Width="392px" />
<ea:framelabel runat="server" style="LEFT: 420px; TOP: 210px" Number="7" Text="Cel złożenia formularza <.Normal>(zaznaczyć właściwy kwadrat)<./>:" Height="28px" Width="228px" />
<ea:checklabel runat="server" style="LEFT: 426px; TOP: 217px" Number="1" Text="złożenie deklaracji" Height="21px" DataMember="A.Korekta" Width="102px" ComparedValue="False" NumberAlignLeft="False" />
<ea:checklabel runat="server" style="LEFT: 530px; TOP: 217px" Number="2" Text="korekta deklaracji &lt;SUP&gt;1)&lt;/SUP&gt;" Height="21px" DataMember="A.Korekta" NumberAlignLeft="False" />

<!-- SEKCJA B -->

<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 246px; font-size:20pt" Height="147px" Width="653px" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom" />
<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 245px; font-size:20pt" Height="147px" Text="B. DANE IDENTYFIKACYJNE PODATNIKA|<.FOOTER>&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;* - dotyczy podmiotów niebędących osobami fizycznymi&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;** - dotyczy podmiotów będących osobami fizycznymi<./>" Width="653px" FrameStyle="BigBold" FrameBorderStyle="None" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 274px" Number="8" Text="Rodzaj podatnika <.Normal>(zaznaczyć właściwy kwadrat)<./>" Height="28px" Width="621px" />
<ea:checklabel runat="server" style="LEFT: 140px; TOP: 283px; right: 714px" Number="1" Text="podatnik niebędący osobą fizyczną" Height="14px" DataMember="B1.OsobaFiz" Width="189px" ComparedValue="False" NumberAlignLeft="False" />
<ea:checklabel runat="server" style="LEFT: 364px; TOP: 283px" Number="2" Text="osoba fizyczna" Height="14px" DataMember="B1.OsobaFiz" Width="189px" NumberAlignLeft="False" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 302px" Number="9" Text="Nazwa pełna * / Nazwisko, pierwsze imię, data urodzenia **" Height="84px" DataMember="B1.Nazwa" Width="625px" SmallerFontLength="80" />

<!-- SEKCJA C -->

<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 394px; height: 497px" Text="C. ROZLICZENIE PODATKU NALEŻNEGO" Width="653px" FrameStyle="BigYellowBold" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 403px; right: 883px; height: 14px;"	HorizontalAlign="Center" Text="Podstawa opodatkowania w zł" Width="160px" FrameStyle="SmallBoldYellow" VerticalAlign="Middle" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 403px; height: 15px" HorizontalAlign="Center" Text="Podatek należny w zł" Width="160px" FrameStyle="SmallBoldYellow" VerticalAlign="Middle" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 415px; height: 26px" Number="1" Text="Dostawa towarów oraz świadczenie usług na terytorium kraju, zwolnione od podatku" Height="28px" Width="298px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 415px" Number="10" Height="28px" DataMember="C.Zwolnione" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 415px; bottom: 459px" HorizontalAlign="Right" Height="28px" Width="160px" FrameStyle="BigYellowBold" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 443px" Number="2" Text="Dostawa towarów oraz świadczenie usług poza terytorium|kraju" Height="28px" Width="301px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 443px; right: 723px" Number="11" Height="28px" DataMember="C.DostawaPozaKrajem" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 443px" Height="28px" ValueStyle="Right" Width="160px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 77px;  TOP: 471px; height: 25px" Text="2a. w tym świadczenie usług, o których mowa w art. 100 ust. 1 pkt 4 ustawy" Width="253px" FrameStyle="SmallBoldYellow" Height="15px" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 471px" Number="12" Height="28px" DataMember="C.DostawaPozaKrajemUslugiUnia" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 499px" Number="3" Text="Dostawa towarów oraz świadczenie usług na terytorium kraju, opodatkowane stawką 0%" Height="28px" Width="301px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 499px" Number="13" Height="28px" DataMember="C.0%Netto" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 499px" Height="28px" ValueStyle="Right" Width="160px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 77px;  TOP: 527px; height: 25px" Text="3a. w tym dostawa towarów, o której mowa w art. 129 ustawy" Width="253px" FrameStyle="SmallBoldYellow" Height="15px" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 527px" Number="14" Height="28px" DataMember="C.0%NettoArt129" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 555px" Number="4" Text="Dostawa towarów oraz świadczenie usług na terytorium kraju, opodatkowane stawką 5%" Height="28px" Width="300px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 555px" Number="15" Height="28px" DataMember="C.3%Netto" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 555px" Number="16" Height="28px" DataMember="C.3%VAT" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 583px" Number="5" Text="Dostawa towarów oraz świadczenie usług na terytorium kraju, opodatkowane stawką 7% albo 8%" Height="28px" Width="300px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 583px" Number="17" Height="28px" DataMember="C.7%Netto" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 583px" Number="18" Height="28px" DataMember="C.7%VAT" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 611px" Number="6" Text="Dostawa towarów oraz świadczenie usług na terytorium kraju, opodatkowane stawką 22% albo 23%" Height="28px" Width="302px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 611px" Number="19" Height="28px" DataMember="C.22%Netto" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 611px" Number="20" Height="28px" DataMember="C.22%VAT" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 639px" Number="7" Text="Wewnątrzwspólnotowa dostawa towarów" Height="28px" Width="303px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 639px" Number="21" Height="28px" DataMember="C.UniaDostawa" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 639px;"	Height="28px" ValueStyle="Right" Width="160px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 667px" Number="8" Text="Eksport towarów" Height="28px" Width="303px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 667px" Number="22" Height="28px" DataMember="C.Eksport" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 695px" Number="9" Text="Wewnątrzwspólnotowe nabycie towarów" Height="28px" Width="302px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 695px" Number="23" Height="28px" DataMember="C.UniaNabycieNetto" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 695px; height: 27px" Number="24" DataMember="C.UniaNabycieVAT" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 723px; height: 26px; width: 303px" Number="10" Text="Import towarów podlegający rozliczeniu zgodnie z art. 33a|ustawy" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 723px" Number="25" Height="28px" DataMember="C.ImportTowarowNetto" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 723px" Number="26" Height="28px" DataMember="C.ImportTowarowVAT" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 751px" Number="11" Text="Import usług z wyłączeniem usług nabywanych od|podatników podatku od wartości dodanej, do których stosuje|się art. 28b ustawy" Height="28px" Width="302px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 751px" Number="27" Height="28px" DataMember="C.ImportUslugNettoNieUnia" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 751px" Number="28" Height="28px" DataMember="C.ImportUslugVATNieUnia" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 779px; height: 25px" Number="12" Text="Import usług nabywanych od podatników podatku od|wartości dodanej, do których stosuje się art. 28b ustawy" Width="302px" FrameStyle="SmallBoldYellow" Height="15px" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 779px" Number="29" Height="28px" DataMember="C.ImportUslugNettoUnia" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 779px" Number="30" Height="28px" DataMember="C.ImportUslugVATUnia" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 807px" Number="13" Text="Dostawa towarów oraz świadczenie usług, dla których|podatnikiem jest nabywca zgodnie z art. 17 ust. 1 pkt 7 lub 8|ustawy <.Normal>(wypełnia dostawca)<./>" Height="28px" Width="302px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 807px" Number="31" Height="28px" DataMember="C.DostawaTowarowNettoDostawca" ValueStyle="Zl" Width="160px" />

<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 835px; right: 1371px" Number="14" Text="Dostawa towarów, dla których podatnikiem jest nabywca|zgodnie z art. 17 ust. 1 pkt 5 ustawy <.Normal>(wypełnia nabywca)<./>" Height="28px" Width="302px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 835px" Number="32" Height="28px" DataMember="C.DostawaTowarowNettoZagranica" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 835px" Number="33" Height="28px" DataMember="C.DostawaTowarowVATZagranica" ValueStyle="Zl" Width="160px" />

<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 863px; right: 1371px" Number="15" Text="Dostawa towarów oraz świadczenie usług, dla których|podatnikiem jest nabywca zgodnie z art. 17 ust. 1 pkt 7 lub 8|ustawy <.Normal>(wypełnia nabywca)<./>" Height="28px" Width="302px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 863px" Number="34" Height="28px" DataMember="C.DostawaTowarowNettoKraj" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 863px" Number="35" Height="28px" DataMember="C.DostawaTowarowVATKraj" ValueStyle="Zl" Width="160px" />


<!-- FOOTER DEKLARACJI STRONA 1-->

<ea:deklaracjafooter runat="server" id="DeklaracjaFooter1" style="LEFT: 522px; TOP: 927px" Height="15px" Width="56px" Version="18" PageTotal="3" PageNumber="1"  Symbol="VAT-7" />

<!-- PAGE 2 -->

<ea:deklaracjaheader runat="server" id="DeklaracjaHeader2" style="LEFT: 0px; TOP: 970px" StylNagłówka="WylacznieElektronicznie" />

<!-- KONCOWKA SEKCJI C -->
<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 996px; font-size:20pt" Height="147px" Width="653px" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 996px" Number="16" Text="Kwota podatku należnego od towarów i usług objętych spisem z natury, o którym mowa w art. 14 ust. 5 ustawy" Height="28px" Width="462px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 996px" Number="36" Height="28px" DataMember="C.Spis" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1024px" Number="17" Text="<span style='font-size:95%;'>Zwrot odliczonej lub zwróconej kwoty wydatkowanej na zakup kas rejestrujących, o którym mowa w art. 111|ust. 6 ustawy</span>" Height="28px" Width="462px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1024px" Number="37" Height="28px" DataMember="C.ZwrotZakupKas" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1052px" Number="18" Text="&lt;span style=&quot;font-size:95%&quot;&gt;Kwota podatku należnego od wewnątrzwspólnotowego nabycia środków transportu, wykazanego w poz. 24,|podlegająca wpłacie w terminie, o którym mowa art. 103 ust. 3, w związku z ust. 4 ustawy&lt;/span&gt;"   Height="28px" Width="462px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1052px" Number="38" Height="28px" DataMember="C.SrodkiTransportu" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1080px" Number="19" Text="Kwota podatku od wewnątrzwspólnotowego nabycia paliw silnikowych, podlegająca wpłacie w terminach, o których mowa w art. 103 ust. 5a i 5b ustawy"   Height="28px" Width="462px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1080px" Number="39" Height="28px" DataMember="C.NabyciePaliw" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1108px" Text="<.Normal>Razem: (<./>Poz. 40<.Normal> = suma kwot z poz. 10, 11, 13, 15, 17, 19, 21, 22,|23, 25, 27, 29, 31, 32 i 34; <./>Poz. 41<.Normal> = suma kwot z poz. 16, 18, 20, 24,|26, 28, 30, 33, 35, 36 i 37 pomniejszona o kwotę z poz. 38 i 39)<./>" Height="28px" Width="301px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 1108px" Number="40" Height="28px" DataMember="C.Netto" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1108px" Number="41" Height="28px" DataMember="C.VAT" ValueStyle="Zl" Width="160px" />


<!-- SEKCJA D -->

<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 1143px" Text="D. ROZLICZENIE PODATKU NALICZONEGO" Height="21px" Width="648px" FrameStyle="BigYellowBold" />
<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 1164px" Text="D.1. PRZENIESIENIA" Height="49px" Width="648px" FrameStyle="BigYellow" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1164px" HorizontalAlign="Center" Text="Podatek do odliczenia w zł" Height="21px" Width="161px" FrameStyle="SmallBoldYellow" VerticalAlign="Middle" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1185px" Text="Kwota nadwyżki z poprzedniej deklaracji" Height="28px" Width="464px" FrameStyle="SmallBoldYellow" FooterText="Kwota z poz. &quot;Kwota do przeniesienia na następny okres rozliczeniowy&quot; z poprzedniej deklaracji lub wynikająca z decyzji." />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1185px" Number="42" Height="28px" DataMember="D1.Nadwyzka" ValueStyle="Zl" Width="162px" />

<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 1213px" Text="D.2. NABYCIE TOWARÓW I USŁUG ORAZ PODATEK NALICZONY Z UWZGLĘDNIENIEM KOREKT" Height="94px" Width="653px" FrameStyle="BigYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 1234px"	HorizontalAlign="Center" Text="Wartość netto w zł" Height="17px" Width="161px" FrameStyle="SmallBoldYellow" VerticalAlign="Middle" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1234px"	HorizontalAlign="Center" Text="Podatek naliczony w zł" Height="17px" Width="161px" FrameStyle="SmallBoldYellow" VerticalAlign="Middle" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1248px"	Text="Nabycie towarów i usług zaliczanych u podatnika do środków|trwałych" Height="28px" Width="299px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 1248px" Number="43" Height="28px" DataMember="D2.SrodkiTrwaleNetto" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1248px" Number="44" Height="28px" DataMember="D2.SrodkiTrwaleVAT" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1276px"	Text="Nabycie towarów i usług pozostałych" Height="28px" Width="301px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 1276px" Number="45" Height="28px" DataMember="D2.PozostaleNetto" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1276px" Number="46" Height="28px" DataMember="D2.PozostaleVAT" ValueStyle="Zl" Width="160px" />

<!-- D3 -->

<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 1304px" Text="D.3. PODATEK NALICZONY - DO ODLICZENIA (w zł)" Height="168px" Width="650px" FrameStyle="BigYellow"  />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1332px" Text="Korekta podatku naliczonego od nabycia środków trwałych" Height="28px" Width="461px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1332px" Number="47" Height="28px" DataMember="D3.SrodkiTrwale" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1360px" Text="Korekta podatku naliczonego od pozostałych nabyć" Height="28px" Width="463px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1360px" Number="48" Height="28px" DataMember="D3.Pozostale" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1388px" Text="Korekta podatku naliczonego, o której mowa w art. 89b ust. 1 ustawy" Height="28px" Width="463px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1388px" Number="49" Height="28px" DataMember="D3KasoweZleDlugi" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1416px" Text="Korekta podatku naliczonego, o której mowa w art. 89b ust. 4 ustawy" Height="28px" Width="463px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1416px" TopValueSet="6" Number="50" Height="28px" DataMember="D3KasoweZleDlugiZaplacone" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1444px" Text="Razem kwota podatku naliczonego do odliczenia" Height="28px" Width="460px" FrameStyle="SmallBoldYellow" FooterText="Należy wpisać sumę kwot z poz. 42, 44, 46, 47, 48, 49 i 50." />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1444px" Number="51" Height="28px" DataMember="D3.Razem" ValueStyle="Zl" Width="160px" />


<!-- SEKCJA E -->

<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 1472px" Text="&lt;span style=&quot;font-size:95%&quot;&gt;E. OBLICZENIE WYSOKOŚCI ZOBOWIĄZANIA PODATKOWEGO LUB KWOTY ZWROTU (w zł)&lt;/span&gt;" Height="273px" Width="651px" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader" />

<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1493px" Text="Kwota wydatkowana na zakup kas rejestrujących, do odliczenia w danym okresie rozliczeniowym" Height="28px" Width="459px" FrameStyle="SmallBoldYellow" FooterText="Kwota wykazana w poz. 52 nie może być wyższa od różnicy kwot z poz. 41 i 51.<br>Jeżeli różnica kwot pomiędzy poz. 41 i 51 jest mniejsza lub równa 0, wówczas należy wpisać 0." />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1493px" Number="52" Height="28px" DataMember="E.KasyOdliczenia" ValueStyle="Zl" Width="160px" />

<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1521px" Text="Kwota podatku objęta zaniechaniem poboru" Height="28px" Width="461px" FrameStyle="SmallBoldYellow" FooterText="Kwota ta nie może być wyższa niż różnica pomiędzy kwotą z poz. 41 a sumą kwot z poz. 51 i 52.<br>Jeżeli różnica kwot pomiędzy poz. 41 i 51 pomniejszona o kwotę z poz. 52 jest mniejsza od 0, wówczas należy wpisać 0." />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1521px" Number="53" Height="28px" DataMember="E.Zaniechanie" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1549px" Text="Kwota podatku podlegającego wpłacie do urzędu skarbowego" Height="28px" Width="461px" FrameStyle="SmallBoldYellow" FooterText="Jeżeli różnica kwot pomiędzy poz. 41 i 51 jest większa od 0, wówczas poz. 54 = poz. 41 - poz. 51 - poz. 52 - poz. 53,<br>w przeciwnym wypadku należy wpisać 0." />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1549px" Number="54" Height="28px" DataMember="E.DoZaplaty" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1577px" Text="Kwota wydatkowana na zakup kas rejestrujących, przysługująca do zwrotu w danym okresie rozliczeniowym" Height="28px" Width="462px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1577px" Number="55" Height="28px" DataMember="E.KasyZwrot" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1605px" Text="Nadwyżka podatku naliczonego nad należnym" Height="28px" Width="464px" FrameStyle="SmallBoldYellow" FooterText="Jeżeli różnica kwot pomiędzy poz. 51 i 41 jest większa lub równa 0, wówczas poz. 56 = poz. 51 - poz. 41 + poz. 55,<br>w przeciwnym wypadku należy wpisać 0." />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1605px" Number="56" Height="28px" DataMember="E.DoZwrotu" ValueStyle="Zl" Width="160px" />

<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1633px" HorizontalAlign="Right" Height="112px" Width="462px" FrameStyle="SmallBoldYellow" VerticalAlign="Middle" />
<ea:framelabel runat="server" style="LEFT: 56px;  TOP: 1633px; width: 433px" Text="Kwota do zwrotu na rachunek bankowy wskazany przez podatnika" Height="28px" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1633px" Number="57" Height="28px" DataMember="E.NaKonto" ValueStyle="Zl" Width="160px" />
<ea:framelabel runat="server" style="LEFT: 84px;  TOP: 1661px; width: 246px" Text="w tym kwota do zwrotu" Height="56px"	FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 1661px; width: 160px" Number="58" Text="na rachunek VAT" Height="28px" DataMember="E.NaKontoVAT" ValueStyle="Zl" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1661px; width: 160px" Number="59" Text="w terminie 25 dni (art. 87 ust. 6)" Height="28px" DataMember="E.NaKonto25" ValueStyle="Zl" />
<ea:framelabel runat="server" style="LEFT: 329px; TOP: 1689px; width: 160px" Number="60" Text="w terminie 60 dni" Height="28px" DataMember="E.NaKonto60" ValueStyle="Zl" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1689px; width: 160px" Number="61" Text="w terminie 180 dni" Height="28px" DataMember="E.NaKonto180" ValueStyle="Zl" />
<ea:framelabel runat="server" style="LEFT: 112px; TOP: 1717px; width: 378px" Text="Kwota do przeniesienia na następny okres rozliczeniowy" Height="28px" FrameStyle="SmallBoldYellow" FooterText="Od kwoty z poz. 56 należy odjąć kwotę z poz. 57" />
<ea:framelabel runat="server" style="LEFT: 490px; TOP: 1717px"	Number="62" Height="28px" DataMember="E.DoPrzeniesienia" ValueStyle="Zl" Width="160px" />

<!-- SEKCJA F -->

<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 1745px" Text="F. INFORMACJE DODATKOWE"  Height="84px" Width="651px" FrameStyle="BigYellowBold"  FrameBorderStyle="DoubleHeader" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1766px; height: 28px; width: 182px" Text="Podatnik wykonywał w okresie|rozliczeniowym czynności, o których|mowa w <.Normal>(zaznaczyć właściwe kwadraty):<./>" FrameStyle="SmallBoldYellow" />
<ea:framelabel runat="server" style="LEFT: 210px; TOP: 1766px; height: 28px; width: 98px" Number="63" />
<ea:framelabel runat="server" style="LEFT: 308px; TOP: 1766px; height: 28px; width: 133px" Number="64" />
<ea:framelabel runat="server" style="LEFT: 441px; TOP: 1766px; height: 28px; width: 105px" Number="65" />
<ea:framelabel runat="server" style="LEFT: 546px; TOP: 1766px; height: 28px; width: 105px" Number="66" />
<ea:checklabel runat="server" style="LEFT: 220px; TOP: 1775px" Text="art. 119 ustawy" Height="3px" DataMember="F.Czynnosc1" />
<ea:checklabel runat="server" style="LEFT: 318px; TOP: 1775px" Text="art. 120 ust. 4 lub 5 ustawy" Height="3px" DataMember="F.Czynnosc2" />
<ea:checklabel runat="server" style="LEFT: 451px; TOP: 1775px" Text="art. 122 ustawy" Height="3px" DataMember="F.Czynnosc3" />
<ea:checklabel runat="server" style="LEFT: 556px; TOP: 1775px" Text="art. 136 ustawy" Height="3px" DataMember="F.Czynnosc4" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 1794px; HEIGHT: 35px; WIDTH: 413px" Text="Podatnik korzysta z obniżenia zobowiązania podatkowego, o którym mowa|w art. 108d ustawy" Number="67" />
<ea:framelabel runat="server" style="LEFT: 441px; TOP: 1794px; HEIGHT: 35px; WIDTH: 210px" Text="&lt;span style=&quot;font-size:95%&quot;&gt;Podatnik wnioskuje o zwrot podatku na rachunek VAT <.Normal>(wykazany w poz. 58)<./>&lt;/span&gt;" Number="68" />
<ea:checklabel runat="server" style="LEFT: 220px; TOP: 1810px" Text="tak" Height="3px" DataMember="F.Obnizenie108D" />
<ea:checklabel runat="server" style="LEFT: 546px; TOP: 1810px" Text="tak" Height="3px" DataMember="F.ZwrotNaRachunekVAT" />



<ea:deklaracjafooter runat="server" id="DeklaracjaFooter2" style="LEFT: 0px; TOP: 1866px" Height="15px" Width="56px" Version="18" PageTotal="3" PageNumber="2"  Symbol="VAT-7" />

<!-- PAGE 3 -->

<ea:deklaracjaheader runat="server" id="DeklaracjaHeader3" style="LEFT: 0px; TOP: 1940px" StylNagłówka="WylacznieElektronicznie" />



<!-- SEKCJA G -->

<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 1975px" Text="G. INFORMACJA O ZAŁĄCZNIKACH|<.FOOTER>Do niniejszej deklaracji dołączono (zaznaczyć właściwy kwadrat):<./>" Height="91px" Width="651px" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 2010px" Number="69" Text="Wniosek o zwrot podatku (VAT-ZZ)" Height="28px" Width="315px" />
<ea:checklabel runat="server" style="LEFT: 112px; TOP: 2019px" Number="1" Text="tak" Height="12px" DataMember="G.Zwrot" Width="20px" NumberAlignLeft="False" />
<ea:checklabel runat="server" style="LEFT: 170px; TOP: 2019px" Number="2" Text="nie" Height="12px" DataMember="G.Zwrot" Width="20px" ComparedValue="False" NumberAlignLeft="False" />
<ea:framelabel runat="server" style="LEFT: 343px; TOP: 2010px" Number="70" Text="Wniosek o przyspieszenie terminu zwrotu podatku (VAT-ZT)" Height="28px" Width="306px" />
<ea:checklabel runat="server" style="LEFT: 441px; TOP: 2019px" Number="1" Text="tak" Height="12px" DataMember="G.Przyspieszenie" Width="20px" NumberAlignLeft="False" />
<ea:checklabel runat="server" style="LEFT: 500px; TOP: 2019px" Number="2" Text="nie" Height="12px" DataMember="G.Przyspieszenie" Width="20px" ComparedValue="False" NumberAlignLeft="False" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 2038px" Number="71" Text="Zawiadomienie o skorygowaniu podstawy opodatkowania oraz kwoty podatku należnego (VAT-ZD)" Height="28px" Width="623px" />
<ea:checklabel runat="server" style="LEFT: 243px; TOP: 2047px; right: 1212px" Number="1" Text="tak" Height="12px" DataMember="DOD.G_ZawiadomienieKorektaNaleznego" Width="20px" NumberAlignLeft="False" />
<ea:checklabel runat="server" style="LEFT: 320px; TOP: 2047px; right: 1155px" Number="2" Text="nie" Height="12px" DataMember="DOD.G_ZawiadomienieKorektaNaleznego" Width="20px" ComparedValue="False" NumberAlignLeft="False" />

<!-- SEKCJA H -->

<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 2066px" Text="H. DANE KONTAKTOWE PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA" Height="77px" Width="651px" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 2087px; right: 715px" Number="72" Text="Imię" Height="28px" DataMember="H.Imię" Width="196px" />
<ea:framelabel runat="server" style="LEFT: 224px; TOP: 2087px" Number="73" Text="Nazwisko" Height="28px" DataMember="H.Nazwisko" Width="197px" />
<ea:framelabel runat="server" style="LEFT: 420px; TOP: 2087px" Number="74" Text="Adres e-mail" Height="56px" DataMember="H.Email" Width="232px" />
<ea:framelabel runat="server" style="LEFT: 28px;  TOP: 2115px" Number="75" Text="Telefon kontaktowy" Height="28px" DataMember="H.Telefon" Width="196px" />
<ea:framelabel runat="server" style="LEFT: 224px; TOP: 2115px" Number="76" Text="Data wypełnienia" Height="28px" DataMember="H.Data" ValueStyle="Date" Width="197px" />

<!-- INFORMACJE -->

<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 2185px; height: 14px; width: 653px" Text="1) Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2018 r. poz. 800, z późn. zm.)." FrameStyle="Small" FrameBorderStyle="None" />
<ea:framelabel runat="server" style="LEFT: 0px;   TOP: 2205px; height: 63px; width: 653px" Text="&lt;B&gt;&lt;CENTER&gt;Pouczenia&lt;/CENTER&gt;&lt;/B&gt;&lt;BR&gt;W przypadku niewpłacenia w obowiązującym terminie kwoty z poz. 54 lub wpłacenia jej w niepełnej wysokości, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2017 r. poz. 1201, z późn. zm.).&lt;br&gt;&lt;br&gt;Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym." FrameStyle="Small" FrameBorderStyle="None" />

<ea:deklaracjafooter runat="server" id="DeklaracjaFooter3" style="LEFT: 552px; TOP: 2822px" Version="18" PageTotal="3" PageNumber="3" Symbol="VAT-7" />


</form>
    </body>
</HTML>





