﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="65001" %>
<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Core" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>ZAP 3(3)</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">

        public class Params : ContextBase {
            public readonly PracHistoria historia;
            public Params(Context context) : base(context) {
                historia = (PracHistoria)context[typeof(PracHistoria)];
                foreach (RachunekBankowyPracownika rbp in historia.Pracownik.Rachunki)
                    if (!rbp.Blokada) {
                        rachunek = rbp;
                        break;
                    }
            }
            RachunekBankowyPracownika rachunek;
            [Caption("Rachunek bankowy")]
            [Priority(50)]
            public RachunekBankowyPracownika Rachunek {
                get { return rachunek; }
                set {
                    rachunek = value;
                    if (rachunek != null)
                        rezygnacja = false;
                    OnChanged(EventArgs.Empty);
                }
            }
            public LookupInfo.Item GetListRachunek() {
                return Soneta.Kasa.RachBankPodmiot.RachunkiPodmiotuLookup(historia.Pracownik);
            }
            bool rezygnacja;
            [Caption("Rezygnacja z rachunku")]
            [Priority(60)]
            public bool Rezygnacja {
                get { return rezygnacja; }
                set {
                    rezygnacja = value;
                    OnChanged(EventArgs.Empty);
                }
            }
            public bool IsReadOnlyRezygnacja() {
                return rachunek != null;
            }
            bool rezygnacjaMail;
            [Caption("Rezygnacja z mail")]
            [Priority(70)]
            public bool RezygnacjaMail {
                get { return rezygnacjaMail; }
                set {
                    rezygnacjaMail = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }
		Params info;
        [Context]
        public Params Info {
            set { info = value; }
        }
        void OnContextLoad(object sender, EventArgs e) {
            if (dc.OverPrint) {
                dc.LeftMargin = 6;
                dc.TopMargin = 6;
                dc.PageZoom = "114%";
            }
            PracHistoria prev = (PracHistoria)info.historia.Pracownik.Historia.GetPrev(info.historia);
            if (info.Rezygnacja)
                rachunekRezygnacja.EditValue = true;
            else if (info.Rachunek != null) {
                Soneta.Kasa.RachunekBankowy rb = info.Rachunek.Rachunek;
                if (rb.Bank != null) {
                    if (rb.Bank.Adres.Kraj != "" && rb.Bank.Adres.Kraj.ToLower() != "polska")
                        rachunekKraj.EditValue = rb.Bank.Adres.Kraj;
                    rachunekNazwaBanku.EditValue = rb.Bank.Nazwa;
                }
                if (info.Rachunek.Nazwa1 != "")
                    rachunekPosiadacz.EditValue = info.Rachunek.Nazwa1 + ", " + info.Rachunek.Nazwa2;
                else
                    rachunekPosiadacz.EditValue = info.historia.Pracownik.ImięNazwisko + ", " + info.historia.Adres.Linia1 + ", " + info.historia.Adres.Linia2;
                rachunekNumer.EditValue = "Numer IBAN: " + rb.Numer + (!string.IsNullOrEmpty(rb.SWIFT) ? ", Kod SWIFT: " + rb.SWIFT : "");
            }
            if (info.historia.Podatki.NaPITAdresZameldowania ||
                info.historia.AdresZamieszkania.Wojewodztwo.ToString() == "nieokreślone") {
                AdresKraj.EditValue = info.historia.AdresZameldowania.Kraj;
                AdresWojewodztwo.EditValue = info.historia.AdresZameldowania.Wojewodztwo;
                AdresPowiat.EditValue = info.historia.AdresZameldowania.Powiat;
                AdresGmina.EditValue = info.historia.AdresZameldowania.Gmina;
                AdresUlica.EditValue = info.historia.AdresZameldowania.Ulica;
                AdresNrDomu.EditValue = info.historia.AdresZameldowania.NrDomu;
                AdresNrLokalu.EditValue = info.historia.AdresZameldowania.NrLokalu;
                AdresMiejscowosc.EditValue = info.historia.AdresZameldowania.Miejscowosc;
                AdresKodPocztowy.EditValue = info.historia.AdresZameldowania.KodPocztowy;
                AdresPoczta.EditValue = info.historia.AdresZameldowania.Poczta;
                AdresTelefon.EditValue = info.historia.AdresZameldowania.Telefon;
                AdresFax.EditValue = info.historia.AdresZameldowania.Faks;
            }
            else {
                AdresKraj.EditValue = info.historia.AdresZamieszkania.Kraj;
                AdresWojewodztwo.EditValue = info.historia.AdresZamieszkania.Wojewodztwo;
                AdresPowiat.EditValue = info.historia.AdresZamieszkania.Powiat;
                AdresGmina.EditValue = info.historia.AdresZamieszkania.Gmina;
                AdresUlica.EditValue = info.historia.AdresZamieszkania.Ulica;
                AdresNrDomu.EditValue = info.historia.AdresZamieszkania.NrDomu;
                AdresNrLokalu.EditValue = info.historia.AdresZamieszkania.NrLokalu;
                AdresMiejscowosc.EditValue = info.historia.AdresZamieszkania.Miejscowosc;
                AdresKodPocztowy.EditValue = info.historia.AdresZamieszkania.KodPocztowy;
                AdresPoczta.EditValue = info.historia.AdresZamieszkania.Poczta;
                AdresTelefon.EditValue = info.historia.AdresZamieszkania.Telefon;
                AdresFax.EditValue = info.historia.AdresZamieszkania.Faks;
            }
            if (info.historia.AdresDoKorespondencji.Ulica.Length > 0 ||
                info.historia.AdresDoKorespondencji.NrDomu.Length > 0 ||
                info.historia.AdresDoKorespondencji.NrLokalu.Length > 0 ||
                info.historia.AdresDoKorespondencji.Miejscowosc.Length > 0) {
                AdresKrajK.EditValue = info.historia.AdresDoKorespondencji.Kraj;
                AdresWojewodztwoK.EditValue = info.historia.AdresDoKorespondencji.Wojewodztwo;
                AdresPowiatK.EditValue = info.historia.AdresDoKorespondencji.Powiat;
                AdresGminaK.EditValue = info.historia.AdresDoKorespondencji.Gmina;
                AdresUlicaK.EditValue = info.historia.AdresDoKorespondencji.Ulica;
                AdresNrDomuK.EditValue = info.historia.AdresDoKorespondencji.NrDomu;
                AdresNrLokaluK.EditValue = info.historia.AdresDoKorespondencji.NrLokalu;
                AdresMiejscowoscK.EditValue = info.historia.AdresDoKorespondencji.Miejscowosc;
                AdresKodPocztowyK.EditValue = info.historia.AdresDoKorespondencji.KodPocztowy;
                AdresPocztaK.EditValue = info.historia.AdresDoKorespondencji.Poczta;
            }
            KontaktEMAIL.EditValue = info.historia.Kontakt.EMAIL;
            if (info.RezygnacjaMail)
                checkAdresElektronicznyRezyg.EditValue = true;
            else
                AdresElektroniczny.EditValue = info.historia.Kontakt.EMAIL;
        }
        
        static void Msg(object value) {
        }
		    
    </script>
	</HEAD>
	<body leftMargin="0" rightMargin="0">
		<form id="ZAP_3" method="post" runat="server">
			<ea:deklaracjaheader id="DeklaracjaHeader1" style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 0px"
				runat="server" Width="630px" StylNagłówka="WypałniaSkładającyCRP"></ea:deklaracjaheader>
<ea:framelabel id="FrameLabel21" style="Z-INDEX: 101; LEFT: 0px; POSITION: absolute; TOP: 21px"
				runat="server" Width="273px" ValueStyle="nip_w" DataMember="PESEL" Height="28px" 
                Text="1. Identyfikator podatkowy numer PESEL"></ea:framelabel>
<ea:framelabel id="FrameLabel22" style="Z-INDEX: 102; LEFT: 273px; POSITION: absolute; TOP: 21px"
				runat="server" Width="119px" Height="28px" Text="Nr dokumentu" FrameStyle="SmallBoldGray" Number="2"></ea:framelabel>
<ea:framelabel id="FrameLabel23" style="Z-INDEX: 103; LEFT: 392px; POSITION: absolute; TOP: 21px"
				runat="server" Width="77px" Height="30px" Text="Status" FrameStyle="SmallBoldGray" Number="3"></ea:framelabel>
<ea:framelabel id="FrameLabel34" style="Z-INDEX: 104; LEFT: 65px; POSITION: absolute; TOP: 62px; height: 21px;"
				runat="server" Width="565px" 
                Text="ZGŁOSZENIE AKTUALIZACYJNE OSOBY FIZYCZNEJ BĘDĄCEJ PODATNIKIEM" 
                FrameStyle="BigBold" FrameBorderStyle="None" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="labelPIT" 
                style="Z-INDEX: 105; LEFT: 5px; POSITION: absolute; TOP: 62px; width: 71px; right: 821px;" 
                runat="server" Height="21px" FrameStyle="BigBold" FrameBorderStyle="None" 
                Text="ZAP-3"></ea:framelabel>
<ea:framelabel id="FrameLabel24" style="Z-INDEX: 106; LEFT: 0px; POSITION: absolute; TOP: 86px; height: 105px;"
				runat="server" Width="630px" FrameStyle="SmallBoldYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel27" style="Z-INDEX: 107; LEFT: 7px; POSITION: absolute; TOP: 88px; right: 799px;"
				runat="server" Width="600px" Height="80px"
                Text="&lt;b&gt;Formularz przeznaczony dla osoby fizycznej, spełniającej łącznie poniższe kryteria:&lt;br&gt;
                - jest objęta rejestrem PESEL,&lt;br&gt;
                - nie prowadzi działalności gospodarczej,&lt;br&gt;
                - nie jest zarejestrowanym podatnikiem podatku od towarów i usług,&lt;br&gt;
                - nie jest płatnikiem podatków,&lt;br&gt;
                - nie jest płatnikiem składek na ubezpieczenia społeczne oraz ubezpieczenia zdrowotne.&lt;br&gt;
                &lt;/b&gt;
                Formularz służy do zgłoszenia: aktualnego adresu miejsca zamieszkania (część B.2),
                danych kontaktowych (część B.3) oraz informacji dotyczących rachunku osobistego (część B.4)."
                FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel30" style="Z-INDEX: 108; LEFT: 0px; POSITION: absolute; TOP: 170px"
				runat="server" Width="630px" Height="20px"
                Text="Podstawa prawna: Ustawa z dnia 13 października 1995 r. o zasadach ewidencji i identyfikacji podatników i płatników
                (Dz. U. z 2017 r.&lt;br&gt; poz. 869) - zgodnie z art.9 ust 1d." 
                FrameStyle="SmallBoldGray"></ea:framelabel>
<ea:framelabel id="FrameLabel17" style="Z-INDEX: 109; LEFT: 0px; POSITION: absolute; TOP: 194px; height: 46px;"
				runat="server" Width="630px" Text="A. MIEJSCE ZŁOŻENIA ZGŁOSZENIA" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="p6" style="Z-INDEX: 110; LEFT: 28px; POSITION: absolute; TOP: 215px; width: 601px;"
				runat="server" Height="30px" 
                Text="Naczelnik urzędu skarbowego, do którego jest adresowane zgłoszenie" Number="4" 
                DataMember="Podatki.UrzadSkarbowy.Nazwa"></ea:framelabel>
<ea:framelabel id="FrameLabel1" style="Z-INDEX: 111; LEFT: 0px; POSITION: absolute; TOP: 246px"
				runat="server" Width="630px" Height="19px" Text="B. DANE SKŁADAJĄCEGO" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel2" style="Z-INDEX: 112; LEFT: 0px; POSITION: absolute; TOP: 264px; height: 50px;"
				runat="server" Width="630px" Text="B.1. DANE IDENTYFIKACYJNE" FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel4" style="Z-INDEX: 113; LEFT: 28px; POSITION: absolute; TOP: 285px; height: 30px; width: 301px;"
				runat="server" DataMember="Nazwisko" Text="Nazwisko" Number="5"></ea:framelabel>
<ea:framelabel id="FrameLabel6" style="Z-INDEX: 114; LEFT: 329px; POSITION: absolute; TOP: 285px; right: 751px; width: 301px;"
				runat="server" DataMember="Imie" Height="28px" Text="Pierwsze imię" Number="6"></ea:framelabel>
<ea:framelabel id="Framelabel101" style="Z-INDEX: 115; LEFT: 0px; POSITION: absolute; TOP: 313px; height: 105px;"
				runat="server" Width="630px" Text="B.2. ADRES MIEJSCA ZAMIESZKANIA" 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 116; LEFT: 28px; POSITION: absolute; TOP: 334px"
				runat="server" Width="140px" ID="AdresKraj" Height="28px" Text="Kraj" 
                Number="7" CssClass="style1"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 117; LEFT: 168px; POSITION: absolute; TOP: 334px"
				runat="server" Width="266px" ID="AdresWojewodztwo" Height="28px" 
                Text="Województwo" Number="8"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 118; LEFT: 434px; POSITION: absolute; TOP: 334px"
				runat="server" Width="196px" ID="AdresPowiat" Height="28px" Text="Powiat" 
                Number="9"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 119; LEFT: 28px; POSITION: absolute; TOP: 362px"
				runat="server" Width="161px" ID="AdresGmina" Height="28px" Text="Gmina" 
                Number="10"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 120; LEFT: 189px; POSITION: absolute; TOP: 362px"
				runat="server" Width="301px" ID="AdresUlica" Height="28px" Text="Ulica" 
                Number="11"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 121; LEFT: 490px; POSITION: absolute; TOP: 362px"
				runat="server" Width="70px" ID="AdresNrDomu" Height="28px" Text="Nr domu" 
                Number="12"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 122; LEFT: 560px; POSITION: absolute; TOP: 362px"
				runat="server" Width="70px" ID="AdresNrLokalu" Height="28px" Text="Nr lokalu" 
                Number="13"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 123; LEFT: 28px; POSITION: absolute; TOP: 390px; right: 639px;"
				runat="server" Width="252px" ID="AdresMiejscowosc" Height="28px" Text="Miejscowość" 
                Number="14"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 124; LEFT: 280px; POSITION: absolute; TOP: 390px; "
				runat="server" Width="105px" ValueStyle="PostalCode" ID="AdresKodPocztowy" 
                Height="28px" Text="Kod pocztowy" Number="15" CssClass="style1"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 125; LEFT: 385px; POSITION: absolute; TOP: 390px; height: 30px;"
				runat="server" Width="245px" ID="AdresPoczta" Text="Poczta" Number="16"></ea:framelabel>
<ea:framelabel id="Framelabel7" style="Z-INDEX: 126; LEFT: 0px; POSITION: absolute; TOP: 418px; height: 90px;"
				runat="server" Width="630px" Text="B.3. DANE KONTAKTOWE&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Podanie informacji w części B.3. nie jest obowiązkowe. Wpisane niżej dane w części B.3.1. i B.3.2. aktualizują poprzedni stan danych." 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 137; LEFT: 28px; POSITION: absolute; TOP: 453px; height: 30px; width: 601px;"
				runat="server" ID="AdresTelefon" Text="Telefon" Number="17"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 137; LEFT: 28px; POSITION: absolute; TOP: 481px; height: 30px; width: 301px;"
				runat="server" ID="AdresFax" Text="Fax" Number="18"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 138; LEFT: 329px; POSITION: absolute; TOP: 481px; right: 751px; width: 301px;"
				runat="server" ID="KontaktEMAIL" Height="28px" Text="E-mail" Number="19"></ea:framelabel>
<ea:framelabel id="Framelabel3" style="Z-INDEX: 126; LEFT: 0px; POSITION: absolute; TOP: 509px; height: 100px;"
				runat="server" Width="630px" Text="B.3.1. ADRES ELEKTRONICZNY&lt;/font&gt;&lt;.Footer&gt; - adres w systemie teleinformatycznym. Do doręczeń pism za pomocą środków komunikacji
                elektronicznej może mieć zastosowanie adres elektroniczny na portalu podatkowym lub w systemie ePUAP, w przypadku, jeżeli wniesiono
                o zastosowanie takiego sposobu doręczania albo wyrażono na to zgodę (art. 144a § 1 pkt 2 lub art. 144a § 1 pkt 3 w związku z art. 3e § 1
                ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz. U. z 2017 r. poz. 201, z późn. zm.)). Adres elektroniczny w systemie ePUAP
                może mieć również zastosowanie do doręczeń pism w analogicznych przypadkach określonych w art. 39(1) § 1 pkt 2 lub art. 39(1) § 1 pkt 3
                w związku z art. 39(1) § 1a ustawy z dnia 14 czerwca 1960 r. - Kodeks postępowania administracyjnego (Dz. U. z 2017 r. poz. 1257).
                W poz. 21 można zaznaczyć rezygnację ze wskazania adresu elektronicznego." 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 137; LEFT: 28px; POSITION: absolute; TOP: 579px; height: 30px; width: 401px;"
				runat="server" ID="AdresElektroniczny" Text="Adres elektroniczny" Number="20"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 138; LEFT: 427px; POSITION: absolute; TOP: 579px; right: 751px; width: 201px;"
				runat="server" ID="AdresElektronicznyRezyg" Height="28px" Text="Rezygnacja z adresu elektronicznego" Number="21"></ea:framelabel>
<ea:checklabel id="checkAdresElektronicznyRezyg" style="Z-INDEX: 145; LEFT: 517px; POSITION: absolute; TOP: 588px; right: 382px;"
				runat="server" Width="35px" Height="14px"></ea:checklabel>
<ea:framelabel id="Framelabel5" style="Z-INDEX: 126; LEFT: 0px; POSITION: absolute; TOP: 607px; height: 120px;"
				runat="server" Width="630px" Text="B.3.2. ADRES DO KORESPONDENCJI&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Należy wypełnić tylko wówczas, gdy adres do korespondencji
                jest inny niż w części B.2." 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 127; LEFT: 28px; POSITION: absolute; TOP: 642px"
				runat="server" Width="140px" ID="AdresKrajK" Height="28px" Text="Kraj" 
                Number="22" CssClass="style1"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 128; LEFT: 168px; POSITION: absolute; TOP: 642px"
				runat="server" Width="266px" ID="AdresWojewodztwoK" Height="28px" 
                Text="Województwo" Number="23"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 129; LEFT: 434px; POSITION: absolute; TOP: 642px"
				runat="server" Width="196px" ID="AdresPowiatK" Height="28px" Text="Powiat" 
                Number="24"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 130; LEFT: 28px; POSITION: absolute; TOP: 670px"
				runat="server" Width="161px" ID="AdresGminaK" Height="28px" Text="Gmina" 
                Number="25"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 131; LEFT: 189px; POSITION: absolute; TOP: 670px"
				runat="server" Width="301px" ID="AdresUlicaK" Height="28px" Text="Ulica" 
                Number="26"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 132; LEFT: 490px; POSITION: absolute; TOP: 670px"
				runat="server" Width="70px" ID="AdresNrDomuK" Height="28px" Text="Nr domu" 
                Number="27"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 133; LEFT: 560px; POSITION: absolute; TOP: 670px"
				runat="server" Width="70px" ID="AdresNrLokaluK" Height="28px" Text="Nr lokalu" 
                Number="28"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 134; LEFT: 28px; POSITION: absolute; TOP: 698px; right: 639px;"
				runat="server" Width="252px" ID="AdresMiejscowoscK" Height="28px" Text="Miejscowość" 
                Number="29"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 135; LEFT: 280px; POSITION: absolute; TOP: 698px; "
				runat="server" Width="105px" ValueStyle="PostalCode" ID="AdresKodPocztowyK" 
                Height="28px" Text="Kod pocztowy" Number="30" CssClass="style1"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 136; LEFT: 385px; POSITION: absolute; TOP: 698px; height: 30px;"
				runat="server" Width="245px" ID="AdresPocztaK" Text="Poczta" Number="31"></ea:framelabel>
<ea:deklaracjafooter id="footer1" 
                style="Z-INDEX: 152; LEFT: 489px; POSITION: absolute; TOP: 910px" runat="server"
				TitleWidth="106" Symbol="ZAP-3" PageNumber="1" PageTotal="2" Version="4"></ea:deklaracjafooter>
<ea:deklaracjaheader id="DeklaracjaHeader2" style="Z-INDEX: 153; LEFT: 0px; POSITION: absolute; TOP: 980px"
				runat="server" Width="630px" StylNagłówka="WypałniaSkładającyCRP"></ea:deklaracjaheader>
<ea:framelabel id="FrameLabel162" style="Z-INDEX: 139; LEFT: 0px; POSITION: absolute; TOP: 1003px; height: 146px; right: 289px;"
				runat="server" Width="630px" Text="B.4. RACHUNEK OSOBISTY - DO ZWROTU PODATKU LUB NADPŁATY&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Podanie informacji o rachunku (poz. 32-35) nie jest obowiązkowe, jeżeli składający nie wybiera tej formy zwrotu podatku lub nadpłaty. Na wskazany rachunek będą dokonywane ewentualne zwroty nadpłaty lub podatku. Można podać jedynie taki rachunek, którego właścicielem lub współwłaścicielem jest składający. Wpisane niżej dane dotyczące rachunku aktualizują poprzedni stan danych.
                Zaznaczenie kwadratu w poz.36 oznacza rezygnację przez składającego 
                z otrzymywania ewentualnego zwrotu nadpłaty lub podatku na rachunek osobisty (również z powodu likwidacji rachunku). Kraj siedziby banku (oddziału) (poz.32) podać, gdy rachunek jest prowadzony za granicą."
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="rachunekKraj" style="Z-INDEX: 140; LEFT: 28px; POSITION: absolute; TOP: 1066px; right: 632px; width: 258px;"
				runat="server" Height="28px" Text="Kraj siedziby banku (oddziału)" 
                Number="32"></ea:framelabel>
<ea:framelabel id="rachunekNazwaBanku" style="Z-INDEX: 141; LEFT: 287px; POSITION: absolute; TOP: 1066px; right: 534px; width: 343px;"
				runat="server" 
                Height="28px" Text="Pełna nazwa banku (oddziału) / SKOK" Number="33"></ea:framelabel>
<ea:framelabel id="rachunekPosiadacz" style="Z-INDEX: 142; LEFT: 28px; POSITION: absolute; TOP: 1094px; width: 599px;"
				runat="server" Height="28px" Text="Posiadacz rachunku" 
                Number="34"></ea:framelabel>
<ea:framelabel id="rachunekNumer" style="Z-INDEX: 143; LEFT: 28px; POSITION: absolute; TOP: 1122px; width: 530px;"
				runat="server" Height="28px" Text="Pełny numer rachunku (w przypadku rachunku zagranicznego numer rachunku powinien zawierać kod SWIFT)" 
                Number="35"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 560px; POSITION: absolute; TOP: 1122px"
				runat="server" Width="70px" Height="28px" Text="Rezygnacja" 
                Number="36"></ea:framelabel>
<ea:checklabel id="rachunekRezygnacja" style="Z-INDEX: 145; LEFT: 578px; POSITION: absolute; TOP: 1132px; right: 382px;"
				runat="server" Width="35px" Height="14px"></ea:checklabel>
<ea:framelabel id="Framelabel121" style="Z-INDEX: 146; LEFT: 0px; POSITION: absolute; TOP: 1150px; width: 630px; height: 156px;"
				runat="server" 
                Text="C. &lt;font size=2&gt;PODPIS SKŁADAJĄCEGO/DANE I PODPIS OSOBY REPREZENTUJĄCEJ SKŁADAJĄCEGO&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Osobą reprezentującą składającego może być jedynie osoba uprawniona do reprezentowania, np. opiekun prawny, kurator, pełnomocnik określony w pełnomocnictwie. Poz. 37-40 wypełnić jedynie w przypadku osoby reprezentującej składającego.&lt;./&gt;" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="Framelabel177" style="Z-INDEX: 147; LEFT: 28px; POSITION: absolute; TOP: 1192px; width: 301px;"
				runat="server" Height="28px" Text="Imię" Number="37"></ea:framelabel>
<ea:framelabel id="Framelabel181" style="Z-INDEX: 148; LEFT: 329px; POSITION: absolute; TOP: 1192px; width: 301px; right: 485px;"
				runat="server" Height="28px" Text="Nazwisko" Number="38"></ea:framelabel>
<ea:framelabel id="Framelabel178" style="Z-INDEX: 149; LEFT: 28px; POSITION: absolute; TOP: 1220px; width: 600px;"
				runat="server" Height="28px" Text="Identyfikator podatkowy NIP / numer PESEL&lt;.Normal&gt;(niepotrzebne skreślić)&lt;./&gt;" Number="39"></ea:framelabel>
<ea:framelabel id="Framelabel166" style="Z-INDEX: 150; LEFT: 28px; POSITION: absolute; TOP: 1248px; right: 632px; width: 599px;"
				runat="server" Height="28px" Text="Adres do korespondencji" 
                Number="40"></ea:framelabel>
<ea:framelabel id="Framelabel180" style="Z-INDEX: 151; LEFT: 28px; POSITION: absolute; TOP: 1276px; width: 225px; right: 619px;"
				runat="server" Height="28px" Text="Data wypełnienia zgłoszenia" Number="41" 
                ValueStyle="Date"></ea:framelabel>
<ea:framelabel id="Framelabel137" style="Z-INDEX: 152; LEFT: 252px; POSITION: absolute; TOP: 1276px; width: 378px; right: 485px;"
				runat="server" Height="28px" 
                Text="Podpis składającego/osoby reprezentującej składającego&lt;.Normal&gt;(niepotrzebne skreślić)&lt;./&gt;" 
                Number="42"></ea:framelabel>
<ea:framelabel id="FrameLabel127" style="Z-INDEX: 153; LEFT: 0px; POSITION: absolute; TOP: 1301px; height: 162px;"
				runat="server" Width="630px" Text="D. ADNOTACJE URZĘDU SKARBOWEGO (część nie jest wypełniana w przypadku zgłoszenia w postaci elektronicznej)"
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel130" style="Z-INDEX: 154; LEFT: 28px; POSITION: absolute; TOP: 1329px; height: 79px;"
				runat="server" Width="602px" Text="Uwagi urzędu skarbowego" 
                FrameStyle="SmallBoldGray" Number="43"></ea:framelabel>
<ea:framelabel id="FrameLabel128" style="Z-INDEX: 155; LEFT: 28px; POSITION: absolute; TOP: 1406px; right: 511px; height: 26px;"
				runat="server" Width="301px" 
                Text="Identyfikator przyjmującego formularz" FrameStyle="SmallBoldGray" 
                Number="44"></ea:framelabel>
<ea:framelabel id="FrameLabel129" style="Z-INDEX: 156; LEFT: 329px; POSITION: absolute; TOP: 1406px; height: 31px;"
				runat="server" Width="301px" Text="Podpis przyjmującego formularz" 
                FrameStyle="SmallBoldGray" Number="45"></ea:framelabel>
<ea:framelabel id="FrameLabel171" style="Z-INDEX: 157; LEFT: 28px; POSITION: absolute; TOP: 1434px; right: 602px; width: 213px; height: 29px;"
				runat="server" Text="Data rejestracji w systemie" 
                FrameStyle="SmallBoldGray" Number="46" ValueStyle="Date"></ea:framelabel>
<ea:framelabel id="FrameLabel172" style="Z-INDEX: 158; LEFT: 238px; POSITION: absolute; TOP: 1434px; right: 420px; width: 179px; height: 27px;"
				runat="server" Text="Identyfikator rejestrującego formularz w systemie" 
                FrameStyle="SmallBoldGray" Number="47"></ea:framelabel>
<ea:framelabel id="FrameLabel173" style="Z-INDEX: 159; LEFT: 420px; POSITION: absolute; TOP: 1434px; right: 590px; width: 210px; height: 27px;"
				runat="server" Text="Podpis rejestrującego formularz w systemie" 
                FrameStyle="SmallBoldGray" Number="48"></ea:framelabel>
<ea:deklaracjafooter id="footer2" 
                style="Z-INDEX: 160; LEFT: 0px; POSITION: absolute; TOP: 1900px" runat="server"
				TitleWidth="106" Symbol="ZAP-3" PageNumber="2" PageTotal="2" Version="4"></ea:deklaracjafooter>
<ea:datacontext id="dc" style="Z-INDEX: 161; LEFT: 189px; POSITION: absolute; TOP: 1900px" runat="server"
				TypeName="Soneta.Kadry.PracHistoria,Soneta.KadryPlace" oncontextload="OnContextLoad" 
                LeftMargin="15" PageHeight="977px" PageZoom="106%"></ea:datacontext>
</form>
	</body>
</HTML>
