﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<script runat="server">
    bool ift1R;
    
    void OnContextLoad(Object sender, EventArgs args) {
        Soneta.Deklaracje.PIT.IFT1 dek = (Soneta.Deklaracje.PIT.IFT1)dc[typeof(Soneta.Deklaracje.PIT.IFT1)];
        if (dek is Soneta.Deklaracje.PIT.IFT1R_15) {
            ift1R = true;
            ORD_ZU.Visible = ((Soneta.Deklaracje.PIT.IFT1R_15)dek).TreśćUzasadnienia != "";
        }
        else if (dek is Soneta.Deklaracje.PIT.IFT1_15) {
            ift1R = false;
            ORD_ZU.Visible = ((Soneta.Deklaracje.PIT.IFT1_15)dek).TreśćUzasadnienia != "";
        }
        else
            throw new RowException(dek, "Wzór tylko dla deklaracji IFT1(15) oraz IFT1R(15).");

        bool osobaFizyczna = (bool)dek.Bloki["B1"]["OsobaFiz"];
        string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], osobaFizyczna);

        if (osobaFizyczna) {
            OsobaNieFizyczna.Visible = false;
            if (nazwa.Length > 0)
                Nazwisko.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                ImiePierwsze.EditValue = nazwa[1].Trim();
            if (nazwa.Length > 2)
                DataUrodzenia.EditValue = nazwa[2].Trim();
        }
        else {
            OsobaFizyczna.Visible = false;
            if (nazwa.Length > 0)
                NazwaPelna.EditValue = nazwa[0].Trim();
            //if (nazwa.Length > 1)
            //    REGON.EditValue = nazwa[1].Trim();
        }

        string kodKraju = ((string)dek.Bloki["X"]["KodKrajuPl"]).ToUpper();
        if (kodKraju == "" || kodKraju == "PL")
            AdresZagrPl.Visible = false;
        else
            AdresPolPl.Visible = false;
                
        DataZłożenia.Visible = !ift1R;

        InitBrakDanych(dek);        
    }

    void InitBrakDanych(Deklaracja dek) {
        string brakDanych = dek.Module.Config.PIT.Ogólne.UzupełnienieAdresuNaEDeklaracji;
        if (brakDanych != "") {
            AddMap(pit_miejscZagr, "", brakDanych, 56);
            AddMap(pit_miejscUrodz, "", brakDanych, 56);
        }
    }

    static void AddMap(XmlDataLabel label, string key, string value, int maxLen) {
        label.ValuesMap.Add(new ValuesPair(key, Soneta.Core.Tools.Left(value, maxLen)));
    }
    
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.IFT1,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<%if (ift1R) { %>
<Deklaracja 
    xsi:schemaLocation="http://crd.gov.pl/wzor/2019/12/19/8976/ http://crd.gov.pl/wzor/2019/12/19/8976/schemat.xsd" 
    xmlns="http://crd.gov.pl/wzor/2019/12/19/8976/" 
    xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/" 
    xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/ORDZU/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<%} else {%>
<Deklaracja 
    xsi:schemaLocation="http://crd.gov.pl/wzor/2019/12/19/8977/ http://crd.gov.pl/wzor/2019/12/19/8977/schemat.xsd" 
    xmlns="http://crd.gov.pl/wzor/2019/12/19/8977/" 
    xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/" 
    xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/ORDZU/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<%}%>
    <Naglowek>
<%if (ift1R) { %>
        <KodFormularza kodSystemowy="IFT-1R (15)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">IFT-1/IFT-1R</KodFormularza>
<%} else {%>
        <KodFormularza kodSystemowy="IFT-1 (15)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">IFT-1/IFT-1R</KodFormularza>
<%}%>
        <WariantFormularza>15</WariantFormularza>
        <CelZlozenia poz="P_7"><ea:XmlDataLabel runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
        <OkresOd poz="P_4"><ea:XmlDataLabel runat="server" DataMember="0.Od" XSDType="TData"></ea:XmlDataLabel></OkresOd>
        <OkresDo poz="P_5"><ea:XmlDataLabel runat="server" DataMember="0.Do" XSDType="TData"></ea:XmlDataLabel></OkresDo>
        <ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
    </Naglowek>
    <Podmiot1 rola="Płatnik/Podmiot Wypłacający">
        <ea:Section ID="OsobaFizyczna" runat="server"><OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" ID="ImiePierwsze" runat="server" XSDType="TImie" />
            <ea:XmlDataLabel ElementName="etd:Nazwisko" ID="Nazwisko" runat="server" XSDType="TNazwisko" />
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" ID="DataUrodzenia" runat="server" XSDType="TData" />
        </OsobaFizyczna></ea:Section>
        <ea:Section ID="OsobaNieFizyczna" runat="server"><OsobaNiefizyczna>
            <ea:XmlDataLabel ElementName="NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="PelnaNazwa" ID="NazwaPelna" runat="server" XSDType="TZnakowy" />
        </OsobaNiefizyczna></ea:Section>
        <AdresZamieszkaniaSiedziby rodzajAdresu="RAD">
            <ea:Section ID="AdresPolPl" runat="server">
            <etd:AdresPol>
                <etd:KodKraju>PL</etd:KodKraju>
                <ea:XmlDataLabel ElementName="etd:Wojewodztwo" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin" />
                <ea:XmlDataLabel ElementName="etd:Powiat" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="etd:Gmina" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"/>
                <ea:XmlDataLabel ElementName="etd:Ulica" runat="server" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"/>
                <ea:XmlDataLabel ElementName="etd:NrDomu" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"/>
                <ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"/>
                <ea:XmlDataLabel ElementName="etd:Miejscowosc" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="etd:KodPocztowy" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"/>
            </etd:AdresPol>
            </ea:Section>
            <ea:Section ID="AdresZagrPl" runat="server">
            <etd:AdresZagr>
                <ea:XmlDataLabel ElementName="etd:KodKraju" runat="server" DataMember="X.KodKrajuPl" XSDType="TTekstowy"/>
                <ea:XmlDataLabel ElementName="etd:KodPocztowy" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:Miejscowosc" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
                <ea:XmlDataLabel ElementName="etd:Ulica" runat="server" DataMember="B2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrDomu" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
                <ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" DataMember="B2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
            </etd:AdresZagr>
            </ea:Section>
        </AdresZamieszkaniaSiedziby>
    </Podmiot1>	
    <Podmiot2 rola="Odbiorca Należności">
        <OsobaFizZagr>
            <ea:XmlDataLabel ElementName="ImiePierwsze" runat="server" DataMember="C1.Imię" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="Nazwisko" runat="server" DataMember="C1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="DataUrodzenia" runat="server" DataMember="C1.DataUrodz" XSDType="TData"/>
            <ea:XmlDataLabel ElementName="MiejsceUrodzenia" ID="pit_miejscUrodz" runat="server" DataMember="C1.MiejsceUrodz" XSDType="TMiejscowosc"/>
            <ea:XmlDataLabel ElementName="ImieOjca" runat="server" DataMember="C1.ImięOjca" XSDType="TImie" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="ImieMatki" runat="server" DataMember="C1.ImięMatki" XSDType="TImie" HideEmptyOrZero="true"/>
            <NrId poz="P_25"><ea:XmlDataLabel runat="server" DataMember="C1.Dokument" XSDType="TZnakowy"/></NrId>
            <RodzajNrId poz="P_26"><ea:XmlDataLabel runat="server" DataMember="X.RodzajNumeruPodatnika" XSDType="TZnakowy"/></RodzajNrId>
            <KodKrajuWydania poz="P_27A"><ea:XmlDataLabel runat="server" DataMember="X.DokumentKodKraju" XSDType="TZnakowy"/></KodKrajuWydania>
        </OsobaFizZagr>
        <AdresZamieszkania rodzajAdresu="RAD">
            <ea:XmlDataLabel ElementName="etd:KodKraju" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/>
            <ea:XmlDataLabel ElementName="etd:KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="etd:Miejscowosc" ID="pit_miejscZagr" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
            <ea:XmlDataLabel ElementName="etd:Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="etd:NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
        </AdresZamieszkania>
    </Podmiot2>
    <PozycjeSzczegolowe>
        <ea:XmlDataLabel ElementName="P_34" runat="server" DataMember="D.1Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_35" runat="server" DataMember="D.1Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_36" runat="server" DataMember="D.1Stawka" XSDType="TProcentowy" />
        <ea:XmlDataLabel ElementName="P_37" runat="server" DataMember="D.1Podatek" XSDType="TKwotaC" />
		
        <ea:XmlDataLabel ElementName="P_38" runat="server" DataMember="D.2Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_39" runat="server" DataMember="D.2Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_40" runat="server" DataMember="D.2Stawka" XSDType="TProcentowy" />
        <ea:XmlDataLabel ElementName="P_41" runat="server" DataMember="D.2Podatek" XSDType="TKwotaC" />
		
        <ea:XmlDataLabel ElementName="P_42" runat="server" DataMember="D.3Zwolniony" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="P_43" runat="server" DataMember="D.3Kwota" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="P_44" runat="server" DataMember="D.3Stawka" XSDType="TProcentowy" />
        <ea:XmlDataLabel ElementName="P_45" runat="server" DataMember="D.3Podatek" XSDType="TKwota2" />

        <ea:XmlDataLabel ElementName="P_46" runat="server" DataMember="D.4Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_47" runat="server" DataMember="D.4Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_48" runat="server" DataMember="D.4Stawka" XSDType="TProcentowy" />
        <ea:XmlDataLabel ElementName="P_49" runat="server" DataMember="D.4Podatek" XSDType="TKwotaC" />

        <ea:XmlDataLabel ElementName="P_50" runat="server" DataMember="D.5Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_51" runat="server" DataMember="D.5Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_52" runat="server" DataMember="D.5Stawka" XSDType="TProcentowy" />
        <ea:XmlDataLabel ElementName="P_53" runat="server" DataMember="D.5Podatek" XSDType="TKwotaC" />

        <ea:XmlDataLabel ElementName="P_54" runat="server" DataMember="D.6Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_55" runat="server" DataMember="D.6Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_56" runat="server" DataMember="D.6Stawka" XSDType="TProcentowy" />
        <ea:XmlDataLabel ElementName="P_57" runat="server" DataMember="D.6Podatek" XSDType="TKwotaC" />

        <ea:XmlDataLabel ElementName="P_58" runat="server" DataMember="D.7Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_59" runat="server" DataMember="D.7Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_60" runat="server" DataMember="D.7Stawka" XSDType="TProcentowy" />
        <ea:XmlDataLabel ElementName="P_61" runat="server" DataMember="D.7Podatek" XSDType="TKwotaC" />
		
        <ea:XmlDataLabel ElementName="P_62" runat="server" DataMember="D.8Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_63" runat="server" DataMember="D.8Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_64" runat="server" DataMember="D.8Stawka" XSDType="TProcentowy" />
        <ea:XmlDataLabel ElementName="P_65" runat="server" DataMember="D.8Podatek" XSDType="TKwotaC" />
		
        <ea:XmlDataLabel ElementName="P_66" runat="server" DataMember="D.9Zwolniony" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_67" runat="server" DataMember="D.9Kwota" XSDType="TKwotaC" />
        <ea:XmlDataLabel ElementName="P_68" runat="server" DataMember="D.9Stawka" XSDType="TProcentowy" />
        <ea:XmlDataLabel ElementName="P_69" runat="server" DataMember="D.9Podatek" XSDType="TKwotaC" />
		
        <ea:XmlDataLabel ElementName="P_70" runat="server" DataMember="D.10Zwolniony" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="P_71" runat="server" DataMember="D.10Kwota" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="P_72" runat="server" DataMember="D.10Stawka" XSDType="TProcentowy" />
        <ea:XmlDataLabel ElementName="P_73" runat="server" DataMember="D.10Podatek" XSDType="TKwota2" />

        <ea:XmlDataLabel ElementName="P_74" ID="DataZłożenia" runat="server" DataMember="E.DataZłożenia" XSDType="TData" />
        <ea:XmlDataLabel ElementName="P_75" runat="server" DataMember="E.DataPrzekazania" XSDType="TData" />
    </PozycjeSzczegolowe>
    <Pouczenie>1</Pouczenie>
    <ea:Section ID="ORD_ZU" runat="server">
    <Zalaczniki>
    <zzu:Zalacznik_ORD-ZU>
        <zzu:Naglowek>
            <zzu:KodFormularza kodSystemowy="ORD-ZU (3)" wersjaSchemy="2-0E">ORD-ZU</zzu:KodFormularza>
            <zzu:WariantFormularza>3</zzu:WariantFormularza>
        </zzu:Naglowek>
        <zzu:PozycjeSzczegolowe>
            <ea:XmlDataLabel ElementName="zzu:P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
        </zzu:PozycjeSzczegolowe>
    </zzu:Zalacznik_ORD-ZU>
    </Zalaczniki>
    </ea:Section>
</Deklaracja>
