﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<script runat="server">
    void OnContextLoad(Object sender, EventArgs args) {
        var dek = (PIT11Z_29)dc[typeof(PIT11Z_29)];

        bool osobaFizyczna = (bool)dek.Bloki["B1"]["OsobaFiz"];
        string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], osobaFizyczna);
        
        if (osobaFizyczna) {
            OsobaNieFizyczna.Visible = false;
            if (nazwa.Length > 0)
                Nazwisko.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                ImiePierwsze.EditValue = nazwa[1].Trim();
            if (nazwa.Length > 2)
                DataUrodzenia.EditValue = nazwa[2].Trim();
            string nip = (string)dek.Bloki["0"]["Nip"];
            P0_NIP.Visible = nip!="";
            P0_PESEL.Visible = nip=="";
        }
        else {
            OsobaFizyczna.Visible = false;
            if (nazwa.Length > 0)
                NazwaPelna.EditValue = nazwa[0].Trim();
        }

        var pity = new List<PIT11>();
        foreach (PIT11 pit in dek.Deklaracje)
            if (pit is PIT11_29)
                pity.Add((PIT11)pit);
        PIT_REP.DataSource = pity;
    }

    protected void PIT_11_BeforeRow(object sender, EventArgs e) {
        var dek = (PIT11_29)PIT_REP.CurrentRow;
        
        if (dek.JestPESEL) {
            P10_NIP.Visible = false;
            P10_PESEL.Visible = true;
        }
        else {
            P10_NIP.Visible = true;
            P10_PESEL.Visible = false;
        }
        
        var numerDok = (string)dek.Bloki["C1"]["ZagrNIP"];
        ZagrNrId.Visible = numerDok!="";
        if (ZagrNrId.Visible) {     
            NumerDok.EditValue = numerDok;       
            RodzajDok.EditValue = SplitedItem((string)dek.Bloki["C1"]["RodzajDok"], 1, '/');
            KrajDok.EditValue = SplitedItem((string)dek.Bloki["C1"]["KrajDok"], 1, '/');
        }
        else {
            NumerDok.EditValue = "";       
            RodzajDok.EditValue = "";
            KrajDok.EditValue = "";
        }

        var miejsc = (string)dek.Bloki["C2"]["Miejsc"];
        AdresZamieszkania.Visible = miejsc!="";

        if ((bool)dek.Bloki["D"]["Jeden"])
            P28.EditValue = 1;
        else if ((bool)dek.Bloki["D"]["Wiecej"])
            P28.EditValue = 2;
        else if ((bool)dek.Bloki["D"]["JedenPodw"])
            P28.EditValue = 3;
        else if ((bool)dek.Bloki["D"]["WiecejPodw"])
            P28.EditValue = 4;
        else
            P28.EditValue = 1;

        P89.EditValue = (bool)dek.Bloki["G"]["PITR"] ? 1 : 2;

        var pityr = new List<PITR_21>();
        foreach (Deklaracja z in dek.Deklaracje)
            if (z is PITR_21)
                pityr.Add((PITR_21)z);
        PIT_R.DataSource = pityr;
    }

    string SplitedItem(string s, int item, params char[] separator) {
        string[] ss = s.Split(separator);
        return ss.Length<item ? "" : ss[item];
    }

    protected void PIT_R_BeforeRow(object sender, EventArgs e) {
    }

    static void AddMap(XmlDataLabel label, string key, string value, int maxLen) {
        label.ValuesMap.Add(new ValuesPair(key, Soneta.Core.Tools.Left(value, maxLen)));
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT11Z_29,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<tns:Deklaracja 
    xsi:schemaLocation="http://crd.gov.pl/wzor/2022/09/12/11784/ http://crd.gov.pl/wzor/2022/09/12/11784/schemat.xsd" 
    xmlns:tns="http://crd.gov.pl/wzor/2022/09/12/11784/"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/03/15/eD/DefinicjeTypy/"
    xmlns:kusex="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/12/23/eD/KodyUrzedowSkarbowychExWUS/"
    xmlns:zr="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/03/15/eD/PITR/">    
    <tns:Naglowek>
        <tns:KodFormularza kodSystemowy="PIT-11 (29)" kodPodatku="PIT" rodzajZobowiazania="Z" wersjaSchemy="2-0E">PIT-11Z</tns:KodFormularza>
        <tns:WariantFormularza>29</tns:WariantFormularza>		
        <tns:CelZlozenia poz="P_7"><ea:XmlDataLabel runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></tns:CelZlozenia>
        <ea:XmlDataLabel ElementName="tns:Rok" runat="server" DataMember="0.Rok" XSDType="TCalkowity" />
        <tns:KodUrzedu>0000</tns:KodUrzedu>		
    </tns:Naglowek>
    <tns:Podmiot1 rola="Płatnik/Składający">
        <ea:Section ID="OsobaFizyczna" runat="server"><tns:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="etd:NIP" runat="server" ID="P0_NIP" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="etd:PESEL" runat="server" ID="P0_PESEL" DataMember="0.PESEL" XSDType="TNrPESEL"/>
            <ea:XmlDataLabel ElementName="etd:ImiePierwsze" ID="ImiePierwsze" runat="server" XSDType="TImie"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:Nazwisko" ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel>
            <ea:XmlDataLabel ElementName="etd:DataUrodzenia" ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel>
        </tns:OsobaFizyczna></ea:Section>
        <ea:Section ID="OsobaNieFizyczna" runat="server"><tns:OsobaNiefizyczna>
            <ea:XmlDataLabel ElementName="tns:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
            <ea:XmlDataLabel ElementName="tns:PelnaNazwa" ID="NazwaPelna" runat="server" XSDType="TZnakowy" />
        </tns:OsobaNiefizyczna></ea:Section>
    </tns:Podmiot1>	
    <ea:DataRepeater ID="PIT_REP" runat="server" WithSections="False" OnBeforeRow="PIT_11_BeforeRow">
    <tns:Pozycja typ="G">
    <ea:XmlDataLabel ElementName="tns:KodUrzeduP" runat="server" DataMember="X.KodUrzeduSkarbowego" />
    <tns:Podmiot2 rola="Podatnik">
        <tns:OsobaFizyczna>
            <ea:XmlDataLabel ElementName="tns:NIP" ID="P10_NIP" runat="server" DataMember="C1.NIP" XSDType="TNrNIP" />
            <ea:XmlDataLabel ElementName="tns:PESEL" ID="P10_PESEL" runat="server" DataMember="C1.PESEL" XSDType="TNrPESEL" />
            <ea:XmlDataLabel ElementName="tns:ImiePierwsze" runat="server" DataMember="C1.Imię" XSDType="TImie"/>
            <ea:XmlDataLabel ElementName="tns:Nazwisko" runat="server" DataMember="C1.Nazwisko" XSDType="TNazwisko"/>
            <ea:XmlDataLabel ElementName="tns:DataUrodzenia" runat="server" DataMember="C1.DataUrodz" XSDType="TData"/>
            <ea:Section ID="ZagrNrId" runat="server">
                <tns:NrId poz="P_13"><ea:XmlDataLabel ID="NumerDok" runat="server"/></tns:NrId>
                <tns:RodzajNrId poz="P_14"><ea:XmlDataLabel ID="RodzajDok" runat="server"/></tns:RodzajNrId>
                <tns:KodKrajuWydania poz="P_15A"><ea:XmlDataLabel ID="KrajDok" runat="server"/></tns:KodKrajuWydania>
            </ea:Section>
        </tns:OsobaFizyczna>
        <ea:Section ID="AdresZamieszkania" runat="server">
        <tns:AdresZamieszkania rodzajAdresu="RAD">
            <tns:KodKraju poz="P_19A"><ea:XmlDataLabel runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"><ValuesMap><ea:ValuesPair Key="" Value="PL" /></ValuesMap></ea:XmlDataLabel></tns:KodKraju>
            <ea:XmlDataLabel ElementName="tns:Wojewodztwo" ID="pit_wojew" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:Powiat" ID="pit_powiat" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:Gmina" ID="pit_gmina" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:Ulica" PozAttribute="P_23" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:NrDomu" PozAttribute="P_24" ID="pit_nrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:NrLokalu" PozAttribute="P_25" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
            <ea:XmlDataLabel ElementName="tns:Miejscowosc" PozAttribute="P_26" ID="pit_miejsc" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
            <ea:XmlDataLabel ElementName="tns:KodPocztowy" PozAttribute="P_27" ID="pit_kodPoczt" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
        </tns:AdresZamieszkania>
        </ea:Section>
    </tns:Podmiot2>
    <tns:PozycjeSzczegolowe>
          <ea:XmlDataLabel ElementName="tns:P_5" runat="server" DataMember="0.Numer" XSDType="TCalkowity" /> 
        <tns:P_11><ea:XmlDataLabel runat="server" DataMember="C1.Rezydent"><ValuesMap><ea:ValuesPair Key="False" Value="2" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel></tns:P_11>        

        <ea:XmlDataLabel ElementName="tns:P_28" ID="P28" runat="server" XSDType="TCalkowity" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="tns:P_29" runat="server" DataMember="E.1aPrzychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_30" runat="server" DataMember="E.1aKoszty" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_31" runat="server" DataMember="E.1Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_32" runat="server" DataMember="E.1Zwolniony" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_33" runat="server" DataMember="E.1Zaliczka" XSDType="TKwotaC"/>
        <ea:XmlDataLabel ElementName="tns:P_34" runat="server" DataMember="E.1bPrzychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_35" runat="server" DataMember="E.1bKoszty" XSDType="TKwota2"/>
		
        <ea:XmlDataLabel ElementName="tns:P_36" runat="server" DataMember="E.2aPrzychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_37" runat="server" DataMember="E.2aKoszty" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_38" runat="server" DataMember="E.2Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_39" runat="server" DataMember="E.2Zwolniony" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_40" runat="server" DataMember="E.2Zaliczka" XSDType="TKwotaC"/>
        <ea:XmlDataLabel ElementName="tns:P_41" runat="server" DataMember="E.2bPrzychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_42" runat="server" DataMember="E.2bKoszty" XSDType="TKwota2"/>
		
        <ea:XmlDataLabel ElementName="tns:P_43" runat="server" DataMember="E.3aPrzychód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_44" runat="server" DataMember="E.3aKoszty" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_45" runat="server" DataMember="E.3Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_46" runat="server" DataMember="E.3Zwolniony" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_47" runat="server" DataMember="E.3Zaliczka" XSDType="TKwotaC"/>		
        <ea:XmlDataLabel ElementName="tns:P_48" runat="server" DataMember="E.3bPrzychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_49" runat="server" DataMember="E.3bKoszty" XSDType="TKwota2"/>
		
        <ea:XmlDataLabel ElementName="tns:P_50" runat="server" DataMember="E.4Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_51" runat="server" DataMember="E.4Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_52" runat="server" DataMember="E.4Zwolniony" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_53" runat="server" DataMember="E.4Zaliczka" XSDType="TKwotaC"/>
		
        <ea:XmlDataLabel ElementName="tns:P_54" runat="server" DataMember="E.5Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_55" runat="server" DataMember="E.5Koszty" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_56" runat="server" DataMember="E.5Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_57" runat="server" DataMember="E.5Zaliczka" XSDType="TKwotaC"/>
		
        <ea:XmlDataLabel ElementName="tns:P_58" runat="server" DataMember="E.6Przychód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_59" runat="server" DataMember="E.6Koszty" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_60" runat="server" DataMember="E.6Dochód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_61" runat="server" DataMember="E.6Zaliczka" XSDType="TKwotaC"/>		

        <ea:XmlDataLabel ElementName="tns:P_62" runat="server" DataMember="E.7Przychód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_63" runat="server" DataMember="E.7Koszty" XSDType="TKwota2" HideEmptyOrZero="true"/>		
        <ea:XmlDataLabel ElementName="tns:P_64" runat="server" DataMember="E.7Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_65" runat="server" DataMember="E.7Zaliczka" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="tns:P_66" runat="server" DataMember="E.8Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_67" runat="server" DataMember="E.8Koszty" XSDType="TKwota2"HideEmptyOrZero="true" />	
        <ea:XmlDataLabel ElementName="tns:P_68" runat="server" DataMember="E.8Dochód" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="tns:P_69" runat="server" DataMember="E.8Zaliczka" XSDType="TKwotaC" />

        <ea:XmlDataLabel ElementName="tns:P_70" runat="server" DataMember="E.9Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_71" runat="server" DataMember="E.9Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_72" runat="server" DataMember="E.9Zaliczka" XSDType="TKwotaC"/>
        <ea:XmlDataLabel ElementName="tns:P_73" runat="server" DataMember="E.9bPrzychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_74" runat="server" DataMember="E.9Koszty" XSDType="TKwota2"/>	

        <ea:XmlDataLabel ElementName="tns:P_75" runat="server" DataMember="E.10Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_76" runat="server" DataMember="E.10Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_77" runat="server" DataMember="E.10Zaliczka" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="tns:P_78" runat="server" DataMember="E.11Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_79" runat="server" DataMember="E.11Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_80" runat="server" DataMember="E.11Zaliczka" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="tns:P_81" runat="server" DataMember="E.12Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_82" runat="server" DataMember="E.12Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_83" runat="server" DataMember="E.12Zaliczka" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="tns:P_84" runat="server" DataMember="E.13Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_85" runat="server" DataMember="E.13Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_86" runat="server" DataMember="E.13Zaliczka" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="tns:P_87" runat="server" DataMember="E.14Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_88" runat="server" DataMember="E.14Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_89" runat="server" DataMember="E.14Zaliczka" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="tns:P_90" runat="server" DataMember="E.15Przychód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_91" runat="server" DataMember="E.15Koszty" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_92" runat="server" DataMember="E.15Dochód" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_93" runat="server" DataMember="E.15Zwolniony" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="tns:P_94" runat="server" DataMember="E.15Zaliczka" XSDType="TKwotaC"/>

        <ea:XmlDataLabel ElementName="tns:P_95" runat="server" DataMember="E.SpołeczneRazem" XSDType="TKwota2" HideEmptyOrZero="true"/>		
        <ea:XmlDataLabel ElementName="tns:P_96" runat="server" DataMember="E.Społeczne26Razem" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_97" runat="server" DataMember="E.Społeczne26Zwol" XSDType="TKwota2" HideEmptyOrZero="true"/>		

        <ea:XmlDataLabel ElementName="tns:P_98" runat="server" DataMember="F.1Przychód" XSDType="TKwota2" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="tns:P_99" runat="server" DataMember="F.2Opis" XSDType="TZnakowy" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_100" runat="server" DataMember="F.2Przychód" XSDType="TKwota2" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="tns:P_101" runat="server" DataMember="F.3Opis" XSDType="TZnakowy" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_102" runat="server" DataMember="F.3Przychód" XSDType="TKwota2" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="tns:P_103" runat="server" DataMember="F.4Opis" XSDType="TZnakowy" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_104" runat="server" DataMember="F.4Przychód" XSDType="TKwota2" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="tns:P_105" runat="server" DataMember="F.Przychód" XSDType="TKwota2"/>


        <ea:XmlDataLabel ElementName="tns:P_106" runat="server" DataMember="G.PrzychódTytStyp" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_107" runat="server" DataMember="G.ZZagranicy" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_108" runat="server" DataMember="G.PomocBezzwrotna" XSDType="TKwota2" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="tns:P_109" runat="server" DataMember="G.PrzychódZwolniony26" XSDType="TKwota2" />
        <ea:XmlDataLabel ElementName="tns:P_110" runat="server" DataMember="G.PrzychódZwolniony26Etat" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_111" runat="server" DataMember="G.PrzychódZwolniony26Umowa" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_112" runat="server" DataMember="G.PrzychódZwolniony26Praktyki" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_113" runat="server" DataMember="G.PrzychódZwolniony26PraktykiMacierzyński" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_114" runat="server" DataMember="G.PrzychódZwolnionyUlgi" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_115" runat="server" DataMember="G.PrzychódZwolnionyUlgiEtat" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_116" runat="server" DataMember="G.PrzychódZwolnionyUlgiUmowa" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_117" runat="server" DataMember="G.PrzychódZwolnionyUlgiUmowaMacierzyński" XSDType="TKwota2" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="tns:P_118" ID="XmlDataLabel1" runat="server" HideEmptyOrZero="true" DataMember="G.PrzychódZwolUlgiPodstawa152"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
        <ea:XmlDataLabel ElementName="tns:P_119" ID="XmlDataLabel2" runat="server" HideEmptyOrZero="true" DataMember="G.PrzychódZwolUlgiPodstawa153"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>
        <ea:XmlDataLabel ElementName="tns:P_120" ID="XmlDataLabel3" runat="server" HideEmptyOrZero="true" DataMember="G.PrzychódZwolUlgiPodstawa154"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="0"/></ValuesMap></ea:XmlDataLabel>

        <ea:XmlDataLabel ElementName="tns:P_121" ID="P89" runat="server" DataMember="G.PITR"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="2"/></ValuesMap></ea:XmlDataLabel>

        <ea:XmlDataLabel ElementName="tns:P_122" runat="server" DataMember="G.SkładkiZdrowotne" XSDType="TKwota2" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="tns:P_123" runat="server" DataMember="G.SkładkiCzłonkowskieZwiązkiZaw" XSDType="TKwota2" HideEmptyOrZero="true"/>

    </tns:PozycjeSzczegolowe>
    <tns:Zalaczniki>
    <ea:DataRepeater ID="PIT_R" runat="server" WithSections="False" OnBeforeRow="PIT_R_BeforeRow">
    <zr:Zalacznik_PIT-R>
    <zr:Naglowek>
        <zr:KodFormularza kodSystemowy="PIT-R (21)" wersjaSchemy="1-0E">PIT-R</zr:KodFormularza>
        <zr:WariantFormularza>21</zr:WariantFormularza>
    </zr:Naglowek>
    <zr:PozycjeSzczegolowe>
       <ea:XmlDataLabel ElementName="zr:P_12" runat="server" DataMember="D.01_b" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_13" runat="server" DataMember="D.01_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_14" runat="server" DataMember="D.01_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_15" runat="server" DataMember="D.01_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_16" runat="server" DataMember="D.02_b" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_17" runat="server" DataMember="D.02_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_18" runat="server" DataMember="D.02_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_19" runat="server" DataMember="D.02_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_20" runat="server" DataMember="D.03_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_21" runat="server" DataMember="D.03_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_22" runat="server" DataMember="D.03_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_23" runat="server" DataMember="D.03_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_24" runat="server" DataMember="D.04_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_25" runat="server" DataMember="D.04_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_26" runat="server" DataMember="D.04_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_27" runat="server" DataMember="D.04_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="zr:P_28" runat="server" DataMember="D.05_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_29" runat="server" DataMember="D.05_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_30" runat="server" DataMember="D.05_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_31" runat="server" DataMember="D.05_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_32" runat="server" DataMember="D.06_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_33" runat="server" DataMember="D.06_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_34" runat="server" DataMember="D.06_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_35" runat="server" DataMember="D.06_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_36" runat="server" DataMember="D.07_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_37" runat="server" DataMember="D.07_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_38" runat="server" DataMember="D.07_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_39" runat="server" DataMember="D.07_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="zr:P_40" runat="server" DataMember="D.08_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_41" runat="server" DataMember="D.08_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_42" runat="server" DataMember="D.08_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_43" runat="server" DataMember="D.08_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_44" runat="server" DataMember="D.09_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_45" runat="server" DataMember="D.09_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_46" runat="server" DataMember="D.09_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_47" runat="server" DataMember="D.09_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_48" runat="server" DataMember="D.10_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_49" runat="server" DataMember="D.10_c" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_50" runat="server" DataMember="D.10_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_51" runat="server" DataMember="D.10_e" XSDType="TKwota2"/>				

        <ea:XmlDataLabel ElementName="zr:P_52" runat="server" DataMember="D.11_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_53" runat="server" DataMember="D.11_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_54" runat="server" DataMember="D.11_d" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_55" runat="server" DataMember="D.11_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_56" runat="server" DataMember="D.12_b" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_57" runat="server" DataMember="D.12_c" XSDType="TKwota2"/>
        <ea:XmlDataLabel ElementName="zr:P_58" runat="server" DataMember="D.12_d" XSDType="TKwota2"/>		
        <ea:XmlDataLabel ElementName="zr:P_59" runat="server" DataMember="D.12_e" XSDType="TKwota2"/>		

        <ea:XmlDataLabel ElementName="zr:P_60" runat="server" DataMember="D.razem_e" XSDType="TKwota2"/>
    </zr:PozycjeSzczegolowe>
    </zr:Zalacznik_PIT-R>
    </ea:DataRepeater>
    </tns:Zalaczniki>
    </tns:Pozycja>
    </ea:DataRepeater>
    <tns:Pouczenie>1</tns:Pouczenie>
</tns:Deklaracja>
