﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<script runat="server">
    Soneta.Deklaracje.PIT.PIT4R_2 dek;

    void OnContextLoad(Object sender, EventArgs args) {
        dek = (Soneta.Deklaracje.PIT.PIT4R_2)dc[typeof(Soneta.Deklaracje.PIT.PIT4R_2)];

        bool osobaFizyczna = (bool)dek.Bloki["B1"]["OsobaFiz"];
        string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], osobaFizyczna);
        
        if (osobaFizyczna) {
            OsobaNieFizyczna.Visible = false;
            if (nazwa.Length > 0)
                Nazwisko.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                ImiePiersze.EditValue = nazwa[1].Trim();
            if (nazwa.Length > 2)
                DataUrodzenia.EditValue = nazwa[2].Trim();
        }
        else {
            OsobaFizyczna.Visible = false;
            if (nazwa.Length > 0)
                NazwaPelna.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                REGON.EditValue = nazwa[1].Trim();
        }

        ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
    }
	
</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT4R_2,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:noNamespaceSchemaLocation="http://www.e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/PIT/PIT-4R(2)_v1-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<Naglowek>
	    <KodFormularza kodSystemowy="PIT-4R (2)" kodPodatku="PIT" rodzajZobowiazania="P">PIT-4R</KodFormularza>
		<WariantFormularza>2</WariantFormularza>		
		<CelZlozenia poz="P_6"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<Rok><ea:XmlDataLabel ID="DataLabel2" runat="server" DataMember="0.Rok"></ea:XmlDataLabel></Rok>
		<KodUrzedu><ea:XmlDataLabel ID="DataLabel4" runat="server" DataMember="X.KodUrzeduSkarbowego"></ea:XmlDataLabel></KodUrzedu>
	</Naglowek>
	<Podmiot1 rola="Płatnik">
		<ea:Section ID="OsobaFizyczna" runat="server"><OsobaFizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel1" runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<ImiePierwsze><ea:XmlDataLabel ID="ImiePiersze" runat="server" XSDType="TImie"></ea:XmlDataLabel></ImiePierwsze>
			<Nazwisko><ea:XmlDataLabel ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel></Nazwisko>
			<DataUrodzenia><ea:XmlDataLabel ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel></DataUrodzenia>
		</OsobaFizyczna></ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server"><OsobaNiefizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel2" runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<PelnaNazwa><ea:XmlDataLabel ID="NazwaPelna" runat="server" XSDType="TZnakowy"></ea:XmlDataLabel></PelnaNazwa>
			<REGON><ea:XmlDataLabel ID="REGON" runat="server" XSDType="TNrREGON"></ea:XmlDataLabel></REGON>
		</OsobaNiefizyczna></ea:Section>
		<AdresZamieszkaniaSiedziby rodzajAdresu="RAD">
			<AdresPol>
				<KodKraju>PL</KodKraju>
				<Wojewodztwo><ea:XmlDataLabel ID="XmlDataLabel3" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin"></ea:XmlDataLabel></Wojewodztwo>
				<Powiat><ea:XmlDataLabel ID="XmlDataLabel4" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"></ea:XmlDataLabel></Powiat>
				<Gmina><ea:XmlDataLabel ID="XmlDataLabel5" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"></ea:XmlDataLabel></Gmina>
				<ea:XmlDataLabel ID="XmlDataLabel6" runat="server" ElementName="Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<NrDomu><ea:XmlDataLabel ID="XmlDataLabel7" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel></NrDomu>
				<ea:XmlDataLabel ID="XmlDataLabel8" runat="server" ElementName="NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
				<Miejscowosc><ea:XmlDataLabel ID="XmlDataLabel9" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></Miejscowosc>
				<KodPocztowy><ea:XmlDataLabel ID="XmlDataLabel10" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></KodPocztowy>
				<Poczta><ea:XmlDataLabel ID="XmlDataLabel11" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc"></ea:XmlDataLabel></Poczta>
			</AdresPol>
		</AdresZamieszkaniaSiedziby>
	</Podmiot1>	
	<PozycjeSzczegolowe>
		<P_19><ea:XmlDataLabel ID="P19" runat="server" DataMember="C1.1Podatnicy" XSDType="TCalkowity"></ea:XmlDataLabel></P_19>
		<P_25><ea:XmlDataLabel ID="P25" runat="server" DataMember="C1.1Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_25>
		<P_20><ea:XmlDataLabel ID="P20" runat="server" DataMember="C1.2Podatnicy" XSDType="TCalkowity"></ea:XmlDataLabel></P_20>
		<P_26><ea:XmlDataLabel ID="P26" runat="server" DataMember="C1.2Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_26>		
		<P_21><ea:XmlDataLabel ID="P21" runat="server" DataMember="C1.3Podatnicy" XSDType="TCalkowity"></ea:XmlDataLabel></P_21>
		<P_27><ea:XmlDataLabel ID="P27" runat="server" DataMember="C1.3Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_27>		
		<P_22><ea:XmlDataLabel ID="P22" runat="server" DataMember="C1.4Podatnicy" XSDType="TCalkowity"></ea:XmlDataLabel></P_22>
		<P_28><ea:XmlDataLabel ID="P28" runat="server" DataMember="C1.4Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_28>		
		<P_23><ea:XmlDataLabel ID="P23" runat="server" DataMember="C1.5Podatnicy" XSDType="TCalkowity"></ea:XmlDataLabel></P_23>
		<P_29><ea:XmlDataLabel ID="P29" runat="server" DataMember="C1.5Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_29>		
		<P_24><ea:XmlDataLabel ID="P24" runat="server" DataMember="C1.6Podatnicy" XSDType="TCalkowity"></ea:XmlDataLabel></P_24>
		<P_30><ea:XmlDataLabel ID="P30" runat="server" DataMember="C1.6Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_30>		
		<P_31><ea:XmlDataLabel ID="P31" runat="server" DataMember="C1.7Podatnicy" XSDType="TCalkowity"></ea:XmlDataLabel></P_31>
		<P_37><ea:XmlDataLabel ID="P37" runat="server" DataMember="C1.7Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_37>
		<P_32><ea:XmlDataLabel ID="P32" runat="server" DataMember="C1.8Podatnicy" XSDType="TCalkowity"></ea:XmlDataLabel></P_32>
		<P_38><ea:XmlDataLabel ID="P38" runat="server" DataMember="C1.8Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_38>
		<P_33><ea:XmlDataLabel ID="P33" runat="server" DataMember="C1.9Podatnicy" XSDType="TCalkowity"></ea:XmlDataLabel></P_33>
		<P_39><ea:XmlDataLabel ID="P39" runat="server" DataMember="C1.9Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_39>
		<P_34><ea:XmlDataLabel ID="P34" runat="server" DataMember="C1.10Podatnicy" XSDType="TCalkowity"></ea:XmlDataLabel></P_34>
		<P_40><ea:XmlDataLabel ID="P40" runat="server" DataMember="C1.10Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_40>		
		<P_35><ea:XmlDataLabel ID="P35" runat="server" DataMember="C1.11Podatnicy" XSDType="TCalkowity"></ea:XmlDataLabel></P_35>
		<P_41><ea:XmlDataLabel ID="P41" runat="server" DataMember="C1.11Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_41>
		<P_36><ea:XmlDataLabel ID="P36" runat="server" DataMember="C1.12Podatnicy" XSDType="TCalkowity"></ea:XmlDataLabel></P_36>
		<P_42><ea:XmlDataLabel ID="P42" runat="server" DataMember="C1.12Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_42>

		<P_43><ea:XmlDataLabel ID="P43" runat="server" DataMember="C2.1Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_43>
		<P_44><ea:XmlDataLabel ID="P44" runat="server" DataMember="C2.2Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_44>		
		<P_45><ea:XmlDataLabel ID="P45" runat="server" DataMember="C2.3Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_45>		
		<P_46><ea:XmlDataLabel ID="P46" runat="server" DataMember="C2.4Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_46>		
		<P_47><ea:XmlDataLabel ID="P47" runat="server" DataMember="C2.5Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_47>		
		<P_48><ea:XmlDataLabel ID="P48" runat="server" DataMember="C2.6Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_48>		
		<P_49><ea:XmlDataLabel ID="P49" runat="server" DataMember="C2.7Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_49>
		<P_50><ea:XmlDataLabel ID="P50" runat="server" DataMember="C2.8Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_50>
		<P_51><ea:XmlDataLabel ID="P51" runat="server" DataMember="C2.9Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_51>
		<P_52><ea:XmlDataLabel ID="P52" runat="server" DataMember="C2.10Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_52>		
		<P_53><ea:XmlDataLabel ID="P53" runat="server" DataMember="C2.11Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_53>
		<P_54><ea:XmlDataLabel ID="P54" runat="server" DataMember="C2.12Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_54>
		
		<P_55><ea:XmlDataLabel ID="P55" runat="server" DataMember="C3.1Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_55>
		<P_56><ea:XmlDataLabel ID="P56" runat="server" DataMember="C3.2Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_56>		
		<P_57><ea:XmlDataLabel ID="P57" runat="server" DataMember="C3.3Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_57>		
		<P_58><ea:XmlDataLabel ID="P58" runat="server" DataMember="C3.4Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_58>		
		<P_59><ea:XmlDataLabel ID="P59" runat="server" DataMember="C3.5Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_59>		
		<P_60><ea:XmlDataLabel ID="P60" runat="server" DataMember="C3.6Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_60>		
		<P_61><ea:XmlDataLabel ID="P61" runat="server" DataMember="C3.7Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_61>
		<P_62><ea:XmlDataLabel ID="P62" runat="server" DataMember="C3.8Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_62>
		<P_63><ea:XmlDataLabel ID="P63" runat="server" DataMember="C3.9Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_63>
		<P_64><ea:XmlDataLabel ID="P64" runat="server" DataMember="C3.10Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_64>		
		<P_65><ea:XmlDataLabel ID="P65" runat="server" DataMember="C3.11Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_65>
		<P_66><ea:XmlDataLabel ID="P66" runat="server" DataMember="C3.12Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_66>
		
		<P_67><ea:XmlDataLabel ID="P67" runat="server" DataMember="C4.1Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_67>
		<P_68><ea:XmlDataLabel ID="P68" runat="server" DataMember="C4.2Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_68>		
		<P_69><ea:XmlDataLabel ID="P69" runat="server" DataMember="C4.3Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_69>		
		<P_70><ea:XmlDataLabel ID="P70" runat="server" DataMember="C4.4Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_70>		
		<P_71><ea:XmlDataLabel ID="P71" runat="server" DataMember="C4.5Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_71>		
		<P_72><ea:XmlDataLabel ID="P72" runat="server" DataMember="C4.6Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_72>		
		<P_73><ea:XmlDataLabel ID="P73" runat="server" DataMember="C4.7Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_73>
		<P_74><ea:XmlDataLabel ID="P74" runat="server" DataMember="C4.8Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_74>
		<P_75><ea:XmlDataLabel ID="P75" runat="server" DataMember="C4.9Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_75>
		<P_76><ea:XmlDataLabel ID="P76" runat="server" DataMember="C4.10Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_76>		
		<P_77><ea:XmlDataLabel ID="P77" runat="server" DataMember="C4.11Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_77>
		<P_78><ea:XmlDataLabel ID="P78" runat="server" DataMember="C4.12Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_78>
		
		<P_79><ea:XmlDataLabel ID="P79" runat="server" DataMember="C5.1Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_79>
		<P_80><ea:XmlDataLabel ID="P80" runat="server" DataMember="C5.2Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_80>		
		<P_81><ea:XmlDataLabel ID="P81" runat="server" DataMember="C5.3Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_81>		
		<P_82><ea:XmlDataLabel ID="P82" runat="server" DataMember="C5.4Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_82>		
		<P_83><ea:XmlDataLabel ID="P83" runat="server" DataMember="C5.5Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_83>		
		<P_84><ea:XmlDataLabel ID="P84" runat="server" DataMember="C5.6Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_84>		
		<P_85><ea:XmlDataLabel ID="P85" runat="server" DataMember="C5.7Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_85>
		<P_86><ea:XmlDataLabel ID="P86" runat="server" DataMember="C5.8Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_86>
		<P_87><ea:XmlDataLabel ID="P87" runat="server" DataMember="C5.9Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_87>
		<P_88><ea:XmlDataLabel ID="P88" runat="server" DataMember="C5.10Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_88>		
		<P_89><ea:XmlDataLabel ID="P89" runat="server" DataMember="C5.11Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_89>
		<P_90><ea:XmlDataLabel ID="P90" runat="server" DataMember="C5.12Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_90>
		
		<P_91><ea:XmlDataLabel ID="P91" runat="server" DataMember="C6.1Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_91>
		<P_92><ea:XmlDataLabel ID="P92" runat="server" DataMember="C6.2Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_92>		
		<P_93><ea:XmlDataLabel ID="P93" runat="server" DataMember="C6.3Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_93>		
		<P_94><ea:XmlDataLabel ID="P94" runat="server" DataMember="C6.4Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_94>		
		
		<P_95><ea:XmlDataLabel ID="P95" runat="server" DataMember="C7.1Nadpłata" XSDType="TKwotaC"></ea:XmlDataLabel></P_95>
		<P_96><ea:XmlDataLabel ID="P96" runat="server" DataMember="C7.2Nadpłata" XSDType="TKwotaC"></ea:XmlDataLabel></P_96>		
		<P_97><ea:XmlDataLabel ID="P97" runat="server" DataMember="C7.3Nadpłata" XSDType="TKwotaC"></ea:XmlDataLabel></P_97>		
		<P_98><ea:XmlDataLabel ID="P98" runat="server" DataMember="C7.4Nadpłata" XSDType="TKwotaC"></ea:XmlDataLabel></P_98>		
		<P_99><ea:XmlDataLabel ID="P99" runat="server" DataMember="C7.5Nadpłata" XSDType="TKwotaC"></ea:XmlDataLabel></P_99>		
		<P_100><ea:XmlDataLabel ID="P100" runat="server" DataMember="C7.6Nadpłata" XSDType="TKwotaC"></ea:XmlDataLabel></P_100>		
		<P_101><ea:XmlDataLabel ID="P101" runat="server" DataMember="C7.7Nadpłata" XSDType="TKwotaC"></ea:XmlDataLabel></P_101>
		<P_102><ea:XmlDataLabel ID="P102" runat="server" DataMember="C7.8Nadpłata" XSDType="TKwotaC"></ea:XmlDataLabel></P_102>
		<P_103><ea:XmlDataLabel ID="P103" runat="server" DataMember="C7.9Nadpłata" XSDType="TKwotaC"></ea:XmlDataLabel></P_103>
		<P_104><ea:XmlDataLabel ID="P104" runat="server" DataMember="C7.10Nadpłata" XSDType="TKwotaC"></ea:XmlDataLabel></P_104>		
		<P_105><ea:XmlDataLabel ID="P105" runat="server" DataMember="C7.11Nadpłata" XSDType="TKwotaC"></ea:XmlDataLabel></P_105>
		<P_106><ea:XmlDataLabel ID="P106" runat="server" DataMember="C7.12Nadpłata" XSDType="TKwotaC"></ea:XmlDataLabel></P_106>
		
		<P_107><ea:XmlDataLabel ID="P107" runat="server" DataMember="C8.1Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_107>
		<P_108><ea:XmlDataLabel ID="P108" runat="server" DataMember="C8.2Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_108>		
		<P_109><ea:XmlDataLabel ID="P109" runat="server" DataMember="C8.3Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_109>		
		<P_110><ea:XmlDataLabel ID="P110" runat="server" DataMember="C8.4Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_110>		
		<P_111><ea:XmlDataLabel ID="P111" runat="server" DataMember="C8.5Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_111>		
		<P_112><ea:XmlDataLabel ID="P112" runat="server" DataMember="C8.6Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_112>		
		<P_113><ea:XmlDataLabel ID="P113" runat="server" DataMember="C8.7Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_113>
		<P_114><ea:XmlDataLabel ID="P114" runat="server" DataMember="C8.8Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_114>
		<P_115><ea:XmlDataLabel ID="P115" runat="server" DataMember="C8.9Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_115>
		<P_116><ea:XmlDataLabel ID="P116" runat="server" DataMember="C8.10Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_116>		
		<P_117><ea:XmlDataLabel ID="P117" runat="server" DataMember="C8.11Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_117>
		<P_118><ea:XmlDataLabel ID="P118" runat="server" DataMember="C8.12Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_118>
		
		<P_119><ea:XmlDataLabel ID="P119" runat="server" DataMember="C10.1Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_119>
		<P_120><ea:XmlDataLabel ID="P120" runat="server" DataMember="C10.2Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_120>		
		<P_121><ea:XmlDataLabel ID="P121" runat="server" DataMember="C10.3Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_121>		
		<P_122><ea:XmlDataLabel ID="P122" runat="server" DataMember="C10.4Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_122>		
		<P_123><ea:XmlDataLabel ID="P123" runat="server" DataMember="C10.5Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_123>		
		<P_124><ea:XmlDataLabel ID="P124" runat="server" DataMember="C10.6Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_124>		
		<P_125><ea:XmlDataLabel ID="P125" runat="server" DataMember="C10.7Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_125>
		<P_126><ea:XmlDataLabel ID="P126" runat="server" DataMember="C10.8Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_126>
		<P_127><ea:XmlDataLabel ID="P127" runat="server" DataMember="C10.9Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_127>
		<P_128><ea:XmlDataLabel ID="P128" runat="server" DataMember="C10.10Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_128>		
		<P_129><ea:XmlDataLabel ID="P129" runat="server" DataMember="C10.11Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_129>
		<P_130><ea:XmlDataLabel ID="P130" runat="server" DataMember="C10.12Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_130>
		
		<P_131><ea:XmlDataLabel ID="P131" runat="server" DataMember="C9.1Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_131>
		<P_132><ea:XmlDataLabel ID="P132" runat="server" DataMember="C9.2Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_132>		
		<P_133><ea:XmlDataLabel ID="P133" runat="server" DataMember="C9.3Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_133>		
		<P_134><ea:XmlDataLabel ID="P134" runat="server" DataMember="C9.4Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_134>		
		<P_135><ea:XmlDataLabel ID="P135" runat="server" DataMember="C9.5Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_135>		
		<P_136><ea:XmlDataLabel ID="P136" runat="server" DataMember="C9.6Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_136>		
		<P_137><ea:XmlDataLabel ID="P137" runat="server" DataMember="C9.7Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_137>
		<P_138><ea:XmlDataLabel ID="P138" runat="server" DataMember="C9.8Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_138>
		<P_139><ea:XmlDataLabel ID="P139" runat="server" DataMember="C9.9Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_139>
		<P_140><ea:XmlDataLabel ID="P140" runat="server" DataMember="C9.10Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_140>		
		<P_141><ea:XmlDataLabel ID="P141" runat="server" DataMember="C9.11Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_141>
		<P_142><ea:XmlDataLabel ID="P142" runat="server" DataMember="C9.12Zaliczka" XSDType="TKwotaC"></ea:XmlDataLabel></P_142>
		
		<P_143><ea:XmlDataLabel ID="P143" runat="server" DataMember="C11.1Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_143>
		<P_144><ea:XmlDataLabel ID="P144" runat="server" DataMember="C11.2Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_144>		
		<P_145><ea:XmlDataLabel ID="P145" runat="server" DataMember="C11.3Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_145>		
		<P_146><ea:XmlDataLabel ID="P146" runat="server" DataMember="C11.4Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_146>		
		<P_147><ea:XmlDataLabel ID="P147" runat="server" DataMember="C11.5Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_147>		
		<P_148><ea:XmlDataLabel ID="P148" runat="server" DataMember="C11.6Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_148>		
		<P_149><ea:XmlDataLabel ID="P149" runat="server" DataMember="C11.7Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_149>
		<P_150><ea:XmlDataLabel ID="P150" runat="server" DataMember="C11.8Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_150>
		<P_151><ea:XmlDataLabel ID="P151" runat="server" DataMember="C11.9Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_151>
		<P_152><ea:XmlDataLabel ID="P152" runat="server" DataMember="C11.10Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_152>		
		<P_153><ea:XmlDataLabel ID="P153" runat="server" DataMember="C11.11Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_153>
		<P_154><ea:XmlDataLabel ID="P154" runat="server" DataMember="C11.12Podatek" XSDType="TKwotaC"></ea:XmlDataLabel></P_154>
		
		<P_155><ea:XmlDataLabel ID="P155" runat="server" DataMember="C12.1Wynagrodzenie" XSDType="TKwotaC"></ea:XmlDataLabel></P_155>
		<P_156><ea:XmlDataLabel ID="P156" runat="server" DataMember="C12.2Wynagrodzenie" XSDType="TKwotaC"></ea:XmlDataLabel></P_156>		
		<P_157><ea:XmlDataLabel ID="P157" runat="server" DataMember="C12.3Wynagrodzenie" XSDType="TKwotaC"></ea:XmlDataLabel></P_157>		
		<P_158><ea:XmlDataLabel ID="P158" runat="server" DataMember="C12.4Wynagrodzenie" XSDType="TKwotaC"></ea:XmlDataLabel></P_158>		
		<P_159><ea:XmlDataLabel ID="P159" runat="server" DataMember="C12.5Wynagrodzenie" XSDType="TKwotaC"></ea:XmlDataLabel></P_159>		
		<P_160><ea:XmlDataLabel ID="P160" runat="server" DataMember="C12.6Wynagrodzenie" XSDType="TKwotaC"></ea:XmlDataLabel></P_160>		
		<P_161><ea:XmlDataLabel ID="P161" runat="server" DataMember="C12.7Wynagrodzenie" XSDType="TKwotaC"></ea:XmlDataLabel></P_161>
		<P_162><ea:XmlDataLabel ID="P162" runat="server" DataMember="C12.8Wynagrodzenie" XSDType="TKwotaC"></ea:XmlDataLabel></P_162>
		<P_163><ea:XmlDataLabel ID="P163" runat="server" DataMember="C12.9Wynagrodzenie" XSDType="TKwotaC"></ea:XmlDataLabel></P_163>
		<P_164><ea:XmlDataLabel ID="P164" runat="server" DataMember="C12.10Wynagrodzenie" XSDType="TKwotaC"></ea:XmlDataLabel></P_164>		
		<P_165><ea:XmlDataLabel ID="P165" runat="server" DataMember="C12.11Wynagrodzenie" XSDType="TKwotaC"></ea:XmlDataLabel></P_165>
		<P_166><ea:XmlDataLabel ID="P166" runat="server" DataMember="C12.12Wynagrodzenie" XSDType="TKwotaC"></ea:XmlDataLabel></P_166>
		
		<P_167><ea:XmlDataLabel ID="P167" runat="server" DataMember="C13.1DoWpłaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_167>
		<P_168><ea:XmlDataLabel ID="P168" runat="server" DataMember="C13.2DoWpłaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_168>		
		<P_169><ea:XmlDataLabel ID="P169" runat="server" DataMember="C13.3DoWpłaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_169>		
		<P_170><ea:XmlDataLabel ID="P170" runat="server" DataMember="C13.4DoWpłaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_170>		
		<P_171><ea:XmlDataLabel ID="P171" runat="server" DataMember="C13.5DoWpłaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_171>		
		<P_172><ea:XmlDataLabel ID="P172" runat="server" DataMember="C13.6DoWpłaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_172>		
		<P_173><ea:XmlDataLabel ID="P173" runat="server" DataMember="C13.7DoWpłaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_173>
		<P_174><ea:XmlDataLabel ID="P174" runat="server" DataMember="C13.8DoWpłaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_174>
		<P_175><ea:XmlDataLabel ID="P175" runat="server" DataMember="C13.9DoWpłaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_175>
		<P_176><ea:XmlDataLabel ID="P176" runat="server" DataMember="C13.10DoWpłaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_176>		
		<P_177><ea:XmlDataLabel ID="P177" runat="server" DataMember="C13.11DoWpłaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_177>
		<P_178><ea:XmlDataLabel ID="P178" runat="server" DataMember="C13.12DoWpłaty" XSDType="TKwotaC"></ea:XmlDataLabel></P_178>
		
		<ea:XmlDataLabel ID="P179" ElementName="P_179" runat="server" DataMember="D.Wyjaśnienie" XSDType="TTekstowy" HideEmptyOrZero="true"></ea:XmlDataLabel>
		
	</PozycjeSzczegolowe>
	<Pouczenie>W przypadku niewpłacenia w obowiązującym terminie kwot z poz. od 167 do 178 lub wpłacenia ich w niepełnej wysokości, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz.U. z 2005 r. Nr 229, poz.1954, z późn.zm.).</Pouczenie>
	<Oswiadczenie>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za uchybienie obowiązkom płatnika.</Oswiadczenie>
	<Zalaczniki><ea:Section ID="ORD_ZU" runat="server">
    <Zalacznik_ORD-ZU xsi:noNamespaceSchemaLocation="http://e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/ZalacznikiOgolne/ORD-ZU(2)_v1-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	    <Naglowek>
            <KodFormularza kodSystemowy="ORD-ZU (2)">ORD-ZU</KodFormularza>
            <WariantFormularza>2</WariantFormularza>
	    </Naglowek>
	    <PozycjeSzczegolowe>
	        <P_13><ea:XmlDataLabel runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/></P_13>
	    </PozycjeSzczegolowe>
	</Zalacznik_ORD-ZU></ea:Section>	
	</Zalaczniki>
</Deklaracja>
