﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.VAT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Globalization" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Types" %>



<script runat="server">
	Soneta.Deklaracje.VAT.VIIDO_1 dek;

	private struct PozycjaC2
    {
        public string KodKraju { get; set; }
        public string RodzajStawki { get; set; }
        public string Stawka { get; set; }
        public string PodstawaOpodatkowania { get; set; }
        public string KwotaPodatku { get; set; }
    }
	
	private struct PozycjaC3
    {
        public string KodKraju { get; set; }
        public int Rok { get; set; }
        public int Miesiac { get; set; }
        public string KwotaPodatkuZKorekt { get; set; }
    }

	private struct PozycjaC4
    {
        public string KodKraju { get; set; }
        public string PodatekNalezny { get; set; }
    }

	private string PrzytnijString(string tekst)
	{
		if(tekst.Length > 100)
			return tekst.Substring(0,100);
		return tekst;
	}

	void OnContextLoad(Object sender, EventArgs args)
	{
		dek = (Soneta.Deklaracje.VAT.VIIDO_1)dc[typeof(Soneta.Deklaracje.VAT.VIIDO_1)];
		CoreModule core = CoreModule.GetInstance(dc);

		KodUS.EditValue = 1436;
        WariantFormularza.EditValue = 1;
        DataWypelnienia.EditValue = dek.Data.ToString("yyyy-MM-dd");
        NumerIOSS.EditValue = core.Config.Firma.KonfiguracjaOSS.NumerIOSS;
		

        Posrednik.Visible = !string.IsNullOrEmpty(core.Config.Firma.KonfiguracjaOSS.NazwaPosrednika);
		NazwaPosrednika.EditValue = PrzytnijString(core.Config.Firma.KonfiguracjaOSS.NazwaPosrednika);
		NumerIOSSPosrednika.EditValue = core.Config.Firma.KonfiguracjaOSS.NumerIOSSPosrednika;
		NIPPosrednika.EditValue = core.Config.Firma.KonfiguracjaOSS.NIPPosrednika;

		var pozycje = new List<VIIDO_1_Pozycja>();
		var pozycjeC4 = new List<PozycjaC4>();
		Dictionary<string, List<PozycjaC2>> pozycjeC2 = new Dictionary<string, List<PozycjaC2>>();
		Dictionary<string, List<PozycjaC3>> pozycjeC3 = new Dictionary<string, List<PozycjaC3>>();


		string[] nazwa = ((string)dek.Bloki["B"]["Nazwa"]).Split(',');
        if (nazwa.Length > 2)
        {
			string nazwaPodatnika = "";
			if (nazwa.Length > 0)
				nazwaPodatnika += nazwa[0].Trim();
			if (nazwa.Length > 1)
				nazwaPodatnika += " " + nazwa[1].Trim();

			NazwaPelna.EditValue = PrzytnijString(nazwaPodatnika);
        }
        else
        {
            if (nazwa.Length > 0)
                NazwaPelna.EditValue = PrzytnijString(nazwa[0].Trim());
        }

		foreach (Deklaracja z in dek.Deklaracje){
			if (z is VIIDO_1_Pozycja)
				pozycje.Add((VIIDO_1_Pozycja)z);
		}

		foreach(var p in pozycje)
		{

			if(p.Blok == "C2"){
				var kodKraju = GetKodKraju(dek.Session, p.Panstwo);
				if (!pozycjeC2.ContainsKey(kodKraju))
					pozycjeC2.Add(kodKraju, new List<PozycjaC2>());

				pozycjeC2[kodKraju].Add(new PozycjaC2
				{
					KodKraju =  kodKraju,
					RodzajStawki = CaptionAttribute.EnumToString(p.RodzajStawki).ToUpper(),
					Stawka = GetDotSeparator(p.StawkaPodatkuVAT),
					PodstawaOpodatkowania = GetDotSeparator(p.PodstawaOpodatkowania.Value),
					KwotaPodatku = GetDotSeparator(p.KwotaPodatku.Value)
				});
			}

			if(p.Blok == "C3"){
				var kodKraju = GetKodKraju(dek.Session, p.Panstwo);
				if (!pozycjeC3.ContainsKey(kodKraju))
					pozycjeC3.Add(kodKraju, new List<PozycjaC3>());

				pozycjeC3[kodKraju].Add(new PozycjaC3
				{
					KodKraju =  kodKraju,
					Rok = p.Rok,
					Miesiac = p.Miesiac,
					KwotaPodatkuZKorekt = GetDotSeparator(p.KwotaPodatkuZKorekt.Value)
				});
			}
				
		}

		foreach(var p in dek.C4Tablica)
		{
			pozycjeC4.Add(new PozycjaC4
			{
				KodKraju = GetKodKraju(dek.Session, p.Panstwo),
				PodatekNalezny = GetDotSeparator(p.PodatekNalezny.Value)
			});
		}
		SumaPodatek.EditValue = GetDotSeparator(pozycje.Sum(x => x.KwotaPodatku.Value));
		
		C2.DataSource = pozycjeC2;
		C3.DataSource = pozycjeC3;
		C4.DataSource = pozycjeC4;

		PodatekNaleznySuma.EditValue = GetDotSeparator(dek.PodatekNalezny.Value);
		Dostawy.Visible = pozycjeC2.Count != 0;
		Korekty.Visible = pozycjeC3.Count != 0;
		Podatek.Visible = pozycjeC2.Count != 0 || pozycjeC3.Count != 0;
		ZakresDat.Visible = ((Date)dek.Bloki["C1"]["TerminRozpoczecia"]) != Date.Empty && ((Date)dek.Bloki["C1"]["TerminZakonczenia"]) != Date.Empty; 
	}

	private static string GetKodKraju(Session session, string nazwaKraju)
	{
		var krajTbl = session.Get<CoreModule>().KrajeTbl.WgNazwa[nazwaKraju];
		var kodKraju = krajTbl != null ? krajTbl.Kod2 : "";
		if(kodKraju == "GR")
			kodKraju = "EL";

		return kodKraju;
	}

	private static string GetDotSeparator(decimal value)
	{		
		return value.ToString(System.Globalization.CultureInfo.InvariantCulture);
	}
</script>


<ea:datacontext id="dc" runat="server" typename="Soneta.Deklaracje.VAT.VIIDO_1,Soneta.Deklaracje" oncontextload="OnContextLoad" />
<?xml version="1.0" encoding="UTF-8" ?>
<Deklaracja
	xmlns="http://crd.gov.pl/wzor/2021/07/07/10744/"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://crd.gov.pl/wzor/2021/07/07/10744/ http://crd.gov.pl/wzor/2021/07/07/10744/schemat.xsd"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/03/11/eD/DefinicjeTypy/"
	xmlns:oss="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2021/03/12/eD/DefinicjeTypyOss/" >
	<Naglowek>
		<KodFormularza kodSystemowy="VII-DO (1)" kodPodatku="VII" rodzajZobowiazania="Z" wersjaSchemy="1-0E">VII-DO</KodFormularza>


		<ea:XmlDataLabel ID="WariantFormularza" ElementName="WariantFormularza" runat="server" />
		<ea:XmlDataLabel runat="server" ID="DataWypelnienia" ElementName="DataWypelnienia" />
		<CelZlozenia><ea:XmlDataLabel runat="server" DataMember="A.WersjaRobocza"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<Rok><ea:XmlDataLabel runat="server" DataMember="0.Rok" /></Rok>
		<Miesiac><ea:XmlDataLabel runat="server" DataMember="0.Miesiac" /></Miesiac>
		<KodUrzedu><ea:XmlDataLabel runat="server" ID="KodUS" /></KodUrzedu>
	</Naglowek>

	<Podmiot1 rola="Podatnik">
		<ea:Section ID="Podmiot1" runat="server">
			<PodmiotDowolny>
				<ea:XmlDataLabel runat="server" ElementName="IdentyfikatorVAT" ID="NumerIOSS" />
				<ea:XmlDataLabel runat="server" ElementName="NIP" DataMember="B.NIP" XSDType="TNrNIP" />
				<ea:XmlDataLabel runat="server" ElementName="PelnaNazwa" ID="NazwaPelna" XSDType="TZnakowy" />
			</PodmiotDowolny>
		</ea:Section>
	
	</Podmiot1>
	<ea:Section ID="Posrednik" runat="server">
		<Podmiot2 rola="Pośrednik">
				<PodmiotDowolny>
					<ea:XmlDataLabel runat="server" ElementName="IntNumber" ID="NumerIOSSPosrednika" />
					<ea:XmlDataLabel runat="server" ElementName="NIP" ID="NIPPosrednika" XSDType="TNrNIP" />
					<ea:XmlDataLabel runat="server" ElementName="PelnaNazwa" ID="NazwaPosrednika" XSDType="TZnakowy" />
				</PodmiotDowolny>
		</Podmiot2>
	</ea:Section>	
	<PozycjeSzczegolowe>
		<ea:Section ID="ZakresDat" runat="server">
			<Period>
				<ea:XmlDataLabel ElementName="oss:StartDate" runat="server" DataMember="C1.TerminRozpoczecia" XSDType="TData"/>
				<ea:XmlDataLabel ElementName="oss:EndDate" runat="server" DataMember="C1.TerminZakonczenia" XSDType="TData"/>

			</Period>
		</ea:Section>
		<ea:Section ID="Podatek" runat="server">
		<VATReturnMSCON>
			<ea:Section ID="Dostawy" runat="server">
				<Supplies>
					<ea:DataRepeater ID="C2" runat="server" WithSections="False">
						<MSIDSupplies>
							<ea:XmlDataLabel ElementName="MSCONCountryCode" runat="server" DataMember="Key"  />
							<MSIDSupply>
								<ea:DataRepeater runat="server" WithSections="False" DataMember="Value">
										<oss:VATReturnDetail>
											<ea:Section ConditionValue="PODSTAWOWA" DataMember="RodzajStawki" runat="server"><oss:VATRate type="STANDARD"><ea:XmlDataLabel runat="server" DataMember="Stawka"/></oss:VATRate></ea:Section>
											<ea:Section ConditionValue="OBNIŻONA" DataMember="RodzajStawki" runat="server"><oss:VATRate type="REDUCED"><ea:XmlDataLabel runat="server" DataMember="Stawka" /></oss:VATRate></ea:Section>
											<oss:TaxableAmount currency="EUR"><ea:XmlDataLabel runat="server" DataMember="PodstawaOpodatkowania" /></oss:TaxableAmount>
											<oss:VATAmount currency="EUR"><ea:XmlDataLabel runat="server" DataMember="KwotaPodatku"/></oss:VATAmount>
										</oss:VATReturnDetail>
								</ea:DataRepeater>
							</MSIDSupply>
						</MSIDSupplies>
					</ea:DataRepeater>
					<GrandTotal currency="EUR"><ea:XmlDataLabel runat="server" ID="SumaPodatek" /></GrandTotal>
				</Supplies>
			</ea:Section>
			<ea:Section ID="Korekty" runat="server">
				<ea:DataRepeater ID="C3" runat="server" WithSections="False">					
					<Corrections>
							<ea:XmlDataLabel ElementName="MSCONCountryCode" runat="server" DataMember="Key"  />
							<MSCONCorrections>
								<ea:DataRepeater runat="server" WithSections="False" DataMember="Value">									
									<Correction>
										<Period>
											<ea:XmlDataLabel ElementName="Year" runat="server" DataMember="Rok"  />
											<ea:XmlDataLabel ElementName="Month" runat="server" DataMember="Miesiac"  />
										</Period>
										<TotalVATAmountCorrection currency="EUR"><ea:XmlDataLabel runat="server" DataMember="KwotaPodatkuZKorekt"/></TotalVATAmountCorrection>
									</Correction>
								</ea:DataRepeater>
							</MSCONCorrections>
					</Corrections>
				</ea:DataRepeater>
			</ea:Section>
		</VATReturnMSCON>
		</ea:Section>
		<ea:DataRepeater ID="C4" runat="server" WithSections="False">
			<MSCONBalance>
				<ea:XmlDataLabel ElementName="MSCONCountryCode" runat="server" DataMember="KodKraju"  />
				<BalanceOfVATDue currency="EUR"><ea:XmlDataLabel runat="server" DataMember="PodatekNalezny" /></BalanceOfVATDue>
			</MSCONBalance>
		</ea:DataRepeater>
		<TotalAmountOfVATDue currency="EUR"><ea:XmlDataLabel runat="server" ID="PodatekNaleznySuma" /></TotalAmountOfVATDue>

	</PozycjeSzczegolowe>
	<Pouczenie1>Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym.</Pouczenie1>
	<Pouczenie2>W przypadku niewpłacenia w obowiązującym terminie kwoty podatku VAT należnej Rzeczpospolitej Polskiej lub wpłacenia jej w niepełnej wysokości, niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z art. 3a § 1 pkt 1 ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2020 r. poz. 1427, z późn. zm.).</Pouczenie2>

</Deklaracja>
