﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="65001" %>
<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Core" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>NIP-7 (2)</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
		public enum _PrzeznaczenieFormularza {
            ZgłoszenieIdentyfikacyjne, ZgłoszenieAktualizacyjne
        }
        public class Params : ContextBase {
            public readonly PracHistoria historia;
            public Params(Context context)
                : base(context) {
                historia = (PracHistoria)context[typeof(PracHistoria)];
                zgłoszenie = historia.NIP == "";
                foreach (RachunekBankowyPracownika rbp in historia.Pracownik.Rachunki)
                    if (!rbp.Blokada) {
                        rachunek = rbp;
                        break;
                    }
            }
            public bool zgłoszenie;
            [Priority(10)]
            [Caption("Przeznacz.formularza")]
            public _PrzeznaczenieFormularza PrzeznaczenieFormularza {
                get { return zgłoszenie ? _PrzeznaczenieFormularza.ZgłoszenieIdentyfikacyjne : _PrzeznaczenieFormularza.ZgłoszenieAktualizacyjne; }
                set {
                    zgłoszenie = value == _PrzeznaczenieFormularza.ZgłoszenieIdentyfikacyjne;
                    OnChanged(EventArgs.Empty);
                }
            }
            RachunekBankowyPracownika rachunek;
            [Caption("Rachunek bankowy")]
            [Priority(50)]
            public RachunekBankowyPracownika Rachunek {
                get { return rachunek; }
                set {
                    rachunek = value;
                    if (rachunek != null)
                        rezygnacja = false;
                    OnChanged(EventArgs.Empty);
                }
            }
            public LookupInfo.Item GetListRachunek() {
                return Soneta.Kasa.RachBankPodmiot.RachunkiPodmiotuLookup(historia.Pracownik);
            }
            bool rezygnacja;
            [Caption("Rezygnacja")]
            [Priority(60)]
            public bool Rezygnacja {
                get { return rezygnacja; }
                set {
                    rezygnacja = value;
                    OnChanged(EventArgs.Empty);
                }
            }
            public bool IsReadOnlyRezygnacja() {
                return rachunek != null;
            }
        }
		Params info;
        [Context]
        public Params Info {
            set { info = value; }
        }
        void OnContextLoad(object sender, EventArgs e) {
            if (dc.OverPrint) {
                dc.LeftMargin = 6;
                dc.TopMargin = 6;
                dc.PageZoom = "114%";
            }
            if (info.zgłoszenie)
                p5_1.EditValue = true;
            else
                p5_2.EditValue = true;
            if (!info.zgłoszenie) {
                PracHistoria prev = (PracHistoria)info.historia.Pracownik.Historia.GetPrev(info.historia);
                if (prev != null) {
                    zp10.EditValue = string.Compare(prev.Nazwisko, info.historia.Nazwisko, true) != 0;
                    zp12.EditValue = string.Compare(prev.Imie, info.historia.Imie, true) != 0;
                    zp14.EditValue = string.Compare(prev.ImieDrugie, info.historia.ImieDrugie, true) != 0;
                    zp16.EditValue = string.Compare(prev.ImieOjca, info.historia.ImieOjca, true) != 0;
                    zp18.EditValue = string.Compare(prev.ImieMatki, info.historia.ImieMatki, true) != 0;
                    zp20.EditValue = prev.Urodzony.Data!=info.historia.Urodzony.Data;
                    zp22.EditValue = string.Compare(prev.Urodzony.Miejsce, info.historia.Urodzony.Miejsce, true) != 0;
                    zp25.EditValue = string.Compare(prev.NazwiskoRodowe, info.historia.NazwiskoRodowe, true) != 0;
                    zp27.EditValue = prev.Dokument.Rodzaj != info.historia.Dokument.Rodzaj;
                    zp29.EditValue = string.Compare(prev.Dokument.SeriaNumer, info.historia.Dokument.SeriaNumer, true) != 0;
                }
            }
            if (info.Rezygnacja)
                rachunekRezygnacja.EditValue = true;
            else if (info.Rachunek != null) {
                Soneta.Kasa.RachunekBankowy rb = info.Rachunek.Rachunek;
                if (rb.Bank != null) {
                    if (rb.Bank.Adres.Kraj != "" && rb.Bank.Adres.Kraj.ToLower() != "polska")
                        rachunekKraj.EditValue = rb.Bank.Adres.Kraj;
                    rachunekNazwaBanku.EditValue = rb.Bank.Nazwa;
                }
                if (info.Rachunek.Nazwa1 != "")
                    rachunekPosiadacz.EditValue = info.Rachunek.Nazwa1 + ", " + info.Rachunek.Nazwa2;
                else
                    rachunekPosiadacz.EditValue = info.historia.Pracownik.ImięNazwisko + ", " + info.historia.Adres.Linia1 + ", " + info.historia.Adres.Linia2;
                rachunekNumer.EditValue = rb.Numer;
            }
            if (info.historia.AdresDoKorespondencji.Ulica.Length > 0 ||
                info.historia.AdresDoKorespondencji.NrDomu.Length > 0 ||
                info.historia.AdresDoKorespondencji.NrLokalu.Length > 0 ||
                info.historia.AdresDoKorespondencji.Miejscowosc.Length > 0) {
                AdresKrajK.EditValue = info.historia.AdresDoKorespondencji.Kraj;
                AdresWojewodztwoK.EditValue = info.historia.AdresDoKorespondencji.Wojewodztwo;
                AdresPowiatK.EditValue = info.historia.AdresDoKorespondencji.Powiat;
                AdresGminaK.EditValue = info.historia.AdresDoKorespondencji.Gmina;
                AdresUlicaK.EditValue = info.historia.AdresDoKorespondencji.Ulica;
                AdresNrDomuK.EditValue = info.historia.AdresDoKorespondencji.NrDomu;
                AdresNrLokaluK.EditValue = info.historia.AdresDoKorespondencji.NrLokalu;
                AdresMiejscowoscK.EditValue = info.historia.AdresDoKorespondencji.Miejscowosc;
                AdresKodPocztowyK.EditValue = info.historia.AdresDoKorespondencji.KodPocztowy;
                AdresPocztaK.EditValue = info.historia.AdresDoKorespondencji.Poczta;
            }
        }
        static void Msg(object value) {
        }
		    
    </script>
	</HEAD>
	<body leftMargin="0" rightMargin="0">
		<form id="NIP_7_2" method="post" runat="server">
			<ea:deklaracjaheader id="DeklaracjaHeader1" style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 0px"
				runat="server" Width="630px" StylNagłówka="WypałniaSkładającyCRP"></ea:deklaracjaheader>
<ea:framelabel id="FrameLabel21" style="Z-INDEX: 101; LEFT: 0px; POSITION: absolute; TOP: 21px"
				runat="server" Width="273px" ValueStyle="nip_w" DataMember="NIP" Height="28px" 
                Text="1. Identyfikator podatkowy NIP"></ea:framelabel>
<ea:framelabel id="FrameLabel22" style="Z-INDEX: 102; LEFT: 273px; POSITION: absolute; TOP: 21px"
				runat="server" Width="119px" Height="28px" Text="Nr dokumentu" FrameStyle="SmallBoldGray" Number="2"></ea:framelabel>
<ea:framelabel id="FrameLabel23" style="Z-INDEX: 103; LEFT: 392px; POSITION: absolute; TOP: 21px"
				runat="server" Width="77px" Height="30px" Text="Status" FrameStyle="SmallBoldGray" Number="3"></ea:framelabel>
<ea:framelabel id="Framelabel77" style="Z-INDEX: -2; LEFT: 0px; POSITION: absolute; TOP: 49px; height: 50px; width: 629px;"
				runat="server"></ea:frameLabel>
<ea:framelabel id="FrameLabel34" style="Z-INDEX: -1; LEFT: 85px; POSITION: absolute; TOP: 56px; height: 51px;"
				runat="server" Width="525px" 
                Text="ZGŁOSZENIE IDENTYFIKACYJNE/ZGŁOSZENIE AKTUALIZACYJNE &lt;.INDEXUP&gt;1)&lt;./&gt; OSOBY FIZYCZNEJ BĘDĄCEJ PODATNIKIEM LUB PŁATNIKIEM" 
                FrameStyle="BigBold" FrameBorderStyle="None" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="labelPIT" 
                style="Z-INDEX: 104; LEFT: 15px; POSITION: absolute; TOP: 62px; width: 71px; right: 821px;" 
                runat="server" Height="21px" FrameStyle="BigBold" FrameBorderStyle="None" 
                Text="NIP-7"></ea:framelabel>
<ea:framelabel id="FrameLabel24" style="Z-INDEX: 105; LEFT: 0px; POSITION: absolute; TOP: 98px; height: 133px;"
				runat="server" Width="630px" FrameStyle="SmallBoldYellow" 
                FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="Framelabel18" style="Z-INDEX: -2; LEFT: 0px; POSITION: absolute; TOP: 98px; height: 80px; width: 629px;"
				runat="server"></ea:frameLabel>
<ea:framelabel id="FrameLabel28" style="Z-INDEX: 106; LEFT: 7px; POSITION: absolute; TOP: 105px; height: 10px;"
				runat="server" Width="300px" Text="Formularz przeznaczony dla osób fizycznych:"
                FrameStyle="SmallBoldYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel5" style="Z-INDEX: 107; LEFT: 7px; POSITION: absolute; TOP: 120px; height: 62px;"
				runat="server" Width="300px"
                Text="a) niebędących przedsiębiorcami (niepodlegających wpisowi do CEIDG):&lt;br&gt;
                - prowadzących działalność gospodarczą lub&lt;br&gt;
                - podlegających zarejestrowaniu jako podatnicy podatku od towarów i usług lub będących zarejestrowanymi podatnikami podatku od towarów i usług"
                FrameStyle="SmallBoldYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel14" style="Z-INDEX: 108; LEFT: 327px; POSITION: absolute; TOP: 120px; height: 62px;"
				runat="server" Width="300px"
                Text="b) nieprowadzących działalności gospodarczej:&lt;br&gt;
                - będących płatnikami podatku&lt;br&gt;
                - będących płatnikami składek na ubezpieczenia społeczne oraz ubezpieczenia zdrowotne,&lt;br&gt;
                - nieobjętych rejestrem PESEL."
                FrameStyle="SmallBoldYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel25" style="Z-INDEX: 109; LEFT: 7px; POSITION: absolute; TOP: 180px; right: 821px;"
				runat="server" Width="91px" Height="14px" Text="Podstawa prawna:" 
                FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel26" style="Z-INDEX: 112; LEFT: 133px; POSITION: absolute; TOP: 180px"
				runat="server" Width="490px" Height="21px" Text='Ustawa z dnia 13 października 1995 r. o zasadach ewidencji i identyfikacji podatników i płatników (Dz. U. z 2012 r. poz. 1314 oraz<br>
z 2013 r. poz. 2), zwana dalej „ustawą".' FrameStyle="SmallYellow"
				FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel30" style="Z-INDEX: 114; LEFT: 7px; POSITION: absolute; TOP: 200px"
				runat="server" Width="91px" Height="7px" Text="Termin składania:" 
                FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel31" style="Z-INDEX: 115; LEFT: 133px; POSITION: absolute; TOP: 200px; height: 8px;"
				runat="server" Width="490px" Text="Zgodnie z art. 6, 7 i 9 ustawy."
				FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel32" style="Z-INDEX: 116; LEFT: 7px; POSITION: absolute; TOP: 212px"
				runat="server" Width="91px" Height="7px" Text="Miejsce składania:" 
                FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel33" style="Z-INDEX: 117; LEFT: 133px; POSITION: absolute; TOP: 212px; height: 10px;"
				runat="server" Width="490px" Text="Zgłoszenie składa się do naczelnika urzędu skarbowego  właściwego w rozumieniu art.4 ustawy."
				FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel17" style="Z-INDEX: 118; LEFT: 0px; POSITION: absolute; TOP: 230px; height: 238px;"
				runat="server" Width="630px" Text="A. CEL  I MIEJSCE ZŁOŻENIA ZGŁOSZENIA&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;
                Jeżeli w poz.4 nie zaznaczono kwadratu nr 1 lub 2 należy pominąć część C. W poz.5 należy zaznaczyć kwadrat nr 1: gdy formularz jest
                składany jako zgłoszenie identyfikacyjne, w celu nadania NIP albo kwadrat nr 2: gdy formularz jest składany jako zgłoszenie aktualizacyjne,
                w przypadku zmiany danych objętych zgłoszeniem, tzn. zmiany danych składającego lub zmiany naczelnego urzędu skarbowego właściwego
                w sprawach ewidencji. W przypadku zgłoszenia aktualizacyjnego wystarczy wypełnić poz. 1 oraz części A, B.1. (poz. 8, 10, 18 i 29), B.3., B.5., D,
                i E, a także inne pozycje, gdy dane się zmieniły."
                FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="Framelabel19" style="Z-INDEX: 120; LEFT: 28px; POSITION: absolute; TOP: 300px; width: 601px;"
				runat="server" Height="105px" 
                Text="Status ewidencyjny &lt;.Normal&gt;(zaznaczyć właściwy kwadrat lub kwadraty):&lt;./&gt;" 
                Number="4"></ea:frameLabel>
<ea:checklabel id="p4_1" style="Z-INDEX: 121; LEFT: 33px; POSITION: absolute; TOP: 310px"
				runat="server" Width="600px" DataMember="" Height="14px" Text="Osoba prowadząca działalność gospodarczą" 
                Number="1" NumberAlignLeft="False"></ea:checklabel>
<ea:checklabel id="p4_2" style="Z-INDEX: 122; LEFT: 33px; POSITION: absolute; TOP: 328px"
				runat="server" Width="600px" DataMember="" Height="14px" Text="Osoba podlegająca zarejestrowaniu jako podatnik podatku od towarów i usług lub będąca zarejestrowanym podatnikiem podatku od towarów i usług" 
                Number="2" NumberAlignLeft="False"></ea:checklabel>
<ea:checklabel id="p4_3" style="Z-INDEX: 123; LEFT: 33px; POSITION: absolute; TOP: 346px"
				runat="server" Width="600px" DataMember="" Height="14px" Text="Płatnik podatków" 
                Number="3" NumberAlignLeft="False"></ea:checklabel>
<ea:checklabel id="p4_4" style="Z-INDEX: 124; LEFT: 33px; POSITION: absolute; TOP: 364px"
				runat="server" Width="600px" DataMember="" Height="14px" Text="Płatnik składek na ubezpieczenia społeczne oraz ubezpieczenia zdrowotne" 
                Number="4" NumberAlignLeft="False"></ea:checklabel>
<ea:checklabel id="p4_5" style="Z-INDEX: 125; LEFT: 33px; POSITION: absolute; TOP: 382px"
				runat="server" Width="600px" DataMember="" Height="14px" Text="Podatnik nieobjęty rejestrem PESEL" 
                Number="5" NumberAlignLeft="False"></ea:checklabel>
<ea:framelabel id="Framelabel147" style="Z-INDEX: 126; LEFT: 28px; POSITION: absolute; TOP: 405px; width: 601px;"
				runat="server" Height="28px" 
                Text="Przeznaczenie formularza &lt;.Normal&gt;(zaznaczyć właściwy kwadrat):&lt;./&gt;" 
                Number="5"></ea:frameLabel>
<ea:checklabel id="p5_1" style="Z-INDEX: 127; LEFT: 33px; POSITION: absolute; TOP: 412px; right: 751px;"
				runat="server" Width="136px" Height="14px" Text="Zgłoszenie identyfikacyjne" 
                Number="1" NumberAlignLeft="False">
            </ea:checkLabel>
<ea:checklabel id="p5_2" style="Z-INDEX: 128; LEFT: 163px; POSITION: absolute; TOP: 412px"
				runat="server" Width="136px" Height="14px" Text="Zgłoszenie aktualizacyjne" Number="2" 
                NumberAlignLeft="False">
            </ea:checkLabel>
<ea:framelabel id="p6" style="Z-INDEX: 129; LEFT: 28px; POSITION: absolute; TOP: 433px; width: 601px;"
				runat="server" Height="28px" 
                Text="Naczelnik urzędu skarbowego, do którego jest adresowane zgłoszenie" Number="6" 
                DataMember="Podatki.UrzadSkarbowy.Nazwa">
            </ea:framelabel>
<ea:framelabel id="FrameLabel1" style="Z-INDEX: 134; LEFT: 0px; POSITION: absolute; TOP: 468px"
				runat="server" Width="630px" Height="28px" Text="B. DANE SKŁADAJĄCEGO" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel2" style="Z-INDEX: 135; LEFT: 0px; POSITION: absolute; TOP: 496px; height: 243px;"
				runat="server" Width="630px" Text="B.1. DANE IDENTYFIKACYJNE&lt;/font&gt;&lt;.Footer&gt;
                - w przypadku osób fizycznych objętych rejestrem PESEL źródłem ich danych jest rejestr PESEL, a
                poniżej - w celu prawidłowej identyfikacji - należy wypełnić jedynie poz. 7, 8, 10. W przypadku osób nieobjętych rejestrem PESEL (w poz.4
                zaznaczony kwadrat nr 5) dla wskazania zmiany danych należy zaznaczyć odpowiedni kwadrat."
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel3" style="Z-INDEX: 136; LEFT: 28px; POSITION: absolute; TOP: 545px; width: 231px; right: 688px;"
				runat="server" Height="28px" Text="Numer PESEL &lt;.INDEXUP&gt;2)" Number="7" 
                DataMember="PESEL"></ea:framelabel>
<ea:framelabel id="FrameLabel4" style="Z-INDEX: 137; LEFT: 259px; POSITION: absolute; TOP: 545px; height: 28px; width: 310px;"
				runat="server" DataMember="Nazwisko" Text="Nazwisko" Number="8"></ea:framelabel>
<ea:framelabel id="FrameLabel20" style="Z-INDEX: 138; LEFT: 567px; POSITION: absolute; TOP: 545px; height: 28px; width: 60px;"
				runat="server" DataMember="" Text="Zmiana w poz.8" Number="9"></ea:framelabel>
<ea:checklabel id="zp10" style="Z-INDEX: 139; LEFT: 605px; POSITION: absolute; TOP: 552px; width: 23px;"
				runat="server" Height="14px"></ea:checklabel>
<ea:framelabel id="FrameLabel6" style="Z-INDEX: 140; LEFT: 28px; POSITION: absolute; TOP: 573px; right: 751px; width: 231px;"
				runat="server" DataMember="Imie" Height="28px" Text="Pierwsze imię" Number="10"></ea:framelabel>
<ea:framelabel id="FrameLabel27" style="Z-INDEX: 141; LEFT: 259px; POSITION: absolute; TOP: 573px; height: 28px; width: 60px;"
				runat="server" DataMember="" Text="Zmiana w poz.10" Number="11"></ea:framelabel>
<ea:checklabel id="zp12" style="Z-INDEX: 142; LEFT: 297px; POSITION: absolute; TOP: 580px; width: 23px;"
				runat="server" Height="14px"></ea:checklabel>
<ea:framelabel id="FrameLabel7" style="Z-INDEX: 142; LEFT: 322px; POSITION: absolute; TOP: 573px; width: 245px;"
				runat="server" DataMember="ImieDrugie" Height="28px" Text="Drugie imię" Number="12"></ea:framelabel>
<ea:framelabel id="FrameLabel29" style="Z-INDEX: 143; LEFT: 567px; POSITION: absolute; TOP: 573px; height: 28px; width: 60px;"
				runat="server" DataMember="" Text="Zmiana w poz.12" Number="13"></ea:framelabel>
<ea:checklabel id="zp14" style="Z-INDEX: 144; LEFT: 605px; POSITION: absolute; TOP: 580px; width: 23px;"
				runat="server" Height="14px"></ea:checklabel>
<ea:framelabel id="FrameLabel9" style="Z-INDEX: 145; LEFT: 28px; POSITION: absolute; TOP: 601px; width: 231px;"
				runat="server" DataMember="ImieOjca" Height="28px" Text="Imię ojca" Number="14"></ea:framelabel>
<ea:framelabel id="FrameLabel35" style="Z-INDEX: 146; LEFT: 259px; POSITION: absolute; TOP: 601px; height: 28px; width: 60px;"
				runat="server" DataMember="" Text="Zmiana w poz.14" Number="15"></ea:framelabel>
<ea:checklabel id="zp16" style="Z-INDEX: 147; LEFT: 297px; POSITION: absolute; TOP: 608px; width: 23px;"
				runat="server" Height="14px"></ea:checklabel>
<ea:framelabel id="FrameLabel8" style="Z-INDEX: 148; LEFT: 322px; POSITION: absolute; TOP: 601px; width: 245px; right: 289px;"
				runat="server" DataMember="ImieMatki" Height="28px" Text="Imię matki" Number="16"></ea:framelabel>
<ea:framelabel id="FrameLabel36" style="Z-INDEX: 149; LEFT: 567px; POSITION: absolute; TOP: 601px; height: 28px; width: 60px;"
				runat="server" DataMember="" Text="Zmiana w poz.16" Number="17"></ea:framelabel>
<ea:checklabel id="zp18" style="Z-INDEX: 150; LEFT: 605px; POSITION: absolute; TOP: 608px; width: 23px;"
				runat="server" Height="14px"></ea:checklabel>
<ea:framelabel id="Framelabel105" style="Z-INDEX: 151; LEFT: 28px; POSITION: absolute; TOP: 629px; width: 231px; right: 609px;"
				runat="server" ValueStyle="Date" DataMember="Urodzony.Data" Height="28px" 
                Text="Data urodzenia" Number="18"></ea:framelabel>
<ea:framelabel id="FrameLabel37" style="Z-INDEX: 152; LEFT: 259px; POSITION: absolute; TOP: 629px; height: 28px; width: 60px;"
				runat="server" DataMember="" Text="Zmiana w poz.18" Number="19"></ea:framelabel>
<ea:checklabel id="zp20" style="Z-INDEX: 153; LEFT: 297px; POSITION: absolute; TOP: 636px; width: 23px;"
				runat="server" Height="14px"></ea:checklabel>
<ea:framelabel id="Framelabel103" style="Z-INDEX: 154; LEFT: 322px; POSITION: absolute; TOP: 629px; width: 245px;"
				runat="server" DataMember="Urodzony.Miejsce" Height="28px" Number="20" 
                Text="Miejsce (miejscowość) urodzenia"></ea:framelabel>
<ea:framelabel id="FrameLabel38" style="Z-INDEX: 155; LEFT: 567px; POSITION: absolute; TOP: 629px; height: 28px; width: 60px;"
				runat="server" DataMember="" Text="Zmiana w poz.20" Number="21"></ea:framelabel>
<ea:checklabel id="zp22" style="Z-INDEX: 156; LEFT: 605px; POSITION: absolute; TOP: 636px; width: 23px;"
				runat="server" Height="14px"></ea:checklabel>
<ea:framelabel id="FrameLabel10" style="Z-INDEX: 157; LEFT: 28px; POSITION: absolute; TOP: 657px; width: 231px;"
				runat="server" Height="28px" Text="Płeć &lt;.Normal&gt;(zaznaczyć właściwy kwadrat):" 
                Number="22"></ea:framelabel>
<ea:checklabel id="p24_2" style="Z-INDEX: 158; LEFT: 141px; POSITION: absolute; TOP: 664px"
				runat="server" Width="136px" DataMember="Plec" Height="14px" Text="mężczyzna" 
                Number="2" NumberAlignLeft="False" ComparedValue="Mężczyzna"></ea:checkLabel>
<ea:checklabel id="p24_1" style="Z-INDEX: 159; LEFT: 34px; POSITION: absolute; TOP: 664px; right: 761px;"
				runat="server" Width="136px" Height="14px" Text="kobieta" Number="1" 
                NumberAlignLeft="False" ComparedValue="Kobieta" DataMember="Plec"></ea:checkLabel>
<ea:framelabel id="FrameLabel11" style="Z-INDEX: 160; LEFT: 259px; POSITION: absolute; TOP: 657px; width: 310px;"
				runat="server" DataMember="NazwiskoRodowe" Height="28px" Text="Nazwisko rodowe (według aktu urodzenia)" 
                Number="23"></ea:framelabel>
<ea:framelabel id="FrameLabel39" style="Z-INDEX: 161; LEFT: 567px; POSITION: absolute; TOP: 657px; height: 28px; width: 60px;"
				runat="server" DataMember="" Text="Zmiana w poz.23" Number="24"></ea:framelabel>
<ea:checklabel id="zp25" style="Z-INDEX: 162; LEFT: 605px; POSITION: absolute; TOP: 664px; width: 23px;"
				runat="server" Height="14px"></ea:checklabel>
<ea:framelabel id="FrameLabel13" style="Z-INDEX: 163; LEFT: 28px; POSITION: absolute; TOP: 685px; bottom: 363px;"
				runat="server" Width="231px" DataMember="Dokument.Rodzaj" Height="28px" 
                Text="Rodzaj dokumentu stwierdzającego tożsamość" Number="25">
    <ValuesMap><ea:ValuesPair Key="Niezdefiniowany" Value="" /></ValuesMap>
</ea:framelabel>
<ea:framelabel id="FrameLabel40" style="Z-INDEX: 164; LEFT: 259px; POSITION: absolute; TOP: 685px; height: 28px; width: 60px;"
				runat="server" DataMember="" Text="Zmiana w poz.25" Number="26"></ea:framelabel>
<ea:checklabel id="zp27" style="Z-INDEX: 165; LEFT: 297px; POSITION: absolute; TOP: 692px; width: 23px;"
				runat="server" Height="14px"></ea:checklabel>
<ea:framelabel id="FrameLabel12" style="Z-INDEX: 166; LEFT: 322px; POSITION: absolute; TOP: 685px; width: 245px;"
				runat="server" DataMember="Dokument.SeriaNumer" Height="28px" 
                Text="Seria i numer dokumentu stwierdzającego tożsamość" 
                Number="27"></ea:framelabel>
<ea:framelabel id="FrameLabel42" style="Z-INDEX: 167; LEFT: 567px; POSITION: absolute; TOP: 685px; height: 28px; width: 60px;"
				runat="server" DataMember="" Text="Zmiana w poz.27" Number="28"></ea:framelabel>
<ea:checklabel id="zp29" style="Z-INDEX: 168; LEFT: 605px; POSITION: absolute; TOP: 692px; width: 23px;"
				runat="server" Height="14px"></ea:checklabel>
<ea:framelabel id="FrameLabel15" style="Z-INDEX: 169; LEFT: 28px; POSITION: absolute; TOP: 713px; width: 601px;"
				runat="server" DataMember="Obywatelstwo.Nazwa" Height="28px" Text="Obywatelstwo &lt;.Normal&gt;(należy podać wszystkie obywatelstwa posiadane w dniu składania zgłoszenia)" 
                Number="29" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel81" style="Z-INDEX: 170; LEFT: 0px; POSITION: absolute; TOP: 741px; height: 82px;"
				runat="server" Width="630px" 
                Text="B.2. INFORMACJA O NUMERACH IDENTYFIKACYJNYCH UZYSKANYCH W INNYCH KRAJACH&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Należy wypełnić tylko wówczas, gdy składający uzyskał numery służące identyfikacji dla celów podatkowych lub ubezpieczeń społecznych w
                innych krajach. W przypadku braku miejsca na wpisanie dalszych informacji należy sporządzić listę tych informacji odpowiednio, zgodnie z zakresem danych określonych w części B.2. (poz. 30-32). Składając formularz za pomocą środków komunikacji elektronicznej
                nie zachodzi potrzeba dołączania listy." 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel102" style="Z-INDEX: 171; LEFT: 28px; POSITION: absolute; TOP: 797px; width: 134px; right: 736px;"
				runat="server" DataMember="Obywatelstwo.KrajDokumentu" Height="28px" Text="Kraj" 
                Number="30"></ea:framelabel>
<ea:framelabel id="Framelabel84" style="Z-INDEX: 172; LEFT: 161px; POSITION: absolute; TOP: 797px; width: 166px;"
				runat="server" DataMember="Obywatelstwo.NumerPodatnika" Height="28px" Text="Numer" Number="31">
                </ea:frameLabel>
<ea:framelabel id="Framelabel41" style="Z-INDEX: 173; LEFT: 329px; POSITION: absolute; TOP: 797px; width: 300px; right: 736px;"
				runat="server" DataMember="" Height="28px" Text="Powód zgłoszenia (zaznaczyć właściwy kwadrat):" Number="32"></ea:framelabel>
<ea:checklabel id="p34_1" style="Z-INDEX: 174; LEFT: 360px; POSITION: absolute; TOP: 805px"
				runat="server" Width="136px" DataMember="" Height="14px" Text="numer aktualny" 
                Number="1" NumberAlignLeft="False"></ea:checkLabel>
<ea:checklabel id="p34_2" style="Z-INDEX: 175; LEFT: 460px; POSITION: absolute; TOP: 805px; right: 761px;"
				runat="server" Width="136px" DataMember="" Height="14px" Text="numer nieaktualny"
                Number="2" NumberAlignLeft="False"></ea:checkLabel>
<ea:framelabel id="FrameLabel182" style="Z-INDEX: 176; LEFT: 0px; POSITION: absolute; TOP: 830px; height: 21px;"
				runat="server" Width="630px" Text="1) Niniejszy formularz może być składany w charakterze zgłoszenia identyfikacyjnego lub zgłoszenia aktualizacyjnego.  W zgłoszeniu aktualizacyjnym&lt;br&gt;należy podać NIP składającego (poz.1)."
				FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel183" style="Z-INDEX: 177; LEFT: 0px; POSITION: absolute; TOP: 850px; height: 21px;"
				runat="server" Width="630px" Text="2) Numer PESEL należy wypełnić wyłącznie w przypadku zgłoszenia identyfikacyjnego lub pierwszego zgłoszenia po uzyskaniu numeru PESEL."
				FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:deklaracjafooter id="footer1" 
                style="Z-INDEX: 178; LEFT: 490px; POSITION: absolute; TOP: 930px" runat="server"
				Width="154px" Height="10px" TitleWidth="106" Symbol="NIP-7" PageNumber="1" 
                PageTotal="4" Version="2"></ea:deklaracjafooter>
<ea:deklaracjaheader id="DeklaracjaHeader2" style="Z-INDEX: 179; LEFT: 0px; POSITION: absolute; TOP: 980px"
				runat="server" Width="630px" StylNagłówka="WypałniaSkładającyCRP"></ea:deklaracjaheader>
<ea:framelabel id="Framelabel101" style="Z-INDEX: 180; LEFT: 0px; POSITION: absolute; TOP: 1001px; height: 108px;"
				runat="server" Width="630px" Text="B.3. ADRES MIEJSCA ZAMIESZKANIA" 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel106" style="Z-INDEX: 181; LEFT: 28px; POSITION: absolute; TOP: 1022px"
				runat="server" Width="140px" DataMember="Adres.Kraj" Height="28px" Text="Kraj" 
                Number="33" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel107" style="Z-INDEX: 182; LEFT: 168px; POSITION: absolute; TOP: 1022px"
				runat="server" Width="266px" DataMember="Adres.Wojewodztwo" Height="28px" 
                Text="Województwo" Number="34"></ea:framelabel>
<ea:framelabel id="Framelabel108" style="Z-INDEX: 183; LEFT: 434px; POSITION: absolute; TOP: 1022px"
				runat="server" Width="196px" DataMember="Adres.Powiat" Height="28px" Text="Powiat" 
                Number="35"></ea:framelabel>
<ea:framelabel id="Framelabel109" style="Z-INDEX: 184; LEFT: 28px; POSITION: absolute; TOP: 1050px"
				runat="server" Width="161px" DataMember="Adres.Gmina" Height="28px" Text="Gmina" 
                Number="36"></ea:framelabel>
<ea:framelabel id="Framelabel110" style="Z-INDEX: 185; LEFT: 189px; POSITION: absolute; TOP: 1050px"
				runat="server" Width="301px" DataMember="Adres.Ulica" Height="28px" Text="Ulica" 
                Number="37"></ea:framelabel>
<ea:framelabel id="Framelabel111" style="Z-INDEX: 186; LEFT: 490px; POSITION: absolute; TOP: 1050px"
				runat="server" Width="70px" DataMember="Adres.NrDomu" Height="28px" Text="Nr domu" 
                Number="38"></ea:framelabel>
<ea:framelabel id="Framelabel112" style="Z-INDEX: 187; LEFT: 560px; POSITION: absolute; TOP: 1050px"
				runat="server" Width="70px" DataMember="Adres.NrLokalu" Height="28px" Text="Nr lokalu" 
                Number="39"></ea:framelabel>
<ea:framelabel id="Framelabel113" style="Z-INDEX: 188; LEFT: 28px; POSITION: absolute; TOP: 1078px; right: 639px;"
				runat="server" Width="252px" DataMember="Adres.Miejscowosc" Height="28px" Text="Miejscowość" 
                Number="40"></ea:framelabel>
<ea:framelabel id="Framelabel114" style="Z-INDEX: 189; LEFT: 280px; POSITION: absolute; TOP: 1078px; "
				runat="server" Width="105px" ValueStyle="PostalCode" DataMember="Adres.KodPocztowy" 
                Height="28px" Text="Kod pocztowy" Number="41" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel115" style="Z-INDEX: 190; LEFT: 385px; POSITION: absolute; TOP: 1078px; height: 30px;"
				runat="server" Width="245px" DataMember="Adres.Poczta" Text="Poczta" Number="42"></ea:framelabel>
<ea:framelabel id="Framelabel148" style="Z-INDEX: 180; LEFT: 0px; POSITION: absolute; TOP: 1106px; height: 126px;"
				runat="server" Width="630px" Text="B.4. ADRES DO KORESPONDENCJI&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Należy wypełnić tylko wówczas, gdy adres do korespondecji jest inny niż w części B.3. Wpisane niżej dane dotyczące adresu
                do korespondencji aktualizują poprzedni stan danych." 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 181; LEFT: 28px; POSITION: absolute; TOP: 1148px"
				runat="server" Width="140px" ID="AdresKrajK" Height="28px" Text="Kraj" 
                Number="43" CssClass="style1"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 182; LEFT: 168px; POSITION: absolute; TOP: 1148px"
				runat="server" Width="266px" ID="AdresWojewodztwoK" Height="28px" 
                Text="Województwo" Number="44"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 183; LEFT: 434px; POSITION: absolute; TOP: 1148px"
				runat="server" Width="196px" ID="AdresPowiatK" Height="28px" Text="Powiat" 
                Number="45"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 184; LEFT: 28px; POSITION: absolute; TOP: 1176px"
				runat="server" Width="161px" ID="AdresGminaK" Height="28px" Text="Gmina" 
                Number="46"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 185; LEFT: 189px; POSITION: absolute; TOP: 1176px"
				runat="server" Width="301px" ID="AdresUlicaK" Height="28px" Text="Ulica" 
                Number="47"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 186; LEFT: 490px; POSITION: absolute; TOP: 1176px"
				runat="server" Width="70px" ID="AdresNrDomuK" Height="28px" Text="Nr domu" 
                Number="48"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 187; LEFT: 560px; POSITION: absolute; TOP: 1176px"
				runat="server" Width="70px" ID="AdresNrLokaluK" Height="28px" Text="Nr lokalu" 
                Number="49"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 188; LEFT: 28px; POSITION: absolute; TOP: 1204px; right: 639px;"
				runat="server" Width="252px" ID="AdresMiejscowoscK" Height="28px" Text="Miejscowość" 
                Number="50"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 189; LEFT: 280px; POSITION: absolute; TOP: 1204px; "
				runat="server" Width="105px" ValueStyle="PostalCode" ID="AdresKodPocztowyK" 
                Height="28px" Text="Kod pocztowy" Number="51" CssClass="style1"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 190; LEFT: 385px; POSITION: absolute; TOP: 1204px; height: 30px;"
				runat="server" Width="245px" ID="AdresPocztaK" Text="Poczta" Number="52"></ea:framelabel>
<ea:framelabel id="FrameLabel161" style="Z-INDEX: -1; LEFT: 0px; POSITION: absolute; TOP: 1232px; height: 80px;"
				runat="server" Width="630px" Text="B.5. KONTAKT" FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel163" style="Z-INDEX: 191; LEFT: 28px; POSITION: absolute; TOP: 1253px; width: 599px;"
				runat="server" DataMember="Adres.Telefon" Height="28px" Text="Telefon" 
                Number="53"></ea:framelabel>
<ea:framelabel id="Framelabel164" style="Z-INDEX: 192; LEFT: 28px; POSITION: absolute; TOP: 1281px; right: 632px; width: 258px;"
				runat="server" DataMember="Adres.Faks" Height="28px" Text="Faks" 
                Number="54"></ea:framelabel>
<ea:framelabel id="Framelabel165" style="Z-INDEX: 193; LEFT: 287px; POSITION: absolute; TOP: 1281px; right: 534px; width: 343px;"
				runat="server" DataMember="Kontakt.EMAIL" 
                Height="28px" Text="E-mail" Number="55"></ea:framelabel>
<ea:framelabel id="FrameLabel162" style="Z-INDEX: -1; LEFT: 0px; POSITION: absolute; TOP: 1309px; height: 166px; right: 289px;"
				runat="server" Width="630px" Text="B.6. OSOBISTY RACHUNEK DO ZWROTU NADPŁATY LUB PODATKU&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Podanie informacji o rachunku (poz. 56-59) nie jest obowiązkowe, jeżeli składający nie wybiera tej formy zwrotu nadpłaty podatku. Na wskazany rachunek będą dokonywane ewentualne zwroty nadpłaty lub podatku. Można podać jedynie taki rachunek, którego właścicielem lub współwłaścicielem jest składający. Wpisane niżej dane dotyczące rachunku aktualizują poprzedni stan danych. W przypadku zgłoszenia aktualizacyjnego, jeżeli dane zawarte w części B.6 nie zmieniły się, to część B.6 formularza nie musi być wypełniona. Zaznaczenie kwadratu w poz.60 oznacza rezygnację przez składającego 
                z otrzymywania ewentualnego zwrotu nadpłaty lub podatku na rachunek osobisty (również z powodu likwidacji rachunku). Kraj siedziby banku (oddziału) (poz.56) należy podać, gdy rachunek jest prowadzony za granicą." 
                FrameStyle="BigYellow" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="rachunekKraj" style="Z-INDEX: 194; LEFT: 28px; POSITION: absolute; TOP: 1387px; right: 632px; width: 258px;"
				runat="server" Height="28px" Text="Kraj siedziby banku (oddziału)" 
                Number="56"></ea:framelabel>
<ea:framelabel id="rachunekNazwaBanku" style="Z-INDEX: 195; LEFT: 287px; POSITION: absolute; TOP: 1387px; right: 534px; width: 343px;"
				runat="server" 
                Height="28px" Text="Pełna nazwa banku (oddziału) / SKOK" Number="57"></ea:framelabel>
<ea:framelabel id="rachunekPosiadacz" style="Z-INDEX: 196; LEFT: 28px; POSITION: absolute; TOP: 1415px; width: 599px;"
				runat="server" Height="28px" Text="Posiadacz rachunku" 
                Number="58"></ea:framelabel>
<ea:framelabel id="rachunekNumer" style="Z-INDEX: 197; LEFT: 28px; POSITION: absolute; TOP: 1443px; width: 530px;"
				runat="server" Height="28px" Text="Pełny numer rachunku" 
                Number="59"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 198; LEFT: 560px; POSITION: absolute; TOP: 1443px"
				runat="server" Width="70px" Height="28px" Text="Rezygnacja" 
                Number="60"></ea:framelabel>
<ea:checklabel id="rachunekRezygnacja" style="Z-INDEX: 199; LEFT: 585px; POSITION: absolute; TOP: 1452px; right: 382px;"
				runat="server" Width="35px" Height="14px"></ea:checklabel>
<ea:framelabel id="FrameLabel16" style="Z-INDEX: 200; LEFT: 0px; POSITION: absolute; TOP: 1478px"
				runat="server" Width="630px" Height="32px" Text="C. DANE DOTYCZĄCE PROWADZONEJ SAMODZIELNIE DZIAŁALNOŚCI&lt;br&gt;GOSPODARCZEJ PRZEZ OSOBY FIZYCZNE - NIEBĘDĄCE PRZEDSIĘBIORCAMI" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel43" style="Z-INDEX: 201; LEFT: 0px; POSITION: absolute; TOP: 1513px; height: 198px;"
				runat="server" Width="630px" Text="C.1. DATY DOTYCZĄCE PROWADZONEJ DZIAŁALNOŚCI ORAZ JEJ ZAKOŃCZENIA, NUMER IDENTYFIKACYJNY REGON, RODZAJ DZIAŁALNOŚCI, STATUS SZCZEGÓLNY DZIAŁALNOŚCI"
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel44" style="Z-INDEX: 202; LEFT: 28px; POSITION: absolute; TOP: 1548px; width: 330px;"
				runat="server" Height="28px" Text="Rodzaj daty (zaznaczyć właściwy kwadrat):" 
                Number="61"></ea:framelabel>
<ea:checklabel id="p53_1" style="Z-INDEX: 203; LEFT: 43px; POSITION: absolute; TOP: 1555px; right: 382px;"
				runat="server" Width="130px" Text="rozpoczęcie działalności" Height="14px"
                Number="1" NumberAlignLeft="False"></ea:checklabel>
<ea:checklabel id="p53_2" style="Z-INDEX: 203; LEFT: 183px; POSITION: absolute; TOP: 1555px; right: 382px;"
				runat="server" Width="130px" Text="zakończenie działalności" Height="14px"
                Number="2" NumberAlignLeft="False"></ea:checklabel>
<ea:framelabel id="Framelabel45" style="Z-INDEX: 204; LEFT: 357px; POSITION: absolute; TOP: 1548px; width: 270px;"
				runat="server" Height="28px" Text="Data" ValueStyle="Date" Number="62"></ea:framelabel>
<ea:framelabel id="Framelabel46" style="Z-INDEX: 205; LEFT: 28px; POSITION: absolute; TOP: 1576px; width: 601px;"
				runat="server" Height="28px" Text="REGON" Number="63"></ea:framelabel>
<ea:framelabel id="Framelabel47" style="Z-INDEX: 206; LEFT: 28px; POSITION: absolute; TOP: 1604px; width: 500px;"
				runat="server" Height="80px" Text="Rodzaj przeważającej działalności (należy podać rodzaj przeważającej działalności gospodarczej, w przypadku
                rozpoczynających - rodzaj planowanej działalności, według Polskiej Klasyfikacji Działalności (PKD)) &lt;.INDEXUP&gt;3)"
                Number="64"></ea:framelabel>
<ea:framelabel id="Framelabel48" style="Z-INDEX: 207; LEFT: 525px; POSITION: absolute; TOP: 1604px; width: 105px;"
				runat="server" Height="80px" Text="Kod PKD" Number="65"></ea:framelabel>
<ea:framelabel id="Framelabel49" style="Z-INDEX: 208; LEFT: 28px; POSITION: absolute; TOP: 1681px; width: 601px;"
				runat="server" Height="28px" Text="Status szczególny działalności (zaznaczyć właściwe kwadraty):"
                Number="66"></ea:framelabel>
<ea:checklabel id="p58_1" style="Z-INDEX: 209; LEFT: 43px; POSITION: absolute; TOP: 1688px; right: 382px;"
				runat="server" Width="180px" Text="prowadzi zakład pracy chronionej" Height="14px"
                Number="1" NumberAlignLeft="False"></ea:checklabel>
<ea:checklabel id="p58_2" style="Z-INDEX: 210; LEFT: 197px; POSITION: absolute; TOP: 1688px; right: 382px;"
				runat="server" Width="180px" Text="nie prowadzi zakładu pracy chronionej" Height="14px"
                Number="2" NumberAlignLeft="False"></ea:checklabel>
<ea:checklabel id="p58_3" style="Z-INDEX: 211; LEFT: 368px; POSITION: absolute; TOP: 1688px; right: 382px;"
				runat="server" Width="280px" Text="prowadzi zagraniczne przedsiębiorstwo drobnej wytwórczości" Height="14px"
                Number="3" NumberAlignLeft="False"></ea:checklabel>
<ea:framelabel id="FrameLabel51" style="Z-INDEX: 212; LEFT: 0px; POSITION: absolute; TOP: 1720px; height: 50px;"
				runat="server" Width="630px" Text="3) Przeważającą działalność ustala się zgodnie z $10 ust.2 rozporządzenia Rady Ministrów z dnia 27 lipca 1999 r. w sprawie sposobu i metodologii
                prowadzenia i aktualizacji rejestru podmiotów gospodarki narodowej, w tym wzorów wniosków, ankiet i zaświadczeń oraz szczegółowych
                warunków i trybu współdziałania służb statystyki publicznej z innymi organami prowadzącymi urzędowe rejestry i systemy informacyjne
                administracji publicznej (Dz.U. Nr 69, poz.763, z późn.zm.)."
				FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:deklaracjafooter id="footer2" 
                style="Z-INDEX: 213; LEFT: 0px; POSITION: absolute; TOP: 1900px" runat="server"
				Width="154px" Height="10px" TitleWidth="106" Symbol="NIP-7" PageNumber="2" 
                PageTotal="4" Version="2"></ea:deklaracjafooter>
<ea:deklaracjaheader id="DeklaracjaHeader3" style="Z-INDEX: 214; LEFT: 0px; POSITION: absolute; TOP: 1960px"
				runat="server" Width="630px" StylNagłówka="WypałniaSkładającyCRP"></ea:deklaracjaheader>
<ea:framelabel id="FrameLabel56" style="Z-INDEX: 215; LEFT: 0px; POSITION: absolute; TOP: 1981px"
				runat="server" Width="630px" Height="32px" Text="C.2. RACHUNKI ZWIĄZANE Z DZIAŁALNOŚCIĄ GOSPODARCZĄ&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Kraj siedziby banku (oddziału) należy podać, gdy rachunek jest prowadzony za granicą." 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel50" style="Z-INDEX: -1; LEFT: 0px; POSITION: absolute; TOP: 2016px; height: 166px; right: 289px;"
				runat="server" Width="630px" Text="C.2.1. RACHUNEK, NA KTÓRY BĘDZIE DOKONYWANY ZWROT PODATKU&lt;/font&gt;&lt;.Footer&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;W przypadku gdy następuje zmiana rachunku bankowego, na którym będzie dokonywany zwrot podatku, należy w poz.71 podać numer
                rachunku poprzednio wskazanego do zwrotów." 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel52" style="Z-INDEX: 216; LEFT: 28px; POSITION: absolute; TOP: 2040px; right: 632px; width: 258px;"
				runat="server" Height="28px" Text="Kraj siedziby banku (oddziału)" 
                Number="67"></ea:framelabel>
<ea:framelabel id="Framelabel53" style="Z-INDEX: 217; LEFT: 287px; POSITION: absolute; TOP: 2040px; right: 534px; width: 343px;"
				runat="server" 
                Height="28px" Text="Pełna nazwa banku (oddziału) / SKOK" Number="68"></ea:framelabel>
<ea:framelabel id="Framelabel54" style="Z-INDEX: 218; LEFT: 28px; POSITION: absolute; TOP: 2068px; width: 599px;"
				runat="server" Height="28px" Text="Posiadacz rachunku" 
                Number="69"></ea:framelabel>
<ea:framelabel id="Framelabel55" style="Z-INDEX: 219; LEFT: 28px; POSITION: absolute; TOP: 2096px; width: 599px;"
				runat="server" Height="28px" Text="Pełny numer rachunku" 
                Number="70"></ea:framelabel>
<ea:framelabel id="Framelabel57" style="Z-INDEX: 220; LEFT: 28px; POSITION: absolute; TOP: 2156px; width: 599px;"
				runat="server" Height="28px" Text="Numer rachunku poprzednio wskazanego do zwrotu" 
                Number="71"></ea:framelabel>
<ea:framelabel id="FrameLabel58" style="Z-INDEX: -1; LEFT: 0px; POSITION: absolute; TOP: 2184px; height: 40px; right: 289px;"
				runat="server" Width="630px" Text="C.2.2. RACHUNKI ZWIĄZANE Z DZIAŁALNOŚCIĄ &lt;/font&gt;&lt;.Footer&gt;(z wyjątkiem rachunku wskazanego do zwrotów w poz.67-70 części C.2.1)&lt;br&gt;
                W przypadku braku miejsca na wpisanie dalszych rachunków należy sporządzić listę tych rachunków odpowiednio, zgodnie z zakresem danych
                określonych w części C.2.2. (poz.72-76). Składając formularz za pomocą środków komunikacji elektronicznej nie zachodzi potrzeba dołączania listy." 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel60" style="Z-INDEX: 221; LEFT: 0px; POSITION: absolute; TOP: 2226px; right: 632px; width: 286px;"
				runat="server" Height="28px" Text="Kraj siedziby banku (oddziału)" 
                Number="72"></ea:framelabel>
<ea:framelabel id="Framelabel61" style="Z-INDEX: 222; LEFT: 287px; POSITION: absolute; TOP: 2226px; right: 534px; width: 343px;"
				runat="server" 
                Height="28px" Text="Pełna nazwa banku (oddziału) / SKOK" Number="73"></ea:framelabel>
<ea:framelabel id="Framelabel62" style="Z-INDEX: 223; LEFT: 0px; POSITION: absolute; TOP: 2254px; width: 627px;"
				runat="server" Height="28px" Text="Posiadacz rachunku" 
                Number="74"></ea:framelabel>
<ea:framelabel id="Framelabel63" style="Z-INDEX: 224; LEFT: 0px; POSITION: absolute; TOP: 2282px; width: 518px;"
				runat="server" Height="28px" Text="Pełny numer rachunku" 
                Number="75"></ea:framelabel>
<ea:framelabel ID="Framelabel64" style="Z-INDEX: 225; LEFT: 518px; POSITION: absolute; TOP: 2282px"
				runat="server" Width="110px" Height="28px" Text="Likwidacja rachunku" 
                Number="76"></ea:framelabel>
<ea:checklabel id="p68" style="Z-INDEX: 226; LEFT: 570px; POSITION: absolute; TOP: 2290px; right: 382px;"
				runat="server" Width="24px" Text="" Height="14px"></ea:checklabel>
<ea:framelabel id="FrameLabel79" style="Z-INDEX: -1; LEFT: 0px; POSITION: absolute; TOP: 2310px; height: 112px; right: 289px;"
				runat="server" Width="630px" Text="C.3. ADRES MIEJSCA PRZECHOWYWANIA DOKUMENTACJI RACHUNKOWEJ" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="Framelabel82" style="Z-INDEX: 244; LEFT: 28px; POSITION: absolute; TOP: 2338px"
				runat="server" Width="140px" Height="28px" Text="Kraj" 
                Number="77" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel83" style="Z-INDEX: 245; LEFT: 168px; POSITION: absolute; TOP: 2338px"
				runat="server" Width="266px" Height="28px" 
                Text="Województwo" Number="78"></ea:framelabel>
<ea:framelabel id="Framelabel85" style="Z-INDEX: 246; LEFT: 434px; POSITION: absolute; TOP: 2338px"
				runat="server" Width="196px" Height="28px" Text="Powiat" 
                Number="79"></ea:framelabel>
<ea:framelabel id="Framelabel86" style="Z-INDEX: 247; LEFT: 28px; POSITION: absolute; TOP: 2366px"
				runat="server" Width="161px" Height="28px" Text="Gmina" 
                Number="80"></ea:framelabel>
<ea:framelabel id="Framelabel87" style="Z-INDEX: 248; LEFT: 189px; POSITION: absolute; TOP: 2366px"
				runat="server" Width="301px" Height="28px" Text="Ulica" 
                Number="81"></ea:framelabel>
<ea:framelabel id="Framelabel88" style="Z-INDEX: 249; LEFT: 490px; POSITION: absolute; TOP: 2366px"
				runat="server" Width="70px" Height="28px" Text="Nr domu" 
                Number="82"></ea:framelabel>
<ea:framelabel id="Framelabel89" style="Z-INDEX: 250; LEFT: 560px; POSITION: absolute; TOP: 2366px"
				runat="server" Width="70px" Height="28px" Text="Nr lokalu" 
                Number="83"></ea:framelabel>
<ea:framelabel id="Framelabel90" style="Z-INDEX: 251; LEFT: 28px; POSITION: absolute; TOP: 2394px; right: 639px;"
				runat="server" Width="252px" Height="28px" Text="Miejscowość" 
                Number="84"></ea:framelabel>
<ea:framelabel id="Framelabel91" style="Z-INDEX: 252; LEFT: 280px; POSITION: absolute; TOP: 2394px; "
				runat="server" Width="105px" ValueStyle="PostalCode" 
                Height="28px" Text="Kod pocztowy" Number="85" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel92" style="Z-INDEX: 253; LEFT: 385px; POSITION: absolute; TOP: 2394px; height: 30px;"
				runat="server" Width="245px" Text="Poczta" Number="86"></ea:framelabel>
<ea:framelabel id="FrameLabel80" style="Z-INDEX: 254; LEFT: 0px; POSITION: absolute; TOP: 2422px"
				runat="server" Width="630px" Height="130px" Text="C.4. DANE WYNIKAJĄCE Z WPISU DO EWIDENCJI LUB REJESTRU" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="Framelabel93" style="Z-INDEX: 255; LEFT: 28px; POSITION: absolute; TOP: 2443px; height: 28px;"
				runat="server" Width="599px" Text="Nazwa organu prowadzącego ewidencję lub rejestr" Number="87">
                </ea:framelabel>
<ea:framelabel id="Framelabel94" style="Z-INDEX: 256; LEFT: 28px; POSITION: absolute; TOP: 2471px; height: 28px;"
				runat="server" Width="599px" Text="Nazwa ewidencji lub rejestru" Number="88">
                </ea:framelabel>
<ea:framelabel id="Framelabel95" style="Z-INDEX: 257; LEFT: 28px; POSITION: absolute; TOP: 2499px; height: 28px;"
				runat="server" Width="300px" Text="Data rejestracji lub data zmiany" Number="89" ValueStyle="Date">
                </ea:framelabel>
<ea:framelabel id="Framelabel96" style="Z-INDEX: 257; LEFT: 329px; POSITION: absolute; TOP: 2499px; height: 28px;"
				runat="server" Width="298px" Text="Nazwa ewidencji lub rejestru" Number="90">
                </ea:framelabel>
<ea:framelabel id="Framelabel97" style="Z-INDEX: 258; LEFT: 28px; POSITION: absolute; TOP: 2527px; height: 28px;"
				runat="server" Width="599px" Text="Nazwa pełna (firma)" Number="91">
                </ea:framelabel>
<ea:framelabel id="FrameLabel98" style="Z-INDEX: 261; LEFT: 0px; POSITION: absolute; TOP: 2555px"
				runat="server" Width="630px" Height="30px" Text="C.5. ADRESY MIEJSC PROWADZENIA DZIAŁALNOŚCI" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel125" style="Z-INDEX: -1; LEFT: 0px; POSITION: absolute; TOP: 2583px; height: 118px; right: 289px;"
				runat="server" Width="630px" Text="C.5.1. ADRES GŁÓWNEGO MIEJSCA PROWADZENIA DZIAŁALNOŚCI&lt;br&gt;&lt;/font&gt;&lt;.Footer&gt;(jeżeli nie jest możliwe wskazanie adresu głównego miejsca prowadzenia działalności, należy podać adres zamieszkania)" 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel99" style="Z-INDEX: 264; LEFT: 28px; POSITION: absolute; TOP: 2618px"
				runat="server" Width="140px" Height="28px" Text="Kraj" 
                Number="92"></ea:framelabel>
<ea:framelabel id="Framelabel100" style="Z-INDEX: 265; LEFT: 168px; POSITION: absolute; TOP: 2618px"
				runat="server" Width="266px" Height="28px" 
                Text="Województwo" Number="93"></ea:framelabel>
<ea:framelabel id="Framelabel104" style="Z-INDEX: 266; LEFT: 434px; POSITION: absolute; TOP: 2618px"
				runat="server" Width="196px" Height="28px" Text="Powiat" 
                Number="94"></ea:framelabel>
<ea:framelabel id="Framelabel116" style="Z-INDEX: 267; LEFT: 28px; POSITION: absolute; TOP: 2646px"
				runat="server" Width="161px" Height="28px" Text="Gmina" 
                Number="95"></ea:framelabel>
<ea:framelabel id="Framelabel117" style="Z-INDEX: 268; LEFT: 189px; POSITION: absolute; TOP: 2646px"
				runat="server" Width="301px" Height="28px" Text="Ulica" 
                Number="96"></ea:framelabel>
<ea:framelabel id="Framelabel118" style="Z-INDEX: 269; LEFT: 490px; POSITION: absolute; TOP: 2646px"
				runat="server" Width="70px" Height="28px" Text="Nr domu" 
                Number="97"></ea:framelabel>
<ea:framelabel id="Framelabel119" style="Z-INDEX: 270; LEFT: 560px; POSITION: absolute; TOP: 2646px"
				runat="server" Width="70px" Height="28px" Text="Nr lokalu" 
                Number="98"></ea:framelabel>
<ea:framelabel id="Framelabel120" style="Z-INDEX: 271; LEFT: 28px; POSITION: absolute; TOP: 2674px; right: 639px;"
				runat="server" Width="252px" Height="28px" Text="Miejscowość" 
                Number="99"></ea:framelabel>
<ea:framelabel id="Framelabel122" style="Z-INDEX: 272; LEFT: 280px; POSITION: absolute; TOP: 2674px; "
				runat="server" Width="105px" ValueStyle="PostalCode" 
                Height="28px" Text="Kod pocztowy" Number="100"></ea:framelabel>
<ea:framelabel id="Framelabel123" style="Z-INDEX: 273; LEFT: 385px; POSITION: absolute; TOP: 2674px; height: 30px;"
				runat="server" Width="245px" Text="Poczta" Number="101"></ea:framelabel>
<ea:deklaracjafooter id="footer3" 
                style="Z-INDEX: 259; LEFT: 490px; POSITION: absolute; TOP: 2870px" runat="server"
				Width="154px" Height="10px" TitleWidth="106" Symbol="NIP-7" PageNumber="3" 
                PageTotal="4" Version="2"></ea:deklaracjafooter>
<ea:deklaracjaheader id="DeklaracjaHeader4" style="Z-INDEX: 260; LEFT: 0px; POSITION: absolute; TOP: 2940px"
				runat="server" Width="630px" StylNagłówka="WypałniaSkładającyCRP"></ea:deklaracjaheader>
<ea:framelabel id="FrameLabel126" style="Z-INDEX: -1; LEFT: 0px; POSITION: absolute; TOP: 2962px; height: 210px; right: 289px;"
				runat="server" Width="630px" Text="C.5.2. ADRESY POZOSTAŁYCH MIEJSC PROWADZENIA DZIAŁALNOŚCI&lt;br&gt;&lt;/font&gt;&lt;.Footer&gt;W zgłoszeniu identyfikacyjnym należy podać adresy wszystkich miejsc prowadzenia działalności (również hurtowni, magazynów, składów), a w zgłoszeniu
                aktualizacyjnym stosownie do okoliczności i zmian. W przypadku braku miejsca na wpisanie dalszych adresów należy sporządzić listę adresów tych miejsc odpowiednio, zgodnie z zakresem części C.5.2. (poz.102-113).
                Składając formularz za pomocą środków komunikacji elektronicznej nie zachodzi potrzeba dołączania listy. W przypadku adresu nietypowego (np. sklep w przejściu podziemnym, działalność na terenie całego kraju) dane adresowe należy podać z możliwą dokładnością." 
                FrameStyle="BigYellow" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="Framelabel131" style="Z-INDEX: 274; LEFT: 28px; POSITION: absolute; TOP: 3026px"
				runat="server" Width="599px" Height="28px" Text="Powód zgłoszenia adresu (zaznaczyć właściwy kwadrat):" 
                Number="102"></ea:framelabel>
<ea:checklabel id="p104_1" style="Z-INDEX: 275; LEFT: 50px; POSITION: absolute; TOP: 3033px; right: 382px;"
				runat="server" Width="250px" Text="prowadzenie działalności pod tym adresem"
                Number="1" NumberAlignLeft="False" Height="14px"></ea:checklabel>
<ea:checklabel id="p104_2" style="Z-INDEX: 276; LEFT: 320px; POSITION: absolute; TOP: 3033px; right: 382px;"
				runat="server" Width="250px" Text="zakończenie działalności pod tym adresem"
                Number="2" NumberAlignLeft="False" Height="14px"></ea:checklabel>
<ea:framelabel id="Framelabel132" style="Z-INDEX: 277; LEFT: 28px; POSITION: absolute; TOP: 3054px"
				runat="server" Width="140px" Height="28px" Text="Kraj" 
                Number="103"></ea:framelabel>
<ea:framelabel id="Framelabel133" style="Z-INDEX: 278; LEFT: 168px; POSITION: absolute; TOP: 3054px"
				runat="server" Width="266px" Height="28px" 
                Text="Województwo" Number="104"></ea:framelabel>
<ea:framelabel id="Framelabel134" style="Z-INDEX: 279; LEFT: 434px; POSITION: absolute; TOP: 3054px"
				runat="server" Width="196px" Height="28px" Text="Powiat" 
                Number="105"></ea:framelabel>
<ea:framelabel id="Framelabel135" style="Z-INDEX: 280; LEFT: 28px; POSITION: absolute; TOP: 3082px"
				runat="server" Width="161px" Height="28px" Text="Gmina" 
                Number="106"></ea:framelabel>
<ea:framelabel id="Framelabel138" style="Z-INDEX: 281; LEFT: 189px; POSITION: absolute; TOP: 3082px"
				runat="server" Width="301px" Height="28px" Text="Ulica" 
                Number="107"></ea:framelabel>
<ea:framelabel id="Framelabel139" style="Z-INDEX: 282; LEFT: 490px; POSITION: absolute; TOP: 3082px"
				runat="server" Width="70px" Height="28px" Text="Nr domu" 
                Number="108"></ea:framelabel>
<ea:framelabel id="Framelabel140" style="Z-INDEX: 283; LEFT: 560px; POSITION: absolute; TOP: 3082px"
				runat="server" Width="70px" Height="28px" Text="Nr lokalu" 
                Number="109"></ea:framelabel>
<ea:framelabel id="Framelabel141" style="Z-INDEX: 284; LEFT: 28px; POSITION: absolute; TOP: 3110px; right: 639px;"
				runat="server" Width="252px" Height="28px" Text="Miejscowość" 
                Number="110"></ea:framelabel>
<ea:framelabel id="Framelabel142" style="Z-INDEX: 285; LEFT: 280px; POSITION: absolute; TOP: 3110px; "
				runat="server" Width="105px" ValueStyle="PostalCode" 
                Height="28px" Text="Kod pocztowy" Number="111"></ea:framelabel>
<ea:framelabel id="Framelabel143" style="Z-INDEX: 286; LEFT: 385px; POSITION: absolute; TOP: 3110px; height: 30px;"
				runat="server" Width="245px" Text="Poczta" Number="112"></ea:framelabel>
<ea:framelabel id="Framelabel144" style="Z-INDEX: 287; LEFT: 28px; POSITION: absolute; TOP: 3138px; height: 30px;"
				runat="server" Width="599px" Text="Określenie opisowe adresu nietypowego" Number="113"></ea:framelabel>
<ea:framelabel id="FrameLabel145" style="Z-INDEX: 288; LEFT: 0px; POSITION: absolute; TOP: 3172px"
				runat="server" Width="630px" Height="18px" Text="D. INFORMACJA O ZAŁĄCZNIKACH" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel146" style="Z-INDEX: 289; LEFT: 0px; POSITION: absolute; TOP: 3193px; height: 55px;"
				runat="server" Width="630px" Text="D.1. DOŁĄCZONE FORMULARZE&lt;br&gt;&lt;/font&gt;&lt;.Footer&gt;W każdej pozycji należy podać liczbę dołączonych formularzy."
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel149" style="Z-INDEX: 290; LEFT: 28px; POSITION: absolute; TOP: 3221px; height: 30px;"
				runat="server" Width="200px" Text="Lista, o której mowa w części B.2." Number="114"></ea:framelabel>
<ea:framelabel id="Framelabel150" style="Z-INDEX: 291; LEFT: 231px; POSITION: absolute; TOP: 3221px; height: 30px;"
				runat="server" Width="185px" Text="Lista, o której mowa w części C.2.2." Number="115"></ea:framelabel>
<ea:framelabel id="Framelabel151" style="Z-INDEX: 292; LEFT: 413px; POSITION: absolute; TOP: 3221px; height: 30px;"
				runat="server" Width="218px" Text="Lista, o której mowa w części C.5.2." Number="116"></ea:framelabel>
<ea:framelabel id="FrameLabel152" style="Z-INDEX: 293; LEFT: 0px; POSITION: absolute; TOP: 3249px; height: 85px;"
				runat="server" Width="630px" Text="D.2. DOŁĄCZONE DOKUMENTY ALBO ICH UWIERZYTELNIONE LUB POŚWIADCZONE URZĘDOWO KOPIE&lt;br&gt;&lt;/font&gt;&lt;.Footer&gt;W zależności od okoliczności do zgłoszenia należy dołączyć pełnomocnictwo albo postanowienie sądu o ustanowieniu kuratora (art.5 ust.4a i art.9 ust.6 pkt 1 ustawy)."
                FrameStyle="BigYellow" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="Framelabel153" style="Z-INDEX: 294; LEFT: 28px; POSITION: absolute; TOP: 3299px; height: 30px;"
				runat="server" Width="599px" Text="Dołączone dokumenty (zaznaczyć właściwy kwadrat):" Number="117"></ea:framelabel>
<ea:checklabel id="p119_1" style="Z-INDEX: 295; LEFT: 50px; POSITION: absolute; TOP: 3306px; right: 382px;"
				runat="server" Width="250px" Text="pełnomocnictwo"
                Number="1" NumberAlignLeft="False" Height="14px"></ea:checklabel>
<ea:checklabel id="p119_2" style="Z-INDEX: 296; LEFT: 320px; POSITION: absolute; TOP: 3306px; right: 382px;"
				runat="server" Width="250px" Text="postanowienie sądu o ustanowieniu kuratora"
                Number="2" NumberAlignLeft="False" Height="14px"></ea:checklabel>
<ea:framelabel id="Framelabel121" style="Z-INDEX: 251; LEFT: 0px; POSITION: absolute; TOP: 3333px; width: 630px; height: 178px;"
				runat="server" 
                Text="E. &lt;font size=2&gt;PODPIS SKŁADAJĄCEGO/DANE I PODPIS OSOBY REPREZENTUJĄCEJ SKŁADAJĄCEGO&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Poz.118-121 wypełnia wyłącznie osoba reprezentująca składającego, tj. osoba posiadająca pełnomocnictwo albo postanowienie sądu." 
                FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="Framelabel177" style="Z-INDEX: 252; LEFT: 28px; POSITION: absolute; TOP: 3362px; width: 300px;"
				runat="server" Height="28px" Text="Imię" Number="118"></ea:framelabel>
<ea:framelabel id="Framelabel181" style="Z-INDEX: 253; LEFT: 329px; POSITION: absolute; TOP: 3362px; width: 300px; right: 485px;"
				runat="server" Height="28px" Text="Nazwisko" Number="119"></ea:framelabel>
<ea:framelabel id="Framelabel178" style="Z-INDEX: 254; LEFT: 28px; POSITION: absolute; TOP: 3390px; width: 599px;"
				runat="server" Height="28px" Text="Identyfikator podatkowy NIP / numer PESEL&lt;.INDEXUP&gt;(niepotrzebne skreślić)" Number="120"></ea:framelabel>
<ea:framelabel id="Framelabel166" style="Z-INDEX: 255; LEFT: 28px; POSITION: absolute; TOP: 3418px; right: 632px; width: 599px;"
				runat="server" Height="28px" Text="Adres do korespondencji" 
                Number="121"></ea:framelabel>
<ea:framelabel id="Framelabel180" style="Z-INDEX: 256; LEFT: 28px; POSITION: absolute; TOP: 3446px; width: 225px; right: 619px;"
				runat="server" Height="56px" Text="Data wypełnienia zgłoszenia" Number="122" 
                ValueStyle="Date"></ea:framelabel>
<ea:framelabel id="Framelabel137" style="Z-INDEX: 257; LEFT: 252px; POSITION: absolute; TOP: 3446px; width: 378px; right: 485px;"
				runat="server" Height="56px" 
                Text="Podpis (i pieczątka) składającego / osoby reprezentującej składającego &lt;.Normal&gt;(niepotrzebne skreślić)&lt;./&gt;" 
                Number="123"></ea:framelabel>
<ea:framelabel id="FrameLabel127" style="Z-INDEX: 258; LEFT: 0px; POSITION: absolute; TOP: 3508px; height: 170px;"
				runat="server" Width="630px" Text="F. ADNOTACJE URZĘDU SKARBOWEGO" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel130" style="Z-INDEX: 259; LEFT: 28px; POSITION: absolute; TOP: 3536px; height: 87px;"
				runat="server" Width="602px" Text="Uwagi urzędu skarbowego" 
                FrameStyle="SmallBoldGray" Number="124"></ea:framelabel>
<ea:framelabel id="FrameLabel128" style="Z-INDEX: 260; LEFT: 28px; POSITION: absolute; TOP: 3620px; right: 511px; height: 26px;"
				runat="server" Width="301px" 
                Text="Identyfikator przyjmującego formularz" FrameStyle="SmallBoldGray" 
                Number="125"></ea:framelabel>
<ea:framelabel id="FrameLabel129" style="Z-INDEX: 261; LEFT: 329px; POSITION: absolute; TOP: 3620px; height: 31px;"
				runat="server" Width="301px" Text="Podpis przyjmującego formularz" 
                FrameStyle="SmallBoldGray" Number="126"></ea:framelabel>
<ea:framelabel id="FrameLabel171" style="Z-INDEX: 262; LEFT: 28px; POSITION: absolute; TOP: 3648px; right: 602px; width: 223px; height: 29px;"
				runat="server" Text="Data rejestracji w systemie" 
                FrameStyle="SmallBoldGray" Number="127" ValueStyle="Date"></ea:framelabel>
<ea:framelabel id="FrameLabel172" style="Z-INDEX: 263; LEFT: 252px; POSITION: absolute; TOP: 3648px; right: 420px; width: 169px; height: 27px;"
				runat="server" Text="Identyfikator rejestrującego formularz w systemie" 
                FrameStyle="SmallBoldGray" Number="128"></ea:framelabel>
<ea:framelabel id="FrameLabel173" style="Z-INDEX: 264; LEFT: 420px; POSITION: absolute; TOP: 3648px; right: 590px; width: 210px; height: 27px;"
				runat="server" Text="Podpis rejestrującego formularz w systemie" 
                FrameStyle="SmallBoldGray" Number="129"></ea:framelabel>
<ea:framelabel id="FrameLabel136" style="Z-INDEX: 254; LEFT: 0px; POSITION: absolute; TOP: 3682px; height: 18px;"
				runat="server" Width="630px" 
                Text="Pouczenie&lt;/br&gt; Za wykroczenia skarbowe dotyczące obowiązków ewidencyjnych, o których mowa w art.81 Kodeksu karnego skarbowego, grozi kara grzywny." 
                FrameBorderStyle="None" HorizontalAlign="Center"></ea:framelabel>
<ea:deklaracjafooter id="footer4" 
                style="Z-INDEX: 255; LEFT: 0px; POSITION: absolute; TOP: 3850px" runat="server"
				TitleWidth="106" Symbol="NIP-7" PageNumber="4" PageTotal="4" Version="2"></ea:deklaracjafooter>
<ea:datacontext id="dc" style="Z-INDEX: 256; LEFT: 189px; POSITION: absolute; TOP: 3897px" runat="server"
				TypeName="Soneta.Kadry.PracHistoria,Soneta.KadryPlace" oncontextload="OnContextLoad" 
                LeftMargin="15" PageHeight="977px" PageZoom="107%"></ea:datacontext>
</form>
	</body>
</HTML>
