﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Place;
using Soneta.Kalend;
using System.Diagnostics;
using System.Collections.Generic;
using Soneta.Web;
using Soneta.Deklaracje;
using Soneta.Deklaracje.PIT;
using System.Web.UI.HtmlControls;

namespace ASP {

    public partial class PIT_40_19 : System.Web.UI.Page {

        public string Str_PITWatermark = "Tylko do celów poglądowych";
        public static string Str_PITVerifier = "Wydruk PIT-40 (19) może być drukowany wyłącznie dla deklaracji PIT-40 w wersji 19.";

        public class SrParams : SerializableContextBase {

            public SrParams(Context context) : base(context) {
            }

            bool watermark = true;
            [Caption("Znak wodny")]
            public bool Watermark {
                get { return watermark; }
                set {
                    watermark = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }

        SrParams srpars;
        [SettingsContext]
        public SrParams SrPars {
            get { return srpars; }
            set { srpars = value; }
        }

        protected void dc_ContextLoad(object sender, EventArgs e) {
            Deklaracja pit = (Deklaracja)dc[typeof(Deklaracja)];
            if (pit as PIT40_19 == null)
                throw new InvalidOperationException(Str_PITVerifier);
            PIT40_19 pit40 = (PIT40_19)pit;
            if (!pit.Module.Config.PIT.Ogólne.DanePodatnikaWStopce)
                flDanePodatnika2.Text = flDanePodatnika1.Text = "";
            else {
                flDanePodatnika2.Text = flDanePodatnika1.Text = string.Format("{0}, {1}: {2}",
                            pit40.Podmiot.ToString(),
                            pit40.JestPESEL ? "PESEL" : "NIP",
                            pit40.IdentyfikatorPodatnika);
            }
            if (pit40.JestPESEL) {
                flPeselNip.Text = "<strike>Identyfikator podatkowy NIP</strike>/Numer PESEL <.Indexup>(niepotrzebne skreślić))";
                flPeselNip.ValueStyle = ValueStyles.WideText;
            }
            else {
                flPeselNip.Text = "Identyfikator podatkowy NIP/<strike>Numer PESEL</strike> <.Indexup>(niepotrzebne skreślić))";
                flPeselNip.ValueStyle = ValueStyles.nip_w;
            }
            watermark.Visible = srpars.Watermark;
        }

    }
}
