﻿<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Zadania" %>
<%@ import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<script runat="server">

public class Parametry : Soneta.Business.ContextBase
    {
        FromTo okres;

        public Parametry(Context cx) : base(cx)
        {
            okres = new FromTo(Date.Today.FirstDayMonth(), Date.Today.LastDayMonth());
        }


        [Caption("W okresie :")]

        public FromTo Okres
        {
            get { return okres; }
            set { okres = value; }
        }
    }

    // inicjacja klasy parametrów
    Parametry param = null;

    [Context]
    [Caption("Historia zleceń")]

    public Parametry Param
    {
        get { return param; }
        set { param = value; }
    } 

    protected void dc_ContextLoad(object sender, EventArgs e)
    {
        DataLabelZlecenia.EditValue = "Zlecenia serwisowe";
        
        Soneta.Business.View v = ((Urzadzenie)(dc[typeof(Urzadzenie)])).Zlecenia;
        v.Condition&= new FieldCondition.LessEqual("Start", new DateTime(param.Okres.To.Year,param.Okres.To.Month,param.Okres.To.Day));
        v.Condition&= new FieldCondition.GreaterEqual("End", new DateTime(param.Okres.From.Year,param.Okres.From.Month,param.Okres.From.Day));

        ArrayList dokumentyAL = new ArrayList();
        ArrayList czesciAL = new ArrayList();
        ArrayList uslugiAL = new ArrayList();

        grid1.DataSource = v;

        foreach (UrzadzenieUzyte u in v)
        {
           // if(!(u.Zadanie is PlanowanyPrzeglad))
           {
                foreach (DokumentCRM dcrm in u.Zadanie.DokumentyCRM)
                    dokumentyAL.Add(dcrm);        

                if(u.Zadanie.DokCRMCzesci!=null)
                {
                    foreach (PozycjaDokHandlowego p in ((DokumentHandlowy)u.Zadanie.DokCRMCzesci.Dokument).Pozycje)
                        czesciAL.Add(p);
                }

                if (u.Zadanie.DokCRMUslugi != null)
                {
                    foreach (PozycjaDokHandlowego p in ((DokumentHandlowy)u.Zadanie.DokCRMUslugi.Dokument).Pozycje)
                        uslugiAL.Add(p);
                }
            }
        }  

        //  <ea:GridColumn Width="15" Align="Left" DataMember="Zadanie.Workers.Zadanie.KosztCzesci" Caption="Suma części" Total="Sum"></ea:GridColumn>
        //  <ea:GridColumn Width="15" Align="Left" DataMember="Zadanie.Workers.Zadanie.KosztUslug" Caption="Suma usług" Total="Sum"></ea:GridColumn>

        dokumenty.DataSource = dokumentyAL;
        czesci.DataSource = czesciAL;
        uslugi.DataSource = uslugiAL;

        ReportHeader1.Title = ((Urzadzenie)(dc[typeof(Urzadzenie)])).ToString() + "|Zakres: " + param.Okres.ToString();
    }
</script>
<HTML>
	<HEAD>
		<TITLE>Urzadzenie</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server" ID="form">
			<ea:DataContext id="dc" runat="server" 
                TypeName="Soneta.Zadania.Urzadzenie,Soneta.Zadania" 
                oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader1" runat="server" ></eb:ReportHeader>


<p>
<div style='FONT-WEIGHT: bold; FONT-SIZE: 8pt; WIDTH: 100%; COLOR: white; FONT-FAMILY: Verdana; BACKGROUND-COLOR: maroon; FONT-VARIANT: small-caps'>
	Ogólne
</div>
Identyfikator: 
<ea:DataLabel runat="server" ID="label7" DataMember="Identyfikator"></ea:datalabel>
            <br>
Nazwa: <ea:DataLabel runat="server" ID="label11" DataMember="Nazwa"></ea:datalabel>
            <br>
            Opis:&nbsp; <ea:DataLabel runat="server" ID="label14" DataMember="Opis"></ea:datalabel><br>
            Stan Aktualny: <ea:DataLabel runat="server" ID="label15" DataMember="Workers.Urzadzenie.StanUrzadzeniaNaDzien"></ea:datalabel>
            <br />
            Dostępność:
<ea:DataLabel runat="server" ID="label16" DataMember="Workers.Urzadzenie.Dostepnosc"></ea:datalabel>
<div style='FONT-WEIGHT: bold; FONT-SIZE: 8pt; WIDTH: 100%; COLOR: white; FONT-FAMILY: Verdana; BACKGROUND-COLOR: maroon; FONT-VARIANT: small-caps'>
	Serwis
</div>
Termin gwarancji :
<ea:DataLabel runat="server" ID="label17" DataMember="DataGwarancji"></ea:datalabel><br>

            Częstotliwość przeglądów (m-ce) :
<ea:DataLabel runat="server" ID="label18" DataMember="PrzegladOkres"></ea:datalabel><br>
            Kontrahent : 
<ea:DataLabel runat="server" ID="label19" DataMember="Kontrahent"></ea:datalabel><br>
            Lokalizacja : 
<ea:DataLabel runat="server" ID="label20" DataMember="Lokalizacja"></ea:datalabel><br>
            Serwisant : 
<ea:DataLabel runat="server" ID="label21" DataMember="Serwisant"></ea:datalabel><br>
            Data ostatniego przeglądu : 
<ea:DataLabel runat="server" ID="label22" DataMember="Workers.Urzadzenie.DataOstatniegoPrzegladu"></ea:datalabel><br>
            Data następnego przeglądu : 
<ea:DataLabel runat="server" ID="label23" DataMember="Workers.Urzadzenie.DataNastepnegoPrzegladu"></ea:datalabel>
            <br />
            Data ostatniej naprawy :
<ea:DataLabel runat="server" ID="label24" DataMember="Workers.Urzadzenie.DataOstatniejNaprawy"></ea:datalabel><br>
            Przyjęty do naprawy :
<ea:DataLabel runat="server" ID="label25" DataMember="Workers.Urzadzenie.CzyPrzyjety"></ea:datalabel><br>
            Stan:&nbsp; <ea:DataLabel runat="server" ID="label26" DataMember="Workers.Urzadzenie.StanUrzadzenia"></ea:datalabel>&nbsp;<p>


<div style='FONT-WEIGHT: bold; FONT-SIZE: 8pt; WIDTH: 100%; COLOR: white; FONT-FAMILY: Verdana; BACKGROUND-COLOR: maroon; FONT-VARIANT: small-caps'>
	<ea:DataLabel runat="server" ID="DataLabelZlecenia" ></ea:datalabel>
</div>


	<ea:Grid runat="server" ID="grid1" DataMember="Zlecenia" 
                RowTypeName="Soneta.Zadania.UrzadzenieUzyte,Soneta.Zadania">
		<Columns>
			<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
            <ea:GridColumn  Align="Left" DataMember="Zadanie" Caption="Zadanie"></ea:GridColumn>
			<ea:GridColumn Width="24" Align="Left" DataMember="StanZadania" Caption="Stan zadania"></ea:GridColumn>
			<ea:GridColumn Width="22" Align="Left" DataMember="DataZamkniecia" Caption="Data zamknięcia"></ea:GridColumn>
			<ea:GridColumn Width="18" Align="Left" DataMember="Rozliczone" Caption="Rozliczone"></ea:GridColumn>
			
		</Columns>
	</ea:Grid>


<p>
<div style='FONT-WEIGHT: bold; FONT-SIZE: 8pt; WIDTH: 100%; COLOR: white; FONT-FAMILY: Verdana; BACKGROUND-COLOR: maroon; FONT-VARIANT: small-caps'>
	Planowane przeglądy
</div>
	<ea:Grid runat="server" ID="grid2" DataMember="PlanowanePrzeglady" RowTypeName="Soneta.Zadania.PlanowanyPrzeglad,Soneta.Zadania">
		<Columns>
			<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
			<ea:GridColumn  Align="Left" DataMember="Nazwa" Caption="Nazwa"></ea:GridColumn>
			<ea:GridColumn Width="35" Align="Left" DataMember="Zadanie" Caption="Zadanie"></ea:GridColumn>
			<ea:GridColumn Width="15" Align="Left" DataMember="Termin" Caption="Data przeglądu"></ea:GridColumn>
            
		</Columns>
	</ea:Grid>


    <p>
<div style='FONT-WEIGHT: bold; FONT-SIZE: 8pt; WIDTH: 100%; COLOR: white; FONT-FAMILY: Verdana; BACKGROUND-COLOR: maroon; FONT-VARIANT: small-caps'>
	Dokumenty
</div>
	<ea:Grid runat="server" ID="dokumenty" Sort="Zadanie.Numer" GroupData0="Zadanie.Numer" GroupData1="Zadanie" GroupLine="{0} - {1}"   RowTypeName="Soneta.Zadania.DokumentCRM,Soneta.Zadania">
		<Columns>
			<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
			<ea:GridColumn  Align="Left" DataMember="Dokument" Caption="Dokument"></ea:GridColumn>
            <ea:GridColumn Width="20" Align="Left" DataMember="RodzajDokCRM" Caption="Rodzaj Dokumentu"></ea:GridColumn>
            <ea:GridColumn Width="15" Align="Left" DataMember="Data" Caption="Data"></ea:GridColumn>
            <ea:GridColumn Width="19" Align="Left" DataMember="Wartosc" Caption="Wartość"  Total="Sum"></ea:GridColumn>
            
          
         
                
		
	
		</Columns>
	</ea:Grid>

            <br>

<p>
<div style='FONT-WEIGHT: bold; FONT-SIZE: 8pt; WIDTH: 100%; COLOR: white; FONT-FAMILY: Verdana; BACKGROUND-COLOR: maroon; FONT-VARIANT: small-caps'>
	Części
</div>
	<ea:Grid runat="server" ID="czesci"  GroupData0="Dokument" Sort="Dokument" GroupLine ="{0}" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel">
		<Columns>
			<ea:GridColumn Width="4" Align="Right" DataMember="Lp" Caption="Lp"></ea:GridColumn>
			<ea:GridColumn Align="Left" DataMember="Towar" Caption="Towar"></ea:GridColumn>
			<ea:GridColumn Width="8" Align="Left" DataMember="Ilosc" Caption="Ilość"></ea:GridColumn>
			<ea:GridColumn Width="14" Align="Left" DataMember="Cena" Caption="Cena"></ea:GridColumn>
			<ea:GridColumn Width="16" Align="Left" DataMember="WartoscCy" Caption="Wartość" Total="Sum"></ea:GridColumn>
			<ea:GridColumn Width="6" Align="Left" DataMember="DefinicjaStawki" Caption="St.VAT"></ea:GridColumn>
		</Columns>
	</ea:Grid>


<p>
<div style='FONT-WEIGHT: bold; FONT-SIZE: 8pt; WIDTH: 100%; COLOR: white; FONT-FAMILY: Verdana; BACKGROUND-COLOR: maroon; FONT-VARIANT: small-caps'>
	Usługi
</div>
	<ea:Grid runat="server" ID="uslugi" DataMember="DokHanUslugi.Pozycje"  GroupData0="Dokument" Sort="Dokument" GroupLine ="{0}" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel">
		<Columns>
			<ea:GridColumn Width="4" Align="Right" DataMember="Lp" Caption="Lp"></ea:GridColumn>
			<ea:GridColumn Align="Left" DataMember="Towar" Caption="Towar"></ea:GridColumn>
			<ea:GridColumn Width="8" Align="Left" DataMember="Ilosc" Caption="Ilość"></ea:GridColumn>
			<ea:GridColumn Width="14" Align="Left" DataMember="Cena" Caption="Cena"></ea:GridColumn>
			<ea:GridColumn Width="8" Align="Left" DataMember="Rabat" Caption="Rabat"></ea:GridColumn>
			<ea:GridColumn Width="14" Align="Left" DataMember="CenaPoRabacie" Caption="Cena po rabacie"></ea:GridColumn>
			<ea:GridColumn Width="17" Align="Left" DataMember="WartoscCy" Caption="Wartość" Total="Sum"></ea:GridColumn>
			<ea:GridColumn Width="6" Align="Left" DataMember="DefinicjaStawki" Caption="St.VAT"></ea:GridColumn>
		</Columns>
	</ea:Grid>



			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>
