﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Zadania" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.CzlonkowieSzkolenia" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<head>
	<script runat="server">
        public enum RodzajEtykiety
        {
            [Caption("Etykiety adresowe")]
            Adresowe,
            [Caption("Identyfikatory")]
            Identyfikatory
        }

        public class Params : ContextBase
        {
            public Params(Context cx)
                : base(cx) { }
                       
            RodzajEtykiety rodzaj = RodzajEtykiety.Adresowe;
            [Priority(10)]
            [Caption("Rodzaj etykiet")]
            public RodzajEtykiety Rodzaj
            {
                get { return rodzaj; }
                set { rodzaj = value; }
            }
            
            Decimal wys_kom = 37.0m;
            [Priority(40)]
            [Caption("Wysokość komórki:")]

            public Decimal Wys_kom
            {
                get { return wys_kom; }
                set { wys_kom = value; }
            }

            Decimal szer_kom = 105.0m;

            [Caption("Szerokość komórki:")]
            [Priority(50)]
            public Decimal Szer_kom
            {
                get { return szer_kom; }
                set { szer_kom = value; }
            }

            Decimal mar_gd = 0.0m;

            [Caption("Margines górny:")]
            [Priority(20)]
            public Decimal Mar_gd
            {
                get { return mar_gd; }
                set { mar_gd = value; }
            }

            Decimal mar_lp = 0.00m;
            [Priority(30)]
            [Caption("Margines lewy:")]

            public Decimal Mar_lp
            {
                get { return mar_lp; }
                set { mar_lp = value; }
            }
            bool ramki = false;
            [Priority(60)]
            [Caption("Drukować ramki")]
            public bool Ramki
            {
                get { return ramki; }
                set { ramki = value; }
            }

        }

        Params param = null;
        [Caption("Drukowanie etykiet")]
        [Context]
	 
	    public Params Param
        {
            get { return param; }
            set { param = value; }
        }

        void OnContextLoad(Object sender, EventArgs args)
        {
            dc.LeftMargin = (int)(param.Mar_lp );
            dc.TopMargin = (int)(param.Mar_gd );
            Row[] rows = null; 
            if (dc.Context.Contains(typeof(INavigatorContext)))
            {
                INavigatorContext nav = dc[typeof(INavigatorContext)] as INavigatorContext;
                if (nav.SelectedRows.Length > 0 && nav.SelectedRows[0] is ZgloszenieUczestnik)
                {
                    rows = new Row[nav.SelectedRows.Length];
                    for (int i = 0; i < nav.SelectedRows.Length; i++)
                        rows[i] = (Row)nav.SelectedRows[i];
                }

            } 
/*            if (rows == null && dc.Context.Contains(typeof(GrupaSzkol)))
            {
                GrupaSzkol grupa = (GrupaSzkol)dc[typeof(GrupaSzkol)];
                rows = grupa.Uczestnicy.ToArray<Row>();
            }
 */
            if (rows == null)
            {
                rows = (Row[])dc[typeof(Row[])];
            }
            if (rows == null)
                throw new Exception("Nie udało się wyszukać uczestników");
            //UczestnikBase[] kontrahenci = (UczestnikBase[])dc[typeof(UczestnikBase[])];

            decimal kom_szer = param.Szer_kom;
            //KZ wysokość komórki zależna od oddziału
            decimal kom_wys = param.Wys_kom;
            //Msg(dc.Session.Login.Entitle.CurrentOddzial.ID.ToString());
            /*if (dc.Session.Login.Entitle.CurrentOddzial.ID == 114 || dc.Session.Login.Entitle.CurrentOddzial.ID == 115)
                kom_wys = 25.2m;
            else
                kom_wys = param.Wys_kom;*/
    
                        int ilosc_poziom = (int)System.Math.Floor((210m - 2*param.Mar_lp) / kom_szer);
            int ilosc_pion = (int)System.Math.Floor((297m - 2*param.Mar_gd) / kom_wys);

            int ilosc_wierszy_total = ((int)(rows.Length / ilosc_poziom)) ;

            if ((rows.Length % ilosc_poziom) > 0)
                ilosc_wierszy_total++;
            
            string tablica="";
            string tablica_p = String.Format("<EA:SECTION TYPE=\"HEADER\" /><table cellspacing=0 cellpadding=0 style='vertical-align:middle; text-align:{0}; font-family: Tahoma; font-size: 11pt; border:{1}; BORDER-COLLAPSE: collapse; overflow: hidden;'><tr><th colspan='{2}' style='height:0;'></th></tr><EA:SECTION TYPE=\"BODY\" />", Param.Rodzaj == null ? "left" : "center", Param.Ramki ? "1px solid silver" : "0", ilosc_poziom);

            string tablica_k = "</table> <EA:SECTION TYPE=\"BODY\" />";
            string wiersz_p = "<tr>";
            string wiersz_k = "</tr><EA:SECTION TYPE=\"BODY\" />";

            string komorka_p = String.Format("<td  style=\" vertical-align:middle; overflow:hidden; border:{0}; height: {1:#0}mm ; width:{2:#0}mm \"> ", Param.Ramki ? "1px solid silver" : "0", kom_wys, kom_szer);
            string komorka_k = "</td>";


               
            int licznik = 0;
            
            tablica += tablica_p;
            
            for (int i = 1; i <= ilosc_wierszy_total; i++)
            {
                tablica += wiersz_p;
                for (int j = 0; j < ilosc_poziom; j++)
                {
                    tablica += komorka_p;
                    if (licznik < rows.Length)
                    {
                        Row wiersz = rows[licznik];


                        UczestnikBase ucz = wiersz as UczestnikBase;
                        ZgloszenieUczestnik zgl = wiersz as ZgloszenieUczestnik;                        
                        Soneta.CRM.Kontrahent k = null;
                        if (ucz != null)
                        {
                            k = ucz.Firma;
                        }
                        else
                        {
                            if (zgl != null)
                            {
                                ucz = zgl.Uczestnik;
                                k = zgl.Zgloszenie.Kontrahent != null ? zgl.Zgloszenie.Kontrahent : ucz.Firma;
                            }
                        }
                        if (ucz == null)
                            throw new Exception("Nierozpoznany typ wiersza");
                        
                        tablica += "Sz.P. <b>"+ucz.Imie.ToUpper() + " " + ucz.Nazwisko.ToUpper() +"</b><br /> ";
                        switch (Param.Rodzaj)
                        {
                            case RodzajEtykiety.Adresowe:
                                Kontrahent adresat = ucz.Kontrahent;
                                if (zgl != null && zgl.KorespPlatnik)
                                {
                                    tablica += zgl.Platnik.Nazwa + "<br/>";
                                    adresat = zgl.Platnik;
                                }
                                if (adresat.AdresDoKorespondencji.Pełny.Trim() != "")
                                    tablica += " " + adresat.AdresDoKorespondencji.Linia1 + " <br/> " + adresat.AdresDoKorespondencji.Linia2;
                                else
                                    tablica += " " + adresat.Adres.Linia1.ToUpper() + " <br/> " + adresat.Adres.Linia2.ToUpper();

                                break;
                            case RodzajEtykiety.Identyfikatory:
                                if (k != null)
                                    tablica += k.NazwaPierwszaLinia + "<br/>" + k.Adres.Miejscowosc;
                                break;
                        }
                        
                        licznik++;
                    }
                       tablica += komorka_k;
                    
                }

                tablica += wiersz_k;
                //if (i % ilosc_pion==0)                { tablica += tablica_k+tablica_p; }
            }

            tablica += tablica_k;
            strona.EditValue = tablica; 
         
               
        }
        void Msg(Object o)
        {
        }
      
	</script>
	    </head>
	<BODY >
		<FORM  method="post" runat="server" id="Formul" >
			<ea:DataContext id="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
       
        	<ea:DataLabel ID="strona" runat="server">    </ea:DataLabel>
					  	
		</FORM>
	    </BODY>
</HTML>

