﻿<%@ import Namespace="Soneta.CzlonkowieSzkolenia" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>ZgloszenieUczestnik</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
            class ZajeciaDzien : IComparable
            {
                Date data;
                Time czasod;
                Time czasdo;
                public ZajeciaDzien(LekcjaSzkol lekcja)
                {
                    this.data = lekcja.Data;
                    this.czasod = lekcja.CzasOd;
                    this.czasdo = lekcja.CzasDo;
                }
                public void Aktualizuj(LekcjaSzkol lekcja)
                {
                    if (lekcja.Data == data)
                    {
                        if (lekcja.CzasOd != Time.Empty && lekcja.CzasOd != Time.MaxValue && lekcja.CzasOd != Time.MinValue && lekcja.CzasOd < czasod)
                            czasod = lekcja.CzasOd;
                        if (lekcja.CzasDo != Time.Empty && lekcja.CzasDo != Time.MaxValue && lekcja.CzasDo != Time.MinValue && lekcja.CzasDo > czasdo)
                            czasdo = lekcja.CzasDo;
                    }
                }
                public Date Data
                {
                    get { return data; }
                    set { data = value; }
                }
                public Time CzasOd
                {
                    get { return czasod; }
                    set { czasod = value; }
                }
                public Time CzasDo
                {
                    get { return czasdo; }
                    set { czasdo = value; }
                }




                public int CompareTo(object obj)
                {
                    ZajeciaDzien z = obj as ZajeciaDzien;
                    if (z == null) return 1;
                    return data.CompareTo(z.Data);
                }

            }
            void OnContextLoad(Object sender, EventArgs args)
            {
                if (dc.Context.Contains(typeof(ZgloszenieUczestnik)))
                {
                    ZgloszenieUczestnik zgl = (ZgloszenieUczestnik)dc[typeof(ZgloszenieUczestnik)];
                    DataRepeater1.DataSource = new object[] { zgl };
                    return;
                }
                else if (dc.Context.Contains(typeof(INavigatorContext)))
                {
                    INavigatorContext nav = dc[typeof(INavigatorContext)] as Soneta.Business.INavigatorContext;
                    if (nav.SelectedRows.Length > 0 && nav.SelectedRows[0] is ZgloszenieUczestnik)
                    {
                        DataRepeater1.DataSource = nav.SelectedRows;
                        return;
                    }
                }
                throw new Exception("Wydruk należy uruchomić z poziomu zgłoszenia (uczestnika) lub zaznaczonych uczestników na grupie szkoleniowej");
            }
            void DataRepeaterBeforeRow(Object sender, EventArgs args)
            {
                //ZgloszenieUczestnik zgl = (ZgloszenieUczestnik)dc[typeof(ZgloszenieUczestnik)];
                ZgloszenieUczestnik zgl = (ZgloszenieUczestnik)DataRepeater1.CurrentRow;
                DataLabelDzis.EditValue = Date.Today.ToString("d MMMM yyyy");
                DataLabelData.EditValue = zgl.GrupaSzkol.DataOd == zgl.GrupaSzkol.DataDo ? String.Format("dniu {0}", zgl.GrupaSzkol.DataOd) : String.Format("dniach {0}", new FromTo(zgl.GrupaSzkol.DataOd, zgl.GrupaSzkol.DataDo));
                Hashtable dni = new Hashtable();
                string miejsce = "";
                foreach (LekcjaSzkol lekcja in zgl.GrupaSzkol.Zajecia)
                {
                    if (miejsce == "" && lekcja.Sala != null)
                        miejsce = lekcja.Sala.Nazwa + ", " + lekcja.Sala.Adres.Miejscowosc + ", " + lekcja.Sala.Adres.Linia1;
                    ZajeciaDzien item = (ZajeciaDzien)dni[lekcja.Data];
                    if (item == null)
                    {
                        item = new ZajeciaDzien(lekcja);
                        dni.Add(lekcja.Data, item);
                    }
                    else
                        item.Aktualizuj(lekcja);
                }
                ArrayList l = new ArrayList(dni.Values);
                l.Sort();
                string program = "";
                int i = 0;
                foreach (ZajeciaDzien z in l)
                {
                    string rejestracja = i == 0 ? String.Format("<li>Rejestracja od godz. {0}</li>", new Time(z.CzasOd.TotalMinutes - 30)) : "";
                    program += String.Format("<p style='font-family:Arial; font-size:12pt; font-weight:bold; text-decoration: underline'>{0}:</p><ul style='font-family:Arial; font-size:12pt; '>{1}<li>Rozpoczęcie wykładów godz. {2}</li><li>Zakończenie szkolenia godz. {3}</li></ul>", z.Data, rejestracja, z.CzasOd, z.CzasDo);
                    i++;
                }
                DataLabelProgram.EditValue = program;
                DataLabelMiejsce.EditValue = miejsce;
                DataLabelOperator.EditValue = dc.Session.Login.Operator.FullName;
                
                
                
                //Podstawianie numeru konta
                        //ZB: Rachunek domyślny dla oddziału terenowego
        Soneta.Kasa.EwidencjaSP rachunek = null;
        Soneta.Kasa.KasaModule km = Soneta.Kasa.KasaModule.GetInstance(zgl);
                 
         // teraz z ewdencji pod oddziałem
        // podstawiam zaznaczony lub pierwszy z brzegu jeśli nie ma zaznaconych
        foreach (Soneta.Kasa.EwidencjaSP ewid in km.EwidencjeSP.WgOddzial[zgl.Zgloszenie.Oddzial])
            {
                if (ewid is Soneta.Kasa.RachunekBankowyFirmyBase && ((bool)ewid.Features["DrukujNaFakturze"] || rachunek == null))
                {
                    rachunek = ewid;
                    if ((bool)ewid.Features["DrukujNaFakturze"]) break;
                }
            }
        
        // i podstawienie do labelków
        if (rachunek != null && rachunek.Rachunek!=null)
        {
            NrKonta.EditValue = rachunek.Rachunek.Bank!=null ? rachunek.Rachunek.Bank.Nazwa : "";
        }       

            }
		</script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server" ID="form">
		
			<ea:DataContext id="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
			<ea:DataRepeater ID="DataRepeater1" runat="server" RowTypeName="Soneta.CzlonkowieSzkolenia.ZgloszenieUczestnik,Soneta.CzlonkowieSzkolenia" OnBeforeRow="DataRepeaterBeforeRow">
			<ea:PageBreak runat="server" BreakFirstTimes="false"></ea:PageBreak>
			<p style="font-family:Arial; font-size:12pt;">
			<ea:DataLabel ID="DataLabelMiejscowosc" runat="server" Bold="false" DataMember="GrupaSzkol.Oddzial.Adres.Miejscowosc" />
			, dnia <ea:DataLabel  runat="server" Bold="false" ID="DataLabelDzis" />
            </p>
            <p style="font-family:Arial; font-size:12pt; font-weight:bold;">
            Sz. 
                <ea:DataLabel runat="server" ID="LabelPan1" DataMember="Uczestnik.Plec" Bold="False" >
                    <ValuesMap>
                        <ea:ValuesPair Key="Kobieta" Value="Pani" />
                        <ea:ValuesPair Key="Mężczyzna" Value="Pan" />
                    </ValuesMap>
                </ea:DataLabel>
                <ea:DataLabel  runat="server" Bold="false" ID="DataLabel1" DataMember="Uczestnik.Imie"/>
                <ea:DataLabel  runat="server" Bold="false" ID="DataLabel2" DataMember="Uczestnik.Nazwisko"/>
            </p>
			<p style="font-family:Arial; font-size:12pt;">
            Uprzejmie informujemy, że potwierdzamy 
                            <ea:DataLabel runat="server" ID="DataLabel3" DataMember="Uczestnik.Plec" Bold="False" >
                    <ValuesMap>
                        <ea:ValuesPair Key="Kobieta" Value="Pani" />
                        <ea:ValuesPair Key="Mężczyzna" Value="Pana" />
                    </ValuesMap>
                </ea:DataLabel>
            uczestnictwo w szkoleniu pt. 
            <ea:DataLabel  runat="server" ID="DataLabel4" DataMember="GrupaSzkol.RodzajSzkol.Nazwa" />
            w 
            <ea:DataLabel  runat="server" Bold="false" ID="DataLabelData" />
            , które odbędzie się w 
            <ea:DataLabel  runat="server" Bold="false" ID="DataLabelMiejsce" />
            .
            </p>
            <ea:DataLabel  runat="server" Bold="false" ID="DataLabelProgram" />

			<p style="font-family:Arial; font-size:12pt;">
             Informujemy, że w trakcie przerw na szkoleniu zapewniamy kawę, herbatę, ciasteczka, lunch.
            </p>

			<p style="font-family:Arial; font-size:12pt; text-align:center;">
            Prosimy o dokonanie wpłaty za udział w szkoleniu na numer konta<br />
                <ea:DataLabel ID="NrKonta" runat="server" Bold="false" />
            </p>
			    <p style="font-family:Arial; font-size:12pt; text-align:center;">
                    <br />
                </p>
			<p style="font-family:Arial; font-size:12pt; font-weight:bold;">
                Ze względów organizacyjnych uprzejmie prosimy o przesłanie kopii przelewu na 
                numer faxu:
                <ea:DataLabel DataMember="Zgloszenie.Oddzial.Adres.Faks" runat="server" Bold="false" />
            </p>
            <p style="font-family:Arial; font-size:12pt; ">
                Jeżeli będą Państwo mieli pytania odnośnie szkolenia, prosimy o kontakt pod 
                numerem tel.:
                <ea:DataLabel runat="server" Bold="false" DataMember="Zgloszenie.Oddzial.Adres.Telefon" />
            </p>
            <p style="font-family:Arial; font-size:12pt; ">
                Serdecznie zapraszamy do korzystania z naszych usług i odwiedzania strony 
                internetowej
                <ea:DataLabel ID="AdresWWW" runat="server" Bold="false" />
            </p>

<p style="font-family:Bookman Old Style; font-size:12pt; color:Red; font-weight:bold; ">
Proszę o informację zwrotną o dacie i miejscu urodzenia (dane potrzebne do wystawienia zaświadczenia)
 </p>
 <p style="font-family:Arial; font-size:12pt; ">
Z poważaniem<br /><br />
<ea:DataLabel runat="server" ID="DataLabelOperator" Bold="false" /><br />
Specjalista w Dziale Szkoleń
</p>
</ea:DataRepeater>


		</FORM>
	</BODY>
</HTML>


