﻿<%@ import Namespace="Soneta.CzlonkowieSzkolenia" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>RejestrZasiwadczenZarządcyBS</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
            public class Params : ContextBase
            {
                public Params(Context cx)
                    : base(cx)
                {
                    data = Date.Today;
                    miejsce = "";
                    egzaminatorzy = "-";
                    przewodniczący = "";
                    czlonkowie = "";
                }
                Date data;
                string miejsce;
                string przewodniczący;
                string czlonkowie;
                string egzaminatorzy;
                [Priority(10)]
                public Date Data
                {
                    get { return data; }
                    set { data = value; }
                }
                [Priority(20)]
                public string Miejsce
                {
                    get { return miejsce; }
                    set { miejsce = value; }
                }
                [Priority(30)]
                public string Przewodniczący
                {
                    get { return przewodniczący; }
                    set { przewodniczący = value; }
                }
                [Priority(40)]
                public string Członkowie
                {
                    get { return czlonkowie; }
                    set { czlonkowie= value; }
                }
                [Priority(50)]
                public string Egzaminatorzy
                {
                    get { return egzaminatorzy; }
                    set { egzaminatorzy= value; }
                }

            }


            Params param = null;
            [Context]
            public Params Param
            {
                get { return param; }
                set { param = value; }
            }
		    
            void OnContextLoad(Object sender, EventArgs args)
            {
                Soneta.CzlonkowieSzkolenia.GrupaSzkol grupa = (Soneta.CzlonkowieSzkolenia.GrupaSzkol)dc[typeof(Soneta.CzlonkowieSzkolenia.GrupaSzkol)];
                Soneta.Business.View ucz = grupa.Uczestnicy;
                ZgloszenieUczestnik z;
                ucz.Condition &= new FieldCondition.Equal("StatusZgloszenia", StatusZgloszenia.Aktywne);
                ucz.Sort = "Uczestnik.Nazwisko,Uczestnik.Imie";
                Grid.DataSource = ucz;
                DataLabelDataEgz.EditValue = param.Data;
                
                
                
                
                string table = String.Format("<table style='font-size:11pt;'><tr style='vertical-align:top; height:18mm;'><td style='width:45mm;'>Przewodniczący Komisji:</td><td style='width:50mm;'>{0}</td><td style='width:40mm; text-align:center; font-size:8pt; font-style:italic;'>&nbsp;<br/><hr/>podpis</td></tr>", param.Przewodniczący);
                string[] czl = param.Członkowie.Split(new string[]{","}, StringSplitOptions.RemoveEmptyEntries);
                for (int i = 0; i < czl.Length; i++)
                {
                    table += String.Format("<tr style='vertical-align:top; height:18mm;'><td>{0}</td><td>{1}</td><td style='text-align:center; font-size:8pt; font-style:italic;'>&nbsp;<br/><hr/>podpis</td></tr>", i == 0 ? "Członkowie:" : "&nbsp;", czl[i]);
                }
                table+="</table>";
                DataLabelPodpisy.EditValue = table;
                DataLabelPrzewodniczaczy.EditValue = param.Przewodniczący;
                DataLabelEgzaminatorzy.EditValue = param.Egzaminatorzy;
                DataLabelczlonkowie.EditValue = param.Członkowie;
                // nazwa oddziału  - Krzysiek Z
                
                    
            }
            void GridBeforeRow(Object sender, RowEventArgs args)
            {

                ZgloszenieUczestnik zgloszenie = (ZgloszenieUczestnik)args.Row;
                colNazwisko.EditValue = zgloszenie.Uczestnik.Nazwisko + " " + zgloszenie.Uczestnik.Imie;
                GridColumn3.EditValue = zgloszenie.OcenaKoncowa;
                switch (zgloszenie.OcenaKoncowa){
                    case "1":
                        GridColumn4.EditValue = "niedostateczny";
                        break;
                    case "2":
                        GridColumn4.EditValue = "dopuszczający";
                            break;
                    case "3":
                        GridColumn4.EditValue = "dostateczny";
                            break;
                    case "4":
                        GridColumn4.EditValue = "dobry";
                            break;
                    case "5":
                        GridColumn4.EditValue = "bardzo dobry";
                            break;
                    case "6":
                        GridColumn4.EditValue = "celujący";
                            break;
                    default:
                            GridColumn4.EditValue = "";
                            break;
                }
                //GridColumn4.EditValue = zgloszenie.OcenaKoncowa.
            }
    
		</script>
	</HEAD>
	<BODY>
	<table><tr style="vertical-align:top; width:30mm; height:18mm;"></tr></table>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="OnContextLoad" TypeName="Soneta.CzlonkowieSzkolenia.GrupaSzkol,Soneta.CzlonkowieSzkolenia"></ea:DataContext>
			<p style="text-align:center; font-weight:bold; font-family:Times New Roman; font-size:11pt; line-height:6mm; ">
			PROTOKÓŁ<br />
			Z PRZEBIEGU EGZAMINU KOŃCOWEGO<br />
			KURSU<br /><br />
			<span style="font-size:14pt; font-style:italic;"><ea:DataLabel runat="server" DataMember="RodzajSzkol.Nazwa" /> / <ea:DataLabel ID="DataLabel1" runat="server" DataMember="Numer" /> </span>
			</p>
			<p style=" font-family:Times New Roman; font-size:11pt; line-height:6mm;">
			                zorganizowanego w okresie od 
			<ea:DataLabel ID="DataLabel2" runat="server" DataMember="DataOd"  Bold="false"/>
			do
			<ea:DataLabel ID="DataLabel3" runat="server" DataMember="DataDo"  Bold="false"/>
			o zakresie tematycznym określonym w programie kursu.<br /><br />
			Egzamin został przeprowadzony w dniu <ea:DataLabel ID="DataLabelDataEgz" runat="server" Bold="false"/> przed Komisją Egzaminacyjną w składzie:
			</p>
			
			<table style=" font-family:Times New Roman; font-size:11pt; line-height:6mm; ">
			  <tr style="vertical-align:top;">
			    <td style="width:30mm;">Przewodniczący:<ea:DataLabel ID="DataLabelPrzewodniczaczy" runat="server">
                    </ea:DataLabel>
                  </td>
			    
			  </tr>
			  <tr style="vertical-align:top;">
			    <td >Członkowie:<ea:DataLabel ID="DataLabelczlonkowie" runat="server">
                    </ea:DataLabel>
                  </td>
			    
			  </tr>
			  <tr style="vertical-align:top;">
			    <td >z udziałem egzaminatorów:<ea:DataLabel ID="DataLabelEgzaminatorzy" runat="server">
                    </ea:DataLabel>
                  </td>
			    
			  </tr>
			</table>
			
			<br />
			<p style = " font-family:Times New Roman; font-size:11pt; line-height:6mm;">
			Tematy zadań egzaminacyjnych stanowią załączniki nr 1 do niniejszego protokołu.<br /><br />
			
			<b>WYNIKI EGZAMINU</b>
			</p>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.CzlonkowieSzkolenia.ZgloszenieUczestnik,Soneta.CzlonkowieSzkolenia" OnBeforeRow="GridBeforeRow">
				<Columns>
					<ea:GridColumn runat="server" Align="Center" DataMember="#" Caption="L.p." Width="5"></ea:GridColumn>
					<ea:GridColumn ID="colNazwisko" runat="server" Align="Left" Caption="Nazwisko i imię osoby zdającej"></ea:GridColumn>
				    <ea:GridColumn ID="GridColumn1" runat="server" Align="Left" 
                        Caption="Data urodzenia" DataMember="Uczestnik.DataUr" Width="15">
                    </ea:GridColumn>
                    <ea:GridColumn ID="GridColumn2" runat="server" Align="Left" 
                        Caption="Miejsce urodzenia" DataMember="Uczestnik.MiejsceUr" Width="25">
                    </ea:GridColumn>
                    <ea:GridColumn ID="GridColumn3" runat="server" 
                        Caption="Ocena z egzaminu~oznaczenie cyfrowe" Width="13" 
                        Align="Center" >
                    </ea:GridColumn>
                    <ea:GridColumn ID="GridColumn4" runat="server" 
                        Caption="Ocena z egzaminu~oznaczenie słowne" Width="13">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<ea:SectionMarker ID="SectionMarker1" runat="server" SectionType="Body" />
			<p style=" font-family:Times New Roman; font-size:11pt; line-height:6mm;">
			    Wykaz kwalifikacji zawodowych potwierdzonych na egzaminie:<br />
			<ea:DataLabel ID="DataLabelKwalifikacje" runat="server" Bold="false" DataMember="RodzajSzkol.Opis"/>
			<ea:SectionMarker ID="SectionMarker2" runat="server" SectionType="Body" />
			</p><br />
			<p style=" font-family:Times New Roman; font-size:11pt; line-height:6mm;">
			Oceny powyższe zostały wpisane do dziennika kursu w dniu ............................................<br /><br /><br /><br />
			</p>
			<ea:SectionMarker ID="SectionMarker3" runat="server" SectionType="Body" />
			    <ea:DataLabel ID="DataLabelPodpisy" runat="server" Bold="false" />
		</FORM>
	</BODY>
</HTML>

