﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="65001" %>
<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Core" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>NIP-3 (4)</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
		public enum _PrzeznaczenieFormularza {
            ZgłoszenieIdentyfikacyjne, ZgłoszenieAktualizacyjne
        }
        public class Params : ContextBase {
            public readonly PracHistoria historia;
            public Params(Context context)
                : base(context) {
                historia = (PracHistoria)context[typeof(PracHistoria)];
                zgłoszenie = historia.NIP == "";
                foreach (RachunekBankowyPracownika rbp in historia.Pracownik.Rachunki)
                    if (!rbp.Blokada) {
                        rachunek = rbp;
                        break;
                    }
            }
            public bool zgłoszenie;
            [Priority(10)]
            [Caption("Przeznacz.formularza")]
            public _PrzeznaczenieFormularza PrzeznaczenieFormularza {
                get { return zgłoszenie ? _PrzeznaczenieFormularza.ZgłoszenieIdentyfikacyjne : _PrzeznaczenieFormularza.ZgłoszenieAktualizacyjne; }
                set {
                    zgłoszenie = value == _PrzeznaczenieFormularza.ZgłoszenieIdentyfikacyjne;
                    OnChanged(EventArgs.Empty);
                }
            }
            Date dataZamieszakania;
            [Priority(20)]
            [Caption("Data zamieszakania")]
            public Date DataZamieszkania {
                get { return dataZamieszakania; }
                set {
                    dataZamieszakania = value;
                    OnChanged(EventArgs.Empty);
                }
            }
            bool korespondencjaNaZameldowania;
            [Priority(30)]
            [Caption("Kor.na adr.zameld.")]
            public bool KorespondencjaNaZameldowania {
                get { return korespondencjaNaZameldowania; }
                set {
                    korespondencjaNaZameldowania = value;
                    OnChanged(EventArgs.Empty);
                }
            }
            Date dataZameldowania;
            [Priority(40)]
            [Caption("Data zameldowania")]
            public Date DataZameldowania {
                get { return dataZameldowania; }
                set {
                    dataZameldowania = value;
                    OnChanged(EventArgs.Empty);
                }
            }
            RachunekBankowyPracownika rachunek;
            [Caption("Rachunek bankowy")]
            [Priority(50)]
            public RachunekBankowyPracownika Rachunek {
                get { return rachunek; }
                set {
                    rachunek = value;
                    if (rachunek != null)
                        rezygnacja = false;
                    OnChanged(EventArgs.Empty);
                }
            }
            public LookupInfo.Item GetListRachunek() {
                return Soneta.Kasa.RachBankPodmiot.RachunkiPodmiotuLookup(historia.Pracownik);
            }
            bool rezygnacja;
            [Caption("Rezygnacja")]
            [Priority(60)]
            public bool Rezygnacja {
                get { return rezygnacja; }
                set {
                    rezygnacja = value;
                    OnChanged(EventArgs.Empty);
                }
            }
            public bool IsReadOnlyRezygnacja() {
                return rachunek != null;
            }
            bool częśćE;
            [Caption("Wypełnij cześć E")]
            [Priority(70)]
            public bool CzęśćE {
                get { return częśćE; }
                set {
                    częśćE = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }
		Params info;
        [Context]
        public Params Info {
            set { info = value; }
        }
        void OnContextLoad(object sender, EventArgs e) {
            if (dc.OverPrint) {
                dc.LeftMargin = 6;
                dc.TopMargin = 6;
                dc.PageZoom = "114%";
            }
            if (info.zgłoszenie)
                p4_1.EditValue = true;
            else
                p4_2.EditValue = true;
            if (!info.zgłoszenie) {
                PracHistoria prev = (PracHistoria)info.historia.Pracownik.Historia.GetPrev(info.historia);
                if (prev != null) {
                    zp8.EditValue = string.Compare(prev.PESEL, info.historia.PESEL, true) != 0;
                    zp9.EditValue = string.Compare(prev.Nazwisko, info.historia.Nazwisko, true) != 0;
                    zp10.EditValue = string.Compare(prev.Imie, info.historia.Imie, true) != 0;
                    zp11.EditValue = string.Compare(prev.ImieDrugie, info.historia.ImieDrugie, true) != 0;
                    zp12.EditValue = string.Compare(prev.ImieOjca, info.historia.ImieOjca, true) != 0;
                    zp13.EditValue = string.Compare(prev.ImieMatki, info.historia.ImieMatki, true) != 0;
                    zp14.EditValue = prev.Urodzony.Data!=info.historia.Urodzony.Data;
                    zp15.EditValue = string.Compare(prev.Urodzony.Miejsce, info.historia.Urodzony.Miejsce, true) != 0;
                    zp17.EditValue = string.Compare(prev.NazwiskoRodowe, info.historia.NazwiskoRodowe, true) != 0;
                    zp18.EditValue = prev.Dokument.Rodzaj != info.historia.Dokument.Rodzaj;
                    zp19.EditValue = string.Compare(prev.Dokument.SeriaNumer, info.historia.Dokument.SeriaNumer, true) != 0;
                    zp20.EditValue = string.Compare(prev.Obywatelstwo.Nazwa, info.historia.Obywatelstwo.Nazwa, true) != 0;
                }
            }
            p26.EditValue = info.DataZamieszkania;
            if (info.historia.AdresZamieszkania.IsEmpty()) {
                p37.DataMember = "";
                p38.DataMember = "";
                p39.DataMember = "";
                p40.DataMember = "";
                p41.DataMember = "";
                p42.DataMember = "";
                p43.DataMember = "";
                p44.DataMember = "";
                p45.DataMember = "";
                p46.DataMember = "";
                p47.DataMember = "";
                p48.DataMember = "";
                p49.DataMember = "";
            }
            if (info.Rezygnacja)
                rachunekRezygnacja.EditValue = true;
            else if (info.Rachunek != null) {
                Soneta.Kasa.RachunekBankowy rb = info.Rachunek.Rachunek;
                if (rb.Bank != null) {
                    if (rb.Bank.Adres.Kraj != "" && rb.Bank.Adres.Kraj.ToLower() != "polska")
                        rachunekKraj.EditValue = rb.Bank.Adres.Kraj;
                    rachunekNazwaBanku.EditValue = rb.Bank.Nazwa;
                }
                if (info.Rachunek.Nazwa1 != "")
                    rachunekPosiadacz.EditValue = info.Rachunek.Nazwa1 + ", " + info.Rachunek.Nazwa2;
                else
                    rachunekPosiadacz.EditValue = info.historia.Pracownik.ImięNazwisko + ", " + info.historia.Adres.Linia1 + ", " + info.historia.Adres.Linia2;
                rachunekNumer.EditValue = rb.Numer;
            }
            if (info.CzęśćE) {
                CoreModule.ConfigNode.FirmaNode.PieczątkaLeaf pieczątka = CoreModule.GetInstance(info).Config.Firma.Pieczątka;
                p67.EditValue = pieczątka.NIP;
                p68.EditValue = pieczątka.Nazwa;
            }
        }
        static void Msg(object value) {
        }
		    
    </script>
	</HEAD>
	<body leftMargin="0" rightMargin="0">
		<form id="NIP_3_4" method="post" runat="server">
			<ea:deklaracjaheader id="DeklaracjaHeader1" style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 0px"
				runat="server" Width="630px" StylNagłówka="WypałniaSkładający"></ea:deklaracjaheader>
<ea:framelabel id="FrameLabel21" style="Z-INDEX: 101; LEFT: 0px; POSITION: absolute; TOP: 21px"
				runat="server" Width="273px" ValueStyle="nip_w" DataMember="NIP" Height="28px" 
                Text="1. Numer Identyfikacji Podatkowej (NIP)"></ea:framelabel>
<ea:framelabel id="FrameLabel22" style="Z-INDEX: 102; LEFT: 273px; POSITION: absolute; TOP: 21px"
				runat="server" Width="119px" Height="28px" Text="Nr dokumentu" FrameStyle="SmallBoldGray" Number="2"></ea:framelabel>
<ea:framelabel id="FrameLabel23" style="Z-INDEX: 103; LEFT: 392px; POSITION: absolute; TOP: 21px"
				runat="server" Width="77px" Height="30px" Text="Status" FrameStyle="SmallBoldGray" Number="3"></ea:framelabel>
<ea:framelabel id="Framelabel77" style="Z-INDEX: -2; LEFT: 0px; POSITION: absolute; TOP: 49px; height: 60px; width: 629px;"
				runat="server">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel34" style="Z-INDEX: -1; LEFT: 85px; POSITION: absolute; TOP: 56px; height: 51px;"
				runat="server" Width="525px" 
                Text="ZGŁOSZENIE IDENTYFIKACYJNE/ZGŁOSZENIE AKTUALIZACYJNE &lt;.INDEXUP&gt;1)&lt;./&gt; OSOBY FIZYCZNEJ NIEPROWADZĄCEJ SAMODZIELNIE DZIAŁALNOŚCI GOSPODARCZEJ" 
                FrameStyle="BigBold" FrameBorderStyle="None" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="labelPIT" 
                style="Z-INDEX: 104; LEFT: 15px; POSITION: absolute; TOP: 62px; width: 71px; right: 821px;" 
                runat="server" Height="21px" FrameStyle="BigBold" FrameBorderStyle="None" 
                Text="NIP-3"></ea:framelabel>
<ea:framelabel id="FrameLabel24" style="Z-INDEX: 109; LEFT: 0px; POSITION: absolute; TOP: 112px; height: 119px;"
				runat="server" Width="630px" FrameStyle="SmallBoldYellow" 
                FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="FrameLabel25" style="Z-INDEX: 110; LEFT: 7px; POSITION: absolute; TOP: 115px; right: 821px;"
				runat="server" Width="91px" Height="14px" Text="Podstawa prawna:" 
                FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel26" style="Z-INDEX: 111; LEFT: 133px; POSITION: absolute; TOP: 115px"
				runat="server" Width="490px" Height="21px" Text='Ustawa z dnia 13 października 1995 r. o zasadach ewidencji i identyfikacji podatników i płatników (Dz.U. z 2004 r. Nr 269, 
poz.2681, z późn. zm.), zwana dalej „ustawą".' FrameStyle="SmallYellow"
				FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel27" style="Z-INDEX: 112; LEFT: 7px; POSITION: absolute; TOP: 136px; right: 799px;"
				runat="server" Width="91px" Height="7px" Text="Składający:" FrameStyle="SmallYellow" 
                FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel28" style="Z-INDEX: 113; LEFT: 133px; POSITION: absolute; TOP: 136px; height: 62px;"
				runat="server" Width="490px" Text="Formularz przeznaczony dla osób fizycznych:&lt;br&gt;
a) nieprowadzących w ogóle działalności gospodarczej,&lt;br&gt;
b) wspólników spółek cywilnych, jawnych, partnerskich, komandytowych i komandytowo-akcyjnych, jeżeli poza 
uczestnictwem w tych spółkach nie prowadzą innej działalności gospodarczej,&lt;br&gt;
c) płatników podatku dochodowego od osób fizycznych oraz płatników składek na ubezpieczenia społeczne lub 
zdrowotne, jeżeli nie są podatnikami." FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel30" style="Z-INDEX: 114; LEFT: 7px; POSITION: absolute; TOP: 200px"
				runat="server" Width="91px" Height="7px" Text="Termin składania:" 
                FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel31" style="Z-INDEX: 115; LEFT: 133px; POSITION: absolute; TOP: 200px; height: 8px;"
				runat="server" Width="490px" Text="Zgodnie z art.6, 7, 8 i 9 ustawy."
				FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel32" style="Z-INDEX: 116; LEFT: 7px; POSITION: absolute; TOP: 212px"
				runat="server" Width="91px" Height="7px" Text="Miejsce składania:" 
                FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel33" style="Z-INDEX: 117; LEFT: 133px; POSITION: absolute; TOP: 212px; height: 10px;"
				runat="server" Width="490px" Text="Zgłoszenie składa się do naczelnika urzędu skarbowego  właściwego w rozumieniu art.4 ustawy."
				FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel17" style="Z-INDEX: 118; LEFT: 0px; POSITION: absolute; TOP: 231px; height: 146px;"
				runat="server" Width="630px" Text="A. CEL  I MIEJSCE ZŁOŻENIA ZGŁOSZENIA&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;W poz. 4 należy zaznaczyć właściwy kwadrat. Kwadrat nr 1: gdy formularz składany  jest  jako zgłoszenie identyfikacyjne, w celu nadania NIP. Kwadrat nr 2: gdy formularz składany jest jako zgłoszenie aktualizacyjne w przypadku zmiany danych objętych zgłoszeniem tzn. zmiany danych składającego  (w tym po zakończeniu prowadzonej samodzielnie działalności gospodarczej) lub zmiany naczelnika urzędu skarbowego właściwego w sprawach ewidencji." 
                FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="Framelabel147" style="Z-INDEX: 123; LEFT: 28px; POSITION: absolute; TOP: 287px; width: 257px;"
				runat="server" Height="28px" 
                Text="Przeznaczenie formularza &lt;.Normal&gt;(zaznaczyć właściwy kwadrat):&lt;./&gt;" 
                Number="4">
                </ea:FrameLabel>
<ea:framelabel id="p6" style="Z-INDEX: 119; LEFT: 287px; POSITION: absolute; TOP: 287px; width: 343px;"
				runat="server" Height="28px" 
                Text="Naczelnik urzędu skarbowego, do którego adresowane jest zgłoszenie" Number="5" 
                DataMember="Podatki.UrzadSkarbowy.Nazwa"></ea:framelabel>
<ea:checklabel id="p4_1" style="Z-INDEX: 257; LEFT: 33px; POSITION: absolute; TOP: 296px; right: 751px;"
				runat="server" Width="136px" Height="14px" Text="zgłoszenie identyfikacyjne" 
                Number="1" NumberAlignLeft="False">
            </ea:CheckLabel>
<ea:checklabel id="p4_2" style="Z-INDEX: 257; LEFT: 163px; POSITION: absolute; TOP: 296px"
				runat="server" Width="136px" Height="14px" Text="zgłoszenie aktualizacyjne" Number="2" 
                NumberAlignLeft="False">
            </ea:CheckLabel>
<ea:framelabel id="Framelabel148" style="Z-INDEX: 123; LEFT: 28px; POSITION: absolute; TOP: 315px"
				runat="server" Width="602px" Height="28px" 
                Text="Nastąpiła zmiana właściwości naczelnika urzędu skarbowego &lt;.Normal&gt;- wypełnić tylko w przypadku zgłoszenia aktualizacyjnego(zaznaczyć właściwy kwadrat)&lt;./&gt;" 
                Number="6">
                </ea:FrameLabel>
<ea:checklabel id="p6_1" style="Z-INDEX: 257; LEFT: 219px; POSITION: absolute; TOP: 324px"
				runat="server" Width="136px" DataMember="" Height="14px" Text="nie" 
                Number="1" NumberAlignLeft="False" ComparedValue="False">
            </ea:CheckLabel>
<ea:checklabel id="p6_4" style="Z-INDEX: 127; LEFT: 358px; POSITION: absolute; TOP: 324px"
				runat="server" Width="133px" DataMember="" Height="14px" Text="tak" 
                Number="2" NumberAlignLeft="False"></ea:checklabel>
<ea:framelabel id="p5" style="Z-INDEX: 119; LEFT: 28px; POSITION: absolute; TOP: 343px; width: 601px;"
				runat="server" Height="28px" Text="Poprzednio właściwy naczelnik urzędu skarbowego &lt;.Normal&gt;(należy wypełnić tylko w przypadku zaznaczenia w poz.6  kwadratu nr 2)&lt;./&gt;" 
                Number="7"></ea:framelabel>
<ea:framelabel id="FrameLabel1" style="Z-INDEX: 120; LEFT: 0px; POSITION: absolute; TOP: 378px"
				runat="server" Width="630px" Height="28px" Text="B. DANE SKŁADAJĄCEGO" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel2" style="Z-INDEX: 121; LEFT: 0px; POSITION: absolute; TOP: 406px; height: 224px;"
				runat="server" Width="630px" Text="B.1. DANE IDENTYFIKACYJNE" FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel3" style="Z-INDEX: 122; LEFT: 28px; POSITION: absolute; TOP: 434px; width: 231px; right: 688px;"
				runat="server" Height="28px" Text="Numer ewidencyjny PESEL" Number="8" 
                DataMember="PESEL"></ea:framelabel>
<ea:framelabel id="FrameLabel4" style="Z-INDEX: 128; LEFT: 259px; POSITION: absolute; TOP: 434px; height: 30px; width: 370px;"
				runat="server" DataMember="Nazwisko" Text="Nazwisko" Number="9"></ea:framelabel>
<ea:framelabel id="FrameLabel6" style="Z-INDEX: 130; LEFT: 28px; POSITION: absolute; TOP: 462px; right: 751px; width: 294px;"
				runat="server" DataMember="Imie" Height="28px" Text="Pierwsze imię" Number="10"></ea:framelabel>
<ea:framelabel id="FrameLabel7" style="Z-INDEX: 131; LEFT: 322px; POSITION: absolute; TOP: 462px; width: 307px;"
				runat="server" DataMember="ImieDrugie" Height="28px" Text="Drugie imię" Number="11"></ea:framelabel>
            &nbsp;
<ea:framelabel id="FrameLabel9" style="Z-INDEX: 133; LEFT: 28px; POSITION: absolute; TOP: 490px; width: 295px;"
				runat="server" DataMember="ImieOjca" Height="28px" Text="Imię ojca" Number="12"></ea:framelabel>
<ea:framelabel id="FrameLabel8" style="Z-INDEX: 132; LEFT: 322px; POSITION: absolute; TOP: 490px; width: 306px; right: 289px;"
				runat="server" DataMember="ImieMatki" Height="28px" Text="Imię matki" Number="13"></ea:framelabel>
<ea:framelabel id="Framelabel105" style="Z-INDEX: 145; LEFT: 28px; POSITION: absolute; TOP: 518px; width: 224px; right: 609px;"
				runat="server" ValueStyle="Date" DataMember="Urodzony.Data" Height="28px" 
                Text="Data urodzenia" Number="14"></ea:framelabel>
<ea:framelabel id="Framelabel103" style="Z-INDEX: 143; LEFT: 252px; POSITION: absolute; TOP: 518px; width: 375px;"
				runat="server" DataMember="Urodzony.Miejsce" Height="28px" Number="15" 
                Text="Miejsce (miejscowość) urodzenia"></ea:framelabel>
<ea:framelabel id="FrameLabel10" style="Z-INDEX: 134; LEFT: 28px; POSITION: absolute; TOP: 546px; width: 225px;"
				runat="server" Height="28px" Text="Płeć &lt;.Normal&gt;(zaznaczyć właściwy kwadrat)" 
                Number="16"></ea:framelabel>
<ea:framelabel id="FrameLabel11" style="Z-INDEX: 135; LEFT: 252px; POSITION: absolute; TOP: 546px; width: 379px;"
				runat="server" DataMember="NazwiskoRodowe" Height="28px" Text="Nazwisko rodowe (według świadectwa urodzenia)" 
                Number="17"></ea:framelabel>
<ea:checklabel id="p16_2" style="Z-INDEX: 257; LEFT: 141px; POSITION: absolute; TOP: 554px"
				runat="server" Width="136px" DataMember="Plec" Height="14px" Text="mężczyzna" 
                Number="2" NumberAlignLeft="False" ComparedValue="Mężczyzna">
            </ea:CheckLabel>
<ea:checklabel id="p16_1" style="Z-INDEX: 257; LEFT: 34px; POSITION: absolute; TOP: 555px; right: 761px;"
				runat="server" Width="136px" Height="14px" Text="kobieta" Number="1" 
                NumberAlignLeft="False" ComparedValue="Kobieta" DataMember="Plec">
            </ea:CheckLabel>
<ea:framelabel id="FrameLabel13" style="Z-INDEX: 137; LEFT: 28px; POSITION: absolute; TOP: 574px; bottom: 363px;"
				runat="server" Width="252px" DataMember="Dokument.Rodzaj" Height="28px" 
                Text="Rodzaj dokumentu stwierdzającego tożsamość &lt;.INDEXUP&gt;2)" 
                Number="18">
    <ValuesMap>
        <ea:ValuesPair Key="Niezdefiniowany" Value="" />
    </ValuesMap>
            </ea:framelabel>
<ea:framelabel id="FrameLabel12" style="Z-INDEX: 136; LEFT: 280px; POSITION: absolute; TOP: 574px; width: 348px;"
				runat="server" DataMember="Dokument.SeriaNumer" Height="28px" 
                Text="Seria i numer dokumentu stwierdzającego tożsamość &lt;.INDEXUP&gt;2)" 
                Number="19"></ea:framelabel>
<ea:framelabel id="FrameLabel15" style="Z-INDEX: 139; LEFT: 28px; POSITION: absolute; TOP: 602px; width: 601px;"
				runat="server" DataMember="Obywatelstwo.Nazwa" Height="28px" Text="Obywatelstwo &lt;.Normal&gt;(należy podać wszystkie obywatelstwa posiadane w dniu składania zgłoszenia)" 
                Number="20" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel41" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 630px; height: 70px;"
				runat="server" Width="630px" Text="B.2. INFORMACJA O ZMIANACH DANYCH WYKAZANYCH W CZĘŚCI B.1.&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Należy wypełnić tylko w przypadku zgłoszenia aktualizacyjnego i tylko wówczas, gdy nastąpiła zmiana danych w części B.1." 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel104" style="Z-INDEX: 144; LEFT: 28px; POSITION: absolute; TOP: 665px; width: 600px; height: 34px;"
				runat="server" 
                Text="Numery zmienionych pozycji &lt;.Normal&gt;(należy zaznaczyć kwadraty z numerami pozycji, w których nastąpiła zmiana danych):" 
                Number="21"></ea:framelabel>
<ea:checklabel id="zp8" style="Z-INDEX: 145; LEFT: 54px; POSITION: absolute; TOP: 676px; width: 23px;"
				runat="server" Height="14px" Number="8" NumberAlignLeft="False" CheckStyle="Rectangle"></ea:checklabel>
<ea:checklabel id="zp9" style="Z-INDEX: 145; LEFT: 91px; POSITION: absolute; TOP: 676px; width: 23px;"
				runat="server" Height="14px" Number="9" NumberAlignLeft="False" 
                CheckStyle="Rectangle"></ea:checklabel>
<ea:checklabel id="zp10" style="Z-INDEX: 145; LEFT: 134px; POSITION: absolute; TOP: 676px"
				runat="server" Width="14px" Height="14px" Number="10" NumberAlignLeft="False" 
                CheckStyle="Rectangle"></ea:checklabel>
<ea:checklabel id="zp11" style="Z-INDEX: 145; LEFT: 177px; POSITION: absolute; TOP: 676px"
				runat="server" Width="14px" DataMember="" Height="14px" Number="11" 
                NumberAlignLeft="False" CheckStyle="Rectangle"></ea:checklabel>
<ea:checklabel id="zp12" style="Z-INDEX: 145; LEFT: 220px; POSITION: absolute; TOP: 676px; right: 672px;"
				runat="server" Width="14px" DataMember="" Height="14px" Number="12" 
                NumberAlignLeft="False" CheckStyle="Rectangle"></ea:checklabel>
<ea:checklabel id="zp13" style="Z-INDEX: 145; LEFT: 263px; POSITION: absolute; TOP: 676px"
				runat="server" Width="14px" DataMember="" Height="14px" Number="13" 
                NumberAlignLeft="False" CheckStyle="Rectangle"></ea:checklabel>
<ea:checklabel id="zp14" style="Z-INDEX: 145; LEFT: 306px; POSITION: absolute; TOP: 676px; right: 568px;"
				runat="server" Width="14px" DataMember="" Height="14px" Number="14" 
                NumberAlignLeft="False" CheckStyle="Rectangle"></ea:checklabel>
<ea:checklabel id="zp15" style="Z-INDEX: 145; LEFT: 349px; POSITION: absolute; TOP: 676px; right: 531px;"
				runat="server" Width="14px" Height="14px" Number="15" NumberAlignLeft="False" 
                CheckStyle="Rectangle"></ea:checklabel>
<ea:checklabel id="zp17" style="Z-INDEX: 145; LEFT: 392px; POSITION: absolute; TOP: 676px"
				runat="server" Width="14px" Height="14px" Number="17" NumberAlignLeft="False" 
                CheckStyle="Rectangle"></ea:checklabel>
<ea:checklabel id="zp18" style="Z-INDEX: 145; LEFT: 435px; POSITION: absolute; TOP: 676px; right: 472px;"
				runat="server" Width="14px" Height="14px" Number="18" NumberAlignLeft="False" 
                CheckStyle="Rectangle"></ea:checklabel>
<ea:checklabel id="zp19" style="Z-INDEX: 145; LEFT: 478px; POSITION: absolute; TOP: 676px"
				runat="server" Width="14px" Height="14px" Number="19" NumberAlignLeft="False" 
                CheckStyle="Rectangle"></ea:checklabel>
<ea:checklabel id="zp20" style="Z-INDEX: 145; LEFT: 519px; POSITION: absolute; TOP: 676px"
				runat="server" Width="14px" Height="14px" Number="20" NumberAlignLeft="False" 
                CheckStyle="Rectangle"></ea:checklabel>
<ea:framelabel id="Framelabel81" style="Z-INDEX: 141; LEFT: 0px; POSITION: absolute; TOP: 700px; height: 55px;"
				runat="server" Width="630px" 
                Text="B.3. INFORMACJA O NUMERACH IDENTYFIKACYJNYCH UZYSKANYCH W INNYCH KRAJACH&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Należy wypełnić tylko wówczas, gdy składający uzyskał numery służące identyfikacji dla celów podatkowych w innych krajach." 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel102" style="Z-INDEX: 142; LEFT: 28px; POSITION: absolute; TOP: 728px; width: 134px; right: 736px;"
				runat="server" DataMember="Obywatelstwo.KrajDokumentu" Height="28px" Text="Kraj" 
                Number="22"></ea:framelabel>
<ea:framelabel id="Framelabel84" style="Z-INDEX: 144; LEFT: 161px; POSITION: absolute; TOP: 728px; width: 166px;"
				runat="server" DataMember="Obywatelstwo.NumerPodatnika" Height="28px" Text="Numer" 
                Number="23">
                </ea:FrameLabel>
<ea:framelabel id="Framelabel149" style="Z-INDEX: 142; LEFT: 329px; POSITION: absolute; TOP: 728px; width: 134px; right: 428px;"
				runat="server" Height="28px" Text="Kraj" Number="24"></ea:framelabel>
<ea:framelabel id="Framelabel150" style="Z-INDEX: 144; LEFT: 462px; POSITION: absolute; TOP: 728px; width: 166px;"
				runat="server" Height="28px" Text="Numer" Number="25">
                </ea:FrameLabel>
<ea:framelabel id="Framelabel101" style="Z-INDEX: 146; LEFT: 0px; POSITION: absolute; TOP: 756px; height: 132px;"
				runat="server" Width="630px" Text="B.4. ADRES MIEJSCA ZAMIESZKANIA &lt;/font&gt;&lt;.Footer&gt;Na podstawie  tego adresu określa się  właściwość naczelnika urzędu skarbowego w sprawach ewidencji. Adres ten  będzie równocześnie adresem do korespondencji, chyba że składający zaznaczy kwadrat w pozycji 38.&lt;br&gt;W przypadku zgłoszenia aktualizacyjnego, jeżeli w poz.6 formularza zaznaczony został kwadrat&lt;br&gt;nr 1 i nie nastąpiła zmiana adresu miejsca zamieszkania, to poz.26 (data zamieszkania) nie musi być wypełniona." 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="p26" style="Z-INDEX: 149; LEFT: 434px; POSITION: absolute; TOP: 777px"
				runat="server" Width="196px" Height="28px" Text="Data zamieszkania" Number="26" 
                ValueStyle="Date"></ea:framelabel>
<ea:framelabel id="Framelabel106" style="Z-INDEX: 147; LEFT: 28px; POSITION: absolute; TOP: 805px"
				runat="server" Width="140px" DataMember="Adres.Kraj" Height="28px" Text="Kraj" 
                Number="27" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel107" style="Z-INDEX: 148; LEFT: 168px; POSITION: absolute; TOP: 805px"
				runat="server" Width="266px" DataMember="Adres.Wojewodztwo" Height="28px" 
                Text="Województwo" Number="28"></ea:framelabel>
<ea:framelabel id="Framelabel108" style="Z-INDEX: 149; LEFT: 434px; POSITION: absolute; TOP: 805px"
				runat="server" Width="196px" DataMember="Adres.Powiat" Height="28px" Text="Powiat" 
                Number="29"></ea:framelabel>
<ea:framelabel id="Framelabel109" style="Z-INDEX: 150; LEFT: 28px; POSITION: absolute; TOP: 833px"
				runat="server" Width="161px" DataMember="Adres.Gmina" Height="28px" Text="Gmina" 
                Number="30"></ea:framelabel>
<ea:framelabel id="Framelabel110" style="Z-INDEX: 151; LEFT: 189px; POSITION: absolute; TOP: 833px"
				runat="server" Width="301px" DataMember="Adres.Ulica" Height="28px" Text="Ulica" 
                Number="31"></ea:framelabel>
<ea:framelabel id="Framelabel111" style="Z-INDEX: 152; LEFT: 490px; POSITION: absolute; TOP: 833px"
				runat="server" Width="70px" DataMember="Adres.NrDomu" Height="28px" Text="Nr domu" 
                Number="33"></ea:framelabel>
<ea:framelabel id="Framelabel112" style="Z-INDEX: 153; LEFT: 560px; POSITION: absolute; TOP: 833px"
				runat="server" Width="70px" DataMember="Adres.NrLokalu" Height="28px" Text="Nr lokalu" 
                Number="31"></ea:framelabel>
<ea:framelabel id="Framelabel113" style="Z-INDEX: 154; LEFT: 28px; POSITION: absolute; TOP: 861px; right: 639px;"
				runat="server" Width="252px" DataMember="Adres.Miejscowosc" Height="28px" Text="Miejscowość" 
                Number="34"></ea:framelabel>
<ea:framelabel id="Framelabel114" style="Z-INDEX: 155; LEFT: 280px; POSITION: absolute; TOP: 861px; "
				runat="server" Width="105px" ValueStyle="PostalCode" DataMember="Adres.KodPocztowy" 
                Height="28px" Text="Kod pocztowy" Number="35" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel115" style="Z-INDEX: 156; LEFT: 385px; POSITION: absolute; TOP: 861px; height: 30px;"
				runat="server" Width="245px" DataMember="Adres.Poczta" Text="Poczta" Number="36"></ea:framelabel>
<ea:framelabel id="FrameLabel182" style="Z-INDEX: 254; LEFT: 0px; POSITION: absolute; TOP: 891px; height: 21px;"
				runat="server" Width="630px" Text="1) Niniejszy formularz może być składany w charakterze zgłoszenia identyfikacyjnego lub zgłoszenia aktualizacyjnego.  W zgłoszeniu aktualizacyjnym&lt;br&gt;należy podać NIP składającego (poz.1)."
				FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel183" style="Z-INDEX: 254; LEFT: 0px; POSITION: absolute; TOP: 912px; height: 21px;"
				runat="server" Width="630px" Text="2) W przypadku obywateli polskich należy podać dane z dowodu osobistego, a jedynie w przypadku nieposiadania dowodu osobistego, z innego dokumentu stwierdzającego tożsamość."
				FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:deklaracjafooter id="footer1" 
                style="Z-INDEX: 163; LEFT: 490px; POSITION: absolute; TOP: 924px" runat="server"
				Width="154px" Height="10px" TitleWidth="106" Symbol="NIP-3" PageNumber="1" 
                PageTotal="2" Version="4"></ea:deklaracjafooter>
<ea:deklaracjaheader id="DeklaracjaHeader2" style="Z-INDEX: 165; LEFT: 0px; POSITION: absolute; TOP: 980px"
				runat="server" Width="630px" StylNagłówka="WypałniaSkładający"></ea:deklaracjaheader>
<ea:framelabel id="FrameLabel16" style="Z-INDEX: -1; LEFT: 0px; POSITION: absolute; TOP: 1001px; height: 165px;"
				runat="server" Width="630px" Text="B.5. ADRES MIEJSCA ZAMELDOWANIA (stałego lub czasowego, jeżeli brak jest stałego)&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Pozycje od 38 do 49 należy wypełniać tylko wówczas, gdy adres miejsca zameldowania jest inny niż podany adres miejsca zamieszkania. W przypadku zgłoszenia aktualizacyjnego, gdy adres miejsca zameldowania jest inny niż podany adres miejsca zamieszkania, to jeżeli w poz.6 formularza zaznaczone został kwadrat nr 1 i nie nastąpiła zmiana adresu miejsca zameldowania, poz.39 (data zameldowania) nie musi być wypełniona. " 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:checklabel id="p38" style="Z-INDEX: 168; LEFT: 237px; POSITION: absolute; TOP: 1054px"
				runat="server" Width="200px" Height="14px" NumberAlignLeft="False" 
                Text="Kwadrat należy zaznaczyć jeżeli korespondencja ma być wysyłana na niżej podany adres miejsca zameldowania" 
                CheckVertMiddle="True"></ea:checklabel>
<ea:framelabel id="p29" style="Z-INDEX: 167; LEFT: 28px; POSITION: absolute; TOP: 1057px"
				runat="server" Width="196px" Height="28px" Number="37"></ea:framelabel>
<ea:framelabel id="p28" style="Z-INDEX: 167; LEFT: 224px; POSITION: absolute; TOP: 1057px; width: 210px;"
				runat="server" Height="28px" Number="38"></ea:framelabel>
<ea:framelabel id="p39" style="Z-INDEX: 167; LEFT: 434px; POSITION: absolute; TOP: 1057px"
				runat="server" Width="196px" Height="28px" Text="Data zameldowania" Number="39" 
                ValueStyle="Date"></ea:framelabel>
<ea:checklabel id="p37" style="Z-INDEX: 168; LEFT: 37px; POSITION: absolute; TOP: 1062px"
				runat="server" Width="180px" Height="14px" NumberAlignLeft="False" 
                Text="Kwadrat należy zaznaczyć, jeżeli składający nie posiada adresu miejsca zameldowania" 
                CheckVertMiddle="True"></ea:checklabel>
<ea:framelabel id="p40" style="Z-INDEX: 147; LEFT: 28px; POSITION: absolute; TOP: 1085px"
				runat="server" Width="140px" DataMember="AdresZameldowania.Kraj" Height="28px" Text="Kraj" 
                Number="40"></ea:framelabel>
<ea:framelabel id="p41" style="Z-INDEX: 148; LEFT: 168px; POSITION: absolute; TOP: 1085px; right: 485px;"
				runat="server" Width="266px" DataMember="AdresZameldowania.Wojewodztwo" Height="28px" 
                Text="Województwo" Number="41"></ea:framelabel>
<ea:framelabel id="p42" style="Z-INDEX: 149; LEFT: 434px; POSITION: absolute; TOP: 1085px"
				runat="server" Width="196px" DataMember="AdresZameldowania.Powiat" Height="28px" Text="Powiat" 
                Number="42" Bold="False"></ea:framelabel>
<ea:framelabel id="p43" style="Z-INDEX: 150; LEFT: 28px; POSITION: absolute; TOP: 1113px"
				runat="server" Width="161px" DataMember="AdresZameldowania.Gmina" Height="28px" Text="Gmina" 
                Number="43" Bold="False"></ea:framelabel>
<ea:framelabel id="p44" style="Z-INDEX: 151; LEFT: 189px; POSITION: absolute; TOP: 1113px; right: 429px;"
				runat="server" Width="301px" DataMember="AdresZameldowania.Ulica" Height="28px" Text="Ulica" 
                Number="44"></ea:framelabel>
<ea:framelabel id="p45" style="Z-INDEX: 152; LEFT: 490px; POSITION: absolute; TOP: 1113px; right: 359px;"
				runat="server" Width="70px" DataMember="AdresZameldowania.NrDomu" Height="28px" Text="Nr domu" 
                Number="45" Bold="False"></ea:framelabel>
<ea:framelabel id="p46" style="Z-INDEX: 153; LEFT: 560px; POSITION: absolute; TOP: 1113px"
				runat="server" Width="70px" DataMember="AdresZameldowania.NrLokalu" Height="28px" Text="Nr lokalu" 
                Number="46"></ea:framelabel>
<ea:framelabel id="p47" style="Z-INDEX: 154; LEFT: 28px; POSITION: absolute; TOP: 1141px; right: 639px;"
				runat="server" Width="252px" DataMember="AdresZameldowania.Miejscowosc" Height="28px" Text="Miejscowość" 
                Number="47"></ea:framelabel>
<ea:framelabel id="p48" style="Z-INDEX: 155; LEFT: 280px; POSITION: absolute; TOP: 1141px; right: 534px;"
				runat="server" Width="105px" ValueStyle="PostalCode" DataMember="AdresZameldowania.KodPocztowy" 
                Height="28px" Text="Kod pocztowy" Number="48"></ea:framelabel>
<ea:framelabel id="p49" style="Z-INDEX: 156; LEFT: 385px; POSITION: absolute; TOP: 1141px; height: 30px;"
				runat="server" Width="245px" DataMember="AdresZameldowania.Poczta" Text="Poczta" 
                Number="49"></ea:framelabel>
<ea:framelabel id="FrameLabel161" style="Z-INDEX: -1; LEFT: 0px; POSITION: absolute; TOP: 1169px; height: 86px;"
				runat="server" Width="630px" Text="B.6. KONTAKT" FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel163" style="Z-INDEX: 150; LEFT: 28px; POSITION: absolute; TOP: 1197px; width: 599px;"
				runat="server" DataMember="Adres.Telefon" Height="28px" Text="Telefon" 
                Number="50"></ea:framelabel>
<ea:framelabel id="Framelabel164" style="Z-INDEX: 154; LEFT: 28px; POSITION: absolute; TOP: 1225px; right: 632px; width: 258px;"
				runat="server" DataMember="Adres.Faks" Height="28px" Text="Faks" 
                Number="51"></ea:framelabel>
<ea:framelabel id="Framelabel165" style="Z-INDEX: 155; LEFT: 287px; POSITION: absolute; TOP: 1225px; right: 534px; width: 343px;"
				runat="server" DataMember="Kontakt.EMAIL" 
                Height="28px" Text="E-mail" Number="52"></ea:framelabel>
<ea:framelabel id="FrameLabel162" style="Z-INDEX: -1; LEFT: 0px; POSITION: absolute; TOP: 1253px; height: 173px; right: 289px;"
				runat="server" Width="630px" Text="B.7. OSOBISTY RACHUNEK BANKOWY&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Podanie informacji o rachunku bankowym (poz. od 53 do  57) nie jest obowiązkowe, jeżeli składający nie wybiera tej formy zwrotu nadpłaty podatku dochodowego. Na wskazany rachunek będą dokonywane ewentualne zwroty nadpłaty podatku dochodowego. Można podać jedynie taki rachunek, którego właścicielem lub współwłaścicielem jest składający. Wpisane niżej dane dotyczące rachunku aktualizują poprzedni stan danych. W przypadku zgłoszenia aktualizacyjnego, jeżeli w poz.6 formularza zaznaczony został kwadrat nr 1 i dane zawarte w części B.7 nie uległy zmianie, to część B.7 formularza nie musi być wypełniona. Zaznaczenie kwadratu w poz.57 oznacza rezygnację przez składającego 
z otrzymywania ewentualnego zwrotu nadpłaty podatku dochodowego na rachunek osobisty (również z powodu likwidacji rachunku). Kraj siedziby banku (oddziału) (poz.53) należy podać, gdy rachunek jest prowadzony za granicą Rzeczypospolitej Polskiej. 
" 
                FrameStyle="BigYellow" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="rachunekKraj" style="Z-INDEX: 154; LEFT: 28px; POSITION: absolute; TOP: 1337px; right: 632px; width: 258px;"
				runat="server" Height="28px" Text="Kraj siedziby banku (oddziału)" 
                Number="53"></ea:framelabel>
<ea:framelabel id="rachunekNazwaBanku" style="Z-INDEX: 155; LEFT: 287px; POSITION: absolute; TOP: 1337px; right: 534px; width: 343px;"
				runat="server" 
                Height="28px" Text="Pełna nazwa banku (oddziału)" Number="54"></ea:framelabel>
<ea:framelabel id="rachunekPosiadacz" style="Z-INDEX: 150; LEFT: 28px; POSITION: absolute; TOP: 1365px; width: 599px;"
				runat="server" Height="28px" Text="Posiadacz rachunku" 
                Number="55"></ea:framelabel>
<ea:framelabel id="rachunekNumer" style="Z-INDEX: 150; LEFT: 28px; POSITION: absolute; TOP: 1393px; width: 530px;"
				runat="server" Height="28px" Text="Pełny numer rachunku" 
                Number="56"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 153; LEFT: 560px; POSITION: absolute; TOP: 1393px"
				runat="server" Width="70px" Height="28px" Text="Rezygnacja" 
                Number="57"></ea:framelabel>
<ea:checklabel id="rachunekRezygnacja" style="Z-INDEX: 240; LEFT: 578px; POSITION: absolute; TOP: 1402px; right: 382px;"
				runat="server" Width="35px" Height="14px"></ea:checklabel>
<ea:framelabel id="FrameLabel174" style="Z-INDEX: -1; LEFT: 0px; POSITION: absolute; TOP: 1428px; height: 123px; right: 289px;"
				runat="server" Width="630px" Text="C. INFORMACJE DODATKOWE&lt;br&gt;&lt;.Footer&gt;Pozycje:59 i 60 należy wypełnić tylko wówczas, gdy składający zakończył prowadzoną samodzielnie działalność gospodarczą i zgłasza tę informację w ramach aktualizacji danych. W takim przypadku, do zgłoszenia, należy dołączyć dokument (albo jego uwierzytelnioną lub 
poświadczoną urzędowo kopię) stwierdzający  wykreślenie tej działalności z Ewidencji działalności gospodarczej lub rejestru (art.9  ust.6 ustawy). 
Pozycję 60 należy wypełnić jedynie w przypadku dołączenia do zgłoszenia pełnomocnictwa albo postanowienia sądu o ustanowieniu kuratora. 
 &lt;./&gt;" 
                FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="Framelabel179" style="Z-INDEX: 154; LEFT: 28px; POSITION: absolute; TOP: 1492px; right: 632px; width: 599px;"
				runat="server" Height="28px" Text="Data zakończenia działalności gospodarczej" 
                Number="58" ValueStyle="Date"></ea:framelabel>
<ea:checklabel id="Checklabel8" style="Z-INDEX: 240; LEFT: 328px; POSITION: absolute; TOP: 1515px"
				runat="server" Width="260px" Height="14px" Text="Informacja o dołączeniu dokumentu dotyczącego pełnomocnictwa albo postanowienia sądu o ustanowieniu kuratora (zaznaczyć kwadrat w przypadku dołączenia dokumentu)" 
                ComparedValue="False" NumberAlignLeft="False" CheckVertMiddle="True"></ea:checklabel>
<ea:checklabel id="Checklabel7" style="Z-INDEX: 239; LEFT: 51px; POSITION: absolute; TOP: 1516px; right: 587px;"
				runat="server" Width="260px" Height="14px" Text="Informacja o dołączeniu dokumnetu stwierdzającego zakończenie działalności gospodarczej (zaznaczyć kwadrat w przypadku dołączenia dokumentu) " 
                NumberAlignLeft="False" CheckVertMiddle="True"></ea:checklabel>
<ea:framelabel id="Framelabel78" style="Z-INDEX: 234; LEFT: 28px; POSITION: absolute; TOP: 1519px; width: 278px; right: 610px;"
				runat="server" Height="28px" Number="59"></ea:framelabel>
<ea:framelabel id="Framelabel176" style="Z-INDEX: 237; LEFT: 308px; POSITION: absolute; TOP: 1519px; width: 320px;"
				runat="server" Height="28px" Number="60"></ea:framelabel>
<ea:framelabel id="Framelabel121" style="Z-INDEX: 233; LEFT: 0px; POSITION: absolute; TOP: 1554px; width: 630px; height: 133px;"
				runat="server" 
                Text="D. &lt;font size=2&gt;PODPIS SKŁADAJĄCEGO/DANE I PODPIS OSOBY REPREZENTUJĄCEJ SKŁADAJĄCEGO&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Osobą reprezentującą składającego może być jedynie osoba uprawniona do reprezentowania np. opiekun prawny, kurator, pełnomocnik określony w pełnomocnictwie. Pozycje od 61 do 64 wypełnić jedynie w przypadku osoby reprezentującej składającego.&lt;./&gt;" 
                FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="Framelabel177" style="Z-INDEX: 238; LEFT: 28px; POSITION: absolute; TOP: 1596px; width: 204px;"
				runat="server" Height="28px" Text="Imię" Number="61"></ea:framelabel>
<ea:framelabel id="Framelabel181" style="Z-INDEX: 238; LEFT: 231px; POSITION: absolute; TOP: 1596px; width: 204px; right: 485px;"
				runat="server" Height="28px" Text="Nazwisko" Number="62"></ea:framelabel>
<ea:framelabel id="Framelabel178" style="Z-INDEX: 238; LEFT: 434px; POSITION: absolute; TOP: 1596px; width: 193px;"
				runat="server" Height="28px" Text="NIP" Number="63"></ea:framelabel>
<ea:framelabel id="Framelabel166" style="Z-INDEX: 234; LEFT: 28px; POSITION: absolute; TOP: 1624px; right: 632px; width: 599px;"
				runat="server" Height="28px" Text="Adres do korespondencji" 
                Number="64"></ea:framelabel>
<ea:framelabel id="Framelabel180" style="Z-INDEX: 238; LEFT: 28px; POSITION: absolute; TOP: 1652px; width: 225px; right: 619px;"
				runat="server" Height="28px" Text="Data wypełnienia zgłoszenia" Number="65" 
                ValueStyle="Date"></ea:framelabel>
<ea:framelabel id="Framelabel137" style="Z-INDEX: 238; LEFT: 252px; POSITION: absolute; TOP: 1652px; width: 378px; right: 485px;"
				runat="server" Height="28px" 
                Text="Podpis składającego/osoby reprezentującej składającego&lt;.Normal&gt;(niepotrzebne skreślić)&lt;./&gt;" 
                Number="66"></ea:framelabel>
<ea:framelabel id="FrameLabel122" style="Z-INDEX: 241; LEFT: 0px; POSITION: absolute; TOP: 1687px; height: 75px;"
				runat="server" Width="630px" Text="E. &lt;font size=2&gt;DANE PODMIOTU, ZA POŚREDNICTWEM KTÓREGO PRZEKAZYWANY JEST FORMULARZ&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Wypełnia podmiot, który przekazuje formularz w sposób określony w art.8 i 9 ust.1a i 1b ustawy oraz w rozporządzeniu Ministra Finansów z dnia 30 grudnia 1999 r. w sprawie trybu składania zgłoszeń identyfikacyjnych oraz aktualizacyjnych przez podatników podatku  rolnego, leśnego i od nieruchomości (Dz.U. Nr 111, poz.1291). &lt;./&gt;"
				FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom"></ea:framelabel>
<ea:framelabel id="p67" style="Z-INDEX: 242; LEFT: 28px; POSITION: absolute; TOP: 1729px; width: 195px; right: 695px;"
				runat="server" Height="28px" Text="NIP" Number="67"></ea:framelabel>
<ea:framelabel id="p68" style="Z-INDEX: 244; LEFT: 224px; POSITION: absolute; TOP: 1729px; width: 405px;"
				runat="server" Height="28px" Text="Pieczęć, nazwa pełna lub imię i nazwisko podmiotu" 
                Number="68"></ea:framelabel>
<ea:framelabel id="FrameLabel127" style="Z-INDEX: 245; LEFT: 0px; POSITION: absolute; TOP: 1764px; height: 112px;"
				runat="server" Width="630px" Text="F. ADNOTACJE URZĘDU SKARBOWEGO" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel130" style="Z-INDEX: 246; LEFT: 28px; POSITION: absolute; TOP: 1792px; height: 27px;"
				runat="server" Width="602px" Text="Uwagi urzędu skarbowego" 
                FrameStyle="SmallBoldGray" Number="69"></ea:framelabel>
<ea:framelabel id="FrameLabel128" style="Z-INDEX: 247; LEFT: 28px; POSITION: absolute; TOP: 1820px; right: 590px; height: 26px;"
				runat="server" Width="301px" 
                Text="Identyfikator przyjmującego formularz" FrameStyle="SmallBoldGray" 
                Number="70"></ea:framelabel>
<ea:framelabel id="FrameLabel129" style="Z-INDEX: 248; LEFT: 329px; POSITION: absolute; TOP: 1820px; height: 31px;"
				runat="server" Width="301px" Text="Podpis przyjmującego formularz" 
                FrameStyle="SmallBoldGray" Number="71"></ea:framelabel>
<ea:framelabel id="FrameLabel171" style="Z-INDEX: 247; LEFT: 28px; POSITION: absolute; TOP: 1848px; right: 681px; width: 213px; height: 29px;"
				runat="server" Text="Data rejestracji w systemie" 
                FrameStyle="SmallBoldGray" Number="72" ValueStyle="Date"></ea:framelabel>
<ea:framelabel id="FrameLabel172" style="Z-INDEX: 247; LEFT: 238px; POSITION: absolute; TOP: 1848px; right: 590px; width: 179px; height: 27px;"
				runat="server" Text="Identyfikator rejestrującego formularz w systemie" 
                FrameStyle="SmallBoldGray" Number="73"></ea:framelabel>
<ea:framelabel id="FrameLabel173" style="Z-INDEX: 247; LEFT: 420px; POSITION: absolute; TOP: 1848px; right: 590px; width: 210px; height: 27px;"
				runat="server" Text="Podpis rejestrującego formularz w systemie" 
                FrameStyle="SmallBoldGray" Number="74"></ea:framelabel>
<ea:framelabel id="FrameLabel136" style="Z-INDEX: 254; LEFT: 0px; POSITION: absolute; TOP: 1882px"
				runat="server" Width="630px" Height="6px" 
                Text="Za wykroczenia skarbowe dotyczące obowiązków ewidencyjnych, o których mowa w art.81 Kodeksu karnego skarbowego, grozi sankcja karna." 
                FrameBorderStyle="None"></ea:framelabel>
<ea:deklaracjafooter id="footer2" 
                style="Z-INDEX: 255; LEFT: 0px; POSITION: absolute; TOP: 1897px" runat="server"
				TitleWidth="106" Symbol="NIP-3" PageNumber="2" PageTotal="2" Version="4"></ea:deklaracjafooter>
<ea:datacontext id="dc" style="Z-INDEX: 256; LEFT: 189px; POSITION: absolute; TOP: 1897px" runat="server"
				TypeName="Soneta.Kadry.PracHistoria,Soneta.KadryPlace" oncontextload="OnContextLoad" 
                LeftMargin="15" PageHeight="977px" PageZoom="107%"></ea:datacontext>
</form>
	</body>
</HTML>
