﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="65001" %>
<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>PIT-11 (16)</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
            System.Collections.Generic.Dictionary<int, FrameLabel> dct = new System.Collections.Generic.Dictionary<int, FrameLabel>();
            int[] overprintMap = {
                                     35, -10, -40,           //1.
                                     36, -10, -30,
                                     37, -10, -20,
                                     38, -10, -10,
                                     39, -10, 0,
                                     40, -10, -40,
                                     41, -10, -30,
                                     42, 0, -40,           //2.
                                     43, 0, -20,
                                     44, 0, 0,
                                     45, 0, -40,           //3.
                                     46, 0, -20,
                                     47, 0, -10,
                                     48, 0, 0,
                                     49, 0, -40,           //4.
                                     50, 0, -20,
                                     51, 0, 0,
                                     52, 0, -40,           //5.
                                     53, 0, -20,
                                     54, 0, 0,
                                     55, 5, -40,           //6.
                                     56, 5, -30,
                                     57, 5, -20,
                                     58, 5, 0,
                                     59, -10, -40,           //7.
                                     60, -10, -30,
                                     61, -10, -20,
                                     62, -10, 0,
                                     63, -10, -40,           //8.
                                     64, -10, -30,
                                     65, -10, -20,
                                     66, -10, 0,
                                     67, -10, -40,           //9.
                                     68, -10, -30,
                                     69, -10, -20,
                                     70, -10, 0,
                                     71, -10, -40,           //10.
                                     72, -10, -20,
                                     73, -10, -10,
                                     74, -10, 0,
                                     75, -10, 0,
                                     76, -10, 0,
                                     77, -10, 0,
                                     78, -10, 0,
                                     79, -10, 0,
                                     80, -10, 0,
                             };
            void OnContextLoad(object sender, EventArgs e) {
                PIT pit = (PIT)dc[typeof(PIT)];
                if (pit as PIT11_18 == null)
                    throw new InvalidOperationException("Wydruk PIT-11 (18) może być drukowany wyłącznie dla deklaracji PIT-11 w wersji 18.");
                if (dc.OverPrint) {
                    dc.LeftMargin = 6;
                    dc.TopMargin = 6;
                    dc.PageZoom = "114%";
                    foreach (object obj in PIT_11_15.Controls) {
                        FrameLabel fl = obj as FrameLabel;
                        if (fl != null && fl.Number >= 35 && fl.Number <= 80)
                            dct.Add(fl.Number, fl);
                    }
                    Resize(55, 0, -15);
                    Resize(56, 0, -15);
                    Resize(57, 0, -15);
                    Resize(58, 0, -15);
                    for (int i = 0; i < overprintMap.Length; i += 3)
                        Move(overprintMap[i], overprintMap[i + 1], overprintMap[i + 2]);
                    Move(Checklabel_82_T, -10, 0);
                    Move(Checklabel_82_N, -10, 0);
                }
                if (!pit.Module.Config.PIT.Ogólne.DanePodatnikaWStopce)
                    flDanePodatnika.Text = "";
                else {
                    string nip = (string)pit.Bloki["C1"]["NIP"];
                    flDanePodatnika.Text = pit.Podmiot.ToString() + ", nip:" + nip;
                }
            }
            void Resize(int number, int dwidth, int dheight) {
                FrameLabel fl = dct[number];
                if (dwidth != 0)
                    fl.Style["width"] = (ParsePx(fl.Style["width"]) + dwidth) + "px";
                if (dheight != 0)
                    fl.Style["height"] = (ParsePx(fl.Style["height"]) + dheight) + "px";
            }
            void Move(int number, int dtop, int dleft) {
                Move(dct[number], dtop, dleft);
                dct.Remove(number);
            }
            void Move(WebControl fl, int dtop, int dleft) {
                if (dleft != 0)
                    fl.Style["LEFT"] = (ParsePx(fl.Style["LEFT"]) + dleft) + "px";
                if (dtop != 0)
                    fl.Style["TOP"] = (ParsePx(fl.Style["TOP"]) + dtop) + "px";
            }
            int ParsePx(string px) {
                return int.Parse(px.Substring(0, px.Length - 2));
            }
</script>
	</HEAD>
	<body leftMargin="0" rightMargin="0">
		<form id="PIT_11_15" method="post" runat="server">
			<ea:deklaracjaheader id="DeklaracjaHeader1" style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 0px"
				runat="server" Width="630px"></ea:deklaracjaheader>
<ea:framelabel id="FrameLabel21" style="Z-INDEX: 101; LEFT: 0px; POSITION: absolute; TOP: 21px"
				runat="server" Width="273px" ValueStyle="nip_w" DataMember="0.Nip" Height="28px" Text="1. Numer Identyfikacji Podatkowej płatnika"></ea:framelabel>
<ea:framelabel id="FrameLabel22" style="Z-INDEX: 102; LEFT: 273px; POSITION: absolute; TOP: 21px"
				runat="server" Width="119px" Height="28px" Text="Nr dokumentu" FrameStyle="SmallBoldGray" Number="2"></ea:framelabel>
<ea:framelabel id="FrameLabel23" style="Z-INDEX: 103; LEFT: 392px; POSITION: absolute; TOP: 21px"
				runat="server" Width="77px" Height="30px" Text="Status" FrameStyle="SmallBoldGray" Number="3"></ea:framelabel>
<ea:framelabel id="labelPIT" style="Z-INDEX: 104; LEFT: 0px; POSITION: absolute; TOP: 49px" runat="server"
				Width="119px" Height="21px" FrameStyle="BigBold" FrameBorderStyle="None" Text="PIT-11"></ea:framelabel>
<ea:framelabel id="FrameLabel158" style="Z-INDEX: 105; LEFT: 126px; POSITION: absolute; TOP: 63px"
				runat="server" Width="525px" Height="35px" 
                Text="INFORMACJA O  DOCHODACH ORAZ O POBRANYCH ZALICZKACH<br>NA PODATEK DOCHODOWY" 
                FrameStyle="BigBold" FrameBorderStyle="None" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel19" style="Z-INDEX: 106; LEFT: 259px; POSITION: absolute; TOP: 105px; width: 115px;"
				runat="server" ValueStyle="n4" DataMember="0.Rok" Height="28px" Text="4. Rok"></ea:framelabel>
<ea:framelabel id="FrameLabel29" style="Z-INDEX: 108; LEFT: 170px; POSITION: absolute; TOP: 112px"
				runat="server" Width="70px" Height="17px" Text="w roku" FrameStyle="BigBold" 
                FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel24" style="Z-INDEX: 109; LEFT: 0px; POSITION: absolute; TOP: 140px"
				runat="server" Width="630px" Height="105px" FrameStyle="SmallBoldYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel25" style="Z-INDEX: 110; LEFT: 7px; POSITION: absolute; TOP: 147px"
				runat="server" Width="91px" Height="7px" Text="Podstawa prawna:" FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel26" style="Z-INDEX: 111; LEFT: 133px; POSITION: absolute; TOP: 147px"
				runat="server" Width="490px" Height="28px" Text='Art.39 ust.1, art.42 ust.2 pkt 1 i art.42e ust.6 ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych (Dz. U. z 2010 r. Nr 51, poz.307 z późn. zm.), zwanej dalej "ustawą"; atr.35a ust.5 ustawy, w brzmieniu obowiązującym przed dniem 26 października 2007 r. <.INDEXUP>1)<./>. ' FrameStyle="SmallYellow"
				FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel27" style="Z-INDEX: 112; LEFT: 7px; POSITION: absolute; TOP: 175px"
				runat="server" Width="91px" Height="7px" Text="Składający:" FrameStyle="SmallYellow" 
                FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel28" style="Z-INDEX: 113; LEFT: 133px; POSITION: absolute; TOP: 175px"
				runat="server" Width="490px" Height="7px" 
                Text="Płatnik podatku dochodowego od osób fizycznych." FrameStyle="SmallYellow" 
                FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel30" style="Z-INDEX: 114; LEFT: 7px; POSITION: absolute; TOP: 184px"
				runat="server" Width="91px" Height="7px" Text="Termin doręczenia:" 
                FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel31" style="Z-INDEX: 115; LEFT: 133px; POSITION: absolute; TOP: 184px"
				runat="server" Width="490px" Height="42px" Text="Do końca lutego roku następującego po roku podatkowym. W przypadku gdy, w trakcie roku podatkowego ustał obowiązek poboru zaliczki przez płatników, o których mowa w art.39 ust.1 ustawy - w terminie 14 dni od złożenia pisemnego wniosku przez podatnika, w przypadku zaprzestania działalności przez płatników, o których mowa w art.41 ust.1 ustawy, przed końcem lutego roku następującego po roku podatkowym - do dnia zaprzestania tej działalności."
				FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel32" style="Z-INDEX: 116; LEFT: 7px; POSITION: absolute; TOP: 224px"
				runat="server" Width="91px" Height="7px" Text="Otrzymuje:" FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel33" style="Z-INDEX: 117; LEFT: 133px; POSITION: absolute; TOP: 224px"
				runat="server" Width="490px" Height="21px" Text="Podatnik oraz urząd skarbowy <.INDEXUP>2)<./> według miejsca zamieszkania podatnika, a w przypadku podatników, o których mowa w art.3 ust.2a ustawy, urząd skarbowy w sprawach opodatkowania osób zagranicznych."
				FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel17" style="Z-INDEX: 118; LEFT: 0px; POSITION: absolute; TOP: 245px"
				runat="server" Width="630px" Height="84px" Text="A. MIEJSCE I CEL SKŁADANIA INFORMACJI" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="FrameLabel18" style="Z-INDEX: 119; LEFT: 28px; POSITION: absolute; TOP: 273px"
				runat="server" Width="602px" DataMember="A.UrzadSkarb" Height="28px" Text="Urząd skarbowy, do którego adresowana jest informacja" Number="5"></ea:framelabel>
<ea:framelabel id="Framelabel77" style="Z-INDEX: 123; LEFT: 28px; POSITION: absolute; TOP: 301px"
				runat="server" Width="602px" Height="28px" Text="Cel złożenia formularza <.Normal>(zaznaczyć właściwy kwadrat)<./>" Number="6">
                </ea:FrameLabel>
<ea:checklabel id="Checklabel10" style="Z-INDEX: 257; LEFT: 219px; POSITION: absolute; TOP: 308px"
				runat="server" Width="136px" DataMember="A.Korekta" Height="14px" Text="złożenie informacji" Number="1" NumberAlignLeft="False" ComparedValue="False">
            </ea:CheckLabel>
<ea:checklabel id="Checklabel9" style="Z-INDEX: 127; LEFT: 358px; POSITION: absolute; TOP: 308px"
				runat="server" Width="133px" DataMember="A.Korekta" Height="14px" Text="korekta informacji 3)" Number="2" NumberAlignLeft="False"></ea:checklabel>
<ea:framelabel id="FrameLabel1" style="Z-INDEX: 120; LEFT: 0px; POSITION: absolute; TOP: 329px"
				runat="server" Width="630px" Height="28px" Text="B. DANE PŁATNIKA" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader" FooterText="                        * - dotyczy płatnika niebędącego osobą fizyczną       ** - dotyczy płatnika będącego osobą fizyczną"></ea:framelabel>
<ea:framelabel id="FrameLabel2" style="Z-INDEX: 121; LEFT: 0px; POSITION: absolute; TOP: 357px"
				runat="server" Width="630px" Height="112px" Text="B.1. DANE IDENTYFIKACYJNE" FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel3" style="Z-INDEX: 122; LEFT: 28px; POSITION: absolute; TOP: 385px"
				runat="server" Width="602px" Height="28px" Text="Rodzaj płatnika <.Normal>(zaznaczyć właściwy kwadrat)<./>" Number="7"></ea:framelabel>
<ea:checklabel id="CheckLabel1" style="Z-INDEX: 124; LEFT: 132px; POSITION: absolute; TOP: 392px"
				runat="server" Width="161px" DataMember="B1.OsobaFiz" Height="14px" Text="płatnik niebędący osobą fizyczną" Number="1" NumberAlignLeft="False" ComparedValue="False">
            </ea:CheckLabel>
<ea:checklabel id="CheckLabel2" style="Z-INDEX: 126; LEFT: 423px; POSITION: absolute; TOP: 392px"
				runat="server" Width="133px" DataMember="B1.OsobaFiz" Height="14px" Text="osoba fizyczna" Number="2" NumberAlignLeft="False">
            </ea:CheckLabel>
<ea:framelabel id="FrameLabel4" style="Z-INDEX: 128; LEFT: 28px; POSITION: absolute; TOP: 413px"
				runat="server" Width="602px" DataMember="B1.Nazwa" Height="56px" Text="Nazwa pełna, REGON * / Nazwisko, pierwsze imię, data urodzenia, PESEL **" Number="8"></ea:framelabel>
<ea:framelabel id="FrameLabel5" style="Z-INDEX: 129; LEFT: 0px; POSITION: absolute; TOP: 469px"
				runat="server" Width="630px" Height="111px" Text="B.2. ADRES SIEDZIBY * / ADRES ZAMIESZKANIA **" FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel6" style="Z-INDEX: 130; LEFT: 28px; POSITION: absolute; TOP: 497px"
				runat="server" Width="140px" DataMember="B2.Kraj" Height="28px" Text="Kraj" Number="9"></ea:framelabel>
<ea:framelabel id="FrameLabel7" style="Z-INDEX: 131; LEFT: 168px; POSITION: absolute; TOP: 497px"
				runat="server" Width="266px" DataMember="B2.Wojew" Height="28px" Text="Województwo" Number="10"></ea:framelabel>
            &nbsp;
<ea:framelabel id="FrameLabel8" style="Z-INDEX: 132; LEFT: 434px; POSITION: absolute; TOP: 497px"
				runat="server" Width="196px" DataMember="B2.Powiat" Height="28px" Text="Powiat" Number="11"></ea:framelabel>
<ea:framelabel id="FrameLabel9" style="Z-INDEX: 133; LEFT: 28px; POSITION: absolute; TOP: 525px" SmallerFontLength="16"
				runat="server" Width="161px" DataMember="B2.Gmina" Height="28px" Text="Gmina" Number="12"></ea:framelabel>
<ea:framelabel id="FrameLabel10" style="Z-INDEX: 134; LEFT: 189px; POSITION: absolute; TOP: 525px"
				runat="server" Width="301px" DataMember="B2.Ulica" Height="28px" Text="Ulica" Number="13"></ea:framelabel>
<ea:framelabel id="FrameLabel11" style="Z-INDEX: 135; LEFT: 490px; POSITION: absolute; TOP: 525px" SmallerFontLength="6"
				runat="server" Width="70px" DataMember="B2.NrDomu" Height="28px" Text="Nr domu" Number="14"></ea:framelabel>
<ea:framelabel id="FrameLabel12" style="Z-INDEX: 136; LEFT: 560px; POSITION: absolute; TOP: 525px"
				runat="server" Width="70px" DataMember="B2.NrLokalu" Height="28px" Text="Nr lokalu" Number="15"></ea:framelabel>
<ea:framelabel id="FrameLabel13" style="Z-INDEX: 137; LEFT: 28px; POSITION: absolute; TOP: 553px"
				runat="server" Width="252px" DataMember="B2.Miejsc" Height="28px" Text="Miejscowość" Number="16"></ea:framelabel>
<ea:framelabel id="FrameLabel14" style="Z-INDEX: 138; LEFT: 280px; POSITION: absolute; TOP: 553px"
				runat="server" Width="105px" ValueStyle="PostalCode" DataMember="B2.KodPoczt" Height="28px" Text="Kod pocztowy" Number="17"></ea:framelabel>
<ea:framelabel id="FrameLabel15" style="Z-INDEX: 139; LEFT: 385px; POSITION: absolute; TOP: 553px"
				runat="server" Width="245px" DataMember="B2.Poczta" Height="28px" Text="Poczta" Number="18"></ea:framelabel>
<ea:framelabel id="Framelabel41" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 581px"
				runat="server" Width="630px" Height="27px" Text="C. DANE PODATNIKA" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="Framelabel81" style="Z-INDEX: 141; LEFT: 0px; POSITION: absolute; TOP: 609px"
				runat="server" Width="630px" Height="82px" Text="C.1. DANE IDENTYFIKACYJNE" FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel102" style="Z-INDEX: 142; LEFT: 28px; POSITION: absolute; TOP: 637px"
				runat="server" Width="210px" ValueStyle="nip_t" DataMember="C1.NIP" Height="28px" Text="Numer Identyfikacji Podatkowej" Number="19"></ea:framelabel>
<ea:framelabel id="Framelabel103" style="Z-INDEX: 143; LEFT: 238px; POSITION: absolute; TOP: 637px" SmallerFontLength="20"
				runat="server" Width="196px" DataMember="C1.Nazwisko" Height="28px" Text="Nazwisko" Number="20"></ea:framelabel>
<ea:framelabel id="Framelabel104" style="Z-INDEX: 144; LEFT: 434px; POSITION: absolute; TOP: 637px"
				runat="server" Width="196px" DataMember="C1.Imię" Height="28px" Text="Pierwsze imię" Number="21"></ea:framelabel>
<ea:framelabel id="Framelabel105" style="Z-INDEX: 145; LEFT: 28px; POSITION: absolute; TOP: 665px"
				runat="server" Width="315px" ValueStyle="Date" DataMember="C1.DataUrodz" Height="28px" Text="Data urodzenia" Number="22"></ea:framelabel>
<ea:framelabel id="Framelabel84" style="Z-INDEX: 144; LEFT: 343px; POSITION: absolute; TOP: 665px"
				runat="server" Width="287px" DataMember="C1.PESEL" Height="28px" Text="PESEL" 
                Number="23" ValueStyle="WideText">
                </ea:FrameLabel>
<ea:framelabel id="Framelabel101" style="Z-INDEX: 146; LEFT: 0px; POSITION: absolute; TOP: 693px"
				runat="server" Width="630px" Height="109px" Text="C.2. ADRES ZAMIESZKANIA" FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="Framelabel106" style="Z-INDEX: 147; LEFT: 28px; POSITION: absolute; TOP: 721px"
				runat="server" Width="140px" DataMember="C2.Kraj" Height="28px" Text="Kraj" Number="24"></ea:framelabel>
<ea:framelabel id="Framelabel107" style="Z-INDEX: 148; LEFT: 168px; POSITION: absolute; TOP: 721px"
				runat="server" Width="266px" DataMember="C2.Wojew" Height="28px" Text="Województwo" Number="25"></ea:framelabel>
<ea:framelabel id="Framelabel108" style="Z-INDEX: 149; LEFT: 434px; POSITION: absolute; TOP: 721px"
				runat="server" Width="196px" DataMember="C2.Powiat" Height="28px" Text="Powiat" Number="26"></ea:framelabel>
<ea:framelabel id="Framelabel109" style="Z-INDEX: 150; LEFT: 28px; POSITION: absolute; TOP: 749px" SmallerFontLength="16"
				runat="server" Width="161px" DataMember="C2.Gmina" Height="28px" Text="Gmina" Number="27"></ea:framelabel>
<ea:framelabel id="Framelabel110" style="Z-INDEX: 151; LEFT: 189px; POSITION: absolute; TOP: 749px"
				runat="server" Width="301px" DataMember="C2.Ulica" Height="28px" Text="Ulica" 
                Number="28"></ea:framelabel>
<ea:framelabel id="Framelabel111" style="Z-INDEX: 152; LEFT: 490px; POSITION: absolute; TOP: 749px" SmallerFontLength="6"
				runat="server" Width="70px" DataMember="C2.NrDomu" Height="28px" Text="Nr domu" Number="29"></ea:framelabel>
<ea:framelabel id="Framelabel112" style="Z-INDEX: 153; LEFT: 560px; POSITION: absolute; TOP: 749px"
				runat="server" Width="70px" DataMember="C2.NrLokalu" Height="28px" Text="Nr lokalu" Number="30"></ea:framelabel>
<ea:framelabel id="Framelabel113" style="Z-INDEX: 154; LEFT: 28px; POSITION: absolute; TOP: 777px"
				runat="server" Width="252px" DataMember="C2.Miejsc" Height="28px" Text="Miejscowość" Number="31"></ea:framelabel>
<ea:framelabel id="Framelabel114" style="Z-INDEX: 155; LEFT: 280px; POSITION: absolute; TOP: 777px"
				runat="server" Width="105px" ValueStyle="PostalCode" DataMember="C2.KodPoczt" Height="28px" Text="Kod pocztowy" Number="32"></ea:framelabel>
<ea:framelabel id="Framelabel115" style="Z-INDEX: 156; LEFT: 385px; POSITION: absolute; TOP: 777px"
				runat="server" Width="245px" DataMember="C2.Poczta" Height="28px" Text="Poczta" Number="33"></ea:framelabel>
<ea:framelabel id="Framelabel116" style="Z-INDEX: 157; LEFT: 0px; POSITION: absolute; TOP: 805px"
				runat="server" Width="630px" Height="107px" Text="D. INFROMACJA O KOSZTACH UZYSKANIA PRZYCHODU <.SMALLER>Z TYTUŁU STOSUNKU SŁUŻBOWEGO,<br>STOSUNKU PRACY, SPÓŁDZIELCZEGO STOSUNKU PRACY ORAZ PRACY NAKŁADCZEJ<./>" FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="Framelabel117" style="Z-INDEX: 158; LEFT: 28px; POSITION: absolute; TOP: 840px"
				runat="server" Width="602px" Height="71px" Text="Koszty uzyskania przychodów, wykazane w poz.36, zostały uwzględnione do wysokości przysługującej podatnikowi <.Normal>(zaznaczyć właściwy kwadrat)<./>:" Number="34"></ea:framelabel>
<ea:checklabel id="Checklabel3" style="Z-INDEX: 159; LEFT: 44px; POSITION: absolute; TOP: 851px"
				runat="server" Width="287px" DataMember="D.Jeden" Height="14px" Text="z jednego stosunku pracy (stosunków pokrewnych)" Number="1" NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:checklabel id="Checklabel4" style="Z-INDEX: 160; LEFT: 335px; POSITION: absolute; TOP: 851px"
				runat="server" Width="280px" DataMember="D.Wiecej" Height="12px" Text="z więcej niż jednego stosunku pracy (stosunków pokrewnych)" Number="2" NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:checklabel id="Checklabel5" style="Z-INDEX: 161; LEFT: 44px; POSITION: absolute; TOP: 868px"
				runat="server" Width="286px" DataMember="D.JedenPodw" Height="14px" Text="z jednego stosunku pracy (stosunków pokrewnych), podwyższone w związku z zamieszkiwaniem podatnika poza miejscowością, w której znajduje się zakład pracy" Number="3" NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:checklabel id="Checklabel6" style="Z-INDEX: 162; LEFT: 335px; POSITION: absolute; TOP: 868px"
				runat="server" Width="277px" DataMember="D.WiecejPodw" Height="14px" Text="z więcej niż jednego stosunku pracy (stosunków pokrewnych), podwyższone w związku z zamieszkiwaniem podatnika poza miejscowością, w której znajduje się zakład pracy" Number="4" NumberAlignLeft="False" AlignTop="True"></ea:checklabel>
<ea:deklaracjafooter id="footer1" 
                style="Z-INDEX: 163; LEFT: 490px; POSITION: absolute; TOP: 924px" runat="server"
				Width="154px" Height="10px" TitleWidth="106" Symbol="PIT-11" PageNumber="1" 
                PageTotal="2" Version="18"></ea:deklaracjafooter>
<ea:deklaracjaheader id="DeklaracjaHeader2" style="Z-INDEX: 165; LEFT: 0px; POSITION: absolute; TOP: 980px"
				runat="server" Width="630px"></ea:deklaracjaheader>
<ea:framelabel id="FrameLabel16" style="Z-INDEX: 166; LEFT: 0px; POSITION: absolute; TOP: 1001px; height: 536px;"
				runat="server" Width="630px" 
                Text="E. DOCHODY PODATNIKA, POBRANE ZALICZKI ORAZ POBRANE SKŁADKI <.INDEXUP>6)<./>" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel39" style="Z-INDEX: 167; LEFT: 28px; POSITION: absolute; TOP: 1022px; width: 221px;"
				runat="server" Height="25px" Text="Źródła przychodów" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel37" style="Z-INDEX: 168; LEFT: 252px; POSITION: absolute; TOP: 1022px; width: 78px; right: 617px;"
				runat="server" ValueStyle="ZlGr" Height="25px" Text="Przychód <.INDEXUP>4)<./>" 
                FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel40" style="Z-INDEX: 169; LEFT: 329px; POSITION: absolute; TOP: 1022px; width: 79px;"
				runat="server" ValueStyle="ZlGr" Height="25px" 
                Text="Koszty uzyskania<br>przychodów <.INDEXUP>5)<./>" 
                FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel42" style="Z-INDEX: 170; LEFT: 406px; POSITION: absolute; TOP: 1022px; width: 80px;"
				runat="server" Height="25px" Text="Dochód<br>(b-c)" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center" ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="FrameLabel152" style="Z-INDEX: 170; LEFT: 483px; POSITION: absolute; TOP: 1022px; width: 80px;"
				runat="server" Height="25px" 
                Text="Dochód zwolniony &lt;br&gt; od podatku &lt;.INDEXUP&gt;4)&lt;./&gt;" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center" ValueStyle="ZlGr"></ea:framelabel>
<ea:framelabel id="FrameLabel43" style="Z-INDEX: 171; LEFT: 560px; POSITION: absolute; TOP: 1022px; width: 69px;"
				runat="server" Height="25px" Text="Zaliczka pobrana<br>przez płatnika" 
                FrameStyle="SmallBoldYellow" HorizontalAlign="Center" ValueStyle="Zl"></ea:framelabel>
<ea:framelabel id="FrameLabel38" style="Z-INDEX: 172; LEFT: 28px; POSITION: absolute; TOP: 1050px; height: 15px; width: 222px;"
				runat="server" Text="a" FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel44" style="Z-INDEX: 173; LEFT: 252px; POSITION: absolute; TOP: 1050px; width: 79px;"
				runat="server" Height="12px" Text="b" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel45" style="Z-INDEX: 174; LEFT: 329px; POSITION: absolute; TOP: 1050px; height: 15px; width: 76px;"
				runat="server" Text="c" FrameStyle="SmallBoldYellow" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel46" style="Z-INDEX: 175; LEFT: 406px; POSITION: absolute; TOP: 1050px; width: 79px;"
				runat="server" Height="12px" Text="d" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel153" style="Z-INDEX: 175; LEFT: 483px; POSITION: absolute; TOP: 1050px; width: 79px;"
				runat="server" Height="12px" Text="e" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel47" style="Z-INDEX: 176; LEFT: 560px; POSITION: absolute; TOP: 1050px; width: 67px;"
				runat="server" Height="12px" Text="f" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel48" style="Z-INDEX: 177; LEFT: 28px; POSITION: absolute; TOP: 1064px; height: 86px; bottom: 568px; width: 224px;"
				runat="server" 
                Text="Należności ze stosunku: pracy, służbowego, spółdzielczego i z pracy nakładczej, a także zasiłki pieniężne z ubezpieczenia społecznego wypłacone przez zakład pracy,o którym mowa w art.31 ustawy oraz płatników, o których mowa w art.42e ust.1 ustawy" FrameStyle="SmallBoldYellow"
				Number="1" HorizontalAlign="Left" 
                FooterText="W poz.40 należy wykazać przychody, do których zastosowano odliczenie kosztów uzyskania przychodów na podstawie art.22 ust.9 pkt 3 ustawy."></ea:framelabel>
<ea:framelabel id="Framelabel49" style="Z-INDEX: 178; LEFT: 252px; POSITION: absolute; TOP: 1064px; width: 77px; height: 56px;" SmallerFontLength="18"
				runat="server" ValueStyle="ZlGr" DataMember="E.1aPrzychód" Number="35"></ea:framelabel>
<ea:framelabel id="Framelabel51" style="Z-INDEX: 179; LEFT: 329px; POSITION: absolute; TOP: 1064px; width: 75px; height: 58px;" SmallerFontLength="18"
				runat="server" ValueStyle="ZlGr" DataMember="E.1aKoszty" Number="36"></ea:framelabel>
<ea:framelabel id="Framelabel53" style="Z-INDEX: 180; LEFT: 406px; POSITION: absolute; TOP: 1064px; width: 78px; height: 87px;" SmallerFontLength="18"
				runat="server" ValueStyle="ZlGr" DataMember="E.1Dochód" 
                Number="37"></ea:framelabel>
<ea:framelabel id="Framelabel154" style="Z-INDEX: 180; LEFT: 483px; POSITION: absolute; TOP: 1064px; width: 78px; height: 85px;" SmallerFontLength="18"
				runat="server" ValueStyle="ZlGr" DataMember="E.1Zwolniony" 
                Number="38"></ea:framelabel>
<ea:framelabel id="Framelabel54" style="Z-INDEX: 181; LEFT: 560px; POSITION: absolute; TOP: 1064px; width: 73px; height: 86px;"
				runat="server" ValueStyle="Zl" DataMember="E.1Zaliczka" 
                Number="39"></ea:framelabel>
<ea:framelabel id="Framelabel50" style="Z-INDEX: 182; LEFT: 252px; POSITION: absolute; TOP: 1120px; width: 76px; height: 25px;" SmallerFontLength="18"
				runat="server" ValueStyle="ZlGr" DataMember="E.1bPrzychód" 
                Number="40" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel52" style="Z-INDEX: 183; LEFT: 329px; POSITION: absolute; TOP: 1120px; width: 76px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.1bKoszty" Height="28px" 
                Number="41"></ea:framelabel>
<ea:framelabel id="FrameLabel55" style="Z-INDEX: 184; LEFT: 28px; POSITION: absolute; TOP: 1148px; height: 45px; width: 221px;"
				runat="server" Text="Należności z tytułu członkowstwa w rolniczej spółdzielni produkcyjnej lub innej spółdzielni zajmującej się produkcją rolną oraz zasiłki pieniężne z ubezpieczenia społecznego"
				FrameStyle="SmallBoldYellow" Number="2" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel57" style="Z-INDEX: 185; LEFT: 252px; POSITION: absolute; TOP: 1148px; width: 78px; height: 45px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.2Przychód" 
                Number="42"></ea:framelabel>
<ea:framelabel id="Framelabel59" style="Z-INDEX: 186; LEFT: 406px; POSITION: absolute; TOP: 1148px; width: 77px; height: 44px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.2Dochód" 
                Number="43" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel60" style="Z-INDEX: 187; LEFT: 560px; POSITION: absolute; TOP: 1148px; width: 70px; height: 41px;"
				runat="server" ValueStyle="Zl" DataMember="E.2Zaliczka" 
                Number="44"></ea:framelabel>
<ea:framelabel id="FrameLabel61" style="Z-INDEX: 188; LEFT: 28px; POSITION: absolute; TOP: 1190px; width: 221px;"
				runat="server" Height="25px" Text="Emerytury - renty zagraniczne" 
                FrameStyle="SmallBoldYellow" Number="3" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel62" style="Z-INDEX: 189; LEFT: 252px; POSITION: absolute; TOP: 1190px; width: 75px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.3Przychód" Height="28px" 
                Number="45"></ea:framelabel>
<ea:framelabel id="Framelabel64" style="Z-INDEX: 190; LEFT: 406px; POSITION: absolute; TOP: 1190px; width: 79px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.3Dochód" Height="28px" 
                Number="46"></ea:framelabel>
<ea:framelabel id="Framelabel156" style="Z-INDEX: 190; LEFT: 483px; POSITION: absolute; TOP: 1190px; width: 79px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.3Zwolniony" Height="28px" 
                Number="47"></ea:framelabel>
<ea:framelabel id="Framelabel65" style="Z-INDEX: 191; LEFT: 560px; POSITION: absolute; TOP: 1190px; width: 71px;"
				runat="server" ValueStyle="Zl" DataMember="E.3Zaliczka" Height="28px" 
                Number="48"></ea:framelabel>
<ea:framelabel id="FrameLabel66" style="Z-INDEX: 192; LEFT: 28px; POSITION: absolute; TOP: 1218px; height: 26px; width: 221px;"
				runat="server" 
                Text="Należności za pracę przypadające tymczasowo aresztowanym lub skazanym" 
                FrameStyle="SmallBoldYellow" Number="4" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel72" style="Z-INDEX: 193; LEFT: 252px; POSITION: absolute; TOP: 1218px; right: 591px; width: 80px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.4Przychód" Height="28px" 
                Number="49" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel85" style="Z-INDEX: 194; LEFT: 406px; POSITION: absolute; TOP: 1218px; width: 74px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.4Dochód" Height="28px" 
                Number="50" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel91" style="Z-INDEX: 195; LEFT: 560px; POSITION: absolute; TOP: 1218px; width: 72px;"
				runat="server" ValueStyle="Zl" DataMember="E.4Zaliczka" Height="28px" 
                Number="51"></ea:framelabel>
<ea:framelabel id="FrameLabel67" style="Z-INDEX: 196; LEFT: 28px; POSITION: absolute; TOP: 1246px; height: 26px; width: 225px;"
				runat="server" 
                Text="Świadczenia wypłacone z Funduszów :<br>Pracy i Gwarantowanych Świadczeń Pracowniczych" 
                FrameStyle="SmallBoldYellow" Number="5" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel73" style="Z-INDEX: 197; LEFT: 252px; POSITION: absolute; TOP: 1246px; width: 77px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.5Przychód" Height="26px" 
                Number="52"></ea:framelabel>
<ea:framelabel id="Framelabel86" style="Z-INDEX: 198; LEFT: 406px; POSITION: absolute; TOP: 1246px; width: 79px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.5Dochód" Height="28px" 
                Number="53"></ea:framelabel>
<ea:framelabel id="Framelabel92" style="Z-INDEX: 199; LEFT: 560px; POSITION: absolute; TOP: 1246px; width: 69px;"
				runat="server" ValueStyle="Zl" DataMember="E.5Zaliczka" Height="26px" 
                Number="54"></ea:framelabel>
<ea:framelabel id="FrameLabel97" style="Z-INDEX: 200; LEFT: 28px; POSITION: absolute; TOP: 1274px; height: 39px; width: 222px;"
				runat="server" Text="Działalność wykonywana osobiście, o której mowa w art.13 pkt 2, 4, 6 (z wyjątykiem czynności wymienionych w wierszu 7) i 7-9 ustawy, w tym umowy zlecenia i o dzieło&lt;./&gt;"
				FrameStyle="SmallBoldYellow" Number="6" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel74" style="Z-INDEX: 201; LEFT: 252px; POSITION: absolute; TOP: 1274px; width: 75px; height: 40px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.6Przychód" 
                Number="55"></ea:framelabel>
<ea:framelabel id="Framelabel100" style="Z-INDEX: 202; LEFT: 329px; POSITION: absolute; TOP: 1274px; width: 76px; height: 40px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.6Koszty" 
                Number="56"></ea:framelabel>
<ea:framelabel id="Framelabel87" style="Z-INDEX: 203; LEFT: 406px; POSITION: absolute; TOP: 1274px; width: 79px; right: 482px; height: 40px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.6Dochód" 
                Number="57"></ea:framelabel>
<ea:framelabel id="Framelabel93" style="Z-INDEX: 204; LEFT: 560px; POSITION: absolute; TOP: 1274px; width: 69px; height: 41px;"
				runat="server" ValueStyle="Zl" DataMember="E.6Zaliczka" 
                Number="58"></ea:framelabel>
<ea:framelabel id="FrameLabel68" style="Z-INDEX: 205; LEFT: 28px; POSITION: absolute; TOP: 1316px; width: 222px;"
				runat="server" Height="26px" 
                Text="Czynności związane z pełnieniem obowiązków społeczych lub obywatelskich (art.13 pkt 5 i 6 ustawy) - <.Normal>Należy wpisać kwotę wynikające z PIT-R<./>" FrameStyle="SmallBoldYellow"
				Number="7" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel98" style="Z-INDEX: 206; LEFT: 252px; POSITION: absolute; TOP: 1316px; right: 591px; width: 78px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.7Przychód" Height="28px" 
                Number="59" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel80" style="Z-INDEX: 207; LEFT: 329px; POSITION: absolute; TOP: 1316px; width: 76px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.7Koszty" Height="28px" 
                Number="60" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel118" style="Z-INDEX: 208; LEFT: 406px; POSITION: absolute; TOP: 1316px; width: 74px; bottom: 428px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.7Dochód" Height="28px" 
                Number="61"></ea:framelabel>
<ea:framelabel id="Framelabel120" style="Z-INDEX: 209; LEFT: 560px; POSITION: absolute; TOP: 1316px; bottom: 481px; width: 69px;"
				runat="server" ValueStyle="Zl" DataMember="E.7Zaliczka" Height="28px" 
                Number="62"></ea:framelabel>
<ea:framelabel id="FrameLabel126" style="Z-INDEX: 210; LEFT: 28px; POSITION: absolute; TOP: 1344px; width: 226px;"
				runat="server" Height="26px" 
                Text="Prawa autorskie i inne prawa, o których mowa w art.18 ustawy" 
                FrameStyle="SmallBoldYellow" Number="8" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel135" style="Z-INDEX: 211; LEFT: 252px; POSITION: absolute; TOP: 1344px; width: 79px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.8Przychód" Height="28px" 
                Number="63"></ea:framelabel>
<ea:framelabel id="Framelabel139" style="Z-INDEX: 212; LEFT: 329px; POSITION: absolute; TOP: 1344px; width: 76px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.8Koszty" Height="28px" 
                Number="64"></ea:framelabel>
<ea:framelabel id="Framelabel141" style="Z-INDEX: 213; LEFT: 406px; POSITION: absolute; TOP: 1344px; width: 78px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.8Dochód" Height="28px" 
                Number="65"></ea:framelabel>
<ea:framelabel id="Framelabel143" style="Z-INDEX: 214; LEFT: 560px; POSITION: absolute; TOP: 1344px; width: 72px;"
				runat="server" ValueStyle="Zl" DataMember="E.8Zaliczka" Height="28px" 
                Number="66"></ea:framelabel>
<ea:framelabel id="Framelabel71" style="Z-INDEX: 220; LEFT: 28px; POSITION: absolute; TOP: 1372px; width: 223px;"
				runat="server" Height="26px" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Left" Number="9" 
                Text="Należności wynikające z umowy aktywizacyjnej">
                </ea:FrameLabel>
<ea:framelabel id="Framelabel90" style="Z-INDEX: 221; LEFT: 252px; POSITION: absolute; TOP: 1372px; width: 79px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.9Przychód" Height="28px" 
                Number="67">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel96" style="Z-INDEX: 222; LEFT: 329px; POSITION: absolute; TOP: 1372px; width: 75px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.9Koszty" Height="28px" 
                Number="68">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel145" style="Z-INDEX: 223; LEFT: 406px; POSITION: absolute; TOP: 1372px; width: 76px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.9Dochód" Height="28px" 
                Number="69">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel146" style="Z-INDEX: 224; LEFT: 560px; POSITION: absolute; TOP: 1372px; width: 69px;"
				runat="server" ValueStyle="Zl" DataMember="E.9Zaliczka" Height="28px" 
                Number="70"></ea:framelabel>
<ea:framelabel id="FrameLabel70" style="Z-INDEX: 225; LEFT: 28px; POSITION: absolute; TOP: 1400px; width: 222px;"
				runat="server" Height="26px" FrameStyle="SmallBoldYellow" 
                HorizontalAlign="Left" Number="10" Text="Inne źródła"></ea:framelabel>
<ea:framelabel id="Framelabel76" style="Z-INDEX: 226; LEFT: 252px; POSITION: absolute; TOP: 1400px; width: 78px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.10Przychód" Height="28px" 
                Number="71"></ea:framelabel>
<ea:framelabel id="Framelabel89" style="Z-INDEX: 227; LEFT: 406px; POSITION: absolute; TOP: 1400px; width: 78px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.10Dochód" Height="28px" 
                Number="72" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel157" style="Z-INDEX: 227; LEFT: 483px; POSITION: absolute; TOP: 1400px; width: 78px;"
				runat="server" ValueStyle="ZlGr" DataMember="E.10Zwolniony" Height="28px" 
                Number="73" CssClass="style1"></ea:framelabel>
<ea:framelabel id="Framelabel95" style="Z-INDEX: 228; LEFT: 560px; POSITION: absolute; TOP: 1400px; width: 69px;"
				runat="server" ValueStyle="Zl" DataMember="E.10Zaliczka" Height="28px" 
                Number="74"></ea:framelabel>
<ea:framelabel id="FrameLabel36" style="Z-INDEX: 229; LEFT: 35px; POSITION: absolute; TOP: 1428px; width: 389px;"
				runat="server" Height="26px" 
                Text="Składki na ubezpieczenia społeczne, o których mowa w przepisach ustawy, podlegające odliczenu od dochodu" 
                FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel99" style="Z-INDEX: 230; LEFT: 427px; POSITION: absolute; TOP: 1428px"
				runat="server" Width="203px" ValueStyle="ZlGr" DataMember="E.Społeczne" Height="28px" 
                Number="75"></ea:framelabel>
<ea:framelabel id="FrameLabel149" style="Z-INDEX: 229; LEFT: 42px; POSITION: absolute; TOP: 1456px; width: 382px;"
				runat="server" Height="26px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left" 
                Text="w tym zagraniczne, o których mowa w art.26 ust.1 pkt 2a ustawy"></ea:framelabel>
<ea:framelabel id="Framelabel148" style="Z-INDEX: 230; LEFT: 427px; POSITION: absolute; TOP: 1456px"
				runat="server" Width="203px" ValueStyle="ZlGr" DataMember="E.SpołeczneZagr" Height="28px" 
                Number="76"></ea:framelabel>
<ea:framelabel id="FrameLabel63" style="Z-INDEX: 231; LEFT: 35px; POSITION: absolute; TOP: 1484px; width: 394px;"
				runat="server" Height="28px" 
                Text="Składki na ubezpieczenie zdrowotne, o których mowa w przepisach ustawy, podlegające odliczenu od podatku" 
                FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel119" style="Z-INDEX: 232; LEFT: 427px; POSITION: absolute; TOP: 1484px"
				runat="server" Width="203px" ValueStyle="ZlGr" DataMember="E.ZdrDoOdlicz" 
                Height="28px" Number="77"></ea:framelabel>
<ea:framelabel id="FrameLabel151" style="Z-INDEX: 231; LEFT: 42px; POSITION: absolute; TOP: 1512px; width: 385px;"
				runat="server" Height="28px" FrameStyle="SmallBoldYellow" HorizontalAlign="Left" 
                Text="w tym zagraniczne, o których mowa w art.27b ust.1.pkt 2 ustawy"></ea:framelabel>
<ea:framelabel id="Framelabel150" style="Z-INDEX: 232; LEFT: 427px; POSITION: absolute; TOP: 1512px"
				runat="server" Width="203px" ValueStyle="ZlGr" DataMember="E.ZdrDoOdliczZagr" 
                Height="28px" Number="78"></ea:framelabel>
<ea:framelabel id="Framelabel121" style="Z-INDEX: 233; LEFT: 0px; POSITION: absolute; TOP: 1540px"
				runat="server" Width="630px" Height="112px" 
                Text="F. &lt;font STYLE='font-size: 10pt;'&gt;INFORMACJA O PRZYCHODACH ZWOLNIONYCH OD PODATKU ORAZ O ZAŁĄCZNIKU&lt;/font&gt;" 
                FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="FrameLabel58" style="Z-INDEX: 235; LEFT: 28px; POSITION: absolute; TOP: 1568px"
				runat="server" Width="399px" Height="28px" 
                Text="Przychody otrzymywane z zagranicy, o których mowa w art.21 ust.1 pkt 74 ustawy, między innymi renty inwalidzkie z tytułu inwalidztwa wojennego" FrameStyle="SmallBoldYellow"
				HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel78" style="Z-INDEX: 234; LEFT: 427px; POSITION: absolute; TOP: 1568px"
				runat="server" Width="203px" ValueStyle="ZlGr" DataMember="F.ZZagranicy" Height="28px" 
                Number="79"></ea:framelabel>
<ea:framelabel id="FrameLabel79" style="Z-INDEX: 236; LEFT: 28px; POSITION: absolute; TOP: 1596px"
				runat="server" Width="399px" Height="28px" Text="Przychody pochodzące ze środków bezzwrotnej pomocy zagranicznej, o których mowa w art.21 ust.1 pkt 46 ustawy:"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:framelabel>
<ea:framelabel id="Framelabel83" style="Z-INDEX: 237; LEFT: 427px; POSITION: absolute; TOP: 1596px"
				runat="server" Width="203px" ValueStyle="ZlGr" DataMember="F.PomocBezzwrotna" 
                Height="28px" Number="80"></ea:framelabel>
<ea:framelabel id="Framelabel137" style="Z-INDEX: 238; LEFT: 28px; POSITION: absolute; TOP: 1624px"
				runat="server" Width="602px" Height="28px" 
                Text="Do niniejszej informacji dołączono informację PIT-R <.Normal>(należy zaznaczyć właściwy kwadrat)<./>" 
                Number="81"></ea:framelabel>
<ea:checklabel id="Checklabel_82_T" style="Z-INDEX: 239; LEFT: 161px; POSITION: absolute; TOP: 1631px"
				runat="server" Width="35px" DataMember="F.PITR" Height="14px" Text="Tak" Number="1" 
                NumberAlignLeft="False"></ea:checklabel>
<ea:checklabel id="Checklabel_82_N" style="Z-INDEX: 240; LEFT: 328px; POSITION: absolute; TOP: 1633px"
				runat="server" Width="35px" DataMember="F.PITR" Height="14px" Text="Nie" Number="2" 
                NumberAlignLeft="False" ComparedValue="False"></ea:checklabel>
<ea:framelabel id="FrameLabel122" style="Z-INDEX: 241; LEFT: 0px; POSITION: absolute; TOP: 1652px"
				runat="server" Width="630px" Height="56px" Text="G. &lt;font STYLE='font-size: 10pt;'&gt;OŚW.PŁATNIKA LUB OSOBY ODPOWIEDZIALNEJ ZA OBLICZENIE I POBRANIE PODATKU&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za uchybienie obowiązkom płatnika&lt;./&gt;"
				FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="FrameLabel123" style="Z-INDEX: 242; LEFT: 28px; POSITION: absolute; TOP: 1680px"
				runat="server" Width="147px" DataMember="G.Imię" Height="28px" Text="Imię" Number="82"></ea:framelabel>
<ea:framelabel id="FrameLabel125" style="Z-INDEX: 244; LEFT: 175px; POSITION: absolute; TOP: 1680px" SmallerFontLength="20"
				runat="server" Width="147px" DataMember="G.Nazwisko" Height="28px" Text="Nazwisko" 
                Number="83"></ea:framelabel>
<ea:framelabel id="FrameLabel124" style="Z-INDEX: 243; LEFT: 322px; POSITION: absolute; TOP: 1680px"
				runat="server" Width="308px" Height="28px" 
                Text="Podpis (i pieczątka) osoby odpowiedzialnej za obliczenie i pobranie podatku" 
                Number="84"></ea:framelabel>
<ea:framelabel id="FrameLabel127" style="Z-INDEX: 245; LEFT: 0px; POSITION: absolute; TOP: 1708px"
				runat="server" Width="630px" Height="62px" Text="H. ADNOTACJE URZĘDU SKARBOWEGO" 
                FrameStyle="BigYellowBold" FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="FrameLabel130" style="Z-INDEX: 246; LEFT: 28px; POSITION: absolute; TOP: 1729px"
				runat="server" Width="602px" Height="20px" Text="Uwagi urzędu skarbowego" 
                FrameStyle="SmallBoldGray" Number="85"></ea:framelabel>
<ea:framelabel id="FrameLabel128" style="Z-INDEX: 247; LEFT: 28px; POSITION: absolute; TOP: 1750px"
				runat="server" Width="301px" Height="20px" 
                Text="Identyfikator przyjmującego formularz" FrameStyle="SmallBoldGray" 
                Number="86"></ea:framelabel>
<ea:framelabel id="FrameLabel129" style="Z-INDEX: 248; LEFT: 329px; POSITION: absolute; TOP: 1750px"
				runat="server" Width="301px" Height="20px" Text="Podpis przyjmującego formularz" 
                FrameStyle="SmallBoldGray" Number="87"></ea:framelabel>
<ea:framelabel id="FrameLabel147" style="Z-INDEX: 249; LEFT: 3px; POSITION: absolute; TOP: 1771px"
				runat="server" Width="627px" Height="28px" 
                Text="1) Art.35a ustawy został uchylony z dniem 26 października 2007 r. ustawą z dnia 24 sierpnia 2007 r. o zmianie ustawy o promocji zatrudnienia i instytucjach rynku pracy oraz o zmianie niektórych innych ustaw (Dz.U.Nr 176, poz.1243). Uchylony przepis na mocy art.7 ust.7 powołanej ustawy ma zastosowanie do płatników do czasu obowiązywania umowy aktywizacyjnej zawartej przed dniem 26 października 2007 r." 
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel132" style="Z-INDEX: 250; LEFT: 3px; POSITION: absolute; TOP: 1799px"
				runat="server" Width="627px" Height="1px" 
                Text="2) Ilekroć jest mowa o urzędzie skarbowym - oznacza to urząd skarbowy, którym kieruje właściwy dla podatnika naczelnik urzędu skarbowego." 
                FrameStyle="Small" FrameBorderStyle="None">
                </ea:FrameLabel>
<ea:framelabel id="Framelabel131" style="Z-INDEX: 251; LEFT: 3px; POSITION: absolute; TOP: 1808px"
				runat="server" Width="627px" Height="21px" 
                Text="3) Zgodnie z art.81 Ordynacji podatkowej płatnik może skorygować złożoną informację przez złożenie informacji korygującej wraz z dołączonym pisemnym uzasadnieniem przyczyn korekty." 
                FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel133" style="Z-INDEX: 252; LEFT: 3px; POSITION: absolute; TOP: 1827px; height: 29px;"
				runat="server" Width="627px" 
                Text="4) W kwocie przychodów, w części E, nie uwzględnia się przychodów wolnych od podatku na podstawie przepisów ustawy oraz przychodów, od których na podstawie przepisów Ordynacji podatkowej zaniechano poboru podatku; jednakże w kolumnie e należy wykazać dochody zwolnione od podatku na podstawie umów o unikaniu podwójnego opodatkowania lub innych umów międzynarodowych." 
                FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="Framelabel35" style="Z-INDEX: 253; LEFT: 3px; POSITION: absolute; TOP: 1856px"
				runat="server" Width="627px" Height="6px" 
                Text="5) W kwocie kosztów uzyskania przychodu wykazuje się koszty faktycznie uwzględnione przez płatnika przy poborze zaliczek na podatek." 
                FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel56" style="Z-INDEX: 254; LEFT: 3px; POSITION: absolute; TOP: 1865px; height: 31px;"
				runat="server" Width="627px"                 
                Text="6) W poz. 75-78 nie wykazuje się składek, których podstawę wymiaru stanowi dochód (przychód) zwolniony od podatku na podstawie ustawy oraz składek. których podstawę wymiaru stanowi dochód, od którego na podstawie przepisów Ordynacji podatkowej zaniechano poboru podatku, a w przypadku składek zagranicznych, których podstawę wymiaru stanowi dochód (przychód) zwolniony od podatku na podstawie umów o unikaniu podwójnego opodatkowania." FrameStyle="Small"
				FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel136" style="Z-INDEX: 255; LEFT: 3px; POSITION: absolute; TOP: 1895px"
				runat="server" Width="627px" Height="6px" Text="Ilekroć w informacji jest mowa o Ordynacji podatkowej - oznacza to ustawę z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz.U. z 2005 r. Nr 8, poz.60, z późn.zm.)."
				FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
<ea:deklaracjafooter id="footer2" 
                style="Z-INDEX: 256; LEFT: 0px; POSITION: absolute; TOP: 1906px" runat="server"
				TitleWidth="106" Symbol="PIT-11" PageNumber="2" PageTotal="2" Version="18"></ea:deklaracjafooter>
<ea:datacontext id="dc" style="Z-INDEX: 257; LEFT: 189px; POSITION: absolute; TOP: 1910px" runat="server"
				TypeName="Soneta.Deklaracje.PIT.PIT,Soneta.Deklaracje" oncontextload="OnContextLoad" 
                LeftMargin="15" PageHeight="977px" PageZoom="107%"></ea:datacontext>
<ea:framelabel id="flDanePodatnika" style="Z-INDEX: 258; LEFT: 199px; POSITION: absolute; TOP: 1905px; height: 21px; width: 427px; right: 275px;"
				runat="server" Text="?" FrameStyle="Middle" FrameBorderStyle="None" 
                HorizontalAlign="Right" VerticalAlign="Bottom"></ea:framelabel>
</form>
	</body>
</HTML>
