﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<script runat="server">
    protected void dc_ContextLoad(object sender, EventArgs e) {
        PIT8AR_Base pit = (PIT8AR_Base)dc[typeof(PIT8AR_Base)];
        if (!(pit is PIT8AR_2))
            throw new InvalidOperationException("Wydruk PIT-8AR (2) może być drukowany wyłącznie dla deklaracji PIT-8AR w wersji 2.");
        int miesiąc = pit.RokMiesiac.Month;
        if (miesiąc == 12)
            flMiesiac.Visible = false;
        else
            foreach (object obj in PIT8AR_2.Controls) {
                FrameLabel f = obj as FrameLabel;
                if (f != null && !ValidFrame(f.DataMember, miesiąc))
                    f.DataMember = "";
            }
    }
    static bool ValidFrame(string dataMember, int miesiąc) {
        if (dataMember == "" || dataMember[0] != 'C')
            return true;
        int i = dataMember.IndexOf('.');
        int l = char.IsDigit(dataMember[i + 2]) ? 2 : 1;
        dataMember = dataMember.Substring(i + 1, l);
        return int.Parse(dataMember) == miesiąc;
    }
</script>
<HTML>
	<HEAD>
		<title>PIT-8AR (1)</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body leftMargin="0" rightMargin="0">
		<form id="PIT8AR_2" method="post" runat="server">
			<ea:DeklaracjaHeader id="DeklaracjaHeader1" style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 0px"
				runat="server" StylNagłówka="JasneCiemneElektronicznie"></ea:DeklaracjaHeader>
<ea:framelabel id="FrameLabel21" style="Z-INDEX: 101; LEFT: 0px; POSITION: absolute; TOP: 21px"
				runat="server" DataMember="0.Nip" Height="28px" Width="252px" Text="1. Identyfikator podatkowy NIP płatnika"
				ValueStyle="nip_w"></ea:framelabel>
<ea:framelabel id="FrameLabel22" style="Z-INDEX: 102; LEFT: 252px; POSITION: absolute; TOP: 21px"
				runat="server" Number="2" Height="28px" Width="126px" Text="Nr dokumentu" FrameStyle="SmallBoldGray"></ea:framelabel>
<ea:framelabel id="FrameLabel23" style="Z-INDEX: 103; LEFT: 378px; POSITION: absolute; TOP: 21px"
				runat="server" Number="3" Height="30px" Width="77px" Text="Status" FrameStyle="SmallBoldGray"></ea:framelabel>
<ea:framelabel id="FrameLabel35" style="Z-INDEX: 104; LEFT: 0px; POSITION: absolute; TOP: 49px"
				runat="server" Height="14px" Width="70px" Text="PIT-8AR" FrameBorderStyle="None" FrameStyle="BigBold"></ea:framelabel>
<ea:framelabel id="FrameLabel34" style="Z-INDEX: 105; LEFT: 91px; POSITION: absolute; TOP: 70px"
				runat="server" Height="34px" Width="413px" Text="DEKLARACJA ROCZNA O ZRYCZAŁTOWANYM PODATKU DOCHODOWYM"
				FrameBorderStyle="None" FrameStyle="BigBold" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="FrameLabel20" style="Z-INDEX: 106; LEFT: 273px; POSITION: absolute; TOP: 112px"
				runat="server" DataMember="0.Rok" Height="28px" Width="126px" Text="4. Rok" ValueStyle="n2"></ea:framelabel>
<ea:framelabel id="flMiesiac" style="Z-INDEX: 106; LEFT: 406px; POSITION: absolute; TOP: 112px"
				runat="server" DataMember="0.Miesiąc" Height="28px" Width="126px" Text="Miesiąc" ValueStyle="n2">
                </ea:FrameLabel>
<ea:framelabel id="FrameLabel29" style="Z-INDEX: 107; LEFT: 217px; POSITION: absolute; TOP: 119px"
				runat="server" Height="17px" Width="28px" Text="za" FrameBorderStyle="None" FrameStyle="BigBold"></ea:framelabel>
<ea:framelabel id="FrameLabel24" style="Z-INDEX: 108; LEFT: 0px; POSITION: absolute; TOP: 147px"
				runat="server" Height="112px" Width="653px" FrameStyle="SmallBoldYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel25" style="Z-INDEX: 109; LEFT: 7px; POSITION: absolute; TOP: 154px"
				runat="server" Height="14px" Width="91px" Text="Podstawa prawna:" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel26" style="Z-INDEX: 110; LEFT: 133px; POSITION: absolute; TOP: 154px"
				runat="server" Height="21px" Width="511px" Text='Art.42 ust.1a ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych (Dz. U. z 2010 r. Nr 51, poz.307 z późn. zm.), zwanej dalej "ustawą".'
				FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel27" style="Z-INDEX: 111; LEFT: 7px; POSITION: absolute; TOP: 182px"
				runat="server" Height="7px" Width="91px" Text="Składający:" FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel28" style="Z-INDEX: 112; LEFT: 133px; POSITION: absolute; TOP: 182px"
				runat="server" Height="7px" Width="511px" Text="Płatnik zryczałtowanego podatku dochodowego od osób fizycznych."
				FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel30" style="Z-INDEX: 113; LEFT: 7px; POSITION: absolute; TOP: 203px"
				runat="server" Height="7px" Width="91px" Text="Terminy składania:" FrameBorderStyle="None"
				FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel31" style="Z-INDEX: 114; LEFT: 133px; POSITION: absolute; TOP: 203px"
				runat="server" Height="20px" Width="511px" Text="Do końca stycznia roku następującego po roku podatkowym. W przypadku zaprzestania działalności przez płatnika przed tym terminem - do dnia zaprzestania tej działalności."
				FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel32" style="Z-INDEX: 115; LEFT: 7px; POSITION: absolute; TOP: 231px"
				runat="server" Height="7px" Width="91px" Text="Otrzymuje:" FrameBorderStyle="None"
				FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel33" style="Z-INDEX: 116; LEFT: 133px; POSITION: absolute; TOP: 231px"
				runat="server" Height="21px" Width="511px" Text="Urząd skarbowy <.INDEXUP>1)<./> według miejsca zamieszkania płatnika, a jeżeli płatnik nie jest osobą fizyczną, według siedziby bądź miejsca prowadzenia działalności, gdy płatnik nie posiada siedziby."
				FrameBorderStyle="None" FrameStyle="SmallYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel17" style="Z-INDEX: 117; LEFT: 0px; POSITION: absolute; TOP: 259px"
				runat="server" Height="84px" Width="651px" Text="A. MIEJSCE I CEL SKŁADANIA DEKLARACJI" FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel18" style="Z-INDEX: 118; LEFT: 28px; POSITION: absolute; TOP: 287px"
				runat="server" DataMember="A.UrzadSkarb" Number="5" Height="28px" Width="620px" Text="Urząd skarbowy, do którego adresowana jest deklaracja"></ea:framelabel>
<ea:framelabel id="Framelabel19" style="Z-INDEX: 122; LEFT: 28px; POSITION: absolute; TOP: 315px"
				runat="server" Number="6" Height="28px" Width="622px" Text="Cel złożenia formularza<.Normal>(zaznaczyć właściwy kwadrat)<./>">
                </ea:FrameLabel>
<ea:checklabel id="Checklabel4" style="Z-INDEX: 124; LEFT: 182px; POSITION: absolute; TOP: 322px"
				runat="server" DataMember="A.Korekta" Number="1" Height="14px" Width="189px" Text="złożenie deklaracji"
				NumberAlignLeft="False" ComparedValue="False">
            </ea:CheckLabel>
<ea:checklabel id="Checklabel3" style="Z-INDEX: 174; LEFT: 392px; POSITION: absolute; TOP: 322px"
				runat="server" DataMember="A.Korekta" Number="2" Height="14px" Width="124px" Text="korekta deklaracji 2)"
				NumberAlignLeft="False"></ea:checklabel>
<ea:framelabel id="FrameLabel1" style="Z-INDEX: 119; LEFT: 0px; POSITION: absolute; TOP: 343px"
				runat="server" Height="35px" Width="649px" Text="B. DANE PŁATNIKA" FrameStyle="BigYellowBold"
				FooterText="                        * - dotyczy płatnika niebędącego osobą fizyczną       ** - dotyczy płatnika będącego osobą fizyczną"
				FrameBorderStyle="DoubleHeader"></ea:framelabel>
<ea:framelabel id="FrameLabel2" style="Z-INDEX: 120; LEFT: 0px; POSITION: absolute; TOP: 378px"
				runat="server" Height="112px" Width="651px" Text="B.1. DANE IDENTYFIKACYJNE" FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel3" style="Z-INDEX: 121; LEFT: 28px; POSITION: absolute; TOP: 399px"
				runat="server" Number="7" Height="28px" Width="622px" Text="Rodzaj płatnika <.Normal>(zaznaczyć właściwy kwadrat)<./>"></ea:framelabel>
<ea:checklabel id="CheckLabel1" style="Z-INDEX: 123; LEFT: 133px; POSITION: absolute; TOP: 406px"
				runat="server" DataMember="B1.OsobaFiz" Number="1" Height="14px" Width="189px" Text="płatnik niebędący osobą fizyczną"
				NumberAlignLeft="False" ComparedValue="False">
            </ea:CheckLabel>
<ea:checklabel id="CheckLabel2" style="Z-INDEX: 125; LEFT: 434px; POSITION: absolute; TOP: 406px"
				runat="server" DataMember="B1.OsobaFiz" Number="2" Height="14px" Width="124px" Text="osoba fizyczna"
				NumberAlignLeft="False">
            </ea:CheckLabel>
<ea:framelabel id="FrameLabel4" style="Z-INDEX: 127; LEFT: 28px; POSITION: absolute; TOP: 427px"
				runat="server" DataMember="B1.Nazwa" Number="8" Height="63px" Width="624px" 
                Text="Nazwa pełna, REGON* / Nazwisko, pierwsze imię, data urodzenia **"></ea:framelabel>
<ea:framelabel id="FrameLabel5" style="Z-INDEX: 128; LEFT: 0px; POSITION: absolute; TOP: 490px"
				runat="server" Height="112px" Width="652px" Text="B.2. ADRES SIEDZIBY * / ADRES ZAMIESZKANIA **"
				FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel6" style="Z-INDEX: 129; LEFT: 28px; POSITION: absolute; TOP: 518px"
				runat="server" DataMember="B2.Kraj" Number="9" Height="28px" Width="134px" Text="Kraj"></ea:framelabel>
<ea:framelabel id="FrameLabel7" style="Z-INDEX: 130; LEFT: 161px; POSITION: absolute; TOP: 518px"
				runat="server" DataMember="B2.Wojew" Number="10" Height="28px" Width="273px" Text="Województwo"></ea:framelabel>
<ea:framelabel id="FrameLabel8" style="Z-INDEX: 131; LEFT: 434px; POSITION: absolute; TOP: 518px"
				runat="server" DataMember="B2.Powiat" Number="11" Height="28px" Width="218px" Text="Powiat"></ea:framelabel>
<ea:framelabel id="FrameLabel9" style="Z-INDEX: 132; LEFT: 28px; POSITION: absolute; TOP: 546px"
				runat="server" DataMember="B2.Gmina" Number="12" Height="28px" Width="161px" Text="Gmina"></ea:framelabel>
<ea:framelabel id="FrameLabel10" style="Z-INDEX: 133; LEFT: 189px; POSITION: absolute; TOP: 546px"
				runat="server" DataMember="B2.Ulica" Number="13" Height="28px" Width="308px" Text="Ulica"></ea:framelabel>
<ea:framelabel id="FrameLabel11" style="Z-INDEX: 134; LEFT: 497px; POSITION: absolute; TOP: 546px"
				runat="server" DataMember="B2.NrDomu" Number="14" Height="28px" Width="91px" Text="Nr domu"></ea:framelabel>
<ea:framelabel id="FrameLabel12" style="Z-INDEX: 135; LEFT: 588px; POSITION: absolute; TOP: 546px"
				runat="server" DataMember="B2.NrLokalu" Number="15" Height="28px" Width="63px" Text="Nr lokalu"></ea:framelabel>
<ea:framelabel id="FrameLabel13" style="Z-INDEX: 136; LEFT: 28px; POSITION: absolute; TOP: 574px"
				runat="server" DataMember="B2.Miejsc" Number="16" Height="28px" Width="266px" Text="Miejscowość"></ea:framelabel>
<ea:framelabel id="FrameLabel14" style="Z-INDEX: 137; LEFT: 294px; POSITION: absolute; TOP: 574px"
				runat="server" DataMember="B2.KodPoczt" Number="17" Height="28px" Width="105px" Text="Kod pocztowy"
				ValueStyle="PostalCode"></ea:framelabel>
<ea:framelabel id="FrameLabel15" style="Z-INDEX: 138; LEFT: 399px; POSITION: absolute; TOP: 574px"
				runat="server" DataMember="B2.Poczta" Number="18" Height="28px" Width="253px" Text="Poczta"></ea:framelabel>
<ea:framelabel id="FrameLabel16" style="Z-INDEX: 139; LEFT: 0px; POSITION: absolute; TOP: 602px"
				runat="server" Height="32px" Width="651px" Text="C. WYKAZ NALEŻNEGO ZRYCZAŁTOWANEGO PODATKU DOCHODOWEGO POBRANEGO ZA POSZCZEGÓLNE MIESIĄCE ROKU PODATKOWEGO" 
				FrameStyle="BigYellowBold"
				FrameBorderStyle="DoubleHeader" VerticalAlign="Middle"></ea:framelabel>
<ea:framelabel id="Framelabel41" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 636px"
				runat="server" Height="24px" Width="651px" Text="Wygrane w konkursach, grach i zakładach wzajemnych oraz nagrody związane ze sprzedażą premiową (art.30 ust.1 pkt 2 ustawy)"
				FrameStyle="MiddleBoldYellow" Number="1" VerticalAlign="Middle">
                </ea:FrameLabel>         
<ea:framelabel id="Framelabel64" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 658px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Left" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel36" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 658px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel37" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 658px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel38" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 658px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel39" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 658px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel40" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 658px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel42" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 658px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel71" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 672px"
				runat="server" DataMember="C1.1Podatek" Number="19" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel72" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 672px"
				runat="server" DataMember="C1.2Podatek" Number="20" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel73" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 672px"
				runat="server" DataMember="C1.3Podatek" Number="21" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel74" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 672px"
				runat="server" DataMember="C1.4Podatek" Number="22" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel75" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 672px"
				runat="server" DataMember="C1.5Podatek" Number="23" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel76" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 672px"
				runat="server" DataMember="C1.6Podatek" Number="24" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel77" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 714px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel78" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 714px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel132" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 714px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel133" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 714px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel311" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 714px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel330" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 714px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel331" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 728px"
				runat="server" DataMember="C1.7Podatek" Number="25" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel332" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 728px"
				runat="server" DataMember="C1.8Podatek" Number="26" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel333" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 728px"
				runat="server" DataMember="C1.9Podatek" Number="27" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel334" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 728px"
				runat="server" DataMember="C1.10Podatek" Number="28" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel336" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 728px"
				runat="server" DataMember="C1.11Podatek" Number="29" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel337" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 728px"
				runat="server" DataMember="C1.12Podatek" Number="30" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel63" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 777px"
				runat="server" Height="28px" Width="651px" Text="Świadczenia otrzymane przez emerytów lub rencistów będących byłymi pracownikami (art.30 ust.1 pkt 4 ustawy)" FrameStyle="MiddleBoldYellow" Number="2" VerticalAlign="Middle">
                </ea:FrameLabel>
<ea:framelabel id="Framelabel62" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 805px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Left" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel65" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 805px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel66" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 805px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel67" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 805px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel68" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 805px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel69" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 805px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel70" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 805px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel82" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 819px"
				runat="server" DataMember="C2.1Podatek" Number="31" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel100" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 819px"
				runat="server" DataMember="C2.2Podatek" Number="32" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel109" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 819px"
				runat="server" DataMember="C2.3Podatek" Number="33" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel112" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 819px"
				runat="server" DataMember="C2.4Podatek" Number="34" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel104" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 819px"
				runat="server" DataMember="C2.5Podatek" Number="35" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel96" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 819px"
				runat="server" DataMember="C2.6Podatek" Number="36" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel83" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 861px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel101" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 861px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel110" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 861px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel113" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 861px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel105" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 861px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel97" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 861px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel84" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 875px"
				runat="server" DataMember="C2.7Podatek" Number="37" Height="49px" Width="84px" ValueStyle="ForceZl">
                </ea:FrameLabel>
<ea:framelabel id="Framelabel102" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 875px"
				runat="server" DataMember="C2.8Podatek" Number="38" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel111" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 875px"
				runat="server" DataMember="C2.9Podatek" Number="39" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel114" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 875px"
				runat="server" DataMember="C2.10Podatek" Number="40" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel106" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 875px"
				runat="server" DataMember="C2.11Podatek" Number="41" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel98" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 875px"
				runat="server" DataMember="C2.12Podatek" Number="42" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:DeklaracjaFooter id="DeklaracjaFooter1" style="Z-INDEX: 152; LEFT: 532px; POSITION: absolute; TOP: 945px"
				runat="server" Width="56px" Height="15px" Symbol="PIT-8AR" PageNumber="1" 
                PageTotal="4" Version="2"></ea:DeklaracjaFooter>
<ea:DeklaracjaHeader id="DeklaracjaHeader2" 
                style="Z-INDEX: 153; LEFT: 0px; POSITION: absolute; TOP: 980px" runat="server" 
                StylNagłówka="JasneCiemneElektronicznie"></ea:DeklaracjaHeader>
<ea:framelabel id="Framelabel79" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1001px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="3" VerticalAlign="Middle" Text="Świadczenia pieniężne otrzymane przez funkcjonariuszy służb mundurowych oraz żołnierzy, wymienione w art.30 ust.1 pkt 4a ustawy">
                </ea:FrameLabel>
<ea:framelabel id="Framelabel80" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 1029px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel81" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 1029px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel95" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 1029px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel99" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 1029px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel103" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 1029px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel107" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 1029px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel108" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 1029px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel43" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 1043px"
				runat="server" DataMember="C3.1Podatek" Number="43" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel44" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 1043px"
				runat="server" DataMember="C3.2Podatek" Number="44" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel45" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 1043px"
				runat="server" DataMember="C3.3Podatek" Number="45" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel46" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 1043px"
				runat="server" DataMember="C3.4Podatek" Number="46" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel47" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 1043px"
				runat="server" DataMember="C3.5Podatek" Number="47" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel48" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 1043px"
				runat="server" DataMember="C3.6Podatek" Number="48" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel49" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 1085px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel50" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 1085px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel51" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 1085px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel53" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 1085px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel54" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 1085px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel55" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 1085px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel56" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 1099px"
				runat="server" DataMember="C3.7Podatek" Number="49" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel57" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 1099px"
				runat="server" DataMember="C3.8Podatek" Number="50" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel58" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 1099px"
				runat="server" DataMember="C3.9Podatek" Number="51" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel59" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 1099px"
				runat="server" DataMember="C3.10Podatek" Number="52" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel60" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 1099px"
				runat="server" DataMember="C3.11Podatek" Number="53" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel61" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 1099px"
				runat="server" DataMember="C3.12Podatek" Number="54" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel85" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1148px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="4" VerticalAlign="Middle" Text="Jednorazowe odszkodowania za skrócenie okresu wypowiedzenia wypłacane żołnierzom zwalnianym z zawodowej służby wojskowej (art.30 ust.1 pkt 13 ustawy)">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel86" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 1176px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel115" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 1176px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel116" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 1176px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel117" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 1176px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel118" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 1176px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel119" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 1176px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel124" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 1176px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel161" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 1190px"
				runat="server" DataMember="C4.1Podatek" Number="55" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel162" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 1190px"
				runat="server" DataMember="C4.2Podatek" Number="56" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel163" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 1190px"
				runat="server" DataMember="C4.3Podatek" Number="57" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel164" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 1190px"
				runat="server" DataMember="C4.4Podatek" Number="58" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel165" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 1190px"
				runat="server" DataMember="C4.5Podatek" Number="59" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel166" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 1190px"
				runat="server" DataMember="C4.6Podatek" Number="60" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel167" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 1232px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel168" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 1232px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel169" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 1232px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel170" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 1232px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel171" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 1232px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel172" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 1232px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel173" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 1246px"
				runat="server" DataMember="C4.7Podatek" Number="61" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel174" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 1246px"
				runat="server" DataMember="C4.8Podatek" Number="62" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel175" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 1246px"
				runat="server" DataMember="C4.9Podatek" Number="63" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel176" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 1246px"
				runat="server" DataMember="C4.10Podatek" Number="64" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel177" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 1246px"
				runat="server" DataMember="C4.11Podatek" Number="65" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel178" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 1246px"
				runat="server" DataMember="C4.12Podatek" Number="66" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel87" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1295px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="5" VerticalAlign="Middle" Text="Należności osób zagranicznych, wymienione w art.29 ustawy">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel90" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 1323px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel155" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 1323px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel156" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 1323px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel157" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 1323px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel158" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 1323px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel159" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 1323px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel160" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 1323px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel185" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 1337px"
				runat="server" DataMember="C5.1Podatek" Number="67" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel186" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 1337px"
				runat="server" DataMember="C5.2Podatek" Number="68" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel187" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 1337px"
				runat="server" DataMember="C5.3Podatek" Number="69" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel188" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 1337px"
				runat="server" DataMember="C5.4Podatek" Number="70" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel189" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 1337px"
				runat="server" DataMember="C5.5Podatek" Number="71" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel190" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 1337px"
				runat="server" DataMember="C5.6Podatek" Number="72" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel191" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 1379px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel192" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 1379px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel193" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 1379px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel194" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 1379px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel195" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 1379px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel196" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 1379px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel197" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 1393px"
				runat="server" DataMember="C5.7Podatek" Number="73" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel198" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 1393px"
				runat="server" DataMember="C5.8Podatek" Number="74" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel199" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 1393px"
				runat="server" DataMember="C5.9Podatek" Number="75" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel200" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 1393px"
				runat="server" DataMember="C5.10Podatek" Number="76" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel201" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 1393px"
				runat="server" DataMember="C5.11Podatek" Number="77" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel202" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 1393px"
				runat="server" DataMember="C5.12Podatek" Number="78" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel89" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1442px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="6" VerticalAlign="Middle" Text="Odsetki od pożyczek (z wyjątkiem gdy udzielanie pożyczek jest przedmiotem działalności gospodarczej), odsetki i dyskonto od papierów wartościowych (art.30a ust.1 pkt 1 i 2 ustawy)">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel252" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 1470px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel179" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 1470px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel180" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 1470px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel181" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 1470px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel182" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 1470px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel183" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 1470px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel184" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 1470px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel137" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 1484px"
				runat="server" DataMember="C6.1Podatek" Number="79" Height="42px" Width="84px" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel138" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 1484px"
				runat="server" DataMember="C6.2Podatek" Number="80" Height="42px" Width="84px" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel139" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 1484px"
				runat="server" DataMember="C6.3Podatek" Number="81" Height="42px" Width="84px" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel140" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 1484px"
				runat="server" DataMember="C6.4Podatek" Number="82" Height="42px" Width="84px" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel141" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 1484px"
				runat="server" DataMember="C6.5Podatek" Number="83" Height="42px" Width="84px" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel142" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 1484px"
				runat="server" DataMember="C6.6Podatek" Number="84" Height="42px" Width="84px" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel143" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 1526px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel144" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 1526px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel145" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 1526px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel146" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 1526px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel147" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 1526px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel148" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 1526px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel149" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 1540px"
				runat="server" DataMember="C6.7Podatek" Number="85" Height="49px" Width="84px" 
                ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel150" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 1540px"
				runat="server" DataMember="C6.8Podatek" Number="86" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel151" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 1540px"
				runat="server" DataMember="C6.9Podatek" Number="87" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel152" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 1540px"
				runat="server" DataMember="C6.10Podatek" Number="88" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel153" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 1540px"
				runat="server" DataMember="C6.11Podatek" Number="89" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel154" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 1540px"
				runat="server" DataMember="C6.12Podatek" Number="90" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel91" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1589px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="7" VerticalAlign="Middle" Text="Odsetki lub inne przychody od środków pieniężnych zgromadzonych na rachunku podatnika lub w innych formach oszczędzania przechowywania lub inwestowania (art.30a ust.1 pkt 3 ustawy)">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel92" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 1617px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel203" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 1617px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel228" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 1617px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel229" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 1617px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel230" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 1617px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel231" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 1617px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel232" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 1617px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel233" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 1631px"
				runat="server" DataMember="C7.1Podatek" Number="91" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel234" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 1631px"
				runat="server" DataMember="C7.2Podatek" Number="92" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel235" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 1631px"
				runat="server" DataMember="C7.3Podatek" Number="93" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel236" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 1631px"
				runat="server" DataMember="C7.4Podatek" Number="94" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel237" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 1631px"
				runat="server" DataMember="C7.5Podatek" Number="95" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel238" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 1631px"
				runat="server" DataMember="C7.6Podatek" Number="96" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel239" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 1673px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel240" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 1673px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel241" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 1673px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel242" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 1673px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel243" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 1673px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel244" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 1673px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel245" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 1687px"
				runat="server" DataMember="C7.7Podatek" Number="97" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel246" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 1687px"
				runat="server" DataMember="C7.8Podatek" Number="98" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel247" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 1687px"
				runat="server" DataMember="C7.9Podatek" Number="99" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel248" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 1687px"
				runat="server" DataMember="C7.10Podatek" Number="100" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel249" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 1687px"
				runat="server" DataMember="C7.11Podatek" Number="101" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel250" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 1687px"
				runat="server" DataMember="C7.12Podatek" Number="102" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel93" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1736px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="8" VerticalAlign="Middle" Text="Dywidendy i inne przychody z tytułu udziału w zyskach osób prawnych (art.30a ust.1 pkt 4 ustawy)">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel94" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 1764px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel227" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 1764px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel204" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 1764px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel205" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 1764px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel206" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 1764px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel207" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 1764px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel208" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 1764px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel209" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 1778px"
				runat="server" DataMember="C8.1Podatek" Number="103" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel210" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 1778px"
				runat="server" DataMember="C8.2Podatek" Number="104" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel211" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 1778px"
				runat="server" DataMember="C8.3Podatek" Number="105" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel212" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 1778px"
				runat="server" DataMember="C8.4Podatek" Number="106" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel213" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 1778px"
				runat="server" DataMember="C8.5Podatek" Number="107" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel214" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 1778px"
				runat="server" DataMember="C8.6Podatek" Number="108" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel215" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 1820px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel216" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 1820px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel217" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 1820px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel218" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 1820px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel219" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 1820px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel220" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 1820px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel221" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 1834px"
				runat="server" DataMember="C8.7Podatek" Number="109" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel222" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 1834px"
				runat="server" DataMember="C8.8Podatek" Number="110" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel223" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 1834px"
				runat="server" DataMember="C8.9Podatek" Number="111" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel224" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 1834px"
				runat="server" DataMember="C8.10Podatek" Number="112" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel225" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 1834px"
				runat="server" DataMember="C8.11Podatek" Number="113" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel226" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 1834px"
				runat="server" DataMember="C8.12Podatek" Number="114" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:DeklaracjaFooter id="DeklaracjaFooter3" 
                style="Z-INDEX: 152; LEFT: 0px; POSITION: absolute; TOP: 1911px" runat="server" 
                Width="56px" Height="15px" Symbol="PIT-8AR" PageNumber="2" PageTotal="4" 
                Version="2"></ea:DeklaracjaFooter>
<ea:DeklaracjaHeader id="DeklaracjaHeader3" 
                style="Z-INDEX: 153; LEFT: 0px; POSITION: absolute; TOP: 1960px" runat="server" 
                StylNagłówka="JasneCiemneElektronicznie"></ea:DeklaracjaHeader>
<ea:framelabel id="Framelabel251" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 1981px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="9" VerticalAlign="Middle" Text="Dochód z tytułu udziału w funduszach kapitałowych (art.30a ust.1 pkt 5 ustawy)">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel257" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 2009px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel263" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2009px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel264" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2009px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel265" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2009px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel266" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2009px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel267" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2009px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel268" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2009px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel293" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 2023px"
				runat="server" DataMember="C9.1Podatek" Number="115" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel294" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 2023px"
				runat="server" DataMember="C9.2Podatek" Number="116" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel295" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 2023px"
				runat="server" DataMember="C9.3Podatek" Number="117" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel296" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 2023px"
				runat="server" DataMember="C9.4Podatek" Number="118" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel297" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 2023px"
				runat="server" DataMember="C9.5Podatek" Number="119" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel298" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 2023px"
				runat="server" DataMember="C9.6Podatek" Number="120" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel299" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2065px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel300" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2065px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel301" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2065px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel302" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2065px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel303" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2065px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel304" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2065px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel305" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 2079px"
				runat="server" DataMember="C9.7Podatek" Number="1121" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel306" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 2079px"
				runat="server" DataMember="C9.8Podatek" Number="122" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel307" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 2079px"
				runat="server" DataMember="C9.9Podatek" Number="123" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel308" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 2079px"
				runat="server" DataMember="C9.10Podatek" Number="124" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel309" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 2079px"
				runat="server" DataMember="C9.11Podatek" Number="125" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel310" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 2079px"
				runat="server" DataMember="C9.12Podatek" Number="126" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel256" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 2128px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="10" VerticalAlign="Middle" Text="Kwoty wypłacone po śmierci członka otwartegu funduszu emerytalnego (art.30a ust.1 pkt 6 ustawy)">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel258" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 2156px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel287" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2156px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel288" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2156px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel289" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2156px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel290" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2156px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel291" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2156px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel292" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2156px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel269" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 2170px"
				runat="server" DataMember="C10.1Podatek" Number="127" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel270" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 2170px"
				runat="server" DataMember="C10.2Podatek" Number="128" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel271" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 2170px"
				runat="server" DataMember="C10.3Podatek" Number="129" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel272" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 2170px"
				runat="server" DataMember="C10.4Podatek" Number="130" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel273" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 2170px"
				runat="server" DataMember="C10.5Podatek" Number="131" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel274" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 2170px"
				runat="server" DataMember="C10.6Podatek" Number="132" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel275" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2212px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel276" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2212px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel277" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2212px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel278" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2212px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel279" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2212px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel280" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2212px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel281" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 2226px"
				runat="server" DataMember="C10.7Podatek" Number="133" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel354" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 2226px"
				runat="server" DataMember="C10.8Podatek" Number="134" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel355" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 2226px"
				runat="server" DataMember="C10.9Podatek" Number="135" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel356" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 2226px"
				runat="server" DataMember="C10.10Podatek" Number="136" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel357" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 2226px"
				runat="server" DataMember="C10.11Podatek" Number="137" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel358" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 2226px"
				runat="server" DataMember="C10.12Podatek" Number="138" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel255" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 2275px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="11" VerticalAlign="Middle" Text=" Dochody członka pracowniczegu funduszu emerytalnego z tytułu przeniesienia akcji (art.30a ust.1 pkt 7 ustawy)">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel254" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 2303px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel335" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2303px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel312" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2303px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel313" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2303px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel314" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2303px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel315" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2303px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel316" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2303px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel317" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 2317px"
				runat="server" DataMember="C11.1Podatek" Number="139" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel318" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 2317px"
				runat="server" DataMember="C11.2Podatek" Number="140" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel319" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 2317px"
				runat="server" DataMember="C11.3Podatek" Number="141" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel320" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 2317px"
				runat="server" DataMember="C11.4Podatek" Number="142" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel321" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 2317px"
				runat="server" DataMember="C11.5Podatek" Number="143" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel322" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 2317px"
				runat="server" DataMember="C11.6Podatek" Number="144" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel323" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2359px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel324" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2359px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel325" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2359px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel326" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2359px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel327" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2359px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel328" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2359px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel329" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 2373px"
				runat="server" DataMember="C11.7Podatek" Number="145" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel378" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 2373px"
				runat="server" DataMember="C11.8Podatek" Number="146" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel379" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 2373px"
				runat="server" DataMember="C11.9Podatek" Number="147" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel380" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 2373px"
				runat="server" DataMember="C11.10Podatek" Number="148" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel381" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 2373px"
				runat="server" DataMember="C11.11Podatek" Number="149" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel382" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 2373px"
				runat="server" DataMember="C11.12Podatek" Number="150" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel253" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 2422px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="12" VerticalAlign="Middle" Text="Przychody z tytułu zbycia prawa poboru akcji (art.30a ust.1 pkt 8 ustawy)">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel88" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 2450px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel359" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2450px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel360" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2450px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel361" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2450px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel362" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2450px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel363" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2450px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel364" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2450px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel365" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 2464px"
				runat="server" DataMember="C12.1Podatek" Number="151" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel366" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 2464px"
				runat="server" DataMember="C12.2Podatek" Number="152" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel367" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 2464px"
				runat="server" DataMember="C12.3Podatek" Number="153" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel368" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 2464px"
				runat="server" DataMember="C12.4Podatek" Number="154" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel369" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 2464px"
				runat="server" DataMember="C12.5Podatek" Number="155" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel370" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 2464px"
				runat="server" DataMember="C12.6Podatek" Number="156" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel371" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2506px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel372" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2506px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel373" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2506px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel374" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2506px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel375" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2506px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel376" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2506px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel377" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 2520px"
				runat="server" DataMember="C12.7Podatek" Number="157" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel282" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 2520px"
				runat="server" DataMember="C12.8Podatek" Number="158" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel283" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 2520px"
				runat="server" DataMember="C12.9Podatek" Number="159" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel284" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 2520px"
				runat="server" DataMember="C12.10Podatek" Number="160" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel285" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 2520px"
				runat="server" DataMember="C12.11Podatek" Number="161" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel286" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 2520px"
				runat="server" DataMember="C12.12Podatek" Number="162" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel259" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 2569px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="13" VerticalAlign="Middle" Text="Inne należności niewymienione w wierszach 1-12">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel260" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 2597px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel383" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2597px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel408" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2597px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel409" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2597px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel410" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2597px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel411" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2597px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel412" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2597px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel346" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 2611px"
				runat="server" DataMember="C13.1Podatek" Number="163" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel347" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 2611px"
				runat="server" DataMember="C13.2Podatek" Number="164" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel348" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 2611px"
				runat="server" DataMember="C13.3Podatek" Number="165" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel349" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 2611px"
				runat="server" DataMember="C13.4Podatek" Number="166" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel350" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 2611px"
				runat="server" DataMember="C13.5Podatek" Number="167" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel351" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 2611px"
				runat="server" DataMember="C13.6Podatek" Number="168" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel352" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2653px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel353" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2653px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel431" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2653px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel432" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2653px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel433" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2653px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel434" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2653px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel435" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 2667px"
				runat="server" DataMember="C13.7Podatek" Number="169" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel436" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 2667px"
				runat="server" DataMember="C13.8Podatek" Number="170" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel437" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 2667px"
				runat="server" DataMember="C13.9Podatek" Number="171" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel438" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 2667px"
				runat="server" DataMember="C13.10Podatek" Number="172" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel439" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 2667px"
				runat="server" DataMember="C13.11Podatek" Number="173" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel440" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 2667px"
				runat="server" DataMember="C13.12Podatek" Number="174" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel338" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 2716px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="14" VerticalAlign="Middle" Text="Suma pobranego zryczałtowanego podatku za poszczególne miesiące z wierszy 1-13">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel339" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 2744px"
				runat="server" Height="119px" Width="147px" Text="Kwoty pobranego zryczałtowanego podatku"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel340" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2744px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel341" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2744px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel342" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2744px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel343" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2744px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel344" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2744px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel345" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2744px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel413" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 2758px"
				runat="server" DataMember="C14.1Podatek" Number="175" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel414" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 2758px"
				runat="server" DataMember="C14.2Podatek" Number="176" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel415" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 2758px"
				runat="server" DataMember="C14.3Podatek" Number="177" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel416" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 2758px"
				runat="server" DataMember="C14.4Podatek" Number="178" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel417" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 2758px"
				runat="server" DataMember="C14.5Podatek" Number="179" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel418" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 2758px"
				runat="server" DataMember="C14.6Podatek" Number="180" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel419" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2800px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel420" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2800px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel421" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2800px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel422" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2800px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel423" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2800px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel424" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2800px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel425" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 2814px"
				runat="server" DataMember="C14.7Podatek" Number="181" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel426" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 2814px"
				runat="server" DataMember="C14.8Podatek" Number="182" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel427" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 2814px"
				runat="server" DataMember="C14.9Podatek" Number="183" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel428" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 2814px"
				runat="server" DataMember="C14.10Podatek" Number="184" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel429" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 2814px"
				runat="server" DataMember="C14.11Podatek" Number="185" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel430" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 2814px"
				runat="server" DataMember="C14.12Podatek" Number="186" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:DeklaracjaFooter id="DeklaracjaFooter2" style="Z-INDEX: 172; LEFT: 532px; POSITION: absolute; TOP: 2883px"
				runat="server" Symbol="PIT-8AR" PageNumber="3" PageTotal="4" Version="2"></ea:DeklaracjaFooter>
<ea:DeklaracjaHeader id="DeklaracjaHeader4" 
                style="Z-INDEX: 153; LEFT: 0px; POSITION: absolute; TOP: 2947px" runat="server" 
                StylNagłówka="JasneCiemneElektronicznie"></ea:DeklaracjaHeader>
<ea:framelabel id="Framelabel261" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 2968px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="15" VerticalAlign="Middle" Text="Kwota potrąconego wynagrodzenia z tytułu terminowego wpłacenia podatku dochodowego - zgodnie z art.28 Ordynacji podatkowej">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel121" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 2996px"
				runat="server" Height="119px" Width="147px" Text="Kwoty wynagrodzenia"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel441" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 2996px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel442" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 2996px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel443" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 2996px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel444" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 2996px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel445" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 2996px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel446" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 2996px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel447" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 3010px"
				runat="server" DataMember="C15.1Wynagrodzenie" Number="187" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel448" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 3010px"
				runat="server" DataMember="C15.2Wynagrodzenie" Number="188" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel449" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 3010px"
				runat="server" DataMember="C15.3Wynagrodzenie" Number="189" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel450" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 3010px"
				runat="server" DataMember="C15.4Wynagrodzenie" Number="190" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel451" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 3010px"
				runat="server" DataMember="C15.5Wynagrodzenie" Number="191" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel452" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 3010px"
				runat="server" DataMember="C15.6Wynagrodzenie" Number="192" Height="42px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel453" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 3052px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel454" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 3052px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel455" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 3052px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel456" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 3052px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel457" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 3052px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel458" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 3052px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel459" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 3066px"
				runat="server" DataMember="C15.7Wynagrodzenie" Number="193" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel460" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 3066px"
				runat="server" DataMember="C15.8Wynagrodzenie" Number="194" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel461" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 3066px"
				runat="server" DataMember="C15.9Wynagrodzenie" Number="195" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel462" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 3066px"
				runat="server" DataMember="C15.10Wynagrodzenie" Number="196" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel463" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 3066px"
				runat="server" DataMember="C15.11Wynagrodzenie" Number="197" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel464" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 3066px"
				runat="server" DataMember="C15.12Wynagrodzenie" Number="198" Height="49px" Width="84px" ValueStyle="ForceZl">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel120" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 3115px"
				runat="server" Height="28px" Width="651px" FrameStyle="MiddleBoldYellow" Number="16" VerticalAlign="Middle" Text="Kwoty do wpłaty<br><.Normal>Od kwot za poszczególne miesiące z wiersza 14 należy odpowiednio odjąc kwoty z wiersza 15<./>">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel262" style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 3143px"
				runat="server" Height="119px" Width="147px" Text="Kwoty do wpłaty *)"
				FrameStyle="SmallBoldYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel407" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 3143px"
				runat="server" Height="14px" Width="84px" Text="I" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel384" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 3143px"
				runat="server" Height="14px" Width="84px" Text="II" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel385" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 3143px"
				runat="server" Height="14px" Width="84px" Text="III" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel386" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 3143px"
				runat="server" Height="14px" Width="84px" Text="IV" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel387" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 3143px"
				runat="server" Height="14px" Width="84px" Text="V" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel388" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 3143px"
				runat="server" Height="14px" Width="84px" Text="VI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel389" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 3157px"
				runat="server" DataMember="C16.1DoWpłaty" Number="199" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel390" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 3157px"
				runat="server" DataMember="C16.2DoWpłaty" Number="200" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel391" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 3157px"
				runat="server" DataMember="C16.3DoWpłaty" Number="201" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel392" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 3157px"
				runat="server" DataMember="C16.4DoWpłaty" Number="202" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel393" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 3157px"
				runat="server" DataMember="C16.5DoWpłaty" Number="203" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel394" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 3157px"
				runat="server" DataMember="C16.6DoWpłaty" Number="204" Height="42px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel395" style="Z-INDEX: 141; LEFT: 147px; POSITION: absolute; TOP: 3199px"
				runat="server" Height="14px" Width="84px" Text="VII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel396" style="Z-INDEX: 141; LEFT: 231px; POSITION: absolute; TOP: 3199px"
				runat="server" Height="14px" Width="84px" Text="VIII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel397" style="Z-INDEX: 141; LEFT: 315px; POSITION: absolute; TOP: 3199px"
				runat="server" Height="14px" Width="84px" Text="IX" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel398" style="Z-INDEX: 141; LEFT: 399px; POSITION: absolute; TOP: 3199px"
				runat="server" Height="14px" Width="84px" Text="X" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel399" style="Z-INDEX: 141; LEFT: 483px; POSITION: absolute; TOP: 3199px"
				runat="server" Height="14px" Width="84px" Text="XI" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel400" style="Z-INDEX: 141; LEFT: 567px; POSITION: absolute; TOP: 3199px"
				runat="server" Height="14px" Width="84px" Text="XII" FrameStyle="SmallYellow" HorizontalAlign="Center" VerticalAlign="Middle">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel401" style="Z-INDEX: 145; LEFT: 147px; POSITION: absolute; TOP: 3213px"
				runat="server" DataMember="C16.7DoWpłaty" Number="205" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel402" style="Z-INDEX: 145; LEFT: 231px; POSITION: absolute; TOP: 3213px"
				runat="server" DataMember="C16.8DoWpłaty" Number="206" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel403" style="Z-INDEX: 145; LEFT: 315px; POSITION: absolute; TOP: 3213px"
				runat="server" DataMember="C16.9DoWpłaty" Number="207" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel404" style="Z-INDEX: 145; LEFT: 399px; POSITION: absolute; TOP: 3213px"
				runat="server" DataMember="C16.10DoWpłaty" Number="208" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel405" style="Z-INDEX: 145; LEFT: 483px; POSITION: absolute; TOP: 3213px"
				runat="server" DataMember="C16.11DoWpłaty" Number="209" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:framelabel id="Framelabel406" style="Z-INDEX: 145; LEFT: 567px; POSITION: absolute; TOP: 3213px"
				runat="server" DataMember="C16.12DoWpłaty" Number="210" Height="49px" Width="84px" ValueStyle="ZlGr">
            </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel122" style="Z-INDEX: 156; LEFT: 0px; POSITION: absolute; TOP: 3262px"
				runat="server" Text="D. OŚWIADCZENIE I PODPIS PŁATNIKA LUB OSOBY WYZNACZONEJ DO OBLICZENIA I POBRANIA PODATKU / PEŁNOMOCNIKA PŁATNIKA|&lt;.Footer&gt;Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za uchybienie obowiązkom płatnika&lt;./&gt;"
				Width="651px" Height="119px" FrameStyle="BigYellowBold" 
                FrameBorderStyle="DoubleHeader"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel123" style="Z-INDEX: 157; LEFT: 28px; POSITION: absolute; TOP: 3325px"
				runat="server" Text="Imię" Width="210px" Height="58px" Number="211" DataMember="D.Imię"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel125" style="Z-INDEX: 158; LEFT: 238px; POSITION: absolute; TOP: 3325px"
				runat="server" Text="Nazwisko" Width="210px" Height="58px" Number="212" DataMember="D.Nazwisko"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel126" style="Z-INDEX: 159; LEFT: 448px; POSITION: absolute; TOP: 3325px"
				runat="server" Text="Podpis i pieczątka"
				Width="203px" Height="57px" Number="213"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel127" style="Z-INDEX: 160; LEFT: 0px; POSITION: absolute; TOP: 3381px"
				runat="server" Text="E. ADNOTACJE URZĘDU SKARBOWEGO" Width="651px" Height="126px" FrameStyle="BigYellowBold"
				FrameBorderStyle="DoubleHeader"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel130" style="Z-INDEX: 161; LEFT: 28px; POSITION: absolute; TOP: 3409px"
				runat="server" Text="Uwagi urzędu skarbowego" Width="623px" Height="70px" Number="214" FrameStyle="SmallBoldGray"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel128" style="Z-INDEX: 162; LEFT: 28px; POSITION: absolute; TOP: 3479px"
				runat="server" Text="Identyfikator przyjmującego formularz" Width="315px" Height="29px" Number="215"
				FrameStyle="SmallBoldGray"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel129" style="Z-INDEX: 163; LEFT: 343px; POSITION: absolute; TOP: 3479px"
				runat="server" Text="Podpis przyjmującego formularz" Width="308px" Height="29px" Number="216"
				FrameStyle="SmallBoldGray"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel465" style="Z-INDEX: 169; LEFT: 0px; POSITION: absolute; TOP: 3521px"
				runat="server" Text="&lt;.INDEXUP&gt;1)&lt;./&gt; Ilekroć w deklaracji jest mowa o urzędzie skarbowym - oznacza to urząd skarbowy, którym kieruje właściwy dla płatnika naczelnik urzędu skarbowego."
				Width="651px" Height="14px" FrameBorderStyle="None" FrameStyle="Small">
            </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel466" style="Z-INDEX: 169; LEFT: 0px; POSITION: absolute; TOP: 3542px"
				runat="server" Text="&lt;.INDEXUP&gt;2)&lt;./&gt; Zgodnie z art.81 Ordynacji podatkowej płatnik może skorygować złożoną deklarację przez złożenie deklaracji korygującej wraz z dołączonym pisemnym uzasadnieniem przyczyn korekty."
				Width="651px" Height="19px" FrameBorderStyle="None" FrameStyle="Small">
            </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel134" style="Z-INDEX: 170; LEFT: 0px; POSITION: absolute; TOP: 3577px"
				runat="server" Text="*) Pouczenie" Width="651px" Height="5px" HorizontalAlign="Center" FrameBorderStyle="None"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel135" style="Z-INDEX: 171; LEFT: 0px; POSITION: absolute; TOP: 3598px"
				runat="server" Text="W przypadku niewpłacenia w obowiązującym terminie kwoty z poz.199 do 210 lub wpłacenia ich w niepełnej wysokości niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz.U. z 2005 r. Nr 229, poz. 1954, późn.zm.)."
				Width="651px" Height="21px" FrameStyle="Small" FrameBorderStyle="None"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel131" style="Z-INDEX: 164; LEFT: 0px; POSITION: absolute; TOP: 3633px"
				runat="server" Text="Objaśnienia" Width="651px" Height="5px" HorizontalAlign="Center" FrameBorderStyle="None"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel136" style="Z-INDEX: 169; LEFT: 0px; POSITION: absolute; TOP: 3654px"
				runat="server" Text="1. Deklarację wypełniają płatnicy określeni w art.41 ustawy, jeżeli są obowiązani pobierać zryczałtowany podatek dochodowy od dokonywanych wypłat (świadczeń) lub stawianych do dyspozycji podatnika pieniędzy lub wartości pieniężnych, oraz spółdzielnie pobierające zryczałtowany podatek dochodowy stosownie do postanowień art.18 ustawy z dnia 12 listopada 2003 r. o zmiane ustawy o podatku dochodowym od osób fizycznych oraz niektórych innych ustaw (Dz.U. Nr 202, poz. 1956, z późn. zm.)."
				Width="651px" Height="35px" FrameBorderStyle="None" FrameStyle="Small">
            </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel52" style="Z-INDEX: 169; LEFT: 0px; POSITION: absolute; TOP: 3696px"
				runat="server" Text="2. Kwoty zryczałtowanego podatku wykazywanego w wierszach 5-9 i 13 należy obliczać z uwzględnieniem postanowień umów o unikaniu podwójnego opodatkowania."
				Width="651px" Height="14px" FrameBorderStyle="None" FrameStyle="Small"></ea:FrameLabel>
<ea:FrameLabel id="FrameLabel467" style="Z-INDEX: 169; LEFT: 0px; POSITION: absolute; TOP: 3717px"
				runat="server" Text="3. Kwoty podatku i wynagrodzenia przysługującego płatnikom z tytułu terminowego wpłacenia podatku dochodowego zaokrągla się zgodnie z art. 63 Ordynacji podatkowej."
				Width="651px" Height="19px" FrameBorderStyle="None" FrameStyle="Small">
                </ea:FrameLabel>
<ea:FrameLabel id="FrameLabel468" style="Z-INDEX: 169; LEFT: 0px; POSITION: absolute; TOP: 3745px"
				runat="server" Text="4. Ilekroć w deklaracji jest mowa o Ordynacji podatkowej - oznacza to ustawę z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz.U. z 2005 r. Nr 8, poz.60, z późn.zm.)"
				Width="651px" Height="14px" FrameBorderStyle="None" FrameStyle="Small">
            </ea:FrameLabel>
<ea:DeklaracjaFooter id="DeklaracjaFooter4" style="Z-INDEX: 172; LEFT: 0px; POSITION: absolute; TOP: 3850px"
				runat="server" Symbol="PIT-8AR" PageNumber="4" PageTotal="4" Version="2"></ea:DeklaracjaFooter>
<ea:datacontext id="dc" LeftMargin="13" PageZoom="106.74%" PageHeight="977px" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT8AR_2,Soneta.Deklaracje"
				style="Z-INDEX: 173; LEFT: 189px; POSITION: absolute; TOP: 3887px" OnContextLoad="dc_ContextLoad"></ea:datacontext>
</form>
	</body>
</HTML>
