﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="65001" %>
<%@ import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.Xml" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<HTML>

<HEAD>
    <title>PIT-8C (10)</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
    <script runat="server">
        void OnContextLoad(object sender, EventArgs e) {
            PIT pit = (PIT)dc[typeof (PIT)];
            if (pit as PIT8C_10 == null)
                throw new InvalidOperationException("Wydruk PIT-8C (10) może być drukowany wyłącznie dla deklaracji PIT-8C w wersji 8.");
            if (!dc.OverPrint) {
                string upo = (pit.Deklaracja ?? pit).GetNumerUpo();
                if (upo != "") {
                    Resize(FrameNIPPlatnika, -64, 0);
                    Move(FrameNrDokumentu, 0, -64);
                    Resize(FrameNrDokumentu, 64, 0);
                    FrameNrDokumentu.EditValue = upo;
                }
            }
            else {
                dc.LeftMargin = 6;
                dc.TopMargin = 6;
                dc.PageZoom = "114%";
            }
            if (((PIT8C_10)pit).JestPESEL) {
                flPeselNip.Text = "<strike>Identyfikator podatkowy NIP</strike>/numer PESEL <.Indexup><small>(niepotrzebne skreślić)</small>";
                flPeselNip.ValueStyle = ValueStyles.WideText;
            }
        else {
                flPeselNip.Text = "Identyfikator podatkowy NIP/<strike>Numer PESEL</strike> <.Indexup><small>(niepotrzebne skreślić)</small>";
                flPeselNip.ValueStyle = ValueStyles.nip_w;
            }
        }

        void Resize(WebControl fl, int dwidth, int dheight) {
            if (dwidth != 0)
                fl.Style["width"] = (ParsePx(fl.Style["width"]) + dwidth) + "px";
            if (dheight != 0)
                fl.Style["height"] = (ParsePx(fl.Style["height"]) + dheight) + "px";
        }

        void Move(WebControl fl, int dtop, int dleft) {
            if (dtop != 0)
                fl.Style["TOP"] = (ParsePx(fl.Style["TOP"]) + dtop) + "px";
            if (dleft != 0)
                fl.Style["LEFT"] = (ParsePx(fl.Style["LEFT"]) + dleft) + "px";
        }

        int ParsePx(string px) {
            return int.Parse(px.Substring(0, px.Length - 2));
        }
    </script>
</HEAD>

<body leftMargin="0" rightMargin="0">
    <form id="PIT_8C_" method="post" runat="server">
        <ea:deklaracjaheader id="DeklaracjaHeader1" style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 0px"
            runat="server" Width="630px" StylNagłówka="PolaJasneWypelniaPlatnik"></ea:deklaracjaheader>
        <ea:framelabel id="FrameNIPPlatnika"
            style="Z-INDEX: 101; LEFT: 0px; POSITION: absolute; TOP: 21px; width: 338px;" runat="server"
            ValueStyle="nip_w" DataMember="0.Nip" Height="28px"
            Text="1. Identyfikator podatkowy NIP podmiotu obowiązanego do składania informacji"></ea:framelabel>
        <ea:framelabel id="FrameNrDokumentu"
            style="Z-INDEX: 102; LEFT: 337px; POSITION: absolute; TOP: 21px; width: 193px;" runat="server" Height="28px"
            Text="Nr dokumentu" FrameStyle="SmallBoldGray" Number="2"></ea:framelabel>
        <ea:framelabel id="FrameLabel23" style="Z-INDEX: 103; LEFT: 531px; POSITION: absolute; TOP: 21px; width: 97px;"
            runat="server" Height="30px" Text="Status" FrameStyle="SmallBoldGray" Number="3"></ea:framelabel>
        <ea:framelabel id="labelPIT" style="Z-INDEX: 104; LEFT: 0px; POSITION: absolute; TOP: 49px" runat="server"
            Width="119px" Height="21px" FrameStyle="BigBold" FrameBorderStyle="None" Text="PIT-8C"></ea:framelabel>
        <ea:framelabel id="FrameLabel34" style="Z-INDEX: 105; LEFT: 0px; POSITION: absolute; TOP: 63px; width: 630px;"
            runat="server" Height="35px"
            Text="INFORMACJA O NIEKTÓRYCH DOCHODACH Z KAPITAŁÓW PIENIĘŻNYCH"
            FrameStyle="BigBold" FrameBorderStyle="None" HorizontalAlign="Center"></ea:framelabel>
        <ea:framelabel id="FrameLabel19" style="Z-INDEX: 106; LEFT: 304px; POSITION: absolute; TOP: 99px; width: 150px;"
            runat="server" ValueStyle="n4" DataMember="0.Rok" Height="28px" Text="4. Rok"></ea:framelabel>
        <ea:framelabel id="FrameLabel29"
            style="Z-INDEX: 108; LEFT: 207px; POSITION: absolute; TOP: 106px; right: 782px;" runat="server" Width="70px"
            Height="17px" Text="W ROKU" FrameStyle="BigBold" FrameBorderStyle="None"></ea:framelabel>
        <ea:framelabel id="FrameLabel24" style="Z-INDEX: 109; LEFT: 0px; POSITION: absolute; TOP: 132px; height: 96px;"
            runat="server" Width="630px" FrameStyle="SmallBoldYellow" FrameBorderStyle="DoubleBottom"></ea:framelabel>
        <ea:framelabel id="FrameLabel25" style="Z-INDEX: 110; LEFT: 7px; POSITION: absolute; TOP: 134px" runat="server"
            Width="91px" Height="7px" Text="Podstawa prawna:" FrameStyle="SmallYellow" FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel26" style="Z-INDEX: 111; LEFT: 133px; POSITION: absolute; TOP: 134px"
            runat="server" Width="490px" Height="28px"
            Text='Art. 39 ust. 3 ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych (Dz. U. z 2019 r. poz. 1387, z późn. zm.), zwanej dalej „ustawą”. '
            FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
        <ea:framelabel id="FrameLabel28"
            style="Z-INDEX: 113; LEFT: 133px; POSITION: absolute; TOP: 152px; height: 19px;" runat="server"
            Width="490px"
            Text="Oosoba fizyczna prowadząca działalność gospodarczą, osoba prawna i jej jednostka organizacyjna oraz jednostka organizacyjna niemająca osobowości prawnej."
            FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
        <ea:framelabel id="FrameLabel27" style="Z-INDEX: 112; LEFT: 7px; POSITION: absolute; TOP: 152px" runat="server"
            Width="91px" Height="9px" Text="Składający:" FrameStyle="SmallYellow" FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel30" style="Z-INDEX: 114; LEFT: 7px; POSITION: absolute; TOP: 172px" runat="server"
            Width="91px" Height="7px" Text="Termin składania:" FrameStyle="SmallYellow" FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel31"
            style="Z-INDEX: 115; LEFT: 133px; POSITION: absolute; TOP: 172px; height: 38px;" runat="server"
            Width="490px"
            Text="Do końca stycznia roku następującego po roku podatkowym - dla informacji składanych urzędowi skarbowemu; do końca lutego roku następującego po roku podatkowym - dla informacji przesyłanych podatnikowi; do dnia zaprzestania działalności - w przypadku gdy składający zaprzestali działalności przed końcem stycznia lub odpowiednio przed końcem lutego następującego po roku podatkowym."
            FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
        <ea:framelabel id="FrameLabel33"
            style="Z-INDEX: 117; LEFT: 133px; POSITION: absolute; TOP: 201px; height: 18px;" runat="server"
            Width="490px"
            Text="Podatnik oraz urząd skarbowy według miejsca zamieszkania podatnika,  a w przypadku podatnika, o którym mowa w art. 3 ust. 2a ustawy, urząd skarbowy w sprawach opodatkowania osób zagranicznych."
            FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
        <ea:framelabel id="FrameLabel32" style="Z-INDEX: 116; LEFT: 7px; POSITION: absolute; TOP: 200px" runat="server"
            Width="91px" Height="7px" Text="Otrzymuje:" FrameStyle="SmallYellow" FrameBorderStyle="None">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel17" style="Z-INDEX: 118; LEFT: 0px; POSITION: absolute; TOP: 231px; height: 93px;"
            runat="server" Width="630px" Text="A. MIEJSCE I CEL SKŁADANIA INFORMACJI" FrameStyle="BigYellowBold"
            FrameBorderStyle="DoubleBottom"></ea:framelabel>
        <ea:framelabel id="FrameLabel18" style="Z-INDEX: 119; LEFT: 28px; POSITION: absolute; TOP: 259px" runat="server"
            Width="602px" DataMember="A.UrzadSkarb" Height="28px"
            Text="Urząd skarbowy, do którego adresowana jest informacja<.INDEXUP>1)<./>" Number="5"></ea:framelabel>
        <ea:framelabel id="Framelabel77" style="Z-INDEX: 123; LEFT: 28px; POSITION: absolute; TOP: 287px" runat="server"
            Width="602px" Height="28px"
            Text="Cel złożenia formularza &lt;.Normal&gt;(zaznaczyć właściwy kwadrat):&lt;./&gt;" Number="6">
        </ea:FrameLabel>
        <ea:checklabel id="Checklabel9" style="Z-INDEX: 127; LEFT: 358px; POSITION: absolute; TOP: 292px" runat="server"
            Width="133px" DataMember="A.Korekta" Height="14px" Text="korekta informacji 2)" Number="2"
            NumberAlignLeft="False"></ea:checklabel>
        <ea:checklabel id="Checklabel10"
            style="Z-INDEX: 257; LEFT: 219px; POSITION: absolute; TOP: 293px; right: 469px;" runat="server"
            Width="136px" DataMember="A.Korekta" Height="14px" Text="złożenie informacji" Number="1"
            NumberAlignLeft="False" ComparedValue="False">
        </ea:CheckLabel>
        <ea:framelabel id="FrameLabel1" style="Z-INDEX: 120; LEFT: 0px; POSITION: absolute; TOP: 322px" runat="server"
            Width="630px" Height="126px"
            Text="B. DANE IDENTYFIKACYJNE SKŁADAJĄCEGO&lt;br&gt;&lt;.Footer&gt;* - dotyczy składającego niebędącego osobą fizyczną ** - dotyczy składającego będącego osobą fizyczną&lt;./&gt;"
            FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom"></ea:framelabel>
        <ea:framelabel id="FrameLabel3" style="Z-INDEX: 122; LEFT: 28px; POSITION: absolute; TOP: 357px" runat="server"
            Width="602px" Height="28px"
            Text="Rodzaj składającego &lt;.Normal&gt;(zaznaczyć właściwy kwadrat):&lt;./&gt;" Number="7">
        </ea:framelabel>
        <ea:checklabel id="CheckLabel1" style="Z-INDEX: 124; LEFT: 132px; POSITION: absolute; TOP: 364px" runat="server"
            Width="200px" DataMember="B1.OsobaFiz" Height="14px" Text="składający niebędący osobą fizyczną" Number="1"
            NumberAlignLeft="False" ComparedValue="False">
        </ea:CheckLabel>
        <ea:checklabel id="CheckLabel2" style="Z-INDEX: 126; LEFT: 423px; POSITION: absolute; TOP: 364px" runat="server"
            Width="133px" DataMember="B1.OsobaFiz" Height="14px" Text="osoba fizyczna" Number="2"
            NumberAlignLeft="False">
        </ea:CheckLabel>
        <ea:framelabel id="FrameLabel4" style="Z-INDEX: 128; LEFT: 28px; POSITION: absolute; TOP: 385px; height: 25px;"
            runat="server" Width="602px" DataMember="NazwaFirma" SmallerFontLength="70" Text="Nazwa pełna *"
            Number="8"></ea:framelabel>
        <ea:framelabel id="FrameLabel36" style="Z-INDEX: 128; LEFT: 28px; POSITION: absolute; TOP: 413px; height: 25px;"
            runat="server" Width="602px" DataMember="NazwaOsobaFizycza"
            Text="Nazwisko, pierwsze imię, data urodzenia **" Number="9"></ea:framelabel>
        <ea:framelabel id="Framelabel41" style="Z-INDEX: 140; LEFT: 0px; POSITION: absolute; TOP: 448px" runat="server"
            Width="630px" Height="168px" Text="C. DANE IDENTYFIKACYJNE I ADRES ZAMIESZKANIA PODATNIKA"
            FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom"></ea:framelabel>
        <ea:framelabel id="flPeselNip"
            style="Z-INDEX: 142; LEFT: 28px; POSITION: absolute; TOP: 469px; right: 801px; width: 599px;" runat="server"
            DataMember="IdentyfikatorPodatnika" Height="28px"
            Text="Identyfikator podatkowy NIP/Numer PESEL ;.Indexup&gt;(niepotrzebne skreślić)" Number="10">
        </ea:framelabel>
        <ea:framelabel id="Framelabel103"
            style="Z-INDEX: 143; LEFT: 28px; POSITION: absolute; TOP: 497px; width: 237px;" SmallerFontLength="20"
            runat="server" DataMember="C1.Nazwisko" Height="28px" Text="Nazwisko" Number="11"></ea:framelabel>
        <ea:framelabel id="Framelabel104"
            style="Z-INDEX: 144; LEFT: 266px; POSITION: absolute; TOP: 497px; width: 192px;" runat="server"
            DataMember="C1.Imię" Height="28px" Text="Pierwsze imię" Number="12"></ea:framelabel>
        <ea:framelabel id="Framelabel105"
            style="Z-INDEX: 145; LEFT: 455px; POSITION: absolute; TOP: 497px; width: 174px;" runat="server"
            ValueStyle="Date" DataMember="C1.DataUrodz" Height="28px" Text="Data urodzenia" Number="13"></ea:framelabel>
        <ea:framelabel id="Framelabel106"
            style="Z-INDEX: 147; LEFT: 28px; POSITION: absolute; TOP: 525px; right: 871px;" runat="server" Width="140px"
            DataMember="C2.Kraj" Height="28px" Text="Kraj" Number="14"></ea:framelabel>
        <ea:framelabel id="Framelabel107" style="Z-INDEX: 148; LEFT: 168px; POSITION: absolute; TOP: 525px"
            runat="server" Width="266px" DataMember="C2.Wojew" Height="28px" Text="Województwo" Number="15">
        </ea:framelabel>
        <ea:framelabel id="Framelabel108" style="Z-INDEX: 149; LEFT: 434px; POSITION: absolute; TOP: 525px"
            runat="server" Width="196px" DataMember="C2.Powiat" Height="28px" Text="Powiat" Number="16"></ea:framelabel>
        <ea:framelabel id="Framelabel109" style="Z-INDEX: 150; LEFT: 28px; POSITION: absolute; TOP: 553px"
            SmallerFontLength="16" runat="server" Width="161px" DataMember="C2.Gmina" Height="28px" Text="Gmina"
            Number="17"></ea:framelabel>
        <ea:framelabel id="Framelabel110" style="Z-INDEX: 151; LEFT: 189px; POSITION: absolute; TOP: 553px"
            runat="server" Width="301px" DataMember="C2.Ulica" Height="28px" Text="Ulica" Number="18"></ea:framelabel>
        <ea:framelabel id="Framelabel111" style="Z-INDEX: 152; LEFT: 490px; POSITION: absolute; TOP: 553px"
            SmallerFontLength="6" runat="server" Width="70px" DataMember="C2.NrDomu" Height="28px" Text="Nr domu"
            Number="19"></ea:framelabel>
        <ea:framelabel id="Framelabel112" style="Z-INDEX: 153; LEFT: 560px; POSITION: absolute; TOP: 553px"
            runat="server" Width="70px" DataMember="C2.NrLokalu" Height="28px" Text="Nr lokalu" Number="20">
        </ea:framelabel>
        <ea:framelabel id="Framelabel113" style="Z-INDEX: 154; LEFT: 28px; POSITION: absolute; TOP: 581px"
            runat="server" Width="420px" DataMember="C2.Miejsc" Height="28px" Text="Miejscowość" Number="21">
        </ea:framelabel>
        <ea:framelabel id="Framelabel114" style="Z-INDEX: 155; LEFT: 434px; POSITION: absolute; TOP: 581px"
            runat="server" Width="196px" ValueStyle="PostalCode" DataMember="C2.KodPoczt" Height="28px"
            Text="Kod pocztowy" Number="22"></ea:framelabel>
        <ea:framelabel id="FrameLabel20"
            style="Z-INDEX: 166; LEFT: 0px; POSITION: absolute; TOP: 615px; height: 289px;" runat="server"
            Width="630px"
            Text="D. &lt;font STYLE='font-size: 10pt;'&gt;INFORMACJA O WYSOKOŚCI DOCHODÓW, O KTÓRYCH MOWA W ART. 30b UST. 2 USTAWY&lt;./&gt;"
            FrameStyle="BigYellowBold" 
            FrameBorderStyle="DoubleBottom">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel152" 
            style="Z-INDEX: 167; LEFT: 28px; POSITION: absolute; TOP: 645px"
            runat="server" 
            Width="217px" 
            Height="25px" 
            Text="Rodzaje przychodów" 
            FrameStyle="SmallBoldYellow"
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel159" style="Z-INDEX: 168; LEFT: 245px; POSITION: absolute; TOP: 645px"
            runat="server" Width="98px" ValueStyle="ZlGr" Height="25px" Text="Przychód" FrameStyle="SmallBoldYellow"
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel160" style="Z-INDEX: 169; LEFT: 343px; POSITION: absolute; TOP: 645px"
            runat="server" Width="84px" ValueStyle="ZlGr" Height="25px" Text="Koszty uzyskania&lt;br&gt;przychodu"
            FrameStyle="SmallBoldYellow" HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel161"
            style="Z-INDEX: 170; LEFT: 427px; POSITION: absolute; TOP: 645px; right: 339px;" runat="server"
            Width="105px" Height="25px" Text="Dochód<br>(b-c)" FrameStyle="SmallBoldYellow" HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel153" style="Z-INDEX: 171; LEFT: 532px; POSITION: absolute; TOP: 645px"
            runat="server" Width="99px" Height="25px" Text="Strata&lt;br&gt; (c - b)" FrameStyle="SmallBoldYellow"
            HorizontalAlign="Center">
        </ea:framelabel>

        <ea:framelabel id="FrameLabel38" style="Z-INDEX: 172; LEFT: 28px; POSITION: absolute; TOP: 673px"
            runat="server" Width="217px" Height="12px" Text="<.Normal>a" FrameStyle="SmallBoldYellow"
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel44" style="Z-INDEX: 173; LEFT: 245px; POSITION: absolute; TOP: 673px"
            runat="server" Width="98px" Height="12px" Text="<.Normal>b" FrameStyle="SmallBoldYellow"
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel45" style="Z-INDEX: 174; LEFT: 343px; POSITION: absolute; TOP: 673px"
            runat="server" Width="84px" Height="12px" Text="<.Normal>c" FrameStyle="SmallBoldYellow"
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel148" style="Z-INDEX: 175; LEFT: 427px; POSITION: absolute; TOP: 673px"
            runat="server" Width="105px" Height="12px" Text="<.Normal>d" FrameStyle="SmallBoldYellow"
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel166" style="Z-INDEX: 176; LEFT: 532px; POSITION: absolute; TOP: 673px"
            runat="server" Width="99px" Height="12px" Text="<.Normal>e" FrameStyle="SmallBoldYellow"
            HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel158"
            style="Z-INDEX: 200; LEFT: 28px; POSITION: absolute; TOP: 687px; height: 29px; right: 794px;"
            runat="server" Width="217px" Text="Odpłatne zbycie papierów wartościowych" FrameStyle="SmallBoldYellow"
            Number="1" HorizontalAlign="Left">
        </ea:framelabel>
        <ea:framelabel id="Framelabel149"
            style="Z-INDEX: 202; LEFT: 245px; POSITION: absolute; TOP: 687px; width: 97px;" runat="server"
            ValueStyle="ZlGr" DataMember="D.1Przychód" Height="30px" Number="23">
        </ea:framelabel>
        <ea:framelabel id="Framelabel151"
            style="Z-INDEX: 202; LEFT: 343px; POSITION: absolute; TOP: 687px; bottom: 188px;" runat="server"
            Width="84px" ValueStyle="ZlGr" DataMember="D.1Koszty" Height="30px" Number="24">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel46"
            style="Z-INDEX: 175; LEFT: 427px; POSITION: absolute; TOP: 687px; height: 167px;" runat="server"
            Width="105px" FrameStyle="SmallBoldYellow" HorizontalAlign="Center">
        </ea:framelabel>
        <ea:framelabel id="FrameLabel68" style="Z-INDEX: 205; LEFT: 28px; POSITION: absolute; TOP: 715px"
            runat="server" Width="217px" Height="26px" Text="Realizacja praw wynikających z papierów wartościowych"
            FrameStyle="SmallBoldYellow" Number="2" HorizontalAlign="Left"></ea:framelabel>
        <ea:framelabel id="Framelabel150"
            style="Z-INDEX: 202; LEFT: 245px; POSITION: absolute; TOP: 715px; width: 97px;" runat="server"
            ValueStyle="ZlGr" DataMember="D.2Przychód" Height="30px" Number="25" CssClass="style1"></ea:framelabel>
        <ea:framelabel id="Framelabel100" style="Z-INDEX: 202; LEFT: 343px; POSITION: absolute; TOP: 715px"
            runat="server" Width="84px" ValueStyle="ZlGr" DataMember="D.2Koszty" Height="30px" Number="26"></ea:framelabel>
            <ea:framelabel id="FrameLabel126" style="Z-INDEX: 210; LEFT: 28px; POSITION: absolute; TOP: 743px"
            runat="server" Width="217px" Height="26px"
            Text="Odpłatne zbycie pochodnych instrumentów finansowych oraz realizacja praw z nich wynikających"
            FrameStyle="SmallBoldYellow" Number="3" HorizontalAlign="Left"></ea:framelabel>
        <ea:framelabel id="Framelabel98" style="Z-INDEX: 206; LEFT: 245px; POSITION: absolute; TOP: 743px"
            runat="server" Width="99px" ValueStyle="ZlGr" DataMember="D.3Przychód" Height="28px" Number="27" CssClass="style1">
        </ea:framelabel>
        <ea:framelabel id="Framelabel80" style="Z-INDEX: 207; LEFT: 343px; POSITION: absolute; TOP: 743px"
            runat="server" Width="84px" ValueStyle="ZlGr" DataMember="D.3Koszty" Height="28px" Number="28"></ea:framelabel>
        <ea:framelabel id="FrameLabel134" style="Z-INDEX: 215; LEFT: 28px; POSITION: absolute; TOP: 771px"
            runat="server" Width="217px" Height="26px"
            Text="Odpłatne zbycie niebędących papierami wartościowymi udziałów (akcji)"
            FrameStyle="SmallBoldYellow" Number="4" HorizontalAlign="Left"></ea:framelabel>
        <ea:framelabel id="Framelabel135" style="Z-INDEX: 211; LEFT: 245px; POSITION: absolute; TOP: 771px"
            runat="server" Width="99px" ValueStyle="ZlGr" DataMember="D.4Przychód" Height="28px" Number="29" CssClass="style1">
        </ea:framelabel>
        <ea:framelabel id="Framelabel139" style="Z-INDEX: 212; LEFT: 343px; POSITION: absolute; TOP: 771px"
            runat="server" Width="84px" ValueStyle="ZlGr" DataMember="D.4Koszty" Height="28px" Number="30"></ea:framelabel>
        <ea:framelabel id="FrameLabel69"
            style="Z-INDEX: 220; LEFT: 28px; POSITION: absolute; TOP: 799px; width: 218px; height: 53px;"
            runat="server"
            Text="Objęcie udziałów (akcji) w spółkach albo wkładów w spółdzielniach w zamian za wkład niepieniężny w innej postaci niż przedsiębiorstwo lub jego zorganizowana część"
            FrameStyle="SmallBoldYellow" Number="5" HorizontalAlign="Left"></ea:framelabel>
        <ea:framelabel id="Framelabel138"
            style="Z-INDEX: 216; LEFT: 245px; POSITION: absolute; TOP: 799px; height: 57px;" runat="server"
            Width="99px" ValueStyle="ZlGr" DataMember="D.5Przychód" Number="31"></ea:framelabel>
        <ea:framelabel id="Framelabel82"
            style="Z-INDEX: 222; LEFT: 343px; POSITION: absolute; TOP: 799px; height: 55px;" runat="server"
            Width="84px" ValueStyle="ZlGr" DataMember="D.5Koszty" Number="32">
        </ea:FrameLabel>
        <ea:framelabel id="Framelabel71" style="Z-INDEX: 220; LEFT: 28px; POSITION: absolute; TOP: 855px"
            runat="server" Width="217px" Height="26px"
            Text="Razem&lt;br&gt;&lt;br&gt;<.Normal>Suma kwot z wierszy od 1 do 5." FrameStyle="SmallBoldYellow"
            HorizontalAlign="Left" CssClass="style1">
        </ea:FrameLabel>
        <ea:framelabel id="Framelabel167" style="Z-INDEX: 221; LEFT: 245px; POSITION: absolute; TOP: 855px"
            runat="server" Width="98px" ValueStyle="ZlGr" DataMember="D.Przychód" Height="28px" Number="33">
        </ea:FrameLabel>
        <ea:framelabel id="Framelabel168" style="Z-INDEX: 222; LEFT: 343px; POSITION: absolute; TOP: 855px; "
            runat="server" Width="84px" ValueStyle="ZlGr" DataMember="D.Koszty" Height="28px" Number="34" CssClass="style1">
        </ea:FrameLabel>
        <ea:framelabel id="Framelabel145"
            style="Z-INDEX: 223; LEFT: 427px; POSITION: absolute; TOP: 855px; right: 507px;" runat="server"
            Width="105px" ValueStyle="ForceZlGr" DataMember="D.Dochód" Height="28px" Number="35">
        </ea:FrameLabel>
        <ea:framelabel id="Framelabel146" style="Z-INDEX: 224; LEFT: 532px; POSITION: absolute; TOP: 855px"
            runat="server" Width="99px" ValueStyle="ForceZlGr" DataMember="D.Strata" Height="28px" Number="36"></ea:framelabel>


        <ea:deklaracjafooter id="footer1" style="Z-INDEX: 163; LEFT: 490px; POSITION: absolute; TOP: 950px"
            runat="server" Width="154px" Height="10px" TitleWidth="106" Symbol="PIT-8C" PageNumber="1" PageTotal="2"
            Version="10"></ea:deklaracjafooter>
        <ea:deklaracjaheader id="DeklaracjaHeader2" style="Z-INDEX: 165; LEFT: 0px; POSITION: absolute; TOP: 980px"
            runat="server" Width="630px" StylNagłówka="PolaJasneWypelniaPlatnik"></ea:deklaracjaheader>

        <ea:framelabel id="Framelabel121"
            style="Z-INDEX: 233; LEFT: 0px; POSITION: absolute; TOP: 1000; height: 57px;" runat="server" Width="630px"
            Text="E. &lt;font STYLE='font-size: 10pt;'&gt;INFORMACJA O WYSOKOŚCI PRZYCHODÓW NIEWYKAZYWANYCH W CZĘŚCI D&lt;.INDEXUP&gt;3)&lt;./&gt;&lt;/font&gt;"
            FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom">
        </ea:framelabel>


        <ea:framelabel id="FrameLabel58"
            style="Z-INDEX: 235; LEFT: 28px; POSITION: absolute; TOP: 1021px; right: 470px;" runat="server"
            Width="399px" Height="28px" Text="Przychód z odpłatnego zbycia papierów wartościowych"
            FrameStyle="SmallBoldYellow" HorizontalAlign="Left"></ea:framelabel>
        <ea:framelabel id="Framelabel78" style="Z-INDEX: 234; LEFT: 427px; POSITION: absolute; TOP: 1021px"
            runat="server" Width="203px" ValueStyle="ForceZlGr" DataMember="E.Przychód" Height="28px" Number="37"></ea:framelabel>

        <ea:framelabel id="FrameLabel122"
            style="Z-INDEX: 241; LEFT: 0px; POSITION: absolute; TOP: 1056px; height: 80px;" runat="server" Width="630px"
            Text="F. &lt;font STYLE='font-size: 10pt;'&gt;PODPIS OSOBY UPOWAŻNIONEJ DO SPORZĄDZENIA INFORMACJI&lt;/font&gt;&lt;.INDEXUP&gt;4)&lt;./&gt;&lt;/font&gt;"
            FrameStyle="BigYellowBold" FrameBorderStyle="DoubleBottom"></ea:framelabel>

        <ea:framelabel id="FrameLabel123"
            style="Z-INDEX: 242; LEFT: 28px; POSITION: absolute; TOP: 1075px; height: 46px;" runat="server"
            Width="599px" DataMember="" Text="Imię, nazwisko, podpis albo nadruk z imieniem, nazwiskiem oraz stanowiskiem służbowym" Number="38"></ea:framelabel>
       
        
        <ea:framelabel id="FrameLabel147"
            style="Z-INDEX: 253; LEFT: 3px; POSITION: absolute; TOP: 1150px; height: 21px; width: 627px;" runat="server"
            Text="&lt;.INDEXUP&gt;1)&lt;./&gt; Ilekroć w deklaracji jest mowa o urzędzie skarbowym, w tym urzędzie skarbowym, do którego adresowana jest informacja - oznacza to urząd skarbowy, przy pomocy którego właściwy dla podatnika naczelnik urzędu skarbowego wykonuje swoje zadania."
            FrameStyle="Small" FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel132"
            style="Z-INDEX: 253; LEFT: 3px; POSITION: absolute; TOP: 1177px; height: 22px; width: 627px;" runat="server"
            Text="&lt;.INDEXUP&gt;2)&lt;./&gt;Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2019 r. poz. 900, z późn. zm.), zwanej dalej „Ordynacją podatkową”."
            FrameStyle="Small" FrameBorderStyle="None">
        </ea:FrameLabel>
        <ea:framelabel id="FrameLabel56"
            style="Z-INDEX: 254; LEFT: 3px; POSITION: absolute; TOP: 1200px; height: 39px; width: 627px;" runat="server"
            Text="&lt;.INDEXUP&gt;3)&lt;./&gt;Składający informację wykazuje przychody z odpłatnego zbycia papierów wartościowych i realizacji praw z nich wynikających, tylko co do których nie jest w stanie określić czy podlegają opodatkowaniu, czy nie podlegają opodatkowaniu na podstawie art. 19 ustawy z dnia 12 listopada 2003 r. o zmianie ustawy o podatku dochodowym od osób fizycznych oraz niektórych innych ustaw (Dz. U. poz. 1956, z późn. zm.); przychodów niepodlegających opodatkowaniu podatnik nie wykazuje w zeznaniu podatkowym."
            FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
       
        <ea:framelabel id="Framelabel131"
            style="Z-INDEX: 253; LEFT: 3px; POSITION: absolute; TOP: 1240px; width: 627px;" runat="server" Height="21px"
            Text="W informacji nie wykazuje się przychodów (dochodów) wolnych od podatku dochodowego na podstawie przepisów ustawy oraz dochodów, od których na podstawie przepisów Ordynacji podatkowej zaniechano poboru podatku."
            FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
        <ea:framelabel id="FrameLabel10" style="Z-INDEX: 156; LEFT: 300px; POSITION: absolute; TOP: 1270px"
            runat="server" Width="327px" Height="21px"
            Text="&lt;font STYLE='font-size: 7pt;'&gt;&lt;b&gt;Pouczenie&lt;/b&gt;" FrameStyle="Small"
            FrameBorderStyle="None"></ea:framelabel>
        <ea:framelabel id="FrameLabel11" style="Z-INDEX: 157; LEFT: 3px; POSITION: absolute; TOP: 1300px" runat="server"
            Width="627px" Height="6px"
            Text="Za złożenie informacji nieprawdziwej grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym."
            FrameStyle="Small" FrameBorderStyle="None"></ea:framelabel>
        <ea:deklaracjafooter id="footer2"
            style="Z-INDEX: 256; LEFT: 0px; POSITION: absolute; TOP: 1907px; right: 755px;" runat="server"
            TitleWidth="106" Symbol="PIT-8C" PageNumber="2" PageTotal="2" Version="10"></ea:deklaracjafooter>
        <ea:datacontext id="dc" style="Z-INDEX: 257; LEFT: 189px; POSITION: absolute; TOP: 1907px; width: 265px;"
            runat="server" TypeName="Soneta.Deklaracje.PIT.PIT8C,Soneta.Deklaracje" oncontextload="OnContextLoad"
            LeftMargin="15" PageHeight="977px" PageZoom="108%"></ea:datacontext>
    </form>
</body>

</HTML>