﻿<%@ Page language="c#" codePage="1200" AutoEventWireup="false" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.EwidencjaVat" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje.VAT" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>VAT-7(13) Info</title>
		<meta http-equiv="Content-Type" content="text/html; charset=unicode">
		<script runat="server">

    void VAT_7_13_Info_OnLoad(Object sender, EventArgs args)
			{
        Soneta.Deklaracje.VAT.VAT7_13 dek = (Soneta.Deklaracje.VAT.VAT7_13)DataContext1[typeof(Soneta.Deklaracje.VAT.VAT7_13)];
        
        BlokC.Visible = param.BlokC;
        Pole20.Visible = param.Pole20;
        Pole21.Visible = param.Pole21;
        Pole21a.Visible = param.Pole21a;        
        Pole22.Visible = param.Pole22;
        Pole23.Visible = param.Pole23;
        Pole2425.Visible = param.Pole2425;
        Pole2627.Visible = param.Pole2627;
        Pole2829.Visible = param.Pole2829;
        Pole30.Visible = param.Pole30;
        Pole31.Visible = param.Pole31;
        Pole3233.Visible = param.Pole3233;
        Pole3435.Visible = param.Pole3435;
        Pole3637.Visible = param.Pole3637;
        Pole3637a.Visible = param.Pole3637a;        
        Pole3839.Visible = param.Pole3839;

        BlokD2.Visible = param.BlokD2;
        Pole4647.Visible = param.Pole4647;
        Pole4849.Visible = param.Pole4849;
        
        
        SubTable stNalezny = dek.GetElementyNalezny();
        SubTable stNaliczony = dek.GetElementyNaliczony();

        ArrayList pole20Arr = new ArrayList();
        ArrayList pole21Arr = new ArrayList();
        ArrayList pole21aArr = new ArrayList();        
        ArrayList pole22Arr = new ArrayList();
        ArrayList pole23Arr = new ArrayList();
        ArrayList pole2425Arr = new ArrayList();
        ArrayList pole2627Arr = new ArrayList();
        ArrayList pole2829Arr = new ArrayList();
        ArrayList pole30Arr = new ArrayList();
        ArrayList pole31Arr = new ArrayList();
        ArrayList pole3233Arr = new ArrayList();
        ArrayList pole3435Arr = new ArrayList();
        ArrayList pole3637Arr = new ArrayList();
        ArrayList pole3637aArr = new ArrayList();        
        ArrayList pole3839Arr = new ArrayList();
        ArrayList naleznyPodejrzaneArr = new ArrayList();                                                                                              
        
        foreach (ElemRozliczeniaVAT elem in stNalezny)
        {
            if (elem.Element.Naglowek.Ewidencja.Typ != TypDokumentu.FWUENabyciaNależnyEwidencja &&
               (elem.Stawka.Status == StatusStawkiVat.NiePodlega || elem.Stawka.Status == StatusStawkiVat.Brak) &&
               elem.Rodzaj != RodzajZakupuVAT.NabywcaPodatnik)
            {
                pole21Arr.Add(elem);
                if(VAT7.IsUnia(elem) && elem.Rodzaj==RodzajZakupuVAT.Usługi)
                  pole21aArr.Add(elem);
            }
            else if (VAT7.IsZwolnione(elem))
            {
                pole20Arr.Add(elem);
            }
            else if (VAT7.Is0(elem) || VAT7.IsEksportPodrozny(elem) || 
                    VAT7.Is0Usluga(elem) && !(
                        elem.Element.Naglowek.Ewidencja.Typ == TypDokumentu.FWUENabyciaNależnyEwidencja
					            && (elem.RodzajPodmiotu == RodzajPodmiotu.Unijny || elem.RodzajPodmiotu == RodzajPodmiotu.Eksportowy)))
            {
                pole22Arr.Add(elem);
                if (VAT7.IsEksportPodrozny(elem))
                    pole23Arr.Add(elem);
            }
            else if (VAT7.Is3(elem) || VAT7.Is5(elem))
            {
                pole2425Arr.Add(elem);
            } 
						else if (VAT7.Is7(elem) || VAT7.Is8(elem))
            {
                pole2627Arr.Add(elem);
            } 
						else if (VAT7.Is22(elem) || VAT7.Is23(elem))
            {
                pole2829Arr.Add(elem);
            }
            else if (VAT7.IsUniaDostawa(elem))
            {
                pole30Arr.Add(elem);
            }
            else if (VAT7.IsEksport(elem))
            {
                pole31Arr.Add(elem);
            }
            else if (VAT7.IsUniaNabycieWew(elem))
            {
                pole3233Arr.Add(elem);
            }
            else if (VAT7.IsImportTowarow(elem))
            {
                pole3435Arr.Add(elem);
            }
            else if (VAT7.IsImportUslug(elem))
            {
                pole3637Arr.Add(elem);
                if (VAT7.IsUnia(elem) || VAT7.Is0Usluga(elem) && !VAT7.IsEksport(elem))
                  pole3637aArr.Add(elem);
            }
            else if (VAT7.IsNabywcaPodatnik(elem))//mmm
            {
                pole3839Arr.Add(elem);
            }
            else
                naleznyPodejrzaneArr.Add(elem);
        }

        ArrayList pole4647TakArr = new ArrayList();
        ArrayList pole4647WarunkowoVRArr = new ArrayList();
        ArrayList pole4647WarunkowoArr = new ArrayList();
        ArrayList pole4647WarunkowoNieruchomosciArr = new ArrayList();
        ArrayList pole4849TakArr = new ArrayList();
        ArrayList pole4849WarunkowoArr = new ArrayList();                                                                                                                      
        ArrayList naliczonyPodejrzaneArr = new ArrayList();                                                                                                      
        
        foreach (ElemRozliczeniaVAT elem in stNaliczony)
        {
            //nie uwzględniamy nabyc wewnątrz wspólnotowych
            if (elem.Stawka.Procent == 0m &&
						(elem.Naglowek.Naglowek.RodzajPodmiotu == RodzajPodmiotu.Unijny || elem.Naglowek.Naglowek.RodzajPodmiotu == RodzajPodmiotu.UnijnyTrójstronny) &&
						elem.Naglowek.Naglowek.Ewidencja.Typ == TypDokumentu.ZakupEwidencja)
							continue;


            //wyłączenie elementów nie podlegających odliczeniom
            if (elem.Odliczenia == OdliczeniaVAT.Nie)
							continue;

            //wyłączenie ze zliczania zakupów o stawce NP
            if (elem.Stawka.Status == StatusStawkiVat.NiePodlega || elem.Stawka.Status == StatusStawkiVat.Brak)
							continue;

            //wyłączenie ze zliczania zakupów o stawce 0%
            if (!dek.VAT.Ogólne.UwzględniaćZakupy0 &&
						elem.Stawka.Status == StatusStawkiVat.Opodatkowana && elem.Stawka.Procent == 0m)
							continue;

            //wyłączenie ze zliczania zakupów o stawce ZW
            if (!dek.VAT.Ogólne.UwzględniaćZakupyZW && elem.Stawka.Status == StatusStawkiVat.Zwolniona)
                continue;


            if (dek.IsSrodkiTrwaleOgolnieOdliczenia(elem))
            {
                pole4647TakArr.Add(elem);
            }
            else if (dek.IsPozostaleOdliczenia(elem))
            {
                pole4849TakArr.Add(elem);
            }
            else if (dek.IsSrodkiTrwaleVRWarunkowo(elem))
            {
                pole4647WarunkowoVRArr.Add(elem);
            }
            else if (dek.IsSrodkiTrwaleWarunkowo(elem))
            {
                pole4647WarunkowoArr.Add(elem);
            }
            else if (dek.IsNieruchomosciWarunkowo(elem))
            {
                pole4647WarunkowoNieruchomosciArr.Add(elem);
            }
            else if (dek.IsPozostaleWarunkowo(elem))
            {
                pole4849WarunkowoArr.Add(elem);
            }
            else
                naliczonyPodejrzaneArr.Add(elem);            
        }

        Pole20Grid.DataSource = pole20Arr;
        Pole21Grid.DataSource = pole21Arr;
        Pole21aGrid.DataSource = pole21aArr;        
        Pole22Grid.DataSource = pole22Arr;
        Pole23Grid.DataSource = pole23Arr;
        Pole2425Grid.DataSource = pole2425Arr;
        Pole2627Grid.DataSource = pole2627Arr;                                
        Pole2829Grid.DataSource = pole2829Arr;
        Pole30Grid.DataSource = pole30Arr;
        Pole31Grid.DataSource = pole31Arr;
        Pole3233Grid.DataSource = pole3233Arr;
        Pole3435Grid.DataSource = pole3435Arr;
        Pole3637Grid.DataSource = pole3637Arr;
        Pole3637aGrid.DataSource = pole3637aArr;        
        Pole3839Grid.DataSource = pole3839Arr;

        Pole4647TakGrid.DataSource = pole4647TakArr;
        Pole4647WarunkowoVRGrid.DataSource = pole4647WarunkowoVRArr;
        Pole4647WarunkowoGrid.DataSource = pole4647WarunkowoArr;
        Pole4647WarunkowoNieruchomosciGrid.DataSource = pole4647WarunkowoNieruchomosciArr;
        Pole4849TakGrid.DataSource = pole4849TakArr;
        Pole4849WarunkowoGrid.DataSource = pole4849WarunkowoArr;

				if (naleznyPodejrzaneArr.Count > 0) {
					foreach (ElemRozliczeniaVAT elem in naleznyPodejrzaneArr)
						writeToLog(elem);
				}

				if (naliczonyPodejrzaneArr.Count > 0) {
					foreach (ElemRozliczeniaVAT elem in naliczonyPodejrzaneArr)
						writeToLog(elem);
				}			
    }

		static string logName = "VAT-7 - podejrzane elementy nie uwzględnione na deklaracji";
		
			void writeToLog(ElemRozliczeniaVAT elem) {
			Log log = new Log(logName, true);
			log.WriteLine("{0}({1});{2};{3};{4};{5};{6};{7};{8};{9}",
				elem.NumerEwidencji, elem.NumerDokumentu, elem.Lp, elem.Stawka, elem.Netto, elem.VAT,
				elem.Rodzaj, elem.Odliczenia, elem.RodzajPodmiotu, elem.StatusPodmiotu);
		}		
			
    Param param = null;
    
    [Context]
    [Required]
    public Param Params{
			get{ return param; }			
			set{ param = value; }
    }
    
    public class Param : ContextBase{

			public Param(Context cx): base(cx){
			}

        bool blokC = true;
        [Priority(1)]
        [Caption("Blok C")]
        public bool BlokC
        {
            get { return blokC; }
            set { blokC = value; }
        }

        bool pole20 = true;
        [Priority(2)]
        [Caption(" Pole 20")]
        public bool Pole20
        {
            get { return pole20; }
            set { pole20 = value; }
        }

        bool pole21 = true;
        [Priority(3)]
        [Caption(" Pole 21")]
        public bool Pole21
        {
            get { return pole21; }
            set { pole21 = value; }
        }
        
        bool pole21a = true;
        [Priority(4)]
        [Caption(" Pole 22")]
        public bool Pole21a
        {
            get { return pole21a; }
            set { pole21a = value; }
        }        

        bool pole22 = true;
        [Priority(5)]
        [Caption(" Pole 23")]
        public bool Pole22
        {
            get { return pole22; }
            set { pole22 = value; }
        }

        bool pole23 = true;
        [Priority(6)]
        [Caption("  Pole 24")]
        public bool Pole23
        {
            get { return pole23; }
            set { pole23 = value; }
        }

        bool pole2425 = true;
        [Priority(7)]
        [Caption(" Pole 25,26")]
        public bool Pole2425
        {
            get { return pole2425; }
            set { pole2425 = value; }
        }

        bool pole2627 = true;
        [Priority(8)]
        [Caption(" Pole 27,28")]
        public bool Pole2627
        {
            get { return pole2627; }
            set { pole2627 = value; }
        }

        bool pole2829 = true;
        [Priority(9)]
        [Caption(" Pole 29,30")]
        public bool Pole2829
        {
            get { return pole2829; }
            set { pole2829 = value; }
        }

        bool pole30 = true;
        [Priority(10)]
        [Caption(" Pole 31")]
        public bool Pole30
        {
            get { return pole30; }
            set { pole30 = value; }
        }

        bool pole31 = true;
        [Priority(11)]
        [Caption(" Pole 32")]
        public bool Pole31
        {
            get { return pole31; }
            set { pole31 = value; }
        }

        bool pole3233 = true;
        [Priority(12)]
        [Caption(" Pole 33,34")]
        public bool Pole3233
        {
            get { return pole3233; }
            set { pole3233 = value; }
        }

        bool pole3435 = true;
        [Priority(13)]
        [Caption(" Pole 35,36")]
        public bool Pole3435
        {
            get { return pole3435; }
            set { pole3435 = value; }
        }

        bool pole3637 = true;
        [Priority(14)]
        [Caption(" Pole 37,38")]
        public bool Pole3637
        {
            get { return pole3637; }
            set { pole3637 = value; }
        }
        
        bool pole3637a = true;
        [Priority(15)]
        [Caption(" Pole 39,40")]
        public bool Pole3637a
        {
            get { return pole3637a; }
            set { pole3637a = value; }
        }        

        bool pole3839 = true;
        [Priority(16)]
        [Caption(" Pole 41,42")]
        public bool Pole3839
        {
            get { return pole3839; }
            set { pole3839 = value; }
        }
        
        bool blokD2 = true;
        [Priority(17)]
        [Caption("Blok D.2")]
        public bool BlokD2
        {
            get { return blokD2; }
            set { blokD2 = value; }
        }

        bool pole4647 = true;
        [Priority(18)]
        [Caption(" Pole 49,50")]
        public bool Pole4647
        {
            get { return pole4647; }
            set { pole4647 = value; }
        }

        bool pole4849 = true;
        [Priority(19)]
        [Caption(" Pole 51,52")]
        public bool Pole4849
        {
            get { return pole4849; }
            set { pole4849 = value; }
        }                        
        
    }
		</script>
	</HEAD>
	<body>
		<form id="VAT_7_13_Info" method="post" runat="server">
			<ea:datacontext id="DataContext1" runat="server" OnContextLoad="VAT_7_13_Info_OnLoad" TypeName="Soneta.Deklaracje.VAT.VAT7_13,Soneta.Deklaracje"></ea:datacontext>
			<cc1:ReportHeader id="ReportHeader1" title="Zestawienie VAT-7(13) {0}" runat="server" DataMember0="Numer.NumerPelny"></cc1:ReportHeader>
			<ea:Section id="BlokC" runat="server" Width="100%">
				<STRONG><FONT size="2">Blok C</FONT></STRONG><BR>
				<ea:Section id="Pole20" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 20</EM></FONT>
					<ea:grid id="Pole20Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="colLP"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="colEwidencja" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="colDokument"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="colData"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="colNetto" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="colVAT"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>
				<ea:Section id="Pole21" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 21</EM></FONT>
					<ea:grid id="Pole21Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn7"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn8" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn9"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn10"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn11" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn12"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>				
        <ea:Section id="Pole21a" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 22</EM></FONT>
					<ea:grid id="Pole21aGrid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"	Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>								
				<ea:Section id="Pole22" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 23</EM></FONT>
					<ea:grid id="Pole22Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn13"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn14" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn15"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn16"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn17" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn18"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>								
				<ea:Section id="Pole23" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 24</EM></FONT>
					<ea:grid id="Pole23Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn19"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn20" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn21"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn22"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn23" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn24"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>												
				<ea:Section id="Pole2425" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 25,26</EM></FONT>
					<ea:grid id="Pole2425Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn25"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn26" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn27"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn28"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn29" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn30"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>														
				<ea:Section id="Pole2627" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 27,28</EM></FONT>
					<ea:grid id="Pole2627Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn31"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn32" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn33"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn34"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn35" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn36"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>														
				<ea:Section id="Pole2829" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 29,30</EM></FONT>
					<ea:grid id="Pole2829Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn1"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn2" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn3"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn4"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn5" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn6"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>
				<ea:Section id="Pole30" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 31</EM></FONT>
					<ea:grid id="Pole30Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn37"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn38" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn39"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn40"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn41" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn42"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>		
				<ea:Section id="Pole31" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 32</EM></FONT>
					<ea:grid id="Pole31Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn61"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn62" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn63"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn64"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn65" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn66"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>						
				<ea:Section id="Pole3233" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 33,34</EM></FONT>
					<ea:grid id="Pole3233Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn43"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn44" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn45"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn46"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn47" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn48"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>						
				<ea:Section id="Pole3435" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 35,36</EM></FONT>
					<ea:grid id="Pole3435Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn49"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn50" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn51"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn52"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn53" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn54"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>										
				<ea:Section id="Pole3637" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 37,38</EM></FONT>
					<ea:grid id="Pole3637Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn55"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn56" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn57"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn58"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn59" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn60"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>														
				<ea:Section id="Pole3637a" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 39,40</EM></FONT>
					<ea:grid id="Pole3637aGrid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" 
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>																		
			</ea:Section>
				<ea:Section id="Pole3839" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 41,42</EM></FONT>
					<ea:grid id="Pole3839Grid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn97"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn98" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn99"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn100"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn101" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn102"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
				</ea:Section>														
			</ea:Section>			
			<ea:Section id="BlokD2" runat="server" Width="100%">
				<STRONG><FONT size="2">Blok D.2</FONT></STRONG><BR>
				<ea:Section id="Pole4647" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 49,50</EM></FONT><BR>
                    <FONT size="2"><EM>Odliczenia na "Tak"</EM></FONT><BR>					
					<ea:grid id="Pole4647TakGrid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn67"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn68" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn69"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn70"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn71" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn72"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
                    <FONT size="2"><EM>Odliczenia na "Warunkowo" - środki trwałe VAT rok</EM></FONT><BR>					
					<ea:grid id="Pole4647WarunkowoVRGrid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn103"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn104" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn105"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn106"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn107" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn108"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>					
                    <FONT size="2"><EM>Odliczenia na "Warunkowo" - środki trwałe</EM></FONT><BR>					
					<ea:grid id="Pole4647WarunkowoGrid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn73"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn74" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn75"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn76"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn77" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn78"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>					
                    <FONT size="2"><EM>Odliczenia na "Warunkowo" - nieruchomości</EM></FONT><BR>					
					<ea:grid id="Pole4647WarunkowoNieruchomosciGrid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn91"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn92" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn93"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn94"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn95" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn96"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>										
				</ea:Section>
				<ea:Section id="Pole4849" runat="server" Width="100%">
					<FONT size="2"><EM>Pole 51,52</EM></FONT><BR>
                    <FONT size="2"><EM>Odliczenia na "Tak"</EM></FONT><BR>					
					<ea:grid id="Pole4849TakGrid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn79"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn80" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn81"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn82"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn83" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn84"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>
                    <FONT size="2"><EM>Odliczenia na "Warunkowo"</EM></FONT><BR>					
					<ea:grid id="Pole4849WarunkowoGrid" runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega"
						ShowTotalSum="true">
						<Columns>
							<ea:GridColumn Width="5" DataMember="#" Caption="Lp" ID="GridColumn85"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" ID="GridColumn86" Total="Info"></ea:GridColumn>
							<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" ID="GridColumn87"></ea:GridColumn>
							<ea:GridColumn Width="10" DataMember="Data" Caption="Data" ID="GridColumn88"></ea:GridColumn>
							<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}"
								ID="GridColumn89" Total="Sum"></ea:GridColumn>
							<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" ID="GridColumn90"
								Total="Sum"></ea:GridColumn>
						</Columns>
					</ea:grid>					
				</ea:Section>				
			</ea:Section>			
			<cc1:ReportFooter id="ReportFooter1" runat="server">
				<Subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
		</form>
	</body>
</HTML>

