﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>


<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>

<%@ Import Namespace="Soneta.Deklaracje.VAT" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.EwidencjaVat" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>VAT-7(15) Info</title>
	<meta http-equiv="Content-Type" content="text/html; charset=unicode">
	<script runat="server">

	
		private void VAT_7_15_Info_OnLoad(Object sender, EventArgs args)
		{
			var dek = (VAT7_15)DataContext1[typeof(VAT7_15)];

			SectionOfBlokC1.Visible = Params.BlokC;
			SectionOfBlokC2.Visible = Params.BlokC;
			SectionOfBlokD1.Visible = Params.BlokD2;
			SectionOfBlokD2.Visible = Params.BlokD2;

			var gSusp = new List<ElemRozliczeniaVAT>();

			if (Params.BlokC)
			{
				var g10 = new GridClass { Name = "Pole 10", Visible = Params.Pole10 };
				var g11 = new GridClass { Name = "Pole 11", Visible = Params.Pole11 };
				var g12 = new GridClass { Name = "Pole 12", Visible = Params.Pole12 };
				var g13 = new GridClass { Name = "Pole 13", Visible = Params.Pole13 };
				var g14 = new GridClass { Name = "Pole 14", Visible = Params.Pole14 };
				var g15 = new GridClass { Name = "Pole 15, 16", Visible = Params.Pole1516 };
				var g17 = new GridClass { Name = "Pole 17, 18", Visible = Params.Pole1718 };
				var g19 = new GridClass { Name = "Pole 19, 20", Visible = Params.Pole1920 };
				var g21 = new GridClass { Name = "Pole 21", Visible = Params.Pole21 };
				var g22 = new GridClass { Name = "Pole 22", Visible = Params.Pole22 };
				var g23 = new GridClass { Name = "Pole 23, 24", Visible = Params.Pole2324 };
				var g25 = new GridClass { Name = "Pole 25, 26", Visible = Params.Pole2526 };
				var g27 = new GridClass { Name = "Pole 27, 28", Visible = Params.Pole2728 };
				var g29 = new GridClass { Name = "Pole 29, 30", Visible = Params.Pole2930 };
				var g31 = new GridClass { Name = "Pole 31", Visible = Params.Pole31 };
				var g32 = new GridClass { Name = "Pole 32, 33", Visible = Params.Pole3233 };
				var g34 = new GridClass { Name = "Pole 34, 35", Visible = Params.Pole3435 };
				var gArr = new[] { g10, g11, g12, g13, g14, g15, g17, g19, g21, g22, g23, g25, g27, g29, g31, g32, g34 };

				foreach (ElemRozliczeniaVAT elem in dek.GetElementyNalezny())
				{
					if (elem.Element.Naglowek.Ewidencja.Typ != TypDokumentu.FWUENabyciaNależnyEwidencja && (elem.Stawka.Status == StatusStawkiVat.NiePodlega || elem.Stawka.Status == StatusStawkiVat.Brak) &&
						!VAT7.IsNabywcaPodatnikTowarLubUsluga(elem) && (VAT7.IsKraj(elem) || elem.Rodzaj != RodzajZakupuVAT.VATMarza))
					{
						if (!VAT7.IsUniaNieTrojstronny(elem) && elem.RodzajPodmiotu != RodzajPodmiotu.Eksportowy)
							continue;

						g11.Add(elem);
						if (VAT7.IsUniaNieTrojstronny(elem) && elem.Rodzaj == RodzajZakupuVAT.Usługi)
							g12.Add(elem);
					}
					else if (VAT7.IsZwolnione(elem))
					{
						g10.Add(elem);
					}
					else if (VAT7.Is0(elem) || VAT7.IsEksportPodrozny(elem) || VAT7.Is0Usluga(elem) &&
						!(elem.Element.Naglowek.Ewidencja.Typ == TypDokumentu.FWUENabyciaNależnyEwidencja && (elem.RodzajPodmiotu == RodzajPodmiotu.Unijny || elem.RodzajPodmiotu == RodzajPodmiotu.Eksportowy)))
					{
						g13.Add(elem);
						if (VAT7.IsEksportPodrozny(elem))
							g14.Add(elem);
					}
					else if (VAT7.Is3(elem) || VAT7.Is5(elem))
						g15.Add(elem);
					else if (VAT7.Is7(elem) || VAT7.Is8(elem))
						g17.Add(elem);
					else if (VAT7.Is22(elem) || VAT7.Is23(elem))
						g19.Add(elem);
					else if (VAT7.IsUniaDostawa(elem))
						g21.Add(elem);
					else if (VAT7.IsEksport(elem) && elem.Element.Naglowek.Ewidencja.Typ != TypDokumentu.FWUENabyciaNależnyEwidencja)
						g22.Add(elem);
					else if (VAT7.IsUniaNabycieWew(elem))
						g23.Add(elem);
					else if (VAT7.IsImportTowarow(elem))
						g25.Add(elem);
					else if (VAT7.IsImportUslug(elem))
					{
						if (VAT7.IsUnia(elem) || VAT7.Is0Usluga(elem) && !VAT7.IsEksport(elem))
							g29.Add(elem);
						else
							g27.Add(elem);
					}
					else if (VAT7.IsNabywcaPodatnik(elem) && elem.Element.Naglowek.Ewidencja.Typ == TypDokumentu.SprzedażEwidencja)
						g31.Add(elem);
					else if (VAT7.IsNabywcaPodatnik(elem) && elem.RodzajPodmiotu == RodzajPodmiotu.Krajowy)
						g34.Add(elem);
					else if (VAT7.IsNabywcaPodatnik(elem) && elem.Rodzaj == RodzajZakupuVAT.NabywcaPodatnik)
						g32.Add(elem);
					else
						gSusp.Add(elem);
				}

				SectionOfBlokC2.DataSource = gArr.Where(g => g.Visible);
			}

			if (Params.BlokD2)
			{
				var g41 = new GridClass { Name = "Pole 41, 42 - odliczenia na TAK", Visible = Params.Pole4142 };
				var g41Vr = new GridClass { Name = "Odliczenia na WARUNKOWO - środki trwałe VAT rok", Visible = Params.Pole4142 };
				var g41ST = new GridClass { Name = "Odliczenia na WARUNKOWO - środki trwałe", Visible = Params.Pole4142 };
				var g41Nr = new GridClass { Name = "Odliczenia na WARUNKOWO - nieruchomości", Visible = Params.Pole4142 };
				var g43 = new GridClass { Name = "Pole 43, 44 - odliczenia na TAK", Visible = Params.Pole4344 };
				var g43W = new GridClass { Name = "Odliczenia na WARUNKOWO", Visible = Params.Pole4344 };
				var gArr = new[] { g41, g41Vr, g41ST, g41Nr, g43, g43W };

				foreach (ElemRozliczeniaVAT elem in dek.GetElementyNaliczony())
				{
					if (elem.Stawka.Procent == 0m && (elem.Naglowek.Naglowek.RodzajPodmiotu == RodzajPodmiotu.Unijny || elem.Naglowek.Naglowek.RodzajPodmiotu == RodzajPodmiotu.UnijnyTrójstronny) && elem.Naglowek.Naglowek.Ewidencja.Typ == TypDokumentu.ZakupEwidencja)
						continue; // -> nie uwzględniamy nabyc wewnątrz wspólnotowych
					if (elem.Odliczenia == OdliczeniaVAT.Nie)
						continue; // -> wyłączenie elementów nie podlegających odliczeniom
					if (elem.Stawka.Status == StatusStawkiVat.NiePodlega || elem.Stawka.Status == StatusStawkiVat.Brak)
						continue; // -> wyłączenie ze zliczania zakupów o stawce NP
					if (!dek.VAT.Ogólne.UwzględniaćZakupy0 && elem.Stawka.Status == StatusStawkiVat.Opodatkowana && elem.Stawka.Procent == 0m)
						continue; // -> wyłączenie ze zliczania zakupów o stawce 0%
					if (!dek.VAT.Ogólne.UwzględniaćZakupyZW && elem.Stawka.Status == StatusStawkiVat.Zwolniona)
						continue; // -> wyłączenie ze zliczania zakupów o stawce ZW

					if (dek.IsSrodkiTrwaleOgolnieOdliczenia(elem))
						g41.Add(elem);
					else if (dek.IsPozostaleOdliczenia(elem))
					{
						if(elem.Naglowek.Typ != TypRozliczeniaVAT.KasoweZłeDługi && elem.Naglowek.Typ != TypRozliczeniaVAT.KasoweZłeDługiKorekta)
							g43.Add(elem);
					}
					else if (dek.IsSrodkiTrwaleVRWarunkowo(elem))
						g41Vr.Add(elem);
					else if (dek.IsSrodkiTrwaleWarunkowo(elem))
						g41ST.Add(elem);
					else if (dek.IsNieruchomosciWarunkowo(elem))
						g41Nr.Add(elem);
					else if (dek.IsPozostaleWarunkowo(elem))
						g43W.Add(elem);
					else
						gSusp.Add(elem);
				}

				SectionOfBlokD2.DataSource = gArr.Where(g => g.Visible);
			}

			if (gSusp.Count > 0 )
			{
				var log = new Log("VAT-7 - podejrzane elementy nie uwzględnione na deklaracji", true);
				foreach (var elem in gSusp)
					log.WriteLine("{0}({1});{2};{3};{4};{5};{6};{7};{8};{9}", elem.NumerEwidencji, elem.NumerDokumentu, elem.Lp, elem.Stawka, elem.Netto, elem.VAT, elem.Rodzaj, elem.Odliczenia, elem.RodzajPodmiotu, elem.StatusPodmiotu);
			}
		}


		public class GridClass
		{
			private List<ElemRozliczeniaVAT> _elems = new List<ElemRozliczeniaVAT>();

			public String Name { get; set; }
			public Boolean Visible { get; set; }

			public List<ElemRozliczeniaVAT> Elems
			{
				get { return _elems; }
				set { _elems = value; }
			}

			public void Add(ElemRozliczeniaVAT elem)
			{ _elems.Add(elem); }
		}


		[Context, Required]
		public Parameters Params { get; set; }


		public class Parameters : ContextBase
		{
			private bool _blokD2;
			private bool _blokC;

			public Parameters(Context cx)
				: base(cx)
			{
				_blokC = _blokD2 = true;
				Pole10 = Pole11 = Pole12 = Pole13 = Pole14 = Pole1516 = Pole1718 = Pole1920 = Pole21 = Pole22 = Pole2324 = Pole2526 = Pole2728 = Pole2930 = Pole31 = Pole3233 = Pole3435 = true;
				Pole4142 = Pole4344 = true;
			}

			[Priority(10)]
			[Caption("Blok C")]
			[Category("VAT-7 (15) - BLOK C")]
			public bool BlokC
			{
				get { return _blokC; }
				set { _blokC = value; OnChanged(); }
			}

			[Priority(20)]
			[Caption(" ... Pole 10")]
			public bool Pole10 { get; set; }

			[Priority(30)]
			[Caption(" ... Pole 11")]
			public bool Pole11 { get; set; }

			[Priority(40)]
			[Caption(" ... Pole 12")]
			public bool Pole12 { get; set; }

			[Priority(50)]
			[Caption(" ... Pole 13")]
			public bool Pole13 { get; set; }

			[Priority(60)]
			[Caption(" ... Pole 14")]
			public bool Pole14 { get; set; }

			[Priority(70)]
			[Caption(" ... Pole 15, 16")]
			public bool Pole1516 { get; set; }

			[Priority(80)]
			[Caption(" ... Pole 17, 18")]
			public bool Pole1718 { get; set; }

			[Priority(90)]
			[Caption(" ... Pole 19, 20")]
			public bool Pole1920 { get; set; }

			[Priority(100)]
			[Caption(" ... Pole 21")]
			public bool Pole21 { get; set; }

			[Priority(110)]
			[Caption(" ... Pole 22")]
			public bool Pole22 { get; set; }

			[Priority(120)]
			[Caption(" ... Pole 23, 24")]
			public bool Pole2324 { get; set; }

			[Priority(130)]
			[Caption(" ... Pole 25, 26")]
			public bool Pole2526 { get; set; }

			[Priority(140)]
			[Caption(" ... Pole 27, 28")]
			public bool Pole2728 { get; set; }

			[Priority(150)]
			[Caption(" ... Pole 29, 30")]
			public bool Pole2930 { get; set; }

			[Priority(160)]
			[Caption(" ... Pole 31")]
			public bool Pole31 { get; set; }

			[Priority(170)]
			[Caption(" ... Pole 32, 33")]
			public bool Pole3233 { get; set; }

			[Priority(180)]
			[Caption(" ... Pole 34, 35")]
			public bool Pole3435 { get; set; }

			[Priority(200)]
			[Caption("Blok D.2")]
			[Category("VAT-7 (15) - BLOK D.2")]
			public bool BlokD2
			{
				get { return _blokD2; }
				set { _blokD2 = value; OnChanged(); }
			}

			[Priority(210)]
			[Caption(" ... Pole 41, 42")]
			public bool Pole4142 { get; set; }

			[Priority(220)]
			[Caption(" ... Pole 43, 44")]
			public bool Pole4344 { get; set; }


			public bool IsReadOnlyPole10() { return !_blokC; }
			public bool IsReadOnlyPole11() { return !_blokC; }
			public bool IsReadOnlyPole12() { return !_blokC; }
			public bool IsReadOnlyPole13() { return !_blokC; }
			public bool IsReadOnlyPole14() { return !_blokC; }
			public bool IsReadOnlyPole1516() { return !_blokC; }
			public bool IsReadOnlyPole1718() { return !_blokC; }
			public bool IsReadOnlyPole1920() { return !_blokC; }
			public bool IsReadOnlyPole21() { return !_blokC; }
			public bool IsReadOnlyPole22() { return !_blokC; }
			public bool IsReadOnlyPole2324() { return !_blokC; }
			public bool IsReadOnlyPole2526() { return !_blokC; }
			public bool IsReadOnlyPole2728() { return !_blokC; }
			public bool IsReadOnlyPole2930() { return !_blokC; }
			public bool IsReadOnlyPole31() { return !_blokC; }
			public bool IsReadOnlyPole3233() { return !_blokC; }
			public bool IsReadOnlyPole3435() { return !_blokC; }

			public bool IsReadOnlyPole4142() { return !_blokD2; }
			public bool IsReadOnlyPole4344() { return !_blokD2; }
		}

		
	</script>
</head>
<body>
	<form id="VAT_7_15_Info" method="post" runat="server">
		<ea:datacontext id="DataContext1" runat="server" oncontextload="VAT_7_15_Info_OnLoad" typename="Soneta.Deklaracje.VAT.VAT7_15,Soneta.Deklaracje"></ea:datacontext>
		<cc1:reportheader id="ReportHeader1" title="Zestawienie VAT-7(15) {0}" runat="server" datamember0="Numer.NumerPelny"></cc1:reportheader>

		<ea:section id="SectionOfBlokC1" runat="server" width="100%">
			<span style='font-size: 11pt; font-weight: bold; display: block; margin: 5mm 0'>Blok C</span>
		</ea:section>

		<ea:datarepeater id="SectionOfBlokC2" withsections="False" runat="server">
			<span style="font-size: 9pt; font-weight: normal; display: block; margin: 3mm 0 1mm 0;"><ea:DataLabel runat="server" DataMember="Name" Bold="False" /></span>
				
			<ea:Grid runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega" DataMember="Elems" >
				<Columns>
					<ea:GridColumn Width="5" DataMember="#" Caption="Lp" />
					<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" />
					<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" />
					<ea:GridColumn Width="10" DataMember="Data" Caption="Data" Total="Info" />
					<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}" Total="Sum" />
					<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" Total="Sum" />
				</Columns>
			</ea:Grid>
		</ea:datarepeater>
		
		<ea:section id="SectionOfBlokD1" runat="server" width="100%">
			<span style='font-size: 11pt; font-weight: bold; display: block; margin: 5mm 0'>Blok D.2</span>
		</ea:section>

		<ea:datarepeater id="SectionOfBlokD2" withsections="False" runat="server">
			<span style="font-size: 9pt; font-weight: normal; display: block; margin: 3mm 0 1mm 0;"><ea:DataLabel runat="server" DataMember="Name" Bold="False" /></span>
				
			<ea:Grid runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega" DataMember="Elems" >
				<Columns>
					<ea:GridColumn Width="5" DataMember="#" Caption="Lp" />
					<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" />
					<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" />
					<ea:GridColumn Width="10" DataMember="Data" Caption="Data" Total="Info" />
					<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}" Total="Sum" />
					<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" Total="Sum" />
				</Columns>
			</ea:Grid>
		</ea:datarepeater>

		<cc1:reportfooter runat="server">
			<subtitles>
				<cc1:FooterSubtitle SubtitleType="Operator" />
			</subtitles>
		</cc1:reportfooter>
	</form>
</body>
</html>

