﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>


<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Linq" %>

<%@ Import Namespace="Soneta.Deklaracje.VAT" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.EwidencjaVat" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>VAT-7(16) Info</title>
	<meta http-equiv="Content-Type" content="text/html; charset=unicode">
	<script runat="server">

	
		private void VAT_7_16_Info_OnLoad(Object sender, EventArgs args)
		{
			var dek = (VAT7_16)DataContext1[typeof(VAT7_16)];

			SectionOfBlokC1.Visible = Params.BlokC;
			SectionOfBlokC2.Visible = Params.BlokC;
			SectionOfBlokD1.Visible = Params.BlokD2;
			SectionOfBlokD2.Visible = Params.BlokD2;

			var gSusp = new List<ElemRozliczeniaVAT>();

			if (Params.BlokC)
			{
				var g10 = new GridClass { Name = "Pole 10", Visible = Params.Pole10 };
				var g11 = new GridClass { Name = "Pole 11", Visible = Params.Pole11 };
				var g12 = new GridClass { Name = "Pole 12", Visible = Params.Pole12 };
				var g13 = new GridClass { Name = "Pole 13", Visible = Params.Pole13 };
				var g14 = new GridClass { Name = "Pole 14", Visible = Params.Pole14 };
				var g15 = new GridClass { Name = "Pole 15, 16", Visible = Params.Pole1516 };
				var g17 = new GridClass { Name = "Pole 17, 18", Visible = Params.Pole1718 };
				var g19 = new GridClass { Name = "Pole 19, 20", Visible = Params.Pole1920 };
				var g21 = new GridClass { Name = "Pole 21", Visible = Params.Pole21 };
				var g22 = new GridClass { Name = "Pole 22", Visible = Params.Pole22 };
				var g23 = new GridClass { Name = "Pole 23, 24", Visible = Params.Pole2324 };
				var g25 = new GridClass { Name = "Pole 25, 26", Visible = Params.Pole2526 };
				var g27 = new GridClass { Name = "Pole 27, 28", Visible = Params.Pole2728 };
				var g29 = new GridClass { Name = "Pole 29, 30", Visible = Params.Pole2930 };
				var g31 = new GridClass { Name = "Pole 31", Visible = Params.Pole31 };
				var g32 = new GridClass { Name = "Pole 32, 33", Visible = Params.Pole3233 };
				var g34 = new GridClass { Name = "Pole 34, 35", Visible = Params.Pole3435 };
				var gArr = new[] { g10, g11, g12, g13, g14, g15, g17, g19, g21, g22, g23, g25, g27, g29, g31, g32, g34 };

				foreach (ElemRozliczeniaVAT elem in dek.GetElementyNalezny())
				{
					if (elem.Element.Naglowek.Ewidencja.Typ != TypDokumentu.FWUENabyciaNależnyEwidencja && (elem.Stawka.Status == StatusStawkiVat.NiePodlega || elem.Stawka.Status == StatusStawkiVat.Brak) &&
						!VAT7.IsNabywcaPodatnikTowarLubUsluga(elem) && (VAT7.IsKraj(elem) || elem.Rodzaj != RodzajZakupuVAT.VATMarza))
					{
						if (!VAT7.IsUnia(elem) && elem.RodzajPodmiotu != RodzajPodmiotu.Eksportowy)
							continue;

						g11.Add(elem);
						if (VAT7.IsUnia(elem) && elem.Rodzaj == RodzajZakupuVAT.Usługi)
							g12.Add(elem);
					}
					else if (VAT7.IsZwolnione(elem))
					{
						g10.Add(elem);
					}
					else if (VAT7.Is0(elem) || VAT7.IsEksportPodrozny(elem) || VAT7.Is0Usluga(elem) &&
						!(elem.Element.Naglowek.Ewidencja.Typ == TypDokumentu.FWUENabyciaNależnyEwidencja && (elem.RodzajPodmiotu == RodzajPodmiotu.Unijny || elem.RodzajPodmiotu == RodzajPodmiotu.Eksportowy)))
					{
						g13.Add(elem);
						if (VAT7.IsEksportPodrozny(elem))
							g14.Add(elem);
					}
					else if (VAT7.Is3(elem) || VAT7.Is5(elem))
						g15.Add(elem);
					else if (VAT7.Is7(elem) || VAT7.Is8(elem))
						g17.Add(elem);
					else if (VAT7.Is22(elem) || VAT7.Is23(elem))
						g19.Add(elem);
					else if (VAT7.IsUniaDostawa(elem))
						g21.Add(elem);
					else if (VAT7.IsEksport(elem) && elem.Element.Naglowek.Ewidencja.Typ != TypDokumentu.FWUENabyciaNależnyEwidencja)
						g22.Add(elem);
					else if (VAT7.IsUniaNabycieWew(elem))
						g23.Add(elem);
					else if (VAT7.IsImportTowarow(elem))
						g25.Add(elem);
					else if (VAT7.IsImportUslug(elem))
					{
						if (VAT7.IsUnia(elem) || VAT7.Is0Usluga(elem) && !VAT7.IsEksport(elem))
							g29.Add(elem);
						else
							g27.Add(elem);
					}
					else if (VAT7.IsNabywcaPodatnik(elem) && elem.Element.Naglowek.Ewidencja.Typ == TypDokumentu.SprzedażEwidencja)
						g31.Add(elem);
					else if (VAT7.IsNabywcaPodatnik(elem) && elem.RodzajPodmiotu == RodzajPodmiotu.Krajowy)
						g34.Add(elem);
					else if (VAT7.IsNabywcaPodatnik(elem) && elem.Rodzaj == RodzajZakupuVAT.NabywcaPodatnik)
						g32.Add(elem);
					else
						gSusp.Add(elem);
				}

				SectionOfBlokC2.DataSource = gArr.Where(g => g.Visible);
			}

			if (Params.BlokD2)
			{
				var g41 = new GridClass { Name = "Pole 42, 43 - działalność TAK, odliczenia TAK", Visible = Params.Pole4243 };

				var g41VrDz     = new GridClass { Name = "działalność MIESZANA, odliczenia TAK - środki trwałe VAT rok", Visible = Params.Pole4243 };
				var g41VrOdl    = new GridClass { Name = "działalność TAK, odliczenia WARUNKOWO - środki trwałe VAT rok", Visible = Params.Pole4243 };
				var g41VrDzOdl  = new GridClass { Name = "działalność MIESZANA, odliczenia WARUNKOWO - środki trwałe VAT rok", Visible = Params.Pole4243 };
		
        		var g41STDz     = new GridClass { Name = "działalność MIESZANA, odliczenia TAK - środki trwałe", Visible = Params.Pole4243 };
        		var g41STOdl    = new GridClass { Name = "działalność TAK, odliczenia WARUNKOWO - środki trwałe", Visible = Params.Pole4243 };
        		var g41STDzOdl  = new GridClass { Name = "działalność MIESZANA, odliczenia WARUNKOWO - środki trwałe", Visible = Params.Pole4243 };
		
        		var g41NrDz     = new GridClass { Name = "działalność MIESZANA, odliczenia TAK - nieruchomości", Visible = Params.Pole4243 };
        		var g41NrOdl    = new GridClass { Name = "działalność TAK, odliczenia WARUNKOWO - nieruchomości", Visible = Params.Pole4243 };
        		var g41NrDzOdl  = new GridClass { Name = "działalność MIESZANA, odliczenia WARUNKOWO - nieruchomości", Visible = Params.Pole4243 };

				var g43         = new GridClass { Name = "Pole 44, 45 - działalność TAK, odliczenia TAK", Visible = Params.Pole4445 };
				var g43Dz       = new GridClass { Name = "działalność MIESZANA, odliczenia TAK", Visible = Params.Pole4445 };
				var g43Odl      = new GridClass { Name = "działalność TAK, odliczenia WARUNKOWO", Visible = Params.Pole4445 };
				var g43DzOdl    = new GridClass { Name = "działalność MIESZANA, odliczenia WARUNKOWO", Visible = Params.Pole4445 };

				var gArr = new[] { g41, g41VrDz,g41VrOdl,g41VrDzOdl, g41STDz,g41STOdl,g41STDzOdl, g41NrDz,g41NrOdl,g41NrDzOdl,
                    g43, g43Dz, g43Odl, g43DzOdl };

				foreach (ElemRozliczeniaVAT elem in dek.GetElementyNaliczony())
				{
					if (elem.Stawka.Procent == 0m && (elem.Naglowek.Naglowek.RodzajPodmiotu == RodzajPodmiotu.Unijny || elem.Naglowek.Naglowek.RodzajPodmiotu == RodzajPodmiotu.UnijnyTrójstronny) && elem.Naglowek.Naglowek.Ewidencja.Typ == TypDokumentu.ZakupEwidencja)
						continue; // -> nie uwzględniamy nabyc wewnątrz wspólnotowych
					if (elem.Odliczenia == OdliczeniaVAT.Nie || elem.DzialalnoscGosp == DzialalnoscGospodarcza.Nie)
						continue; // -> wyłączenie elementów nie podlegających odliczeniom
					if (elem.Stawka.Status == StatusStawkiVat.NiePodlega || elem.Stawka.Status == StatusStawkiVat.Brak)
						continue; // -> wyłączenie ze zliczania zakupów o stawce NP
					if (!dek.VAT.Ogólne.UwzględniaćZakupy0 && elem.Stawka.Status == StatusStawkiVat.Opodatkowana && elem.Stawka.Procent == 0m)
						continue; // -> wyłączenie ze zliczania zakupów o stawce 0%
					if (!dek.VAT.Ogólne.UwzględniaćZakupyZW && elem.Stawka.Status == StatusStawkiVat.Zwolniona)
						continue; // -> wyłączenie ze zliczania zakupów o stawce ZW

				    if (dek.IsSrodkiTrwaleOgolnieOdliczeniaV15(elem) || dek.IsPozostaleOdliczeniaV15(elem))
				    {
				        if (elem.Naglowek.Typ != TypRozliczeniaVAT.KasoweZłeDługi && elem.Naglowek.Typ != TypRozliczeniaVAT.KasoweZłeDługiKorekta)
				        {
				            if(dek.IsSrodkiTrwaleOgolnieOdliczeniaV15(elem))
    							g41.Add(elem);
                            if(dek.IsPozostaleOdliczeniaV15(elem))
						        g43.Add(elem);
				        }
				    }
					else if (dek.IsSrodkiTrwaleVRWarunkowoV15(elem))
						AddElem(elem,g41VrDz, g41VrOdl, g41VrDzOdl);
					else if (dek.IsSrodkiTrwaleWarunkowoV15(elem))
        				AddElem(elem,g41STDz, g41STOdl, g41STDzOdl);
					else if (dek.IsNieruchomosciWarunkowoV15(elem))
        				AddElem(elem,g41NrDz, g41NrOdl, g41NrDzOdl);
					else if (dek.IsPozostaleWarunkowoV15(elem))
        				AddElem(elem,g43Dz, g43Odl, g43DzOdl);
					else
						gSusp.Add(elem);
				}

				SectionOfBlokD2.DataSource = gArr.Where(g => g.Visible);
			}

			if (gSusp.Count > 0 )
			{
				var log = new Log("VAT-7 - podejrzane elementy nie uwzględnione na deklaracji", true);
				foreach (var elem in gSusp)
					log.WriteLine("{0}({1});{2};{3};{4};{5};{6};{7};{8};{9}", elem.NumerEwidencji, elem.NumerDokumentu, elem.Lp, elem.Stawka, elem.Netto, elem.VAT, elem.Rodzaj, elem.Odliczenia, elem.RodzajPodmiotu, elem.StatusPodmiotu);
			}
		}


	    private void AddElem(ElemRozliczeniaVAT elem, GridClass dz, GridClass odl, GridClass dzOdl)
	    {
	        Debug.Assert(elem.DzialalnoscGosp == DzialalnoscGospodarcza.CelMieszany || elem.Odliczenia == OdliczeniaVAT.Warunkowo);    
            if(elem.DzialalnoscGosp == DzialalnoscGospodarcza.Tak && elem.Odliczenia == OdliczeniaVAT.Warunkowo)
                odl.Add(elem);
            else if(elem.DzialalnoscGosp == DzialalnoscGospodarcza.CelMieszany && elem.Odliczenia == OdliczeniaVAT.Tak)
                dz.Add(elem);
            else
                dzOdl.Add(elem);
	    }


		public class GridClass
		{
			private List<ElemRozliczeniaVAT> _elems = new List<ElemRozliczeniaVAT>();

			public String Name { get; set; }
			public Boolean Visible { get; set; }

			public List<ElemRozliczeniaVAT> Elems
			{
				get { return _elems; }
				set { _elems = value; }
			}

			public void Add(ElemRozliczeniaVAT elem)
			{ _elems.Add(elem); }
		}


		[Context, Required]
		public Parameters Params { get; set; }


		public class Parameters : ContextBase
		{
			private bool _blokD2;
			private bool _blokC;

			public Parameters(Context cx)
				: base(cx)
			{
				_blokC = _blokD2 = true;
				Pole10 = Pole11 = Pole12 = Pole13 = Pole14 = Pole1516 = Pole1718 = Pole1920 = Pole21 = Pole22 = Pole2324 = Pole2526 = Pole2728 = Pole2930 = Pole31 = Pole3233 = Pole3435 = true;
				Pole4243 = Pole4445 = true;
			}

			[Priority(10)]
			[Caption("Blok C")]
			[Category("VAT-7 (16) - BLOK C")]
			public bool BlokC
			{
				get { return _blokC; }
				set { _blokC = value; OnChanged(); }
			}

			[Priority(20)]
			[Caption(" ... Pole 10")]
			public bool Pole10 { get; set; }

			[Priority(30)]
			[Caption(" ... Pole 11")]
			public bool Pole11 { get; set; }

			[Priority(40)]
			[Caption(" ... Pole 12")]
			public bool Pole12 { get; set; }

			[Priority(50)]
			[Caption(" ... Pole 13")]
			public bool Pole13 { get; set; }

			[Priority(60)]
			[Caption(" ... Pole 14")]
			public bool Pole14 { get; set; }

			[Priority(70)]
			[Caption(" ... Pole 15, 16")]
			public bool Pole1516 { get; set; }

			[Priority(80)]
			[Caption(" ... Pole 17, 18")]
			public bool Pole1718 { get; set; }

			[Priority(90)]
			[Caption(" ... Pole 19, 20")]
			public bool Pole1920 { get; set; }

			[Priority(100)]
			[Caption(" ... Pole 21")]
			public bool Pole21 { get; set; }

			[Priority(110)]
			[Caption(" ... Pole 22")]
			public bool Pole22 { get; set; }

			[Priority(120)]
			[Caption(" ... Pole 23, 24")]
			public bool Pole2324 { get; set; }

			[Priority(130)]
			[Caption(" ... Pole 25, 26")]
			public bool Pole2526 { get; set; }

			[Priority(140)]
			[Caption(" ... Pole 27, 28")]
			public bool Pole2728 { get; set; }

			[Priority(150)]
			[Caption(" ... Pole 29, 30")]
			public bool Pole2930 { get; set; }

			[Priority(160)]
			[Caption(" ... Pole 31")]
			public bool Pole31 { get; set; }

			[Priority(170)]
			[Caption(" ... Pole 32, 33")]
			public bool Pole3233 { get; set; }

			[Priority(180)]
			[Caption(" ... Pole 34, 35")]
			public bool Pole3435 { get; set; }

			[Priority(200)]
			[Caption("Blok D.2")]
			[Category("VAT-7 (16) - BLOK D.2")]
			public bool BlokD2
			{
				get { return _blokD2; }
				set { _blokD2 = value; OnChanged(); }
			}

			[Priority(210)]
			[Caption(" ... Pole 42, 43")]
			public bool Pole4243 { get; set; }

			[Priority(220)]
			[Caption(" ... Pole 44, 45")]
			public bool Pole4445 { get; set; }


			public bool IsReadOnlyPole10() { return !_blokC; }
			public bool IsReadOnlyPole11() { return !_blokC; }
			public bool IsReadOnlyPole12() { return !_blokC; }
			public bool IsReadOnlyPole13() { return !_blokC; }
			public bool IsReadOnlyPole14() { return !_blokC; }
			public bool IsReadOnlyPole1516() { return !_blokC; }
			public bool IsReadOnlyPole1718() { return !_blokC; }
			public bool IsReadOnlyPole1920() { return !_blokC; }
			public bool IsReadOnlyPole21() { return !_blokC; }
			public bool IsReadOnlyPole22() { return !_blokC; }
			public bool IsReadOnlyPole2324() { return !_blokC; }
			public bool IsReadOnlyPole2526() { return !_blokC; }
			public bool IsReadOnlyPole2728() { return !_blokC; }
			public bool IsReadOnlyPole2930() { return !_blokC; }
			public bool IsReadOnlyPole31() { return !_blokC; }
			public bool IsReadOnlyPole3233() { return !_blokC; }
			public bool IsReadOnlyPole3435() { return !_blokC; }

			public bool IsReadOnlyPole4243() { return !_blokD2; }
			public bool IsReadOnlyPole4445() { return !_blokD2; }
		}

		
    </script>
</head>
<body>
	<form id="VAT_7_16_Info" method="post" runat="server">
		<ea:datacontext id="DataContext1" runat="server" oncontextload="VAT_7_16_Info_OnLoad" typename="Soneta.Deklaracje.VAT.VAT7_16,Soneta.Deklaracje"></ea:datacontext>
		<cc1:reportheader id="ReportHeader1" title="Zestawienie VAT-7(16) {0}" runat="server" datamember0="Numer.NumerPelny"></cc1:reportheader>

		<ea:section id="SectionOfBlokC1" runat="server" width="100%">
			<span style='font-size: 11pt; font-weight: bold; display: block; margin: 5mm 0'>Blok C</span>
		</ea:section>

		<ea:datarepeater id="SectionOfBlokC2" withsections="False" runat="server">
			<span style="font-size: 9pt; font-weight: normal; display: block; margin: 3mm 0 1mm 0;"><ea:DataLabel runat="server" DataMember="Name" Bold="False" /></span>
				
			<ea:Grid runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega" DataMember="Elems" >
				<Columns>
					<ea:GridColumn Width="5" DataMember="#" Caption="Lp" />
					<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" />
					<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" />
					<ea:GridColumn Width="10" DataMember="Data" Caption="Data" Total="Info" />
					<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}" Total="Sum" />
					<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" Total="Sum" />
				</Columns>
			</ea:Grid>
		</ea:datarepeater>
		
		<ea:section id="SectionOfBlokD1" runat="server" width="100%">
			<span style='font-size: 11pt; font-weight: bold; display: block; margin: 5mm 0'>Blok D.2</span>
		</ea:section>

		<ea:datarepeater id="SectionOfBlokD2" withsections="False" runat="server">
			<span style="font-size: 9pt; font-weight: normal; display: block; margin: 3mm 0 1mm 0;"><ea:DataLabel runat="server" DataMember="Name" Bold="False" /></span>
				
			<ea:Grid runat="server" RowTypeName="Soneta.EwidencjaVat.ElemRozliczeniaVAT,Soneta.Ksiega" DataMember="Elems" >
				<Columns>
					<ea:GridColumn Width="5" DataMember="#" Caption="Lp" />
					<ea:GridColumn DataMember="NumerEwidencji" Caption="Ewidencja" />
					<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" />
					<ea:GridColumn Width="10" DataMember="Data" Caption="Data" Total="Info" />
					<ea:GridColumn Width="25" Align="Right" DataMember="Netto.Value" Caption="Netto" Format="{0:n}" Total="Sum" />
					<ea:GridColumn Width="20" Align="Right" DataMember="VAT.Value" Caption="VAT" Format="{0:n}" Total="Sum" />
				</Columns>
			</ea:Grid>
		</ea:datarepeater>

		<cc1:reportfooter runat="server">
			<subtitles>
				<cc1:FooterSubtitle SubtitleType="Operator" />
			</subtitles>
		</cc1:reportfooter>
	</form>
</body>
</html>

