﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="65001" %>
<%@ import Namespace="Soneta.Deklaracje.PIT" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Core" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>ZAP 3(1)</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">

        public class Params : ContextBase {
            public readonly PracHistoria historia;
            public Params(Context context) : base(context) {
                historia = (PracHistoria)context[typeof(PracHistoria)];
                foreach (RachunekBankowyPracownika rbp in historia.Pracownik.Rachunki)
                    if (!rbp.Blokada) {
                        rachunek = rbp;
                        break;
                    }
            }
            RachunekBankowyPracownika rachunek;
            [Caption("Rachunek bankowy")]
            [Priority(50)]
            public RachunekBankowyPracownika Rachunek {
                get { return rachunek; }
                set {
                    rachunek = value;
                    if (rachunek != null)
                        rezygnacja = false;
                    OnChanged(EventArgs.Empty);
                }
            }
            public LookupInfo.Item GetListRachunek() {
                return Soneta.Kasa.RachBankPodmiot.RachunkiPodmiotuLookup(historia.Pracownik);
            }
            bool rezygnacja;
            [Caption("Rezygnacja")]
            [Priority(60)]
            public bool Rezygnacja {
                get { return rezygnacja; }
                set {
                    rezygnacja = value;
                    OnChanged(EventArgs.Empty);
                }
            }
            public bool IsReadOnlyRezygnacja() {
                return rachunek != null;
            }
        }
		Params info;
        [Context]
        public Params Info {
            set { info = value; }
        }
        void OnContextLoad(object sender, EventArgs e) {
            if (dc.OverPrint) {
                dc.LeftMargin = 6;
                dc.TopMargin = 6;
                dc.PageZoom = "114%";
            }
            PracHistoria prev = (PracHistoria)info.historia.Pracownik.Historia.GetPrev(info.historia);
            if (info.Rezygnacja)
                rachunekRezygnacja.EditValue = true;
            else if (info.Rachunek != null) {
                Soneta.Kasa.RachunekBankowy rb = info.Rachunek.Rachunek;
                if (rb.Bank != null) {
                    if (rb.Bank.Adres.Kraj != "" && rb.Bank.Adres.Kraj.ToLower() != "polska")
                        rachunekKraj.EditValue = rb.Bank.Adres.Kraj;
                    rachunekNazwaBanku.EditValue = rb.Bank.Nazwa;
                }
                if (info.Rachunek.Nazwa1 != "")
                    rachunekPosiadacz.EditValue = info.Rachunek.Nazwa1 + ", " + info.Rachunek.Nazwa2;
                else
                    rachunekPosiadacz.EditValue = info.historia.Pracownik.ImięNazwisko + ", " + info.historia.Adres.Linia1 + ", " + info.historia.Adres.Linia2;
                rachunekNumer.EditValue = rb.Numer;
            }
            if (info.historia.Podatki.NaPITAdresZameldowania ||
                info.historia.AdresZamieszkania.Wojewodztwo.ToString() == "nieokreślone") {
                AdresKraj.EditValue = info.historia.AdresZameldowania.Kraj;
                AdresWojewodztwo.EditValue = info.historia.AdresZameldowania.Wojewodztwo;
                AdresPowiat.EditValue = info.historia.AdresZameldowania.Powiat;
                AdresGmina.EditValue = info.historia.AdresZameldowania.Gmina;
                AdresUlica.EditValue = info.historia.AdresZameldowania.Ulica;
                AdresNrDomu.EditValue = info.historia.AdresZameldowania.NrDomu;
                AdresNrLokalu.EditValue = info.historia.AdresZameldowania.NrLokalu;
                AdresMiejscowosc.EditValue = info.historia.AdresZameldowania.Miejscowosc;
                AdresKodPocztowy.EditValue = info.historia.AdresZameldowania.KodPocztowy;
                AdresPoczta.EditValue = info.historia.AdresZameldowania.Poczta;
                AdresTelefon.EditValue = info.historia.AdresZameldowania.Telefon;
            }
            else {
                AdresKraj.EditValue = info.historia.AdresZamieszkania.Kraj;
                AdresWojewodztwo.EditValue = info.historia.AdresZamieszkania.Wojewodztwo;
                AdresPowiat.EditValue = info.historia.AdresZamieszkania.Powiat;
                AdresGmina.EditValue = info.historia.AdresZamieszkania.Gmina;
                AdresUlica.EditValue = info.historia.AdresZamieszkania.Ulica;
                AdresNrDomu.EditValue = info.historia.AdresZamieszkania.NrDomu;
                AdresNrLokalu.EditValue = info.historia.AdresZamieszkania.NrLokalu;
                AdresMiejscowosc.EditValue = info.historia.AdresZamieszkania.Miejscowosc;
                AdresKodPocztowy.EditValue = info.historia.AdresZamieszkania.KodPocztowy;
                AdresPoczta.EditValue = info.historia.AdresZamieszkania.Poczta;
                AdresTelefon.EditValue = info.historia.AdresZamieszkania.Telefon;
            }
            KontaktEMAIL.EditValue = info.historia.Kontakt.EMAIL;
        }
        
        static void Msg(object value) {
        }
		    
    </script>
	</HEAD>
	<body leftMargin="0" rightMargin="0">
		<form id="ZAP_3" method="post" runat="server">
			<ea:deklaracjaheader id="DeklaracjaHeader1" style="Z-INDEX: 100; LEFT: 0px; POSITION: absolute; TOP: 0px"
				runat="server" Width="630px" StylNagłówka="WypałniaSkładającyCRP"></ea:deklaracjaheader>
<ea:framelabel id="FrameLabel21" style="Z-INDEX: 101; LEFT: 0px; POSITION: absolute; TOP: 21px"
				runat="server" Width="273px" ValueStyle="nip_w" DataMember="PESEL" Height="28px" 
                Text="1. Identyfikator podatkowy numer PESEL"></ea:framelabel>
<ea:framelabel id="FrameLabel22" style="Z-INDEX: 102; LEFT: 273px; POSITION: absolute; TOP: 21px"
				runat="server" Width="119px" Height="28px" Text="Nr dokumentu" FrameStyle="SmallBoldGray" Number="2"></ea:framelabel>
<ea:framelabel id="FrameLabel23" style="Z-INDEX: 103; LEFT: 392px; POSITION: absolute; TOP: 21px"
				runat="server" Width="77px" Height="30px" Text="Status" FrameStyle="SmallBoldGray" Number="3"></ea:framelabel>
<ea:framelabel id="FrameLabel34" style="Z-INDEX: 104; LEFT: 55px; POSITION: absolute; TOP: 62px; height: 21px;"
				runat="server" Width="565px" 
                Text="ZGŁOSZENIE AKTUALIZACYJNE OSOBY FIZYCZNEJ BĘDĄCEJ PODATNIKIEM" 
                FrameStyle="BigBold" FrameBorderStyle="None" HorizontalAlign="Center"></ea:framelabel>
<ea:framelabel id="labelPIT" 
                style="Z-INDEX: 105; LEFT: 5px; POSITION: absolute; TOP: 62px; width: 71px; right: 821px;" 
                runat="server" Height="21px" FrameStyle="BigBold" FrameBorderStyle="None" 
                Text="ZAP-3"></ea:framelabel>
<ea:framelabel id="FrameLabel24" style="Z-INDEX: 106; LEFT: 0px; POSITION: absolute; TOP: 90px; height: 105px;"
				runat="server" Width="630px" FrameStyle="SmallBoldYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel27" style="Z-INDEX: 107; LEFT: 7px; POSITION: absolute; TOP: 92px; right: 799px;"
				runat="server" Width="600px" Height="80px"
                Text="&lt;b&gt;Formularz przeznaczony dla osoby fizycznej, spełniającej łącznie poniższe kryteria:&lt;br&gt;
                - jest objęta rejestrem PESEL&lt;br&gt;
                - nie prowadzi działalności gospodarczej&lt;br&gt;
                - nie jest zarejestrowanym podatnikiem podatku od towarów i usług&lt;br&gt;
                - nie jest płatnikiem podatków&lt;br&gt;
                - nie jest płatnikiem składek na ubezpieczenia społeczne oraz ubezpieczenia zdrowotne&lt;br&gt;
                &lt;/b&gt;
                Formularz służy do zgłoszenia: aktualnego adresu miejsca zamieszkania (część B.2), danych kontaktowych (część B.3)
                oraz informacji dotyczących osobistego rachunku (część B.4)."
                FrameStyle="SmallYellow" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="FrameLabel30" style="Z-INDEX: 108; LEFT: 0px; POSITION: absolute; TOP: 174px"
				runat="server" Width="630px" Height="20px"
                Text="Podstawa prawna: Ustawa z dnia 13 października 1995 r. o zasadach ewidencji i identyfikacji podatników
                (Dz.U. z 2004 r. Nr 269, poz.2681, z późn.zm.) - zgodnie z art.9 ust 1d." 
                FrameStyle="SmallBoldGray"></ea:framelabel>
<ea:framelabel id="FrameLabel17" style="Z-INDEX: 109; LEFT: 0px; POSITION: absolute; TOP: 198px; height: 46px;"
				runat="server" Width="630px" Text="A. MIEJSCE ZŁOŻENIA ZGŁOSZENIA" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="p6" style="Z-INDEX: 110; LEFT: 28px; POSITION: absolute; TOP: 219px; width: 601px;"
				runat="server" Height="30px" 
                Text="Naczelnik urzędu skarbowego, do którego jest adresowane zgłoszenie" Number="4" 
                DataMember="Podatki.UrzadSkarbowy.Nazwa"></ea:framelabel>
<ea:framelabel id="FrameLabel1" style="Z-INDEX: 111; LEFT: 0px; POSITION: absolute; TOP: 250px"
				runat="server" Width="630px" Height="15px" Text="B. DANE SKŁADAJĄCEGO" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel2" style="Z-INDEX: 112; LEFT: 0px; POSITION: absolute; TOP: 264px; height: 50px;"
				runat="server" Width="630px" Text="B.1. DANE IDENTYFIKACYJNE" FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="FrameLabel4" style="Z-INDEX: 113; LEFT: 28px; POSITION: absolute; TOP: 285px; height: 30px; width: 301px;"
				runat="server" DataMember="Nazwisko" Text="Nazwisko" Number="5"></ea:framelabel>
<ea:framelabel id="FrameLabel6" style="Z-INDEX: 114; LEFT: 329px; POSITION: absolute; TOP: 285px; right: 751px; width: 301px;"
				runat="server" DataMember="Imie" Height="28px" Text="Pierwsze imię" Number="6"></ea:framelabel>
<ea:framelabel id="Framelabel101" style="Z-INDEX: 115; LEFT: 0px; POSITION: absolute; TOP: 313px; height: 105px;"
				runat="server" Width="630px" Text="B.2. AKTUALNY ADRES MIEJSCA ZAMIESZKANIA" 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 116; LEFT: 28px; POSITION: absolute; TOP: 334px"
				runat="server" Width="140px" ID="AdresKraj" Height="28px" Text="Kraj" 
                Number="7" CssClass="style1"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 117; LEFT: 168px; POSITION: absolute; TOP: 334px"
				runat="server" Width="266px" ID="AdresWojewodztwo" Height="28px" 
                Text="Województwo" Number="8"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 118; LEFT: 434px; POSITION: absolute; TOP: 334px"
				runat="server" Width="196px" ID="AdresPowiat" Height="28px" Text="Powiat" 
                Number="9"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 119; LEFT: 28px; POSITION: absolute; TOP: 362px"
				runat="server" Width="161px" ID="AdresGmina" Height="28px" Text="Gmina" 
                Number="10"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 120; LEFT: 189px; POSITION: absolute; TOP: 362px"
				runat="server" Width="301px" ID="AdresUlica" Height="28px" Text="Ulica" 
                Number="11"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 121; LEFT: 490px; POSITION: absolute; TOP: 362px"
				runat="server" Width="70px" ID="AdresNrDomu" Height="28px" Text="Nr domu" 
                Number="12"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 122; LEFT: 560px; POSITION: absolute; TOP: 362px"
				runat="server" Width="70px" ID="AdresNrLokalu" Height="28px" Text="Nr lokalu" 
                Number="13"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 123; LEFT: 28px; POSITION: absolute; TOP: 390px; right: 639px;"
				runat="server" Width="252px" ID="AdresMiejscowosc" Height="28px" Text="Miejscowość" 
                Number="14"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 124; LEFT: 280px; POSITION: absolute; TOP: 390px; "
				runat="server" Width="105px" ValueStyle="PostalCode" ID="AdresKodPocztowy" 
                Height="28px" Text="Kod pocztowy" Number="15" CssClass="style1"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 125; LEFT: 385px; POSITION: absolute; TOP: 390px; height: 30px;"
				runat="server" Width="245px" ID="AdresPoczta" Text="Poczta" Number="16"></ea:framelabel>
<ea:framelabel id="Framelabel3" style="Z-INDEX: 126; LEFT: 0px; POSITION: absolute; TOP: 418px; height: 50px;"
				runat="server" Width="630px" Text="B.3. KONTAKT" 
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 127; LEFT: 28px; POSITION: absolute; TOP: 439px; height: 30px; width: 301px;"
				runat="server" ID="AdresTelefon" Text="Telefon" Number="17"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 128; LEFT: 329px; POSITION: absolute; TOP: 439px; right: 751px; width: 301px;"
				runat="server" ID="KontaktEMAIL" Height="28px" Text="E-mail" Number="18"></ea:framelabel>
<ea:framelabel id="FrameLabel162" style="Z-INDEX: 129; LEFT: 0px; POSITION: absolute; TOP: 467px; height: 157px; right: 289px;"
				runat="server" Width="630px" Text="B.4. OSOBISTY RACHUNEK DO ZWROTU NADPŁATY LUB PODATKU&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Podanie informacji o rachunku bankowym (poz. 19-23) nie jest obowiązkowe, jeżeli składający nie wybiera tej formy zwrotu nadpłaty podatku. Na wskazany rachunek będą dokonywane ewentualne zwroty nadpłaty podatku. Można podać jedynie taki rachunek, którego właścicielem lub współwłaścicielem jest składający. Wpisane niżej dane dotyczące rachunku aktualizują poprzedni stan danych.
                Zaznaczenie kwadratu w poz.23 oznacza rezygnację przez składającego 
                z otrzymywania ewentualnego zwrotu nadpłaty lub podatku dochodowego na rachunek osobisty (również z powodu likwidacji rachunku). Kraj siedziby banku (oddziału) (poz.19) należy podać, gdy rachunek jest prowadzony za granicą."
                FrameStyle="BigYellow"></ea:framelabel>
<ea:framelabel id="rachunekKraj" style="Z-INDEX: 130; LEFT: 28px; POSITION: absolute; TOP: 537px; right: 632px; width: 258px;"
				runat="server" Height="28px" Text="Kraj siedziby banku (oddziału)" 
                Number="19"></ea:framelabel>
<ea:framelabel id="rachunekNazwaBanku" style="Z-INDEX: 131; LEFT: 287px; POSITION: absolute; TOP: 537px; right: 534px; width: 343px;"
				runat="server" 
                Height="28px" Text="Pełna nazwa banku (oddziału) / SKOK" Number="20"></ea:framelabel>
<ea:framelabel id="rachunekPosiadacz" style="Z-INDEX: 132; LEFT: 28px; POSITION: absolute; TOP: 565px; width: 599px;"
				runat="server" Height="28px" Text="Posiadacz rachunku" 
                Number="21"></ea:framelabel>
<ea:framelabel id="rachunekNumer" style="Z-INDEX: 133; LEFT: 28px; POSITION: absolute; TOP: 593px; width: 530px;"
				runat="server" Height="28px" Text="Pełny numer rachunku" 
                Number="22"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 134; LEFT: 560px; POSITION: absolute; TOP: 593px"
				runat="server" Width="70px" Height="28px" Text="Rezygnacja" 
                Number="23"></ea:framelabel>
<ea:checklabel id="rachunekRezygnacja" style="Z-INDEX: 135; LEFT: 578px; POSITION: absolute; TOP: 602px; right: 382px;"
				runat="server" Width="35px" Height="14px"></ea:checklabel>
<ea:framelabel id="Framelabel121" style="Z-INDEX: 136; LEFT: 0px; POSITION: absolute; TOP: 624px; width: 630px; height: 156px;"
				runat="server" 
                Text="C. &lt;font size=2&gt;PODPIS SKŁADAJĄCEGO/DANE I PODPIS OSOBY REPREZENTUJĄCEJ SKŁADAJĄCEGO&lt;/font&gt;&lt;br&gt;&lt;.Footer&gt;Osobą reprezentującą składającego może być jedynie osoba uprawniona do reprezentowania, np. opiekun prawny, kurator, pełnomocnik określony w pełnomocnictwie. Poz. 24-27 wypełnić jedynie w przypadku osoby reprezentującej składającego.&lt;./&gt;" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="Framelabel177" style="Z-INDEX: 137; LEFT: 28px; POSITION: absolute; TOP: 666px; width: 301px;"
				runat="server" Height="28px" Text="Imię" Number="24"></ea:framelabel>
<ea:framelabel id="Framelabel181" style="Z-INDEX: 138; LEFT: 329px; POSITION: absolute; TOP: 666px; width: 301px; right: 485px;"
				runat="server" Height="28px" Text="Nazwisko" Number="25"></ea:framelabel>
<ea:framelabel id="Framelabel178" style="Z-INDEX: 139; LEFT: 28px; POSITION: absolute; TOP: 694px; width: 600px;"
				runat="server" Height="28px" Text="Identyfikator podatkowy NIP / numer PESEL&lt;.Normal&gt;(niepotrzebne skreślić)&lt;./&gt;" Number="26"></ea:framelabel>
<ea:framelabel id="Framelabel166" style="Z-INDEX: 140; LEFT: 28px; POSITION: absolute; TOP: 722px; right: 632px; width: 599px;"
				runat="server" Height="28px" Text="Adres do korespondencji" 
                Number="27"></ea:framelabel>
<ea:framelabel id="Framelabel180" style="Z-INDEX: 141; LEFT: 28px; POSITION: absolute; TOP: 750px; width: 225px; right: 619px;"
				runat="server" Height="28px" Text="Data wypełnienia zgłoszenia" Number="28" 
                ValueStyle="Date"></ea:framelabel>
<ea:framelabel id="Framelabel137" style="Z-INDEX: 142; LEFT: 252px; POSITION: absolute; TOP: 750px; width: 378px; right: 485px;"
				runat="server" Height="28px" 
                Text="Podpis składającego/osoby reprezentującej składającego&lt;.Normal&gt;(niepotrzebne skreślić)&lt;./&gt;" 
                Number="29"></ea:framelabel>
<ea:framelabel id="FrameLabel127" style="Z-INDEX: 143; LEFT: 0px; POSITION: absolute; TOP: 781px; height: 112px;"
				runat="server" Width="630px" Text="D. ADNOTACJE URZĘDU SKARBOWEGO" 
                FrameStyle="BigYellowBold"></ea:framelabel>
<ea:framelabel id="FrameLabel130" style="Z-INDEX: 144; LEFT: 28px; POSITION: absolute; TOP: 809px; height: 29px;"
				runat="server" Width="602px" Text="Uwagi urzędu skarbowego" 
                FrameStyle="SmallBoldGray" Number="30"></ea:framelabel>
<ea:framelabel id="FrameLabel128" style="Z-INDEX: 145; LEFT: 28px; POSITION: absolute; TOP: 837px; right: 511px; height: 26px;"
				runat="server" Width="301px" 
                Text="Identyfikator przyjmującego formularz" FrameStyle="SmallBoldGray" 
                Number="31"></ea:framelabel>
<ea:framelabel id="FrameLabel129" style="Z-INDEX: 146; LEFT: 329px; POSITION: absolute; TOP: 837px; height: 31px;"
				runat="server" Width="301px" Text="Podpis przyjmującego formularz" 
                FrameStyle="SmallBoldGray" Number="32"></ea:framelabel>
<ea:framelabel id="FrameLabel171" style="Z-INDEX: 147; LEFT: 28px; POSITION: absolute; TOP: 865px; right: 602px; width: 213px; height: 29px;"
				runat="server" Text="Data rejestracji w systemie" 
                FrameStyle="SmallBoldGray" Number="33" ValueStyle="Date"></ea:framelabel>
<ea:framelabel id="FrameLabel172" style="Z-INDEX: 148; LEFT: 238px; POSITION: absolute; TOP: 865px; right: 420px; width: 179px; height: 27px;"
				runat="server" Text="Identyfikator rejestrującego formularz w systemie" 
                FrameStyle="SmallBoldGray" Number="34"></ea:framelabel>
<ea:framelabel id="FrameLabel173" style="Z-INDEX: 149; LEFT: 420px; POSITION: absolute; TOP: 865px; right: 590px; width: 210px; height: 27px;"
				runat="server" Text="Podpis rejestrującego formularz w systemie" 
                FrameStyle="SmallBoldGray" Number="35"></ea:framelabel>
<ea:deklaracjafooter id="footer2" 
                style="Z-INDEX: 150; LEFT: 489px; POSITION: absolute; TOP: 900px" runat="server"
				TitleWidth="106" Symbol="ZAP-3" PageNumber="1" PageTotal="1" Version="1"></ea:deklaracjafooter>
<ea:datacontext id="dc" style="Z-INDEX: 151; LEFT: 189px; POSITION: absolute; TOP: 900px" runat="server"
				TypeName="Soneta.Kadry.PracHistoria,Soneta.KadryPlace" oncontextload="OnContextLoad" 
                LeftMargin="15" PageHeight="977px" PageZoom="107%"></ea:datacontext>
</form>
	</body>
</HTML>
