﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.CIT" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>

<script runat="server">


void OnContextLoad(Object sender, EventArgs args)
{
	var dek = (CIT10Z)dc[typeof(CIT10Z)];
	ORD_ZU.Visible = dek.TreśćUzasadnienia != "";

	bool osobaFizyczna = (bool)dek.Bloki["C1"]["OsobaFiz"];
	string[] nazwa = PIT.DaneFirmy((string)dek.Bloki["C1"]["Nazwa"], osobaFizyczna);

	if (osobaFizyczna) 
	{
		OsobaNieFizyczna.Visible = false;
		if (nazwa.Length > 0)
			Nazwisko.EditValue = nazwa[0].Trim();
		if (nazwa.Length > 1)
			ImiePierwsze.EditValue = nazwa[1].Trim();
		if (nazwa.Length > 2)
			DataUrodzenia.EditValue = nazwa[2].Trim();
	}
	else
	{
		OsobaFizyczna.Visible = false;
		if (nazwa.Length > 0)
			NazwaPelna.EditValue = nazwa[0].Trim();
		if (nazwa.Length > 1)
			REGON.EditValue = nazwa[1].Trim();
	}

	var kraj = ((string)dek.Bloki["C2"]["Kraj"]).ToUpper();
	if (kraj == "" || kraj == "POLSKA")
		AdresZagrPl.Visible = false;
	else
		AdresPolPl.Visible = false;
}


</script>

<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.CIT.CIT10Z,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja 
	xmlns="http://crd.gov.pl/wzor/2015/02/06/2035/" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://crd.gov.pl/wzor/2015/02/06/2035/ http://crd.gov.pl/wzor/2015/02/06/2035/schemat.xsd"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/06/21/eD/DefinicjeTypy/"
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/10/07/eD/ORDZU/" >
	<Naglowek>
		<KodFormularza kodSystemowy="CIT10Z (2)" kodPodatku="CIT" rodzajZobowiazania="P" wersjaSchemy="1-0E">CIT-10Z</KodFormularza>
		<WariantFormularza>2</WariantFormularza>
		<CelZlozenia poz="P_7"><ea:XmlDataLabel runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<OkresOd poz="P_4"><ea:XmlDataLabel runat="server" DataMember="0.Od" XSDType="TData" ></ea:XmlDataLabel></OkresOd>
		<OkresDo poz="P_5"><ea:XmlDataLabel runat="server" DataMember="0.Do" XSDType="TData" ></ea:XmlDataLabel></OkresDo>
		<ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
	</Naglowek>
	<Podmiot1 rola="Płatnik">
		<ea:Section ID="OsobaFizyczna" runat="server">
			<etd:OsobaFizyczna>
				<ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
				<ea:XmlDataLabel ElementName="etd:ImiePierwsze" ID="ImiePierwsze" runat="server" XSDType="TImie" />
				<ea:XmlDataLabel ElementName="etd:Nazwisko" ID="Nazwisko" runat="server" XSDType="TNazwisko" />
				<ea:XmlDataLabel ElementName="etd:DataUrodzenia" ID="DataUrodzenia" runat="server" XSDType="TData" />
			</etd:OsobaFizyczna>
		</ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server">
			<etd:OsobaNiefizyczna>
				<ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
				<ea:XmlDataLabel ElementName="etd:PelnaNazwa" ID="NazwaPelna" runat="server" XSDType="TZnakowy" />
				<ea:XmlDataLabel ElementName="etd:REGON" ID="REGON" runat="server" XSDType="TNrREGON" />
			</etd:OsobaNiefizyczna>
		</ea:Section>
		<AdresZamieszkaniaSiedziby rodzajAdresu="RAD">
			<ea:Section ID="AdresPolPl" runat="server">
			<etd:AdresPol>
				<etd:KodKraju>PL</etd:KodKraju>
				<ea:XmlDataLabel ElementName="etd:Wojewodztwo" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin" />
				<ea:XmlDataLabel ElementName="etd:Powiat" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="etd:Gmina" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="etd:Ulica" runat="server" HideEmptyOrZero="true" DataMember="C2.Ulica" XSDType="TUlica"/>
				<ea:XmlDataLabel ElementName="etd:NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/>
				<ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" HideEmptyOrZero="true" DataMember="C2.NrLokalu" XSDType="TNrLokalu"/>
				<ea:XmlDataLabel ElementName="etd:Miejscowosc" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
				<ea:XmlDataLabel ElementName="etd:KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/>
				<ea:XmlDataLabel ElementName="etd:Poczta" runat="server" DataMember="C2.Poczta" XSDType="TMiejscowosc"/>
			</etd:AdresPol>
			</ea:Section>
			<ea:Section ID="AdresZagrPl" runat="server">
			<etd:AdresZagr>
				<ea:XmlDataLabel ElementName="etd:KodKraju" runat="server" DataMember="C2.KodKrajuPl" XSDType="TTekstowy"/>
				<ea:XmlDataLabel ElementName="etd:KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
				<ea:XmlDataLabel ElementName="etd:Miejscowosc" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
				<ea:XmlDataLabel ElementName="etd:Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
				<ea:XmlDataLabel ElementName="etd:NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
				<ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
			</etd:AdresZagr>
			</ea:Section>
		</AdresZamieszkaniaSiedziby>
		<ea:XmlDataLabel ElementName="InneNiezbedneOznaczenia" PozAttribute="P_22" runat="server" DataMember="X.AdresPlatnikaInne" XSDType="TZnakowy" HideEmptyOrZero="true"/>
	</Podmiot1>	
	<PozycjeSzczegolowe>
		<ea:XmlDataLabel runat="server" ElementName="P_8" DataMember="B.Przychody"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_9" DataMember="B.Dywidendy"><ValuesMap><ea:ValuesPair Key="False" Value="0" /><ea:ValuesPair Key="True" Value="1"/></ValuesMap></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_23" DataMember="D1.OdsetkiKwota"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_24" DataMember="D1.OdsetkiPodatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_25" DataMember="D1.PrawaKwota"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_26" DataMember="D1.PrawaPodatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_27" DataMember="D1.WidowiskowaKwota"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_28" DataMember="D1.WidowiskowaPodatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_29" DataMember="D1.DoradczeKwota"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_30" DataMember="D1.DoradczePodatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_31" DataMember="D1.MorskaKwota"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_32" DataMember="D1.MorskaPodatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_33" DataMember="D1.PowietrznaKwota"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_34" DataMember="D1.PowietrznaPodatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_35" DataMember="D1.RazemKwota"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_36" DataMember="D1.RazemPodatek"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_37" DataMember="D2.1Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_43" DataMember="D2.1Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_49" DataMember="D2.1Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_55" DataMember="D2.1Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_38" DataMember="D2.2Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_44" DataMember="D2.2Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_50" DataMember="D2.2Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_56" DataMember="D2.2Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_39" DataMember="D2.3Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_45" DataMember="D2.3Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_51" DataMember="D2.3Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_57" DataMember="D2.3Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_40" DataMember="D2.4Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_46" DataMember="D2.4Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_52" DataMember="D2.4Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_58" DataMember="D2.4Kwota"></ea:XmlDataLabel>

		<ea:XmlDataLabel runat="server" ElementName="P_41" DataMember="D2.5Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_47" DataMember="D2.5Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_53" DataMember="D2.5Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_59" DataMember="D2.5Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_42" DataMember="D2.6Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_48" DataMember="D2.6Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_54" DataMember="D2.6Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_60" DataMember="D2.6Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_61" DataMember="D2.7Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_67" DataMember="D2.7Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_73" DataMember="D2.7Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_79" DataMember="D2.7Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_62" DataMember="D2.8Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_68" DataMember="D2.8Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_74" DataMember="D2.8Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_80" DataMember="D2.8Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_63" DataMember="D2.9Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_69" DataMember="D2.9Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_75" DataMember="D2.9Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_81" DataMember="D2.9Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_64" DataMember="D2.10Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_70" DataMember="D2.10Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_76" DataMember="D2.10Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_82" DataMember="D2.10Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_65" DataMember="D2.11Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_71" DataMember="D2.11Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_77" DataMember="D2.11Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_83" DataMember="D2.11Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_66" DataMember="D2.12Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_72" DataMember="D2.12Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_78" DataMember="D2.12Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_84" DataMember="D2.12Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_85" DataMember="D2.13Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_91" DataMember="D2.13Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_97" DataMember="D2.13Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_103" DataMember="D2.13Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_86" DataMember="D2.14Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_92" DataMember="D2.14Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_98" DataMember="D2.14Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_104" DataMember="D2.14Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_87" DataMember="D2.15Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_93" DataMember="D2.15Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_99" DataMember="D2.15Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_105" DataMember="D2.15Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_88" DataMember="D2.16Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_94" DataMember="D2.16Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_100" DataMember="D2.16Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_106" DataMember="D2.16Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_89" DataMember="D2.17Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_95" DataMember="D2.17Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_101" DataMember="D2.17Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_107" DataMember="D2.17Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_90" DataMember="D2.18Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_96" DataMember="D2.18Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_102" DataMember="D2.18Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_108" DataMember="D2.18Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_109" DataMember="D2.19Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_115" DataMember="D2.19Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_121" DataMember="D2.19Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_127" DataMember="D2.19Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_110" DataMember="D2.20Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_116" DataMember="D2.20Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_122" DataMember="D2.20Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_128" DataMember="D2.20Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_111" DataMember="D2.21Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_117" DataMember="D2.21Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_123" DataMember="D2.21Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_129" DataMember="D2.21Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_112" DataMember="D2.22Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_118" DataMember="D2.22Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_124" DataMember="D2.22Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_130" DataMember="D2.22Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_113" DataMember="D2.23Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_119" DataMember="D2.23Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_125" DataMember="D2.23Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_131" DataMember="D2.23Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_114" DataMember="D2.RazemDochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_120" DataMember="D2.RazemPodatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_126" DataMember="D2.RazemWynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_132" DataMember="D2.RazemKwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_133" DataMember="E1.Kwota"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_134" DataMember="E1.Podatek"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_135" DataMember="E2.1Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_141" DataMember="E2.1Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_147" DataMember="E2.1Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_153" DataMember="E2.1Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_136" DataMember="E2.2Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_142" DataMember="E2.2Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_148" DataMember="E2.2Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_154" DataMember="E2.2Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_137" DataMember="E2.3Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_143" DataMember="E2.3Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_149" DataMember="E2.3Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_155" DataMember="E2.3Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_138" DataMember="E2.4Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_144" DataMember="E2.4Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_150" DataMember="E2.4Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_156" DataMember="E2.4Kwota"></ea:XmlDataLabel>

		<ea:XmlDataLabel runat="server" ElementName="P_139" DataMember="E2.5Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_145" DataMember="E2.5Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_151" DataMember="E2.5Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_157" DataMember="E2.5Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_140" DataMember="E2.6Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_146" DataMember="E2.6Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_152" DataMember="E2.6Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_158" DataMember="E2.6Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_159" DataMember="E2.7Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_165" DataMember="E2.7Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_171" DataMember="E2.7Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_177" DataMember="E2.7Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_160" DataMember="E2.8Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_166" DataMember="E2.8Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_172" DataMember="E2.8Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_178" DataMember="E2.8Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_161" DataMember="E2.9Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_167" DataMember="E2.9Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_173" DataMember="E2.9Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_179" DataMember="E2.9Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_162" DataMember="E2.10Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_168" DataMember="E2.10Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_174" DataMember="E2.10Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_180" DataMember="E2.10Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_163" DataMember="E2.11Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_169" DataMember="E2.11Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_175" DataMember="E2.11Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_181" DataMember="E2.11Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_164" DataMember="E2.12Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_170" DataMember="E2.12Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_176" DataMember="E2.12Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_182" DataMember="E2.12Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_183" DataMember="E2.13Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_189" DataMember="E2.13Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_195" DataMember="E2.13Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_201" DataMember="E2.13Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_184" DataMember="E2.14Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_190" DataMember="E2.14Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_196" DataMember="E2.14Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_202" DataMember="E2.14Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_185" DataMember="E2.15Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_191" DataMember="E2.15Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_197" DataMember="E2.15Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_203" DataMember="E2.15Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_186" DataMember="E2.16Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_192" DataMember="E2.16Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_198" DataMember="E2.16Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_204" DataMember="E2.16Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_187" DataMember="E2.17Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_193" DataMember="E2.17Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_199" DataMember="E2.17Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_205" DataMember="E2.17Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_188" DataMember="E2.18Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_194" DataMember="E2.18Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_200" DataMember="E2.18Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_206" DataMember="E2.18Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_207" DataMember="E2.19Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_213" DataMember="E2.19Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_219" DataMember="E2.19Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_225" DataMember="E2.19Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_208" DataMember="E2.20Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_214" DataMember="E2.20Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_220" DataMember="E2.20Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_226" DataMember="E2.20Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_209" DataMember="E2.21Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_215" DataMember="E2.21Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_221" DataMember="E2.21Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_227" DataMember="E2.21Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_210" DataMember="E2.22Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_216" DataMember="E2.22Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_222" DataMember="E2.22Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_228" DataMember="E2.22Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_211" DataMember="E2.23Dochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_217" DataMember="E2.23Podatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_223" DataMember="E2.23Wynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_229" DataMember="E2.23Kwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_212" DataMember="E2.RazemDochod"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_218" DataMember="E2.RazemPodatek"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_224" DataMember="E2.RazemWynagrodzenie"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_230" DataMember="E2.RazemKwota"></ea:XmlDataLabel>
		
		<ea:XmlDataLabel runat="server" ElementName="P_231" DataMember="F.MiesiecyWRokPodatkowy" XSDType="TCalkowity"></ea:XmlDataLabel>
		<ea:XmlDataLabel runat="server" ElementName="P_232" DataMember="F.Podatnikow" XSDType="TCalkowity"></ea:XmlDataLabel>
	</PozycjeSzczegolowe>

	<Pouczenie1>W przypadku niewpłacenia w obowiązującym terminie kwoty z poz. 55-60, 79-84, 103-108, 127-131, 153-158, 177-182, 201-206 i 225-229 lub wpłacenia ich w niepełnej wysokości niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2012 r. poz. 1015, z późn. zm.).</Pouczenie1>
	<Pouczenie2>Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie na uszczuplenie podatku grozi odpowiedzialnośc przewidziana w Kodeksie karnym skarbowym.</Pouczenie2>

	<ea:Section ID="ORD_ZU" runat="server">
		<Zalaczniki>
			<Zalacznik_ORD-ZU xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2011/10/07/eD/ORDZU/" >
			<Naglowek>
				<KodFormularza kodSystemowy="ORD-ZU (2)" wersjaSchemy="2-0E">ORD-ZU</KodFormularza>
				<WariantFormularza>2</WariantFormularza>
			</Naglowek>
			<PozycjeSzczegolowe>
				<ea:XmlDataLabel ElementName="zzu:P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
			</PozycjeSzczegolowe>
		</Zalacznik_ORD-ZU>
		</Zalaczniki>
	</ea:Section>
</Deklaracja>
