﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="Soneta.Deklaracje.CIT" %>
<%@ Import Namespace="System.Collections.Generic" %>

<script runat="server">

	private void OnContextLoad(Object sender, EventArgs args)
	{
		var dek = (CITST_7)dc[typeof(CITST_7)];

		string kodKraju = ((string)dek.Bloki["X"]["KodKrajuPl"]).ToUpper();
		if (kodKraju == "" || kodKraju == "PL")
			AdresZagr.Visible = false;
		else
			AdresPol.Visible = false;

		var oddziały = new List<CITST_7_Multi>();
		var sta = new List<CITSTA_5>();

		foreach (Deklaracja pit in dek.Deklaracje)
			if (pit is CITST_7_Multi)
				oddziały.Add((CITST_7_Multi)pit);
			else if (pit is CITSTA_5)
				sta.Add((CITSTA_5)pit);

		CITSTM_REP.DataSource = oddziały;
		CITSTA_REP.DataSource = sta;

		ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
	}


	protected void CITSTA_BeforeRow(object sender, EventArgs e)
	{
		var dek = (CITSTA_5)CITSTA_REP.CurrentRow;
		CITSTAM_REP.DataSource = dek.Deklaracje;
	}


	protected void CITSTM_BeforeRow(object sender, EventArgs e)
	{
	}

	protected void CITSTAM_BeforeRow(object sender, EventArgs e)
	{
	}

</script>


<ea:DataContext ID="dc" runat="server" TypeName="Soneta.Deklaracje.CIT.CITST_7,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:DataContext>
<?xml version="1.0" encoding="UTF-8" ?>
<Deklaracja 
	xmlns="http://crd.gov.pl/wzor/2020/02/07/9118/" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://crd.gov.pl/wzor/2020/02/07/9118/ http://crd.gov.pl/wzor/2020/02/07/9118/schemat.xsd"
	xmlns:cstam="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2019/01/24/eD/CITSTAM/"
    xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/DefinicjeTypy/"
    xmlns:kgm="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2020/01/09/eD/KodyGMIN/"
    xmlns:tns="http://crd.gov.pl/wzor/2020/02/07/9118/"
    xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/ORDZU/">
	<Naglowek>
		<KodFormularza kodSystemowy="CIT-ST (7)" kodPodatku="CIT" rodzajZobowiazania="Z" wersjaSchemy="7-0E" >CIT-ST</KodFormularza>
		<WariantFormularza>7</WariantFormularza>		
		<CelZlozenia poz="P_8"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="B.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<OkresOd poz="P_4"><ea:XmlDataLabel runat="server" DataMember="0.Od" XSDType="TData"/></OkresOd>
		<OkresDo poz="P_5"><ea:XmlDataLabel runat="server" DataMember="0.Do" XSDType="TData"/></OkresDo>
		<ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
	</Naglowek>
	<Podmiot1 rola="Podatnik">
		<etd:OsobaNiefizyczna>
			<ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
			<ea:XmlDataLabel ElementName="etd:PelnaNazwa" runat="server" DataMember="C1.Nazwa" XSDType="TZnakowy" />
			<ea:XmlDataLabel ElementName="etd:REGON" runat="server" DataMember="C1.Regon" XSDType="TNrREGON" HideEmptyOrZero="true"/>
		</etd:OsobaNiefizyczna>
		<etd:AdresSiedziby rodzajAdresu="RAD">
			<ea:Section ID="AdresPol" runat="server">
				<etd:AdresPol>
					<etd:KodKraju>PL</etd:KodKraju>
					<ea:XmlDataLabel ElementName="etd:Wojewodztwo" ID="pit_wojew" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin"/>
					<ea:XmlDataLabel ElementName="etd:Powiat" ID="pit_powiat" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin"/>
					<ea:XmlDataLabel ElementName="etd:Gmina" ID="pit_gmina" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin"/>
					<ea:XmlDataLabel ElementName="etd:Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
					<ea:XmlDataLabel ElementName="etd:NrDomu" ID="pit_nrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/>
					<ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
					<ea:XmlDataLabel ElementName="etd:Miejscowosc" ID="pit_miejsc" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
					<ea:XmlDataLabel ElementName="etd:KodPocztowy" ID="pit_kodPoczt" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/>
					<ea:XmlDataLabel ElementName="etd:Poczta" ID="pit_poczta" runat="server" DataMember="C2.Poczta" XSDType="TMiejscowosc"/>
				</etd:AdresPol>
			</ea:Section>
			<ea:Section ID="AdresZagr" runat="server">
				<etd:AdresZagr>
					<ea:XmlDataLabel ElementName="etd:KodKraju" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/>
					<ea:XmlDataLabel ElementName="etd:KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
					<ea:XmlDataLabel ElementName="etd:Miejscowosc" ID="pit_miejscZagr" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
					<ea:XmlDataLabel ElementName="etd:Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
					<ea:XmlDataLabel ElementName="etd:NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
					<ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
				</etd:AdresZagr>
			</ea:Section>
		</etd:AdresSiedziby>
	</Podmiot1>
	<PozycjeSzczegolowe>
		<P_9>1</P_9>		
		<ea:XmlDataLabel ElementName="P_22" runat="server" DataMember="D.LiczbaZatrudnionych" XSDType="TCalkowity" />	
		<ea:DataRepeater ID="CITSTM_REP" runat="server" WithSections="False" OnBeforeRow="CITSTM_BeforeRow">
			<P_E typ="G">	
				<ea:XmlDataLabel ElementName="P_A" runat="server" DataMember="E.Wojew" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="P_B" runat="server" DataMember="E.Powiat" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="P_C" runat="server" DataMember="E.Gmina" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="P_D" runat="server" DataMember="E.KodGminy" XSDType="TTekstowy"/>
				<ea:XmlDataLabel ElementName="P_E1" runat="server" DataMember="E.NazwaOddziału" XSDType="TTekstowy"/>
				<ea:XmlDataLabel ElementName="P_F1" runat="server" DataMember="E.Regon" XSDType="TNrREGON" HideEmptyOrZero="true"/>
				<ea:XmlDataLabel ElementName="P_F2" runat="server" DataMember="E.NIP" XSDType="TNrNIP" HideEmptyOrZero="true"/>
				<ea:XmlDataLabel ElementName="P_G" runat="server" DataMember="E.LiczbaZatrudnionych" XSDType="TCalkowity"/>
			</P_E>
		</ea:DataRepeater>
		<ea:XmlDataLabel ElementName="P_169" runat="server" DataMember="F.Data" XSDType="TData" />	
	</PozycjeSzczegolowe>
	<Oswiadczenie>1</Oswiadczenie>
	<Zalaczniki>
		<ea:DataRepeater ID="CITSTA_REP" runat="server" WithSections="False" OnBeforeRow="CITSTA_BeforeRow">
			<Zalacznik_CIT-ST_A xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2019/01/24/eD/CITSTAM/">
				<Naglowek>
					<KodFormularza kodSystemowy="CITSTA (5)" wersjaSchemy="4-0E">CIT-ST/A</KodFormularza>
					<WariantFormularza>5</WariantFormularza>
				</Naglowek>
				<PozycjeSzczegolowe>
					<ea:DataRepeater ID="CITSTAM_REP" runat="server" WithSections="False" OnBeforeRow="CITSTAM_BeforeRow">
						<P_B1 typ="G">
							<ea:XmlDataLabel ElementName="P_1" runat="server" DataMember="B1.Nazwa" XSDType="TTekstowy"/>
							<ea:XmlDataLabel ElementName="P_2" runat="server" DataMember="B1.NazwaSkrócona" XSDType="TTekstowy" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_3" runat="server" DataMember="B1.Regon" XSDType="TNrREGON" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_4" runat="server" DataMember="B1.NIP" XSDType="TNrNIP" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_5" runat="server" DataMember="B1.DataRozpoczęciaDziałalności" XSDType="TData" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_6A" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"><ValuesMap><ea:ValuesPair Key="" Value="PL" /></ValuesMap></ea:XmlDataLabel>
							<ea:XmlDataLabel ElementName="P_7" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_8" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_9" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_10" runat="server" DataMember="B2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_11" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_12" runat="server" DataMember="B2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_13" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
							<ea:XmlDataLabel ElementName="P_14" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
							<ea:XmlDataLabel ElementName="P_15" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc" HideEmptyOrZero="true"/>
						</P_B1>
					</ea:DataRepeater>
				</PozycjeSzczegolowe>
			</Zalacznik_CIT-ST_A>
		</ea:DataRepeater>
		<ea:Section ID="ORD_ZU" runat="server">
			<Zalacznik_ORD-ZU xmlns="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2018/08/24/eD/ORDZU/">
				<Naglowek>
					<KodFormularza kodSystemowy="ORD-ZU (3)" wersjaSchemy="2-0E">ORD-ZU</KodFormularza>
					<WariantFormularza>3</WariantFormularza>
				</Naglowek>
				<PozycjeSzczegolowe>
					<ea:XmlDataLabel ElementName="P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
				</PozycjeSzczegolowe>
			</Zalacznik_ORD-ZU>
		</ea:Section>
	</Zalaczniki>

</Deklaracja>
