﻿
<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.CIT" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>

<script runat="server">

	bool _roczna;

	private void OnContextLoad(Object sender, EventArgs args)
	{
		var dek = (IFT2) dc[typeof (IFT2)];
		_roczna = dek.Roczna;
		ORD_ZU.Visible = dek.TreśćUzasadnienia != "";


		bool osobaFizyczna = (bool) dek.Bloki["B1"]["OsobaFiz"];
		string[] nazwa = PIT.DaneFirmy((string) dek.Bloki["B1"]["Nazwa"], osobaFizyczna);

		if (osobaFizyczna)
		{
			OsobaNieFizyczna.Visible = false;
			if (nazwa.Length > 0)
				Nazwisko.EditValue = nazwa[0].Trim();
			if (nazwa.Length > 1)
				ImiePierwsze.EditValue = nazwa[1].Trim();
			if (nazwa.Length > 2)
				DataUrodzenia.EditValue = nazwa[2].Trim();
		}
		else
		{
			OsobaFizyczna.Visible = false;
			if (nazwa.Length > 0)
				NazwaPelna.EditValue = nazwa[0].Trim();
		}

		var kraj = ((string) dek.Bloki["B2"]["Kraj"]).ToUpper();
		if (kraj == "" || kraj == "POLSKA")
			AdresZagrPl.Visible = false;
		else
			AdresPolPl.Visible = false;

		var blokC1 = dek.Bloki["C1"];
		if ((bool) blokC1["IdentyfikacjaPodatkowa"])
		{
			RodzajIdentyfikacji.EditValue = 1;
		}
		else if ((bool) blokC1["IdentyfikacjaInna"])
		{
			RodzajIdentyfikacji.EditValue = 2;
		}

		var blokC2 = dek.Bloki["C2"];
		var kodKraju2 = GetKodKraju(dek.Session, (string) blokC2["Kraj"]);

		Podmiot2KodKraju.EditValue = kodKraju2;

		if (kodKraju2 == "" || kodKraju2 == "PL")
			PokazujNIP.Visible = true;
		else
			PokazujNIP.Visible = false;

		if (_roczna)
		{
			BlokiEF.Visible = true;
			DataZlozenia.Visible = false;
		}
		else
		{
			BlokiEF.Visible = false;
			DataZlozenia.Visible = true;
		}



		decimal d32 = ((decimal) dek.GetWartoscPola("D", "1Zwolniony"));
		decimal d33 = ((decimal) dek.GetWartoscPola("D", "1Kwota"));
		decimal d34 = ((decimal) dek.GetWartoscPola("D", "1Stawka"));
		decimal d35 = ((decimal) dek.GetWartoscPola("D", "1Podatek"));
				  
		decimal d36 = ((decimal) dek.GetWartoscPola("D", "2Zwolniony"));
		decimal d37 = ((decimal) dek.GetWartoscPola("D", "2Kwota"));
		decimal d38 = ((decimal) dek.GetWartoscPola("D", "2Stawka"));
		decimal d39 = ((decimal) dek.GetWartoscPola("D", "2Podatek"));
				  
		decimal d40 = ((decimal) dek.GetWartoscPola("D", "3Zwolniony"));
		decimal d41 = ((decimal) dek.GetWartoscPola("D", "3Kwota"));
		decimal d42 = ((decimal) dek.GetWartoscPola("D", "3Stawka"));
		decimal d43 = ((decimal) dek.GetWartoscPola("D", "3Podatek"));
				  
		decimal d44 = ((decimal) dek.GetWartoscPola("D", "4Zwolniony"));
		decimal d45 = ((decimal) dek.GetWartoscPola("D", "4Kwota"));
		decimal d46 = ((decimal) dek.GetWartoscPola("D", "4Stawka"));
		decimal d47 = ((decimal) dek.GetWartoscPola("D", "4Podatek"));
				  
		decimal d48 = ((decimal) dek.GetWartoscPola("D", "5Zwolniony"));
		decimal d49 = ((decimal) dek.GetWartoscPola("D", "5Kwota"));
		decimal d50 = ((decimal) dek.GetWartoscPola("D", "5Stawka"));
		decimal d51 = ((decimal) dek.GetWartoscPola("D", "5Podatek"));
				  
		decimal d52 = ((decimal) dek.GetWartoscPola("D", "6Zwolniony"));
		decimal d53 = ((decimal) dek.GetWartoscPola("D", "6Kwota"));
		decimal d54 = ((decimal) dek.GetWartoscPola("D", "6Stawka"));
		decimal d55 = ((decimal) dek.GetWartoscPola("D", "6Podatek"));
				  
		decimal d56 = ((decimal) dek.GetWartoscPola("D", "7Zwolniony"));
		decimal d57 = ((decimal) dek.GetWartoscPola("D", "7Kwota"));
		decimal d58 = ((decimal) dek.GetWartoscPola("D", "7Stawka"));
		decimal d59 = ((decimal) dek.GetWartoscPola("D", "7Podatek"));

		decimal d60 = ((decimal) dek.GetWartoscPola("D", "8Zwolniony"));
		decimal d61 = ((decimal) dek.GetWartoscPola("D", "8Kwota"));
		decimal d62 = ((decimal) dek.GetWartoscPola("D", "8Stawka"));
		decimal d63 = ((decimal) dek.GetWartoscPola("D", "8Podatek"));

		decimal d64 = ((decimal) dek.GetWartoscPola("D", "9Zwolniony"));
		decimal d65 = ((decimal) dek.GetWartoscPola("D", "9Kwota"));
		decimal d66 = ((decimal) dek.GetWartoscPola("D", "9Stawka"));
		decimal d67 = ((decimal) dek.GetWartoscPola("D", "9Podatek"));

		//  Ukrywanie pozycji edeklaracji
		if (d32 > 0 || d33 > 0 || d34 > 0 || d35 > 0)
			Widocznosc32_35.Visible = true;
		else Widocznosc32_35.Visible = false;

		if (d36 > 0 || d37 > 0 || d38 > 0 || d39 > 0)
			Widocznosc36_39.Visible = true;
		else Widocznosc36_39.Visible = false;

		if (d40 > 0 || d41 > 0 || d42 > 0 || d43 > 0)
			Widocznosc40_43.Visible = true;
		else Widocznosc40_43.Visible = false;

		if (d44 > 0 || d45 > 0 || d46 > 0 || d47 > 0)
			Widocznosc44_47.Visible = true;
		else Widocznosc44_47.Visible = false;

		if (d48 > 0 || d49 > 0 || d50 > 0 || d51 > 0)
			Widocznosc48_51.Visible = true;
		else Widocznosc48_51.Visible = false;

		if (d52 > 0 || d53 > 0 || d54 > 0 || d55 > 0)
			Widocznosc52_55.Visible = true;
		else Widocznosc52_55.Visible = false;

		if (d56 > 0 || d57 > 0 || d58 > 0 || d59 > 0)
			Widocznosc56_59.Visible = true;
		else Widocznosc56_59.Visible = false;

		if (d60 > 0 || d61 > 0 || d62 > 0 || d63 > 0)
			Widocznosc60_63.Visible = true;
		else Widocznosc60_63.Visible = false;

        if (d64 > 0 || d65 > 0 || d66 > 0 || d67 > 0)
			Widocznosc64_67.Visible = true;
		else Widocznosc64_67.Visible = false;
	}

	private static string GetKodKraju(Session session, string nazwaKraju)
	{
		var krajTbl = session.Get<CoreModule>().KrajeTbl.WgNazwa[nazwaKraju];
		return krajTbl != null ? krajTbl.Kod2 : "";
	}




</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.CIT.IFT2,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<%if (_roczna) { %>
<Deklaracja
	xmlns="http://crd.gov.pl/wzor/2022/03/28/11449/"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://crd.gov.pl/wzor/2022/03/28/11449/ http://crd.gov.pl/wzor/2022/03/28/11449/schemat.xsd"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/01/05/eD/DefinicjeTypy/"
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/03/14/eD/ORDZU/"
	xmlns:kus="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/01/05/eD/KodyUrzedowSkarbowych/" >
<%} else {%>
<Deklaracja
	xmlns="http://crd.gov.pl/wzor/2022/03/28/11448/"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://crd.gov.pl/wzor/2022/03/28/11448/ http://crd.gov.pl/wzor/2022/03/28/11448/schemat.xsd"
	xmlns:etd="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/01/05/eD/DefinicjeTypy/"
	xmlns:zzu="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/03/14/eD/ORDZU/" 
	xmlns:kus="http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2022/01/05/eD/KodyUrzedowSkarbowych/" >
<%}%>
	<Naglowek>
<%if (_roczna) { %>
		<KodFormularza kodSystemowy="IFT-2R (10)" kodPodatku="CIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">IFT-2/IFT-2R</KodFormularza>
<%} else {%>
		<KodFormularza kodSystemowy="IFT-2 (10)" kodPodatku="CIT" rodzajZobowiazania="Z" wersjaSchemy="1-0E">IFT-2/IFT-2R</KodFormularza>
<%}%>
		<WariantFormularza>10</WariantFormularza>
		<CelZlozenia poz="P_7"><ea:XmlDataLabel runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
		<OkresOd poz="P_4"><ea:XmlDataLabel runat="server" DataMember="0.Od" XSDType="TData" ></ea:XmlDataLabel></OkresOd>
		<OkresDo poz="P_5"><ea:XmlDataLabel runat="server" DataMember="0.Do" XSDType="TData" ></ea:XmlDataLabel></OkresDo>
		<ea:XmlDataLabel ElementName="KodUrzedu" runat="server" DataMember="X.KodUrzeduSkarbowego" />
	</Naglowek>
	<Podmiot1 rola="Płatnik/Podmiot (Wypłacający Należność)">
		<ea:Section ID="OsobaFizyczna" runat="server"><OsobaFizyczna>
			<ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
			<ea:XmlDataLabel ElementName="etd:ImiePierwsze" ID="ImiePierwsze" runat="server" XSDType="TImie" />
			<ea:XmlDataLabel ElementName="etd:Nazwisko" ID="Nazwisko" runat="server" XSDType="TNazwisko" />
			<ea:XmlDataLabel ElementName="etd:DataUrodzenia" ID="DataUrodzenia" runat="server" XSDType="TData" />
		</OsobaFizyczna></ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server"><OsobaNiefizyczna>
			<ea:XmlDataLabel ElementName="NIP" runat="server" DataMember="0.Nip" XSDType="TNrNIP"/>
			<ea:XmlDataLabel ElementName="PelnaNazwa" ID="NazwaPelna" runat="server" XSDType="TZnakowy" />
		</OsobaNiefizyczna></ea:Section>
		<AdresZamieszkaniaSiedziby rodzajAdresu="RAD">
			<ea:Section ID="AdresPolPl" runat="server">
			<etd:AdresPol>
				<etd:KodKraju>PL</etd:KodKraju>
				<ea:XmlDataLabel ElementName="etd:Wojewodztwo" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin" />
				<ea:XmlDataLabel ElementName="etd:Powiat" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="etd:Gmina" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"/>
				<ea:XmlDataLabel ElementName="etd:Ulica" runat="server" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"/>
				<ea:XmlDataLabel ElementName="etd:NrDomu" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"/>
				<ea:XmlDataLabel ElementName="etd:NrLokalu" runat="server" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"/>
				<ea:XmlDataLabel ElementName="etd:Miejscowosc" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
				<ea:XmlDataLabel ElementName="etd:KodPocztowy" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"/>
			</etd:AdresPol>
			</ea:Section>
			<ea:Section ID="AdresZagrPl" runat="server">
			<AdresZagr>
				<ea:XmlDataLabel ElementName="KodKraju" runat="server" DataMember="B2.KodKrajuPl" XSDType="TTekstowy"/>
				<ea:XmlDataLabel ElementName="KodPocztowy" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
				<ea:XmlDataLabel ElementName="Miejscowosc" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"/>
				<ea:XmlDataLabel ElementName="Ulica" runat="server" DataMember="B2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
				<ea:XmlDataLabel ElementName="NrDomu" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
				<ea:XmlDataLabel ElementName="NrLokalu" runat="server" DataMember="B2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
			</AdresZagr>
			</ea:Section>
		</AdresZamieszkaniaSiedziby>
	</Podmiot1>
	<Podmiot2 rola="Podatnik (Odbiorca Należności)">
		<OsobaNieFizZagr>
			<ea:XmlDataLabel ElementName="etd:PelnaNazwa" runat="server" DataMember="C1.NazwaPelna" XSDType="TZnakowy"/>
			<ea:XmlDataLabel ElementName="etd:SkroconaNazwa" runat="server" DataMember="C1.NazwaSkrocona" XSDType="TZnakowy"/>
				 <ea:Section ID="PokazujNIP" runat="server">
			<ea:XmlDataLabel ElementName="etd:NIP" runat="server" DataMember="C1.Nip" XSDType="TNrNIP" HideEmptyOrZero="false"/>
						  </ea:Section>
			<ea:XmlDataLabel ElementName="DataRozpoczeciaDzialalnosci" PozAttribute="P_22" runat="server" DataMember="C1.RozpoczecieDzialalnosci" XSDType="TData" HideEmptyOrZero="True"/>

			<ea:XmlDataLabel ID="RodzajIdentyfikacji" ElementName="RodzajIdentyfikacji" PozAttribute="P_23" runat="server" XSDType="TCalkowity"/>
			<ea:XmlDataLabel ElementName="NumerIdentyfikacyjnyPodatnika" PozAttribute="P_24" runat="server" DataMember="C1.NrIdentyfikacyjny" XSDType="TZnakowy"/>
			<ea:XmlDataLabel ElementName="KodKrajuWydania" PozAttribute="P_25" runat="server" DataMember="C1.KodKraju" XSDType="TZnakowy"/>
		</OsobaNieFizZagr>
		<AdresSiedziby rodzajAdresu="RAD">
			<ea:XmlDataLabel ElementName="KodKraju" ID="Podmiot2KodKraju" runat="server" XSDType="TTekstowy"/>
			<ea:XmlDataLabel ElementName="KodPocztowy" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="Miejscowosc" ID="pit_miejscZagr" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/>
			<ea:XmlDataLabel ElementName="Ulica" runat="server" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="NrDomu" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku" HideEmptyOrZero="true"/>
			<ea:XmlDataLabel ElementName="NrLokalu" runat="server" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
		</AdresSiedziby>
	</Podmiot2>
	<PozycjeSzczegolowe>
		<ea:Section ID="Widocznosc32_35" runat="server">
		<ea:XmlDataLabel ElementName="P_32" runat="server" DataMember="D.1Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_33" runat="server" DataMember="D.1Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_34" runat="server" DataMember="D.1Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_35" runat="server" DataMember="D.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		</ea:Section>

		<ea:Section ID="Widocznosc36_39" runat="server">
		<ea:XmlDataLabel ElementName="P_36" runat="server" DataMember="D.2Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_37" runat="server" DataMember="D.2Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_38" runat="server" DataMember="D.2Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_39" runat="server" DataMember="D.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		</ea:Section>

        <ea:Section ID="Widocznosc40_43" runat="server">
		<ea:XmlDataLabel ElementName="P_40" runat="server" DataMember="D.3Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_41" runat="server" DataMember="D.3Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_42" runat="server" DataMember="D.3Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_43" runat="server" DataMember="D.3Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		</ea:Section>

	    <ea:Section ID="Widocznosc44_47" runat="server">
		<ea:XmlDataLabel ElementName="P_44" runat="server" DataMember="D.4Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_45" runat="server" DataMember="D.4Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_46" runat="server" DataMember="D.4Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_47" runat="server" DataMember="D.4Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		</ea:Section>

        <ea:Section ID="Widocznosc48_51" runat="server">
		<ea:XmlDataLabel ElementName="P_48" runat="server" DataMember="D.5Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_49" runat="server" DataMember="D.5Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_50" runat="server" DataMember="D.5Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_51" runat="server" DataMember="D.5Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		</ea:Section>

		<ea:Section ID="Widocznosc52_55" runat="server">
		<ea:XmlDataLabel ElementName="P_52" runat="server" DataMember="D.6Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_53" runat="server" DataMember="D.6Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_54" runat="server" DataMember="D.6Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_55" runat="server" DataMember="D.6Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		</ea:Section>

        <ea:Section ID="Widocznosc56_59" runat="server">
		<ea:XmlDataLabel ElementName="P_56" runat="server" DataMember="D.7Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_57" runat="server" DataMember="D.7Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_58" runat="server" DataMember="D.7Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_59" runat="server" DataMember="D.7Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		</ea:Section>

	    <ea:Section ID="Widocznosc60_63" runat="server">
		<ea:XmlDataLabel ElementName="P_60" runat="server" DataMember="D.8Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_61" runat="server" DataMember="D.8Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_62" runat="server" DataMember="D.8Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
		<ea:XmlDataLabel ElementName="P_63" runat="server" DataMember="D.8Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
		</ea:Section>

        <ea:Section ID="Widocznosc64_67" runat="server">
        <ea:XmlDataLabel ElementName="P_64" runat="server" DataMember="D.9Zwolniony" XSDType="TKwotaC" HideEmptyOrZero="false"/>
        <ea:XmlDataLabel ElementName="P_65" runat="server" DataMember="D.9Kwota" XSDType="TKwotaC" HideEmptyOrZero="false"/>
        <ea:XmlDataLabel ElementName="P_66" runat="server" DataMember="D.9Stawka" XSDType="TProcentowy" HideEmptyOrZero="false"/>
        <ea:XmlDataLabel ElementName="P_67" runat="server" DataMember="D.9Podatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>
        </ea:Section>

		<ea:Section ID="BlokiEF" runat="server">
        <ea:XmlDataLabel ElementName="P_68" runat="server" DataMember="E.1Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_74" runat="server" DataMember="E.1Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_69" runat="server" DataMember="E.2Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_75" runat="server" DataMember="E.2Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_70" runat="server" DataMember="E.3Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_76" runat="server" DataMember="E.3Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_71" runat="server" DataMember="E.4Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_77" runat="server" DataMember="E.4Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_72" runat="server" DataMember="E.5Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_78" runat="server" DataMember="E.5Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_73" runat="server" DataMember="E.6Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_79" runat="server" DataMember="E.6Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_80" runat="server" DataMember="E.7Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_86" runat="server" DataMember="E.7Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_81" runat="server" DataMember="E.8Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_87" runat="server" DataMember="E.8Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_82" runat="server" DataMember="E.9Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_88" runat="server" DataMember="E.9Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_83" runat="server" DataMember="E.10Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_89" runat="server" DataMember="E.10Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_84" runat="server" DataMember="E.11Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_90" runat="server" DataMember="E.11Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_85" runat="server" DataMember="E.12Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_91" runat="server" DataMember="E.12Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_92" runat="server" DataMember="E.13Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_98" runat="server" DataMember="E.13Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_93" runat="server" DataMember="E.14Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_99" runat="server" DataMember="E.14Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_94" runat="server" DataMember="E.15Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_100" runat="server" DataMember="E.15Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_95" runat="server" DataMember="E.16Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_101" runat="server" DataMember="E.16Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_96" runat="server" DataMember="E.17Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_102" runat="server" DataMember="E.17Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_97" runat="server" DataMember="E.18Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_103" runat="server" DataMember="E.18Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_104" runat="server" DataMember="E.19Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_110" runat="server" DataMember="E.19Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_105" runat="server" DataMember="E.20Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_111" runat="server" DataMember="E.20Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_106" runat="server" DataMember="E.21Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_112" runat="server" DataMember="E.21Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_107" runat="server" DataMember="E.22Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_113" runat="server" DataMember="E.22Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_108" runat="server" DataMember="E.23Dochod" XSDType="TKwotaC" HideEmptyOrZero="true"/>
        <ea:XmlDataLabel ElementName="P_114" runat="server" DataMember="E.23Podatek" XSDType="TKwotaC" HideEmptyOrZero="true"/>

        <ea:XmlDataLabel ElementName="P_109" runat="server" DataMember="E.RazemDochod" XSDType="TKwotaC" HideEmptyOrZero="false"/>
        <ea:XmlDataLabel ElementName="P_115" runat="server" DataMember="E.RazemPodatek" XSDType="TKwotaC" HideEmptyOrZero="false"/>

        <ea:XmlDataLabel ElementName="P_116" runat="server" DataMember="F.MiesiecyWRokPodatkowy" XSDType="TCalkowity" />
		</ea:Section>

		<ea:XmlDataLabel ElementName="P_117" ID="DataZlozenia" runat="server" DataMember="G.DataZłożenia" XSDType="TData" />

		<ea:XmlDataLabel ElementName="P_118" runat="server" DataMember="G.DataPrzekazania" XSDType="TData" />
	</PozycjeSzczegolowe>
	<Pouczenie>1</Pouczenie>

	<ea:Section ID="ORD_ZU" runat="server">
	<Zalaczniki>
	<zzu:Zalacznik_ORD-ZU>
		<zzu:Naglowek>
			<zzu:KodFormularza kodSystemowy="ORD-ZU (3)" wersjaSchemy="8-0E">ORD-ZU</zzu:KodFormularza>
			<zzu:WariantFormularza>3</zzu:WariantFormularza>
		</zzu:Naglowek>
		<zzu:PozycjeSzczegolowe>
			<ea:XmlDataLabel ElementName="zzu:P_13" runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/>
		</zzu:PozycjeSzczegolowe>
	</zzu:Zalacznik_ORD-ZU>
	</Zalaczniki>
	</ea:Section>
</Deklaracja>
