﻿<%@ Page Language="C#" AutoEventWireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Deklaracje.PIT" %>
<%@ Import Namespace="System.Collections.Generic" %>
<script runat="server">
    Soneta.Deklaracje.PIT.PIT11_16 dek;

    void OnContextLoad(Object sender, EventArgs args) {
        dek = (PIT11_16)dc[typeof(PIT11_16)];

        bool osobaFizyczna = (bool)dek.Bloki["B1"]["OsobaFiz"];
        string[] nazwa = Soneta.Deklaracje.PIT.PIT.DaneFirmy((string)dek.Bloki["B1"]["Nazwa"], osobaFizyczna);
        
        if (osobaFizyczna) {
            OsobaNieFizyczna.Visible = false;
            if (nazwa.Length > 0)
                Nazwisko.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                ImiePiersze.EditValue = nazwa[1].Trim();
            if (nazwa.Length > 2)
                DataUrodzenia.EditValue = nazwa[2].Trim();
        }
        else {
            OsobaFizyczna.Visible = false;
            if (nazwa.Length > 0)
                NazwaPelna.EditValue = nazwa[0].Trim();
            if (nazwa.Length > 1)
                REGON.EditValue = nazwa[1].Trim();
        }

        string kodKraju = ((string)dek.Bloki["X"]["KodKraju"]).ToUpper();
        if (kodKraju == "" || kodKraju=="PL")
            AdresZagr.Visible = false;
        else
            AdresPol.Visible = false;

        if ((bool)dek.Bloki["D"]["Jeden"])
            P35.EditValue = 1;
        else if ((bool)dek.Bloki["D"]["Wiecej"])
            P35.EditValue = 2;
        else if ((bool)dek.Bloki["D"]["JedenPodw"])
            P35.EditValue = 3;
        else if ((bool)dek.Bloki["D"]["WiecejPodw"])
            P35.EditValue = 4;
        else
            P35.Visible = false;

        P85.EditValue = (bool)dek.Bloki["F"]["PITR"] ? 1 : 2;

        ORD_ZU.Visible = dek.TreśćUzasadnienia != "";
        
        List<PITR_13> pityr = new List<PITR_13>();
        foreach (Deklaracja z in dek.Deklaracje)
            if (z is PITR_13)
                pityr.Add((PITR_13)z);
        PIT_R_13.DataSource = pityr;
    }

    protected void PIT_R_13_BeforeRow(object sender, EventArgs e) {
        PITR_13 pitr = (PITR_13)PIT_R_13.CurrentRow;

        string[] nazwa = ((string)pitr.Bloki["B1"]["Nazwa"]).Split(',');
        if (nazwa.Length > 0)
            PelnaNazwaPITR.EditValue = nazwa[0].Trim();
        if (nazwa.Length > 1)
            REGONPITR.EditValue = nazwa[1].Trim();

        string kodKraju = ((string)pitr.Bloki["X"]["KodKraju"]).ToUpper();
        if (kodKraju == "" || kodKraju == "PL")
            AdresZagrPITR.Visible = false;
        else
            AdresPolPITR.Visible = false;
    }

    static void Msg(object value) {
    }

</script>
<ea:datacontext id="dc" runat="server" TypeName="Soneta.Deklaracje.PIT.PIT11_16,Soneta.Deklaracje" OnContextLoad="OnContextLoad"></ea:datacontext>
<?xml version="1.0" encoding="UTF-8"?>
<Deklaracja xsi:noNamespaceSchemaLocation="http://www.e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/PIT/PIT-11(16)_v1-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<Naglowek>
        <KodFormularza kodSystemowy="PIT-11 (16)" kodPodatku="PIT" rodzajZobowiazania="Z">PIT-11</KodFormularza>
        <WariantFormularza>16</WariantFormularza>		
        <CelZlozenia poz="P_7"><ea:XmlDataLabel ID="DataLabel1" runat="server" DataMember="A.Korekta"><ValuesMap><ea:ValuesPair Key="False" Value="1" /><ea:ValuesPair Key="True" Value="2"/></ValuesMap></ea:XmlDataLabel></CelZlozenia>
        <OkresOd poz="P_4"><ea:XmlDataLabel ID="OkresOd" runat="server" DataMember="0.Od"></ea:XmlDataLabel></OkresOd>
        <OkresDo poz="P_5"><ea:XmlDataLabel ID="OkresDo" runat="server" DataMember="0.Do"></ea:XmlDataLabel></OkresDo>
        <KodUrzedu><ea:XmlDataLabel ID="DataLabel4" runat="server" DataMember="X.KodUrzeduSkarbowego"></ea:XmlDataLabel></KodUrzedu>
	</Naglowek>
	<Podmiot1 rola="Płatnik">
		<ea:Section ID="OsobaFizyczna" runat="server"><OsobaFizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel1" runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<ImiePierwsze><ea:XmlDataLabel ID="ImiePiersze" runat="server" XSDType="TImie"></ea:XmlDataLabel></ImiePierwsze>
			<Nazwisko><ea:XmlDataLabel ID="Nazwisko" runat="server" XSDType="TNazwisko"></ea:XmlDataLabel></Nazwisko>
			<DataUrodzenia><ea:XmlDataLabel ID="DataUrodzenia" runat="server" XSDType="TData"></ea:XmlDataLabel></DataUrodzenia>
		</OsobaFizyczna></ea:Section>
		<ea:Section ID="OsobaNieFizyczna" runat="server"><OsobaNiefizyczna>
			<ea:XmlDataLabel ID="XmlDataLabel2" runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<PelnaNazwa><ea:XmlDataLabel ID="NazwaPelna" runat="server" XSDType="TZnakowy"></ea:XmlDataLabel></PelnaNazwa>
			<REGON><ea:XmlDataLabel ID="REGON" runat="server" XSDType="TNrREGON"></ea:XmlDataLabel></REGON>
		</OsobaNiefizyczna></ea:Section>
		<AdresZamieszkaniaSiedziby rodzajAdresu="RAD">
			<AdresPol>
				<KodKraju>PL</KodKraju>
				<Wojewodztwo><ea:XmlDataLabel ID="XmlDataLabel3" runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin"></ea:XmlDataLabel></Wojewodztwo>
				<Powiat><ea:XmlDataLabel ID="XmlDataLabel4" runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"></ea:XmlDataLabel></Powiat>
				<Gmina><ea:XmlDataLabel ID="XmlDataLabel5" runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"></ea:XmlDataLabel></Gmina>
				<ea:XmlDataLabel ID="XmlDataLabel6" runat="server" ElementName="Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<NrDomu><ea:XmlDataLabel ID="XmlDataLabel7" runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel></NrDomu>
				<ea:XmlDataLabel ID="XmlDataLabel8" runat="server" ElementName="NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
				<Miejscowosc><ea:XmlDataLabel ID="XmlDataLabel9" runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></Miejscowosc>
				<KodPocztowy><ea:XmlDataLabel ID="XmlDataLabel10" runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></KodPocztowy>
				<Poczta><ea:XmlDataLabel ID="XmlDataLabel11" runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc"></ea:XmlDataLabel></Poczta>
			</AdresPol>
		</AdresZamieszkaniaSiedziby>
	</Podmiot1>	
	<Podmiot2 rola="Podatnik">
	    <OsobaFizyczna>
	        <NIP><ea:XmlDataLabel ID="P20" runat="server" DataMember="C1.NIP" XSDType="TNrNIP"/></NIP>
    	    <ImiePierwsze><ea:XmlDataLabel ID="P22" runat="server" DataMember="C1.Imię" XSDType="TImie"/></ImiePierwsze>
	        <Nazwisko><ea:XmlDataLabel ID="P21" runat="server" DataMember="C1.Nazwisko" XSDType="TNazwisko"/></Nazwisko>
	        <DataUrodzenia><ea:XmlDataLabel ID="P23" runat="server" DataMember="C1.DataUrodz" XSDType="TData"/></DataUrodzenia>
	        <PESEL><ea:XmlDataLabel ID="P24" runat="server" DataMember="C1.PESEL" XSDType="TNrPESEL"/></PESEL>
	    </OsobaFizyczna>
        <AdresZamieszkania rodzajAdresu="RAD">
            <ea:Section ID="AdresPol" runat="server"><AdresPol>
                <KodKraju>PL</KodKraju>
                <Wojewodztwo><ea:XmlDataLabel ID="P26" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin"/></Wojewodztwo>
                <Powiat><ea:XmlDataLabel ID="P27" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin"/></Powiat>
                <Gmina><ea:XmlDataLabel ID="P28" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin"/></Gmina>
                <ea:XmlDataLabel ID="P29" runat="server" ElementName="Ulica" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <NrDomu><ea:XmlDataLabel ID="P30" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/></NrDomu>
                <ea:XmlDataLabel ID="P31" runat="server" ElementName="NrLokalu" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
                <Miejscowosc><ea:XmlDataLabel ID="P32" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/></Miejscowosc>
                <KodPocztowy><ea:XmlDataLabel ID="P33" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/></KodPocztowy>
                <Poczta><ea:XmlDataLabel ID="P34" runat="server" DataMember="C2.Poczta" XSDType="TMiejscowosc"/></Poczta>
            </AdresPol></ea:Section><ea:Section ID="AdresZagr" runat="server"><AdresZagr>
                <KodKraju><ea:XmlDataLabel ID="P25z" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/></KodKraju>
                <KodPocztowy><ea:XmlDataLabel ID="P33z" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/></KodPocztowy>
                <Miejscowosc><ea:XmlDataLabel ID="P32z" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/></Miejscowosc>
                <ea:XmlDataLabel ID="P29z" runat="server" ElementName="Ulica" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
                <NrDomu><ea:XmlDataLabel ID="P30z" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/></NrDomu>
                <ea:XmlDataLabel ID="P31z" runat="server" ElementName="NrLokalu" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
            </AdresZagr></ea:Section>
        </AdresZamieszkania>
	</Podmiot2>
	<PozycjeSzczegolowe>
	    <ea:XmlDataLabel ID="P35" runat="server" ElementName="P_35" XSDType="TCalkowity"></ea:XmlDataLabel>
		<P_36><ea:XmlDataLabel ID="P36" runat="server" DataMember="E.1aPrzychód" XSDType="TKwota2"/></P_36>			
		<P_37><ea:XmlDataLabel ID="P37" runat="server" DataMember="E.1aKoszty" XSDType="TKwota2"/></P_37>
		<P_40><ea:XmlDataLabel ID="P40" runat="server" DataMember="E.1bPrzychód" XSDType="TKwota2"/></P_40>		
		<P_41><ea:XmlDataLabel ID="P41" runat="server" DataMember="E.1bKoszty" XSDType="TKwota2"/></P_41>
		<P_38><ea:XmlDataLabel ID="P38" runat="server" DataMember="E.1Dochód" XSDType="TKwota2"/></P_38>
		<P_39><ea:XmlDataLabel ID="P39" runat="server" DataMember="E.1Zaliczka" XSDType="TKwotaC"/></P_39>
		<P_42><ea:XmlDataLabel ID="P42" runat="server" DataMember="E.2Przychód" XSDType="TKwota2"/></P_42>
		<P_43><ea:XmlDataLabel ID="P43" runat="server" DataMember="E.2Dochód" XSDType="TKwota2"/></P_43>
		<P_44><ea:XmlDataLabel ID="P44" runat="server" DataMember="E.2Zaliczka" XSDType="TKwotaC"/></P_44>		
		<P_45><ea:XmlDataLabel ID="P45" runat="server" DataMember="E.3Przychód" XSDType="TKwota2"/></P_45>		
		<P_46><ea:XmlDataLabel ID="P46" runat="server" DataMember="E.3Dochód" XSDType="TKwota2"/></P_46>		
		<P_47><ea:XmlDataLabel ID="P47" runat="server" DataMember="E.3Zaliczka" XSDType="TKwotaC"/></P_47>		
		<P_48><ea:XmlDataLabel ID="P48" runat="server" DataMember="E.4Przychód" XSDType="TKwota2"/></P_48>		
		<P_49><ea:XmlDataLabel ID="P49" runat="server" DataMember="E.4Dochód" XSDType="TKwota2"/></P_49>
		<P_50><ea:XmlDataLabel ID="P50" runat="server" DataMember="E.4Zaliczka" XSDType="TKwotaC"/></P_50>
		<P_51><ea:XmlDataLabel ID="P51" runat="server" DataMember="E.5Przychód" XSDType="TKwota2"/></P_51>
		<P_52><ea:XmlDataLabel ID="P52" runat="server" DataMember="E.5Dochód" XSDType="TKwota2"/></P_52>		
		<P_53><ea:XmlDataLabel ID="P53" runat="server" DataMember="E.5Zaliczka" XSDType="TKwotaC"/></P_53>
		<P_54><ea:XmlDataLabel ID="P54" runat="server" DataMember="E.6Przychód" XSDType="TKwota2"/></P_54>		
		<P_55><ea:XmlDataLabel ID="P55" runat="server" DataMember="E.6Koszty" XSDType="TKwota2"/></P_55>
		<P_56><ea:XmlDataLabel ID="P56" runat="server" DataMember="E.6Dochód" XSDType="TKwota2"/></P_56>		
		<P_57><ea:XmlDataLabel ID="P57" runat="server" DataMember="E.6Zaliczka" XSDType="TKwotaC"/></P_57>		
		<P_58><ea:XmlDataLabel ID="P58" runat="server" DataMember="E.7Przychód" XSDType="TKwota2"/></P_58>		
		<P_59><ea:XmlDataLabel ID="P59" runat="server" DataMember="E.7Koszty" XSDType="TKwota2"/></P_59>		
		<P_60><ea:XmlDataLabel ID="P60" runat="server" DataMember="E.7Dochód" XSDType="TKwota2"/></P_60>		
		<P_61><ea:XmlDataLabel ID="P61" runat="server" DataMember="E.7Zaliczka" XSDType="TKwotaC"/></P_61>
		<P_62><ea:XmlDataLabel ID="P62" runat="server" DataMember="E.8Przychód" XSDType="TKwota2"/></P_62>
		<P_63><ea:XmlDataLabel ID="P63" runat="server" DataMember="E.8Koszty" XSDType="TKwota2"/></P_63>
		<P_64><ea:XmlDataLabel ID="P64" runat="server" DataMember="E.8Dochód" XSDType="TKwota2"/></P_64>		
		<P_65><ea:XmlDataLabel ID="P65" runat="server" DataMember="E.8Zaliczka" XSDType="TKwotaC"/></P_65>
		<P_66><ea:XmlDataLabel ID="P66" runat="server" DataMember="E.9Przychód" XSDType="TKwota2"/></P_66>		
		<P_67><ea:XmlDataLabel ID="P67" runat="server" DataMember="E.9Koszty" XSDType="TKwota2"/></P_67>
		<P_68><ea:XmlDataLabel ID="P68" runat="server" DataMember="E.9Dochód" XSDType="TKwota2"/></P_68>		
		<P_69><ea:XmlDataLabel ID="P69" runat="server" DataMember="E.9Zaliczka" XSDType="TKwotaC"/></P_69>	
		<P_70><ea:XmlDataLabel ID="P70" runat="server" DataMember="E.10Przychód" XSDType="TKwota2"/></P_70>		
		<P_71><ea:XmlDataLabel ID="P71" runat="server" DataMember="E.10Koszty" XSDType="TKwota2"/></P_71>		
		<P_72><ea:XmlDataLabel ID="P72" runat="server" DataMember="E.10Dochód" XSDType="TKwota2"/></P_72>		
		<P_73><ea:XmlDataLabel ID="P73" runat="server" DataMember="E.10Zaliczka" XSDType="TKwotaC"/></P_73>
		<P_74><ea:XmlDataLabel ID="P74" runat="server" DataMember="E.11Przychód" XSDType="TKwota2"/></P_74>
		<P_75><ea:XmlDataLabel ID="P75" runat="server" DataMember="E.11Koszty" XSDType="TKwota2"/></P_75>
		<P_76><ea:XmlDataLabel ID="P76" runat="server" DataMember="E.11Dochód" XSDType="TKwota2"/></P_76>		
		<P_77><ea:XmlDataLabel ID="P77" runat="server" DataMember="E.11Zaliczka" XSDType="TKwotaC"/></P_77>
		<P_78><ea:XmlDataLabel ID="P78" runat="server" DataMember="E.12Przychód" XSDType="TKwota2"/></P_78>		
		<P_79><ea:XmlDataLabel ID="P79" runat="server" DataMember="E.12Dochód" XSDType="TKwota2"/></P_79>
		<P_80><ea:XmlDataLabel ID="P80" runat="server" DataMember="E.12Zaliczka" XSDType="TKwotaC"/></P_80>	
		<P_81><ea:XmlDataLabel ID="P81" runat="server" DataMember="E.Społeczne" XSDType="TKwota2"/></P_81>		
		<P_82><ea:XmlDataLabel ID="P82" runat="server" DataMember="E.ZdrDoOdlicz" XSDType="TKwota2"/></P_82>		
		<P_83><ea:XmlDataLabel ID="P83" runat="server" DataMember="F.ZZagranicy" XSDType="TKwota2"/></P_83>		
		<P_84><ea:XmlDataLabel ID="P84" runat="server" DataMember="F.PomocBezzwrotna" XSDType="TKwota2"/></P_84>		
		<P_85><ea:XmlDataLabel ID="P85" runat="server" DataMember="F.PITR"><ValuesMap><ea:ValuesPair Key="True" Value="1" /><ea:ValuesPair Key="False" Value="2"/></ValuesMap></ea:XmlDataLabel></P_85>
	</PozycjeSzczegolowe>
	<Oswiadczenie>Oświadczam, że są mi znane przepisy Kodeksu karnego skarbowego o odpowiedzialności za uchybienie obowiązkom płatnika.</Oswiadczenie>
	<Zalaczniki><ea:DataRepeater ID="PIT_R_13" runat="server" WithSections="False" OnBeforeRow="PIT_R_13_BeforeRow">
    <Zalacznik_PIT-R xsi:noNamespaceSchemaLocation="http://e-deklaracje.mf.gov.pl/Repozytorium/Definicje/StrukturyDanych_v2-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<Naglowek>
	    <KodFormularza kodSystemowy="PIT-R (13)">PIT-R</KodFormularza>
		<WariantFormularza>13</WariantFormularza>
		<OkresOd poz="P_2"><ea:XmlDataLabel runat="server" DataMember="0.Od"></ea:XmlDataLabel></OkresOd>
		<OkresDo poz="P_3"><ea:XmlDataLabel runat="server" DataMember="0.Do"></ea:XmlDataLabel></OkresDo>
	</Naglowek>
	<Podmiot1 rola="Płatnik">
		<OsobaNiefizyczna>
			<ea:XmlDataLabel runat="server" ElementName="NIP" DataMember="0.Nip" XSDType="TNrNIP"></ea:XmlDataLabel>
			<PelnaNazwa><ea:XmlDataLabel ID="PelnaNazwaPITR" runat="server" XSDType="TZnakowy"></ea:XmlDataLabel></PelnaNazwa>
			<REGON><ea:XmlDataLabel ID="REGONPITR" runat="server" XSDType="TNrREGON"></ea:XmlDataLabel></REGON>
		</OsobaNiefizyczna>
		<AdresSiedziby rodzajAdresu="RAD">
			<AdresPol>
				<KodKraju>PL</KodKraju>
				<Wojewodztwo><ea:XmlDataLabel runat="server" DataMember="B2.Wojew" XSDType="TJednAdmin"></ea:XmlDataLabel></Wojewodztwo>
				<Powiat><ea:XmlDataLabel runat="server" DataMember="B2.Powiat" XSDType="TJednAdmin"></ea:XmlDataLabel></Powiat>
				<Gmina><ea:XmlDataLabel runat="server" DataMember="B2.Gmina" XSDType="TJednAdmin"></ea:XmlDataLabel></Gmina>
				<ea:XmlDataLabel runat="server" ElementName="Ulica" HideEmptyOrZero="true" DataMember="B2.Ulica" XSDType="TUlica"></ea:XmlDataLabel>
				<NrDomu><ea:XmlDataLabel runat="server" DataMember="B2.NrDomu" XSDType="TNrBudynku"></ea:XmlDataLabel></NrDomu>
				<ea:XmlDataLabel runat="server" ElementName="NrLokalu" HideEmptyOrZero="true" DataMember="B2.NrLokalu" XSDType="TNrLokalu"></ea:XmlDataLabel>
				<Miejscowosc><ea:XmlDataLabel runat="server" DataMember="B2.Miejsc" XSDType="TMiejscowosc"></ea:XmlDataLabel></Miejscowosc>
				<KodPocztowy><ea:XmlDataLabel runat="server" DataMember="B2.KodPoczt" XSDType="TKodPocztowy"></ea:XmlDataLabel></KodPocztowy>
				<Poczta><ea:XmlDataLabel runat="server" DataMember="B2.Poczta" XSDType="TMiejscowosc"></ea:XmlDataLabel></Poczta>
			</AdresPol>
		</AdresSiedziby>
	</Podmiot1>	
	<Podmiot2 rola="Podatnik">
	    <OsobaFizyczna>
	        <NIP><ea:XmlDataLabel ID="P17r" runat="server" DataMember="C1.NIP" XSDType="TNrNIP"/></NIP>
    	    <ImiePierwsze><ea:XmlDataLabel ID="P19r" runat="server" DataMember="C1.Imię" XSDType="TImie"/></ImiePierwsze>
	        <Nazwisko><ea:XmlDataLabel ID="P18r" runat="server" DataMember="C1.Nazwisko" XSDType="TNazwisko"/></Nazwisko>
	        <DataUrodzenia><ea:XmlDataLabel ID="P20r" runat="server" DataMember="C1.DataUrodz" XSDType="TData"/></DataUrodzenia>
	        <PESEL><ea:XmlDataLabel ID="P21r" runat="server" DataMember="C1.PESEL" XSDType="TNrPESEL"/></PESEL>
	    </OsobaFizyczna>
	    <AdresZamieszkania rodzajAdresu="RAD">
	        <ea:Section ID="AdresPolPITR" runat="server"><AdresPol>
		        <KodKraju>PL</KodKraju>
		        <Wojewodztwo><ea:XmlDataLabel ID="P23r" runat="server" DataMember="C2.Wojew" XSDType="TJednAdmin"/></Wojewodztwo>
		        <Powiat><ea:XmlDataLabel ID="P24r" runat="server" DataMember="C2.Powiat" XSDType="TJednAdmin"/></Powiat>
		        <Gmina><ea:XmlDataLabel ID="P25r" runat="server" DataMember="C2.Gmina" XSDType="TJednAdmin"/></Gmina>
		        <ea:XmlDataLabel ID="P26r" runat="server" ElementName="Ulica" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
		        <NrDomu><ea:XmlDataLabel ID="P27r" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/></NrDomu>
		        <ea:XmlDataLabel ID="P28r" runat="server" ElementName="NrLokalu" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
		        <Miejscowosc><ea:XmlDataLabel ID="P29r" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/></Miejscowosc>
		        <KodPocztowy><ea:XmlDataLabel ID="P30r" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/></KodPocztowy>
		        <Poczta><ea:XmlDataLabel ID="P31r" runat="server" DataMember="C2.Poczta" XSDType="TMiejscowosc"/></Poczta>
            </AdresPol></ea:Section><ea:Section ID="AdresZagrPITR" runat="server"><AdresZagr>
			    <KodKraju><ea:XmlDataLabel ID="P22zr" runat="server" DataMember="X.KodKraju" XSDType="TTekstowy"/></KodKraju>
			    <KodPocztowy><ea:XmlDataLabel ID="P30zr" runat="server" DataMember="C2.KodPoczt" XSDType="TKodPocztowy"/></KodPocztowy>
			    <Miejscowosc><ea:XmlDataLabel ID="P29zr" runat="server" DataMember="C2.Miejsc" XSDType="TMiejscowosc"/></Miejscowosc>
			    <ea:XmlDataLabel ID="P26zr" runat="server" ElementName="Ulica" DataMember="C2.Ulica" XSDType="TUlica" HideEmptyOrZero="true"/>
			    <NrDomu><ea:XmlDataLabel ID="P27zr" runat="server" DataMember="C2.NrDomu" XSDType="TNrBudynku"/></NrDomu>
			    <ea:XmlDataLabel ID="P28zr" runat="server" ElementName="NrLokalu" DataMember="C2.NrLokalu" XSDType="TNrLokalu" HideEmptyOrZero="true"/>
            </AdresZagr></ea:Section>
	    </AdresZamieszkania>
	</Podmiot2>
	<PozycjeSzczegolowe>
		<P_32><ea:XmlDataLabel ID="P32r" runat="server" DataMember="D.01_b" XSDType="TKwota2"/></P_32>
		<P_33><ea:XmlDataLabel ID="P33r" runat="server" DataMember="D.01_c" XSDType="TKwota2"/></P_33>
		<P_34><ea:XmlDataLabel ID="P34r" runat="server" DataMember="D.01_d" XSDType="TKwota2"/></P_34>
		<P_35><ea:XmlDataLabel ID="P35r" runat="server" DataMember="D.01_e" XSDType="TKwota2"/></P_35>		
		<P_36><ea:XmlDataLabel ID="P36r" runat="server" DataMember="D.02_b" XSDType="TKwota2"/></P_36>
		<P_37><ea:XmlDataLabel ID="P37r" runat="server" DataMember="D.02_c" XSDType="TKwota2"/></P_37>
		<P_38><ea:XmlDataLabel ID="P38r" runat="server" DataMember="D.02_d" XSDType="TKwota2"/></P_38>
		<P_39><ea:XmlDataLabel ID="P39r" runat="server" DataMember="D.02_e" XSDType="TKwota2"/></P_39>		
		<P_40><ea:XmlDataLabel ID="P40r" runat="server" DataMember="D.03_b" XSDType="TKwota2"/></P_40>		
		<P_41><ea:XmlDataLabel ID="P41r" runat="server" DataMember="D.03_c" XSDType="TKwota2"/></P_41>
		<P_42><ea:XmlDataLabel ID="P42r" runat="server" DataMember="D.03_d" XSDType="TKwota2"/></P_42>
		<P_43><ea:XmlDataLabel ID="P43r" runat="server" DataMember="D.03_e" XSDType="TKwota2"/></P_43>		
		<P_44><ea:XmlDataLabel ID="P44r" runat="server" DataMember="D.04_b" XSDType="TKwota2"/></P_44>		
		<P_45><ea:XmlDataLabel ID="P45r" runat="server" DataMember="D.04_c" XSDType="TKwota2"/></P_45>		
		<P_46><ea:XmlDataLabel ID="P46r" runat="server" DataMember="D.04_d" XSDType="TKwota2"/></P_46>		
		<P_47><ea:XmlDataLabel ID="P47r" runat="server" DataMember="D.04_e" XSDType="TKwota2"/></P_47>				
		<P_48><ea:XmlDataLabel ID="P48r" runat="server" DataMember="D.05_b" XSDType="TKwota2"/></P_48>		
		<P_49><ea:XmlDataLabel ID="P49r" runat="server" DataMember="D.05_c" XSDType="TKwota2"/></P_49>
		<P_50><ea:XmlDataLabel ID="P50r" runat="server" DataMember="D.05_d" XSDType="TKwota2"/></P_50>
		<P_51><ea:XmlDataLabel ID="P51r" runat="server" DataMember="D.05_e" XSDType="TKwota2"/></P_51>		
		<P_52><ea:XmlDataLabel ID="P52r" runat="server" DataMember="D.06_b" XSDType="TKwota2"/></P_52>		
		<P_53><ea:XmlDataLabel ID="P53r" runat="server" DataMember="D.06_c" XSDType="TKwota2"/></P_53>
		<P_54><ea:XmlDataLabel ID="P54r" runat="server" DataMember="D.06_d" XSDType="TKwota2"/></P_54>
		<P_55><ea:XmlDataLabel ID="P55r" runat="server" DataMember="D.06_e" XSDType="TKwota2"/></P_55>		
		<P_56><ea:XmlDataLabel ID="P56r" runat="server" DataMember="D.07_b" XSDType="TKwota2"/></P_56>		
		<P_57><ea:XmlDataLabel ID="P57r" runat="server" DataMember="D.07_c" XSDType="TKwota2"/></P_57>		
		<P_58><ea:XmlDataLabel ID="P58r" runat="server" DataMember="D.07_d" XSDType="TKwota2"/></P_58>		
		<P_59><ea:XmlDataLabel ID="P59r" runat="server" DataMember="D.07_e" XSDType="TKwota2"/></P_59>				
		<P_60><ea:XmlDataLabel ID="P60r" runat="server" DataMember="D.08_b" XSDType="TKwota2"/></P_60>		
		<P_61><ea:XmlDataLabel ID="P61r" runat="server" DataMember="D.08_c" XSDType="TKwota2"/></P_61>
		<P_62><ea:XmlDataLabel ID="P62r" runat="server" DataMember="D.08_d" XSDType="TKwota2"/></P_62>
		<P_63><ea:XmlDataLabel ID="P63r" runat="server" DataMember="D.08_e" XSDType="TKwota2"/></P_63>		
		<P_64><ea:XmlDataLabel ID="P64r" runat="server" DataMember="D.09_b" XSDType="TKwota2"/></P_64>		
		<P_65><ea:XmlDataLabel ID="P65r" runat="server" DataMember="D.09_c" XSDType="TKwota2"/></P_65>
		<P_66><ea:XmlDataLabel ID="P66r" runat="server" DataMember="D.09_d" XSDType="TKwota2"/></P_66>		
		<P_67><ea:XmlDataLabel ID="P67r" runat="server" DataMember="D.09_e" XSDType="TKwota2"/></P_67>		
		<P_68><ea:XmlDataLabel ID="P68r" runat="server" DataMember="D.10_b" XSDType="TKwota2"/></P_68>		
		<P_69><ea:XmlDataLabel ID="P69r" runat="server" DataMember="D.10_c" XSDType="TKwota2"/></P_69>		
		<P_70><ea:XmlDataLabel ID="P70r" runat="server" DataMember="D.10_d" XSDType="TKwota2"/></P_70>		
		<P_71><ea:XmlDataLabel ID="P71r" runat="server" DataMember="D.10_e" XSDType="TKwota2"/></P_71>				
		<P_72><ea:XmlDataLabel ID="P72r" runat="server" DataMember="D.11_b" XSDType="TKwota2"/></P_72>		
		<P_73><ea:XmlDataLabel ID="P73r" runat="server" DataMember="D.11_c" XSDType="TKwota2"/></P_73>
		<P_74><ea:XmlDataLabel ID="P74r" runat="server" DataMember="D.11_d" XSDType="TKwota2"/></P_74>
		<P_75><ea:XmlDataLabel ID="P75r" runat="server" DataMember="D.11_e" XSDType="TKwota2"/></P_75>		
		<P_76><ea:XmlDataLabel ID="P76r" runat="server" DataMember="D.12_b" XSDType="TKwota2"/></P_76>		
		<P_77><ea:XmlDataLabel ID="P77r" runat="server" DataMember="D.12_c" XSDType="TKwota2"/></P_77>
		<P_78><ea:XmlDataLabel ID="P78r" runat="server" DataMember="D.12_d" XSDType="TKwota2"/></P_78>		
		<P_79><ea:XmlDataLabel ID="P79r" runat="server" DataMember="D.12_e" XSDType="TKwota2"/></P_79>		
		<P_80><ea:XmlDataLabel ID="P80r" runat="server" DataMember="D.razem_e" XSDType="TKwota2"/></P_80>				
	</PozycjeSzczegolowe>
    </Zalacznik_PIT-R></ea:DataRepeater><ea:Section ID="ORD_ZU" runat="server">
    <Zalacznik_ORD-ZU xsi:noNamespaceSchemaLocation="http://e-deklaracje.mf.gov.pl/Repozytorium/Deklaracje/ZalacznikiOgolne/ORD-ZU(2)_v1-0.xsd" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:usr="urn:the-xml-files:xslt" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	    <Naglowek>
            <KodFormularza kodSystemowy="ORD-ZU (2)">ORD-ZU</KodFormularza>
            <WariantFormularza>2</WariantFormularza>
	    </Naglowek>
	    <PozycjeSzczegolowe>
	        <P_13><ea:XmlDataLabel runat="server" DataMember="TreśćUzasadnienia" XSDType="TTekstowy"/></P_13>
	    </PozycjeSzczegolowe>
	</Zalacznik_ORD-ZU></ea:Section>
	</Zalaczniki>
</Deklaracja>
